"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Cloudsearch = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [cloudsearch](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoncloudsearch.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Cloudsearch extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [cloudsearch](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoncloudsearch.html).
     *
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'cloudsearch';
        this.accessLevelList = {
            Tagging: [
                'AddTags',
                'RemoveTags'
            ],
            Write: [
                'BuildSuggesters',
                'CreateDomain',
                'DefineAnalysisScheme',
                'DefineExpression',
                'DefineIndexField',
                'DefineSuggester',
                'DeleteAnalysisScheme',
                'DeleteDomain',
                'DeleteExpression',
                'DeleteIndexField',
                'DeleteSuggester',
                'IndexDocuments',
                'UpdateAvailabilityOptions',
                'UpdateDomainEndpointOptions',
                'UpdateScalingParameters',
                'document'
            ],
            Read: [
                'DescribeAnalysisSchemes',
                'DescribeAvailabilityOptions',
                'DescribeDomainEndpointOptions',
                'DescribeExpressions',
                'DescribeIndexFields',
                'DescribeScalingParameters',
                'DescribeServiceAccessPolicies',
                'DescribeSuggesters',
                'ListTags',
                'search',
                'suggest'
            ],
            List: [
                'DescribeDomains',
                'ListDomainNames'
            ],
            'Permissions management': [
                'UpdateServiceAccessPolicies'
            ]
        };
    }
    /**
     * Attaches resource tags to an Amazon CloudSearch domain.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/cloudsearch/latest/developerguide/API_AddTags.html
     */
    toAddTags() {
        return this.to('AddTags');
    }
    /**
     * Indexes the search suggestions.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudsearch/latest/developerguide/API_BuildSuggesters.html
     */
    toBuildSuggesters() {
        return this.to('BuildSuggesters');
    }
    /**
     * Creates a new search domain.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudsearch/latest/developerguide/API_CreateDomain.html
     */
    toCreateDomain() {
        return this.to('CreateDomain');
    }
    /**
     * Configures an analysis scheme that can be applied to a text or text-array field to define language-specific text processing options.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudsearch/latest/developerguide/API_DefineAnalysisScheme.html
     */
    toDefineAnalysisScheme() {
        return this.to('DefineAnalysisScheme');
    }
    /**
     * Configures an Expression for the search domain.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudsearch/latest/developerguide/API_DefineExpression.html
     */
    toDefineExpression() {
        return this.to('DefineExpression');
    }
    /**
     * Configures an IndexField for the search domain.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudsearch/latest/developerguide/API_DefineIndexField.html
     */
    toDefineIndexField() {
        return this.to('DefineIndexField');
    }
    /**
     * Configures a suggester for a domain.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudsearch/latest/developerguide/API_DefineSuggester.html
     */
    toDefineSuggester() {
        return this.to('DefineSuggester');
    }
    /**
     * Deletes an analysis scheme.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudsearch/latest/developerguide/API_DeleteAnalysisScheme.html
     */
    toDeleteAnalysisScheme() {
        return this.to('DeleteAnalysisScheme');
    }
    /**
     * Permanently deletes a search domain and all of its data.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudsearch/latest/developerguide/API_DeleteDomain.html
     */
    toDeleteDomain() {
        return this.to('DeleteDomain');
    }
    /**
     * Removes an Expression from the search domain.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudsearch/latest/developerguide/API_DeleteExpression.html
     */
    toDeleteExpression() {
        return this.to('DeleteExpression');
    }
    /**
     * Removes an IndexField from the search domain.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudsearch/latest/developerguide/API_DeleteIndexField.html
     */
    toDeleteIndexField() {
        return this.to('DeleteIndexField');
    }
    /**
     * Deletes a suggester.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudsearch/latest/developerguide/API_DeleteSuggester.html
     */
    toDeleteSuggester() {
        return this.to('DeleteSuggester');
    }
    /**
     * Gets the analysis schemes configured for a domain.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cloudsearch/latest/developerguide/API_DescribeAnalysisSchemes.html
     */
    toDescribeAnalysisSchemes() {
        return this.to('DescribeAnalysisSchemes');
    }
    /**
     * Gets the availability options configured for a domain.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cloudsearch/latest/developerguide/API_DescribeAvailabilityOptions.html
     */
    toDescribeAvailabilityOptions() {
        return this.to('DescribeAvailabilityOptions');
    }
    /**
     * Gets the domain endpoint options configured for a domain.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cloudsearch/latest/developerguide/API_DescribeDomainEndpointOptions.html
     */
    toDescribeDomainEndpointOptions() {
        return this.to('DescribeDomainEndpointOptions');
    }
    /**
     * Gets information about the search domains owned by this account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/cloudsearch/latest/developerguide/API_DescribeDomains.html
     */
    toDescribeDomains() {
        return this.to('DescribeDomains');
    }
    /**
     * Gets the expressions configured for the search domain.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cloudsearch/latest/developerguide/API_DescribeExpressions.html
     */
    toDescribeExpressions() {
        return this.to('DescribeExpressions');
    }
    /**
     * Gets information about the index fields configured for the search domain.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cloudsearch/latest/developerguide/API_DescribeIndexFields.html
     */
    toDescribeIndexFields() {
        return this.to('DescribeIndexFields');
    }
    /**
     * Gets the scaling parameters configured for a domain.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cloudsearch/latest/developerguide/API_DescribeScalingParameters.html
     */
    toDescribeScalingParameters() {
        return this.to('DescribeScalingParameters');
    }
    /**
     * Gets information about the access policies that control access to the domain's document and search endpoints.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cloudsearch/latest/developerguide/API_DescribeServiceAccessPolicies.html
     */
    toDescribeServiceAccessPolicies() {
        return this.to('DescribeServiceAccessPolicies');
    }
    /**
     * Gets the suggesters configured for a domain.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cloudsearch/latest/developerguide/API_DescribeSuggesters.html
     */
    toDescribeSuggesters() {
        return this.to('DescribeSuggesters');
    }
    /**
     * Tells the search domain to start indexing its documents using the latest indexing options.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudsearch/latest/developerguide/API_IndexDocuments.html
     */
    toIndexDocuments() {
        return this.to('IndexDocuments');
    }
    /**
     * Lists all search domains owned by an account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/cloudsearch/latest/developerguide/API_ListDomainNames.html
     */
    toListDomainNames() {
        return this.to('ListDomainNames');
    }
    /**
     * Displays all of the resource tags for an Amazon CloudSearch domain.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cloudsearch/latest/developerguide/API_ListTags.html
     */
    toListTags() {
        return this.to('ListTags');
    }
    /**
     * Removes the specified resource tags from an Amazon ES domain.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/cloudsearch/latest/developerguide/API_RemoveTags.html
     */
    toRemoveTags() {
        return this.to('RemoveTags');
    }
    /**
     * Configures the availability options for a domain.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudsearch/latest/developerguide/API_UpdateAvailabilityOptions.html
     */
    toUpdateAvailabilityOptions() {
        return this.to('UpdateAvailabilityOptions');
    }
    /**
     * Configures the domain endpoint options for a domain.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudsearch/latest/developerguide/API_UpdateDomainEndpointOptions.html
     */
    toUpdateDomainEndpointOptions() {
        return this.to('UpdateDomainEndpointOptions');
    }
    /**
     * Configures scaling parameters for a domain.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudsearch/latest/developerguide/API_UpdateScalingParameters.html
     */
    toUpdateScalingParameters() {
        return this.to('UpdateScalingParameters');
    }
    /**
     * Configures the access rules that control access to the domain's document and search endpoints.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/cloudsearch/latest/developerguide/API_UpdateServiceAccessPolicies.html
     */
    toUpdateServiceAccessPolicies() {
        return this.to('UpdateServiceAccessPolicies');
    }
    /**
     * Allows access to the document service operations.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-access.html#cloudsearch-actions
     */
    toDocument() {
        return this.to('document');
    }
    /**
     * Allows access to the search operations.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-access.html#cloudsearch-actions
     */
    toSearch() {
        return this.to('search');
    }
    /**
     * Allows access to the suggest operations.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-access.html#cloudsearch-actions
     */
    toSuggest() {
        return this.to('suggest');
    }
    /**
     * Adds a resource of type domain to the statement
     *
     * https://docs.aws.amazon.com/cloudsearch/latest/developerguide/creating-domains.html
     *
     * @param domainName - Identifier for the domainName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onDomain(domainName, account, region, partition) {
        return this.on(`arn:${partition || Cloudsearch.defaultPartition}:cloudsearch:${region || '*'}:${account || '*'}:domain/${domainName}`);
    }
}
exports.Cloudsearch = Cloudsearch;
_a = JSII_RTTI_SYMBOL_1;
Cloudsearch[_a] = { fqn: "cdk-iam-floyd.Cloudsearch", version: "0.374.0" };
//# sourceMappingURL=data:application/json;base64,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