import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [codedeploy-commands-secure](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awscodedeploysecurehostcommandsservice.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class CodedeployCommandsSecure extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to get deployment specification
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codedeploy/latest/userguide/vpc-endpoints.html#vpc-codedeploy-agent-configuration
     */
    toGetDeploymentSpecification(): this;
    /**
     * Grants permission to request host agent commands
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codedeploy/latest/userguide/vpc-endpoints.html#vpc-codedeploy-agent-configuration
     */
    toPollHostCommand(): this;
    /**
     * Grants permission to mark host agent commands acknowledged
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codedeploy/latest/userguide/vpc-endpoints.html#vpc-codedeploy-agent-configuration
     */
    toPutHostCommandAcknowledgement(): this;
    /**
     * Grants permission to mark host agent commands completed
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codedeploy/latest/userguide/vpc-endpoints.html#vpc-codedeploy-agent-configuration
     */
    toPutHostCommandComplete(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Statement provider for service [codedeploy-commands-secure](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awscodedeploysecurehostcommandsservice.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
//# sourceMappingURL=codedeploysecurehostcommandsservice.d.ts.map