import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement, Operator } from '../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [deepracer](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsdeepracer.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Deepracer extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to add access for a private leaderboard
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-manage-community-races.html
     */
    toAddLeaderboardAccessPermission(): this;
    /**
     * Grants permission to get current admin multiuser configuration for this account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-admin-set-account-config.html
     */
    toAdminGetAccountConfig(): this;
    /**
     * Grants permission to list all deepracer users with their associated resources created under this account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-admin-list-associated-resources.html
     */
    toAdminListAssociatedResources(): this;
    /**
     * Grants permission to list user data for all users associated with this account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-admin-list-associated-users.html
     */
    toAdminListAssociatedUsers(): this;
    /**
     * Grants permission to manage a user associated with this account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-admin-manage-user.html
     */
    toAdminManageUser(): this;
    /**
     * Grants permission to set configuration options for this account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-admin-set-account-config.html
     */
    toAdminSetAccountConfig(): this;
    /**
     * Grants permission to clone an existing DeepRacer model
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-console-train-evaluate-models.html#deepracer-clone-trained-model
     */
    toCloneReinforcementLearningModel(): this;
    /**
     * Grants permission to create a DeepRacer car in your garage
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-choose-race-type.html
     */
    toCreateCar(): this;
    /**
     * Grants permission to create a leaderboard
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-create-community-race.html
     */
    toCreateLeaderboard(): this;
    /**
     * Grants permission to create an access token for a private leaderboard
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-manage-community-races.html
     */
    toCreateLeaderboardAccessToken(): this;
    /**
     * Grants permission to submit a DeepRacer model to be evaluated for leaderboards
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-submit-model-to-leaderboard.html
     */
    toCreateLeaderboardSubmission(): this;
    /**
     * Grants permission to create ra einforcement learning model for DeepRacer
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-get-started-training-model.html
     */
    toCreateReinforcementLearningModel(): this;
    /**
     * Grants permission to delete a leaderboard
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-manage-community-races.html
     */
    toDeleteLeaderboard(): this;
    /**
     * Grants permission to delete a DeepRacer model
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-get-started-training-model.html
     */
    toDeleteModel(): this;
    /**
     * Grants permission to edit a leaderboard
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-manage-community-races.html
     */
    toEditLeaderboard(): this;
    /**
     * Grants permission to get current multiuser configuration for this account
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-admin-set-account-config.html
     */
    toGetAccountConfig(): this;
    /**
     * Grants permission to retrieve the user's alias for submitting a DeepRacer model to leaderboards
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-submit-model-to-leaderboard.html
     */
    toGetAlias(): this;
    /**
     * Grants permission to download artifacts for an existing DeepRacer model
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-console-train-evaluate-models.html
     */
    toGetAssetUrl(): this;
    /**
     * Grants permission to retrieve a specific DeepRacer car from your garage
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-choose-race-type.html
     */
    toGetCar(): this;
    /**
     * Grants permission to view all the DeepRacer cars in your garage
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-choose-race-type.html
     */
    toGetCars(): this;
    /**
     * Grants permission to retrieve information about an existing DeepRacer model's evaluation jobs
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-get-started-test-in-simulator.html
     */
    toGetEvaluation(): this;
    /**
     * Grants permission to retrieve information about how the latest submitted DeepRacer model for a user performed on a leaderboard
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-submit-model-to-leaderboard.html
     */
    toGetLatestUserSubmission(): this;
    /**
     * Grants permission to retrieve information about leaderboards
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-submit-model-to-leaderboard.html
     */
    toGetLeaderboard(): this;
    /**
     * Grants permission to retrieve information about an existing DeepRacer model
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-get-started-training-model.html
     */
    toGetModel(): this;
    /**
     * Grants permission to retrieve information about private leaderboards
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-join-community-race.html
     */
    toGetPrivateLeaderboard(): this;
    /**
     * Grants permission to retrieve information about the performance of a user's DeepRacer model that got placed on a leaderboard
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-submit-model-to-leaderboard.html
     */
    toGetRankedUserSubmission(): this;
    /**
     * Grants permission to retrieve information about DeepRacer tracks
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-console-train-evaluate-models.html
     */
    toGetTrack(): this;
    /**
     * Grants permission to retrieve information about an existing DeepRacer model's training job
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-get-started-training-model.html
     */
    toGetTrainingJob(): this;
    /**
     * Grants permission to import a reinforcement learning model for DeepRacer
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-troubleshooting-service-migration-errors.html
     */
    toImportModel(): this;
    /**
     * Grants permission to list a DeepRacer model's evaluation jobs
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-get-started-test-in-simulator.html
     */
    toListEvaluations(): this;
    /**
     * Grants permission to list all the DeepRacer model submissions of a user on a leaderboard
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-submit-model-to-leaderboard.html
     */
    toListLeaderboardSubmissions(): this;
    /**
     * Grants permission to list all the available leaderboards
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-submit-model-to-leaderboard.html
     */
    toListLeaderboards(): this;
    /**
     * Grants permission to list all existing DeepRacer models
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-get-started-training-model.html
     */
    toListModels(): this;
    /**
     * Grants permission to retrieve participant information about private leaderboards
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-join-community-race.html
     */
    toListPrivateLeaderboardParticipants(): this;
    /**
     * Grants permission to list all the available private leaderboards
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-join-community-race.html
     */
    toListPrivateLeaderboards(): this;
    /**
     * Grants permission to list all the subscribed private leaderboards
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-join-community-race.html
     */
    toListSubscribedPrivateLeaderboards(): this;
    /**
     * Grants permission to lists tag for a resource
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-tagging.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to list all DeepRacer tracks
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-console-train-evaluate-models.html
     */
    toListTracks(): this;
    /**
     * Grants permission to list a DeepRacer model's training jobs
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-get-started-training-model.html
     */
    toListTrainingJobs(): this;
    /**
     * Grants permission to migrate previous reinforcement learning models for DeepRacer
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-troubleshooting-service-migration-errors.html
     */
    toMigrateModels(): this;
    /**
     * Grants permission to performs the leaderboard operation mentioned in the operation attribute
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-perform-leaderboard-operation.html
     */
    toPerformLeaderboardOperation(): this;
    /**
     * Grants permission to remove access for a private leaderboard
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-manage-community-races.html
     */
    toRemoveLeaderboardAccessPermission(): this;
    /**
     * Grants permission to set the user's alias for submitting a DeepRacer model to leaderboards
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-submit-model-to-leaderboard.html
     */
    toSetAlias(): this;
    /**
     * Grants permission to evaluate a DeepRacer model in a simulated environment
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-get-started-test-in-simulator.html
     */
    toStartEvaluation(): this;
    /**
     * Grants permission to stop DeepRacer model evaluations
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-get-started-test-in-simulator.html
     */
    toStopEvaluation(): this;
    /**
     * Grants permission to stop training a DeepRacer model
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-get-started-training-model.html
     */
    toStopTrainingReinforcementLearningModel(): this;
    /**
     * Grants permission to tag a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-tagging.html
     */
    toTagResource(): this;
    /**
     * Grants permission to test reward functions for correctness
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-console-train-evaluate-models.html#deepracer-train-models-define-reward-function
     */
    toTestRewardFunction(): this;
    /**
     * Grants permission to untag a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-tagging.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update a DeepRacer car in your garage
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-choose-race-type.html
     */
    toUpdateCar(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type car to the statement
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-choose-race-type.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onCar(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type evaluation_job to the statement
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-get-started-test-in-simulator.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onEvaluationJob(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type leaderboard to the statement
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-submit-model-to-leaderboard.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onLeaderboard(resourceId: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type leaderboard_evaluation_job to the statement
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-submit-model-to-leaderboard.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onLeaderboardEvaluationJob(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type reinforcement_learning_model to the statement
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-get-started-training-model.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onReinforcementLearningModel(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type track to the statement
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-console-train-evaluate-models.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onTrack(resourceId: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type training_job to the statement
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-get-started-training-model.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onTrainingJob(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access by multiuser flag
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/reference_policies_iam-condition-keys.html#condition-keys-multiuser
     *
     * Applies to actions:
     * - .toAddLeaderboardAccessPermission()
     * - .toCloneReinforcementLearningModel()
     * - .toCreateCar()
     * - .toCreateLeaderboard()
     * - .toCreateLeaderboardAccessToken()
     * - .toCreateLeaderboardSubmission()
     * - .toCreateReinforcementLearningModel()
     * - .toDeleteLeaderboard()
     * - .toDeleteModel()
     * - .toEditLeaderboard()
     * - .toGetAccountConfig()
     * - .toGetAlias()
     * - .toGetAssetUrl()
     * - .toGetCar()
     * - .toGetCars()
     * - .toGetEvaluation()
     * - .toGetLatestUserSubmission()
     * - .toGetLeaderboard()
     * - .toGetModel()
     * - .toGetPrivateLeaderboard()
     * - .toGetRankedUserSubmission()
     * - .toGetTrainingJob()
     * - .toImportModel()
     * - .toListEvaluations()
     * - .toListLeaderboardSubmissions()
     * - .toListLeaderboards()
     * - .toListModels()
     * - .toListPrivateLeaderboardParticipants()
     * - .toListPrivateLeaderboards()
     * - .toListSubscribedPrivateLeaderboards()
     * - .toListTagsForResource()
     * - .toListTrainingJobs()
     * - .toPerformLeaderboardOperation()
     * - .toRemoveLeaderboardAccessPermission()
     * - .toSetAlias()
     * - .toStartEvaluation()
     * - .toStopEvaluation()
     * - .toStopTrainingReinforcementLearningModel()
     * - .toTagResource()
     * - .toUntagResource()
     * - .toUpdateCar()
     *
     * @param value `true` or `false`. **Default:** `true`
     */
    ifMultiUser(value?: boolean): this;
    /**
     * Filters access by user token in the request
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/reference_policies_iam-condition-keys.html#condition-keys-usertoken
     *
     * Applies to actions:
     * - .toAddLeaderboardAccessPermission()
     * - .toCloneReinforcementLearningModel()
     * - .toCreateCar()
     * - .toCreateLeaderboard()
     * - .toCreateLeaderboardAccessToken()
     * - .toCreateLeaderboardSubmission()
     * - .toCreateReinforcementLearningModel()
     * - .toDeleteLeaderboard()
     * - .toDeleteModel()
     * - .toEditLeaderboard()
     * - .toGetAccountConfig()
     * - .toGetAlias()
     * - .toGetAssetUrl()
     * - .toGetCar()
     * - .toGetCars()
     * - .toGetEvaluation()
     * - .toGetLatestUserSubmission()
     * - .toGetLeaderboard()
     * - .toGetModel()
     * - .toGetPrivateLeaderboard()
     * - .toGetRankedUserSubmission()
     * - .toGetTrainingJob()
     * - .toImportModel()
     * - .toListEvaluations()
     * - .toListLeaderboardSubmissions()
     * - .toListLeaderboards()
     * - .toListModels()
     * - .toListPrivateLeaderboardParticipants()
     * - .toListPrivateLeaderboards()
     * - .toListSubscribedPrivateLeaderboards()
     * - .toListTagsForResource()
     * - .toListTrainingJobs()
     * - .toPerformLeaderboardOperation()
     * - .toRemoveLeaderboardAccessPermission()
     * - .toSetAlias()
     * - .toStartEvaluation()
     * - .toStopEvaluation()
     * - .toStopTrainingReinforcementLearningModel()
     * - .toTagResource()
     * - .toUntagResource()
     * - .toUpdateCar()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifUserToken(value: string | string[], operator?: Operator | string): this;
    /**
     * Statement provider for service [deepracer](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsdeepracer.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
//# sourceMappingURL=deepracer.d.ts.map