import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [elemental-support-content](https://docs.aws.amazon.com/service-authorization/latest/reference/list_elementalsupportcontent.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class ElementalSupportContent extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grant the permission to search support content
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/elemental-appliances-software
     */
    toQuery(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Statement provider for service [elemental-support-content](https://docs.aws.amazon.com/service-authorization/latest/reference/list_elementalsupportcontent.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
//# sourceMappingURL=elementalsupportcontent.d.ts.map