"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ElementalSupportContent = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [elemental-support-content](https://docs.aws.amazon.com/service-authorization/latest/reference/list_elementalsupportcontent.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class ElementalSupportContent extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [elemental-support-content](https://docs.aws.amazon.com/service-authorization/latest/reference/list_elementalsupportcontent.html).
     *
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'elemental-support-content';
        this.accessLevelList = {
            Read: [
                'Query'
            ]
        };
    }
    /**
     * Grant the permission to search support content
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/elemental-appliances-software
     */
    toQuery() {
        return this.to('Query');
    }
}
exports.ElementalSupportContent = ElementalSupportContent;
_a = JSII_RTTI_SYMBOL_1;
ElementalSupportContent[_a] = { fqn: "cdk-iam-floyd.ElementalSupportContent", version: "0.374.0" };
//# sourceMappingURL=data:application/json;base64,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