"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Gamesparks = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [gamesparks](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazongamesparks.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Gamesparks extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [gamesparks](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazongamesparks.html).
     *
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'gamesparks';
        this.accessLevelList = {
            Write: [
                'CreateGame',
                'CreateSnapshot',
                'CreateStage',
                'DeleteGame',
                'DeleteStage',
                'DisconnectPlayer',
                'ExportSnapshot',
                'ImportGameConfiguration',
                'InvokeBackend',
                'StartGeneratedCodeJob',
                'StartStageDeployment',
                'UpdateGame',
                'UpdateGameConfiguration',
                'UpdateSnapshot',
                'UpdateStage'
            ],
            Read: [
                'GetExtension',
                'GetExtensionVersion',
                'GetGame',
                'GetGameConfiguration',
                'GetGeneratedCodeJob',
                'GetPlayerConnectionStatus',
                'GetSnapshot',
                'GetStage',
                'GetStageDeployment',
                'ListTagsForResource'
            ],
            List: [
                'ListExtensionVersions',
                'ListExtensions',
                'ListGames',
                'ListGeneratedCodeJobs',
                'ListSnapshots',
                'ListStageDeployments',
                'ListStages'
            ],
            Tagging: [
                'TagResource',
                'UntagResource'
            ]
        };
    }
    /**
     * Grants permission to create a game
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/gamesparks/latest/api/svc/API_CreateGame.html
     */
    toCreateGame() {
        return this.to('CreateGame');
    }
    /**
     * Grants permission to create a snapshot of a game
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/gamesparks/latest/api/svc/API_CreateSnapshot.html
     */
    toCreateSnapshot() {
        return this.to('CreateSnapshot');
    }
    /**
     * Grants permission to create a stage in a game
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/gamesparks/latest/api/svc/API_CreateStage.html
     */
    toCreateStage() {
        return this.to('CreateStage');
    }
    /**
     * Grants permission to delete a game
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/gamesparks/latest/api/svc/API_DeleteGame.html
     */
    toDeleteGame() {
        return this.to('DeleteGame');
    }
    /**
     * Grants permission to delete a stage from a game
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/gamesparks/latest/api/svc/API_DeleteStage.html
     */
    toDeleteStage() {
        return this.to('DeleteStage');
    }
    /**
     * Grants permission to disconnect a player from the game runtime
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/gamesparks/latest/api/svc/API_DisconnectPlayer.html
     */
    toDisconnectPlayer() {
        return this.to('DisconnectPlayer');
    }
    /**
     * Grants permission to export a snapshot of the game configuration
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/gamesparks/latest/api/svc/API_ExportSnapshot.html
     */
    toExportSnapshot() {
        return this.to('ExportSnapshot');
    }
    /**
     * Grants permission to get details about an extension
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/gamesparks/latest/api/svc/API_GetExtension.html
     */
    toGetExtension() {
        return this.to('GetExtension');
    }
    /**
     * Grants permission to get details about an extension version
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/gamesparks/latest/api/svc/API_GetExtensionVersion.html
     */
    toGetExtensionVersion() {
        return this.to('GetExtensionVersion');
    }
    /**
     * Grants permission to get details about a game
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/gamesparks/latest/api/svc/API_GetGame.html
     */
    toGetGame() {
        return this.to('GetGame');
    }
    /**
     * Grants permission to get the configuration for the game
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/gamesparks/latest/api/svc/API_GetGameConfiguration.html
     */
    toGetGameConfiguration() {
        return this.to('GetGameConfiguration');
    }
    /**
     * Grants permission to get details about a job that is generating code for a snapshot
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/gamesparks/latest/api/svc/API_GetGeneratedCodeJob.html
     */
    toGetGeneratedCodeJob() {
        return this.to('GetGeneratedCodeJob');
    }
    /**
     * Grants permission to get the status of a player connection
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/gamesparks/latest/api/svc/API_GetPlayerConnectionStatus.html
     */
    toGetPlayerConnectionStatus() {
        return this.to('GetPlayerConnectionStatus');
    }
    /**
     * Grants permission to get a snapshot of the game
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/gamesparks/latest/api/svc/API_GetSnapshot.html
     */
    toGetSnapshot() {
        return this.to('GetSnapshot');
    }
    /**
     * Grants permission to gets information about a stage
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/gamesparks/latest/api/svc/API_GetStage.html
     */
    toGetStage() {
        return this.to('GetStage');
    }
    /**
     * Grants permission to get information about a stage deployment
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/gamesparks/latest/api/svc/API_GetStageDeployment.html
     */
    toGetStageDeployment() {
        return this.to('GetStageDeployment');
    }
    /**
     * Grants permission to import a snapshot of a game configuration
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/gamesparks/latest/api/svc/API_ImportGameDocument.html
     */
    toImportGameConfiguration() {
        return this.to('ImportGameConfiguration');
    }
    /**
     * Grants permission to invoke backend services for a specific game
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/gamesparks/latest/dg/security-iam-stage-roles.html
     */
    toInvokeBackend() {
        return this.to('InvokeBackend');
    }
    /**
     * Grants permission to list the extension versions
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/gamesparks/latest/api/svc/API_ListExtensionVersions.html
     */
    toListExtensionVersions() {
        return this.to('ListExtensionVersions');
    }
    /**
     * Grants permission to list the extensions
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/gamesparks/latest/api/svc/API_ListExtensions.html
     */
    toListExtensions() {
        return this.to('ListExtensions');
    }
    /**
     * Grants permission to list the games
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/gamesparks/latest/api/svc/API_ListGames.html
     */
    toListGames() {
        return this.to('ListGames');
    }
    /**
     * Grants permission to get a list of code generation jobs for a snapshot
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/gamesparks/latest/api/svc/API_ListGeneratedCodeJobs.html
     */
    toListGeneratedCodeJobs() {
        return this.to('ListGeneratedCodeJobs');
    }
    /**
     * Grants permission to get a list of snapshot summaries for a game
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/gamesparks/latest/api/svc/API_ListSnapshots.html
     */
    toListSnapshots() {
        return this.to('ListSnapshots');
    }
    /**
     * Grants permission to get a list of stage deployment summaries for a game
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/gamesparks/latest/api/svc/API_ListStageDeployments.html
     */
    toListStageDeployments() {
        return this.to('ListStageDeployments');
    }
    /**
     * Grants permission to get a list of stage summaries for a game
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/gamesparks/latest/api/svc/API_ListStages.html
     */
    toListStages() {
        return this.to('ListStages');
    }
    /**
     * Grants permission to list the tags associated with a resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/gamesparks/latest/api/svc/API_ListTagsForResource.html
     */
    toListTagsForResource() {
        return this.to('ListTagsForResource');
    }
    /**
     * Grants permission to start an asynchronous process that generates client code for system-defined and custom messages
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/gamesparks/latest/api/svc/API_StartGeneratedCodeJob.html
     */
    toStartGeneratedCodeJob() {
        return this.to('StartGeneratedCodeJob');
    }
    /**
     * Grants permission to deploy a snapshot to a stage and creates a new game runtime
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/gamesparks/latest/api/svc/API_StartStageDeployment.html
     */
    toStartStageDeployment() {
        return this.to('StartStageDeployment');
    }
    /**
     * Grants permission to adds tags to a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/gamesparks/latest/api/svc/API_TagResource.html
     */
    toTagResource() {
        return this.to('TagResource');
    }
    /**
     * Grants permission to remove tags from a resource
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/gamesparks/latest/api/svc/API_UntagResource.html
     */
    toUntagResource() {
        return this.to('UntagResource');
    }
    /**
     * Grants permission to change the metadata of a game
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/gamesparks/latest/api/svc/API_UpdateGame.html
     */
    toUpdateGame() {
        return this.to('UpdateGame');
    }
    /**
     * Grants permission to change the working copy of the game configuration
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/gamesparks/latest/api/svc/API_UpdateGameConfiguration.html
     */
    toUpdateGameConfiguration() {
        return this.to('UpdateGameConfiguration');
    }
    /**
     * Grants permission to update the metadata of a snapshot
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/gamesparks/latest/api/svc/API_UpdateSnapshot.html
     */
    toUpdateSnapshot() {
        return this.to('UpdateSnapshot');
    }
    /**
     * Grants permission to update the metadata of a stage
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/gamesparks/latest/api/svc/API_UpdateStage.html
     */
    toUpdateStage() {
        return this.to('UpdateStage');
    }
    /**
     * Adds a resource of type game to the statement
     *
     * https://docs.aws.amazon.com/gamesparks/latest/dg/security-iam-service.html#policy-resources
     *
     * @param gameId - Identifier for the gameId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onGame(gameId, account, region, partition) {
        return this.on(`arn:${partition || Gamesparks.defaultPartition}:gamesparks:${region || '*'}:${account || '*'}:game/${gameId}`);
    }
    /**
     * Adds a resource of type stage to the statement
     *
     * https://docs.aws.amazon.com/gamesparks/latest/dg/security-iam-service.html#policy-resources
     *
     * @param gameId - Identifier for the gameId.
     * @param stageName - Identifier for the stageName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onStage(gameId, stageName, account, region, partition) {
        return this.on(`arn:${partition || Gamesparks.defaultPartition}:gamesparks:${region || '*'}:${account || '*'}:game/${gameId}/stage/${stageName}`);
    }
}
exports.Gamesparks = Gamesparks;
_a = JSII_RTTI_SYMBOL_1;
Gamesparks[_a] = { fqn: "cdk-iam-floyd.Gamesparks", version: "0.374.0" };
//# sourceMappingURL=data:application/json;base64,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