"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.IdentitySync = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [identity-sync](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsidentitysynchronizationservice.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class IdentitySync extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [identity-sync](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsidentitysynchronizationservice.html).
     *
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'identity-sync';
        this.accessLevelList = {
            Write: [
                'CreateSyncFilter',
                'CreateSyncProfile',
                'CreateSyncTarget',
                'DeleteSyncFilter',
                'DeleteSyncProfile',
                'DeleteSyncTarget',
                'StartSync',
                'StopSync',
                'UpdateSyncTarget'
            ],
            Read: [
                'GetSyncProfile',
                'GetSyncTarget'
            ],
            List: [
                'ListSyncFilters'
            ]
        };
    }
    /**
     * Grants permission to create a sync filter on the sync profile
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/security-iam-awsmanpol.html
     */
    toCreateSyncFilter() {
        return this.to('CreateSyncFilter');
    }
    /**
     * Grants permission to create a sync profile for the source
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - ds:AuthorizeApplication
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/security-iam-awsmanpol.html
     */
    toCreateSyncProfile() {
        return this.to('CreateSyncProfile');
    }
    /**
     * Grants permission to create a sync target for the source
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/security-iam-awsmanpol.html
     */
    toCreateSyncTarget() {
        return this.to('CreateSyncTarget');
    }
    /**
     * Grants permission to delete a sync filter on the sync profile
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/security-iam-awsmanpol.html
     */
    toDeleteSyncFilter() {
        return this.to('DeleteSyncFilter');
    }
    /**
     * Grants permission to delete a sync profile on the source
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - ds:UnauthorizeApplication
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/security-iam-awsmanpol.html
     */
    toDeleteSyncProfile() {
        return this.to('DeleteSyncProfile');
    }
    /**
     * Grants permission to delete a sync target on the source
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/security-iam-awsmanpol.html
     */
    toDeleteSyncTarget() {
        return this.to('DeleteSyncTarget');
    }
    /**
     * Grants permission to retrieve a sync profile using sync profile name
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/security-iam-awsmanpol.html
     */
    toGetSyncProfile() {
        return this.to('GetSyncProfile');
    }
    /**
     * Grants permission to retrieve a sync target on the sync profile
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/security-iam-awsmanpol.html
     */
    toGetSyncTarget() {
        return this.to('GetSyncTarget');
    }
    /**
     * Grants permission to list the sync filters on the sync profile
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/security-iam-awsmanpol.html
     */
    toListSyncFilters() {
        return this.to('ListSyncFilters');
    }
    /**
     * Grants permission to start a synchronization process or to restart a synchronization that was previously stopped
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/security-iam-awsmanpol.html
     */
    toStartSync() {
        return this.to('StartSync');
    }
    /**
     * Grants permission to stop any planned synchronizations in the synchronization schedule from starting
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/security-iam-awsmanpol.html
     */
    toStopSync() {
        return this.to('StopSync');
    }
    /**
     * Grants permission to update a sync target on the sync profile
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/security-iam-awsmanpol.html
     */
    toUpdateSyncTarget() {
        return this.to('UpdateSyncTarget');
    }
    /**
     * Adds a resource of type SyncProfileResource to the statement
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/security-iam-awsmanpol.html
     *
     * @param syncProfileName - Identifier for the syncProfileName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onSyncProfileResource(syncProfileName, account, region, partition) {
        return this.on(`^arn:${partition || IdentitySync.defaultPartition}:identity-sync:${region || '*'}:${account || '*'}:profile/${syncProfileName}`);
    }
    /**
     * Adds a resource of type SyncTargetResource to the statement
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/security-iam-awsmanpol.html
     *
     * @param syncProfileName - Identifier for the syncProfileName.
     * @param syncTargetName - Identifier for the syncTargetName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onSyncTargetResource(syncProfileName, syncTargetName, account, region, partition) {
        return this.on(`^arn:${partition || IdentitySync.defaultPartition}:identity-sync:${region || '*'}:${account || '*'}:target/${syncProfileName}/${syncTargetName}`);
    }
}
exports.IdentitySync = IdentitySync;
_a = JSII_RTTI_SYMBOL_1;
IdentitySync[_a] = { fqn: "cdk-iam-floyd.IdentitySync", version: "0.374.0" };
//# sourceMappingURL=data:application/json;base64,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