import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement, Operator } from '../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [iotfleetwise](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiotfleetwise.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Iotfleetwise extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to associate the given vehicle to a fleet
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_AssociateVehicle.html
     */
    toAssociateVehicle(): this;
    /**
     * Grants permission to create a campaign
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_CreateCampaign.html
     */
    toCreateCampaign(): this;
    /**
     * Grants permission to create a decoder manifest for an existing model
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_CreateDecoderManifest.html
     */
    toCreateDecoderManifest(): this;
    /**
     * Grants permission to create a fleet
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_CreateFleet.html
     */
    toCreateFleet(): this;
    /**
     * Grants permission to create a model manifest definition
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_CreateModelManifest.html
     */
    toCreateModelManifest(): this;
    /**
     * Grants permission to create a signal catalog
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_CreateSignalCatalog.html
     */
    toCreateSignalCatalog(): this;
    /**
     * Grants permission to create a vehicle
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iot:CreateThing
     * - iot:DescribeThing
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_CreateVehicle.html
     */
    toCreateVehicle(): this;
    /**
     * Grants permission to delete a campaign
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_DeleteCampaign.html
     */
    toDeleteCampaign(): this;
    /**
     * Grants permission to delete the given decoder manifest
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_DeleteDecoderManifest.html
     */
    toDeleteDecoderManifest(): this;
    /**
     * Grants permission to delete a fleet
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_DeleteFleet.html
     */
    toDeleteFleet(): this;
    /**
     * Grants permission to delete the given model manifest
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_DeleteModelManifest.html
     */
    toDeleteModelManifest(): this;
    /**
     * Grants permission to delete a specific signal catalog
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_DeleteSignalCatalog.html
     */
    toDeleteSignalCatalog(): this;
    /**
     * Grants permission to delete a vehicle
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_DeleteVehicle.html
     */
    toDeleteVehicle(): this;
    /**
     * Grants permission to disassociate a vehicle from an existing fleet
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_DisassociateVehicle.html
     */
    toDisassociateVehicle(): this;
    /**
     * Grants permission to get summary information for a given campaign
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_GetCampaign.html
     */
    toGetCampaign(): this;
    /**
     * Grants permission to get summary information for a given decoder manifest definition
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_GetDecoderManifest.html
     */
    toGetDecoderManifest(): this;
    /**
     * Grants permission to get summary information for a fleet
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_GetFleet.html
     */
    toGetFleet(): this;
    /**
     * Grants permission to get summary information for a given model manifest definition
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_GetModelManifest.html
     */
    toGetModelManifest(): this;
    /**
     * Grants permission to get the account registration status with IoT FleetWise
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_GetRegisterAccountStatus.html
     */
    toGetRegisterAccountStatus(): this;
    /**
     * Grants permission to get summary information for a specific signal catalog
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_GetSignalCatalog.html
     */
    toGetSignalCatalog(): this;
    /**
     * Grants permission to get summary information for a vehicle
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_GetVehicle.html
     */
    toGetVehicle(): this;
    /**
     * Grants permission to get the status of the campaigns running on a specific vehicle
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_GetVehicleStatus.html
     */
    toGetVehicleStatus(): this;
    /**
     * Grants permission to import an existing decoder manifest
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_ImportDecoderManifest.html
     */
    toImportDecoderManifest(): this;
    /**
     * Grants permission to create a signal catalog by importing existing definitions
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_ImportSignalCatalog.html
     */
    toImportSignalCatalog(): this;
    /**
     * Grants permission to list campaigns
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_ListCampaigns.html
     */
    toListCampaigns(): this;
    /**
     * Grants permission to list network interfaces associated to the existing decoder manifest
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_ListDecoderManifestNetworkInterfaces.html
     */
    toListDecoderManifestNetworkInterfaces(): this;
    /**
     * Grants permission to list decoder manifest signals
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_ListDecoderManifestSignals.html
     */
    toListDecoderManifestSignals(): this;
    /**
     * Grants permission to list all decoder manifests, with an optional filter on model manifest
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_ListDecoderManifests.html
     */
    toListDecoderManifests(): this;
    /**
     * Grants permission to list all fleets
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_ListFleets.html
     */
    toListFleets(): this;
    /**
     * Grants permission to list all the fleets that the given vehicle is associated with
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_ListFleetsForVehicle.html
     */
    toListFleetsForVehicle(): this;
    /**
     * Grants permission to list all nodes for the given model manifest
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_ListModelManifestNodes.html
     */
    toListModelManifestNodes(): this;
    /**
     * Grants permission to list all model manifests, with an optional filter on signal catalog
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_ListModelManifests.html
     */
    toListModelManifests(): this;
    /**
     * Grants permission to list all nodes for a given signal catalog
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_.html
     */
    toListSignalCatalogNodes(): this;
    /**
     * Grants permission to list all signal catalogs
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_ListSignalCatalogs.html
     */
    toListSignalCatalogs(): this;
    /**
     * Grants permission to list all vehicles, with an optional filter on model manifest
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_ListVehicles.html
     */
    toListVehicles(): this;
    /**
     * Grants permission to list vehicles in the given fleet
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_ListVehiclesInFleet.html
     */
    toListVehiclesInFleet(): this;
    /**
     * Grants permission to register an AWS account to IoT FleetWise
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_RegisterAccount.html
     */
    toRegisterAccount(): this;
    /**
     * Grants permission to update the given campaign
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_UpdateCampaign.html
     */
    toUpdateCampaign(): this;
    /**
     * Grants permission to update a decoder manifest defnition
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_UpdateDecoderManifest.html
     */
    toUpdateDecoderManifest(): this;
    /**
     * Grants permission to update the fleet
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_UpdateFleet.html
     */
    toUpdateFleet(): this;
    /**
     * Grants permission to update the given model manifest definition
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_UpdateModelManifest.html
     */
    toUpdateModelManifest(): this;
    /**
     * Grants permission to update a specific signal catalog definition
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_UpdateSignalCatalog.html
     */
    toUpdateSignalCatalog(): this;
    /**
     * Grants permission to update the vehicle
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifUpdateToModelManifestArn()
     * - .ifUpdateToDecoderManifestArn()
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_UpdateVehicle.html
     */
    toUpdateVehicle(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type campaign to the statement
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/iot-vehicle-wise.html
     *
     * @param campaignName - Identifier for the campaignName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onCampaign(campaignName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type decodermanifest to the statement
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/iot-vehicle-wise.html
     *
     * @param name - Identifier for the name.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onDecodermanifest(name: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type fleet to the statement
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/iot-vehicle-wise.html
     *
     * @param fleetId - Identifier for the fleetId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onFleet(fleetId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type modelmanifest to the statement
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/iot-vehicle-wise.html
     *
     * @param name - Identifier for the name.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onModelmanifest(name: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type signalcatalog to the statement
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/iot-vehicle-wise.html
     *
     * @param name - Identifier for the name.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onSignalcatalog(name: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type vehicle to the statement
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/iot-vehicle-wise.html
     *
     * @param vehicleId - Identifier for the vehicleId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onVehicle(vehicleId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access by a list of IoT FleetWise Decoder Manifest ARNs
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiotfleetwise.html
     *
     * Applies to actions:
     * - .toUpdateVehicle()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifUpdateToDecoderManifestArn(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by a list of IoT FleetWise Model Manifest ARNs
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiotfleetwise.html
     *
     * Applies to actions:
     * - .toUpdateVehicle()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifUpdateToModelManifestArn(value: string | string[], operator?: Operator | string): this;
    /**
     * Statement provider for service [iotfleetwise](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiotfleetwise.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
//# sourceMappingURL=iotfleetwise.d.ts.map