"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Launchwizard = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [launchwizard](https://docs.aws.amazon.com/service-authorization/latest/reference/list_launchwizard.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Launchwizard extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [launchwizard](https://docs.aws.amazon.com/service-authorization/latest/reference/list_launchwizard.html).
     *
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'launchwizard';
        this.accessLevelList = {
            Write: [
                'DeleteApp',
                'StartProvisioning'
            ],
            Read: [
                'DescribeProvisionedApp',
                'DescribeProvisioningEvents',
                'GetInfrastructureSuggestion',
                'GetIpAddress',
                'GetResourceCostEstimate'
            ],
            List: [
                'ListProvisionedApps'
            ]
        };
    }
    /**
     * Delete an application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/launchwizard/
     */
    toDeleteApp() {
        return this.to('DeleteApp');
    }
    /**
     * Describe provisioning applications
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/launchwizard/
     */
    toDescribeProvisionedApp() {
        return this.to('DescribeProvisionedApp');
    }
    /**
     * Describe provisioning events
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/launchwizard/
     */
    toDescribeProvisioningEvents() {
        return this.to('DescribeProvisioningEvents');
    }
    /**
     * Get infrastructure suggestion
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/launchwizard/
     */
    toGetInfrastructureSuggestion() {
        return this.to('GetInfrastructureSuggestion');
    }
    /**
     * Get customer's ip address
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/launchwizard/
     */
    toGetIpAddress() {
        return this.to('GetIpAddress');
    }
    /**
     * Get resource cost estimate
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/launchwizard/
     */
    toGetResourceCostEstimate() {
        return this.to('GetResourceCostEstimate');
    }
    /**
     * List provisioning applications
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/launchwizard/
     */
    toListProvisionedApps() {
        return this.to('ListProvisionedApps');
    }
    /**
     * Start a provisioning
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/launchwizard/
     */
    toStartProvisioning() {
        return this.to('StartProvisioning');
    }
}
exports.Launchwizard = Launchwizard;
_a = JSII_RTTI_SYMBOL_1;
Launchwizard[_a] = { fqn: "cdk-iam-floyd.Launchwizard", version: "0.374.0" };
//# sourceMappingURL=data:application/json;base64,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