"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.NeptuneDb = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [neptune-db](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonneptune.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class NeptuneDb extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [neptune-db](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonneptune.html).
     *
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'neptune-db';
        this.accessLevelList = {
            Write: [
                'connect'
            ]
        };
    }
    /**
     * Connect to database
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/neptune/latest/userguide/get-started.html
     */
    toConnect() {
        return this.to('connect');
    }
    /**
     * Adds a resource of type database to the statement
     *
     * https://docs.aws.amazon.com/neptune/latest/userguide/get-started.html
     *
     * @param cluster - Identifier for the cluster.
     * @param database - Identifier for the database.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onDatabase(cluster, database, account, region, partition) {
        return this.on(`arn:${partition || NeptuneDb.defaultPartition}:neptune-db:${region || '*'}:${account || '*'}:${cluster}/${database}`);
    }
}
exports.NeptuneDb = NeptuneDb;
_a = JSII_RTTI_SYMBOL_1;
NeptuneDb[_a] = { fqn: "cdk-iam-floyd.NeptuneDb", version: "0.374.0" };
//# sourceMappingURL=data:application/json;base64,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