import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [opsworks](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsopsworks.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Opsworks extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to assign a registered instance to a layer
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_AssignInstance.html
     */
    toAssignInstance(): this;
    /**
     * Grants permission to assign one of the stack's registered Amazon EBS volumes to a specified instance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_AssignVolume.html
     */
    toAssignVolume(): this;
    /**
     * Grants permission to associate one of the stack's registered Elastic IP addresses with a specified instance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_AssociateElasticIp.html
     */
    toAssociateElasticIp(): this;
    /**
     * Grants permission to attach an Elastic Load Balancing load balancer to a specified layer
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_AttachElasticLoadBalancer.html
     */
    toAttachElasticLoadBalancer(): this;
    /**
     * Grants permission to create a clone of a specified stack
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_CloneStack.html
     */
    toCloneStack(): this;
    /**
     * Grants permission to create an app for a specified stack
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_CreateApp.html
     */
    toCreateApp(): this;
    /**
     * Grants permission to run deployment or stack commands
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_CreateDeployment.html
     */
    toCreateDeployment(): this;
    /**
     * Grants permission to create an instance in a specified stack
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_CreateInstance.html
     */
    toCreateInstance(): this;
    /**
     * Grants permission to create a layer
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_CreateLayer.html
     */
    toCreateLayer(): this;
    /**
     * Grants permission to create a new stack
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_CreateStack.html
     */
    toCreateStack(): this;
    /**
     * Grants permission to create a new user profile
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_CreateUserProfile.html
     */
    toCreateUserProfile(): this;
    /**
     * Grants permission to delete a specified app
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_DeleteApp.html
     */
    toDeleteApp(): this;
    /**
     * Grants permission to delete a specified instance, which terminates the associated Amazon EC2 instance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_DeleteInstance.html
     */
    toDeleteInstance(): this;
    /**
     * Grants permission to delete a specified layer
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_DeleteLayer.html
     */
    toDeleteLayer(): this;
    /**
     * Grants permission to delete a specified stack
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_DeleteStack.html
     */
    toDeleteStack(): this;
    /**
     * Grants permission to delete a user profile
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_DeleteUserProfile.html
     */
    toDeleteUserProfile(): this;
    /**
     * Grants permission to delete a user profile
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_DeregisterEcsCluster.html
     */
    toDeregisterEcsCluster(): this;
    /**
     * Grants permission to deregister a specified Elastic IP address
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_DeregisterElasticIp.html
     */
    toDeregisterElasticIp(): this;
    /**
     * Grants permission to deregister a registered Amazon EC2 or on-premises instance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_DeregisterInstance.html
     */
    toDeregisterInstance(): this;
    /**
     * Grants permission to deregister an Amazon RDS instance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_DeregisterRdsDbInstance.html
     */
    toDeregisterRdsDbInstance(): this;
    /**
     * Grants permission to deregister an Amazon EBS volume
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_DeregisterVolume.html
     */
    toDeregisterVolume(): this;
    /**
     * Grants permission to describe the available AWS OpsWorks agent versions
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_DescribeAgentVersions.html
     */
    toDescribeAgentVersions(): this;
    /**
     * Grants permission to request a description of a specified set of apps
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_DescribeApps.html
     */
    toDescribeApps(): this;
    /**
     * Grants permission to describe the results of specified commands
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_DescribeCommands.html
     */
    toDescribeCommands(): this;
    /**
     * Grants permission to request a description of a specified set of deployments
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_DescribeDeployments.html
     */
    toDescribeDeployments(): this;
    /**
     * Grants permission to describe Amazon ECS clusters that are registered with a stack
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_DescribeEcsClusters.html
     */
    toDescribeEcsClusters(): this;
    /**
     * Grants permission to describe Elastic IP addresses
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_DescribeElasticIps.html
     */
    toDescribeElasticIps(): this;
    /**
     * Grants permission to describe a stack's Elastic Load Balancing instances
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_DescribeElasticLoadBalancers.html
     */
    toDescribeElasticLoadBalancers(): this;
    /**
     * Grants permission to request a description of a set of instances
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_DescribeInstances.html
     */
    toDescribeInstances(): this;
    /**
     * Grants permission to request a description of one or more layers in a specified stack
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_DescribeLayers.html
     */
    toDescribeLayers(): this;
    /**
     * Grants permission to describe load-based auto scaling configurations for specified layers
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_DescribeLoadBasedAutoScaling.html
     */
    toDescribeLoadBasedAutoScaling(): this;
    /**
     * Grants permission to describe a user's SSH information
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_DescribeMyUserProfile.html
     */
    toDescribeMyUserProfile(): this;
    /**
     * Grants permission to describe the operating systems that are supported by AWS OpsWorks Stacks
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_DescribeOperatingSystems.html
     */
    toDescribeOperatingSystems(): this;
    /**
     * Grants permission to describe the permissions for a specified stack
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_DescribePermissions.html
     */
    toDescribePermissions(): this;
    /**
     * Grants permission to describe an instance's RAID arrays
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_DescribeRaidArrays.html
     */
    toDescribeRaidArrays(): this;
    /**
     * Grants permission to describe Amazon RDS instances
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_DescribeRdsDbInstances.html
     */
    toDescribeRdsDbInstances(): this;
    /**
     * Grants permission to describe AWS OpsWorks service errors
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_DescribeServiceErrors.html
     */
    toDescribeServiceErrors(): this;
    /**
     * Grants permission to request a description of a stack's provisioning parameters
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_DescribeStackProvisioningParameters.html
     */
    toDescribeStackProvisioningParameters(): this;
    /**
     * Grants permission to describe the number of layers and apps in a specified stack, and the number of instances in each state, such as running_setup or online
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_DescribeStackSummary.html
     */
    toDescribeStackSummary(): this;
    /**
     * Grants permission to request a description of one or more stacks
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_DescribeStacks.html
     */
    toDescribeStacks(): this;
    /**
     * Grants permission to describe time-based auto scaling configurations for specified instances
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_DescribeTimeBasedAutoScaling.html
     */
    toDescribeTimeBasedAutoScaling(): this;
    /**
     * Grants permission to describe specified users
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_DescribeUserProfiles.html
     */
    toDescribeUserProfiles(): this;
    /**
     * Grants permission to describe an instance's Amazon EBS volumes
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_DescribeVolumes.html
     */
    toDescribeVolumes(): this;
    /**
     * Grants permission to detache a specified Elastic Load Balancing instance from its layer
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_DetachElasticLoadBalancer.html
     */
    toDetachElasticLoadBalancer(): this;
    /**
     * Grants permission to disassociate an Elastic IP address from its instance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_DisassociateElasticIp.html
     */
    toDisassociateElasticIp(): this;
    /**
     * Grants permission to get a generated host name for the specified layer, based on the current host name theme
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_GetHostnameSuggestion.html
     */
    toGetHostnameSuggestion(): this;
    /**
     * Grants permission to grant RDP access to a Windows instance for a specified time period
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_RebootInstance.html
     */
    toGrantAccess(): this;
    /**
     * Grants permission to return a list of tags that are applied to the specified stack or layer
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_ListTags.html
     */
    toListTags(): this;
    /**
     * Grants permission to reboot a specified instance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_RebootInstance.html
     */
    toRebootInstance(): this;
    /**
     * Grants permission to register a specified Amazon ECS cluster with a stack
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_RegisterEcsCluster.html
     */
    toRegisterEcsCluster(): this;
    /**
     * Grants permission to register an Elastic IP address with a specified stack
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_RegisterElasticIp.html
     */
    toRegisterElasticIp(): this;
    /**
     * Grants permission to register instances with a specified stack that were created outside of AWS OpsWorks
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_RegisterInstance.html
     */
    toRegisterInstance(): this;
    /**
     * Grants permission to register an Amazon RDS instance with a stack
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_RegisterRdsDbInstance.html
     */
    toRegisterRdsDbInstance(): this;
    /**
     * Grants permission to register an Amazon EBS volume with a specified stack
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_RegisterVolume.html
     */
    toRegisterVolume(): this;
    /**
     * Grants permission to specify the load-based auto scaling configuration for a specified layer
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_SetLoadBasedAutoScaling.html
     */
    toSetLoadBasedAutoScaling(): this;
    /**
     * Grants permission to specify a user's permissions
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_SetPermission.html
     */
    toSetPermission(): this;
    /**
     * Grants permission to specify the time-based auto scaling configuration for a specified instance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_SetTimeBasedAutoScaling.html
     */
    toSetTimeBasedAutoScaling(): this;
    /**
     * Grants permission to start a specified instance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_StartInstance.html
     */
    toStartInstance(): this;
    /**
     * Grants permission to start a stack's instances
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_StartStack.html
     */
    toStartStack(): this;
    /**
     * Grants permission to stop a specified instance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_StopInstance.html
     */
    toStopInstance(): this;
    /**
     * Grants permission to stop a specified stack
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_StopStack.html
     */
    toStopStack(): this;
    /**
     * Grants permission to apply tags to a specified stack or layer
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to unassign a registered instance from all of it's layers
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_UnassignInstance.html
     */
    toUnassignInstance(): this;
    /**
     * Grants permission to unassign an assigned Amazon EBS volume
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_UnassignVolume.html
     */
    toUnassignVolume(): this;
    /**
     * Grants permission to remove tags from a specified stack or layer
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update a specified app
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_UpdateApp.html
     */
    toUpdateApp(): this;
    /**
     * Grants permission to update a registered Elastic IP address's name
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_UpdateElasticIp.html
     */
    toUpdateElasticIp(): this;
    /**
     * Grants permission to update a specified instance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_UpdateInstance.html
     */
    toUpdateInstance(): this;
    /**
     * Grants permission to update a specified layer
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_UpdateLayer.html
     */
    toUpdateLayer(): this;
    /**
     * Grants permission to update a user's SSH public key
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_UpdateMyUserProfile.html
     */
    toUpdateMyUserProfile(): this;
    /**
     * Grants permission to update an Amazon RDS instance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_UpdateRdsDbInstance.html
     */
    toUpdateRdsDbInstance(): this;
    /**
     * Grants permission to update a specified stack
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_UpdateStack.html
     */
    toUpdateStack(): this;
    /**
     * Grants permission to update a specified user profile
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_UpdateUserProfile.html
     */
    toUpdateUserProfile(): this;
    /**
     * Grants permission to update an Amazon EBS volume's name or mount point
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_UpdateVolume.html
     */
    toUpdateVolume(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type stack to the statement
     *
     * https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks.html
     *
     * @param stackId - Identifier for the stackId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onStack(stackId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Statement provider for service [opsworks](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsopsworks.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
//# sourceMappingURL=opsworks.d.ts.map