import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [tag](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonresourcegrouptaggingapi.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Tag extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to describe the status of the StartReportCreation operation
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/resourcegroupstagging/latest/APIReference/API_DescribeReportCreation.html
     */
    toDescribeReportCreation(): this;
    /**
     * Grants permission to retrieve a summary of how many resources are noncompliant with their effective tag policies
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/resourcegroupstagging/latest/APIReference/API_GetComplianceSummary.html
     */
    toGetComplianceSummary(): this;
    /**
     * Grants permission to return tagged or previously tagged resources in the specified AWS Region for the calling account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/resourcegroupstagging/latest/APIReference/API_GetResources.html
     */
    toGetResources(): this;
    /**
     * Grants permission to returns tag keys currently in use in the specified AWS Region for the calling account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/resourcegroupstagging/latest/APIReference/API_GetTagKeys.html
     */
    toGetTagKeys(): this;
    /**
     * Grants permission to return tag values for the specified key that are used in the specified AWS Region for the calling account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/resourcegroupstagging/latest/APIReference/API_GetTagValues.html
     */
    toGetTagValues(): this;
    /**
     * Grants permission to start generating a report listing all tagged resources in accounts across your organization, and whether each resource is compliant with the effective tag policy
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/resourcegroupstagging/latest/APIReference/API_StartReportCreation.html
     */
    toStartReportCreation(): this;
    /**
     * Grants permission to apply one or more tags to the specified resources
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/resourcegroupstagging/latest/APIReference/API_TagResources.html
     */
    toTagResources(): this;
    /**
     * Grants permission to remove the specified tags from the specified resources
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/resourcegroupstagging/latest/APIReference/API_UntagResources.html
     */
    toUntagResources(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Statement provider for service [tag](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonresourcegrouptaggingapi.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
//# sourceMappingURL=resourcegrouptaggingapi.d.ts.map