"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Route53domains = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [route53domains](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonroute53domains.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Route53domains extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [route53domains](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonroute53domains.html).
     *
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'route53domains';
        this.accessLevelList = {
            Write: [
                'AcceptDomainTransferFromAnotherAwsAccount',
                'CancelDomainTransferToAnotherAwsAccount',
                'DeleteDomain',
                'DisableDomainAutoRenew',
                'DisableDomainTransferLock',
                'EnableDomainAutoRenew',
                'EnableDomainTransferLock',
                'RegisterDomain',
                'RejectDomainTransferFromAnotherAwsAccount',
                'RenewDomain',
                'ResendContactReachabilityEmail',
                'RetrieveDomainAuthCode',
                'TransferDomain',
                'TransferDomainToAnotherAwsAccount',
                'UpdateDomainContact',
                'UpdateDomainContactPrivacy',
                'UpdateDomainNameservers'
            ],
            Read: [
                'CheckDomainAvailability',
                'CheckDomainTransferability',
                'GetContactReachabilityStatus',
                'GetDomainDetail',
                'GetDomainSuggestions',
                'GetOperationDetail',
                'ListTagsForDomain',
                'ViewBilling'
            ],
            Tagging: [
                'DeleteTagsForDomain',
                'UpdateTagsForDomain'
            ],
            List: [
                'ListDomains',
                'ListOperations',
                'ListPrices'
            ]
        };
    }
    /**
     * Grants permission to accept the transfer of a domain from another AWS account to the current AWS account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_AcceptDomainTransferFromAnotherAwsAccount.html
     */
    toAcceptDomainTransferFromAnotherAwsAccount() {
        return this.to('AcceptDomainTransferFromAnotherAwsAccount');
    }
    /**
     * Grants permission to cancel the transfer of a domain from the current AWS account to another AWS account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_CancelDomainTransferToAnotherAwsAccount.html
     */
    toCancelDomainTransferToAnotherAwsAccount() {
        return this.to('CancelDomainTransferToAnotherAwsAccount');
    }
    /**
     * Grants permission to check the availability of one domain name
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_CheckDomainAvailability.html
     */
    toCheckDomainAvailability() {
        return this.to('CheckDomainAvailability');
    }
    /**
     * Grants permission to check whether a domain name can be transferred to Amazon Route 53
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_CheckDomainTransferability.html
     */
    toCheckDomainTransferability() {
        return this.to('CheckDomainTransferability');
    }
    /**
     * Grants permission to delete domains
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_DeleteDomain.html
     */
    toDeleteDomain() {
        return this.to('DeleteDomain');
    }
    /**
     * Grants permission to delete the specified tags for a domain
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_DeleteTagsForDomain.html
     */
    toDeleteTagsForDomain() {
        return this.to('DeleteTagsForDomain');
    }
    /**
     * Grants permission to configure Amazon Route 53 to automatically renew the specified domain before the domain registration expires
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_DisableDomainAutoRenew.html
     */
    toDisableDomainAutoRenew() {
        return this.to('DisableDomainAutoRenew');
    }
    /**
     * Grants permission to remove the transfer lock on the domain (specifically the clientTransferProhibited status) to allow domain transfers
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_DisableDomainTransferLock.html
     */
    toDisableDomainTransferLock() {
        return this.to('DisableDomainTransferLock');
    }
    /**
     * Grants permission to configure Amazon Route 53 to automatically renew the specified domain before the domain registration expires
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_DisableDomainAutoRenew.html
     */
    toEnableDomainAutoRenew() {
        return this.to('EnableDomainAutoRenew');
    }
    /**
     * Grants permission to set the transfer lock on the domain (specifically the clientTransferProhibited status) to prevent domain transfers
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_EnableDomainTransferLock.html
     */
    toEnableDomainTransferLock() {
        return this.to('EnableDomainTransferLock');
    }
    /**
     * Grants permission to get information about whether the registrant contact has responded for operations that require confirmation that the email address for the registrant contact is valid, such as registering a new domain
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetContactReachabilityStatus.html
     */
    toGetContactReachabilityStatus() {
        return this.to('GetContactReachabilityStatus');
    }
    /**
     * Grants permission to get detailed information about a domain
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetDomainDetail.html
     */
    toGetDomainDetail() {
        return this.to('GetDomainDetail');
    }
    /**
     * Grants permission to get a list of suggested domain names given a string, which can either be a domain name or simply a word or phrase (without spaces)
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetDomainSuggestions.html
     */
    toGetDomainSuggestions() {
        return this.to('GetDomainSuggestions');
    }
    /**
     * Grants permission to get the current status of an operation that is not completed
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html
     */
    toGetOperationDetail() {
        return this.to('GetOperationDetail');
    }
    /**
     * Grants permission to list all the domain names registered with Amazon Route 53 for the current AWS account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ListDomains.html
     */
    toListDomains() {
        return this.to('ListDomains');
    }
    /**
     * Grants permission to list the operation IDs of operations that are not yet complete
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ListOperations.html
     */
    toListOperations() {
        return this.to('ListOperations');
    }
    /**
     * Grants permission to list the prices of operations for TLDs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ListPrices.html
     */
    toListPrices() {
        return this.to('ListPrices');
    }
    /**
     * Grants permission to list all the tags that are associated with the specified domain
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ListTagsForDomain.html
     */
    toListTagsForDomain() {
        return this.to('ListTagsForDomain');
    }
    /**
     * Grants permission to register domains
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_RegisterDomain.html
     */
    toRegisterDomain() {
        return this.to('RegisterDomain');
    }
    /**
     * Grants permission to reject the transfer of a domain from another AWS account to the current AWS account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_RejectDomainTransferFromAnotherAwsAccount.html
     */
    toRejectDomainTransferFromAnotherAwsAccount() {
        return this.to('RejectDomainTransferFromAnotherAwsAccount');
    }
    /**
     * Grants permission to renew domains for the specified number of years
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_RenewDomain.html
     */
    toRenewDomain() {
        return this.to('RenewDomain');
    }
    /**
     * Grants permission to resend the confirmation email to the current email address for the registrant contact for operations that require confirmation that the email address for the registrant contact is valid, such as registering a new domain
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ResendContactReachabilityEmail.html
     */
    toResendContactReachabilityEmail() {
        return this.to('ResendContactReachabilityEmail');
    }
    /**
     * Grants permission to get the AuthCode for the domain
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_RetrieveDomainAuthCode.html
     */
    toRetrieveDomainAuthCode() {
        return this.to('RetrieveDomainAuthCode');
    }
    /**
     * Grants permission to transfer a domain from another registrar to Amazon Route 53
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_TransferDomain.html
     */
    toTransferDomain() {
        return this.to('TransferDomain');
    }
    /**
     * Grants permission to transfer a domain from the current AWS account to another AWS account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_TransferDomainToAnotherAwsAccount.html
     */
    toTransferDomainToAnotherAwsAccount() {
        return this.to('TransferDomainToAnotherAwsAccount');
    }
    /**
     * Grants permission to update the contact information for domain
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_UpdateDomainContact.html
     */
    toUpdateDomainContact() {
        return this.to('UpdateDomainContact');
    }
    /**
     * Grants permission to update the domain contact privacy setting
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_UpdateDomainContactPrivacy.html
     */
    toUpdateDomainContactPrivacy() {
        return this.to('UpdateDomainContactPrivacy');
    }
    /**
     * Grants permission to replace the current set of name servers for a domain with the specified set of name servers
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_UpdateDomainNameservers.html
     */
    toUpdateDomainNameservers() {
        return this.to('UpdateDomainNameservers');
    }
    /**
     * Grants permission to add or update tags for a specified domain
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_UpdateTagsForDomain.html
     */
    toUpdateTagsForDomain() {
        return this.to('UpdateTagsForDomain');
    }
    /**
     * Grants permission to get all the domain-related billing records for the current AWS account for a specified period
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ViewBilling.html
     */
    toViewBilling() {
        return this.to('ViewBilling');
    }
}
exports.Route53domains = Route53domains;
_a = JSII_RTTI_SYMBOL_1;
Route53domains[_a] = { fqn: "cdk-iam-floyd.Route53domains", version: "0.374.0" };
//# sourceMappingURL=data:application/json;base64,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