import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [route53-recovery-cluster](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonroute53recoverycluster.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Route53RecoveryCluster extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to get a routing control state
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/routing-control/latest/APIReference/API_GetRoutingControlState.html
     */
    toGetRoutingControlState(): this;
    /**
     * Grants permission to list routing controls
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/routing-control/latest/APIReference/API_ListRoutingControls.html
     */
    toListRoutingControls(): this;
    /**
     * Grants permission to update a routing control state
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAllowSafetyRulesOverrides()
     *
     * https://docs.aws.amazon.com/routing-control/latest/APIReference/API_UpdateRoutingControlState.html
     */
    toUpdateRoutingControlState(): this;
    /**
     * Grants permission to update a batch of routing control states
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAllowSafetyRulesOverrides()
     *
     * https://docs.aws.amazon.com/routing-control/latest/APIReference/API_UpdateRoutingControlStates.html
     */
    toUpdateRoutingControlStates(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type routingcontrol to the statement
     *
     * https://docs.aws.amazon.com/recovery-cluster/latest/api/routingcontrol.html
     *
     * @param controlPanelId - Identifier for the controlPanelId.
     * @param routingControlId - Identifier for the routingControlId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onRoutingcontrol(controlPanelId: string, routingControlId: string, account?: string, partition?: string): this;
    /**
     * Override safety rules to allow routing control state updates
     *
     * https://docs.aws.amazon.com/routing-control/latest/APIReference/API_UpdateRoutingControlState.html
     *
     * Applies to actions:
     * - .toUpdateRoutingControlState()
     * - .toUpdateRoutingControlStates()
     *
     * @param value `true` or `false`. **Default:** `true`
     */
    ifAllowSafetyRulesOverrides(value?: boolean): this;
    /**
     * Statement provider for service [route53-recovery-cluster](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonroute53recoverycluster.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
//# sourceMappingURL=route53recoverycluster.d.ts.map