"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Glacier = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [glacier](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazons3glacier.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Glacier extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [glacier](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazons3glacier.html).
     *
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'glacier';
        this.accessLevelList = {
            Write: [
                'AbortMultipartUpload',
                'CompleteMultipartUpload',
                'CreateVault',
                'DeleteArchive',
                'DeleteVault',
                'DeleteVaultNotifications',
                'InitiateJob',
                'InitiateMultipartUpload',
                'PurchaseProvisionedCapacity',
                'SetVaultNotifications',
                'UploadArchive',
                'UploadMultipartPart'
            ],
            'Permissions management': [
                'AbortVaultLock',
                'CompleteVaultLock',
                'DeleteVaultAccessPolicy',
                'InitiateVaultLock',
                'SetDataRetrievalPolicy',
                'SetVaultAccessPolicy'
            ],
            Tagging: [
                'AddTagsToVault',
                'RemoveTagsFromVault'
            ],
            Read: [
                'DescribeJob',
                'DescribeVault',
                'GetDataRetrievalPolicy',
                'GetJobOutput',
                'GetVaultAccessPolicy',
                'GetVaultLock',
                'GetVaultNotifications'
            ],
            List: [
                'ListJobs',
                'ListMultipartUploads',
                'ListParts',
                'ListProvisionedCapacity',
                'ListTagsForVault',
                'ListVaults'
            ]
        };
    }
    /**
     * Grants permission to abort a multipart upload identified by the upload ID
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/api-multipart-abort-upload.html
     */
    toAbortMultipartUpload() {
        return this.to('AbortMultipartUpload');
    }
    /**
     * Grants permission to abort the vault locking process if the vault lock is not in the Locked state
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/api-AbortVaultLock.html
     */
    toAbortVaultLock() {
        return this.to('AbortVaultLock');
    }
    /**
     * Grants permission to add the specified tags to a vault
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/api-AddTagsToVault.html
     */
    toAddTagsToVault() {
        return this.to('AddTagsToVault');
    }
    /**
     * Grants permission to complete a multipart upload process
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/api-multipart-complete-upload.html
     */
    toCompleteMultipartUpload() {
        return this.to('CompleteMultipartUpload');
    }
    /**
     * Grants permission to complete the vault locking process
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/api-CompleteVaultLock.html
     */
    toCompleteVaultLock() {
        return this.to('CompleteVaultLock');
    }
    /**
     * Grants permission to create a new vault with the specified name
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/api-vault-put.html
     */
    toCreateVault() {
        return this.to('CreateVault');
    }
    /**
     * Grants permission to delete an archive from a vault
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifArchiveAgeInDays()
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/api-archive-delete.html
     */
    toDeleteArchive() {
        return this.to('DeleteArchive');
    }
    /**
     * Grants permission to delete a vault
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/api-vault-delete.html
     */
    toDeleteVault() {
        return this.to('DeleteVault');
    }
    /**
     * Grants permission to delete the access policy associated with the specified vault
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/api-DeleteVaultAccessPolicy.html
     */
    toDeleteVaultAccessPolicy() {
        return this.to('DeleteVaultAccessPolicy');
    }
    /**
     * Grants permission to delete the notification configuration set for a vault
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/api-vault-notifications-delete.html
     */
    toDeleteVaultNotifications() {
        return this.to('DeleteVaultNotifications');
    }
    /**
     * Grants permission to get information about a job previously initiated
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/api-describe-job-get.html
     */
    toDescribeJob() {
        return this.to('DescribeJob');
    }
    /**
     * Grants permission to get information about a vault
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/api-vault-get.html
     */
    toDescribeVault() {
        return this.to('DescribeVault');
    }
    /**
     * Grants permission to get the data retrieval policy
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/api-GetDataRetrievalPolicy.html
     */
    toGetDataRetrievalPolicy() {
        return this.to('GetDataRetrievalPolicy');
    }
    /**
     * Grants permission to download the output of the job specified
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/api-job-output-get.html
     */
    toGetJobOutput() {
        return this.to('GetJobOutput');
    }
    /**
     * Grants permission to retrieve the access-policy subresource set on the vault
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/api-GetVaultAccessPolicy.html
     */
    toGetVaultAccessPolicy() {
        return this.to('GetVaultAccessPolicy');
    }
    /**
     * Grants permission to retrieve attributes from the lock-policy subresource set on the specified vault
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/api-GetVaultLock.html
     */
    toGetVaultLock() {
        return this.to('GetVaultLock');
    }
    /**
     * Grants permission to retrieve the notification-configuration subresource set on the vault
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/api-vault-notifications-get.html
     */
    toGetVaultNotifications() {
        return this.to('GetVaultNotifications');
    }
    /**
     * Grants permission to initiate a job of the specified type
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifArchiveAgeInDays()
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/api-initiate-job-post.html
     */
    toInitiateJob() {
        return this.to('InitiateJob');
    }
    /**
     * Grants permission to initiate a multipart upload
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/api-multipart-initiate-upload.html
     */
    toInitiateMultipartUpload() {
        return this.to('InitiateMultipartUpload');
    }
    /**
     * Grants permission to initiate the vault locking process
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/api-InitiateVaultLock.html
     */
    toInitiateVaultLock() {
        return this.to('InitiateVaultLock');
    }
    /**
     * Grants permission to list jobs for a vault that are in-progress and jobs that have recently finished
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/api-jobs-get.html
     */
    toListJobs() {
        return this.to('ListJobs');
    }
    /**
     * Grants permission to list in-progress multipart uploads for the specified vault
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/api-multipart-list-uploads.html
     */
    toListMultipartUploads() {
        return this.to('ListMultipartUploads');
    }
    /**
     * Grants permission to list the parts of an archive that have been uploaded in a specific multipart upload
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/api-multipart-list-parts.html
     */
    toListParts() {
        return this.to('ListParts');
    }
    /**
     * Grants permission to list the provisioned capacity for the specified AWS account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/api-ListProvisionedCapacity.html
     */
    toListProvisionedCapacity() {
        return this.to('ListProvisionedCapacity');
    }
    /**
     * Grants permission to list all the tags attached to a vault
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/api-ListTagsForVault.html
     */
    toListTagsForVault() {
        return this.to('ListTagsForVault');
    }
    /**
     * Grants permission to list all vaults
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/api-vaults-get.html
     */
    toListVaults() {
        return this.to('ListVaults');
    }
    /**
     * Grants permission to purchases a provisioned capacity unit for an AWS account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/api-PurchaseProvisionedCapacity.html
     */
    toPurchaseProvisionedCapacity() {
        return this.to('PurchaseProvisionedCapacity');
    }
    /**
     * Grants permission to remove one or more tags from the set of tags attached to a vault
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/api-RemoveTagsFromVault.html
     */
    toRemoveTagsFromVault() {
        return this.to('RemoveTagsFromVault');
    }
    /**
     * Grants permission to set and then enacts a data retrieval policy in the region specified in the PUT request
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/api-SetDataRetrievalPolicy.html
     */
    toSetDataRetrievalPolicy() {
        return this.to('SetDataRetrievalPolicy');
    }
    /**
     * Grants permission to configure an access policy for a vault; will overwrite an existing policy
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/api-SetVaultAccessPolicy.html
     */
    toSetVaultAccessPolicy() {
        return this.to('SetVaultAccessPolicy');
    }
    /**
     * Grants permission to configure vault notifications
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/api-vault-notifications-put.html
     */
    toSetVaultNotifications() {
        return this.to('SetVaultNotifications');
    }
    /**
     * Grants permission to upload an archive to a vault
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/api-archive-post.html
     */
    toUploadArchive() {
        return this.to('UploadArchive');
    }
    /**
     * Grants permission to upload a part of an archive
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/api-upload-part.html
     */
    toUploadMultipartPart() {
        return this.to('UploadMultipartPart');
    }
    /**
     * Adds a resource of type vault to the statement
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/working-with-vaults.html
     *
     * @param vaultName - Identifier for the vaultName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onVault(vaultName, account, region, partition) {
        return this.on(`arn:${partition || Glacier.defaultPartition}:glacier:${region || '*'}:${account || '*'}:vaults/${vaultName}`);
    }
    /**
     * Filters access by how long an archive has been stored in the vault, in days
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/access-control-overview.html#specifying-conditions
     *
     * Applies to actions:
     * - .toDeleteArchive()
     * - .toInitiateJob()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifArchiveAgeInDays(value, operator) {
        return this.if(`ArchiveAgeInDays`, value, operator || 'StringLike');
    }
    /**
     * Filters access by a customer-defined tag
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/access-control-overview.html#specifying-conditions
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifResourceTagExists(value, operator) {
        return this.if(`ResourceTag/`, value, operator || 'StringLike');
    }
}
exports.Glacier = Glacier;
_a = JSII_RTTI_SYMBOL_1;
Glacier[_a] = { fqn: "cdk-iam-floyd.Glacier", version: "0.374.0" };
//# sourceMappingURL=data:application/json;base64,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