import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [support](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssupport.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Support extends PolicyStatement {
    servicePrefix: string;
    /**
     * Adds one or more attachments to an AWS Support case.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_AddAttachmentsToSet.html
     */
    toAddAttachmentsToSet(): this;
    /**
     * Adds a customer communication to an AWS Support case.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_AddCommunicationToCase.html
     */
    toAddCommunicationToCase(): this;
    /**
     * Creates a new AWS Support case.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_CreateCase.html
     */
    toCreateCase(): this;
    /**
     * Returns the description for an attachment.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_DescribeAttachment.html
     */
    toDescribeAttachment(): this;
    /**
     * This is an internally managed function which allows secondary services to read AWS Support case attributes.
     *
     * Access Level: Read
     */
    toDescribeCaseAttributes(): this;
    /**
     * Returns a list of AWS Support cases that matches the given inputs.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_DescribeCases.html
     */
    toDescribeCases(): this;
    /**
     * Returns the communications and attachments for one or more AWS Support cases.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_DescribeCommunications.html
     */
    toDescribeCommunications(): this;
    /**
     * Returns issue types for AWS Support cases.
     *
     * Access Level: Read
     */
    toDescribeIssueTypes(): this;
    /**
     * Returns the current list of AWS services and categories that applies to each service.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_DescribeServices.html
     */
    toDescribeServices(): this;
    /**
     * Returns the list of severity levels that can be assigned to an AWS Support case.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_DescribeSeverityLevels.html
     */
    toDescribeSeverityLevels(): this;
    /**
     * Returns the support level for an AWS Account identifier.
     *
     * Access Level: Read
     */
    toDescribeSupportLevel(): this;
    /**
     * Returns the status of a Trusted Advisor refresh check based on a list of check identifiers.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_DescribeTrustedAdvisorCheckRefreshStatuses.html
     */
    toDescribeTrustedAdvisorCheckRefreshStatuses(): this;
    /**
     * Returns the results of the Trusted Advisor check that has the specified check identifier.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_DescribeTrustedAdvisorCheckResult.html
     */
    toDescribeTrustedAdvisorCheckResult(): this;
    /**
     * Returns the summaries of the results of the Trusted Advisor checks that have the specified check identifiers.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_DescribeTrustedAdvisorCheckSummaries.html
     */
    toDescribeTrustedAdvisorCheckSummaries(): this;
    /**
     * Returns a list of all available Trusted Advisor checks, including name, identifier, category and description.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_DescribeTrustedAdvisorChecks.html
     */
    toDescribeTrustedAdvisorChecks(): this;
    /**
     * This is an internally managed function to initiate a call on AWS Support Center.
     *
     * Access Level: Write
     */
    toInitiateCallForCase(): this;
    /**
     * This is an internally managed function to initiate a chat on AWS Support Center.
     *
     * Access Level: Write
     */
    toInitiateChatForCase(): this;
    /**
     * This is an internally managed function which allows secondary services to attach attributes to AWS Support cases.
     *
     * Access Level: Write
     */
    toPutCaseAttributes(): this;
    /**
     * Rate an AWS Support case communication.
     *
     * Access Level: Write
     */
    toRateCaseCommunication(): this;
    /**
     * Requests a refresh of the Trusted Advisor check that has the specified check identifier.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_RefreshTrustedAdvisorCheck.html
     */
    toRefreshTrustedAdvisorCheck(): this;
    /**
     * Resolves an AWS Support case.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_ResolveCase.html
     */
    toResolveCase(): this;
    /**
     * Returns a list of AWS Support cases that matches the given inputs.
     *
     * Access Level: Read
     */
    toSearchForCases(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Statement provider for service [support](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssupport.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
//# sourceMappingURL=support.d.ts.map