import { aws_iam as iam } from 'aws-cdk-lib';
/**
 * Base class for the Policy Statement
 */
export declare class PolicyStatementBase extends iam.PolicyStatement {
    /**
     * The default partition for ARNs (such as one of [aws, aws-us-gov, aws-cn]). In
     * CDK applications, this is a reference to the current partition, otherwise, 'aws'.
     */
    protected static readonly defaultPartition: string;
    /**
     * Holds the prefix of the service actions, e.g. `ec2`
     */
    servicePrefix: string;
}
//# sourceMappingURL=1-base.d.ts.map