"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PolicyStatementWithCDKPrincipal = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// @ts-ignore only available after swapping 1-base
const aws_cdk_lib_1 = require("aws-cdk-lib");
const _6_principals_1 = require("./6-principals");
/**
 * Adds CDK specific "principal" functionality to the Policy Statement
 */
class PolicyStatementWithCDKPrincipal extends _6_principals_1.PolicyStatementWithPrincipal {
    constructor() {
        super(...arguments);
        this.cdkPrincipals = [];
        this.cdkPrincipalsApplied = false;
    }
    /**
     * Adds any number of CDK principals to the statement
     * @param principals Principals to add to the statement
     */
    forCdkPrincipal(...principals) {
        this.skipAutoResource = true;
        this.cdkPrincipals.push(...principals);
        return this;
    }
    cdkApplyPrincipals() {
        if (!this.cdkPrincipalsApplied) {
            const mode = this.useNotPrincipals ? 'addNotPrincipals' : 'addPrincipals';
            // @ts-ignore only available after swapping 1-base
            this[mode](...this.cdkPrincipals);
            if (this.hasPrincipals()) {
                Object.keys(this.myPrincipals).forEach((prefix) => {
                    switch (prefix) {
                        case _6_principals_1.PrincipalType.AWS:
                            this.myPrincipals[prefix].forEach((arn) => {
                                // @ts-ignore only available after swapping 1-base
                                this[mode](new aws_cdk_lib_1.aws_iam.ArnPrincipal(arn));
                            });
                            break;
                        case _6_principals_1.PrincipalType.CANONICAL_USER:
                            this.myPrincipals[prefix].forEach((userId) => {
                                // @ts-ignore only available after swapping 1-base
                                this[mode](new aws_cdk_lib_1.aws_iam.CanonicalUserPrincipal(userId));
                            });
                            break;
                        case _6_principals_1.PrincipalType.FEDERATED:
                            this.myPrincipals[prefix].forEach((provider) => {
                                // @ts-ignore only available after swapping 1-base
                                this[mode](new aws_cdk_lib_1.aws_iam.FederatedPrincipal(provider, {}));
                            });
                            break;
                        case _6_principals_1.PrincipalType.SERVICE:
                            this.myPrincipals[prefix].forEach((service) => {
                                // @ts-ignore only available after swapping 1-base
                                this[mode](new aws_cdk_lib_1.aws_iam.ServicePrincipal(service));
                            });
                            break;
                        default:
                            throw Error(`Unhandled principal type: ${prefix}`);
                    }
                });
            }
            this.cdkPrincipalsApplied = true;
        }
    }
}
exports.PolicyStatementWithCDKPrincipal = PolicyStatementWithCDKPrincipal;
_a = JSII_RTTI_SYMBOL_1;
PolicyStatementWithCDKPrincipal[_a] = { fqn: "cdk-iam-floyd.PolicyStatementWithCDKPrincipal", version: "0.374.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiNy1wcmluY2lwYWxzLUNESy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIjctcHJpbmNpcGFscy1DREsudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFBQSxrREFBa0Q7QUFDbEQsNkNBQTZDO0FBRTdDLGtEQUE2RTtBQUU3RTs7R0FFRztBQUNILE1BQWEsK0JBQWdDLFNBQVEsNENBQTRCO0lBQWpGOztRQUNZLGtCQUFhLEdBQXFCLEVBQUUsQ0FBQztRQUN2Qyx5QkFBb0IsR0FBRyxLQUFLLENBQUM7S0FvRHRDO0lBbERDOzs7T0FHRztJQUNJLGVBQWUsQ0FBQyxHQUFHLFVBQTRCO1FBQ3BELElBQUksQ0FBQyxnQkFBZ0IsR0FBRyxJQUFJLENBQUM7UUFDN0IsSUFBSSxDQUFDLGFBQWEsQ0FBQyxJQUFJLENBQUMsR0FBRyxVQUFVLENBQUMsQ0FBQztRQUN2QyxPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7SUFFUyxrQkFBa0I7UUFDMUIsSUFBSSxDQUFDLElBQUksQ0FBQyxvQkFBb0IsRUFBRTtZQUM5QixNQUFNLElBQUksR0FBRyxJQUFJLENBQUMsZ0JBQWdCLENBQUMsQ0FBQyxDQUFDLGtCQUFrQixDQUFDLENBQUMsQ0FBQyxlQUFlLENBQUM7WUFDMUUsa0RBQWtEO1lBQ2xELElBQUksQ0FBQyxJQUFJLENBQUMsQ0FBQyxHQUFHLElBQUksQ0FBQyxhQUFhLENBQUMsQ0FBQztZQUNsQyxJQUFJLElBQUksQ0FBQyxhQUFhLEVBQUUsRUFBRTtnQkFDeEIsTUFBTSxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsWUFBWSxDQUFDLENBQUMsT0FBTyxDQUFDLENBQUMsTUFBTSxFQUFFLEVBQUU7b0JBQ2hELFFBQVEsTUFBTSxFQUFFO3dCQUNkLEtBQUssNkJBQWEsQ0FBQyxHQUFHOzRCQUNwQixJQUFJLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxDQUFDLE9BQU8sQ0FBQyxDQUFDLEdBQUcsRUFBRSxFQUFFO2dDQUN4QyxrREFBa0Q7Z0NBQ2xELElBQUksQ0FBQyxJQUFJLENBQUMsQ0FBQyxJQUFJLHFCQUFHLENBQUMsWUFBWSxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUM7NEJBQ3hDLENBQUMsQ0FBQyxDQUFDOzRCQUNILE1BQU07d0JBQ1IsS0FBSyw2QkFBYSxDQUFDLGNBQWM7NEJBQy9CLElBQUksQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLENBQUMsT0FBTyxDQUFDLENBQUMsTUFBTSxFQUFFLEVBQUU7Z0NBQzNDLGtEQUFrRDtnQ0FDbEQsSUFBSSxDQUFDLElBQUksQ0FBQyxDQUFDLElBQUkscUJBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxNQUFNLENBQUMsQ0FBQyxDQUFDOzRCQUNyRCxDQUFDLENBQUMsQ0FBQzs0QkFDSCxNQUFNO3dCQUNSLEtBQUssNkJBQWEsQ0FBQyxTQUFTOzRCQUMxQixJQUFJLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxDQUFDLE9BQU8sQ0FBQyxDQUFDLFFBQVEsRUFBRSxFQUFFO2dDQUM3QyxrREFBa0Q7Z0NBQ2xELElBQUksQ0FBQyxJQUFJLENBQUMsQ0FBQyxJQUFJLHFCQUFHLENBQUMsa0JBQWtCLENBQUMsUUFBUSxFQUFFLEVBQUUsQ0FBQyxDQUFDLENBQUM7NEJBQ3ZELENBQUMsQ0FBQyxDQUFDOzRCQUNILE1BQU07d0JBQ1IsS0FBSyw2QkFBYSxDQUFDLE9BQU87NEJBQ3hCLElBQUksQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLENBQUMsT0FBTyxDQUFDLENBQUMsT0FBTyxFQUFFLEVBQUU7Z0NBQzVDLGtEQUFrRDtnQ0FDbEQsSUFBSSxDQUFDLElBQUksQ0FBQyxDQUFDLElBQUkscUJBQUcsQ0FBQyxnQkFBZ0IsQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDOzRCQUNoRCxDQUFDLENBQUMsQ0FBQzs0QkFDSCxNQUFNO3dCQUNSOzRCQUNFLE1BQU0sS0FBSyxDQUFDLDZCQUE2QixNQUFNLEVBQUUsQ0FBQyxDQUFDO3FCQUN0RDtnQkFDSCxDQUFDLENBQUMsQ0FBQzthQUNKO1lBQ0QsSUFBSSxDQUFDLG9CQUFvQixHQUFHLElBQUksQ0FBQztTQUNsQztJQUNILENBQUM7O0FBckRILDBFQXNEQyIsInNvdXJjZXNDb250ZW50IjpbIi8vIEB0cy1pZ25vcmUgb25seSBhdmFpbGFibGUgYWZ0ZXIgc3dhcHBpbmcgMS1iYXNlXG5pbXBvcnQgeyBhd3NfaWFtIGFzIGlhbSB9IGZyb20gJ2F3cy1jZGstbGliJztcblxuaW1wb3J0IHsgUG9saWN5U3RhdGVtZW50V2l0aFByaW5jaXBhbCwgUHJpbmNpcGFsVHlwZSB9IGZyb20gJy4vNi1wcmluY2lwYWxzJztcblxuLyoqXG4gKiBBZGRzIENESyBzcGVjaWZpYyBcInByaW5jaXBhbFwiIGZ1bmN0aW9uYWxpdHkgdG8gdGhlIFBvbGljeSBTdGF0ZW1lbnRcbiAqL1xuZXhwb3J0IGNsYXNzIFBvbGljeVN0YXRlbWVudFdpdGhDREtQcmluY2lwYWwgZXh0ZW5kcyBQb2xpY3lTdGF0ZW1lbnRXaXRoUHJpbmNpcGFsIHtcbiAgcHJvdGVjdGVkIGNka1ByaW5jaXBhbHM6IGlhbS5JUHJpbmNpcGFsW10gPSBbXTtcbiAgcHJpdmF0ZSBjZGtQcmluY2lwYWxzQXBwbGllZCA9IGZhbHNlO1xuXG4gIC8qKlxuICAgKiBBZGRzIGFueSBudW1iZXIgb2YgQ0RLIHByaW5jaXBhbHMgdG8gdGhlIHN0YXRlbWVudFxuICAgKiBAcGFyYW0gcHJpbmNpcGFscyBQcmluY2lwYWxzIHRvIGFkZCB0byB0aGUgc3RhdGVtZW50XG4gICAqL1xuICBwdWJsaWMgZm9yQ2RrUHJpbmNpcGFsKC4uLnByaW5jaXBhbHM6IGlhbS5JUHJpbmNpcGFsW10pIHtcbiAgICB0aGlzLnNraXBBdXRvUmVzb3VyY2UgPSB0cnVlO1xuICAgIHRoaXMuY2RrUHJpbmNpcGFscy5wdXNoKC4uLnByaW5jaXBhbHMpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgcHJvdGVjdGVkIGNka0FwcGx5UHJpbmNpcGFscygpIHtcbiAgICBpZiAoIXRoaXMuY2RrUHJpbmNpcGFsc0FwcGxpZWQpIHtcbiAgICAgIGNvbnN0IG1vZGUgPSB0aGlzLnVzZU5vdFByaW5jaXBhbHMgPyAnYWRkTm90UHJpbmNpcGFscycgOiAnYWRkUHJpbmNpcGFscyc7XG4gICAgICAvLyBAdHMtaWdub3JlIG9ubHkgYXZhaWxhYmxlIGFmdGVyIHN3YXBwaW5nIDEtYmFzZVxuICAgICAgdGhpc1ttb2RlXSguLi50aGlzLmNka1ByaW5jaXBhbHMpO1xuICAgICAgaWYgKHRoaXMuaGFzUHJpbmNpcGFscygpKSB7XG4gICAgICAgIE9iamVjdC5rZXlzKHRoaXMubXlQcmluY2lwYWxzKS5mb3JFYWNoKChwcmVmaXgpID0+IHtcbiAgICAgICAgICBzd2l0Y2ggKHByZWZpeCkge1xuICAgICAgICAgICAgY2FzZSBQcmluY2lwYWxUeXBlLkFXUzpcbiAgICAgICAgICAgICAgdGhpcy5teVByaW5jaXBhbHNbcHJlZml4XS5mb3JFYWNoKChhcm4pID0+IHtcbiAgICAgICAgICAgICAgICAvLyBAdHMtaWdub3JlIG9ubHkgYXZhaWxhYmxlIGFmdGVyIHN3YXBwaW5nIDEtYmFzZVxuICAgICAgICAgICAgICAgIHRoaXNbbW9kZV0obmV3IGlhbS5Bcm5QcmluY2lwYWwoYXJuKSk7XG4gICAgICAgICAgICAgIH0pO1xuICAgICAgICAgICAgICBicmVhaztcbiAgICAgICAgICAgIGNhc2UgUHJpbmNpcGFsVHlwZS5DQU5PTklDQUxfVVNFUjpcbiAgICAgICAgICAgICAgdGhpcy5teVByaW5jaXBhbHNbcHJlZml4XS5mb3JFYWNoKCh1c2VySWQpID0+IHtcbiAgICAgICAgICAgICAgICAvLyBAdHMtaWdub3JlIG9ubHkgYXZhaWxhYmxlIGFmdGVyIHN3YXBwaW5nIDEtYmFzZVxuICAgICAgICAgICAgICAgIHRoaXNbbW9kZV0obmV3IGlhbS5DYW5vbmljYWxVc2VyUHJpbmNpcGFsKHVzZXJJZCkpO1xuICAgICAgICAgICAgICB9KTtcbiAgICAgICAgICAgICAgYnJlYWs7XG4gICAgICAgICAgICBjYXNlIFByaW5jaXBhbFR5cGUuRkVERVJBVEVEOlxuICAgICAgICAgICAgICB0aGlzLm15UHJpbmNpcGFsc1twcmVmaXhdLmZvckVhY2goKHByb3ZpZGVyKSA9PiB7XG4gICAgICAgICAgICAgICAgLy8gQHRzLWlnbm9yZSBvbmx5IGF2YWlsYWJsZSBhZnRlciBzd2FwcGluZyAxLWJhc2VcbiAgICAgICAgICAgICAgICB0aGlzW21vZGVdKG5ldyBpYW0uRmVkZXJhdGVkUHJpbmNpcGFsKHByb3ZpZGVyLCB7fSkpO1xuICAgICAgICAgICAgICB9KTtcbiAgICAgICAgICAgICAgYnJlYWs7XG4gICAgICAgICAgICBjYXNlIFByaW5jaXBhbFR5cGUuU0VSVklDRTpcbiAgICAgICAgICAgICAgdGhpcy5teVByaW5jaXBhbHNbcHJlZml4XS5mb3JFYWNoKChzZXJ2aWNlKSA9PiB7XG4gICAgICAgICAgICAgICAgLy8gQHRzLWlnbm9yZSBvbmx5IGF2YWlsYWJsZSBhZnRlciBzd2FwcGluZyAxLWJhc2VcbiAgICAgICAgICAgICAgICB0aGlzW21vZGVdKG5ldyBpYW0uU2VydmljZVByaW5jaXBhbChzZXJ2aWNlKSk7XG4gICAgICAgICAgICAgIH0pO1xuICAgICAgICAgICAgICBicmVhaztcbiAgICAgICAgICAgIGRlZmF1bHQ6XG4gICAgICAgICAgICAgIHRocm93IEVycm9yKGBVbmhhbmRsZWQgcHJpbmNpcGFsIHR5cGU6ICR7cHJlZml4fWApO1xuICAgICAgICAgIH1cbiAgICAgICAgfSk7XG4gICAgICB9XG4gICAgICB0aGlzLmNka1ByaW5jaXBhbHNBcHBsaWVkID0gdHJ1ZTtcbiAgICB9XG4gIH1cbn1cbiJdfQ==