# This file was auto-generated by Fern from our API Definition.

from ..core.pydantic_utilities import UniversalBaseModel
import typing
from .pdk_type import PdkType
from .pic_instance import PicInstance
from .net import Net
from .netlist_placements_value_value import NetlistPlacementsValueValue
from .bundle import Bundle
from .pic_warnings import PicWarnings
from ..core.pydantic_utilities import IS_PYDANTIC_V2
import pydantic


class Netlist(UniversalBaseModel):
    """
    Class to represent a PIC netlist
    """

    name: typing.Optional[str] = None
    pdk_type: typing.Optional[PdkType] = None
    instances: typing.Optional[typing.Dict[str, PicInstance]] = None
    nets: typing.Optional[typing.List[Net]] = None
    ports: typing.Optional[typing.Dict[str, str]] = None
    placements: typing.Optional[typing.Dict[str, typing.Dict[str, NetlistPlacementsValueValue]]] = None
    routes: typing.Optional[typing.Dict[str, Bundle]] = None
    warnings: typing.Optional[PicWarnings] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
