# This file was auto-generated by Fern from our API Definition.

from ..core.pydantic_utilities import UniversalBaseModel
import typing
import pydantic
from .computation import Computation
from ..core.pydantic_utilities import IS_PYDANTIC_V2


class Z3Expression(UniversalBaseModel):
    """
    The model for a Z3 expression.
    """

    type: typing.Optional[typing.Literal["Z3_EXPRESSION"]] = None
    code: str = pydantic.Field()
    """
    A string with the z3 expression.
    """

    default_tolerance: typing.Optional[float] = pydantic.Field(default=None)
    """
    The tolerance to be used when comparing the expression with a value.
    """

    mapping: typing.Optional[typing.Dict[str, typing.Optional[Computation]]] = pydantic.Field(default=None)
    """
    A mapping of the variables used in the expression to Computations.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
