# -*- coding: utf-8 -*-
"""
TencentBlueKing is pleased to support the open source community by making
蓝鲸智云 - PaaS 平台 (BlueKing - PaaS System) available.
Copyright (C) 2017 THL A29 Limited, a Tencent company. All rights reserved.
Licensed under the MIT License (the "License"); you may not use this file except
in compliance with the License. You may obtain a copy of the License at

    http://opensource.org/licenses/MIT

Unless required by applicable law or agreed to in writing, software distributed under
the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
either express or implied. See the License for the specific language governing permissions and
limitations under the License.

We undertake not to change the open source license (MIT license) applicable
to the current version of the project delivered to anyone in the future.
"""
# Generated by Django 1.11.16 on 2019-03-25 11:28
from __future__ import unicode_literals

import uuid

import django.db.models.deletion
import jsonfield.fields
from django.db import migrations, models

import blue_krill.models.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name='Plan',
            fields=[
                (
                    'uuid',
                    models.UUIDField(
                        auto_created=True,
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                        unique=True,
                        verbose_name='UUID',
                    ),
                ),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('updated', models.DateTimeField(auto_now=True)),
                ('name', models.CharField(max_length=64, verbose_name='方案名称')),
                ('properties', jsonfield.fields.JSONField(default={})),
                ('description', models.CharField(blank=True, max_length=1024, verbose_name='方案简介')),
                ('config', blue_krill.models.fields.EncryptField(default='', verbose_name='方案配置')),
                ('is_active', models.BooleanField(default=True, verbose_name='是否可用')),
            ],
        ),
        migrations.CreateModel(
            name='ResourceId',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('namespace', models.CharField(max_length=32)),
                ('uid', models.CharField(db_index=True, max_length=64, unique=True)),
            ],
        ),
        migrations.CreateModel(
            name='Service',
            fields=[
                (
                    'uuid',
                    models.UUIDField(
                        auto_created=True,
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                        unique=True,
                        verbose_name='UUID',
                    ),
                ),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('updated', models.DateTimeField(auto_now=True)),
                ('name', models.CharField(max_length=64, unique=True, verbose_name='服务名称')),
                ('category', models.IntegerField(verbose_name='服务分类')),
                ('display_name', models.CharField(max_length=128, verbose_name='服务全称')),
                ('logo', models.URLField(blank=True, null=True, verbose_name='服务 logo 地址')),
                ('description', models.CharField(blank=True, max_length=1024, verbose_name='简介')),
                ('long_description', models.TextField(blank=True, verbose_name='详细介绍')),
                ('instance_tutorial', models.TextField(blank=True, verbose_name='实例内页介绍')),
                (
                    'available_languages',
                    models.CharField(blank=True, max_length=1024, null=True, verbose_name='支持编程语言'),
                ),
                ('config', jsonfield.fields.JSONField(default={})),
                ('is_active', models.BooleanField(default=True, verbose_name='是否可用')),
                ('is_visible', models.BooleanField(default=True, verbose_name='是否可见')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ServiceInstance',
            fields=[
                (
                    'uuid',
                    models.UUIDField(
                        auto_created=True,
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                        unique=True,
                        verbose_name='UUID',
                    ),
                ),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('updated', models.DateTimeField(auto_now=True)),
                ('config', jsonfield.fields.JSONField(default={})),
                ('credentials', blue_krill.models.fields.EncryptField(default='')),
                ('plan', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='paas_service.Plan')),
                ('service', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='paas_service.Service')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.AlterUniqueTogether(
            name='resourceid',
            unique_together=set([('namespace', 'uid')]),
        ),
        migrations.AddField(
            model_name='plan',
            name='service',
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE, related_name='plans', to='paas_service.Service'
            ),
        ),
        migrations.AlterUniqueTogether(
            name='plan',
            unique_together=set([('service', 'name')]),
        ),
    ]
