# -*- coding: utf-8 -*-
"""
TencentBlueKing is pleased to support the open source community by making
蓝鲸智云 - PaaS 平台 (BlueKing - PaaS System) available.
Copyright (C) 2017 THL A29 Limited, a Tencent company. All rights reserved.
Licensed under the MIT License (the "License"); you may not use this file except
in compliance with the License. You may obtain a copy of the License at

    http://opensource.org/licenses/MIT

Unless required by applicable law or agreed to in writing, software distributed under
the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
either express or implied. See the License for the specific language governing permissions and
limitations under the License.

We undertake not to change the open source license (MIT license) applicable
to the current version of the project delivered to anyone in the future.
"""
# Generated by Django 1.11.20 on 2020-01-03 04:09
from __future__ import unicode_literals

import uuid

import django.db.models.deletion
import jsonfield.fields
from django.db import migrations, models

import blue_krill.models.fields


class Migration(migrations.Migration):

    dependencies = [
        ('paas_service', '0002_serviceinstance_need_to_delete'),
    ]

    operations = [
        migrations.CreateModel(
            name='SpecDefinition',
            fields=[
                (
                    'uuid',
                    models.UUIDField(
                        auto_created=True,
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                        unique=True,
                        verbose_name='UUID',
                    ),
                ),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('updated', models.DateTimeField(auto_now=True)),
                ('index', models.IntegerField(default=0, verbose_name='顺序')),
                ('name', models.CharField(max_length=64, null=True, unique=True, verbose_name='名称')),
                ('display_name', models.CharField(blank=True, max_length=128, verbose_name='展示名称')),
                ('description', models.TextField(blank=True, verbose_name='描述')),
                ('recommended_value', models.CharField(blank=True, max_length=64, null=True, verbose_name='推荐值')),
            ],
            options={
                'verbose_name': '规格定义',
                'verbose_name_plural': '规格定义',
                'ordering': ['index', 'name'],
            },
        ),
        migrations.CreateModel(
            name='Specification',
            fields=[
                (
                    'uuid',
                    models.UUIDField(
                        auto_created=True,
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                        unique=True,
                        verbose_name='UUID',
                    ),
                ),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('updated', models.DateTimeField(auto_now=True)),
                ('value', models.CharField(max_length=64, verbose_name='值')),
                ('display_name', models.CharField(blank=True, max_length=64, verbose_name='展示名称')),
                (
                    'definition',
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to='paas_service.SpecDefinition',
                        verbose_name='定义',
                    ),
                ),
            ],
            options={
                'verbose_name': '规格',
                'verbose_name_plural': '规格',
            },
        ),
        migrations.AlterModelOptions(
            name='plan',
            options={'verbose_name': '方案', 'verbose_name_plural': '方案'},
        ),
        migrations.AlterModelOptions(
            name='service',
            options={'verbose_name': '服务', 'verbose_name_plural': '服务'},
        ),
        migrations.AlterModelOptions(
            name='serviceinstance',
            options={'verbose_name': '服务实例', 'verbose_name_plural': '服务实例'},
        ),
        migrations.AlterField(
            model_name='plan',
            name='config',
            field=blue_krill.models.fields.EncryptField(blank=True, default='', verbose_name='方案配置'),
        ),
        migrations.AlterField(
            model_name='plan',
            name='properties',
            field=jsonfield.fields.JSONField(blank=True, default=dict),
        ),
        migrations.AlterField(
            model_name='plan',
            name='service',
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name='plans',
                to='paas_service.Service',
                verbose_name='服务',
            ),
        ),
        migrations.AlterField(
            model_name='service',
            name='config',
            field=jsonfield.fields.JSONField(blank=True, default=dict),
        ),
        migrations.AlterField(
            model_name='serviceinstance',
            name='config',
            field=jsonfield.fields.JSONField(blank=True, default=dict),
        ),
        migrations.AlterField(
            model_name='serviceinstance',
            name='plan',
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE, to='paas_service.Plan', verbose_name='方案'
            ),
        ),
        migrations.AlterField(
            model_name='serviceinstance',
            name='service',
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE, to='paas_service.Service', verbose_name='服务'
            ),
        ),
        migrations.AddField(
            model_name='plan',
            name='specifications',
            field=models.ManyToManyField(blank=True, to='paas_service.Specification', verbose_name='规格'),
        ),
        migrations.AddField(
            model_name='service',
            name='specifications',
            field=models.ManyToManyField(blank=True, to='paas_service.SpecDefinition', verbose_name='规格定义'),
        ),
        migrations.AlterUniqueTogether(
            name='specification',
            unique_together=set([('definition', 'value')]),
        ),
    ]
