# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['linkding_cli',
 'linkding_cli.commands',
 'linkding_cli.helpers',
 'linkding_cli.util']

package_data = \
{'': ['*']}

install_requires = \
['aiolinkding>=2022.7.0',
 'ruamel.yaml>=0.17.21,<0.18.0',
 'typer[all]>=0.4.1,<0.5.0']

entry_points = \
{'console_scripts': ['linkding = linkding_cli.cli:APP']}

setup_kwargs = {
    'name': 'linkding-cli',
    'version': '2022.7.0',
    'description': 'A CLI to interact with a linkding instance',
    'long_description': '# 🔖 linkding-cli: A CLI to interact with a linkding instance\n\n[![CI](https://github.com/bachya/linkding-cli/workflows/CI/badge.svg)](https://github.com/bachya/linkding-cli/actions)\n[![PyPi](https://img.shields.io/pypi/v/linkding-cli.svg)](https://pypi.python.org/pypi/linkding-cli)\n[![Version](https://img.shields.io/pypi/pyversions/linkding-cli.svg)](https://pypi.python.org/pypi/linkding-cli)\n[![License](https://img.shields.io/pypi/l/linkding-cli.svg)](https://github.com/bachya/linkding-cli/blob/master/LICENSE)\n[![Code Coverage](https://codecov.io/gh/bachya/linkding-cli/branch/master/graph/badge.svg)](https://codecov.io/gh/bachya/linkding-cli)\n[![Maintainability](https://api.codeclimate.com/v1/badges/f01be3cd230902508636/maintainability)](https://codeclimate.com/github/bachya/linkding-cli/maintainability)\n[![Say Thanks](https://img.shields.io/badge/SayThanks-!-1EAEDB.svg)](https://saythanks.io/to/bachya)\n\n`linkding-cli` is a CLI to interact with a\n[linkding](https://github.com/sissbruecker/linkding) instance.\n\n- [Installation](#installation)\n- [Python Versions](#python-versions)\n- [Usage](#usage)\n  * [Main Help](#main-help)\n  * [Configuration](#configuration)\n    + [Example: CLI Options](#example--cli-options)\n    + [Example: Environment Variables](#example--environment-variables)\n    + [Example: Configuration File](#example--configuration-file)\n    + [Merging Configuration Options](#merging-configuration-options)\n  * [Bookmarks](#bookmarks)\n    + [The `bookmarks all` command](#the-bookmarks-all-command)\n    + [The `bookmarks archive` command](#the-bookmarks-archive-command)\n    + [The `bookmarks create` command](#the-bookmarks-create-command)\n    + [The `bookmarks delete` command](#the-bookmarks-delete-command)\n    + [The `bookmarks get` command](#the-bookmarks-get-command)\n    + [The `bookmarks unarchive` command](#the-bookmarks-unarchive-command)\n    + [The `bookmarks update` command](#the-bookmarks-update-command)\n  * [Tags](#tags)\n    + [The `tags all` command](#the-tags-all-command)\n    + [The `tags create` command](#the-tags-create-command)\n    + [The `tags get` command](#the-tags-get-command)\n  * [Misc.](#misc)\n    + [Parsing and Pretty Printing Data](#parsing-and-pretty-printing-data)\n- [Contributing](#contributing)\n\n# Installation\n\n```python\npip install linkding-cli\n```\n\n# Python Versions\n\n`linkding-cli` is currently supported on:\n\n* Python 3.8\n* Python 3.9\n* Python 3.10\n\n# Usage\n\n## Main Help\n\n```\n$ linkding --help\nUsage: linkding [OPTIONS] COMMAND [ARGS]...\n\n  Interact with a linkding instance.\n\nOptions:\n  -c, --config PATH     A path to a config file.  [env var: LINKDING_CONFIG]\n  -t, --token TOKEN     A linkding API token.  [env var: LINKDING_TOKEN]\n  -u, --url URL         A URL to a linkding instance.  [env var: LINKDING_URL]\n  -v, --verbose         Increase verbosity of standard output.\n  --install-completion  Install completion for the current shell.\n  --show-completion     Show completion for the current shell, to copy it or\n                        customize the installation.\n  --help                Show this message and exit.\n\nCommands:\n  bookmarks  Work with bookmarks.\n  tags       Work with tags.\n  ```\n\n## Configuration\n\nConfiguration can be provided via a variety of sources:\n\n* CLI Options\n* Environment Variables\n* Configuration File\n\n### Example: CLI Options\n\n```\n$ linkding -u http://127.0.0.1:8000 -t abcde12345 ...\n```\n\n### Example: Environment Variables\n\n```\n$ LINKDING_URL=http://127.0.0.1:8000 LINKDING_TOKEN=abcde12345 linkding ...\n```\n\n### Example: Configuration File\n\nThe configuration file can be formatted as either JSON:\n\n```json\n{\n  "token": "abcde12345",\n  "url": "http://127.0.0.1:8000",\n  "verbose": false\n}\n```\n\n...or YAML\n\n```yaml\n---\ntoken: "abcde12345"\nurl: "http://127.0.0.1:8000"\nverbose: false\n```\n\nThen, the linkding file can be provided via either `-c` or `--config`.\n\n```\n$ linkding -c ~/.config/linkding.json ...\n```\n\n### Merging Configuration Options\n\nWhen parsing configuration options, `linkding-cli` looks at the configuration sources in\nthe following order:\n\n1. Configuration File\n2. Environment Variables\n3. CLI Options\n\nThis allows you to mix and match sources – for instance, you might have "defaults" in\nthe configuration file and override them via environment variables.\n\n## Bookmarks\n\n```\nUsage: linkding bookmarks [OPTIONS] COMMAND [ARGS]...\n\n  Work with bookmarks.\n\nOptions:\n  --help  Show this message and exit.\n\nCommands:\n  all        Get all bookmarks.\n  archive    Archive a bookmark by its linkding ID.\n  create     Create a bookmark.\n  delete     Delete a bookmark by its linkding ID.\n  get        Get a bookmark by its linkding ID.\n  unarchive  Unarchive a bookmark by its linkding ID.\n  update     Update a bookmark by its linkding ID.\n  ```\n\n### The `bookmarks all` command\n\n```\nUsage: linkding bookmarks all [OPTIONS]\n\n  Get all bookmarks.\n\nOptions:\n  -a, --archived        Return archived bookmarks.\n  -l, --limit INTEGER   The number of bookmarks to return.\n  -o, --offset INTEGER  The index from which to return results.\n  -q, --query TEXT      Return bookmarks containing a query string.\n  --help                Show this message and exit.\n  ```\n\n#### Examples:\n\n```sh\n# Get all bookmarks, but limit the results to 10:\n$ linkding bookmarks all --limit 10\n\n# Get all archived bookmarks that contain "software":\n$ linkding bookmarks all --archived --query software\n```\n\n### The `bookmarks archive` command\n\n```\nUsage: linkding bookmarks archive [OPTIONS] [BOOKMARK_ID]\n\n  Archive a bookmark by its linkding ID.\n\nArguments:\n  [BOOKMARK_ID]  The ID of a bookmark to archive.\n\nOptions:\n  --help  Show this message and exit.\n  ```\n\n#### Examples:\n\n```sh\n# Archive bookmark 12:\n$ linkding bookmarks archive 12\n```\n\n### The `bookmarks create` command\n\n```\nUsage: linkding bookmarks create [OPTIONS] URL\n\n  Create a bookmark.\n\nArguments:\n  URL  The URL to bookmark.  [required]\n\nOptions:\n  -a, --archived                 Whether the newly-created bookmark should be\n                                 immediately archived.\n  -d, --description DESCRIPTION  The description to give the bookmark.\n  --tags TAG1,TAG2,...           The tags to apply to the bookmark.\n  -t, --title TITLE              The title to give the bookmark.\n  -u, --unread                   Whether the newly-created bookmark should be\n                                 marked as unread.\n  --help                         Show this message and exit.\n  ```\n\n#### Examples:\n\n```sh\n# Create a bookmark:\n$ linkding bookmarks create https://example.com\n\n# Create a bookmark and immeditely archive it:\n$ linkding bookmarks create -a https://example.com\n\n# Create a bookmark with title, description, and tags:\n$ linkding bookmarks create https://example.com -t Example -d "A description" --tags tag1,tag2\n```\n\n### The `bookmarks delete` command\n\n```\nUsage: linkding bookmarks delete [OPTIONS] [BOOKMARK_ID]\n\n  Delete a bookmark by its linkding ID.\n\nArguments:\n  [BOOKMARK_ID]  The ID of a bookmark to delete.\n\nOptions:\n  --help  Show this message and exit.\n  ```\n\n#### Examples:\n\n```sh\n# Delete the bookmark with an ID of 12:\n$ linkding bookmarks delete 12\n```\n\n### The `bookmarks get` command\n\n```\nUsage: linkding bookmarks get [OPTIONS] [BOOKMARK_ID]\n\n  Get a bookmark by its linkding ID.\n\nArguments:\n  [BOOKMARK_ID]  The ID of a bookmark to retrieve.\n\nOptions:\n  --help  Show this message and exit.\n  ```\n\n#### Examples:\n\n```sh\n# Get bookmark 12:\n$ linkding bookmarks get 12\n```\n\n### The `bookmarks unarchive` command\n\n```\nUsage: linkding bookmarks unarchive [OPTIONS] [BOOKMARK_ID]\n\n  Unarchive a bookmark by its linkding ID.\n\nArguments:\n  [BOOKMARK_ID]  The ID of a bookmark to unarchive.\n\nOptions:\n  --help  Show this message and exit.\n  ```\n\n#### Examples:\n\n```sh\n# Unarchive bookmark 12:\n$ linkding bookmarks unarchive 12\n```\n\n### The `bookmarks update` command\n\n```\nUsage: linkding bookmarks update [OPTIONS] BOOKMARK_ID\n\n  Update a bookmark by its linkdingn ID.\n\nArguments:\n  BOOKMARK_ID  The ID of a bookmark to update.  [required]\n\nOptions:\n  -u, --url URL                  The URL to assign to the bookmark.\n  -d, --description DESCRIPTION  The description to give the bookmark.\n  --tags TAG1,TAG2,...           The tags to apply to the bookmark.\n  -t, --title TITLE              The title to give the bookmark.\n  -u, --unread                   Whether the bookmark should be marked as\n                                 unread.\n  --help                         Show this message and exit.\n  ```\n\n#### Examples:\n\n```sh\n# Update a bookmark with a new url:\n$ linkding bookmarks update 12 -u https://example.com\n\n# Update a bookmark with title, description, and tags:\n$ linkding bookmarks update 12 -t Example -d "A description" --tags tag1,tag2\n```\n\n## Tags\n\n```\nUsage: linkding tags [OPTIONS] COMMAND [ARGS]...\n\n  Work with tags.\n\nOptions:\n  --help  Show this message and exit.\n\nCommands:\n  all     Get all tags.\n  create  Create a tag.\n  get     Get a tag by its linkding ID.\n  ```\n\n### The `tags all` command\n\n```\nUsage: linkding tags all [OPTIONS]\n\n  Get all tags.\n\nOptions:\n  -l, --limit INTEGER   The number of tags to return.\n  -o, --offset INTEGER  The index from which to return results.\n  --help                Show this message and exit.\n  ```\n\n#### Examples:\n\n```sh\n# Get all tags, but limit the results to 10:\n$ linkding tags all --limit 10\n```\n\n### The `tags create` command\n\n```\nUsage: linkding tags create [OPTIONS] TAG_NAME\n\n  Create a tag.\n\nArguments:\n  TAG_NAME  The tag to create.  [required]\n\nOptions:\n  --help  Show this message and exit.\n  ```\n\n#### Examples:\n\n```sh\n# Create a tag:\n$ linkding tags create sample-tag\n```\n\n### The `tags get` command\n\n```\nUsage: linkding tags get [OPTIONS] TAG_ID\n\n  Get a tag by its linkding ID.\n\nArguments:\n  TAG_ID  The ID of a tag to retrieve.  [required]\n\nOptions:\n  --help  Show this message and exit.\n  ```\n\n#### Examples:\n\n```sh\n# Get tag 12:\n$ linkding tags get 12\n```\n\n## Misc.\n\n### Parsing and Pretty Printing Data\n\n`linkding-cli` doesn\'t have built-in utilities for modifying JSON output in any way.\nInstead, it\'s recommended to use a tool like [`jq`](https://stedolan.github.io/jq/).\nThis allows for multiple new outcomes, like pretty-printing:\n\n```\n$ linkding bookmarks all | jq\n{\n  "count": 123,\n  "next": "http://127.0.0.1:8000/api/bookmarks/?limit=100&offset=100",\n  "previous": null,\n  "results": [\n    {\n      "id": 1,\n      "url": "https://example.com",\n      "title": "Example title",\n      "description": "Example description",\n      "website_title": "Website title",\n      "website_description": "Website description",\n      "tag_names": [\n        "tag1",\n        "tag2"\n      ],\n      "date_added": "2020-09-26T09:46:23.006313Z",\n      "date_modified": "2020-09-26T16:01:14.275335Z"\n    }\n  ]\n}\n```\n\n...and slicing/parsing data:\n\n```\n$ linkding bookmarks all | jq \'.results[0].title\'\n"Example title"\n```\n\n# Contributing\n\n1. [Check for open features/bugs](https://github.com/bachya/linkding-cli/issues)\n  or [initiate a discussion on one](https://github.com/bachya/linkding-cli/issues/new).\n2. [Fork the repository](https://github.com/bachya/linkding-cli/fork).\n3. (_optional, but highly recommended_) Create a virtual environment: `python3 -m venv .venv`\n4. (_optional, but highly recommended_) Enter the virtual environment: `source ./.venv/bin/activate`\n5. Install the dev environment: `script/setup`\n6. Code your new feature or bug fix.\n7. Write tests that cover your new functionality.\n8. Run tests and ensure 100% code coverage: `nox -rs coverage`\n9. Update `README.md` with any new documentation.\n10. Add yourself to `AUTHORS.md`.\n11. Submit a pull request!\n',
    'author': 'Aaron Bach',
    'author_email': 'bachya1208@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/bachya/linkding-cli',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.8.0,<4.0.0',
}


setup(**setup_kwargs)
