# coding: utf-8
"""
    Seeq REST API

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)  # noqa: E501

    OpenAPI spec version: 66.37.0-v202508200810-CD
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""
from __future__ import absolute_import

import json
import mimetypes
import os
import random
import re
import sys
import tempfile
import threading
import time
import uuid
from datetime import date, datetime, timedelta

# python 2 and python 3 compatibility library
from six import PY3, integer_types, iteritems, text_type, binary_type, reraise
from six.moves.urllib.parse import quote
from urllib3.exceptions import *

from . import models
from .configuration import ClientConfiguration
from .rest import ApiException, RESTClientObject


class ApiClient(object):
    """
    Generic API client for Swagger client library builds.

    Swagger generic API client. This client handles the client-
    server communication, and is invariant across implementations. Specifics of
    the methods and models for each application are generated from the Swagger
    templates.

    NOTE: This class is auto generated by the swagger code generator program.
    Ref: https://github.com/swagger-api/swagger-codegen
    Do not edit the class manually.

    :param host: The base path for the server to call.
    :param header_name: a header to pass when making calls to the API.
    :param header_value: a header value to pass when making calls to the API.
    """

    PRIMITIVE_TYPES = (float, bool, binary_type, text_type) + integer_types
    NATIVE_TYPES_MAPPING = {
        'int': int,
        'long': int if PY3 else long,
        'float': float,
        'str': str,
        'bool': bool,
        'date': date,
        'datetime': datetime,
        'object': object,
    }

    def __init__(self, host=None, header_name=None, header_value=None, cookie=None, configuration=None):
        """
        Constructor of the class.
        """
        self.configuration = configuration if configuration is not None else ClientConfiguration.get_default_instance()
        self.rest_client = RESTClientObject(self.configuration)
        self.default_headers = {}
        if header_name is not None:
            self.default_headers[header_name] = header_value
        if host is None:
            self.host = self.configuration.host
        else:
            self.host = host
        self.cookie = cookie
        # Set default User-Agent.
        self.user_agent = 'Swagger-Codegen/66.37.0/python'
        self.auth_token = None
        self.identity_path = None
        self.csrf_token = None

    @property
    def user_agent(self):
        """
        Gets user agent.
        """
        return self.default_headers['User-Agent']

    @user_agent.setter
    def user_agent(self, value):
        """
        Sets user agent.
        """
        self.default_headers['User-Agent'] = value

    def set_default_header(self, header_name, header_value):
        self.default_headers[header_name] = header_value

    def __call_api(self, resource_path, method,
                   path_params=None, query_params=None, header_params=None,
                   body=None, post_params=None, files=None,
                   response_type=None, auth_settings=None, callback=None,
                   _return_http_data_only=None, collection_formats=None, _preload_content=True,
                   _request_timeout=None):

        config = self.configuration

        # header parameters
        header_params = header_params or {}
        header_params.update(self.default_headers)
        if self.cookie:
            header_params['Cookie'] = self.cookie
        # Add authorization header, if we have an authorization token
        self.add_authorization_header(header_params)
        if header_params:
            header_params = self.sanitize_for_serialization(header_params)
            header_params = dict(self.parameters_to_tuples(header_params,
                                                           collection_formats))

        # path parameters
        if path_params:
            path_params = self.sanitize_for_serialization(path_params)
            path_params = self.parameters_to_tuples(path_params,
                                                    collection_formats)
            for k, v in path_params:
                # specified safe chars, encode everything
                resource_path = resource_path.replace(
                    '{%s}' % k, quote(str(v), safe=config.safe_chars_for_path_param))

        # query parameters
        if query_params:
            query_params = self.sanitize_for_serialization(query_params)
            query_params = self.parameters_to_tuples(query_params,
                                                     collection_formats)

        # post parameters
        if post_params or files:
            post_params = self.prepare_post_parameters(post_params, files)
            post_params = self.sanitize_for_serialization(post_params)
            post_params = self.parameters_to_tuples(post_params,
                                                    collection_formats)

        # auth setting
        self.update_params_for_auth(header_params, query_params, auth_settings)

        # body
        if body:
            body = self.sanitize_for_serialization(body)

        # request url
        url = self.host + resource_path

        retry_timeout = float(config.retry_timeout_in_seconds)
        retry_start = None
        retry_count = 0
        sleep_window_min = retry_timeout / 20.0
        sleep_window_max = retry_timeout / 10.0

        while True:
            try:
                # perform request and return response
                response_data = self.request(method, url,
                                             query_params=query_params,
                                             headers=header_params,
                                             post_params=post_params, body=body,
                                             _preload_content=_preload_content,
                                             _request_timeout=_request_timeout)

                break

            except (HTTPError, ApiException) as e:
                if retry_start is None:
                    retry_start = time.time()

                time_left = max(0.0, retry_timeout - (time.time() - retry_start))
                timed_out = (time_left <= 0.0)

                #
                # The following set of clauses is explicit (and therefore not very compact, code-wise) so that
                # it's easy to tell from a stack trace which reason we had for raising an exception.
                #

                # We retry on potentially transient network/socket errors, as determined by inspecting
                # the slate of exceptions possible in urllib3/exceptions.py
                if isinstance(e, (MaxRetryError, TimeoutError)):
                    if timed_out:
                        if hasattr(e, 'reason') and isinstance(e.reason, ConnectTimeoutError):
                            reason = "The Seeq Server is unavailable."
                        else:
                            reason = "The Seeq Server took too long to respond."
                        msg = ("Request timed out for Seeq API call: {0}\n"
                               "API call: {1} {2}\n\n"
                               "Current timeout settings:\n"
                               "---------------------------------\n"
                               "request_timeout_in_seconds: {3}\n"
                               "retry_timeout_in_seconds:   {4}\n\n"
                               "If you are using SPy, you can set these timeouts via spy.options. Call "
                               "spy.options.help() for more information.\n"
                               "If you are using the Seeq Python SDK (without SPy), you must set these options on the "
                               "api_client.configuration object.\n\n"
                               "Internal exception information:\n"
                               "{5}".format(reason, method, url,
                                            self.configuration.request_timeout_in_seconds,
                                            self.configuration.retry_timeout_in_seconds,
                                            str(e)))
                        raise ApiException(status=408, reason=msg)

                elif isinstance(e, ApiException):

                    # 409 "Conflict" can happen due to CRAB-28592.
                    # 502 "Bad Gateway" can happen due to Cloudflare issues.
                    # 504 "Gateway Timeout" can happen due to a bug in Grizzly.
                    retry_statuses = {409, 502, 504}

                    if e.status in retry_statuses:
                        if timed_out:
                            new_reason = (str(e.reason) + ' (Retried ' + str(retry_count) + ' times in ' +
                                          str(config.retry_timeout_in_seconds) + ' seconds)')
                            e.reason = new_reason
                            raise e

                    else:
                        reraise(*sys.exc_info())
                else:
                    reraise(*sys.exc_info())

                retry_count += 1

            # Wait random amount of time (within an exponentially-backing-off window)
            # in an attempt to de-conflict with other calls
            time.sleep(min(time_left, random.uniform(sleep_window_min, sleep_window_max)))
            sleep_window_min *= 2.0
            sleep_window_max *= 2.0

        self.last_response = response_data

        self.extract_authorization_token(response_data)
        self.extract_identity_path(response_data)
        self.extract_csrf_token(response_data)

        return_data = response_data
        if _preload_content:
            # deserialize response data
            if response_type:
                return_data = self.deserialize(response_data, response_type)
            else:
                return_data = None

        if callback:
            if _return_http_data_only:
                callback(return_data)
            else:
                callback((return_data, response_data.status, response_data.headers))
        elif _return_http_data_only:
            return (return_data)
        else:
            return (return_data, response_data.status, response_data.headers)

    def extract_authorization_token(self, response):
        """
        Extracts the authorization token from response headers, if it exists, and stores it for subsequent requests.

        :param response_headers: Map of response headers
        """
        if response.headers.get('x-sq-auth'):
            # If response header contains an updated authorization token, extract and store it for subsequent requests
            self.auth_token = response.headers.get('x-sq-auth')

    def extract_identity_path(self, response):
        """
        Extracts the identity path from response headers, if it exists, and stores it for subsequent requests.

        :param response_headers: Map of response headers
        """
        if response.headers.get('x-sq-identity-path'):
            # If response header contains an updated identity path, extract and store it for subsequent requests
            self.identity_path = response.headers.get('x-sq-identity-path')

    def extract_csrf_token(self, response):
        """
        Extracts the CSRF token from response headers, if it exists, and stores it for subsequent requests.

        :param response_headers: Map of response headers
        """
        if response.headers.get('x-sq-csrf'):
            # If response header contains an updated CSRF token, extract and store it for subsequent requests
            self.csrf_token = response.headers.get('x-sq-csrf')

    def add_authorization_header(self, request_headers):
        """
        Adds authorization headers to the specified map if they are available.

        :param request_headers: Map of request headers
        """
        if self.auth_token:
            request_headers['x-sq-auth'] = self.auth_token
        if self.identity_path:
            request_headers['x-sq-identity-path'] = self.identity_path

    def logout(self):
        self.auth_token = None
        self.identity_path = None
        self.csrf_token = None

    def sanitize_for_serialization(self, obj):
        """
        Builds a JSON POST object.

        If obj is None, return None.
        If obj is str, int, long, float, bool, return directly.
        If obj is datetime.datetime, datetime.date
            convert to string in iso8601 format.
        If obj is list, sanitize each element in the list.
        If obj is dict, return the dict.
        If obj is swagger model, return the properties dict.

        :param obj: The data to serialize.
        :return: The serialized form of data.
        """
        if obj is None:
            return None
        elif isinstance(obj, text_type) and not PY3:
            # SEEQ-NOTE:
            # Python 2 libraries expect to receive binary_type objects that have already been encoded using the
            # desired encoding. Therefore, we return binary_type encoded using utf-8 (assuming binary objects are
            # already utf-8)
            return obj.encode('utf-8')
        elif isinstance(obj, self.PRIMITIVE_TYPES):
            return obj
        elif isinstance(obj, list):
            return [self.sanitize_for_serialization(sub_obj)
                    for sub_obj in obj]
        elif isinstance(obj, tuple):
            return tuple(self.sanitize_for_serialization(sub_obj)
                         for sub_obj in obj)
        elif isinstance(obj, datetime):
            if not obj.tzinfo:
                raise ApiException(
                    status=400,
                    reason="datetimes must have a timezone. tzinfo is None for {0}".format(obj)
                )
            return obj.isoformat()
        elif isinstance(obj, date):
            return obj.isoformat()
        elif isinstance(obj, uuid.UUID):
            return str(obj).upper()
        elif isinstance(obj, timedelta):
            return obj.total_seconds() + obj.nanoseconds / 1e9 if hasattr(obj, 'nanoseconds') else obj.total_seconds()

        if isinstance(obj, dict):
            obj_dict = obj
        else:
            # Convert model obj to dict except
            # attributes `swagger_types`, `attribute_map`
            # and attributes which value is not None.
            # Convert attribute name to json key in
            # model definition for request.
            obj_dict = {obj.attribute_map[attr]: getattr(obj, attr)
                        for attr, _ in iteritems(obj.swagger_types)
                        if getattr(obj, attr) is not None}

        return {key: self.sanitize_for_serialization(val)
                for key, val in iteritems(obj_dict)}

    def deserialize(self, response, response_type):
        """
        Deserializes response into an object.

        :param response: RESTResponse object to be deserialized.
        :param response_type: class literal for
            deserialized object, or string of class name.

        :return: deserialized object.
        """
        if response.data is None:
            return None

        # handle file downloading
        # save response body into a tmp file and return the instance
        if response_type == "file":
            return self.__deserialize_file(response)

        if response_type == "bytes":
            return response.data

        # In the python 3, the response.data is bytes.
        # we need to decode it to string.
        if PY3:
            decoded_data = response.data.decode('utf8')
        else:
            decoded_data = response.data

        # fetch data from response object
        try:
            loaded_data = json.loads(decoded_data)
        except ValueError:
            loaded_data = decoded_data

        if response_type == "json":
            return loaded_data
        return self.__deserialize(loaded_data, response_type)

    def __deserialize(self, data, klass):
        """
        Deserializes dict, list, str into an object.

        :param data: dict, list or str.
        :param klass: class literal, or string of class name.

        :return: object.
        """
        if data is None:
            return None

        if type(klass) == str:
            if klass.startswith('list['):
                sub_kls = re.match(r'list\[(.*)\]', klass).group(1)
                return [self.__deserialize(sub_data, sub_kls)
                        for sub_data in data]

            if klass.startswith('dict('):
                sub_kls = re.match(r'dict\(([^,]*), (.*)\)', klass).group(2)
                return {k: self.__deserialize(v, sub_kls)
                        for k, v in iteritems(data)}

            # convert str to class
            if klass in self.NATIVE_TYPES_MAPPING:
                klass = self.NATIVE_TYPES_MAPPING[klass]
            else:
                klass = getattr(models, klass)

        if klass in self.PRIMITIVE_TYPES:
            return self.__deserialize_primitive(data, klass)
        elif klass == object:
            return self.__deserialize_object(data)
        elif klass == date:
            return self.__deserialize_date(data)
        elif klass == datetime:
            return self.__deserialize_datatime(data)
        else:
            return self.__deserialize_model(data, klass)

    def call_api(self, resource_path, method,
                 path_params=None, query_params=None, header_params=None,
                 body=None, post_params=None, files=None,
                 response_type=None, auth_settings=None, callback=None,
                 _return_http_data_only=None, collection_formats=None, _preload_content=True,
                 _request_timeout=None):
        """
        Makes the HTTP request (synchronous) and return the deserialized data.
        To make an async request, define a function for callback.

        :param resource_path: Path to method endpoint.
        :param method: Method to call.
        :param path_params: Path parameters in the url.
        :param query_params: Query parameters in the url.
        :param header_params: Header parameters to be
            placed in the request header.
        :param body: Request body.
        :param {dict} post_params: Request post form parameters,
            for `application/x-www-form-urlencoded`, `multipart/form-data`.
        :param {list} auth_settings: Auth Settings names for the request.
        :param response_type: Response data type. Valid values are `None`, `'file'`, `'json'`, or a class name that
                              maps to the output and should be used for serialization.
        :param {dict} files: key -> filename, value -> filepath,
            for `multipart/form-data`.
        :param {function} callback: Callback function for asynchronous request.
            If provide this parameter,
            the request will be called asynchronously.
        :param _return_http_data_only: response data without head status code and headers
        :param collection_formats: dict of collection formats for path, query,
            header, and post parameters.
        :param _preload_content: if False, the urllib3.HTTPResponse object will be returned without
                                 reading/decoding response data. Default is True.
        :param _request_timeout: timeout setting for this request. If one number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of (connection, read) timeouts.
        :return:
            If provide parameter callback,
            the request will be called asynchronously.
            The method will return the request thread.
            If parameter callback is None,
            then the method will return the response directly.
        """
        if callback is None:
            return self.__call_api(resource_path, method,
                                   path_params, query_params, header_params,
                                   body, post_params, files,
                                   response_type, auth_settings, callback,
                                   _return_http_data_only, collection_formats, _preload_content, _request_timeout)
        else:
            thread = threading.Thread(target=self.__call_api,
                                      args=(resource_path, method,
                                            path_params, query_params,
                                            header_params, body,
                                            post_params, files,
                                            response_type, auth_settings,
                                            callback, _return_http_data_only,
                                            collection_formats, _preload_content, _request_timeout))
        thread.start()
        return thread

    def request(self, method, url, query_params=None, headers=None,
                post_params=None, body=None, _preload_content=True, _request_timeout=None):
        """
        Makes the HTTP request using RESTClient.
        """
        if method == "GET":
            return self.rest_client.GET(url,
                                        query_params=query_params,
                                        _preload_content=_preload_content,
                                        _request_timeout=_request_timeout,
                                        headers=headers)
        elif method == "HEAD":
            return self.rest_client.HEAD(url,
                                         query_params=query_params,
                                         _preload_content=_preload_content,
                                         _request_timeout=_request_timeout,
                                         headers=headers)
        elif method == "OPTIONS":
            return self.rest_client.OPTIONS(url,
                                            query_params=query_params,
                                            headers=headers,
                                            post_params=post_params,
                                            _preload_content=_preload_content,
                                            _request_timeout=_request_timeout,
                                            body=body)
        elif method == "POST":
            return self.rest_client.POST(url,
                                         query_params=query_params,
                                         headers=headers,
                                         post_params=post_params,
                                         _preload_content=_preload_content,
                                         _request_timeout=_request_timeout,
                                         body=body)
        elif method == "PUT":
            return self.rest_client.PUT(url,
                                        query_params=query_params,
                                        headers=headers,
                                        post_params=post_params,
                                        _preload_content=_preload_content,
                                        _request_timeout=_request_timeout,
                                        body=body)
        elif method == "PATCH":
            return self.rest_client.PATCH(url,
                                          query_params=query_params,
                                          headers=headers,
                                          post_params=post_params,
                                          _preload_content=_preload_content,
                                          _request_timeout=_request_timeout,
                                          body=body)
        elif method == "DELETE":
            return self.rest_client.DELETE(url,
                                           query_params=query_params,
                                           headers=headers,
                                           _preload_content=_preload_content,
                                           _request_timeout=_request_timeout,
                                           body=body)
        else:
            raise ValueError(
                "http method must be `GET`, `HEAD`, `OPTIONS`,"
                " `POST`, `PATCH`, `PUT` or `DELETE`."
            )

    def parameters_to_tuples(self, params, collection_formats):
        """
        Get parameters as list of tuples, formatting collections.

        :param params: Parameters as dict or list of two-tuples
        :param dict collection_formats: Parameter collection formats
        :return: Parameters as list of tuples, collections formatted
        """
        new_params = []
        if collection_formats is None:
            collection_formats = {}
        for k, v in iteritems(params) if isinstance(params, dict) else params:
            if k in collection_formats:
                collection_format = collection_formats[k]
                if collection_format == 'multi':
                    new_params.extend((k, value) for value in v)
                else:
                    if collection_format == 'ssv':
                        delimiter = ' '
                    elif collection_format == 'tsv':
                        delimiter = '\t'
                    elif collection_format == 'pipes':
                        delimiter = '|'
                    else:  # csv is the default
                        delimiter = ','
                    new_params.append(
                        (k, delimiter.join(str(value) for value in v)))
            else:
                new_params.append((k, v))
        return new_params

    def prepare_post_parameters(self, post_params=None, files=None):
        """
        Builds form parameters.

        :param post_params: Normal form parameters.
        :param files: File parameters.
        :return: Form parameters with files.
        """
        params = []

        if post_params:
            params = post_params

        if files:
            for k, v in iteritems(files):
                if not v:
                    continue
                file_names = v if type(v) is list else [v]
                for n in file_names:
                    with open(n, 'rb') as f:
                        filename = os.path.basename(f.name)
                        filedata = f.read()
                        mimetype = mimetypes. \
                                       guess_type(filename)[0] or 'application/octet-stream'
                        params.append(tuple([k, tuple([filename, filedata, mimetype])]))

        return params

    def select_header_accept(self, accepts):
        """
        Returns `Accept` based on an array of accepts provided.

        :param accepts: List of headers.
        :return: Accept (e.g. application/json).
        """
        if not accepts:
            return

        accepts = [x.lower() for x in accepts]

        if 'application/json' in accepts:
            return 'application/json'
        else:
            return ', '.join(accepts)

    def select_header_content_type(self, content_types):
        """
        Returns `Content-Type` based on an array of content_types provided.

        :param content_types: List of content-types.
        :return: Content-Type (e.g. application/json).
        """
        if not content_types:
            return 'application/json'

        content_types = [x.lower() for x in content_types]

        if 'application/json' in content_types or '*/*' in content_types:
            return 'application/json'
        else:
            return content_types[0]

    def update_params_for_auth(self, headers, querys, auth_settings):
        """
        Updates header and query params based on authentication setting.

        :param headers: Header parameters dict to be updated.
        :param querys: Query parameters tuple list to be updated.
        :param auth_settings: Authentication setting identifiers list.
        """
        config = self.configuration

        if not auth_settings:
            return

        for auth in auth_settings:
            auth_setting = config.auth_settings().get(auth)
            if auth_setting:
                if not auth_setting['value']:
                    continue
                elif auth_setting['in'] == 'header':
                    headers[auth_setting['key']] = auth_setting['value']
                elif auth_setting['in'] == 'query':
                    querys.append((auth_setting['key'], auth_setting['value']))
                else:
                    raise ValueError(
                        'Authentication token must be in `query` or `header`'
                    )

    def __deserialize_file(self, response):
        """
        Saves response body into a file in a temporary folder,
        using the filename from the `Content-Disposition` header if provided.

        :param response:  RESTResponse.
        :return: file path.
        """
        config = self.configuration

        fd, path = tempfile.mkstemp(dir=config.temp_folder_path)
        os.close(fd)
        os.remove(path)

        content_disposition = response.headers.get("Content-Disposition")
        if content_disposition:
            filename = re. \
                search(r'filename=[\'"]?([^\'"\s]+)[\'"]?', content_disposition). \
                group(1)
            path = os.path.join(os.path.dirname(path), filename)

        with open(path, "w") as f:
            f.write(response.data)

        return path

    def __deserialize_primitive(self, data, klass):
        """
        Deserializes string to primitive type.

        :param data: str.
        :param klass: class literal.

        :return: int, long, float, str, bool.
        """
        try:
            if klass is str:
                # SEEQ-NOTE:
                # Always return unicode strings to relieve the SDK user from worrying about encoding.
                # Appserver always supplies strings encoded in UTF-8.
                return data if isinstance(data, text_type) else text_type(data, 'utf-8')
            else:
                return klass(data)
        except UnicodeEncodeError:
            return unicode(data)
        except TypeError:
            return data

    def __deserialize_object(self, value):
        """
        Return a original value.

        :return: object.
        """
        return value

    def __deserialize_date(self, string):
        """
        Deserializes string to date.

        :param string: str.
        :return: date.
        """
        try:
            from dateutil.parser import parse
            return parse(string).date()
        except ImportError:
            return string
        except ValueError:
            raise ApiException(
                status=0,
                reason="Failed to parse `{0}` into a date object".format(string)
            )

    def __deserialize_datatime(self, string):
        """
        Deserializes string to datetime.

        The string should be in iso8601 datetime format.

        :param string: str.
        :return: datetime.
        """
        try:
            from dateutil.parser import parse
            return parse(string)
        except ImportError:
            return string
        except ValueError:
            raise ApiException(
                status=0,
                reason=(
                    "Failed to parse `{0}` into a datetime object"
                        .format(string)
                )
            )

    def __deserialize_model(self, data, klass):
        """
        Deserializes list or dict to model.

        :param data: dict, list.
        :param klass: class literal.
        :return: model object.
        """
        if not klass.swagger_types:
            return data

        kwargs = {}
        for attr, attr_type in iteritems(klass.swagger_types):
            if data is not None \
                    and klass.attribute_map[attr] in data \
                    and isinstance(data, (list, dict)):
                value = data[klass.attribute_map[attr]]
                kwargs[attr] = self.__deserialize(value, attr_type)

        instance = klass(**kwargs)

        return instance
