!function(t,i){"object"==typeof exports&&"undefined"!=typeof module?i(exports,require("d3")):"function"==typeof define&&define.amd?define(["exports","d3"],i):i((t="undefined"!=typeof globalThis?globalThis:t||self).BGCViewer={},t.d3)}(this,function(t,i){"use strict";function e(t){var i=Object.create(null);return t&&Object.keys(t).forEach(function(e){if("default"!==e){var a=Object.getOwnPropertyDescriptor(t,e);Object.defineProperty(i,e,a.get?a:{enumerable:!0,get:function(){return t[e]}})}}),i.default=t,Object.freeze(i)}var a=e(i);class r{constructor(t){this.data={tracks:[],annotations:[],primitives:[]},this.isResponsiveWidth=void 0===t.width;const i="string"==typeof t.container?document.querySelector(t.container):t.container;if(!i)throw new Error("Container element not found");this.containerElement=i;const e=this.isResponsiveWidth?this.calculateResponsiveWidth():t.width||800;this.config={container:t.container,width:e,height:t.height||300,margin:t.margin||{top:20,right:10,bottom:20,left:60},trackHeight:t.trackHeight||30,domain:t.domain||[0,100],zoomExtent:t.zoomExtent||[.5,20],onAnnotationClick:t.onAnnotationClick||(()=>{}),onAnnotationHover:t.onAnnotationHover||(()=>{})},this.originalLeftMargin=this.config.margin.left,this.currentTransform=a.zoomIdentity,this.initialize(),this.isResponsiveWidth&&this.setupAutoResize()}calculateResponsiveWidth(){const t=this.containerElement.clientWidth||800;return Math.max(600,t-40)}setupAutoResize(){let t;this.resizeHandler=()=>{clearTimeout(t),t=setTimeout(()=>{this.resize()},100)},window.addEventListener("resize",this.resizeHandler)}initialize(){const t="string"==typeof this.config.container?document.querySelector(this.config.container):this.config.container;if(!t)throw new Error("Container element not found");const i=document.body||document.documentElement;this.tooltip=a.select(i).append("div").attr("class","track-viewer-tooltip").style("position","absolute").style("background","white").style("border","1px solid #ccc").style("padding","4px 8px").style("pointer-events","none").style("display","none").style("z-index","1000"),this.svg=a.select(t).append("svg").attr("width",this.config.width).attr("height",this.config.height),this.chart=this.svg.append("g").attr("transform",`translate(${this.config.margin.left},${this.config.margin.top})`);const e=this.config.width-this.config.margin.left-this.config.margin.right;this.clipId=`clip-${Math.random().toString(36).substring(2,11)}`,this.svg.append("defs").append("clipPath").attr("id",this.clipId).append("rect").attr("x",0).attr("y",-r.LABEL_PADDING).attr("width",e).attr("height","100%"),this.xAxisGroup=this.chart.append("g").attr("class","x-axis"),this.clippedChart=this.chart.append("g").attr("clip-path",`url(#${this.clipId})`),this.x=a.scaleLinear().domain(this.config.domain).range([0,this.config.width-this.config.margin.left-this.config.margin.right]),this.initializeZoom()}initializeZoom(){const t=this.config.width-this.config.margin.left-this.config.margin.right,i=this.config.height-this.config.margin.top-this.config.margin.bottom;this.zoom=a.zoom().scaleExtent(this.config.zoomExtent).translateExtent([[0,0],[t,i]]).extent([[0,0],[t,i]]).on("zoom",t=>{this.currentTransform=t.transform,this.drawTracks()}),this.svg.call(this.zoom),this.clippedChart.insert("rect",":first-child").attr("class","chart-background").attr("width",t).attr("height",i).attr("y",-r.LABEL_PADDING).style("fill","transparent").style("pointer-events","all").style("cursor","grab").on("mousedown",function(){a.select(this).style("cursor","grabbing")}).on("mouseup",function(){a.select(this).style("cursor","grab")})}getTrackHeight(t){return t.height||this.config.trackHeight}getTotalTracksHeight(){return this.data.tracks.reduce((t,i)=>t+this.getTrackHeight(i),0)}getTrackYPosition(t){let i=0;for(let e=0;e<t;e++)i+=this.getTrackHeight(this.data.tracks[e]);return i}updateHeight(){const t=this.getTotalTracksHeight()+this.config.margin.top+this.config.margin.bottom;this.config.height=t,this.svg.attr("height",t);const i=this.getTotalTracksHeight();this.xAxisGroup.attr("transform",`translate(0, ${i})`),this.svg.select("clipPath rect").attr("height",i+r.LABEL_PADDING),this.clippedChart.select(".chart-background").attr("height",i+r.LABEL_PADDING)}createTrackGroups(){this.trackGroups=this.clippedChart.selectAll(".track").data(this.data.tracks,t=>t.id).join("g").attr("id",t=>t.id).attr("class","track").attr("transform",(t,i)=>`translate(0, ${this.getTrackYPosition(i)})`);this.chart.selectAll(".track-label-group").data(this.data.tracks,t=>t.id).join("g").attr("id",t=>`${t.id}-label`).attr("class","track-label-group").attr("transform",(t,i)=>`translate(0, ${this.getTrackYPosition(i)})`).selectAll(".track-label").data(t=>[t]).join("text").attr("class","track-label").attr("x",-10).attr("y",t=>this.getTrackHeight(t)/2).attr("dy","0.35em").attr("text-anchor","end").text(t=>t.label)}drawTracks(){const t=this.currentTransform.rescaleX(this.x);this.xAxisGroup.call(a.axisBottom(t)),this.xAxisGroup.selectAll("text").attr("class","axis-label"),this.trackGroups&&this.trackGroups.each((i,e,r)=>{const n=a.select(r[e]),s=this.data.annotations.filter(t=>t.trackId===i.id),o=[...(this.data.primitives||[]).filter(t=>t.trackId===i.id).map(t=>({type:"primitive",data:t})),...s.map(t=>({type:"annotation",data:t}))],h=n.selectAll("g").data(o,t=>t.data.id).join(t=>t.append("g"),t=>t,t=>t.remove()).attr("id",t=>t.data.id).attr("class",t=>"primitive"===t.type?`${t.type} ${t.data.type} ${t.data.class}`:`${t.type} ${t.data.type} ${t.data.classes.join(" ")}`),c=this;h.each(function(e){const r=a.select(this);r.selectAll("*").remove(),"primitive"===e.type?c.renderPrimitive(r,e.data,t,i):c.renderAnnotation(r,e.data,t,i)})})}renderAnnotation(t,i,e,r){const n=e(i.start),s=Math.max(1,e(i.end)-e(i.start)),o=this.getTrackHeight(r),h=void 0!==i.heightFraction?o*i.heightFraction:o/2,c=o-(void 0!==i.fy?i.fy*o:o/2);let l;switch(i.type){case"arrow":l=this.renderArrow(t,n,c,s,h,i.direction);break;case"circle":l=this.renderCircle(t,n,c,h);break;case"triangle":l=this.renderTriangle(t,n,c,h);break;case"pin":l=this.renderPin(t,n,c,h);break;default:l=this.renderBox(t,n,c,s,h,i.corner_radius||0)}l.attr("data-annotation-id",i.id).style("cursor","pointer").style("pointer-events","all"),i.fill&&l.style("fill",i.fill),i.stroke&&l.style("stroke",i.stroke),void 0!==i.opacity&&l.style("opacity",i.opacity),l.on("mouseover",e=>{l.classed("hovered",!0),t.selectAll(`.annotation-label[data-annotation-id="${i.id}"]`).style("display","block"),void 0!==i.tooltip&&this.showTooltip(e,i,r),this.config.onAnnotationHover(i,r,e)}).on("mouseout",()=>{l.classed("hovered",!1),t.selectAll(`.annotation-label[data-annotation-id="${i.id}"]`).style("display",function(){return"hover"===a.select(this).attr("data-show-label")?"none":null}),this.hideTooltip()}).on("click",()=>{this.config.onAnnotationClick(i,r)}),this.renderAnnotationLabel(t,i,n,c,s,h)}renderPrimitive(t,i,e,a){const r=this.getTrackHeight(a);let n;switch(i.type){case"horizontal-line":n=this.renderHorizontalLine(t,i,e,r);break;case"background":n=this.renderBackground(t,i,e,r);break;default:return}n.attr("class",`primitive ${i.class}`),i.stroke?n.style("stroke",i.stroke):"horizontal-line"===i.type&&n.style("stroke","currentColor"),i.fill?n.style("fill",i.fill):"background"===i.type&&n.style("fill","none"),void 0!==i.opacity&&n.style("opacity",i.opacity)}renderHorizontalLine(t,i,e,a){const r=e.range();let n,s;void 0!==i.start&&void 0!==i.end?(n=e(i.start),s=e(i.end)):void 0!==i.start&&void 0===i.end?(n=e(i.start),s=r[1]):void 0===i.start&&void 0!==i.end?(n=r[0],s=e(i.end)):(n=r[0],s=r[1]);const o=a-(void 0!==i.fy?i.fy*a:a/2),h=Math.round(o)+.5;return t.append("line").attr("x1",n).attr("x2",s).attr("y1",h).attr("y2",h).style("stroke-width",1).style("shape-rendering","crispEdges")}renderBackground(t,i,e,a){const r=e.range();let n,s;return void 0!==i.start&&void 0!==i.end?(n=e(i.start),s=e(i.end)):void 0!==i.start&&void 0===i.end?(n=e(i.start),s=r[1]):void 0===i.start&&void 0!==i.end?(n=r[0],s=e(i.end)):(n=r[0],s=r[1]),t.append("rect").attr("x",n).attr("y",0).attr("width",s-n).attr("height",a)}renderBox(t,i,e,a,r,n=0){return t.append("rect").attr("x",i).attr("y",e-r/2).attr("width",a).attr("height",r).attr("rx",n).attr("ry",n)}renderArrow(t,i,e,a,r,n){const s=Math.min(.2*a,.5*r,8),o=a-s;let h;const c=e-r/2,l=e+r/2;if("right"===n)h=`\n        M ${i} ${c}\n        L ${i+o} ${c}\n        L ${i+a} ${e}\n        L ${i+o} ${l}\n        L ${i} ${l}\n        Z\n      `;else if("left"===n)h=`\n        M ${i} ${e}\n        L ${i+s} ${c}\n        L ${i+a} ${c}\n        L ${i+a} ${l}\n        L ${i+s} ${l}\n        Z\n      `;else{const t=Math.min(.1*a,.3*r,4);h=`\n        M ${i+t} ${c}\n        L ${i+a-t} ${c}\n        L ${i+a} ${e}\n        L ${i+a-t} ${l}\n        L ${i+t} ${l}\n        L ${i} ${e}\n        Z\n      `}return t.append("path").attr("d",h)}renderCircle(t,i,e,a){return t.append("circle").attr("cx",i).attr("cy",e).attr("r",a/2).attr("class","annotation-marker")}renderTriangle(t,i,e,a=.5){const r=.8*a,n=[[i-r/2,e+a],[i,e],[i+r/2,e+a]].map(t=>t.join(",")).join(" ");return t.append("polygon").attr("points",n).attr("class","annotation-triangle")}renderPin(t,i,e,a){const r=t.append("g").attr("class","annotation-pin");return r.append("line").attr("x1",i).attr("y1",e).attr("x2",i).attr("y2",e-a).attr("stroke","black").attr("class","annotation-pin-line"),r.append("circle").attr("cx",i).attr("cy",e-a).attr("r",3).attr("class","annotation-pin-head"),r}renderAnnotationLabel(t,i,e,a,r,n){const s=i.showLabel||"hover";if("never"===s||!i.label)return;const o=i.labelPosition||"above";let h,c;"circle"===i.type||"triangle"===i.type||"pin"===i.type?(h=e,c="above"===o?a-n/2-2:a):(h=e+r/2,c="above"===o?a-n/2-8:a);const l=t.append("text").attr("x",h).attr("y",c).attr("dy","0.35em").attr("text-anchor","middle").attr("class","annotation-label").attr("data-annotation-id",i.id).attr("data-show-label",s).style("fill","currentColor").style("stroke","white").style("stroke-width","0.5px").style("paint-order","stroke fill").style("pointer-events","none").text(i.label);"hover"===s&&l.style("display","none")}showTooltip(t,i,e){const a=void 0!==i.tooltip?i.tooltip:`<strong>${i.label}</strong><br/>Start: ${i.start}<br/>End: ${i.end}<br/>Track: ${e.label}`;this.tooltip.style("display","block").style("left",`${t.pageX+10}px`).style("top",t.pageY-10+"px").html(a)}hideTooltip(){this.tooltip.style("display","none")}calculateRequiredLeftMargin(){if(0===this.data.tracks.length)return this.originalLeftMargin;const t=this.svg.append("text").attr("class","track-label").style("visibility","hidden");let i=0;this.data.tracks.forEach(e=>{t.text(e.label);const a=t.node();if(a&&"function"==typeof a.getBBox)try{const t=a.getBBox();i=Math.max(i,t.width)}catch(t){i=Math.max(i,8*e.label.length)}else i=Math.max(i,8*e.label.length)}),t.remove();return Math.max(this.originalLeftMargin,i+20)}updateMarginAndLayout(){const t=this.calculateRequiredLeftMargin();if(Math.abs(this.config.margin.left-t)>5){this.config.margin.left=t,this.chart.attr("transform",`translate(${this.config.margin.left},${this.config.margin.top})`),this.x.range([0,this.config.width-this.config.margin.left-this.config.margin.right]);const i=this.config.width-this.config.margin.left-this.config.margin.right;this.svg.select("clipPath rect").attr("width",i),this.clippedChart.select(".chart-background").attr("width",i)}}setData(t){this.data={tracks:t.tracks,annotations:t.annotations,primitives:t.primitives||[]},this.updateMarginAndLayout(),this.updateHeight(),this.createTrackGroups(),this.drawTracks()}addTrack(t,i,e){this.data.tracks.push(t),i&&this.data.annotations.push(...i),e&&(this.data.primitives||(this.data.primitives=[]),this.data.primitives.push(...e)),this.updateMarginAndLayout(),this.updateHeight(),this.createTrackGroups(),this.drawTracks()}removeTrack(t){this.data.tracks=this.data.tracks.filter(i=>i.id!==t),this.data.annotations=this.data.annotations.filter(i=>i.trackId!==t),this.data.primitives=(this.data.primitives||[]).filter(i=>i.trackId!==t),this.updateMarginAndLayout(),this.updateHeight(),this.createTrackGroups(),this.drawTracks()}addAnnotation(t){this.data.annotations.push(t),this.drawTracks()}removeAnnotation(t){this.data.annotations=this.data.annotations.filter(i=>i.id!==t),this.drawTracks()}addPrimitive(t){this.data.primitives||(this.data.primitives=[]),this.data.primitives.push(t),this.drawTracks()}removePrimitive(t){this.data.primitives&&(this.data.primitives=this.data.primitives.filter(i=>i.id!==t),this.drawTracks())}updateDomain(t){this.config.domain=t,this.x.domain(t),this.drawTracks()}zoomTo(t,i){const e=(this.config.width-this.config.margin.left-this.config.margin.right)/(this.x(i)-this.x(t)),r=-this.x(t)*e,n=a.zoomIdentity.translate(r,0).scale(e);this.svg.transition().duration(750).call(this.zoom.transform,n)}resetZoom(){this.svg.transition().duration(750).call(this.zoom.transform,a.zoomIdentity)}destroy(){this.resizeHandler&&window.removeEventListener("resize",this.resizeHandler),this.tooltip.remove(),this.svg.remove()}getConfig(){return{...this.config}}getData(){return{tracks:[...this.data.tracks],annotations:[...this.data.annotations],primitives:this.data.primitives?[...this.data.primitives]:[]}}resize(){if(!this.isResponsiveWidth)return;const t=this.calculateResponsiveWidth();if(Math.abs(this.config.width-t)>10){this.config.width=t,this.svg.attr("width",t),this.x.range([0,t-this.config.margin.left-this.config.margin.right]);const i=t-this.config.margin.left-this.config.margin.right;this.svg.select("clipPath rect").attr("width",i),this.clippedChart.select(".chart-background").attr("width",i);const e=this.config.height-this.config.margin.top-this.config.margin.bottom;this.zoom.translateExtent([[0,0],[i,e]]).extent([[0,0],[i,e]]),this.drawTracks()}}}r.LABEL_PADDING=24,t.TrackViewer=r});
//# sourceMappingURL=index.umd.js.map
