# Copyright 2015 Cisco Systems, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

""" This is an auto-generated module containing ManagedObject Meta information. """

from .ucsccoremeta import UcscVersion
from .ucsccoremeta import MoMeta

class VersionMeta:
    """ This class contains all the UcscVersion supported by this package."""
    Version101a = UcscVersion("1.0(1a)")
    Version111a = UcscVersion("1.1(1a)")
    Version111b = UcscVersion("1.1(1b)")
    Version112a = UcscVersion("1.1(2a)")
    Version121a = UcscVersion("1.2(1a)")
    Version121e = UcscVersion("1.2(1e)")
    Version131a = UcscVersion("1.3(1a)")
    Version141a = UcscVersion("1.4(1a)")
    Version151a = UcscVersion("1.5(1a)")
    Version151b = UcscVersion("1.5(1b)")
    Version201b = UcscVersion("2.0(1b)")
    Version201c = UcscVersion("2.0(1c)")
    Version201d = UcscVersion("2.0(1d)")
    Version201e = UcscVersion("2.0(1e)")
    Version201f = UcscVersion("2.0(1f)")
    Version201g = UcscVersion("2.0(1g)")
    Version201h = UcscVersion("2.0(1h)")
    Version201i = UcscVersion("2.0(1i)")
    Version201j = UcscVersion("2.0(1j)")
    Version201k = UcscVersion("2.0(1k)")
    Version201l = UcscVersion("2.0(1l)")
    Version201m = UcscVersion("2.0(1m)")
    Version201n = UcscVersion("2.0(1n)")
    Version201o = UcscVersion("2.0(1o)")
    Version201p = UcscVersion("2.0(1p)")
    Version201s = UcscVersion("2.0(1s)")
    Version201t = UcscVersion("2.0(1t)")
    Version201u = UcscVersion("2.0(1u)")
    Version201v = UcscVersion("2.0(1v)")
    Version211a = UcscVersion("2.1(1a)")
    Version211b = UcscVersion("2.1(1b)")
    Version211c = UcscVersion("2.1(1c)")

MO_CLASS_ID = frozenset([
    "AaaAuthRealm",
    "AaaAuthRealmFsm",
    "AaaAuthRealmFsmStage",
    "AaaConsoleAuth",
    "AaaDefaultAuth",
    "AaaDomain",
    "AaaDomainAuth",
    "AaaDomainGroup",
    "AaaEpAuthProfile",
    "AaaEpFsm",
    "AaaEpFsmStage",
    "AaaEpFsmTask",
    "AaaEpLogin",
    "AaaEpUser",
    "AaaExtMgmtCutThruTkn",
    "AaaLdapEp",
    "AaaLdapEpFsm",
    "AaaLdapEpFsmStage",
    "AaaLdapGroup",
    "AaaLdapGroupRule",
    "AaaLdapProvider",
    "AaaLocale",
    "AaaLog",
    "AaaModLR",
    "AaaOrg",
    "AaaProviderGroup",
    "AaaProviderRef",
    "AaaPwdProfile",
    "AaaRadiusEp",
    "AaaRadiusEpFsm",
    "AaaRadiusEpFsmStage",
    "AaaRadiusProvider",
    "AaaRealmFsm",
    "AaaRealmFsmStage",
    "AaaRealmFsmTask",
    "AaaRemoteUser",
    "AaaRole",
    "AaaSession",
    "AaaSessionLR",
    "AaaShellLogin",
    "AaaSshAuth",
    "AaaTacacsPlusEp",
    "AaaTacacsPlusEpFsm",
    "AaaTacacsPlusEpFsmStage",
    "AaaTacacsPlusProvider",
    "AaaUser",
    "AaaUserData",
    "AaaUserEp",
    "AaaUserEpFsm",
    "AaaUserEpFsmStage",
    "AaaUserEpFsmTask",
    "AaaUserLocale",
    "AaaUserPreferences",
    "AaaUserRole",
    "AaaWebLogin",
    "AdaptorCapQual",
    "AdaptorCapSpec",
    "AdaptorEthAdvFilterProfile",
    "AdaptorEthArfsProfile",
    "AdaptorEthCompQueueProfile",
    "AdaptorEthFailoverProfile",
    "AdaptorEthGENEVEProfile",
    "AdaptorEthInterruptProfile",
    "AdaptorEthInterruptScalingProfile",
    "AdaptorEthNVGREProfile",
    "AdaptorEthOffloadProfile",
    "AdaptorEthPortBySizeLargeStats",
    "AdaptorEthPortBySizeLargeStatsHist",
    "AdaptorEthPortBySizeSmallStats",
    "AdaptorEthPortBySizeSmallStatsHist",
    "AdaptorEthPortErrStats",
    "AdaptorEthPortErrStatsHist",
    "AdaptorEthPortMcastStats",
    "AdaptorEthPortMcastStatsHist",
    "AdaptorEthPortOutsizedStats",
    "AdaptorEthPortOutsizedStatsHist",
    "AdaptorEthPortStats",
    "AdaptorEthPortStatsHist",
    "AdaptorEthRecvQueueProfile",
    "AdaptorEthRoCEProfile",
    "AdaptorEthVxLANProfile",
    "AdaptorEthWorkQueueProfile",
    "AdaptorEtherIfStats",
    "AdaptorEtherIfStatsHist",
    "AdaptorExtEthIf",
    "AdaptorExtEthIfOperation",
    "AdaptorExtIpV6RssHashProfile",
    "AdaptorFcCdbWorkQueueProfile",
    "AdaptorFcErrorRecoveryProfile",
    "AdaptorFcFnicProfile",
    "AdaptorFcIfEventStats",
    "AdaptorFcIfEventStatsHist",
    "AdaptorFcIfFC4Stats",
    "AdaptorFcIfFC4StatsHist",
    "AdaptorFcIfFrameStats",
    "AdaptorFcIfFrameStatsHist",
    "AdaptorFcInterruptProfile",
    "AdaptorFcPortFLogiProfile",
    "AdaptorFcPortPLogiProfile",
    "AdaptorFcPortProfile",
    "AdaptorFcPortStats",
    "AdaptorFcPortStatsHist",
    "AdaptorFcRecvQueueProfile",
    "AdaptorFcWorkQueueProfile",
    "AdaptorFruCapProvider",
    "AdaptorHBAVnicStats",
    "AdaptorHBAVnicStatsHist",
    "AdaptorHostEthIf",
    "AdaptorHostEthIfOperation",
    "AdaptorHostEthIfProfile",
    "AdaptorHostFcIf",
    "AdaptorHostFcIfOperation",
    "AdaptorHostFcIfProfile",
    "AdaptorHostIfConfig",
    "AdaptorHostIscsiIf",
    "AdaptorHostIscsiIfOperation",
    "AdaptorHostIscsiIfProfile",
    "AdaptorHostScsiIf",
    "AdaptorHostScsiLunRef",
    "AdaptorIScsiCap",
    "AdaptorIpV4RssHashProfile",
    "AdaptorIpV6RssHashProfile",
    "AdaptorMenloBaseErrorStats",
    "AdaptorMenloBaseErrorStatsHist",
    "AdaptorMenloDcePortStats",
    "AdaptorMenloDcePortStatsHist",
    "AdaptorMenloEthErrorStats",
    "AdaptorMenloEthErrorStatsHist",
    "AdaptorMenloEthStats",
    "AdaptorMenloEthStatsHist",
    "AdaptorMenloFcErrorStats",
    "AdaptorMenloFcErrorStatsHist",
    "AdaptorMenloFcStats",
    "AdaptorMenloFcStatsHist",
    "AdaptorMenloHostPortStats",
    "AdaptorMenloHostPortStatsHist",
    "AdaptorMenloMcpuErrorStats",
    "AdaptorMenloMcpuErrorStatsHist",
    "AdaptorMenloMcpuStats",
    "AdaptorMenloMcpuStatsHist",
    "AdaptorMenloNetEgStats",
    "AdaptorMenloNetEgStatsHist",
    "AdaptorMenloNetInStats",
    "AdaptorMenloNetInStatsHist",
    "AdaptorMenloQErrorStats",
    "AdaptorMenloQErrorStatsHist",
    "AdaptorMenloQStats",
    "AdaptorMenloQStatsHist",
    "AdaptorNICVnicStats",
    "AdaptorNICVnicStatsHist",
    "AdaptorProtocolProfile",
    "AdaptorQual",
    "AdaptorRnicCapSpec",
    "AdaptorRssProfile",
    "AdaptorSriovHpnConnDef",
    "AdaptorUnit",
    "AdaptorUnitAssocCtx",
    "AdaptorUnitExtn",
    "AdaptorUsnicConnDef",
    "AdaptorVlan",
    "AdaptorVmmqConnDef",
    "AdaptorVnicStats",
    "AdaptorVnicStatsHist",
    "BiosBOT",
    "BiosBootDev",
    "BiosBootDevGrp",
    "BiosTokenFeatureGroup",
    "BiosTokenParam",
    "BiosTokenSettings",
    "BiosUnit",
    "BiosVProfile",
    "BiosVfACPI10Support",
    "BiosVfASPMSupport",
    "BiosVfAllUSBDevices",
    "BiosVfAltitude",
    "BiosVfAssertNMIOnPERR",
    "BiosVfAssertNMIOnSERR",
    "BiosVfBootOptionRetry",
    "BiosVfCPUHardwarePowerManagement",
    "BiosVfCPUPerformance",
    "BiosVfCPUPowerManagement",
    "BiosVfConsistentDeviceNameControl",
    "BiosVfConsoleRedirection",
    "BiosVfCoreMultiProcessing",
    "BiosVfDDR3VoltageSelection",
    "BiosVfDRAMClockThrottling",
    "BiosVfDirectCacheAccess",
    "BiosVfDramRefreshRate",
    "BiosVfEnergyPerformanceTuning",
    "BiosVfEnhancedIntelSpeedStepTech",
    "BiosVfEnhancedPowerCappingSupport",
    "BiosVfExecuteDisableBit",
    "BiosVfFRB2Timer",
    "BiosVfFrequencyFloorOverride",
    "BiosVfFrontPanelLockout",
    "BiosVfIOEMezz1OptionROM",
    "BiosVfIOENVMe1OptionROM",
    "BiosVfIOENVMe2OptionROM",
    "BiosVfIOESlot1OptionROM",
    "BiosVfIOESlot2OptionROM",
    "BiosVfIntegratedGraphics",
    "BiosVfIntegratedGraphicsApertureSize",
    "BiosVfIntelEntrySASRAIDModule",
    "BiosVfIntelHyperThreadingTech",
    "BiosVfIntelTrustedExecutionTechnology",
    "BiosVfIntelTurboBoostTech",
    "BiosVfIntelVTForDirectedIO",
    "BiosVfIntelVirtualizationTechnology",
    "BiosVfInterleaveConfiguration",
    "BiosVfLocalX2Apic",
    "BiosVfLvDIMMSupport",
    "BiosVfMaxVariableMTRRSetting",
    "BiosVfMaximumMemoryBelow4GB",
    "BiosVfMemoryMappedIOAbove4GB",
    "BiosVfMirroringMode",
    "BiosVfNUMAOptimized",
    "BiosVfOSBootWatchdogTimer",
    "BiosVfOSBootWatchdogTimerPolicy",
    "BiosVfOSBootWatchdogTimerTimeout",
    "BiosVfOnboardGraphics",
    "BiosVfOnboardSATAController",
    "BiosVfOnboardStorage",
    "BiosVfOptionROMEnable",
    "BiosVfOptionROMLoad",
    "BiosVfOutOfBandManagement",
    "BiosVfPCHSATAMode",
    "BiosVfPCILOMPortsConfiguration",
    "BiosVfPCIROMCLP",
    "BiosVfPCISlotLinkSpeed",
    "BiosVfPCISlotOptionROMEnable",
    "BiosVfPOSTErrorPause",
    "BiosVfPSTATECoordination",
    "BiosVfPackageCStateLimit",
    "BiosVfProcessorC1E",
    "BiosVfProcessorC3Report",
    "BiosVfProcessorC6Report",
    "BiosVfProcessorC7Report",
    "BiosVfProcessorCMCI",
    "BiosVfProcessorCState",
    "BiosVfProcessorEnergyConfiguration",
    "BiosVfProcessorPrefetchConfig",
    "BiosVfQPILinkFrequencySelect",
    "BiosVfQPISnoopMode",
    "BiosVfQuietBoot",
    "BiosVfRedirectionAfterBIOSPOST",
    "BiosVfResumeOnACPowerLoss",
    "BiosVfSBMezz1OptionROM",
    "BiosVfSBNVMe1OptionROM",
    "BiosVfSIOC1OptionROM",
    "BiosVfSIOC2OptionROM",
    "BiosVfScrubPolicies",
    "BiosVfSelectMemoryRASConfiguration",
    "BiosVfSerialPortAEnable",
    "BiosVfSparingMode",
    "BiosVfSriovConfig",
    "BiosVfTPMPendingOperation",
    "BiosVfTPMSupport",
    "BiosVfTrustedPlatformModule",
    "BiosVfUCSMBootModeControl",
    "BiosVfUCSMBootOrderRuleControl",
    "BiosVfUEFIOSUseLegacyVideo",
    "BiosVfUSBBootConfig",
    "BiosVfUSBConfiguration",
    "BiosVfUSBFrontPanelAccessLock",
    "BiosVfUSBPortConfiguration",
    "BiosVfUSBSystemIdlePowerOptimizingSetting",
    "BiosVfVGAPriority",
    "BiosVfWorkloadConfiguration",
    "CallhomeDest",
    "CallhomeEp",
    "CallhomeFaultInst",
    "CallhomeHolder",
    "CallhomeHolderFsm",
    "CallhomeHolderFsmStage",
    "CallhomeHolderFsmTask",
    "CallhomeHttp",
    "CallhomePeriodicSystemInventory",
    "CallhomePolicy",
    "CallhomeProfile",
    "CallhomeSmtp",
    "CallhomeSource",
    "CallhomeTestAlert",
    "CapabilityCatalogue",
    "CertRepairEp",
    "CertRepairEpFsm",
    "CertRepairEpFsmStage",
    "CertRepairEpFsmTask",
    "ChangeChangedObjectRef",
    "ChangeEp",
    "ChangeEpFsm",
    "ChangeEpFsmStage",
    "ChangeEpFsmTask",
    "CimcvmediaActualMountEntry",
    "CimcvmediaActualMountList",
    "CimcvmediaConfigMountEntry",
    "CimcvmediaExtMgmtRuleEntry",
    "CimcvmediaMountConfigDef",
    "CimcvmediaMountConfigPolicy",
    "ClitestTypeTest",
    "ClitestTypeTest2",
    "ClitestTypeTestChild",
    "CommCimxml",
    "CommCoreFile",
    "CommDateTime",
    "CommDateTimeFsm",
    "CommDateTimeFsmStage",
    "CommDateTimeFsmTask",
    "CommDns",
    "CommDnsProvider",
    "CommEvtChannel",
    "CommHttp",
    "CommHttps",
    "CommLocale",
    "CommLogComponent",
    "CommNtp",
    "CommNtpProvider",
    "CommShellSvcLimits",
    "CommSmashCLP",
    "CommSnmp",
    "CommSnmpCommunity",
    "CommSnmpTrap",
    "CommSnmpTrapData",
    "CommSnmpUser",
    "CommSsh",
    "CommSvcEp",
    "CommSvcEpFsm",
    "CommSvcEpFsmStage",
    "CommSvcEpFsmTask",
    "CommSvcPolicy",
    "CommSyslog",
    "CommSyslogClient",
    "CommSyslogConsole",
    "CommSyslogFile",
    "CommSyslogMonitor",
    "CommSyslogSource",
    "CommTelnet",
    "CommWebChannel",
    "CommWebSvcLimits",
    "CommWsman",
    "CommXmlClConnPolicy",
    "ComputeAutoconfigPolicy",
    "ComputeBlade",
    "ComputeBladeDiscPolicy",
    "ComputeBladeEp",
    "ComputeBladeInheritPolicy",
    "ComputeBoard",
    "ComputeBoardConnector",
    "ComputeBoardController",
    "ComputeCartridge",
    "ComputeCartridgeOperation",
    "ComputeChassisConnPolicy",
    "ComputeChassisConnPolicyOperation",
    "ComputeChassisDiscPolicy",
    "ComputeChassisFeatMask",
    "ComputeChassisQual",
    "ComputeDomainGroupQual",
    "ComputeDomainHwChangeDiscPolicy",
    "ComputeDomainNameQual",
    "ComputeDomainPortDiscPolicy",
    "ComputeDomainQual",
    "ComputeEnvFeatMask",
    "ComputeExtBoard",
    "ComputeFabricEthMonSrcEp",
    "ComputeFabricEthMonSrcEpCont",
    "ComputeFabricFcMonSrcEp",
    "ComputeFabricFcMonSrcEpCont",
    "ComputeFactoryResetOp",
    "ComputeFactoryResetOperation",
    "ComputeFaultUpgradeFlag",
    "ComputeGraphicsCardPolicy",
    "ComputeGroupMembership",
    "ComputeGroupMembershipRef",
    "ComputeHwChangeDiscPolicy",
    "ComputeIOHub",
    "ComputeIOHubEnvStats",
    "ComputeIOHubEnvStatsHist",
    "ComputeInstance",
    "ComputeInstanceIdQual",
    "ComputeInstanceMapping",
    "ComputeLocalTemplDef",
    "ComputeMbPowerStats",
    "ComputeMbPowerStatsHist",
    "ComputeMbTempStats",
    "ComputeMbTempStatsHist",
    "ComputeModularChassisFanPolicy",
    "ComputeNetworkFeatMask",
    "ComputeOwnerQual",
    "ComputePCIeFatalCompletionStats",
    "ComputePCIeFatalCompletionStatsHist",
    "ComputePCIeFatalProtocolStats",
    "ComputePCIeFatalProtocolStatsHist",
    "ComputePCIeFatalReceiveStats",
    "ComputePCIeFatalReceiveStatsHist",
    "ComputePCIeFatalStats",
    "ComputePCIeFatalStatsHist",
    "ComputePhysicalAssocCtx",
    "ComputePhysicalExtension",
    "ComputePhysicalOperation",
    "ComputePhysicalQual",
    "ComputePool",
    "ComputePoolPolicyRef",
    "ComputePoolable",
    "ComputePooledEnclosureComputeSlot",
    "ComputePooledRackUnit",
    "ComputePooledSlot",
    "ComputePoolingPolicy",
    "ComputePortDiscPolicy",
    "ComputePowerExtendedPolicy",
    "ComputePowerSavePolicy",
    "ComputePowerSyncDef",
    "ComputePowerSyncPolicy",
    "ComputeProductFamilyQual",
    "ComputeProfile",
    "ComputePsuPolicy",
    "ComputeQual",
    "ComputeRackQual",
    "ComputeRackUnit",
    "ComputeRackUnitMbTempStats",
    "ComputeRackUnitMbTempStatsHist",
    "ComputeRebootLog",
    "ComputeRemoteOpStatus",
    "ComputeRequirement",
    "ComputeResourceAggrEp",
    "ComputeResourceSet",
    "ComputeResourceSetManager",
    "ComputeResourceSetMember",
    "ComputeScrubPolicy",
    "ComputeServerDiscPolicy",
    "ComputeServerFeatMask",
    "ComputeServerMgmtPolicy",
    "ComputeServerUnit",
    "ComputeSession",
    "ComputeSiteQual",
    "ComputeSlotQual",
    "ComputeStorageFeatMask",
    "ComputeSystem",
    "ComputeSystemAddrQual",
    "ComputeSystemFsm",
    "ComputeSystemFsmStage",
    "ComputeSystemFsmTask",
    "ComputeSystemQual",
    "ComputeTemplate",
    "ComputeTemplateMapping",
    "ComputeUser",
    "ComputeUserEp",
    "ConfigAckItem",
    "ConfigAdaptorItem",
    "ConfigAppImpactResponse",
    "ConfigBackup",
    "ConfigBackupFsm",
    "ConfigBackupFsmStage",
    "ConfigBackupFsmTask",
    "ConfigCartridgeFilter",
    "ConfigCartridgeItem",
    "ConfigCatalogue",
    "ConfigChassisFilter",
    "ConfigChassisItem",
    "ConfigComponentsFilter",
    "ConfigConsumerCatalogue",
    "ConfigConsumerCatalogueFsm",
    "ConfigConsumerCatalogueFsmStage",
    "ConfigConsumerCatalogueFsmTask",
    "ConfigControllerItem",
    "ConfigCpuInfo",
    "ConfigCpuItem",
    "ConfigCryptoCardItem",
    "ConfigDbConfig",
    "ConfigDomainFilter",
    "ConfigDomainItem",
    "ConfigFabricInterconnectFilter",
    "ConfigFabricInterconnectItem",
    "ConfigFanItem",
    "ConfigFexFilter",
    "ConfigFexItem",
    "ConfigFilterGroup",
    "ConfigFilterItem",
    "ConfigFsm",
    "ConfigFsmStage",
    "ConfigGraphicsCardItem",
    "ConfigIOMItem",
    "ConfigImpact",
    "ConfigImpactAnalyzer",
    "ConfigImpactAnalyzerEp",
    "ConfigInputConfig",
    "ConfigInputConfigSet",
    "ConfigLocalDiskItem",
    "ConfigLunItem",
    "ConfigManagedEpImpactResponse",
    "ConfigMemoryItem",
    "ConfigMotherboardItem",
    "ConfigNetRefItem",
    "ConfigOrgItem",
    "ConfigPSUItem",
    "ConfigPasswordEncryption",
    "ConfigPasswordEncryptionFsm",
    "ConfigPasswordEncryptionFsmStage",
    "ConfigPasswordEncryptionFsmTask",
    "ConfigPcieNodeItem",
    "ConfigPolicyUsageItem",
    "ConfigPortItem",
    "ConfigSearchOptions",
    "ConfigSearchResult",
    "ConfigServerFilter",
    "ConfigServerItem",
    "ConfigServiceProfileFilter",
    "ConfigSorter",
    "ConfigSpotLightItem",
    "ConfigStorageArrayProfileFilter",
    "ConfigStorageBladeFilter",
    "ConfigStorageItem",
    "ConfigUCImpact",
    "ConfigXFMItem",
    "ConsumerInst",
    "ConsumerInstFsm",
    "ConsumerInstFsmStage",
    "ConsumerInstFsmTask",
    "ConsumerUniverse",
    "ControllerEp",
    "ControllerEpFsm",
    "ControllerEpFsmStage",
    "ControllerEpFsmTask",
    "CpmaintAck",
    "CpmaintMaintPolicy",
    "DcxVIf",
    "DcxVc",
    "DiagLogEp",
    "DiagMemoryTest",
    "DiagRslt",
    "DiagRunPolicy",
    "DiagSrvCapProvider",
    "DiagSrvCtrl",
    "DiagSrvCtrlOperation",
    "DiagSrvCtrlOperationFsm",
    "DiagSrvCtrlOperationFsmStage",
    "DiagSrvCtrlOperationFsmTask",
    "DomainChassisFeature",
    "DomainChassisParam",
    "DomainChassisProfileItem",
    "DomainEnvironmentFeature",
    "DomainEnvironmentParam",
    "DomainEp",
    "DomainFamilyCapProvider",
    "DomainFeatureCatalog",
    "DomainNetworkFeature",
    "DomainNetworkParam",
    "DomainProfile",
    "DomainProfileFsm",
    "DomainProfileFsmStage",
    "DomainProfileFsmTask",
    "DomainServerFeature",
    "DomainServerParam",
    "DomainServiceProfileItem",
    "DomainStorageFeature",
    "DomainStorageParam",
    "DpsecMac",
    "DupeChangeTracker",
    "DupeChangeTrackerEp",
    "DupeChangeTrackerEpFsm",
    "DupeChangeTrackerEpFsmStage",
    "DupeChangeTrackerEpFsmTask",
    "DupeEp",
    "DupeExtRequestor",
    "DupeIntRequestor",
    "DupeScope",
    "DupeScopeEp",
    "DupeScopeResult",
    "EpqosDefinition",
    "EpqosEgress",
    "EquipmentAdvancedBootOrder",
    "EquipmentBeaconLed",
    "EquipmentBinding",
    "EquipmentBladeCapProvider",
    "EquipmentBreakoutCap",
    "EquipmentCPMeta",
    "EquipmentChassis",
    "EquipmentChassisAssocCtx",
    "EquipmentChassisCapProvider",
    "EquipmentChassisIssues",
    "EquipmentChassisOperation",
    "EquipmentChassisProfile",
    "EquipmentChassisProfileAssocCtx",
    "EquipmentChassisProfileFsm",
    "EquipmentChassisProfileFsmStage",
    "EquipmentChassisProfileFsmTask",
    "EquipmentChassisQual",
    "EquipmentChassisRequirement",
    "EquipmentChassisStats",
    "EquipmentChassisStatsHist",
    "EquipmentCimcVmedia",
    "EquipmentComputeConn",
    "EquipmentComputeConnPolicy",
    "EquipmentCrossFabricModule",
    "EquipmentCrossFabricModuleCapProvider",
    "EquipmentDriveSecCap",
    "EquipmentFan",
    "EquipmentFanModule",
    "EquipmentFanModuleCapProvider",
    "EquipmentFanModuleStats",
    "EquipmentFanModuleStatsHist",
    "EquipmentFanModulesDef",
    "EquipmentFanStats",
    "EquipmentFanStatsHist",
    "EquipmentFex",
    "EquipmentFexCapProvider",
    "EquipmentFexEnvStats",
    "EquipmentFexEnvStatsHist",
    "EquipmentFexOperation",
    "EquipmentFexPowerSummary",
    "EquipmentFexPowerSummaryHist",
    "EquipmentFexPsuInputStats",
    "EquipmentFexPsuInputStatsHist",
    "EquipmentFruVariant",
    "EquipmentGemCapProvider",
    "EquipmentGraphicsCardCapProvider",
    "EquipmentHealthLed",
    "EquipmentHostIfCapProvider",
    "EquipmentIOCard",
    "EquipmentIOCardCapProvider",
    "EquipmentIOCardStats",
    "EquipmentIOCardStatsHist",
    "EquipmentImpliedStorageEnclosureDef",
    "EquipmentIndicatorLed",
    "EquipmentInstance",
    "EquipmentInstanceMapping",
    "EquipmentLocalDiskCapProvider",
    "EquipmentLocalDiskControllerCapProvider",
    "EquipmentLocalDiskDef",
    "EquipmentLocalTemplDef",
    "EquipmentLocatorLed",
    "EquipmentLocatorLedOperation",
    "EquipmentManufacturingDef",
    "EquipmentMemoryUnitCapProvider",
    "EquipmentNetworkElementFanStats",
    "EquipmentNetworkElementFanStatsHist",
    "EquipmentPciDef",
    "EquipmentPcieConnectorCapProvider",
    "EquipmentPcieConnectorUnit",
    "EquipmentPcieNode",
    "EquipmentPcieNodeCapProvider",
    "EquipmentPhysicalQual",
    "EquipmentPicture",
    "EquipmentPool",
    "EquipmentPoolable",
    "EquipmentPoolingPolicy",
    "EquipmentProcessorUnitCapProvider",
    "EquipmentPsu",
    "EquipmentPsuCapProvider",
    "EquipmentPsuInputStats",
    "EquipmentPsuInputStatsHist",
    "EquipmentPsuOutputStats",
    "EquipmentPsuOutputStatsHist",
    "EquipmentPsuStats",
    "EquipmentPsuStatsHist",
    "EquipmentQual",
    "EquipmentRackUnitCapProvider",
    "EquipmentRackUnitFanStats",
    "EquipmentRackUnitFanStatsHist",
    "EquipmentRackUnitPsuStats",
    "EquipmentRackUnitPsuStatsHist",
    "EquipmentRequirement",
    "EquipmentSecureBoot",
    "EquipmentServerFeatureCap",
    "EquipmentServerUnitCapProvider",
    "EquipmentSharedIOModule",
    "EquipmentSiocTempStats",
    "EquipmentSiocTempStatsHist",
    "EquipmentStorageProcessorCap",
    "EquipmentSwitchCapProvider",
    "EquipmentSwitchCard",
    "EquipmentSwitchIOCard",
    "EquipmentSwitchIOCardCapProvider",
    "EquipmentSystemFruCapProvider",
    "EquipmentSystemIOController",
    "EquipmentSystemIOControllerOperation",
    "EquipmentTemplate",
    "EquipmentTemplateMapping",
    "EquipmentTier",
    "EquipmentUnifiedPortCapProvider",
    "EquipmentXFMTypeDef",
    "EquipmentXcvr",
    "EtherErrStats",
    "EtherErrStatsHist",
    "EtherFcoeInterfaceStats",
    "EtherFcoeInterfaceStatsHist",
    "EtherLossStats",
    "EtherLossStatsHist",
    "EtherPIo",
    "EtherPauseStats",
    "EtherPauseStatsHist",
    "EtherRxStats",
    "EtherRxStatsHist",
    "EtherServerIntFIo",
    "EtherSwitchIntFIo",
    "EtherTxStats",
    "EtherTxStatsHist",
    "EventApplication",
    "EventEpCtrl",
    "EventHolder",
    "EventInst",
    "EventLog",
    "EventPolicy",
    "EventRecord",
    "ExtmgmtArpTargets",
    "ExtmgmtGatewayPing",
    "ExtmgmtIfMonPolicy",
    "ExtmgmtMiiStatus",
    "ExtmgmtNdiscTargets",
    "ExtpolClient",
    "ExtpolClientCont",
    "ExtpolClientFsm",
    "ExtpolClientFsmStage",
    "ExtpolClientFsmTask",
    "ExtpolController",
    "ExtpolControllerCont",
    "ExtpolDomain",
    "ExtpolEp",
    "ExtpolEpFsm",
    "ExtpolEpFsmStage",
    "ExtpolEpFsmTask",
    "ExtpolHBStatus",
    "ExtpolProvider",
    "ExtpolProviderCont",
    "ExtpolRegistry",
    "ExtpolRegistryCapability",
    "ExtpolSystemContext",
    "ExtpolVersionHolder",
    "ExtvmmNetworkSets",
    "ExtvmmVMNetworkSets",
    "FabricBreakout",
    "FabricBreakoutOperation",
    "FabricCabling",
    "FabricCablingSw",
    "FabricCartridgeSlotEp",
    "FabricCartridgeSlotEpOperation",
    "FabricCdpLinkPolicy",
    "FabricChangedObjectRef",
    "FabricChassisEp",
    "FabricComputeMSlotEp",
    "FabricComputePhEp",
    "FabricComputePhEpOperation",
    "FabricComputeSlotEp",
    "FabricComputeSlotEpOperation",
    "FabricConsumer",
    "FabricDceSrv",
    "FabricDceSwSrv",
    "FabricDceSwSrvEp",
    "FabricDceSwSrvEpOperation",
    "FabricDceSwSrvPc",
    "FabricDceSwSrvPcEp",
    "FabricDceSwSrvPcEpOperation",
    "FabricDceSwSrvPcOperation",
    "FabricDceSwSrvPcOperationFsm",
    "FabricDceSwSrvPcOperationFsmStage",
    "FabricDomainEp",
    "FabricEnclosurePhEp",
    "FabricEnclosurePhEpOperation",
    "FabricEnclosureSlotEp",
    "FabricEnclosureSlotEpOperation",
    "FabricEp",
    "FabricEthEstc",
    "FabricEthEstcCloud",
    "FabricEthEstcEp",
    "FabricEthEstcEpOperation",
    "FabricEthEstcEpOperationFsm",
    "FabricEthEstcEpOperationFsmStage",
    "FabricEthEstcPc",
    "FabricEthEstcPcEp",
    "FabricEthEstcPcEpOperation",
    "FabricEthEstcPcOperation",
    "FabricEthEstcPcOperationFsm",
    "FabricEthEstcPcOperationFsmStage",
    "FabricEthLan",
    "FabricEthLanEp",
    "FabricEthLanEpOperation",
    "FabricEthLanEpOperationFsm",
    "FabricEthLanEpOperationFsmStage",
    "FabricEthLanPc",
    "FabricEthLanPcEp",
    "FabricEthLanPcEpOperation",
    "FabricEthLanPcOperation",
    "FabricEthLanPcOperationFsm",
    "FabricEthLanPcOperationFsmStage",
    "FabricEthLinkProfile",
    "FabricEthMon",
    "FabricEthMonDestEp",
    "FabricEthMonDestEpOperation",
    "FabricEthMonLan",
    "FabricEthMonOperation",
    "FabricEthMonOperationFsm",
    "FabricEthMonOperationFsmStage",
    "FabricEthMonSrcEp",
    "FabricEthMonSrcEpOperation",
    "FabricEthMonSrcRef",
    "FabricEthPortOperationFsm",
    "FabricEthPortOperationFsmStage",
    "FabricEthTargetEp",
    "FabricEthTargetEpOperation",
    "FabricEthVlanPc",
    "FabricEthVlanPortEp",
    "FabricEtherRef",
    "FabricExtension",
    "FabricFIPortOperationFsm",
    "FabricFIPortOperationFsmStage",
    "FabricFIPortOperationFsmTask",
    "FabricFcEndpoint",
    "FabricFcEstc",
    "FabricFcEstcCloud",
    "FabricFcEstcEp",
    "FabricFcEstcEpOperation",
    "FabricFcEstcEpOperationFsm",
    "FabricFcEstcEpOperationFsmStage",
    "FabricFcMon",
    "FabricFcMonDestEp",
    "FabricFcMonDestEpOperation",
    "FabricFcMonOperation",
    "FabricFcMonOperationFsm",
    "FabricFcMonOperationFsmStage",
    "FabricFcMonSan",
    "FabricFcMonSrcEp",
    "FabricFcMonSrcEpOperation",
    "FabricFcMonSrcRef",
    "FabricFcPortOperationFsm",
    "FabricFcPortOperationFsmStage",
    "FabricFcSan",
    "FabricFcSanEp",
    "FabricFcSanEpOperation",
    "FabricFcSanEpOperationFsm",
    "FabricFcSanEpOperationFsmStage",
    "FabricFcSanPc",
    "FabricFcSanPcEp",
    "FabricFcSanPcEpOperation",
    "FabricFcSanPcOperation",
    "FabricFcSanPcOperationFsm",
    "FabricFcSanPcOperationFsmStage",
    "FabricFcUplinkOperation",
    "FabricFcUserZone",
    "FabricFcUserZoneIvt",
    "FabricFcVsanPc",
    "FabricFcVsanPortEp",
    "FabricFcZoneProfile",
    "FabricFcZoneProfileFsm",
    "FabricFcZoneProfileFsmStage",
    "FabricFcZoneProfileFsmTask",
    "FabricFcZoneProfileIvt",
    "FabricFcoeEstcEp",
    "FabricFcoeEstcEpOperation",
    "FabricFcoeEstcEpOperationFsm",
    "FabricFcoeEstcEpOperationFsmStage",
    "FabricFcoeSanEp",
    "FabricFcoeSanEpOperation",
    "FabricFcoeSanEpOperationFsm",
    "FabricFcoeSanEpOperationFsmStage",
    "FabricFcoeSanPc",
    "FabricFcoeSanPcEp",
    "FabricFcoeSanPcEpOperation",
    "FabricFcoeSanPcOperation",
    "FabricFcoeSanPcOperationFsm",
    "FabricFcoeSanPcOperationFsmStage",
    "FabricFcoeVsanPc",
    "FabricFcoeVsanPortEp",
    "FabricHolder",
    "FabricIf",
    "FabricLacpPolicy",
    "FabricLanAccessMgr",
    "FabricLanCloud",
    "FabricLanCloudPolicy",
    "FabricLanMonCloud",
    "FabricLanPinGroup",
    "FabricLanPinGroupOperation",
    "FabricLanPinTarget",
    "FabricLanPinTargetOperation",
    "FabricLastAckedSlot",
    "FabricMulticastPolicy",
    "FabricNetGroup",
    "FabricNetGroupEp",
    "FabricNetGroupPermit",
    "FabricNetGroupRef",
    "FabricNetGroupReq",
    "FabricOrgVlanPolicy",
    "FabricPoolableVlan",
    "FabricPooledVlan",
    "FabricSanCloud",
    "FabricSanGroup",
    "FabricSanGroupRef",
    "FabricSanMonCloud",
    "FabricSanPinGroup",
    "FabricSanPinGroupOperation",
    "FabricSanPinTarget",
    "FabricSanPinTargetOperation",
    "FabricSubGroup",
    "FabricSwChPhEp",
    "FabricSwChPhEpOperation",
    "FabricSwSubGroup",
    "FabricSystem",
    "FabricUdldLinkPolicy",
    "FabricUdldPolicy",
    "FabricVCon",
    "FabricVConProfile",
    "FabricVlan",
    "FabricVlanEp",
    "FabricVlanGroupReq",
    "FabricVlanPermit",
    "FabricVlanPermitItem",
    "FabricVlanReq",
    "FabricVnetEpSyncEp",
    "FabricVnetEpSyncEpFsm",
    "FabricVnetEpSyncEpFsmStage",
    "FabricVnetEpSyncEpFsmTask",
    "FabricVsan",
    "FabricVsanEp",
    "FabricVsanMembership",
    "FaultDomainEp",
    "FaultDomainInst",
    "FaultGlobalSeverityHolder",
    "FaultGlobalTypedHolder",
    "FaultHolder",
    "FaultInst",
    "FaultLocalTypedHolder",
    "FaultPolicy",
    "FaultSummary",
    "FaultSummaryInst",
    "FaultSvcSummary",
    "FaultTypedHolder",
    "FcErrStats",
    "FcErrStatsHist",
    "FcPIo",
    "FcStats",
    "FcStatsHist",
    "FcpoolAddr",
    "FcpoolBlock",
    "FcpoolBootTarget",
    "FcpoolFormat",
    "FcpoolInitiator",
    "FcpoolInitiatorEp",
    "FcpoolInitiators",
    "FcpoolUniverse",
    "FdBlade",
    "FdBladeFsm",
    "FdBladeFsmStage",
    "FdChassis",
    "FdPhysicalFsm",
    "FdPhysicalFsmStage",
    "FdPhysicalFsmTask",
    "FdRackUnit",
    "FdRackUnitFsm",
    "FdRackUnitFsmStage",
    "FeatureCatalogEp",
    "FeatureChassisDef",
    "FeatureEnvDef",
    "FeatureNetworkDef",
    "FeatureServerDef",
    "FeatureStorageDef",
    "FirmwareAck",
    "FirmwareAutoSyncPolicy",
    "FirmwareBootDefinition",
    "FirmwareBootUnit",
    "FirmwareBundleInfo",
    "FirmwareBundleInfoDigest",
    "FirmwareBundleType",
    "FirmwareBundleTypeCapProvider",
    "FirmwareCatalogPack",
    "FirmwareCatalogPackConfig",
    "FirmwareCatalogue",
    "FirmwareChassisComponentSpec",
    "FirmwareChassisPack",
    "FirmwareCompSource",
    "FirmwareCompTarget",
    "FirmwareComponentSpec",
    "FirmwareComputeHostPack",
    "FirmwareComputeMgmtPack",
    "FirmwareComputeStoragePack",
    "FirmwareConnectionPolicy",
    "FirmwareDependency",
    "FirmwareDistImage",
    "FirmwareDistributable",
    "FirmwareDistributableFsm",
    "FirmwareDistributableFsmStage",
    "FirmwareDistributableFsmTask",
    "FirmwareDomainInfo",
    "FirmwareDomainInfraProfile",
    "FirmwareDownloadPolicy",
    "FirmwareDownloader",
    "FirmwareDownloaderFsm",
    "FirmwareDownloaderFsmStage",
    "FirmwareDownloaderFsmTask",
    "FirmwareExcludeChassisComponent",
    "FirmwareExcludeServerComponent",
    "FirmwareImage",
    "FirmwareInfra",
    "FirmwareInfraPack",
    "FirmwareInfraPackConfig",
    "FirmwareInfraPolicy",
    "FirmwareInstallImpact",
    "FirmwarePolicy",
    "FirmwareProductFamily",
    "FirmwareRemoteCatalogue",
    "FirmwareRunning",
    "FirmwareSource",
    "FirmwareStatus",
    "FirmwareStoragePack",
    "FirmwareSystem",
    "FirmwareType",
    "FirmwareUpdatable",
    "FirmwareUpgradeDetail",
    "FirmwareUpgradeInfo",
    "FlowctrlDefinition",
    "FlowctrlItem",
    "FsmStatus",
    "GlAppendRule",
    "GlBlockEp",
    "GlBlockOp",
    "GlByMo",
    "GlComplexRefEp",
    "GlConflictEp",
    "GlConflictResolutionRuleEp",
    "GlDomainEp",
    "GlEp",
    "GlGlobalDefaultPolicyEp",
    "GlIdRef",
    "GlIdRefEp",
    "GlIdentCtxEp",
    "GlIdentCtxOp",
    "GlIdentCtxResOp",
    "GlIdentCtxResOpFsm",
    "GlIdentCtxResOpFsmStage",
    "GlIdentCtxResOpFsmTask",
    "GlInventoryEp",
    "GlLsp",
    "GlMcastPolicy",
    "GlOperationEp",
    "GlPathEp",
    "GlPolicy",
    "GlPolicyAlgorithmedOp",
    "GlPolicyEp",
    "GlPolicyInvEp",
    "GlPolicyNameRuleEp",
    "GlPolicyOp",
    "GlPolicyRef",
    "GlPolicyRefEp",
    "GlPolicyResOp",
    "GlPolicyResolutionEp",
    "GlPool",
    "GlPoolEp",
    "GlPoolInvEp",
    "GlPoolOp",
    "GlRefsEp",
    "GlRequest",
    "GlRequestFsm",
    "GlRequestFsmStage",
    "GlRequestFsmTask",
    "GlRequestVnetEp",
    "GlRequestVnetEpDomainEp",
    "GlRequestVnetEpDomainEpFsm",
    "GlRequestVnetEpDomainEpFsmStage",
    "GlRequestVnetEpDomainEpFsmTask",
    "GlRequestVnetEpFsm",
    "GlRequestVnetEpFsmStage",
    "GlRequestVnetEpFsmTask",
    "GlRequestVnetEpHolder",
    "GlRequestor",
    "GlRequestorEp",
    "GlSPInvEp",
    "GlServerPoolResOp",
    "GlServiceProfile",
    "GlSpDefEp",
    "GlTemplateEp",
    "GlTemplateOp",
    "GlTemplateResOp",
    "GlUsage",
    "GlUsageEp",
    "GlVlan",
    "GlVnetInvHolder",
    "GlVnicTemplate",
    "GlVnicTemplateEp",
    "GlVsan",
    "GlVxanEp",
    "GlVxanOp",
    "GlVxanResOp",
    "GmetaClass",
    "GmetaPolicyMapElement",
    "GmetaProp",
    "GraphicsCard",
    "GraphicsController",
    "GuiGuiComponent",
    "GuiGuiCont",
    "HcAdapterFirmwareItem",
    "HcAdapterItem",
    "HcAdmin",
    "HcCatalog",
    "HcCatalogList",
    "HcCatalogSource",
    "HcCatalogVersion",
    "HcCleanup",
    "HcDownloadPolicy",
    "HcDownloader",
    "HcDriverInfoItem",
    "HcDriverItem",
    "HcHolder",
    "HcItemNote",
    "HcOsInfoItem",
    "HcOsItem",
    "HcReport",
    "HcScopeDn",
    "HcServerComponent",
    "HcSupportedAdapterFirmwareItem",
    "HcSupportedAdapterItem",
    "HcSupportedDriverItem",
    "HcSupportedOsItem",
    "HcUcsVersionItem",
    "IdentDomainSyncEp",
    "IdentExecutionEp",
    "IdentExecutionRequestEp",
    "IdentIdentCtx",
    "IdentIdentRequest",
    "IdentIdentRequestFsm",
    "IdentIdentRequestFsmStage",
    "IdentIdentRequestFsmTask",
    "IdentMetaSystem",
    "IdentMetaSystemFsm",
    "IdentMetaSystemFsmStage",
    "IdentMetaSystemFsmTask",
    "IdentMetaVerse",
    "IdentRequestEp",
    "IdentSysInfo",
    "IdentpoolBlockQual",
    "IdentpoolConsumed",
    "IdentpoolDomain",
    "IdentpoolDomainGroupQual",
    "IdentpoolIPQual",
    "IdentpoolIPV6Qual",
    "IdentpoolMetaSystem",
    "IdentpoolMetaVerse",
    "IdentpoolPoolable",
    "InbandPolicy",
    "InitiatorFcInitiatorEp",
    "InitiatorGroupEp",
    "InitiatorIScsiInitiatorEp",
    "InitiatorLunEp",
    "InitiatorMemberEp",
    "InitiatorRequestorEp",
    "InitiatorRequestorGrpEp",
    "InitiatorStoreEp",
    "InitiatorUnitEp",
    "InventoryDomainEp",
    "InventoryEp",
    "InventoryGlobalEp",
    "InventoryHolder",
    "InventoryInventoryMoMeta",
    "IpIPv4Dns",
    "IpIpV4StaticAddr",
    "IpServiceIf",
    "IppoolAddr",
    "IppoolBlock",
    "IppoolIpV6Addr",
    "IppoolIpV6Block",
    "IppoolIpV6Pooled",
    "IppoolPool",
    "IppoolPooled",
    "IppoolUniverse",
    "IqnpoolAddr",
    "IqnpoolBlock",
    "IqnpoolFormat",
    "IqnpoolPool",
    "IqnpoolPooled",
    "IqnpoolTransportBlock",
    "IqnpoolUniverse",
    "IscsiAuthProfile",
    "LicenseContents",
    "LicenseDomain",
    "LicenseDownloader",
    "LicenseDownloaderFsm",
    "LicenseDownloaderFsmStage",
    "LicenseDownloaderFsmTask",
    "LicenseEp",
    "LicenseFeature",
    "LicenseFeatureCapProvider",
    "LicenseFeatureLine",
    "LicenseFile",
    "LicenseFileFsm",
    "LicenseFileFsmStage",
    "LicenseFileFsmTask",
    "LicenseInstance",
    "LicenseInstanceFsm",
    "LicenseInstanceFsmStage",
    "LicenseInstanceFsmTask",
    "LicenseProp",
    "LicenseServerHostId",
    "LicenseSource",
    "LicenseSourceFile",
    "LsBinding",
    "LsFcLocale",
    "LsFcZone",
    "LsFcZoneGroup",
    "LsIdentityInfo",
    "LsIssues",
    "LsPower",
    "LsRequirement",
    "LsSPMeta",
    "LsServer",
    "LsServerAssocCtx",
    "LsServerExtension",
    "LsServerFsm",
    "LsServerFsmStage",
    "LsServerFsmTask",
    "LsServerOperation",
    "LsTier",
    "LsVConAssign",
    "LsWaitingUserAck",
    "LsZoneInitiatorMember",
    "LsZoneTargetMember",
    "LsbootBootSecurity",
    "LsbootDef",
    "LsbootDefaultLocalImage",
    "LsbootEFIShell",
    "LsbootEmbeddedLocalDiskImage",
    "LsbootEmbeddedLocalDiskImagePath",
    "LsbootEmbeddedLocalLunImage",
    "LsbootIScsi",
    "LsbootIScsiImagePath",
    "LsbootLan",
    "LsbootLanImagePath",
    "LsbootLocalDiskImage",
    "LsbootLocalDiskImagePath",
    "LsbootLocalHddImage",
    "LsbootLocalLunImagePath",
    "LsbootLocalStorage",
    "LsbootNvme",
    "LsbootNvmeDiskSsd",
    "LsbootNvmePciSsd",
    "LsbootPolicy",
    "LsbootSan",
    "LsbootSanCatSanImage",
    "LsbootSanCatSanImagePath",
    "LsbootSanImage",
    "LsbootSanImagePath",
    "LsbootStorage",
    "LsbootUEFIBootParam",
    "LsbootUpgradeStatus",
    "LsbootUsbExternalImage",
    "LsbootUsbFlashStorageImage",
    "LsbootUsbInternalImage",
    "LsbootVirtualMedia",
    "LsmaintAck",
    "LsmaintMaintPolicy",
    "LstorageAck",
    "LstorageArrayRequirement",
    "LstorageBlade",
    "LstorageControllerDef",
    "LstorageControllerModeConfig",
    "LstorageControllerQualifier",
    "LstorageControllerRef",
    "LstorageCtrlServiceOperation",
    "LstorageDasScsiLun",
    "LstorageDiskGroupConfigDef",
    "LstorageDiskGroupConfigPolicy",
    "LstorageDiskGroupQualifier",
    "LstorageDiskSlot",
    "LstorageDiskZoningConfigDef",
    "LstorageDiskZoningPolicy",
    "LstorageDriveSecurity",
    "LstorageExtension",
    "LstorageLocal",
    "LstorageLocalDef",
    "LstorageLocalDiskConfigRef",
    "LstorageLocalDiskRef",
    "LstorageLogin",
    "LstorageMeta",
    "LstorageProfile",
    "LstorageProfileBinding",
    "LstorageProfileDef",
    "LstorageRecurrWindow",
    "LstorageRemote",
    "LstorageRemoteDef",
    "LstorageRequestCtx",
    "LstorageSecurity",
    "LstorageVirtualDriveDef",
    "MacpoolAddr",
    "MacpoolBlock",
    "MacpoolFormat",
    "MacpoolPool",
    "MacpoolPooled",
    "MacpoolUniverse",
    "MemoryArray",
    "MemoryArrayEnvStats",
    "MemoryArrayEnvStatsHist",
    "MemoryBufferUnit",
    "MemoryBufferUnitEnvStats",
    "MemoryBufferUnitEnvStatsHist",
    "MemoryErrorStats",
    "MemoryErrorStatsHist",
    "MemoryNvDimm",
    "MemoryNvDimmBattery",
    "MemoryNvDimmController",
    "MemoryQual",
    "MemoryRuntime",
    "MemoryRuntimeHist",
    "MemoryUnit",
    "MemoryUnitEnvStats",
    "MemoryUnitEnvStatsHist",
    "MessageEntry",
    "MessageEp",
    "MgmtBackup",
    "MgmtBackupFsm",
    "MgmtBackupFsmStage",
    "MgmtBackupFsmTask",
    "MgmtBackupOperation",
    "MgmtBackupPolicy",
    "MgmtBackupTrigger",
    "MgmtBackupTriggerFsm",
    "MgmtBackupTriggerFsmStage",
    "MgmtBackupTriggerFsmTask",
    "MgmtCfgExportPolicy",
    "MgmtCmcSecureBoot",
    "MgmtCmcSecureBootOperation",
    "MgmtConnection",
    "MgmtController",
    "MgmtDataExporter",
    "MgmtDataExporterFsm",
    "MgmtDataExporterFsmStage",
    "MgmtDataExporterFsmTask",
    "MgmtDataImporter",
    "MgmtDataImporterFsm",
    "MgmtDataImporterFsmStage",
    "MgmtDataImporterFsmTask",
    "MgmtDataItem",
    "MgmtEntity",
    "MgmtEp",
    "MgmtIPv6IfAddr",
    "MgmtIPv6IfConfig",
    "MgmtIf",
    "MgmtIfFsm",
    "MgmtIfFsmStage",
    "MgmtIfFsmTask",
    "MgmtImportItem",
    "MgmtImporter",
    "MgmtImporterFsm",
    "MgmtImporterFsmStage",
    "MgmtImporterFsmTask",
    "MgmtInbandProfile",
    "MgmtInterface",
    "MgmtKmip",
    "MgmtKmipCertPolicy",
    "MgmtKmipOperation",
    "MgmtNamedKmipCertPolicy",
    "MgmtRegistryInfo",
    "MgmtRegistryInfoFsm",
    "MgmtRegistryInfoFsmStage",
    "MgmtRegistryInfoFsmTask",
    "MgmtSecurity",
    "MgmtSvc",
    "MgmtVnet",
    "NetNetGroupPermit",
    "NetworkElement",
    "NetworkElementFsm",
    "NetworkElementFsmStage",
    "NetworkElementFsmTask",
    "NetworkElementOperation",
    "NetworkSystemCACert",
    "NfsClientDef",
    "NfsClientDefFsm",
    "NfsClientDefFsmStage",
    "NfsClientDefFsmTask",
    "NfsEp",
    "NfsExportDef",
    "NfsExportDefFsm",
    "NfsExportDefFsmStage",
    "NfsExportDefFsmTask",
    "NfsMountDef",
    "NfsRepositorySpecPolicy",
    "NwctrlDefinition",
    "ObserveFilter",
    "ObserveObserved",
    "ObserveObservedCont",
    "ObserveObservedFsm",
    "ObserveObservedFsmStage",
    "ObserveObservedFsmTask",
    "OrgDomainFirmwareInfo",
    "OrgDomainGroup",
    "OrgDomainGroupFirmwareReport",
    "OrgDomainGroupPolicy",
    "OrgDomainGroupPolicyReport",
    "OrgExtension",
    "OrgFirmwareVersionCount",
    "OrgMaintTagFirmwareReport",
    "OrgOrg",
    "OrgOrgFsm",
    "OrgOrgFsmStage",
    "OrgOrgFsmTask",
    "OrgOrgSource",
    "OrgSourceMask",
    "OsController",
    "OsEthBondIntf",
    "OsEthIntf",
    "OsInstance",
    "OsPrimarySlave",
    "PkiCertReq",
    "PkiEp",
    "PkiEpFsm",
    "PkiEpFsmStage",
    "PkiEpFsmTask",
    "PkiKeyRing",
    "PkiTP",
    "PolicyChildClass",
    "PolicyCluster",
    "PolicyCommunication",
    "PolicyCommunicationOp",
    "PolicyConfigBackup",
    "PolicyConfigBackupOp",
    "PolicyConfigError",
    "PolicyContext",
    "PolicyControlEp",
    "PolicyControlEpOp",
    "PolicyControlEpOpFsm",
    "PolicyControlEpOpFsmStage",
    "PolicyControlEpOpFsmTask",
    "PolicyControlEpOperation",
    "PolicyControlledInstance",
    "PolicyControlledType",
    "PolicyDateTime",
    "PolicyDateTimeOp",
    "PolicyDestClass",
    "PolicyDestEp",
    "PolicyDeviceProfile",
    "PolicyDigest",
    "PolicyDiscovery",
    "PolicyDiscoveryOp",
    "PolicyDns",
    "PolicyDnsOp",
    "PolicyElement",
    "PolicyEquipment",
    "PolicyEquipmentOp",
    "PolicyFault",
    "PolicyFaultOp",
    "PolicyIdentifierPolicy",
    "PolicyInfraFirmware",
    "PolicyInfraFirmwareOp",
    "PolicyLocalMap",
    "PolicyLogProfile",
    "PolicyMEp",
    "PolicyMEpOp",
    "PolicyModularChassisFan",
    "PolicyModularChassisFanOp",
    "PolicyMonitoring",
    "PolicyMonitoringOp",
    "PolicyPolicyDestClass",
    "PolicyPolicyEp",
    "PolicyPolicyRequestor",
    "PolicyPolicyScope",
    "PolicyPolicyScopeCont",
    "PolicyPolicyScopeContext",
    "PolicyPolicyScopeFsm",
    "PolicyPolicyScopeFsmStage",
    "PolicyPolicyScopeFsmTask",
    "PolicyPortConfig",
    "PolicyPortConfigOp",
    "PolicyPowerExtended",
    "PolicyPowerExtendedOp",
    "PolicyPowerMgmt",
    "PolicyPowerMgmtOp",
    "PolicyPowerSave",
    "PolicyPowerSaveOp",
    "PolicyProxyMo",
    "PolicyPsu",
    "PolicyPsuOp",
    "PolicyRequestor",
    "PolicyScope",
    "PolicySecurity",
    "PolicySecurityOp",
    "PolicySource",
    "PolicySourceApp",
    "PolicyStorageAutoConfig",
    "PolicyStorageAutoConfigOp",
    "PolicySystemEp",
    "PolicySystemProfile",
    "PolicyTracker",
    "PolicyUniverse",
    "PortGroup",
    "PortSubGroup",
    "PowerBudget",
    "PowerChassisMember",
    "PowerEp",
    "PowerGroup",
    "PowerGroupQual",
    "PowerGroupStats",
    "PowerGroupStatsHist",
    "PowerMgmtPolicy",
    "PowerPolicy",
    "PowerProfiledPower",
    "ProcDoer",
    "ProcManager",
    "ProcPrt",
    "ProcPrtCounts",
    "ProcStimulusCounts",
    "ProcSvc",
    "ProcTxCounts",
    "ProcessorEnvStats",
    "ProcessorEnvStatsHist",
    "ProcessorErrorStats",
    "ProcessorErrorStatsHist",
    "ProcessorQual",
    "ProcessorRuntime",
    "ProcessorRuntimeHist",
    "ProcessorUnit",
    "ProcessorUnitAssocCtx",
    "QosclassDefinition",
    "QosclassEthBE",
    "QosclassEthClassified",
    "QosclassFc",
    "QosclassPolicy",
    "QueryDependencyContext",
    "QueryDependencyRef",
    "QueryEp",
    "QueryImportContext",
    "QueryUsageContext",
    "QueryresultDependency",
    "QueryresultDomainGroupEp",
    "QueryresultOrgEp",
    "QueryresultUsage",
    "SecurityUnit",
    "SesDiskSlotEp",
    "SesEnclosure",
    "SmartcallhomeHttpProxy",
    "SmartcallhomePeriodicInventoryStatus",
    "SmartcallhomePeriodicSystemInventory",
    "SmartcallhomePolicy",
    "SmartcallhomeProfile",
    "SmartcallhomeSource",
    "SmartcallhomeTransportGateway",
    "SmartlicenseAgent",
    "SmartlicenseAgentFsm",
    "SmartlicenseAgentFsmStage",
    "SmartlicenseAgentFsmTask",
    "SmartlicenseEntitlement",
    "SmartlicenseEntitlementEp",
    "SmartlicenseEntitlementEpFsm",
    "SmartlicenseEntitlementEpFsmStage",
    "SmartlicenseEntitlementEpFsmTask",
    "SmartlicenseEp",
    "SmartlicenseHolder",
    "SmartlicenseHolderFsm",
    "SmartlicenseHolderFsmStage",
    "SmartlicenseHolderFsmTask",
    "SmartlicenseTest",
    "SmartlicenseTestFsm",
    "SmartlicenseTestFsmStage",
    "SmartlicenseTestFsmTask",
    "SolPolicy",
    "StatsChartContainer",
    "StatsCollectionPolicy",
    "StatsCustomChart",
    "StatsCustomEp",
    "StatsDbMigrationStatus",
    "StatsDbSummaryMeta",
    "StatsHolder",
    "StatsInventoryMeta",
    "StatsPasadenaCollectionPolicy",
    "StatsStandardChart",
    "StatsStandardEp",
    "StatsStatsQuery",
    "StatsStatsQueryHolder",
    "StatsThr32Definition",
    "StatsThr32Value",
    "StatsThr64Definition",
    "StatsThr64Value",
    "StatsThrFloatDefinition",
    "StatsThrFloatValue",
    "StatsThresholdClass",
    "StatsThresholdPolicy",
    "StorageArray",
    "StorageAuthKey",
    "StorageBlade",
    "StorageCloud",
    "StorageClusterIdUniverse",
    "StorageComputeBladeOperation",
    "StorageConnectionDef",
    "StorageConnectionPolicy",
    "StorageController",
    "StorageControllerEp",
    "StorageControllerOperation",
    "StorageControllerRef",
    "StorageCtrlStorageStats",
    "StorageCtrlStorageStatsHist",
    "StorageDiskEnvStats",
    "StorageDiskEnvStatsHist",
    "StorageDiskEp",
    "StorageDiskGroup",
    "StorageEmbeddedStorage",
    "StorageEnclosure",
    "StorageEnclosureDiskSlotEp",
    "StorageEnclosureLocalDiskConfig",
    "StorageEpUser",
    "StorageEthLif",
    "StorageEtherIf",
    "StorageFcIf",
    "StorageFcTargetEp",
    "StorageFcTargetIf",
    "StorageFlexFlashCard",
    "StorageFlexFlashController",
    "StorageFlexFlashControllerOperation",
    "StorageFlexFlashDrive",
    "StorageFlexFlashVirtualDrive",
    "StorageHddMotherBoardTempStats",
    "StorageHddMotherBoardTempStatsHist",
    "StorageIScsiInitiatorEp",
    "StorageIScsiTargetIf",
    "StorageIniGroup",
    "StorageInitiator",
    "StorageInitiatorRef",
    "StorageIpV4PooledAddr",
    "StorageIpV4StaticAddr",
    "StorageItem",
    "StorageLocalDisk",
    "StorageLocalDiskConfigDef",
    "StorageLocalDiskConfigPolicy",
    "StorageLocalDiskEp",
    "StorageLocalDiskOperation",
    "StorageLocalDiskPartition",
    "StorageLocalLun",
    "StorageLunCounters",
    "StorageLunDisk",
    "StorageLunMaskGroup",
    "StorageLunReplica",
    "StorageLunResourceSelectionLog",
    "StorageLunSnapshot",
    "StorageMeta",
    "StorageMezzFlashLife",
    "StorageNodeEp",
    "StorageNvmeStats",
    "StorageNvmeStatsHist",
    "StorageNvmeStorage",
    "StorageOnboardDevice",
    "StorageOperation",
    "StoragePartition",
    "StorageProcessor",
    "StorageProcessorEp",
    "StorageProcessorRuntime",
    "StorageQual",
    "StorageRaidBattery",
    "StorageReplicationCtx",
    "StorageSasExpander",
    "StorageSasPort",
    "StorageSasUpLink",
    "StorageScsiDeviceDescriptor",
    "StorageScsiLun",
    "StorageScsiLunCtx",
    "StorageScsiLunInstRef",
    "StorageScsiLunMask",
    "StorageScsiLunRef",
    "StorageSnapshotCtx",
    "StorageSsdHealthStats",
    "StorageSsdHealthStatsHist",
    "StorageStorageStats",
    "StorageStorageStatsHist",
    "StorageSystem",
    "StorageTransportableFlashModule",
    "StorageUsageCounters",
    "StorageVDMemberEp",
    "StorageVirtualDrive",
    "StorageVirtualDriveContainer",
    "StorageVirtualDriveEp",
    "StorageVirtualDriveOperation",
    "StorageVirtualDriveRef",
    "StorageVirtualDriveRefOperation",
    "StorageVolume",
    "StorageVsanRef",
    "StorageVsanRefIvt",
    "SwCardEnvStats",
    "SwCardEnvStatsHist",
    "SwEnvStats",
    "SwEnvStatsHist",
    "SwSystemStats",
    "SwSystemStatsHist",
    "SyntheticDirectory",
    "SyntheticFile",
    "SyntheticFileSystem",
    "SyntheticFsObj",
    "SyntheticTime",
    "SysdebugAutoCoreFileExportTarget",
    "SysdebugAutoCoreFileExportTargetFsm",
    "SysdebugAutoCoreFileExportTargetFsmStage",
    "SysdebugAutoCoreFileExportTargetFsmTask",
    "SysdebugBackupBehavior",
    "SysdebugCore",
    "SysdebugCoreFileRepository",
    "SysdebugDiagnosticLog",
    "SysdebugEp",
    "SysdebugLogControlDestinationFile",
    "SysdebugLogControlDestinationSyslog",
    "SysdebugLogControlDomain",
    "SysdebugLogControlEp",
    "SysdebugLogControlEpFsm",
    "SysdebugLogControlEpFsmStage",
    "SysdebugLogControlEpFsmTask",
    "SysdebugLogControlModule",
    "SysdebugMEpLogPolicy",
    "SysdebugManualCoreFileExportTarget",
    "SysdebugManualCoreFileExportTargetFsm",
    "SysdebugManualCoreFileExportTargetFsmStage",
    "SysdebugManualCoreFileExportTargetFsmTask",
    "SysdebugTechSupFileRepository",
    "SysdebugTechSupport",
    "SysdebugTechSupportCmdOpt",
    "SysdebugTechSupportFsm",
    "SysdebugTechSupportFsmStage",
    "SysdebugTechSupportFsmTask",
    "SysdebugTechSupportOp",
    "SysdebugTechSupportOperation",
    "SysfileDigest",
    "SysfileMutation",
    "SysfileMutationFsm",
    "SysfileMutationFsmStage",
    "SysfileMutationFsmTask",
    "TagDef",
    "TagDefEp",
    "TagDriver",
    "TagInstance",
    "TagInstanceEp",
    "TagInstanceItem",
    "TagItem",
    "TagSoftwareInst",
    "TestingCliPolicy",
    "TestingServiceProfile",
    "TestingServiceProfileFsm",
    "TestingServiceProfileFsmStage",
    "TestingServiceProfileFsmTask",
    "TestingSnmpCommunity",
    "TestingSnmpPolicy",
    "TestingSnmpSupport",
    "TestingSnmpTrap",
    "TopInfoSyncPolicy",
    "TopMetaInf",
    "TopRoot",
    "TopSystem",
    "TopSystemFsm",
    "TopSystemFsmStage",
    "TopSystemFsmTask",
    "TrigAbsWindow",
    "TrigMeta",
    "TrigPendingAckCount",
    "TrigRecurrWindow",
    "TrigSched",
    "TrigServerToken",
    "TrigTest",
    "TrigTokenRequestor",
    "TrigTriggered",
    "UuidpoolAddr",
    "UuidpoolBlock",
    "UuidpoolFormat",
    "UuidpoolPool",
    "UuidpoolPooled",
    "UuidpoolUniverse",
    "VersionApplication",
    "VersionEp",
    "VersionFilter",
    "VersionMatrix",
    "VersionProduct",
    "VmNic",
    "VnicBootIpPolicy",
    "VnicBootTarget",
    "VnicConnDef",
    "VnicDefBeh",
    "VnicDynamicCon",
    "VnicDynamicConPolicy",
    "VnicDynamicConPolicyRef",
    "VnicEthLif",
    "VnicEther",
    "VnicEtherIf",
    "VnicFault",
    "VnicFc",
    "VnicFcGroupDef",
    "VnicFcGroupTempl",
    "VnicFcIf",
    "VnicFcLif",
    "VnicFcNode",
    "VnicFcOEIf",
    "VnicIPv4Dhcp",
    "VnicIPv4Dns",
    "VnicIPv4If",
    "VnicIPv4IscsiAddr",
    "VnicIPv4PooledIscsiAddr",
    "VnicIPv4StaticRoute",
    "VnicIPv6If",
    "VnicIScsi",
    "VnicIScsiAutoTargetIf",
    "VnicIScsiBootParams",
    "VnicIScsiBootVnic",
    "VnicIScsiInitiatorParams",
    "VnicIScsiLCP",
    "VnicIScsiNode",
    "VnicIScsiStaticTargetIf",
    "VnicIScsiTargetParams",
    "VnicIniGrpFc",
    "VnicIniGrpFcB",
    "VnicIniGrpFcBIf",
    "VnicIniGrpFcIf",
    "VnicIpV4MgmtPooledAddr",
    "VnicIpV4PooledAddr",
    "VnicIpV4ProfDerivedAddr",
    "VnicIpV4StaticAddr",
    "VnicIpV6MgmtPooledAddr",
    "VnicIpV6StaticAddr",
    "VnicLanConnPolicy",
    "VnicLanConnTempl",
    "VnicLifVlan",
    "VnicLifVsan",
    "VnicLstorageIScsi",
    "VnicLun",
    "VnicMgmt",
    "VnicMgmtIf",
    "VnicMonSesFc",
    "VnicMonSesFcIf",
    "VnicNetGroup",
    "VnicNetGroupRef",
    "VnicOutbandMgmtEp",
    "VnicOutbandMgmtEpFsm",
    "VnicOutbandMgmtEpFsmStage",
    "VnicOutbandMgmtEpFsmTask",
    "VnicProfileSet",
    "VnicRackServerDiscoveryProfile",
    "VnicSanConnPolicy",
    "VnicSanConnTempl",
    "VnicSriovHpnConPolicy",
    "VnicSriovHpnConPolicyRef",
    "VnicStorageEthLif",
    "VnicUsnicConPolicy",
    "VnicUsnicConPolicyRef",
    "VnicVhbaBehPolicy",
    "VnicVlan",
    "VnicVmqConPolicy",
    "VnicVmqConPolicyRef",
    "VnicVnicBehPolicy",
    ])

MO_CLASS_META = {
    "AaaAuthRealm": MoMeta("AaaAuthRealm", "aaaAuthRealm", "auth-realm", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin"], ['orgDomainGroup', 'policyDeviceProfile', 'topSystem'], ['aaaAuthRealmFsm', 'aaaConsoleAuth', 'aaaDefaultAuth', 'aaaDomain', 'aaaRealmFsm', 'aaaRealmFsmTask', 'eventInst', 'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "AaaAuthRealmFsm": MoMeta("AaaAuthRealmFsm", "aaaAuthRealmFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['aaaAuthRealm'], ['aaaAuthRealmFsmStage'], [None]),
    "AaaAuthRealmFsmStage": MoMeta("AaaAuthRealmFsmStage", "aaaAuthRealmFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['aaaAuthRealmFsm'], [], [None]),
    "AaaConsoleAuth": MoMeta("AaaConsoleAuth", "aaaConsoleAuth", "console-auth", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin", "domain-group-management"], ['aaaAuthRealm'], [], ["Add", "Get", "Remove", "Set"]),
    "AaaDefaultAuth": MoMeta("AaaDefaultAuth", "aaaDefaultAuth", "default-auth", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin", "domain-group-management"], ['aaaAuthRealm'], [], ["Add", "Get", "Remove", "Set"]),
    "AaaDomain": MoMeta("AaaDomain", "aaaDomain", "domain-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin", "domain-group-management"], ['aaaAuthRealm'], ['aaaDomainAuth'], ["Add", "Get", "Remove", "Set"]),
    "AaaDomainAuth": MoMeta("AaaDomainAuth", "aaaDomainAuth", "domain-auth", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin", "domain-group-management"], ['aaaDomain'], [], ["Add", "Get", "Remove", "Set"]),
    "AaaDomainGroup": MoMeta("AaaDomainGroup", "aaaDomainGroup", "domaingroup-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin"], ['aaaLocale'], [], ["Add", "Get", "Remove"]),
    "AaaEpAuthProfile": MoMeta("AaaEpAuthProfile", "aaaEpAuthProfile", "auth-profile-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], ['orgDomainGroup', 'orgOrg'], ['aaaEpUser'], ["Add", "Get", "Remove", "Set"]),
    "AaaEpFsm": MoMeta("AaaEpFsm", "aaaEpFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['aaaLdapEp', 'aaaRadiusEp', 'aaaTacacsPlusEp'], ['aaaEpFsmStage'], [None]),
    "AaaEpFsmStage": MoMeta("AaaEpFsmStage", "aaaEpFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['aaaEpFsm'], [], [None]),
    "AaaEpFsmTask": MoMeta("AaaEpFsmTask", "aaaEpFsmTask", "task-[item]", VersionMeta.Version101a, "OutputOnly", 0x1, [], [""], ['aaaLdapEp', 'aaaRadiusEp', 'aaaTacacsPlusEp'], [], [None]),
    "AaaEpLogin": MoMeta("AaaEpLogin", "aaaEpLogin", "ep-login-[name]-[id]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], ['aaaUserEp'], [], ["Get"]),
    "AaaEpUser": MoMeta("AaaEpUser", "aaaEpUser", "user-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin", "ls-security", "ls-security-policy"], ['aaaEpAuthProfile'], [], ["Add", "Get", "Remove", "Set"]),
    "AaaExtMgmtCutThruTkn": MoMeta("AaaExtMgmtCutThruTkn", "aaaExtMgmtCutThruTkn", "cutthrutkn-[token]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin"], ['aaaUserEp'], [], ["Get"]),
    "AaaLdapEp": MoMeta("AaaLdapEp", "aaaLdapEp", "ldap-ext", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin"], ['orgDomainGroup', 'policyDeviceProfile', 'topSystem'], ['aaaEpFsm', 'aaaEpFsmTask', 'aaaLdapEpFsm', 'aaaLdapGroup', 'aaaLdapGroupRule', 'aaaLdapProvider', 'aaaProviderGroup', 'eventInst', 'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "AaaLdapEpFsm": MoMeta("AaaLdapEpFsm", "aaaLdapEpFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['aaaLdapEp'], ['aaaLdapEpFsmStage'], [None]),
    "AaaLdapEpFsmStage": MoMeta("AaaLdapEpFsmStage", "aaaLdapEpFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['aaaLdapEpFsm'], [], [None]),
    "AaaLdapGroup": MoMeta("AaaLdapGroup", "aaaLdapGroup", "ldapgroup-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin", "domain-group-management"], ['aaaLdapEp'], ['aaaUserLocale', 'aaaUserRole'], ["Add", "Get", "Remove", "Set"]),
    "AaaLdapGroupRule": MoMeta("AaaLdapGroupRule", "aaaLdapGroupRule", "ldapgroup-rule", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin", "domain-group-management"], ['aaaLdapEp', 'aaaLdapProvider'], [], ["Add", "Get", "Remove", "Set"]),
    "AaaLdapProvider": MoMeta("AaaLdapProvider", "aaaLdapProvider", "provider-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin"], ['aaaLdapEp'], ['aaaLdapGroupRule'], ["Add", "Get", "Remove", "Set"]),
    "AaaLocale": MoMeta("AaaLocale", "aaaLocale", "locale-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin"], ['orgDomainGroup', 'policyDeviceProfile'], ['aaaDomainGroup', 'aaaOrg'], ["Add", "Get", "Remove", "Set"]),
    "AaaLog": MoMeta("AaaLog", "aaaLog", "aaa-log", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin", "operations"], ['topRoot'], ['aaaModLR', 'aaaSessionLR'], ["Get"]),
    "AaaModLR": MoMeta("AaaModLR", "aaaModLR", "aaamlr-[id]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], ['aaaLog'], [], ["Get"]),
    "AaaOrg": MoMeta("AaaOrg", "aaaOrg", "org-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin"], ['aaaLocale'], [], ["Add", "Get", "Remove"]),
    "AaaProviderGroup": MoMeta("AaaProviderGroup", "aaaProviderGroup", "providergroup-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin", "domain-group-management"], ['aaaLdapEp', 'aaaRadiusEp', 'aaaTacacsPlusEp'], ['aaaProviderRef'], ["Add", "Get", "Remove", "Set"]),
    "AaaProviderRef": MoMeta("AaaProviderRef", "aaaProviderRef", "provider-ref-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin", "domain-group-management"], ['aaaProviderGroup'], [], ["Add", "Get", "Remove", "Set"]),
    "AaaPwdProfile": MoMeta("AaaPwdProfile", "aaaPwdProfile", "pwd-profile", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin"], ['aaaUserEp', 'orgDomainGroup', 'policyDeviceProfile'], [], ["Get", "Set"]),
    "AaaRadiusEp": MoMeta("AaaRadiusEp", "aaaRadiusEp", "radius-ext", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin"], ['orgDomainGroup', 'policyDeviceProfile', 'topSystem'], ['aaaEpFsm', 'aaaEpFsmTask', 'aaaProviderGroup', 'aaaRadiusEpFsm', 'aaaRadiusProvider', 'eventInst', 'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "AaaRadiusEpFsm": MoMeta("AaaRadiusEpFsm", "aaaRadiusEpFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['aaaRadiusEp'], ['aaaRadiusEpFsmStage'], [None]),
    "AaaRadiusEpFsmStage": MoMeta("AaaRadiusEpFsmStage", "aaaRadiusEpFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['aaaRadiusEpFsm'], [], [None]),
    "AaaRadiusProvider": MoMeta("AaaRadiusProvider", "aaaRadiusProvider", "provider-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin"], ['aaaRadiusEp'], [], ["Add", "Get", "Remove", "Set"]),
    "AaaRealmFsm": MoMeta("AaaRealmFsm", "aaaRealmFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['aaaAuthRealm'], ['aaaRealmFsmStage'], [None]),
    "AaaRealmFsmStage": MoMeta("AaaRealmFsmStage", "aaaRealmFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['aaaRealmFsm'], [], [None]),
    "AaaRealmFsmTask": MoMeta("AaaRealmFsmTask", "aaaRealmFsmTask", "task-[item]", VersionMeta.Version112a, "OutputOnly", 0x1, [], [""], ['aaaAuthRealm'], [], [None]),
    "AaaRemoteUser": MoMeta("AaaRemoteUser", "aaaRemoteUser", "remoteuser-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin", "domain-group-management"], ['aaaUserEp'], ['aaaSession', 'aaaUserLocale', 'aaaUserRole'], ["Get", "Remove"]),
    "AaaRole": MoMeta("AaaRole", "aaaRole", "role-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin"], ['orgDomainGroup', 'policyDeviceProfile'], [], ["Add", "Get", "Remove", "Set"]),
    "AaaSession": MoMeta("AaaSession", "aaaSession", "term-[id]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin", "domain-group-management"], ['aaaRemoteUser', 'aaaUser'], [], ["Get", "Remove"]),
    "AaaSessionLR": MoMeta("AaaSessionLR", "aaaSessionLR", "aaaslr-[id]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], ['aaaLog'], [], ["Get"]),
    "AaaShellLogin": MoMeta("AaaShellLogin", "aaaShellLogin", "sh-login-[name]-[id]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], ['aaaUserEp'], [], ["Get"]),
    "AaaSshAuth": MoMeta("AaaSshAuth", "aaaSshAuth", "sshauth", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin"], ['aaaUser'], [], ["Add", "Get", "Remove", "Set"]),
    "AaaTacacsPlusEp": MoMeta("AaaTacacsPlusEp", "aaaTacacsPlusEp", "tacacs-ext", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin"], ['orgDomainGroup', 'policyDeviceProfile', 'topSystem'], ['aaaEpFsm', 'aaaEpFsmTask', 'aaaProviderGroup', 'aaaTacacsPlusEpFsm', 'aaaTacacsPlusProvider', 'eventInst', 'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "AaaTacacsPlusEpFsm": MoMeta("AaaTacacsPlusEpFsm", "aaaTacacsPlusEpFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['aaaTacacsPlusEp'], ['aaaTacacsPlusEpFsmStage'], [None]),
    "AaaTacacsPlusEpFsmStage": MoMeta("AaaTacacsPlusEpFsmStage", "aaaTacacsPlusEpFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['aaaTacacsPlusEpFsm'], [], [None]),
    "AaaTacacsPlusProvider": MoMeta("AaaTacacsPlusProvider", "aaaTacacsPlusProvider", "provider-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin"], ['aaaTacacsPlusEp'], [], ["Add", "Get", "Remove", "Set"]),
    "AaaUser": MoMeta("AaaUser", "aaaUser", "user-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin"], ['orgDomainGroup', 'policyDeviceProfile'], ['aaaSession', 'aaaSshAuth', 'aaaUserData', 'aaaUserLocale', 'aaaUserRole'], ["Add", "Get", "Remove", "Set"]),
    "AaaUserData": MoMeta("AaaUserData", "aaaUserData", "user-data", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin"], ['aaaUser'], [], ["Get"]),
    "AaaUserEp": MoMeta("AaaUserEp", "aaaUserEp", "user-ext", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin"], ['topSystem'], ['aaaEpLogin', 'aaaExtMgmtCutThruTkn', 'aaaLocale', 'aaaPwdProfile', 'aaaRemoteUser', 'aaaRole', 'aaaShellLogin', 'aaaUser', 'aaaUserEpFsm', 'aaaUserEpFsmTask', 'aaaUserPreferences', 'aaaWebLogin', 'eventInst', 'faultInst'], ["Get", "Set"]),
    "AaaUserEpFsm": MoMeta("AaaUserEpFsm", "aaaUserEpFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['aaaUserEp'], ['aaaUserEpFsmStage'], [None]),
    "AaaUserEpFsmStage": MoMeta("AaaUserEpFsmStage", "aaaUserEpFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['aaaUserEpFsm'], [], [None]),
    "AaaUserEpFsmTask": MoMeta("AaaUserEpFsmTask", "aaaUserEpFsmTask", "task-[item]", VersionMeta.Version101a, "OutputOnly", 0x1, [], [""], ['aaaUserEp'], [], ["Get"]),
    "AaaUserLocale": MoMeta("AaaUserLocale", "aaaUserLocale", "locale-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin"], ['aaaLdapGroup', 'aaaRemoteUser', 'aaaUser'], [], ["Add", "Get", "Remove", "Set"]),
    "AaaUserPreferences": MoMeta("AaaUserPreferences", "aaaUserPreferences", "pref-[name]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["aaa", "admin", "read-only"], ['aaaUserEp'], [], ["Get", "Set"]),
    "AaaUserRole": MoMeta("AaaUserRole", "aaaUserRole", "role-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin"], ['aaaLdapGroup', 'aaaRemoteUser', 'aaaUser'], [], ["Add", "Get", "Remove", "Set"]),
    "AaaWebLogin": MoMeta("AaaWebLogin", "aaaWebLogin", "web-login-[name]-[id]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], ['aaaUserEp'], [], ["Get"]),
    "AdaptorCapQual": MoMeta("AdaptorCapQual", "adaptorCapQual", "cap-[type]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "pn-policy", "read-only"], ['adaptorQual'], [], ["Add", "Get", "Remove", "Set"]),
    "AdaptorCapSpec": MoMeta("AdaptorCapSpec", "adaptorCapSpec", "cap-[type]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['adaptorFruCapProvider'], [], ["Get"]),
    "AdaptorEthAdvFilterProfile": MoMeta("AdaptorEthAdvFilterProfile", "adaptorEthAdvFilterProfile", "eth-adv-filter", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-network", "ls-server-policy"], ['adaptorHostEthIfProfile'], [], ["Get", "Set"]),
    "AdaptorEthArfsProfile": MoMeta("AdaptorEthArfsProfile", "adaptorEthArfsProfile", "eth-arfs", VersionMeta.Version121a, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-network", "ls-server-policy"], ['adaptorHostEthIfProfile'], [], ["Get", "Set"]),
    "AdaptorEthCompQueueProfile": MoMeta("AdaptorEthCompQueueProfile", "adaptorEthCompQueueProfile", "eth-comp-q", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-network", "ls-server-policy"], ['adaptorHostEthIfProfile', 'adaptorUsnicConnDef', 'adaptorVmmqConnDef'], [], ["Get", "Set"]),
    "AdaptorEthFailoverProfile": MoMeta("AdaptorEthFailoverProfile", "adaptorEthFailoverProfile", "eth-failover", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-network", "ls-server-policy"], ['adaptorHostEthIfProfile', 'adaptorUsnicConnDef'], [], ["Get", "Set"]),
    "AdaptorEthGENEVEProfile": MoMeta("AdaptorEthGENEVEProfile", "adaptorEthGENEVEProfile", "eth-geneve", VersionMeta.Version201m, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-network", "ls-server-policy"], ['adaptorHostEthIfProfile'], [], [None]),
    "AdaptorEthInterruptProfile": MoMeta("AdaptorEthInterruptProfile", "adaptorEthInterruptProfile", "eth-int", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-network", "ls-server-policy"], ['adaptorHostEthIfProfile', 'adaptorUsnicConnDef', 'adaptorVmmqConnDef'], [], ["Get", "Set"]),
    "AdaptorEthInterruptScalingProfile": MoMeta("AdaptorEthInterruptScalingProfile", "adaptorEthInterruptScalingProfile", "eth-interrupt-scaling", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-network", "ls-server-policy"], ['adaptorHostEthIfProfile', 'adaptorUsnicConnDef'], [], ["Get", "Set"]),
    "AdaptorEthNVGREProfile": MoMeta("AdaptorEthNVGREProfile", "adaptorEthNVGREProfile", "eth-nvgre", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-network", "ls-server-policy"], ['adaptorHostEthIfProfile'], [], ["Get", "Set"]),
    "AdaptorEthOffloadProfile": MoMeta("AdaptorEthOffloadProfile", "adaptorEthOffloadProfile", "eth-offload", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-network", "ls-server-policy"], ['adaptorHostEthIfProfile', 'adaptorUsnicConnDef'], [], ["Get", "Set"]),
    "AdaptorEthPortBySizeLargeStats": MoMeta("AdaptorEthPortBySizeLargeStats", "adaptorEthPortBySizeLargeStats", "eth-port-by-size-large-stats-[traffic_direction]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['adaptorHostEthIf', 'vmNic'], ['adaptorEthPortBySizeLargeStatsHist'], [None]),
    "AdaptorEthPortBySizeLargeStatsHist": MoMeta("AdaptorEthPortBySizeLargeStatsHist", "adaptorEthPortBySizeLargeStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], ['adaptorEthPortBySizeLargeStats'], [], [None]),
    "AdaptorEthPortBySizeSmallStats": MoMeta("AdaptorEthPortBySizeSmallStats", "adaptorEthPortBySizeSmallStats", "eth-port-by-size-small-stats-[traffic_direction]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['adaptorHostEthIf', 'vmNic'], ['adaptorEthPortBySizeSmallStatsHist'], [None]),
    "AdaptorEthPortBySizeSmallStatsHist": MoMeta("AdaptorEthPortBySizeSmallStatsHist", "adaptorEthPortBySizeSmallStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], ['adaptorEthPortBySizeSmallStats'], [], [None]),
    "AdaptorEthPortErrStats": MoMeta("AdaptorEthPortErrStats", "adaptorEthPortErrStats", "eth-port-err-stats-[traffic_direction]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['adaptorHostEthIf', 'vmNic'], ['adaptorEthPortErrStatsHist'], [None]),
    "AdaptorEthPortErrStatsHist": MoMeta("AdaptorEthPortErrStatsHist", "adaptorEthPortErrStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], ['adaptorEthPortErrStats'], [], [None]),
    "AdaptorEthPortMcastStats": MoMeta("AdaptorEthPortMcastStats", "adaptorEthPortMcastStats", "eth-port-mcast-stats-[traffic_direction]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['adaptorHostEthIf', 'vmNic'], ['adaptorEthPortMcastStatsHist'], [None]),
    "AdaptorEthPortMcastStatsHist": MoMeta("AdaptorEthPortMcastStatsHist", "adaptorEthPortMcastStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], ['adaptorEthPortMcastStats'], [], [None]),
    "AdaptorEthPortOutsizedStats": MoMeta("AdaptorEthPortOutsizedStats", "adaptorEthPortOutsizedStats", "eth-port-outsized-stats-[traffic_direction]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['adaptorHostEthIf', 'vmNic'], ['adaptorEthPortOutsizedStatsHist'], [None]),
    "AdaptorEthPortOutsizedStatsHist": MoMeta("AdaptorEthPortOutsizedStatsHist", "adaptorEthPortOutsizedStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], ['adaptorEthPortOutsizedStats'], [], [None]),
    "AdaptorEthPortStats": MoMeta("AdaptorEthPortStats", "adaptorEthPortStats", "eth-port-stats-[traffic_direction]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['adaptorHostEthIf', 'vmNic'], ['adaptorEthPortStatsHist'], [None]),
    "AdaptorEthPortStatsHist": MoMeta("AdaptorEthPortStatsHist", "adaptorEthPortStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], ['adaptorEthPortStats'], [], [None]),
    "AdaptorEthRecvQueueProfile": MoMeta("AdaptorEthRecvQueueProfile", "adaptorEthRecvQueueProfile", "eth-rcv-q", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-network", "ls-server-policy"], ['adaptorHostEthIfProfile', 'adaptorUsnicConnDef', 'adaptorVmmqConnDef'], [], ["Get", "Set"]),
    "AdaptorEthRoCEProfile": MoMeta("AdaptorEthRoCEProfile", "adaptorEthRoCEProfile", "eth-roce", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-network", "ls-server-policy"], ['adaptorHostEthIfProfile', 'adaptorVmmqConnDef'], [], ["Get", "Set"]),
    "AdaptorEthVxLANProfile": MoMeta("AdaptorEthVxLANProfile", "adaptorEthVxLANProfile", "eth-vxlan", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-network", "ls-server-policy"], ['adaptorHostEthIfProfile'], [], ["Get", "Set"]),
    "AdaptorEthWorkQueueProfile": MoMeta("AdaptorEthWorkQueueProfile", "adaptorEthWorkQueueProfile", "eth-work-q", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-network", "ls-server-policy"], ['adaptorHostEthIfProfile', 'adaptorUsnicConnDef', 'adaptorVmmqConnDef'], [], ["Get", "Set"]),
    "AdaptorEtherIfStats": MoMeta("AdaptorEtherIfStats", "adaptorEtherIfStats", "ether-if-stats", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['adaptorVlan'], ['adaptorEtherIfStatsHist'], [None]),
    "AdaptorEtherIfStatsHist": MoMeta("AdaptorEtherIfStatsHist", "adaptorEtherIfStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], ['adaptorEtherIfStats'], [], [None]),
    "AdaptorExtEthIf": MoMeta("AdaptorExtEthIf", "adaptorExtEthIf", "ext-eth-[id]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy", "pn-equipment", "pn-maintenance", "read-only"], ['adaptorUnit'], ['adaptorExtEthIfOperation', 'dcxVIf', 'fabricEthMonSrcEp', 'fabricEthMonSrcEpOperation'], ["Get"]),
    "AdaptorExtEthIfOperation": MoMeta("AdaptorExtEthIfOperation", "adaptorExtEthIfOperation", "remote-oper", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy", "pn-equipment", "pn-maintenance"], ['adaptorExtEthIf'], ['faultInst'], ["get", "set"]),
    "AdaptorExtIpV6RssHashProfile": MoMeta("AdaptorExtIpV6RssHashProfile", "adaptorExtIpV6RssHashProfile", "ext-ipv6-rss-hash", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-network", "ls-server-policy"], ['adaptorHostEthIfProfile', 'adaptorUsnicConnDef'], [], ["Get"]),
    "AdaptorFcCdbWorkQueueProfile": MoMeta("AdaptorFcCdbWorkQueueProfile", "adaptorFcCdbWorkQueueProfile", "fc-cdb-work-q", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-server-policy", "ls-storage"], ['adaptorHostFcIfProfile'], [], ["Get", "Set"]),
    "AdaptorFcErrorRecoveryProfile": MoMeta("AdaptorFcErrorRecoveryProfile", "adaptorFcErrorRecoveryProfile", "fc-err-rec", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-server-policy", "ls-storage"], ['adaptorHostFcIfProfile'], [], ["Get", "Set"]),
    "AdaptorFcFnicProfile": MoMeta("AdaptorFcFnicProfile", "adaptorFcFnicProfile", "fc-fnic", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-server-policy", "ls-storage"], ['adaptorHostFcIfProfile'], [], ["Get", "Set"]),
    "AdaptorFcIfEventStats": MoMeta("AdaptorFcIfEventStats", "adaptorFcIfEventStats", "fc-if-event-stats", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['adaptorHostFcIf'], ['adaptorFcIfEventStatsHist'], [None]),
    "AdaptorFcIfEventStatsHist": MoMeta("AdaptorFcIfEventStatsHist", "adaptorFcIfEventStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], ['adaptorFcIfEventStats'], [], [None]),
    "AdaptorFcIfFC4Stats": MoMeta("AdaptorFcIfFC4Stats", "adaptorFcIfFC4Stats", "fc-if-fc4-stats", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['adaptorHostFcIf'], ['adaptorFcIfFC4StatsHist'], [None]),
    "AdaptorFcIfFC4StatsHist": MoMeta("AdaptorFcIfFC4StatsHist", "adaptorFcIfFC4StatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], ['adaptorFcIfFC4Stats'], [], [None]),
    "AdaptorFcIfFrameStats": MoMeta("AdaptorFcIfFrameStats", "adaptorFcIfFrameStats", "fc-if-frame-stats", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['adaptorHostFcIf'], ['adaptorFcIfFrameStatsHist'], [None]),
    "AdaptorFcIfFrameStatsHist": MoMeta("AdaptorFcIfFrameStatsHist", "adaptorFcIfFrameStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], ['adaptorFcIfFrameStats'], [], [None]),
    "AdaptorFcInterruptProfile": MoMeta("AdaptorFcInterruptProfile", "adaptorFcInterruptProfile", "fc-int", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-server-policy", "ls-storage"], ['adaptorHostFcIfProfile'], [], ["Get", "Set"]),
    "AdaptorFcPortFLogiProfile": MoMeta("AdaptorFcPortFLogiProfile", "adaptorFcPortFLogiProfile", "fc-port-flogi", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-server-policy", "ls-storage"], ['adaptorHostFcIfProfile'], [], ["Get", "Set"]),
    "AdaptorFcPortPLogiProfile": MoMeta("AdaptorFcPortPLogiProfile", "adaptorFcPortPLogiProfile", "fc-port-plogi", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-server-policy", "ls-storage"], ['adaptorHostFcIfProfile'], [], ["Get", "Set"]),
    "AdaptorFcPortProfile": MoMeta("AdaptorFcPortProfile", "adaptorFcPortProfile", "fc-port", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-server-policy", "ls-storage"], ['adaptorHostFcIfProfile'], [], ["Get", "Set"]),
    "AdaptorFcPortStats": MoMeta("AdaptorFcPortStats", "adaptorFcPortStats", "fc-port-stats", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['adaptorHostFcIf', 'vmNic'], ['adaptorFcPortStatsHist'], [None]),
    "AdaptorFcPortStatsHist": MoMeta("AdaptorFcPortStatsHist", "adaptorFcPortStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], ['adaptorFcPortStats'], [], [None]),
    "AdaptorFcRecvQueueProfile": MoMeta("AdaptorFcRecvQueueProfile", "adaptorFcRecvQueueProfile", "fc-rcv-q", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-server-policy", "ls-storage"], ['adaptorHostFcIfProfile'], [], ["Get", "Set"]),
    "AdaptorFcWorkQueueProfile": MoMeta("AdaptorFcWorkQueueProfile", "adaptorFcWorkQueueProfile", "fc-work-q", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-server-policy", "ls-storage"], ['adaptorHostFcIfProfile'], [], ["Get", "Set"]),
    "AdaptorFruCapProvider": MoMeta("AdaptorFruCapProvider", "adaptorFruCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin"], ['capabilityCatalogue'], ['adaptorCapSpec', 'adaptorIScsiCap', 'adaptorRnicCapSpec', 'equipmentFruVariant', 'equipmentManufacturingDef', 'equipmentPicture'], ["Get"]),
    "AdaptorHBAVnicStats": MoMeta("AdaptorHBAVnicStats", "adaptorHBAVnicStats", "hba-vnic-stats", VersionMeta.Version111b, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [], ['adaptorHBAVnicStatsHist'], ["Get"]),
    "AdaptorHBAVnicStatsHist": MoMeta("AdaptorHBAVnicStatsHist", "adaptorHBAVnicStatsHist", "[id]", VersionMeta.Version111b, "OutputOnly", 0x1, [], ["read-only"], ['adaptorHBAVnicStats'], [], ["Get"]),
    "AdaptorHostEthIf": MoMeta("AdaptorHostEthIf", "adaptorHostEthIf", "host-eth-[id]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy", "pn-equipment", "pn-maintenance", "read-only"], ['adaptorUnit'], ['adaptorEthPortBySizeLargeStats', 'adaptorEthPortBySizeSmallStats', 'adaptorEthPortErrStats', 'adaptorEthPortMcastStats', 'adaptorEthPortOutsizedStats', 'adaptorEthPortStats', 'adaptorHostEthIfOperation', 'adaptorSriovHpnConnDef', 'adaptorUsnicConnDef', 'adaptorVlan', 'adaptorVmmqConnDef', 'adaptorVnicStats', 'dcxVIf', 'faultInst'], ["Get", "Set"]),
    "AdaptorHostEthIfOperation": MoMeta("AdaptorHostEthIfOperation", "adaptorHostEthIfOperation", "remote-oper", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy", "pn-equipment", "pn-maintenance"], ['adaptorHostEthIf'], ['faultInst'], ["get", "set"]),
    "AdaptorHostEthIfProfile": MoMeta("AdaptorHostEthIfProfile", "adaptorHostEthIfProfile", "eth-profile-[name]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['orgOrg', 'policySystemEp'], ['adaptorEthAdvFilterProfile', 'adaptorEthArfsProfile', 'adaptorEthCompQueueProfile', 'adaptorEthFailoverProfile', 'adaptorEthGENEVEProfile', 'adaptorEthInterruptProfile', 'adaptorEthInterruptScalingProfile', 'adaptorEthNVGREProfile', 'adaptorEthOffloadProfile', 'adaptorEthRecvQueueProfile', 'adaptorEthRoCEProfile', 'adaptorEthVxLANProfile', 'adaptorEthWorkQueueProfile', 'adaptorExtIpV6RssHashProfile', 'adaptorIpV4RssHashProfile', 'adaptorIpV6RssHashProfile', 'adaptorRssProfile'], ["Add", "Get", "Remove", "Set"]),
    "AdaptorHostFcIf": MoMeta("AdaptorHostFcIf", "adaptorHostFcIf", "host-fc-[id]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy", "pn-equipment", "pn-maintenance", "read-only"], ['adaptorUnit'], ['adaptorFcIfEventStats', 'adaptorFcIfFC4Stats', 'adaptorFcIfFrameStats', 'adaptorFcPortStats', 'adaptorHostFcIfOperation', 'adaptorVnicStats', 'dcxVIf', 'faultInst'], ["Get", "Set"]),
    "AdaptorHostFcIfOperation": MoMeta("AdaptorHostFcIfOperation", "adaptorHostFcIfOperation", "remote-oper", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy", "pn-equipment", "pn-maintenance"], ['adaptorHostFcIf'], ['faultInst'], ["get", "set"]),
    "AdaptorHostFcIfProfile": MoMeta("AdaptorHostFcIfProfile", "adaptorHostFcIfProfile", "fc-profile-[name]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['orgOrg'], ['adaptorFcCdbWorkQueueProfile', 'adaptorFcErrorRecoveryProfile', 'adaptorFcFnicProfile', 'adaptorFcInterruptProfile', 'adaptorFcPortFLogiProfile', 'adaptorFcPortPLogiProfile', 'adaptorFcPortProfile', 'adaptorFcRecvQueueProfile', 'adaptorFcWorkQueueProfile'], ["Add", "Get", "Remove", "Set"]),
    "AdaptorHostIfConfig": MoMeta("AdaptorHostIfConfig", "adaptorHostIfConfig", "host-if-config-[id]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["read-only"], ['computeBlade', 'computeRackUnit', 'computeServerUnit'], [], ["Get"]),
    "AdaptorHostIscsiIf": MoMeta("AdaptorHostIscsiIf", "adaptorHostIscsiIf", "host-iscsi-[id]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy", "pn-equipment", "pn-maintenance", "read-only"], ['adaptorUnit'], ['adaptorHostIscsiIfOperation', 'adaptorVlan', 'adaptorVnicStats', 'faultInst'], ["get"]),
    "AdaptorHostIscsiIfOperation": MoMeta("AdaptorHostIscsiIfOperation", "adaptorHostIscsiIfOperation", "remote-oper", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy", "pn-equipment", "pn-maintenance"], ['adaptorHostIscsiIf'], ['faultInst'], ["get", "set"]),
    "AdaptorHostIscsiIfProfile": MoMeta("AdaptorHostIscsiIfProfile", "adaptorHostIscsiIfProfile", "iscsi-profile-[name]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['orgOrg'], ['adaptorProtocolProfile'], ["Add", "Get", "Remove", "Set"]),
    "AdaptorHostScsiIf": MoMeta("AdaptorHostScsiIf", "adaptorHostScsiIf", "host-scsi-[id]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy", "pn-equipment", "pn-maintenance", "read-only"], ['adaptorUnit'], ['adaptorHostScsiLunRef', 'adaptorVnicStats', 'faultInst'], ["Get"]),
    "AdaptorHostScsiLunRef": MoMeta("AdaptorHostScsiLunRef", "adaptorHostScsiLunRef", "host-scsi-lun-[lun_order]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], ['adaptorHostScsiIf'], [], ["Get"]),
    "AdaptorIScsiCap": MoMeta("AdaptorIScsiCap", "adaptorIScsiCap", "iscsi", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['adaptorFruCapProvider'], [], ["Get"]),
    "AdaptorIpV4RssHashProfile": MoMeta("AdaptorIpV4RssHashProfile", "adaptorIpV4RssHashProfile", "ipv4-rss-hash", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-network", "ls-server-policy"], ['adaptorHostEthIfProfile', 'adaptorUsnicConnDef'], [], ["Get"]),
    "AdaptorIpV6RssHashProfile": MoMeta("AdaptorIpV6RssHashProfile", "adaptorIpV6RssHashProfile", "ipv6-rss-hash", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-network", "ls-server-policy"], ['adaptorHostEthIfProfile', 'adaptorUsnicConnDef'], [], ["Get"]),
    "AdaptorMenloBaseErrorStats": MoMeta("AdaptorMenloBaseErrorStats", "adaptorMenloBaseErrorStats", "menlo-base-error-stats", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [], ['adaptorMenloBaseErrorStatsHist'], [None]),
    "AdaptorMenloBaseErrorStatsHist": MoMeta("AdaptorMenloBaseErrorStatsHist", "adaptorMenloBaseErrorStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], ['adaptorMenloBaseErrorStats'], [], [None]),
    "AdaptorMenloDcePortStats": MoMeta("AdaptorMenloDcePortStats", "adaptorMenloDcePortStats", "menlo-dce-port-stats-[menlo_port_index]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['adaptorUnit'], ['adaptorMenloDcePortStatsHist'], [None]),
    "AdaptorMenloDcePortStatsHist": MoMeta("AdaptorMenloDcePortStatsHist", "adaptorMenloDcePortStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], ['adaptorMenloDcePortStats'], [], [None]),
    "AdaptorMenloEthErrorStats": MoMeta("AdaptorMenloEthErrorStats", "adaptorMenloEthErrorStats", "menlo-eth-error-stats-[menlo_eth_index]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['adaptorUnit'], ['adaptorMenloEthErrorStatsHist'], [None]),
    "AdaptorMenloEthErrorStatsHist": MoMeta("AdaptorMenloEthErrorStatsHist", "adaptorMenloEthErrorStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], ['adaptorMenloEthErrorStats'], [], [None]),
    "AdaptorMenloEthStats": MoMeta("AdaptorMenloEthStats", "adaptorMenloEthStats", "menlo-eth-stats-[menlo_eth_index]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['adaptorUnit'], ['adaptorMenloEthStatsHist'], [None]),
    "AdaptorMenloEthStatsHist": MoMeta("AdaptorMenloEthStatsHist", "adaptorMenloEthStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], ['adaptorMenloEthStats'], [], [None]),
    "AdaptorMenloFcErrorStats": MoMeta("AdaptorMenloFcErrorStats", "adaptorMenloFcErrorStats", "menlo-fc-error-stats-[menlo_fc_index]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['adaptorUnit'], ['adaptorMenloFcErrorStatsHist'], [None]),
    "AdaptorMenloFcErrorStatsHist": MoMeta("AdaptorMenloFcErrorStatsHist", "adaptorMenloFcErrorStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], ['adaptorMenloFcErrorStats'], [], [None]),
    "AdaptorMenloFcStats": MoMeta("AdaptorMenloFcStats", "adaptorMenloFcStats", "menlo-fc-stats-[menlo_fc_index]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['adaptorUnit'], ['adaptorMenloFcStatsHist'], [None]),
    "AdaptorMenloFcStatsHist": MoMeta("AdaptorMenloFcStatsHist", "adaptorMenloFcStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], ['adaptorMenloFcStats'], [], [None]),
    "AdaptorMenloHostPortStats": MoMeta("AdaptorMenloHostPortStats", "adaptorMenloHostPortStats", "menlo-host-port-stats-[menlo_port_index]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['adaptorUnit'], ['adaptorMenloHostPortStatsHist'], [None]),
    "AdaptorMenloHostPortStatsHist": MoMeta("AdaptorMenloHostPortStatsHist", "adaptorMenloHostPortStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], ['adaptorMenloHostPortStats'], [], [None]),
    "AdaptorMenloMcpuErrorStats": MoMeta("AdaptorMenloMcpuErrorStats", "adaptorMenloMcpuErrorStats", "menlo-mcpu-error-stats-[menlo_mcpu_index]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['adaptorUnit'], ['adaptorMenloMcpuErrorStatsHist'], [None]),
    "AdaptorMenloMcpuErrorStatsHist": MoMeta("AdaptorMenloMcpuErrorStatsHist", "adaptorMenloMcpuErrorStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], ['adaptorMenloMcpuErrorStats'], [], [None]),
    "AdaptorMenloMcpuStats": MoMeta("AdaptorMenloMcpuStats", "adaptorMenloMcpuStats", "menlo-mcpu-stats-[menlo_mcpu_index]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['adaptorUnit'], ['adaptorMenloMcpuStatsHist'], [None]),
    "AdaptorMenloMcpuStatsHist": MoMeta("AdaptorMenloMcpuStatsHist", "adaptorMenloMcpuStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], ['adaptorMenloMcpuStats'], [], [None]),
    "AdaptorMenloNetEgStats": MoMeta("AdaptorMenloNetEgStats", "adaptorMenloNetEgStats", "menlo-net-eg-stats-[menlo_net_index]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['adaptorUnit'], ['adaptorMenloNetEgStatsHist'], [None]),
    "AdaptorMenloNetEgStatsHist": MoMeta("AdaptorMenloNetEgStatsHist", "adaptorMenloNetEgStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], ['adaptorMenloNetEgStats'], [], [None]),
    "AdaptorMenloNetInStats": MoMeta("AdaptorMenloNetInStats", "adaptorMenloNetInStats", "menlo-net-in-stats-[menlo_net_index]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['adaptorUnit'], ['adaptorMenloNetInStatsHist'], [None]),
    "AdaptorMenloNetInStatsHist": MoMeta("AdaptorMenloNetInStatsHist", "adaptorMenloNetInStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], ['adaptorMenloNetInStats'], [], [None]),
    "AdaptorMenloQErrorStats": MoMeta("AdaptorMenloQErrorStats", "adaptorMenloQErrorStats", "menlo-q-error-stats-comp-[menlo_queue_component]index-[menlo_queue_index]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['adaptorUnit'], ['adaptorMenloQErrorStatsHist'], [None]),
    "AdaptorMenloQErrorStatsHist": MoMeta("AdaptorMenloQErrorStatsHist", "adaptorMenloQErrorStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], ['adaptorMenloQErrorStats'], [], [None]),
    "AdaptorMenloQStats": MoMeta("AdaptorMenloQStats", "adaptorMenloQStats", "menlo-q-stats-comp-[menlo_queue_component]index-[menlo_queue_index]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['adaptorUnit'], ['adaptorMenloQStatsHist'], [None]),
    "AdaptorMenloQStatsHist": MoMeta("AdaptorMenloQStatsHist", "adaptorMenloQStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], ['adaptorMenloQStats'], [], [None]),
    "AdaptorNICVnicStats": MoMeta("AdaptorNICVnicStats", "adaptorNICVnicStats", "nic-vnic-stats", VersionMeta.Version111b, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [], ['adaptorNICVnicStatsHist'], ["Get"]),
    "AdaptorNICVnicStatsHist": MoMeta("AdaptorNICVnicStatsHist", "adaptorNICVnicStatsHist", "[id]", VersionMeta.Version111b, "OutputOnly", 0x1, [], ["read-only"], ['adaptorNICVnicStats'], [], ["Get"]),
    "AdaptorProtocolProfile": MoMeta("AdaptorProtocolProfile", "adaptorProtocolProfile", "iscsi-prot-profile", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-network", "ls-server-policy"], ['adaptorHostIscsiIfProfile'], [], ["Add", "Get", "Set"]),
    "AdaptorQual": MoMeta("AdaptorQual", "adaptorQual", "adaptor", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "pn-policy", "read-only"], ['computeQual'], ['adaptorCapQual'], ["Add", "Get", "Remove"]),
    "AdaptorRnicCapSpec": MoMeta("AdaptorRnicCapSpec", "adaptorRnicCapSpec", "cap-[type]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["read-only"], ['adaptorFruCapProvider'], [], ["Get"]),
    "AdaptorRssProfile": MoMeta("AdaptorRssProfile", "adaptorRssProfile", "rss", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-network", "ls-server-policy"], ['adaptorHostEthIfProfile', 'adaptorUsnicConnDef', 'adaptorVmmqConnDef'], [], ["Get", "Set"]),
    "AdaptorSriovHpnConnDef": MoMeta("AdaptorSriovHpnConnDef", "adaptorSriovHpnConnDef", "sriov-hpn-conn-def-[con_policy_name]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "read-only"], ['adaptorHostEthIf'], [], [None]),
    "AdaptorUnit": MoMeta("AdaptorUnit", "adaptorUnit", "adaptor-[id]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-policy"], ['computeBlade', 'computeRackUnit', 'computeServerUnit'], ['adaptorExtEthIf', 'adaptorHostEthIf', 'adaptorHostFcIf', 'adaptorHostIscsiIf', 'adaptorHostScsiIf', 'adaptorMenloDcePortStats', 'adaptorMenloEthErrorStats', 'adaptorMenloEthStats', 'adaptorMenloFcErrorStats', 'adaptorMenloFcStats', 'adaptorMenloHostPortStats', 'adaptorMenloMcpuErrorStats', 'adaptorMenloMcpuStats', 'adaptorMenloNetEgStats', 'adaptorMenloNetInStats', 'adaptorMenloQErrorStats', 'adaptorMenloQStats', 'adaptorUnitExtn', 'faultInst', 'mgmtController'], ["Get"]),
    "AdaptorUnitAssocCtx": MoMeta("AdaptorUnitAssocCtx", "adaptorUnitAssocCtx", "adaptorunit-assoc-ctx-[id]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['lsServerAssocCtx'], [], ["Get"]),
    "AdaptorUnitExtn": MoMeta("AdaptorUnitExtn", "adaptorUnitExtn", "adaptor-extn-[id]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], ['adaptorUnit'], [], ["get"]),
    "AdaptorUsnicConnDef": MoMeta("AdaptorUsnicConnDef", "adaptorUsnicConnDef", "usnic-conn-def-[con_policy_name]", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "read-only"], ['adaptorHostEthIf'], ['adaptorEthCompQueueProfile', 'adaptorEthFailoverProfile', 'adaptorEthInterruptProfile', 'adaptorEthInterruptScalingProfile', 'adaptorEthOffloadProfile', 'adaptorEthRecvQueueProfile', 'adaptorEthWorkQueueProfile', 'adaptorExtIpV6RssHashProfile', 'adaptorIpV4RssHashProfile', 'adaptorIpV6RssHashProfile', 'adaptorRssProfile'], ["Get"]),
    "AdaptorVlan": MoMeta("AdaptorVlan", "adaptorVlan", "vlan-[id]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['adaptorHostEthIf', 'adaptorHostIscsiIf'], ['adaptorEtherIfStats', 'fabricConsumer', 'fabricEtherRef', 'faultInst'], ["Get"]),
    "AdaptorVmmqConnDef": MoMeta("AdaptorVmmqConnDef", "adaptorVmmqConnDef", "vmmq-conn-def-[con_policy_name]", VersionMeta.Version201f, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "read-only"], ['adaptorHostEthIf'], ['adaptorEthCompQueueProfile', 'adaptorEthInterruptProfile', 'adaptorEthRecvQueueProfile', 'adaptorEthRoCEProfile', 'adaptorEthWorkQueueProfile', 'adaptorRssProfile'], [None]),
    "AdaptorVnicStats": MoMeta("AdaptorVnicStats", "adaptorVnicStats", "virtual-interface-stats", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['adaptorHostEthIf', 'adaptorHostFcIf', 'adaptorHostIscsiIf', 'adaptorHostScsiIf', 'vmNic'], ['adaptorVnicStatsHist'], [None]),
    "AdaptorVnicStatsHist": MoMeta("AdaptorVnicStatsHist", "adaptorVnicStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], ['adaptorVnicStats'], [], [None]),
    "BiosBOT": MoMeta("BiosBOT", "biosBOT", "bdgep", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['biosUnit'], ['biosBootDevGrp'], ["Get"]),
    "BiosBootDev": MoMeta("BiosBootDev", "biosBootDev", "[order]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['biosBootDevGrp'], [], ["Get"]),
    "BiosBootDevGrp": MoMeta("BiosBootDevGrp", "biosBootDevGrp", "bdg-[order]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['biosBOT'], ['biosBootDev'], ["Get"]),
    "BiosTokenFeatureGroup": MoMeta("BiosTokenFeatureGroup", "biosTokenFeatureGroup", "tokn-featr-[name]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], ['biosVProfile'], ['biosTokenParam'], [None]),
    "BiosTokenParam": MoMeta("BiosTokenParam", "biosTokenParam", "tokn-param-[target_token_name]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], ['biosTokenFeatureGroup'], ['biosTokenSettings'], [None]),
    "BiosTokenSettings": MoMeta("BiosTokenSettings", "biosTokenSettings", "tokn-setng-[settings_mo_rn]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], ['biosTokenParam'], [], [None]),
    "BiosUnit": MoMeta("BiosUnit", "biosUnit", "bios", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['computeBlade', 'computeRackUnit', 'computeServerUnit'], ['biosBOT', 'firmwareRunning'], ["Get"]),
    "BiosVProfile": MoMeta("BiosVProfile", "biosVProfile", "bios-prof-[name]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['orgOrg'], ['biosTokenFeatureGroup', 'biosVfACPI10Support', 'biosVfASPMSupport', 'biosVfAllUSBDevices', 'biosVfAltitude', 'biosVfAssertNMIOnPERR', 'biosVfAssertNMIOnSERR', 'biosVfBootOptionRetry', 'biosVfCPUHardwarePowerManagement', 'biosVfCPUPerformance', 'biosVfCPUPowerManagement', 'biosVfConsistentDeviceNameControl', 'biosVfConsoleRedirection', 'biosVfCoreMultiProcessing', 'biosVfDDR3VoltageSelection', 'biosVfDRAMClockThrottling', 'biosVfDirectCacheAccess', 'biosVfDramRefreshRate', 'biosVfEnergyPerformanceTuning', 'biosVfEnhancedIntelSpeedStepTech', 'biosVfEnhancedPowerCappingSupport', 'biosVfExecuteDisableBit', 'biosVfFRB2Timer', 'biosVfFrequencyFloorOverride', 'biosVfFrontPanelLockout', 'biosVfIOEMezz1OptionROM', 'biosVfIOENVMe1OptionROM', 'biosVfIOENVMe2OptionROM', 'biosVfIOESlot1OptionROM', 'biosVfIOESlot2OptionROM', 'biosVfIntegratedGraphics', 'biosVfIntegratedGraphicsApertureSize', 'biosVfIntelEntrySASRAIDModule', 'biosVfIntelHyperThreadingTech', 'biosVfIntelTrustedExecutionTechnology', 'biosVfIntelTurboBoostTech', 'biosVfIntelVTForDirectedIO', 'biosVfIntelVirtualizationTechnology', 'biosVfInterleaveConfiguration', 'biosVfLocalX2Apic', 'biosVfLvDIMMSupport', 'biosVfMaxVariableMTRRSetting', 'biosVfMaximumMemoryBelow4GB', 'biosVfMemoryMappedIOAbove4GB', 'biosVfMirroringMode', 'biosVfNUMAOptimized', 'biosVfOSBootWatchdogTimer', 'biosVfOSBootWatchdogTimerPolicy', 'biosVfOSBootWatchdogTimerTimeout', 'biosVfOnboardGraphics', 'biosVfOnboardSATAController', 'biosVfOnboardStorage', 'biosVfOptionROMEnable', 'biosVfOptionROMLoad', 'biosVfOutOfBandManagement', 'biosVfPCHSATAMode', 'biosVfPCILOMPortsConfiguration', 'biosVfPCIROMCLP', 'biosVfPCISlotLinkSpeed', 'biosVfPCISlotOptionROMEnable', 'biosVfPOSTErrorPause', 'biosVfPSTATECoordination', 'biosVfPackageCStateLimit', 'biosVfProcessorC1E', 'biosVfProcessorC3Report', 'biosVfProcessorC6Report', 'biosVfProcessorC7Report', 'biosVfProcessorCMCI', 'biosVfProcessorCState', 'biosVfProcessorEnergyConfiguration', 'biosVfProcessorPrefetchConfig', 'biosVfQPILinkFrequencySelect', 'biosVfQPISnoopMode', 'biosVfQuietBoot', 'biosVfRedirectionAfterBIOSPOST', 'biosVfResumeOnACPowerLoss', 'biosVfSBMezz1OptionROM', 'biosVfSBNVMe1OptionROM', 'biosVfSIOC1OptionROM', 'biosVfSIOC2OptionROM', 'biosVfScrubPolicies', 'biosVfSelectMemoryRASConfiguration', 'biosVfSerialPortAEnable', 'biosVfSparingMode', 'biosVfSriovConfig', 'biosVfTPMPendingOperation', 'biosVfTPMSupport', 'biosVfTrustedPlatformModule', 'biosVfUCSMBootModeControl', 'biosVfUCSMBootOrderRuleControl', 'biosVfUEFIOSUseLegacyVideo', 'biosVfUSBBootConfig', 'biosVfUSBConfiguration', 'biosVfUSBFrontPanelAccessLock', 'biosVfUSBPortConfiguration', 'biosVfUSBSystemIdlePowerOptimizingSetting', 'biosVfVGAPriority', 'biosVfWorkloadConfiguration'], ["Add", "Get", "Remove", "Set"]),
    "BiosVfACPI10Support": MoMeta("BiosVfACPI10Support", "biosVfACPI10Support", "ACPI10-Support", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['biosVProfile'], [], ["Get", "Set"]),
    "BiosVfASPMSupport": MoMeta("BiosVfASPMSupport", "biosVfASPMSupport", "ASPM-Support", VersionMeta.Version141a, "InputOutput", 0x1, [], ["read-only"], ['biosVProfile'], [], ["Get", "Set"]),
    "BiosVfAllUSBDevices": MoMeta("BiosVfAllUSBDevices", "biosVfAllUSBDevices", "All-USB-Devices", VersionMeta.Version121a, "InputOutput", 0x1, [], ["read-only"], ['biosVProfile'], [], ["Get", "Set"]),
    "BiosVfAltitude": MoMeta("BiosVfAltitude", "biosVfAltitude", "Altitude", VersionMeta.Version141a, "InputOutput", 0x1, [], ["read-only"], ['biosVProfile'], [], ["Get", "Set"]),
    "BiosVfAssertNMIOnPERR": MoMeta("BiosVfAssertNMIOnPERR", "biosVfAssertNMIOnPERR", "Assert-NMI-on-PERR", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['biosVProfile'], [], ["Get", "Set"]),
    "BiosVfAssertNMIOnSERR": MoMeta("BiosVfAssertNMIOnSERR", "biosVfAssertNMIOnSERR", "Assert-NMI-on-SERR", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['biosVProfile'], [], ["Get", "Set"]),
    "BiosVfBootOptionRetry": MoMeta("BiosVfBootOptionRetry", "biosVfBootOptionRetry", "Boot-option-retry", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['biosVProfile'], [], ["Get", "Set"]),
    "BiosVfCPUHardwarePowerManagement": MoMeta("BiosVfCPUHardwarePowerManagement", "biosVfCPUHardwarePowerManagement", "CPU-Hardware-Power-Management", VersionMeta.Version141a, "InputOutput", 0x1, [], ["read-only"], ['biosVProfile'], [], [None]),
    "BiosVfCPUPerformance": MoMeta("BiosVfCPUPerformance", "biosVfCPUPerformance", "CPU-Performance", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['biosVProfile'], [], ["Get", "Set"]),
    "BiosVfCPUPowerManagement": MoMeta("BiosVfCPUPowerManagement", "biosVfCPUPowerManagement", "CPU-Power-Management", VersionMeta.Version141a, "InputOutput", 0x1, [], ["read-only"], ['biosVProfile'], [], ["Get", "Set"]),
    "BiosVfConsistentDeviceNameControl": MoMeta("BiosVfConsistentDeviceNameControl", "biosVfConsistentDeviceNameControl", "Consistent-Device-Name-Control", VersionMeta.Version141a, "InputOutput", 0x1, [], ["read-only"], ['biosVProfile'], [], ["Get", "Set"]),
    "BiosVfConsoleRedirection": MoMeta("BiosVfConsoleRedirection", "biosVfConsoleRedirection", "Console-redirection", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['biosVProfile'], [], ["Get", "Set"]),
    "BiosVfCoreMultiProcessing": MoMeta("BiosVfCoreMultiProcessing", "biosVfCoreMultiProcessing", "Core-MultiProcessing", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['biosVProfile'], [], ["Get", "Set"]),
    "BiosVfDDR3VoltageSelection": MoMeta("BiosVfDDR3VoltageSelection", "biosVfDDR3VoltageSelection", "DDR3-Voltage-Selection", VersionMeta.Version141a, "InputOutput", 0x1, [], ["read-only"], ['biosVProfile'], [], ["Get", "Set"]),
    "BiosVfDRAMClockThrottling": MoMeta("BiosVfDRAMClockThrottling", "biosVfDRAMClockThrottling", "DRAM-Clock-Throttling", VersionMeta.Version121a, "InputOutput", 0x1, [], ["read-only"], ['biosVProfile'], [], ["Get", "Set"]),
    "BiosVfDirectCacheAccess": MoMeta("BiosVfDirectCacheAccess", "biosVfDirectCacheAccess", "Direct-Cache-Access", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['biosVProfile'], [], ["Get", "Set"]),
    "BiosVfDramRefreshRate": MoMeta("BiosVfDramRefreshRate", "biosVfDramRefreshRate", "Dram-Refresh-Rate", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['biosVProfile'], [], ["Get", "Set"]),
    "BiosVfEnergyPerformanceTuning": MoMeta("BiosVfEnergyPerformanceTuning", "biosVfEnergyPerformanceTuning", "Energy-Performance-Tuning", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], ['biosVProfile'], [], [None]),
    "BiosVfEnhancedIntelSpeedStepTech": MoMeta("BiosVfEnhancedIntelSpeedStepTech", "biosVfEnhancedIntelSpeedStepTech", "Enhanced-Intel-SpeedStep-Tech", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['biosVProfile'], [], ["Get", "Set"]),
    "BiosVfEnhancedPowerCappingSupport": MoMeta("BiosVfEnhancedPowerCappingSupport", "biosVfEnhancedPowerCappingSupport", "Enhanced-PowerCapping-Support", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], ['biosVProfile'], [], [None]),
    "BiosVfExecuteDisableBit": MoMeta("BiosVfExecuteDisableBit", "biosVfExecuteDisableBit", "Execute-Disable-Bit", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['biosVProfile'], [], ["Get", "Set"]),
    "BiosVfFRB2Timer": MoMeta("BiosVfFRB2Timer", "biosVfFRB2Timer", "FRB-2-Timer", VersionMeta.Version121a, "InputOutput", 0x1, [], ["read-only"], ['biosVProfile'], [], ["Get", "Set"]),
    "BiosVfFrequencyFloorOverride": MoMeta("BiosVfFrequencyFloorOverride", "biosVfFrequencyFloorOverride", "Frequency-Floor-Override", VersionMeta.Version121a, "InputOutput", 0x1, [], ["read-only"], ['biosVProfile'], [], ["Get", "Set"]),
    "BiosVfFrontPanelLockout": MoMeta("BiosVfFrontPanelLockout", "biosVfFrontPanelLockout", "Front-panel-lockout", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['biosVProfile'], [], ["Get", "Set"]),
    "BiosVfIOEMezz1OptionROM": MoMeta("BiosVfIOEMezz1OptionROM", "biosVfIOEMezz1OptionROM", "IOEMezz1-OptionROM", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], ['biosVProfile'], [], [None]),
    "BiosVfIOENVMe1OptionROM": MoMeta("BiosVfIOENVMe1OptionROM", "biosVfIOENVMe1OptionROM", "IOENVMe1-OptionROM", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], ['biosVProfile'], [], [None]),
    "BiosVfIOENVMe2OptionROM": MoMeta("BiosVfIOENVMe2OptionROM", "biosVfIOENVMe2OptionROM", "IOENVMe2-OptionROM", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], ['biosVProfile'], [], [None]),
    "BiosVfIOESlot1OptionROM": MoMeta("BiosVfIOESlot1OptionROM", "biosVfIOESlot1OptionROM", "IOESlot1-OptionROM", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], ['biosVProfile'], [], [None]),
    "BiosVfIOESlot2OptionROM": MoMeta("BiosVfIOESlot2OptionROM", "biosVfIOESlot2OptionROM", "IOESlot2-OptionROM", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], ['biosVProfile'], [], [None]),
    "BiosVfIntegratedGraphics": MoMeta("BiosVfIntegratedGraphics", "biosVfIntegratedGraphics", "Integrated-Graphics", VersionMeta.Version141a, "InputOutput", 0x1, [], ["read-only"], ['biosVProfile'], [], [None]),
    "BiosVfIntegratedGraphicsApertureSize": MoMeta("BiosVfIntegratedGraphicsApertureSize", "biosVfIntegratedGraphicsApertureSize", "Integrated-Graphics-Aperture-Size", VersionMeta.Version141a, "InputOutput", 0x1, [], ["read-only"], ['biosVProfile'], [], [None]),
    "BiosVfIntelEntrySASRAIDModule": MoMeta("BiosVfIntelEntrySASRAIDModule", "biosVfIntelEntrySASRAIDModule", "Intel-entry-SAS-RAID-module", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['biosVProfile'], [], ["Get", "Set"]),
    "BiosVfIntelHyperThreadingTech": MoMeta("BiosVfIntelHyperThreadingTech", "biosVfIntelHyperThreadingTech", "Intel-HyperThreading-Tech", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['biosVProfile'], [], ["Get", "Set"]),
    "BiosVfIntelTrustedExecutionTechnology": MoMeta("BiosVfIntelTrustedExecutionTechnology", "biosVfIntelTrustedExecutionTechnology", "Intel-Trusted-Execution-Technology", VersionMeta.Version141a, "InputOutput", 0x1, [], ["read-only"], ['biosVProfile'], [], ["Get", "Set"]),
    "BiosVfIntelTurboBoostTech": MoMeta("BiosVfIntelTurboBoostTech", "biosVfIntelTurboBoostTech", "Intel-Turbo-Boost-Tech", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['biosVProfile'], [], ["Get", "Set"]),
    "BiosVfIntelVTForDirectedIO": MoMeta("BiosVfIntelVTForDirectedIO", "biosVfIntelVTForDirectedIO", "Intel-VT-for-directed-IO", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['biosVProfile'], [], ["Get", "Set"]),
    "BiosVfIntelVirtualizationTechnology": MoMeta("BiosVfIntelVirtualizationTechnology", "biosVfIntelVirtualizationTechnology", "Intel-Virtualization-Technology", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['biosVProfile'], [], ["Get", "Set"]),
    "BiosVfInterleaveConfiguration": MoMeta("BiosVfInterleaveConfiguration", "biosVfInterleaveConfiguration", "Interleave-Configuration", VersionMeta.Version121a, "InputOutput", 0x1, [], ["read-only"], ['biosVProfile'], [], ["Get", "Set"]),
    "BiosVfLocalX2Apic": MoMeta("BiosVfLocalX2Apic", "biosVfLocalX2Apic", "Local-X2-Apic", VersionMeta.Version112a, "InputOutput", 0x1, [], ["read-only"], ['biosVProfile'], [], ["Get", "Set"]),
    "BiosVfLvDIMMSupport": MoMeta("BiosVfLvDIMMSupport", "biosVfLvDIMMSupport", "LvDIMM-Support", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['biosVProfile'], [], ["Get", "Set"]),
    "BiosVfMaxVariableMTRRSetting": MoMeta("BiosVfMaxVariableMTRRSetting", "biosVfMaxVariableMTRRSetting", "Max-Variable-MTRR-Setting", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['biosVProfile'], [], ["Get", "Set"]),
    "BiosVfMaximumMemoryBelow4GB": MoMeta("BiosVfMaximumMemoryBelow4GB", "biosVfMaximumMemoryBelow4GB", "Maximum-memory-below-4GB", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['biosVProfile'], [], ["Get", "Set"]),
    "BiosVfMemoryMappedIOAbove4GB": MoMeta("BiosVfMemoryMappedIOAbove4GB", "biosVfMemoryMappedIOAbove4GB", "Memory-mapped-IO-above-4GB", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['biosVProfile'], [], ["Get", "Set"]),
    "BiosVfMirroringMode": MoMeta("BiosVfMirroringMode", "biosVfMirroringMode", "Mirroring-Mode", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['biosVProfile'], [], ["Get", "Set"]),
    "BiosVfNUMAOptimized": MoMeta("BiosVfNUMAOptimized", "biosVfNUMAOptimized", "NUMA-optimized", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['biosVProfile'], [], ["Get", "Set"]),
    "BiosVfOSBootWatchdogTimer": MoMeta("BiosVfOSBootWatchdogTimer", "biosVfOSBootWatchdogTimer", "OS-Boot-Watchdog-Timer", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['biosVProfile'], [], ["Get", "Set"]),
    "BiosVfOSBootWatchdogTimerPolicy": MoMeta("BiosVfOSBootWatchdogTimerPolicy", "biosVfOSBootWatchdogTimerPolicy", "OS-Boot-Watchdog-Timer-Policy", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['biosVProfile'], [], ["Get", "Set"]),
    "BiosVfOSBootWatchdogTimerTimeout": MoMeta("BiosVfOSBootWatchdogTimerTimeout", "biosVfOSBootWatchdogTimerTimeout", "OS-Boot-Watchdog-Timer-Timeout", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['biosVProfile'], [], ["Get", "Set"]),
    "BiosVfOnboardGraphics": MoMeta("BiosVfOnboardGraphics", "biosVfOnboardGraphics", "Onboard-Graphics", VersionMeta.Version141a, "InputOutput", 0x1, [], ["read-only"], ['biosVProfile'], [], [None]),
    "BiosVfOnboardSATAController": MoMeta("BiosVfOnboardSATAController", "biosVfOnboardSATAController", "Onboard-SATA-controller", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['biosVProfile'], [], ["Get", "Set"]),
    "BiosVfOnboardStorage": MoMeta("BiosVfOnboardStorage", "biosVfOnboardStorage", "Onboard-Storage", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['biosVProfile'], [], ["Get", "Set"]),
    "BiosVfOptionROMEnable": MoMeta("BiosVfOptionROMEnable", "biosVfOptionROMEnable", "OptionROM-Enable", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['biosVProfile'], [], ["Get", "Set"]),
    "BiosVfOptionROMLoad": MoMeta("BiosVfOptionROMLoad", "biosVfOptionROMLoad", "OptionROM-load", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['biosVProfile'], [], ["Get", "Set"]),
    "BiosVfOutOfBandManagement": MoMeta("BiosVfOutOfBandManagement", "biosVfOutOfBandManagement", "Out-of-Band-Management", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], ['biosVProfile'], [], [None]),
    "BiosVfPCHSATAMode": MoMeta("BiosVfPCHSATAMode", "biosVfPCHSATAMode", "PCH-SATA-Mode", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], ['biosVProfile'], [], [None]),
    "BiosVfPCILOMPortsConfiguration": MoMeta("BiosVfPCILOMPortsConfiguration", "biosVfPCILOMPortsConfiguration", "PCI-LOM-Ports-Configuration", VersionMeta.Version141a, "InputOutput", 0x1, [], ["read-only"], ['biosVProfile'], [], ["Get", "Set"]),
    "BiosVfPCIROMCLP": MoMeta("BiosVfPCIROMCLP", "biosVfPCIROMCLP", "PCI-ROM-CLP", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], ['biosVProfile'], [], [None]),
    "BiosVfPCISlotLinkSpeed": MoMeta("BiosVfPCISlotLinkSpeed", "biosVfPCISlotLinkSpeed", "PCI-Slot-Link-Speed", VersionMeta.Version121a, "InputOutput", 0x1, [], ["read-only"], ['biosVProfile'], [], ["Get", "Set"]),
    "BiosVfPCISlotOptionROMEnable": MoMeta("BiosVfPCISlotOptionROMEnable", "biosVfPCISlotOptionROMEnable", "PCI-Slot-OptionROM-Enable", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['biosVProfile'], [], ["Get", "Set"]),
    "BiosVfPOSTErrorPause": MoMeta("BiosVfPOSTErrorPause", "biosVfPOSTErrorPause", "POST-error-pause", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['biosVProfile'], [], ["Get", "Set"]),
    "BiosVfPSTATECoordination": MoMeta("BiosVfPSTATECoordination", "biosVfPSTATECoordination", "P-STATE-Coordination", VersionMeta.Version121a, "InputOutput", 0x1, [], ["read-only"], ['biosVProfile'], [], ["Get", "Set"]),
    "BiosVfPackageCStateLimit": MoMeta("BiosVfPackageCStateLimit", "biosVfPackageCStateLimit", "Package-C-State-Limit", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['biosVProfile'], [], ["Get", "Set"]),
    "BiosVfProcessorC1E": MoMeta("BiosVfProcessorC1E", "biosVfProcessorC1E", "Processor-C1E", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['biosVProfile'], [], ["Get", "Set"]),
    "BiosVfProcessorC3Report": MoMeta("BiosVfProcessorC3Report", "biosVfProcessorC3Report", "Processor-C3-Report", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['biosVProfile'], [], ["Get", "Set"]),
    "BiosVfProcessorC6Report": MoMeta("BiosVfProcessorC6Report", "biosVfProcessorC6Report", "Processor-C6-Report", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['biosVProfile'], [], ["Get", "Set"]),
    "BiosVfProcessorC7Report": MoMeta("BiosVfProcessorC7Report", "biosVfProcessorC7Report", "Processor-C7-Report", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['biosVProfile'], [], ["Get", "Set"]),
    "BiosVfProcessorCMCI": MoMeta("BiosVfProcessorCMCI", "biosVfProcessorCMCI", "Processor-CMCI", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], ['biosVProfile'], [], [None]),
    "BiosVfProcessorCState": MoMeta("BiosVfProcessorCState", "biosVfProcessorCState", "Processor-C-State", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['biosVProfile'], [], ["Get", "Set"]),
    "BiosVfProcessorEnergyConfiguration": MoMeta("BiosVfProcessorEnergyConfiguration", "biosVfProcessorEnergyConfiguration", "Processor-Energy-Configuration", VersionMeta.Version121a, "InputOutput", 0x1, [], ["read-only"], ['biosVProfile'], [], ["Get", "Set"]),
    "BiosVfProcessorPrefetchConfig": MoMeta("BiosVfProcessorPrefetchConfig", "biosVfProcessorPrefetchConfig", "Processor-Prefetch-Config", VersionMeta.Version121a, "InputOutput", 0x1, [], ["read-only"], ['biosVProfile'], [], ["Get", "Set"]),
    "BiosVfQPILinkFrequencySelect": MoMeta("BiosVfQPILinkFrequencySelect", "biosVfQPILinkFrequencySelect", "QPI-Link-Frequency-Select", VersionMeta.Version121a, "InputOutput", 0x1, [], ["read-only"], ['biosVProfile'], [], ["Get", "Set"]),
    "BiosVfQPISnoopMode": MoMeta("BiosVfQPISnoopMode", "biosVfQPISnoopMode", "QPI-Snoop-Mode", VersionMeta.Version141a, "InputOutput", 0x1, [], ["read-only"], ['biosVProfile'], [], ["Get", "Set"]),
    "BiosVfQuietBoot": MoMeta("BiosVfQuietBoot", "biosVfQuietBoot", "Quiet-Boot", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['biosVProfile'], [], ["Get", "Set"]),
    "BiosVfRedirectionAfterBIOSPOST": MoMeta("BiosVfRedirectionAfterBIOSPOST", "biosVfRedirectionAfterBIOSPOST", "Redirection-After-BIOS-POST", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], ['biosVProfile'], [], [None]),
    "BiosVfResumeOnACPowerLoss": MoMeta("BiosVfResumeOnACPowerLoss", "biosVfResumeOnACPowerLoss", "Resume-on-AC-power-loss", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['biosVProfile'], [], ["Get", "Set"]),
    "BiosVfSBMezz1OptionROM": MoMeta("BiosVfSBMezz1OptionROM", "biosVfSBMezz1OptionROM", "SBMezz1-OptionROM", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], ['biosVProfile'], [], [None]),
    "BiosVfSBNVMe1OptionROM": MoMeta("BiosVfSBNVMe1OptionROM", "biosVfSBNVMe1OptionROM", "SBNVMe1-OptionROM", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], ['biosVProfile'], [], [None]),
    "BiosVfSIOC1OptionROM": MoMeta("BiosVfSIOC1OptionROM", "biosVfSIOC1OptionROM", "SIOC1-OptionROM", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], ['biosVProfile'], [], [None]),
    "BiosVfSIOC2OptionROM": MoMeta("BiosVfSIOC2OptionROM", "biosVfSIOC2OptionROM", "SIOC2-OptionROM", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], ['biosVProfile'], [], [None]),
    "BiosVfScrubPolicies": MoMeta("BiosVfScrubPolicies", "biosVfScrubPolicies", "Scrub-Policies", VersionMeta.Version121a, "InputOutput", 0x1, [], ["read-only"], ['biosVProfile'], [], ["Get", "Set"]),
    "BiosVfSelectMemoryRASConfiguration": MoMeta("BiosVfSelectMemoryRASConfiguration", "biosVfSelectMemoryRASConfiguration", "SelectMemory-RAS-configuration", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['biosVProfile'], [], ["Get", "Set"]),
    "BiosVfSerialPortAEnable": MoMeta("BiosVfSerialPortAEnable", "biosVfSerialPortAEnable", "Serial-port-A-enable", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['biosVProfile'], [], ["Get", "Set"]),
    "BiosVfSparingMode": MoMeta("BiosVfSparingMode", "biosVfSparingMode", "Sparing-Mode", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['biosVProfile'], [], ["Get", "Set"]),
    "BiosVfSriovConfig": MoMeta("BiosVfSriovConfig", "biosVfSriovConfig", "Sriov-Config", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['biosVProfile'], [], ["Get", "Set"]),
    "BiosVfTPMPendingOperation": MoMeta("BiosVfTPMPendingOperation", "biosVfTPMPendingOperation", "TPM-Pending-Operation", VersionMeta.Version141a, "InputOutput", 0x1, [], ["read-only"], ['biosVProfile'], [], ["Get", "Set"]),
    "BiosVfTPMSupport": MoMeta("BiosVfTPMSupport", "biosVfTPMSupport", "TPM-Support", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], ['biosVProfile'], [], [None]),
    "BiosVfTrustedPlatformModule": MoMeta("BiosVfTrustedPlatformModule", "biosVfTrustedPlatformModule", "Trusted-Platform-Module", VersionMeta.Version141a, "InputOutput", 0x1, [], ["read-only"], ['biosVProfile'], [], ["Get", "Set"]),
    "BiosVfUCSMBootModeControl": MoMeta("BiosVfUCSMBootModeControl", "biosVfUCSMBootModeControl", "UCSM-Boot-Mode-Control", VersionMeta.Version112a, "InputOutput", 0x1, [], ["read-only"], ['biosVProfile'], [], ["Get", "Set"]),
    "BiosVfUCSMBootOrderRuleControl": MoMeta("BiosVfUCSMBootOrderRuleControl", "biosVfUCSMBootOrderRuleControl", "UCSM-Boot-Order-Rule-Control", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['biosVProfile'], [], ["Get", "Set"]),
    "BiosVfUEFIOSUseLegacyVideo": MoMeta("BiosVfUEFIOSUseLegacyVideo", "biosVfUEFIOSUseLegacyVideo", "UEFI-OS-use-legacy-video", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['biosVProfile'], [], ["Get", "Set"]),
    "BiosVfUSBBootConfig": MoMeta("BiosVfUSBBootConfig", "biosVfUSBBootConfig", "USB-Boot-Config", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['biosVProfile'], [], ["Get", "Set"]),
    "BiosVfUSBConfiguration": MoMeta("BiosVfUSBConfiguration", "biosVfUSBConfiguration", "USB-Configuration", VersionMeta.Version141a, "InputOutput", 0x1, [], ["read-only"], ['biosVProfile'], [], ["Get", "Set"]),
    "BiosVfUSBFrontPanelAccessLock": MoMeta("BiosVfUSBFrontPanelAccessLock", "biosVfUSBFrontPanelAccessLock", "USB-Front-Panel-Access-Lock", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['biosVProfile'], [], ["Get", "Set"]),
    "BiosVfUSBPortConfiguration": MoMeta("BiosVfUSBPortConfiguration", "biosVfUSBPortConfiguration", "USB-port-configuration", VersionMeta.Version121a, "InputOutput", 0x1, [], ["read-only"], ['biosVProfile'], [], ["Get", "Set"]),
    "BiosVfUSBSystemIdlePowerOptimizingSetting": MoMeta("BiosVfUSBSystemIdlePowerOptimizingSetting", "biosVfUSBSystemIdlePowerOptimizingSetting", "USB-System-Idle-Power-Optimizing-Setting", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['biosVProfile'], [], ["Get", "Set"]),
    "BiosVfVGAPriority": MoMeta("BiosVfVGAPriority", "biosVfVGAPriority", "VGA-Priority", VersionMeta.Version121a, "InputOutput", 0x1, [], ["read-only"], ['biosVProfile'], [], ["Get", "Set"]),
    "BiosVfWorkloadConfiguration": MoMeta("BiosVfWorkloadConfiguration", "biosVfWorkloadConfiguration", "Workload-Configuration", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], ['biosVProfile'], [], [None]),
    "CallhomeDest": MoMeta("CallhomeDest", "callhomeDest", "email-[email]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "operations"], ['callhomeProfile'], [], ["Add", "Get", "Remove"]),
    "CallhomeEp": MoMeta("CallhomeEp", "callhomeEp", "call-home", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "operations"], ['callhomeHolder', 'orgDomainGroup', 'orgOrg', 'policyDeviceProfile', 'smartlicenseHolder'], ['callhomeFaultInst', 'callhomeHttp', 'callhomePeriodicSystemInventory', 'callhomePolicy', 'callhomeProfile', 'callhomeSmtp', 'callhomeSource', 'callhomeTestAlert', 'smartcallhomeHttpProxy', 'smartcallhomePeriodicSystemInventory', 'smartcallhomePolicy', 'smartcallhomeProfile', 'smartcallhomeSource', 'smartcallhomeTransportGateway'], ["Add", "Get", "Remove", "Set"]),
    "CallhomeFaultInst": MoMeta("CallhomeFaultInst", "callhomeFaultInst", "call-home-fault", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "fault", "operations"], ['callhomeEp'], [], ["Get"]),
    "CallhomeHolder": MoMeta("CallhomeHolder", "callhomeHolder", "smartcallhome", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin"], ['topRoot'], ['callhomeEp', 'callhomeHolderFsm', 'callhomeHolderFsmTask', 'eventInst', 'faultInst', 'smartcallhomePeriodicInventoryStatus'], ["Get"]),
    "CallhomeHolderFsm": MoMeta("CallhomeHolderFsm", "callhomeHolderFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['callhomeHolder'], ['callhomeHolderFsmStage'], ["Get"]),
    "CallhomeHolderFsmStage": MoMeta("CallhomeHolderFsmStage", "callhomeHolderFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['callhomeHolderFsm'], [], ["Get"]),
    "CallhomeHolderFsmTask": MoMeta("CallhomeHolderFsmTask", "callhomeHolderFsmTask", "task-[item]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['callhomeHolder'], [], ["Get"]),
    "CallhomeHttp": MoMeta("CallhomeHttp", "callhomeHttp", "http", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "operations"], ['callhomeEp'], [], ["Get", "Set"]),
    "CallhomePeriodicSystemInventory": MoMeta("CallhomePeriodicSystemInventory", "callhomePeriodicSystemInventory", "periodicsysteminventory", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "operations"], ['callhomeEp'], [], ["Add", "Get", "Remove", "Set"]),
    "CallhomePolicy": MoMeta("CallhomePolicy", "callhomePolicy", "policy-[cause]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "fault"], ['callhomeEp'], [], ["Add", "Get", "Remove", "Set"]),
    "CallhomeProfile": MoMeta("CallhomeProfile", "callhomeProfile", "profile-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "operations"], ['callhomeEp'], ['callhomeDest'], ["Add", "Get", "Remove", "Set"]),
    "CallhomeSmtp": MoMeta("CallhomeSmtp", "callhomeSmtp", "smtp", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "operations"], ['callhomeEp'], [], ["Add", "Get", "Remove", "Set"]),
    "CallhomeSource": MoMeta("CallhomeSource", "callhomeSource", "source", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "operations"], ['callhomeEp'], [], ["Add", "Get", "Remove", "Set"]),
    "CallhomeTestAlert": MoMeta("CallhomeTestAlert", "callhomeTestAlert", "testalert", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "operations"], ['callhomeEp'], [], ["Add", "Get", "Remove", "Set"]),
    "CapabilityCatalogue": MoMeta("CapabilityCatalogue", "capabilityCatalogue", "capabilities", VersionMeta.Version101a, "InputOutput", 0x1, [], [""], ['topRoot'], ['adaptorFruCapProvider', 'diagSrvCapProvider', 'domainFamilyCapProvider', 'equipmentBladeCapProvider', 'equipmentChassisCapProvider', 'equipmentCrossFabricModuleCapProvider', 'equipmentFanModuleCapProvider', 'equipmentFexCapProvider', 'equipmentGemCapProvider', 'equipmentGraphicsCardCapProvider', 'equipmentHostIfCapProvider', 'equipmentIOCardCapProvider', 'equipmentLocalDiskCapProvider', 'equipmentLocalDiskControllerCapProvider', 'equipmentMemoryUnitCapProvider', 'equipmentPcieConnectorCapProvider', 'equipmentPcieNodeCapProvider', 'equipmentProcessorUnitCapProvider', 'equipmentPsuCapProvider', 'equipmentRackUnitCapProvider', 'equipmentServerUnitCapProvider', 'equipmentSwitchCapProvider', 'equipmentSwitchIOCardCapProvider', 'equipmentSystemFruCapProvider', 'firmwareBundleTypeCapProvider', 'firmwareType', 'licenseFeatureCapProvider'], ["Get"]),
    "CertRepairEp": MoMeta("CertRepairEp", "certRepairEp", "cert-repair", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], ['topSystem'], ['certRepairEpFsm', 'certRepairEpFsmTask', 'eventInst', 'faultInst'], [None]),
    "CertRepairEpFsm": MoMeta("CertRepairEpFsm", "certRepairEpFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['certRepairEp'], ['certRepairEpFsmStage'], [None]),
    "CertRepairEpFsmStage": MoMeta("CertRepairEpFsmStage", "certRepairEpFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['certRepairEpFsm'], [], [None]),
    "CertRepairEpFsmTask": MoMeta("CertRepairEpFsmTask", "certRepairEpFsmTask", "task-[item]", VersionMeta.Version101a, "OutputOnly", 0x1, [], [""], ['certRepairEp'], [], [None]),
    "ChangeChangedObjectRef": MoMeta("ChangeChangedObjectRef", "changeChangedObjectRef", "ChangedObjectRef[id]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['changeEp'], [], [None]),
    "ChangeEp": MoMeta("ChangeEp", "changeEp", "syncEp", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['extpolDomain'], ['changeChangedObjectRef', 'changeEpFsm', 'changeEpFsmTask', 'eventInst', 'faultInst'], [None]),
    "ChangeEpFsm": MoMeta("ChangeEpFsm", "changeEpFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['changeEp'], ['changeEpFsmStage'], [None]),
    "ChangeEpFsmStage": MoMeta("ChangeEpFsmStage", "changeEpFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['changeEpFsm'], [], [None]),
    "ChangeEpFsmTask": MoMeta("ChangeEpFsmTask", "changeEpFsmTask", "task-[item]", VersionMeta.Version111a, "OutputOnly", 0x1, [], [""], ['changeEp'], [], [None]),
    "CimcvmediaActualMountEntry": MoMeta("CimcvmediaActualMountEntry", "cimcvmediaActualMountEntry", "actual-mount-entry-[virtual_disk_id]", VersionMeta.Version121e, "InputOutput", 0x1, [], ["read-only"], ['cimcvmediaActualMountList'], [], ["Get"]),
    "CimcvmediaActualMountList": MoMeta("CimcvmediaActualMountList", "cimcvmediaActualMountList", "actual-mount-list", VersionMeta.Version121e, "InputOutput", 0x1, [], ["read-only"], ['mgmtController'], ['cimcvmediaActualMountEntry', 'cimcvmediaExtMgmtRuleEntry'], ["Get"]),
    "CimcvmediaConfigMountEntry": MoMeta("CimcvmediaConfigMountEntry", "cimcvmediaConfigMountEntry", "cfg-mnt-entry-[mapping_name]", VersionMeta.Version121e, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], ['cimcvmediaMountConfigDef', 'cimcvmediaMountConfigPolicy'], [], ["Add", "Get", "Remove", "Set"]),
    "CimcvmediaExtMgmtRuleEntry": MoMeta("CimcvmediaExtMgmtRuleEntry", "cimcvmediaExtMgmtRuleEntry", "ext-mgmt-rule-[mapping_name]", VersionMeta.Version121e, "InputOutput", 0x1, [], ["read-only"], ['cimcvmediaActualMountList'], [], ["Get"]),
    "CimcvmediaMountConfigDef": MoMeta("CimcvmediaMountConfigDef", "cimcvmediaMountConfigDef", "mnt-cfg-def", VersionMeta.Version121e, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], ['lsServer'], ['cimcvmediaConfigMountEntry'], ["Add", "Get", "Remove", "Set"]),
    "CimcvmediaMountConfigPolicy": MoMeta("CimcvmediaMountConfigPolicy", "cimcvmediaMountConfigPolicy", "mnt-cfg-policy-[name]", VersionMeta.Version121e, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], ['orgOrg'], ['cimcvmediaConfigMountEntry'], ["Add", "Get", "Remove", "Set"]),
    "ClitestTypeTest": MoMeta("ClitestTypeTest", "clitestTypeTest", "tt-", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], ['topRoot'], [], ["Get"]),
    "ClitestTypeTest2": MoMeta("ClitestTypeTest2", "clitestTypeTest2", "tt2-", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], ['topRoot'], [], ["Get"]),
    "ClitestTypeTestChild": MoMeta("ClitestTypeTestChild", "clitestTypeTestChild", "tt-child", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], [], [], ["Get"]),
    "CommCimxml": MoMeta("CommCimxml", "commCimxml", "cimxml-svc", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin"], ['orgDomainGroup', 'orgOrg'], [], ["Add", "Get", "Remove", "Set"]),
    "CommCoreFile": MoMeta("CommCoreFile", "commCoreFile", "core-file-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], ['orgDomainGroup', 'orgOrg', 'policyDeviceProfile'], [], [None]),
    "CommDateTime": MoMeta("CommDateTime", "commDateTime", "datetime-svc", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-security", "operations"], ['commLocale', 'commSvcEp', 'commSvcPolicy', 'orgDomainGroup', 'orgOrg', 'policyDeviceProfile'], ['commDateTimeFsm', 'commDateTimeFsmTask', 'commNtpProvider', 'eventInst', 'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "CommDateTimeFsm": MoMeta("CommDateTimeFsm", "commDateTimeFsm", "fsm", VersionMeta.Version151a, "OutputOnly", 0x1, [], [""], ['commDateTime'], ['commDateTimeFsmStage'], [None]),
    "CommDateTimeFsmStage": MoMeta("CommDateTimeFsmStage", "commDateTimeFsmStage", "stage-[name]", VersionMeta.Version151a, "OutputOnly", 0x1, [], [""], ['commDateTimeFsm'], [], [None]),
    "CommDateTimeFsmTask": MoMeta("CommDateTimeFsmTask", "commDateTimeFsmTask", "task-[item]", VersionMeta.Version151a, "OutputOnly", 0x1, [], [""], ['commDateTime'], [], [None]),
    "CommDns": MoMeta("CommDns", "commDns", "dns-svc", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin", "ext-lan-config"], ['commLocale', 'commSvcPolicy', 'orgDomainGroup', 'orgOrg', 'policyDeviceProfile'], ['commDnsProvider'], ["Add", "Get", "Remove", "Set"]),
    "CommDnsProvider": MoMeta("CommDnsProvider", "commDnsProvider", "dns-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin", "ext-lan-config"], ['commDns'], [], ["Add", "Get", "Remove"]),
    "CommEvtChannel": MoMeta("CommEvtChannel", "commEvtChannel", "svc-evt-channel", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin"], ['orgDomainGroup', 'orgOrg'], [], ["Get"]),
    "CommHttp": MoMeta("CommHttp", "commHttp", "http-svc", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin"], ['orgDomainGroup', 'orgOrg', 'policyDeviceProfile'], [], ["Add", "Get", "Remove", "Set"]),
    "CommHttps": MoMeta("CommHttps", "commHttps", "https-svc", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin"], ['commSvcEp', 'orgDomainGroup', 'orgOrg', 'policyDeviceProfile'], [], ["Get", "Set"]),
    "CommLocale": MoMeta("CommLocale", "commLocale", "locale-[name]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], ['storageProcessor'], ['commDateTime', 'commDns', 'commSyslog'], [None]),
    "CommLogComponent": MoMeta("CommLogComponent", "commLogComponent", "log-comp-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "operations"], ['commSyslog'], [], [None]),
    "CommNtp": MoMeta("CommNtp", "commNtp", "ntp-svc", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-security", "operations"], [], [], [None]),
    "CommNtpProvider": MoMeta("CommNtpProvider", "commNtpProvider", "ntp-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-security", "operations"], ['commDateTime'], [], ["Add", "Get", "Remove"]),
    "CommShellSvcLimits": MoMeta("CommShellSvcLimits", "commShellSvcLimits", "shell-svc-limits", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin"], ['orgDomainGroup', 'orgOrg', 'policyDeviceProfile'], [], ["Get"]),
    "CommSmashCLP": MoMeta("CommSmashCLP", "commSmashCLP", "smashclp-svc", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin"], ['orgDomainGroup', 'orgOrg'], [], ["Get"]),
    "CommSnmp": MoMeta("CommSnmp", "commSnmp", "snmp-svc", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin"], ['orgDomainGroup', 'orgOrg', 'policyDeviceProfile'], ['commSnmpCommunity', 'commSnmpTrap', 'commSnmpTrapData', 'commSnmpUser'], ["Add", "Get", "Remove", "Set"]),
    "CommSnmpCommunity": MoMeta("CommSnmpCommunity", "commSnmpCommunity", "snmp-community-[community]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin"], ['commSnmp'], [], [None]),
    "CommSnmpTrap": MoMeta("CommSnmpTrap", "commSnmpTrap", "snmp-trap[hostname]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin"], ['commSnmp'], [], ["Add", "Get", "Remove", "Set"]),
    "CommSnmpTrapData": MoMeta("CommSnmpTrapData", "commSnmpTrapData", "snmp-trap-data[prop_oid]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["read-only"], ['commSnmp'], [], [None]),
    "CommSnmpUser": MoMeta("CommSnmpUser", "commSnmpUser", "snmpv3-user-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin"], ['commSnmp'], [], ["Add", "Get", "Remove", "Set"]),
    "CommSsh": MoMeta("CommSsh", "commSsh", "ssh-svc", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin"], ['orgDomainGroup', 'orgOrg', 'policyDeviceProfile'], [], ["Get"]),
    "CommSvcEp": MoMeta("CommSvcEp", "commSvcEp", "svc-ext", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin"], ['computeSystem', 'topSystem'], ['commDateTime', 'commHttps', 'commSvcEpFsm', 'commSvcEpFsmTask', 'eventInst', 'faultInst'], ["Get"]),
    "CommSvcEpFsm": MoMeta("CommSvcEpFsm", "commSvcEpFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['commSvcEp'], ['commSvcEpFsmStage'], [None]),
    "CommSvcEpFsmStage": MoMeta("CommSvcEpFsmStage", "commSvcEpFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['commSvcEpFsm'], [], [None]),
    "CommSvcEpFsmTask": MoMeta("CommSvcEpFsmTask", "commSvcEpFsmTask", "task-[item]", VersionMeta.Version101a, "OutputOnly", 0x1, [], [""], ['commSvcEp'], [], [None]),
    "CommSvcPolicy": MoMeta("CommSvcPolicy", "commSvcPolicy", "comm-pol-[name]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], ['orgOrg'], ['commDateTime', 'commDns', 'commSyslog'], [None]),
    "CommSyslog": MoMeta("CommSyslog", "commSyslog", "syslog", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "operations"], ['commLocale', 'commSvcPolicy', 'orgDomainGroup', 'orgOrg', 'policyDeviceProfile'], ['commLogComponent', 'commSyslogClient', 'commSyslogConsole', 'commSyslogFile', 'commSyslogMonitor', 'commSyslogSource'], ["Add", "Get", "Remove", "Set"]),
    "CommSyslogClient": MoMeta("CommSyslogClient", "commSyslogClient", "client-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "operations"], ['commSyslog'], [], ["Add", "Get", "Set"]),
    "CommSyslogConsole": MoMeta("CommSyslogConsole", "commSyslogConsole", "console", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "operations"], ['commSyslog'], [], ["Add", "Get", "Set"]),
    "CommSyslogFile": MoMeta("CommSyslogFile", "commSyslogFile", "file", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "operations"], ['commSyslog'], [], ["Add", "Get", "Set"]),
    "CommSyslogMonitor": MoMeta("CommSyslogMonitor", "commSyslogMonitor", "monitor", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "operations"], ['commSyslog'], [], ["Add", "Get", "Set"]),
    "CommSyslogSource": MoMeta("CommSyslogSource", "commSyslogSource", "source", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "domain-group-management", "operations"], ['commSyslog'], [], ["Add", "Get", "Set"]),
    "CommTelnet": MoMeta("CommTelnet", "commTelnet", "telnet-svc", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin"], ['orgDomainGroup', 'orgOrg', 'policyDeviceProfile'], [], ["Add", "Get", "Remove", "Set"]),
    "CommWebChannel": MoMeta("CommWebChannel", "commWebChannel", "svc-web-channel", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin"], ['orgDomainGroup', 'orgOrg'], [], ["Get"]),
    "CommWebSvcLimits": MoMeta("CommWebSvcLimits", "commWebSvcLimits", "web-svc-limits", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin"], ['orgDomainGroup', 'orgOrg', 'policyDeviceProfile'], [], ["Add", "Get", "Remove", "Set"]),
    "CommWsman": MoMeta("CommWsman", "commWsman", "wsman-svc", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin"], ['orgDomainGroup', 'orgOrg'], [], ["Get"]),
    "CommXmlClConnPolicy": MoMeta("CommXmlClConnPolicy", "commXmlClConnPolicy", "xmlclconnpolicy-[client_type]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin", "domain-group-management"], ['orgDomainGroup'], [], ["Get"]),
    "ComputeAutoconfigPolicy": MoMeta("ComputeAutoconfigPolicy", "computeAutoconfigPolicy", "autoconfig-[name]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "pn-policy"], ['orgDomainGroup', 'orgOrg'], ['faultInst'], ["Get", "Set"]),
    "ComputeBlade": MoMeta("ComputeBlade", "computeBlade", "blade-[slot_id]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], ['equipmentChassis'], ['adaptorHostIfConfig', 'adaptorUnit', 'biosUnit', 'computeBoard', 'computeBoardConnector', 'computeBoardController', 'computeExtBoard', 'computeFactoryResetOp', 'computeFactoryResetOperation', 'computePhysicalExtension', 'computePhysicalOperation', 'computePoolable', 'computeRebootLog', 'diagSrvCtrl', 'equipmentBeaconLed', 'equipmentHealthLed', 'equipmentIndicatorLed', 'equipmentLocatorLed', 'equipmentPcieNode', 'faultInst', 'firmwareStatus', 'lsIdentityInfo', 'lsbootDef', 'memoryRuntime', 'mgmtController', 'mgmtSecurity', 'osInstance', 'processorRuntime', 'storageEnclosure', 'storageVirtualDriveContainer', 'sysdebugDiagnosticLog'], ["Get"]),
    "ComputeBladeDiscPolicy": MoMeta("ComputeBladeDiscPolicy", "computeBladeDiscPolicy", "blade-discovery[name]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "domain-group-management", "pn-policy", "read-only"], ['orgDomainGroup', 'orgOrg'], [], ["Add", "Get", "Remove", "Set"]),
    "ComputeBladeEp": MoMeta("ComputeBladeEp", "computeBladeEp", "blade-ep-[id]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], ['storageBlade'], [], ["Get"]),
    "ComputeBladeInheritPolicy": MoMeta("ComputeBladeInheritPolicy", "computeBladeInheritPolicy", "blade-inherit-[name]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "pn-policy"], ['orgDomainGroup', 'orgOrg'], ['faultInst'], ["Add", "Get", "Remove", "Set"]),
    "ComputeBoard": MoMeta("ComputeBoard", "computeBoard", "board", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['computeBlade', 'computeRackUnit', 'computeServerUnit'], ['computeIOHub', 'computeMbPowerStats', 'computeMbTempStats', 'computePCIeFatalCompletionStats', 'computePCIeFatalProtocolStats', 'computePCIeFatalReceiveStats', 'computePCIeFatalStats', 'computeRackUnitMbTempStats', 'equipmentPcieConnectorUnit', 'faultInst', 'graphicsCard', 'lstorageLocal', 'lstorageLocalDef', 'lstorageRemote', 'lstorageRemoteDef', 'memoryArray', 'memoryBufferUnit', 'processorUnit', 'securityUnit', 'storageController', 'storageFlexFlashController', 'storageSasExpander'], ["Get"]),
    "ComputeBoardConnector": MoMeta("ComputeBoardConnector", "computeBoardConnector", "board-conn", VersionMeta.Version121a, "InputOutput", 0x1, [], ["read-only"], ['computeBlade'], [], ["Get"]),
    "ComputeBoardController": MoMeta("ComputeBoardController", "computeBoardController", "boardController", VersionMeta.Version141a, "InputOutput", 0x1, [], ["read-only"], ['computeBlade', 'computeExtBoard', 'computeRackUnit', 'computeServerUnit', 'equipmentChassis', 'equipmentSystemIOController'], ['mgmtController'], ["Get"]),
    "ComputeCartridge": MoMeta("ComputeCartridge", "computeCartridge", "cartridge-[slot_id]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], ['equipmentChassis'], ['computeCartridgeOperation', 'computeServerUnit'], ["Get", "Set"]),
    "ComputeCartridgeOperation": MoMeta("ComputeCartridgeOperation", "computeCartridgeOperation", "remote-oper", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], ['computeCartridge'], ['faultInst'], ["Get", "Set"]),
    "ComputeChassisConnPolicy": MoMeta("ComputeChassisConnPolicy", "computeChassisConnPolicy", "chassis-conn-policy-chassis-[chassis_id]-fabric-[switch_id]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "domain-group-management", "pn-policy"], ['computeSystem', 'orgDomainGroup', 'orgOrg'], ['computeChassisConnPolicyOperation'], ["Get", "Set"]),
    "ComputeChassisConnPolicyOperation": MoMeta("ComputeChassisConnPolicyOperation", "computeChassisConnPolicyOperation", "remote-oper", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "pn-policy"], ['computeChassisConnPolicy'], ['faultInst'], ["Get", "Set"]),
    "ComputeChassisDiscPolicy": MoMeta("ComputeChassisDiscPolicy", "computeChassisDiscPolicy", "chassis-discovery", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "domain-group-management", "pn-policy"], ['orgDomainGroup', 'orgOrg'], [], ["Get", "Set"]),
    "ComputeChassisFeatMask": MoMeta("ComputeChassisFeatMask", "computeChassisFeatMask", "chassis-feat-mask", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], ['computeSystem', 'equipmentChassis', 'equipmentChassisProfile', 'extpolDomain'], [], ["get"]),
    "ComputeChassisQual": MoMeta("ComputeChassisQual", "computeChassisQual", "chassis-from-[min_id]-to-[max_id]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "pn-policy", "read-only"], ['computeDomainQual'], ['computeSlotQual'], ["Add", "Get", "Remove", "Set"]),
    "ComputeDomainGroupQual": MoMeta("ComputeDomainGroupQual", "computeDomainGroupQual", "domaingroup-qualifier-[name]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "pn-policy", "read-only"], ['computeDomainQual'], [], ["Add", "Get", "Remove", "Set"]),
    "ComputeDomainHwChangeDiscPolicy": MoMeta("ComputeDomainHwChangeDiscPolicy", "computeDomainHwChangeDiscPolicy", "hw-change-disc-policy-[name]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "domain-group-management", "pn-policy", "read-only"], ['orgDomainGroup', 'orgOrg'], [], ["add", "get", "remove", "set"]),
    "ComputeDomainNameQual": MoMeta("ComputeDomainNameQual", "computeDomainNameQual", "domain-name-qualifier-[name]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "pn-policy", "read-only"], ['computeDomainQual'], [], ["Add", "Get", "Remove"]),
    "ComputeDomainPortDiscPolicy": MoMeta("ComputeDomainPortDiscPolicy", "computeDomainPortDiscPolicy", "port-discovery-[name]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "domain-group-management", "pn-policy"], ['orgDomainGroup', 'orgOrg'], [], ["add", "get", "remove", "set"]),
    "ComputeDomainQual": MoMeta("ComputeDomainQual", "computeDomainQual", "Domain-qualifier-[name]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "pn-policy", "read-only"], ['computeQual'], ['computeChassisQual', 'computeDomainGroupQual', 'computeDomainNameQual', 'computeOwnerQual', 'computeProductFamilyQual', 'computeRackQual', 'computeSiteQual', 'computeSystemAddrQual'], ["Add", "Get", "Remove"]),
    "ComputeEnvFeatMask": MoMeta("ComputeEnvFeatMask", "computeEnvFeatMask", "env-feat-mask", VersionMeta.Version112a, "InputOutput", 0x1, [], ["read-only"], ['computeSystem', 'extpolDomain', 'lsServer'], [], ["Get"]),
    "ComputeExtBoard": MoMeta("ComputeExtBoard", "computeExtBoard", "ext-board-[id]", VersionMeta.Version112a, "InputOutput", 0x1, [], ["read-only"], ['computeBlade', 'computeRackUnit', 'computeServerUnit'], ['computeBoardController', 'equipmentHealthLed', 'equipmentLocatorLed', 'powerBudget'], ["Get"]),
    "ComputeFabricEthMonSrcEp": MoMeta("ComputeFabricEthMonSrcEp", "computeFabricEthMonSrcEp", "src-[id]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], ['computeFabricEthMonSrcEpCont'], [], [None]),
    "ComputeFabricEthMonSrcEpCont": MoMeta("ComputeFabricEthMonSrcEpCont", "computeFabricEthMonSrcEpCont", "eth-mon", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "operations"], ['computeSystem'], ['computeFabricEthMonSrcEp'], [None]),
    "ComputeFabricFcMonSrcEp": MoMeta("ComputeFabricFcMonSrcEp", "computeFabricFcMonSrcEp", "src-[id]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], ['computeFabricFcMonSrcEpCont'], [], [None]),
    "ComputeFabricFcMonSrcEpCont": MoMeta("ComputeFabricFcMonSrcEpCont", "computeFabricFcMonSrcEpCont", "fc-mon", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "operations"], ['computeSystem'], ['computeFabricFcMonSrcEp'], [None]),
    "ComputeFactoryResetOp": MoMeta("ComputeFactoryResetOp", "computeFactoryResetOp", "factory-reset-remote-oper", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], ['computeBlade', 'computeRackUnit', 'computeServerUnit'], ['faultInst'], ["get", "set"]),
    "ComputeFactoryResetOperation": MoMeta("ComputeFactoryResetOperation", "computeFactoryResetOperation", "factory-reset", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], ['computeBlade', 'computeRackUnit', 'computeServerUnit'], [], ["Get", "Set"]),
    "ComputeFaultUpgradeFlag": MoMeta("ComputeFaultUpgradeFlag", "computeFaultUpgradeFlag", "fltUpgFlg", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin"], ['computeResourceAggrEp'], [], ["Get"]),
    "ComputeGraphicsCardPolicy": MoMeta("ComputeGraphicsCardPolicy", "computeGraphicsCardPolicy", "graphics-card-policy-[name]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-equipment", "pn-maintenance", "pn-policy"], ['orgOrg'], [], ["add", "get", "remove", "set"]),
    "ComputeGroupMembership": MoMeta("ComputeGroupMembership", "computeGroupMembership", "membership-[ip]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "domain-group-management"], ['computeResourceAggrEp'], ['faultInst'], ["Add", "Get", "Remove", "Set"]),
    "ComputeGroupMembershipRef": MoMeta("ComputeGroupMembershipRef", "computeGroupMembershipRef", "membershipref-[id]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], ['orgDomainGroup'], [], ["get"]),
    "ComputeHwChangeDiscPolicy": MoMeta("ComputeHwChangeDiscPolicy", "computeHwChangeDiscPolicy", "hw-change-disc-policy", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "domain-group-management", "pn-policy", "read-only"], ['orgDomainGroup', 'orgOrg'], [], ["add", "get", "remove", "set"]),
    "ComputeIOHub": MoMeta("ComputeIOHub", "computeIOHub", "iohub", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['computeBoard'], ['computeIOHubEnvStats', 'faultInst'], ["Get"]),
    "ComputeIOHubEnvStats": MoMeta("ComputeIOHubEnvStats", "computeIOHubEnvStats", "iohub-stats", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['computeIOHub'], ['computeIOHubEnvStatsHist'], [None]),
    "ComputeIOHubEnvStatsHist": MoMeta("ComputeIOHubEnvStatsHist", "computeIOHubEnvStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], ['computeIOHubEnvStats'], [], [None]),
    "ComputeInstance": MoMeta("ComputeInstance", "computeInstance", "inst-[id]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server"], ['computeRequirement'], ['lsFcLocale', 'lsIssues', 'lsPower', 'lsServerOperation', 'lsmaintAck', 'mgmtInterface', 'storageIpV4PooledAddr', 'storageIpV4StaticAddr', 'storageVirtualDriveRef', 'vnicEther', 'vnicFc', 'vnicIScsi', 'vnicIpV4MgmtPooledAddr', 'vnicIpV4PooledAddr', 'vnicIpV4StaticAddr'], ["Get"]),
    "ComputeInstanceIdQual": MoMeta("ComputeInstanceIdQual", "computeInstanceIdQual", "inst-from-[min_id]-to-[max_id]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "pn-policy", "read-only"], ['computeSlotQual'], [], ["Add", "Get", "Remove"]),
    "ComputeInstanceMapping": MoMeta("ComputeInstanceMapping", "computeInstanceMapping", "instmap-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], ['computeSystem'], [], [None]),
    "ComputeLocalTemplDef": MoMeta("ComputeLocalTemplDef", "computeLocalTemplDef", "inst-[id]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], ['computeTemplate'], ['vnicEther', 'vnicFc', 'vnicIScsi'], ["Get"]),
    "ComputeMbPowerStats": MoMeta("ComputeMbPowerStats", "computeMbPowerStats", "power-stats", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['computeBoard'], ['computeMbPowerStatsHist'], [None]),
    "ComputeMbPowerStatsHist": MoMeta("ComputeMbPowerStatsHist", "computeMbPowerStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], ['computeMbPowerStats'], [], [None]),
    "ComputeMbTempStats": MoMeta("ComputeMbTempStats", "computeMbTempStats", "temp-stats", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['computeBoard'], ['computeMbTempStatsHist'], [None]),
    "ComputeMbTempStatsHist": MoMeta("ComputeMbTempStatsHist", "computeMbTempStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], ['computeMbTempStats'], [], [None]),
    "ComputeModularChassisFanPolicy": MoMeta("ComputeModularChassisFanPolicy", "computeModularChassisFanPolicy", "modular-chassis-fan-policy", VersionMeta.Version201u, "InputOutput", 0x1, [], ["admin", "domain-group-management", "pn-equipment", "pn-policy"], ['orgDomainGroup'], [], [None]),
    "ComputeNetworkFeatMask": MoMeta("ComputeNetworkFeatMask", "computeNetworkFeatMask", "net-feat-mask", VersionMeta.Version112a, "InputOutput", 0x1, [], ["read-only"], ['computeSystem', 'extpolDomain', 'lsServer'], [], ["Get"]),
    "ComputeOwnerQual": MoMeta("ComputeOwnerQual", "computeOwnerQual", "owner-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "pn-policy", "read-only"], ['computeDomainQual', 'computeSystemQual'], [], ["Add", "Get", "Remove", "Set"]),
    "ComputePCIeFatalCompletionStats": MoMeta("ComputePCIeFatalCompletionStats", "computePCIeFatalCompletionStats", "pciefat-completion-stats", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['computeBoard'], ['computePCIeFatalCompletionStatsHist'], [None]),
    "ComputePCIeFatalCompletionStatsHist": MoMeta("ComputePCIeFatalCompletionStatsHist", "computePCIeFatalCompletionStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], ['computePCIeFatalCompletionStats'], [], [None]),
    "ComputePCIeFatalProtocolStats": MoMeta("ComputePCIeFatalProtocolStats", "computePCIeFatalProtocolStats", "pciefat-protocol-stats", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['computeBoard'], ['computePCIeFatalProtocolStatsHist'], [None]),
    "ComputePCIeFatalProtocolStatsHist": MoMeta("ComputePCIeFatalProtocolStatsHist", "computePCIeFatalProtocolStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], ['computePCIeFatalProtocolStats'], [], [None]),
    "ComputePCIeFatalReceiveStats": MoMeta("ComputePCIeFatalReceiveStats", "computePCIeFatalReceiveStats", "pciefat-receive-stats", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['computeBoard'], ['computePCIeFatalReceiveStatsHist'], [None]),
    "ComputePCIeFatalReceiveStatsHist": MoMeta("ComputePCIeFatalReceiveStatsHist", "computePCIeFatalReceiveStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], ['computePCIeFatalReceiveStats'], [], [None]),
    "ComputePCIeFatalStats": MoMeta("ComputePCIeFatalStats", "computePCIeFatalStats", "pciefat-stats", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['computeBoard'], ['computePCIeFatalStatsHist'], [None]),
    "ComputePCIeFatalStatsHist": MoMeta("ComputePCIeFatalStatsHist", "computePCIeFatalStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], ['computePCIeFatalStats'], [], [None]),
    "ComputePhysicalAssocCtx": MoMeta("ComputePhysicalAssocCtx", "computePhysicalAssocCtx", "pn-assoc-ctx", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['lsServerAssocCtx'], [], ["Get"]),
    "ComputePhysicalExtension": MoMeta("ComputePhysicalExtension", "computePhysicalExtension", "phys-extension", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], ['computeBlade', 'computeRackUnit', 'computeServerUnit'], [], ["get"]),
    "ComputePhysicalOperation": MoMeta("ComputePhysicalOperation", "computePhysicalOperation", "remote-oper", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], ['computeBlade', 'computeRackUnit', 'computeServerUnit'], ['faultInst'], ["Get", "Set"]),
    "ComputePhysicalQual": MoMeta("ComputePhysicalQual", "computePhysicalQual", "physical", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "pn-policy", "read-only"], ['computeQual'], [], ["Add", "Get", "Remove", "Set"]),
    "ComputePool": MoMeta("ComputePool", "computePool", "compute-pool-[name]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "pn-policy"], ['orgOrg'], ['computePooledEnclosureComputeSlot', 'computePooledRackUnit', 'computePooledSlot', 'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "ComputePoolPolicyRef": MoMeta("ComputePoolPolicyRef", "computePoolPolicyRef", "poolref-[id]", VersionMeta.Version111a, "InputOutput", 0x1, [], [""], ['computePoolable'], [], ["Get"]),
    "ComputePoolable": MoMeta("ComputePoolable", "computePoolable", "pool-[id]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['computeBlade', 'computeRackUnit', 'computeServerUnit'], ['computePoolPolicyRef'], ["Get"]),
    "ComputePooledEnclosureComputeSlot": MoMeta("ComputePooledEnclosureComputeSlot", "computePooledEnclosureComputeSlot", "system-[system_id]-server-[chassis_id]-[slot_id]-[server_instance_id]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "pn-policy"], ['computePool'], [], ["Add", "Get", "Remove"]),
    "ComputePooledRackUnit": MoMeta("ComputePooledRackUnit", "computePooledRackUnit", "system-[system_id]-rack-[id]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "pn-policy"], ['computePool'], [], ["Add", "Get", "Remove"]),
    "ComputePooledSlot": MoMeta("ComputePooledSlot", "computePooledSlot", "system-[system_id]-blade-[chassis_id]-[slot_id]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "pn-policy"], ['computePool'], [], ["Add", "Get", "Remove"]),
    "ComputePoolingPolicy": MoMeta("ComputePoolingPolicy", "computePoolingPolicy", "pooling-policy-[name]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "pn-policy"], ['orgOrg'], [], ["Add", "Get", "Remove", "Set"]),
    "ComputePortDiscPolicy": MoMeta("ComputePortDiscPolicy", "computePortDiscPolicy", "port-discovery", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "domain-group-management", "pn-policy", "read-only"], ['orgDomainGroup', 'orgOrg'], [], ["get", "set"]),
    "ComputePowerExtendedPolicy": MoMeta("ComputePowerExtendedPolicy", "computePowerExtendedPolicy", "power-extended-policy", VersionMeta.Version201u, "InputOutput", 0x1, [], ["admin", "domain-group-management", "pn-equipment", "pn-policy"], ['orgDomainGroup'], [], [None]),
    "ComputePowerSavePolicy": MoMeta("ComputePowerSavePolicy", "computePowerSavePolicy", "power-save-policy", VersionMeta.Version201u, "InputOutput", 0x1, [], ["admin", "domain-group-management", "pn-equipment", "pn-policy"], ['orgDomainGroup'], [], [None]),
    "ComputePowerSyncDef": MoMeta("ComputePowerSyncDef", "computePowerSyncDef", "power-sync-def", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config-policy", "ls-server", "ls-server-policy"], ['lsServer'], [], [None]),
    "ComputePowerSyncPolicy": MoMeta("ComputePowerSyncPolicy", "computePowerSyncPolicy", "power-sync-[name]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config-policy", "ls-server", "ls-server-policy"], ['orgOrg'], [], ["add", "get", "remove", "set"]),
    "ComputeProductFamilyQual": MoMeta("ComputeProductFamilyQual", "computeProductFamilyQual", "product-qualifier-[product_family]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "pn-policy", "read-only"], ['computeDomainQual'], [], ["Add", "Get", "Remove"]),
    "ComputeProfile": MoMeta("ComputeProfile", "computeProfile", "profile-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], ['computeResourceAggrEp'], ['computeUser'], [None]),
    "ComputePsuPolicy": MoMeta("ComputePsuPolicy", "computePsuPolicy", "psu-policy", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "domain-group-management", "pn-equipment", "pn-policy"], ['orgDomainGroup'], [], ["Add", "Get", "Remove", "Set"]),
    "ComputeQual": MoMeta("ComputeQual", "computeQual", "blade-qualifier-[name]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['orgOrg'], ['adaptorQual', 'computeDomainQual', 'computePhysicalQual', 'memoryQual', 'powerGroupQual', 'processorQual', 'storageQual'], ["Add", "Get", "Remove", "Set"]),
    "ComputeRackQual": MoMeta("ComputeRackQual", "computeRackQual", "rack-from-[min_id]-to-[max_id]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "pn-policy", "read-only"], ['computeDomainQual'], [], ["Add", "Get", "Remove"]),
    "ComputeRackUnit": MoMeta("ComputeRackUnit", "computeRackUnit", "rack-unit-[id]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], ['computeSystem'], ['adaptorHostIfConfig', 'adaptorUnit', 'biosUnit', 'computeBoard', 'computeBoardController', 'computeExtBoard', 'computeFactoryResetOp', 'computeFactoryResetOperation', 'computePhysicalExtension', 'computePhysicalOperation', 'computePoolable', 'computeRebootLog', 'diagSrvCtrl', 'equipmentBeaconLed', 'equipmentFanModule', 'equipmentHealthLed', 'equipmentIndicatorLed', 'equipmentLocatorLed', 'equipmentPsu', 'firmwareStatus', 'lsIdentityInfo', 'lsbootDef', 'mgmtController', 'mgmtSecurity', 'storageEnclosure', 'storageVirtualDriveContainer', 'sysdebugDiagnosticLog'], ["Get"]),
    "ComputeRackUnitMbTempStats": MoMeta("ComputeRackUnitMbTempStats", "computeRackUnitMbTempStats", "temp-stats", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['computeBoard'], ['computeRackUnitMbTempStatsHist'], [None]),
    "ComputeRackUnitMbTempStatsHist": MoMeta("ComputeRackUnitMbTempStatsHist", "computeRackUnitMbTempStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], ['computeRackUnitMbTempStats'], [], [None]),
    "ComputeRebootLog": MoMeta("ComputeRebootLog", "computeRebootLog", "reboot-log-[id]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], ['computeBlade', 'computeRackUnit', 'computeServerUnit'], [], ["get"]),
    "ComputeRemoteOpStatus": MoMeta("ComputeRemoteOpStatus", "computeRemoteOpStatus", "remote-op-status", VersionMeta.Version121a, "InputOutput", 0x1, [], ["read-only"], ['mgmtBackup'], ['faultInst'], ["Get"]),
    "ComputeRequirement": MoMeta("ComputeRequirement", "computeRequirement", "req-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], ['orgOrg'], ['computeInstance'], ["Get"]),
    "ComputeResourceAggrEp": MoMeta("ComputeResourceAggrEp", "computeResourceAggrEp", "compute", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], ['topRoot'], ['computeFaultUpgradeFlag', 'computeGroupMembership', 'computeProfile', 'computeResourceSetManager', 'computeSystem', 'faultGlobalSeverityHolder', 'faultGlobalTypedHolder'], ["Get", "Set"]),
    "ComputeResourceSet": MoMeta("ComputeResourceSet", "computeResourceSet", "rsrc-set-[id]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], ['computeResourceSetManager'], ['computeResourceSetMember'], [None]),
    "ComputeResourceSetManager": MoMeta("ComputeResourceSetManager", "computeResourceSetManager", "rsrc-set-mgr", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], ['computeResourceAggrEp'], ['computeResourceSet'], [None]),
    "ComputeResourceSetMember": MoMeta("ComputeResourceSetMember", "computeResourceSetMember", "rsrc-set-member-[id]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], ['computeResourceSet'], [], [None]),
    "ComputeScrubPolicy": MoMeta("ComputeScrubPolicy", "computeScrubPolicy", "scrub-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], ['orgOrg'], [], ["Add", "Get", "Remove", "Set"]),
    "ComputeServerDiscPolicy": MoMeta("ComputeServerDiscPolicy", "computeServerDiscPolicy", "server-discovery", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "domain-group-management", "pn-policy"], ['orgDomainGroup', 'orgOrg'], [], ["Get", "Set"]),
    "ComputeServerFeatMask": MoMeta("ComputeServerFeatMask", "computeServerFeatMask", "serv-feat-mask", VersionMeta.Version112a, "InputOutput", 0x1, [], ["read-only"], ['computeSystem', 'extpolDomain', 'lsServer'], [], ["Get"]),
    "ComputeServerMgmtPolicy": MoMeta("ComputeServerMgmtPolicy", "computeServerMgmtPolicy", "server-mgmt-policy", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "domain-group-management", "pn-policy"], ['orgDomainGroup', 'orgOrg'], [], ["Get", "Set"]),
    "ComputeServerUnit": MoMeta("ComputeServerUnit", "computeServerUnit", "server-[server_instance_id]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], ['computeCartridge'], ['adaptorHostIfConfig', 'adaptorUnit', 'biosUnit', 'computeBoard', 'computeBoardController', 'computeExtBoard', 'computeFactoryResetOp', 'computeFactoryResetOperation', 'computePhysicalExtension', 'computePhysicalOperation', 'computePoolable', 'computeRebootLog', 'diagSrvCtrl', 'equipmentBeaconLed', 'equipmentHealthLed', 'equipmentIndicatorLed', 'equipmentLocatorLed', 'firmwareStatus', 'lsIdentityInfo', 'lsbootDef', 'mgmtController', 'mgmtSecurity', 'storageEnclosure', 'storageVirtualDriveContainer', 'sysdebugDiagnosticLog'], ["Get", "Set"]),
    "ComputeSession": MoMeta("ComputeSession", "computeSession", "session-[system_name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin"], ['computeUser'], [], [None]),
    "ComputeSiteQual": MoMeta("ComputeSiteQual", "computeSiteQual", "site-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "pn-policy", "read-only"], ['computeDomainQual', 'computeSystemQual'], [], ["Add", "Get", "Remove", "Set"]),
    "ComputeSlotQual": MoMeta("ComputeSlotQual", "computeSlotQual", "slot-from-[min_id]-to-[max_id]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "pn-policy", "read-only"], ['computeChassisQual'], ['computeInstanceIdQual'], ["Add", "Get", "Remove"]),
    "ComputeStorageFeatMask": MoMeta("ComputeStorageFeatMask", "computeStorageFeatMask", "storage-feat-mask", VersionMeta.Version112a, "InputOutput", 0x1, [], ["read-only"], ['computeSystem', 'extpolDomain', 'lsServer'], [], ["Get"]),
    "ComputeSystem": MoMeta("ComputeSystem", "computeSystem", "sys-[id]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], ['computeResourceAggrEp'], ['commSvcEp', 'computeChassisConnPolicy', 'computeChassisFeatMask', 'computeEnvFeatMask', 'computeFabricEthMonSrcEpCont', 'computeFabricFcMonSrcEpCont', 'computeInstanceMapping', 'computeNetworkFeatMask', 'computeRackUnit', 'computeServerFeatMask', 'computeStorageFeatMask', 'computeSystemFsm', 'computeSystemFsmTask', 'computeTemplateMapping', 'computeUserEp', 'domainChassisFeature', 'domainEnvironmentFeature', 'domainNetworkFeature', 'domainServerFeature', 'domainStorageFeature', 'equipmentChassis', 'equipmentFex', 'equipmentInstanceMapping', 'equipmentTemplateMapping', 'eventInst', 'fabricEp', 'faultDomainEp', 'faultInst', 'faultLocalTypedHolder', 'firmwareCatalogPack', 'firmwareSystem', 'firmwareUpgradeInfo', 'fsmStatus', 'mgmtBackup', 'mgmtBackupOperation', 'mgmtController', 'mgmtEntity', 'networkElement', 'policyControlEp', 'storageCloud', 'sysdebugTechSupFileRepository'], ["Get", "Set"]),
    "ComputeSystemAddrQual": MoMeta("ComputeSystemAddrQual", "computeSystemAddrQual", "ip-from-[min_addr]-to-[max_addr]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "pn-policy", "read-only"], ['computeDomainQual', 'computeSystemQual'], [], ["Add", "Get", "Remove"]),
    "ComputeSystemFsm": MoMeta("ComputeSystemFsm", "computeSystemFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['computeSystem'], ['computeSystemFsmStage'], [None]),
    "ComputeSystemFsmStage": MoMeta("ComputeSystemFsmStage", "computeSystemFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['computeSystemFsm'], [], [None]),
    "ComputeSystemFsmTask": MoMeta("ComputeSystemFsmTask", "computeSystemFsmTask", "task-[item]", VersionMeta.Version111a, "OutputOnly", 0x1, [], [""], ['computeSystem'], [], [None]),
    "ComputeSystemQual": MoMeta("ComputeSystemQual", "computeSystemQual", "system-qualifier-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], [""], ['orgOrg'], ['computeOwnerQual', 'computeSiteQual', 'computeSystemAddrQual'], ["Add", "Get", "Remove", "Set"]),
    "ComputeTemplate": MoMeta("ComputeTemplate", "computeTemplate", "templ-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], ['orgOrg'], ['computeLocalTemplDef', 'lsServer'], ["Get"]),
    "ComputeTemplateMapping": MoMeta("ComputeTemplateMapping", "computeTemplateMapping", "templmap-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], ['computeSystem'], [], [None]),
    "ComputeUser": MoMeta("ComputeUser", "computeUser", "user-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin"], ['computeProfile', 'computeUserEp'], ['computeSession'], [None]),
    "ComputeUserEp": MoMeta("ComputeUserEp", "computeUserEp", "user", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin"], ['computeSystem'], ['computeUser'], [None]),
    "ConfigAckItem": MoMeta("ConfigAckItem", "configAckItem", "ack-item", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "ConfigAdaptorItem": MoMeta("ConfigAdaptorItem", "configAdaptorItem", "adaptor-item", VersionMeta.Version141a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "ConfigAppImpactResponse": MoMeta("ConfigAppImpactResponse", "configAppImpactResponse", "app-id-[app_connector_id]src-id-[source_connector_id]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['configImpactAnalyzer'], ['configUCImpact'], [None]),
    "ConfigBackup": MoMeta("ConfigBackup", "configBackup", "type-[backup_type]-ts-[creation_ts]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], ['configConsumerCatalogue'], ['configBackupFsm', 'configBackupFsmTask', 'eventInst', 'faultInst'], ["Get", "Set"]),
    "ConfigBackupFsm": MoMeta("ConfigBackupFsm", "configBackupFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['configBackup'], ['configBackupFsmStage'], [None]),
    "ConfigBackupFsmStage": MoMeta("ConfigBackupFsmStage", "configBackupFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['configBackupFsm'], [], [None]),
    "ConfigBackupFsmTask": MoMeta("ConfigBackupFsmTask", "configBackupFsmTask", "task-[item]", VersionMeta.Version101a, "OutputOnly", 0x1, [], [""], ['configBackup'], [], ["Get"]),
    "ConfigCartridgeFilter": MoMeta("ConfigCartridgeFilter", "configCartridgeFilter", "cartridge-filter", VersionMeta.Version141a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "ConfigCartridgeItem": MoMeta("ConfigCartridgeItem", "configCartridgeItem", "cartridge-item", VersionMeta.Version141a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "ConfigCatalogue": MoMeta("ConfigCatalogue", "configCatalogue", "config-catalogue", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], ['topSystem'], ['configConsumerCatalogue'], ["Get"]),
    "ConfigChassisFilter": MoMeta("ConfigChassisFilter", "configChassisFilter", "chassic-filter", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "ConfigChassisItem": MoMeta("ConfigChassisItem", "configChassisItem", "chassis-item", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "ConfigComponentsFilter": MoMeta("ConfigComponentsFilter", "configComponentsFilter", "components-filter", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], [], [], [None]),
    "ConfigConsumerCatalogue": MoMeta("ConfigConsumerCatalogue", "configConsumerCatalogue", "consumer-catalogue-[internal_name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], ['configCatalogue', 'consumerInst'], ['configBackup', 'configConsumerCatalogueFsm', 'configConsumerCatalogueFsmTask', 'eventInst', 'faultInst'], ["Get", "Set"]),
    "ConfigConsumerCatalogueFsm": MoMeta("ConfigConsumerCatalogueFsm", "configConsumerCatalogueFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['configConsumerCatalogue'], ['configConsumerCatalogueFsmStage'], [None]),
    "ConfigConsumerCatalogueFsmStage": MoMeta("ConfigConsumerCatalogueFsmStage", "configConsumerCatalogueFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['configConsumerCatalogueFsm'], [], [None]),
    "ConfigConsumerCatalogueFsmTask": MoMeta("ConfigConsumerCatalogueFsmTask", "configConsumerCatalogueFsmTask", "task-[item]", VersionMeta.Version101a, "OutputOnly", 0x1, [], [""], ['configConsumerCatalogue'], [], ["Get"]),
    "ConfigControllerItem": MoMeta("ConfigControllerItem", "configControllerItem", "controller-item", VersionMeta.Version141a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "ConfigCpuInfo": MoMeta("ConfigCpuInfo", "configCpuInfo", "cpu-info-[arch]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], ['configServerItem'], [], [None]),
    "ConfigCpuItem": MoMeta("ConfigCpuItem", "configCpuItem", "cpu-item", VersionMeta.Version141a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "ConfigCryptoCardItem": MoMeta("ConfigCryptoCardItem", "configCryptoCardItem", "crypto-card-item", VersionMeta.Version141a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "ConfigDbConfig": MoMeta("ConfigDbConfig", "configDbConfig", "dbconfig", VersionMeta.Version111b, "InputOutput", 0x1, [], ["admin"], ['topSystem'], ['faultInst'], ["Get"]),
    "ConfigDomainFilter": MoMeta("ConfigDomainFilter", "configDomainFilter", "domain-filter", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "ConfigDomainItem": MoMeta("ConfigDomainItem", "configDomainItem", "domain-item", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "ConfigFabricInterconnectFilter": MoMeta("ConfigFabricInterconnectFilter", "configFabricInterconnectFilter", "fabric-interconnect-filter", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "ConfigFabricInterconnectItem": MoMeta("ConfigFabricInterconnectItem", "configFabricInterconnectItem", "fabric-interconnect-item", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "ConfigFanItem": MoMeta("ConfigFanItem", "configFanItem", "fan-item", VersionMeta.Version141a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "ConfigFexFilter": MoMeta("ConfigFexFilter", "configFexFilter", "fex-filter", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "ConfigFexItem": MoMeta("ConfigFexItem", "configFexItem", "fex-item", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "ConfigFilterGroup": MoMeta("ConfigFilterGroup", "configFilterGroup", "filter-group-[name]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin"], [], ['configFilterItem'], [None]),
    "ConfigFilterItem": MoMeta("ConfigFilterItem", "configFilterItem", "filter-item-[name]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin"], ['configFilterGroup'], [], [None]),
    "ConfigFsm": MoMeta("ConfigFsm", "configFsm", "fsm", VersionMeta.Version141a, "InputOutput", 0x1, [], ["read-only"], [], ['configFsmStage'], [None]),
    "ConfigFsmStage": MoMeta("ConfigFsmStage", "configFsmStage", "stage-[name]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["read-only"], ['configFsm'], [], [None]),
    "ConfigGraphicsCardItem": MoMeta("ConfigGraphicsCardItem", "configGraphicsCardItem", "graphics-card-item", VersionMeta.Version141a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "ConfigIOMItem": MoMeta("ConfigIOMItem", "configIOMItem", "iom-item", VersionMeta.Version141a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "ConfigImpact": MoMeta("ConfigImpact", "configImpact", "impact-[name]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['configManagedEpImpactResponse'], [], [None]),
    "ConfigImpactAnalyzer": MoMeta("ConfigImpactAnalyzer", "configImpactAnalyzer", "impact-analyzer-[impact_analyzer_id]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['configImpactAnalyzerEp'], ['configAppImpactResponse', 'configInputConfigSet', 'configManagedEpImpactResponse'], [None]),
    "ConfigImpactAnalyzerEp": MoMeta("ConfigImpactAnalyzerEp", "configImpactAnalyzerEp", "impactanalyzer-ep", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin"], ['topRoot'], ['configImpactAnalyzer'], [None]),
    "ConfigInputConfig": MoMeta("ConfigInputConfig", "configInputConfig", "name-[input_name]status-[input_config_status]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['configInputConfigSet'], [], [None]),
    "ConfigInputConfigSet": MoMeta("ConfigInputConfigSet", "configInputConfigSet", "InputConfigSet", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['configImpactAnalyzer'], ['configInputConfig'], [None]),
    "ConfigLocalDiskItem": MoMeta("ConfigLocalDiskItem", "configLocalDiskItem", "local-disk-item", VersionMeta.Version141a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "ConfigLunItem": MoMeta("ConfigLunItem", "configLunItem", "lun-item", VersionMeta.Version141a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "ConfigManagedEpImpactResponse": MoMeta("ConfigManagedEpImpactResponse", "configManagedEpImpactResponse", "ManagedEpapp-id-[app_connector_id]src-id-[source_connector_id]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['configImpactAnalyzer'], ['configImpact'], [None]),
    "ConfigMemoryItem": MoMeta("ConfigMemoryItem", "configMemoryItem", "memory-item", VersionMeta.Version141a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "ConfigMotherboardItem": MoMeta("ConfigMotherboardItem", "configMotherboardItem", "motherboard-item", VersionMeta.Version141a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "ConfigNetRefItem": MoMeta("ConfigNetRefItem", "configNetRefItem", "", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "ConfigOrgItem": MoMeta("ConfigOrgItem", "configOrgItem", "org-item-[context]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["read-only"], ['fabricVlanPermitItem'], [], [None]),
    "ConfigPSUItem": MoMeta("ConfigPSUItem", "configPSUItem", "psu-item", VersionMeta.Version141a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "ConfigPasswordEncryption": MoMeta("ConfigPasswordEncryption", "configPasswordEncryption", "pwd-encrpt", VersionMeta.Version201v, "InputOutput", 0x1, [], ["admin"], ['topSystem'], ['configPasswordEncryptionFsm', 'configPasswordEncryptionFsmTask', 'eventInst', 'faultInst'], [None]),
    "ConfigPasswordEncryptionFsm": MoMeta("ConfigPasswordEncryptionFsm", "configPasswordEncryptionFsm", "fsm", VersionMeta.Version201v, "OutputOnly", 0x1, [], [""], ['configPasswordEncryption'], ['configPasswordEncryptionFsmStage'], [None]),
    "ConfigPasswordEncryptionFsmStage": MoMeta("ConfigPasswordEncryptionFsmStage", "configPasswordEncryptionFsmStage", "stage-[name]", VersionMeta.Version201v, "OutputOnly", 0x1, [], [""], ['configPasswordEncryptionFsm'], [], [None]),
    "ConfigPasswordEncryptionFsmTask": MoMeta("ConfigPasswordEncryptionFsmTask", "configPasswordEncryptionFsmTask", "task-[item]", VersionMeta.Version201v, "OutputOnly", 0x1, [], [""], ['configPasswordEncryption'], [], [None]),
    "ConfigPcieNodeItem": MoMeta("ConfigPcieNodeItem", "configPcieNodeItem", "pcie-node-item", VersionMeta.Version201v, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "ConfigPolicyUsageItem": MoMeta("ConfigPolicyUsageItem", "configPolicyUsageItem", "policy-usage-item", VersionMeta.Version151a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "ConfigPortItem": MoMeta("ConfigPortItem", "configPortItem", "port-item", VersionMeta.Version141a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "ConfigSearchOptions": MoMeta("ConfigSearchOptions", "configSearchOptions", "", VersionMeta.Version112a, "InputOutput", 0x1, [], ["read-only"], [], [], ["Get"]),
    "ConfigSearchResult": MoMeta("ConfigSearchResult", "configSearchResult", "policy-[converted_dn]-domain-[domain_id]", VersionMeta.Version112a, "InputOutput", 0x1, [], ["read-only"], [], [], ["Get"]),
    "ConfigServerFilter": MoMeta("ConfigServerFilter", "configServerFilter", "server-filter", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "ConfigServerItem": MoMeta("ConfigServerItem", "configServerItem", "server-item", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], [], ['configCpuInfo'], [None]),
    "ConfigServiceProfileFilter": MoMeta("ConfigServiceProfileFilter", "configServiceProfileFilter", "service-profile-filter", VersionMeta.Version141a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "ConfigSorter": MoMeta("ConfigSorter", "configSorter", "class-[sort_class]prop-[sort_prop]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "ConfigSpotLightItem": MoMeta("ConfigSpotLightItem", "configSpotLightItem", "spotlight-[composite_id]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin"], [], [], [None]),
    "ConfigStorageArrayProfileFilter": MoMeta("ConfigStorageArrayProfileFilter", "configStorageArrayProfileFilter", "storage-array-profile-filter", VersionMeta.Version141a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "ConfigStorageBladeFilter": MoMeta("ConfigStorageBladeFilter", "configStorageBladeFilter", "storage-blade-filter", VersionMeta.Version141a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "ConfigStorageItem": MoMeta("ConfigStorageItem", "configStorageItem", "storage-item", VersionMeta.Version141a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "ConfigUCImpact": MoMeta("ConfigUCImpact", "configUCImpact", "ls-[name]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['configAppImpactResponse'], [], [None]),
    "ConfigXFMItem": MoMeta("ConfigXFMItem", "configXFMItem", "xfm-item", VersionMeta.Version201t, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "ConsumerInst": MoMeta("ConsumerInst", "consumerInst", "inst-[connector_id]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], ['consumerUniverse'], ['configConsumerCatalogue', 'consumerInstFsm', 'consumerInstFsmTask', 'eventInst', 'faultInst', 'mgmtImporter', 'nfsMountDef'], [None]),
    "ConsumerInstFsm": MoMeta("ConsumerInstFsm", "consumerInstFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['consumerInst'], ['consumerInstFsmStage'], [None]),
    "ConsumerInstFsmStage": MoMeta("ConsumerInstFsmStage", "consumerInstFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['consumerInstFsm'], [], [None]),
    "ConsumerInstFsmTask": MoMeta("ConsumerInstFsmTask", "consumerInstFsmTask", "task-[item]", VersionMeta.Version101a, "OutputOnly", 0x1, [], [""], ['consumerInst'], [], [None]),
    "ConsumerUniverse": MoMeta("ConsumerUniverse", "consumerUniverse", "universe", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], ['topRoot'], ['consumerInst'], [None]),
    "ControllerEp": MoMeta("ControllerEp", "controllerEp", "controller", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['topRoot'], ['controllerEpFsm', 'controllerEpFsmTask', 'eventInst', 'faultInst'], [None]),
    "ControllerEpFsm": MoMeta("ControllerEpFsm", "controllerEpFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['controllerEp'], ['controllerEpFsmStage'], [None]),
    "ControllerEpFsmStage": MoMeta("ControllerEpFsmStage", "controllerEpFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['controllerEpFsm'], [], [None]),
    "ControllerEpFsmTask": MoMeta("ControllerEpFsmTask", "controllerEpFsmTask", "task-[item]", VersionMeta.Version111a, "OutputOnly", 0x1, [], [""], ['controllerEp'], [], [None]),
    "CpmaintAck": MoMeta("CpmaintAck", "cpmaintAck", "ack", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], ['equipmentChassisProfile', 'equipmentInstance'], ['faultInst'], ["Get", "Set"]),
    "CpmaintMaintPolicy": MoMeta("CpmaintMaintPolicy", "cpmaintMaintPolicy", "chassis-profile-maint-[name]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["read-only"], ['orgOrg'], [], ["Add", "Get", "Remove", "Set"]),
    "DcxVIf": MoMeta("DcxVIf", "dcxVIf", "vif-[id]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], ['adaptorExtEthIf', 'adaptorHostEthIf', 'adaptorHostFcIf'], [], ["get"]),
    "DcxVc": MoMeta("DcxVc", "dcxVc", "vc-[id]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [], ['fabricNetGroupRef', 'fabricSanGroupRef'], ["Get"]),
    "DiagLogEp": MoMeta("DiagLogEp", "diagLogEp", "logep-[switch_id]", VersionMeta.Version201b, "InputOutput", 0x1, [], [""], ['diagRslt'], [], ["get"]),
    "DiagMemoryTest": MoMeta("DiagMemoryTest", "diagMemoryTest", "test-[order]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "pn-policy"], ['diagRunPolicy'], [], ["get"]),
    "DiagRslt": MoMeta("DiagRslt", "diagRslt", "rslt-[id]", VersionMeta.Version201b, "InputOutput", 0x1, [], [""], ['diagSrvCtrl'], ['diagLogEp'], ["get"]),
    "DiagRunPolicy": MoMeta("DiagRunPolicy", "diagRunPolicy", "diag-policy-[name]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "pn-policy"], ['diagSrvCtrl', 'orgDomainGroup', 'orgOrg'], ['diagMemoryTest'], ["get", "set"]),
    "DiagSrvCapProvider": MoMeta("DiagSrvCapProvider", "diagSrvCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin"], ['capabilityCatalogue'], ['equipmentFruVariant', 'equipmentManufacturingDef', 'equipmentPicture'], ["get"]),
    "DiagSrvCtrl": MoMeta("DiagSrvCtrl", "diagSrvCtrl", "diag", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance"], ['computeBlade', 'computeRackUnit', 'computeServerUnit'], ['diagRslt', 'diagRunPolicy', 'diagSrvCtrlOperation', 'etherServerIntFIo'], ["get"]),
    "DiagSrvCtrlOperation": MoMeta("DiagSrvCtrlOperation", "diagSrvCtrlOperation", "remote-oper", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance"], ['diagSrvCtrl'], ['diagSrvCtrlOperationFsm', 'diagSrvCtrlOperationFsmTask', 'eventInst', 'faultInst'], ["get", "set"]),
    "DiagSrvCtrlOperationFsm": MoMeta("DiagSrvCtrlOperationFsm", "diagSrvCtrlOperationFsm", "fsm", VersionMeta.Version201b, "OutputOnly", 0x1, [], [""], ['diagSrvCtrlOperation'], ['diagSrvCtrlOperationFsmStage'], [None]),
    "DiagSrvCtrlOperationFsmStage": MoMeta("DiagSrvCtrlOperationFsmStage", "diagSrvCtrlOperationFsmStage", "stage-[name]", VersionMeta.Version201b, "OutputOnly", 0x1, [], [""], ['diagSrvCtrlOperationFsm'], [], [None]),
    "DiagSrvCtrlOperationFsmTask": MoMeta("DiagSrvCtrlOperationFsmTask", "diagSrvCtrlOperationFsmTask", "task-[item]", VersionMeta.Version201b, "OutputOnly", 0x1, [], [""], ['diagSrvCtrlOperation'], [], [None]),
    "DomainChassisFeature": MoMeta("DomainChassisFeature", "domainChassisFeature", "chassis-feature-[name]", VersionMeta.Version201b, "InputOutput", 0x1, [], [""], ['computeSystem', 'domainFeatureCatalog', 'extpolDomain'], ['domainChassisParam', 'domainEnvironmentParam', 'domainNetworkParam', 'domainServerParam', 'domainStorageParam'], ["get"]),
    "DomainChassisParam": MoMeta("DomainChassisParam", "domainChassisParam", "chassis-param-[name]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin"], ['domainChassisFeature', 'domainEnvironmentFeature', 'domainFeatureCatalog', 'domainNetworkFeature', 'domainServerFeature', 'domainStorageFeature', 'featureChassisDef', 'featureEnvDef', 'featureNetworkDef', 'featureServerDef', 'featureStorageDef'], [], ["get"]),
    "DomainChassisProfileItem": MoMeta("DomainChassisProfileItem", "domainChassisProfileItem", "CP[chassis_profile_dn]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-server", "pn-equipment", "pn-maintenance", "pn-policy"], [], [], [None]),
    "DomainEnvironmentFeature": MoMeta("DomainEnvironmentFeature", "domainEnvironmentFeature", "env-feature-[name]", VersionMeta.Version112a, "InputOutput", 0x1, [], [""], ['computeSystem', 'domainFeatureCatalog', 'extpolDomain'], ['domainChassisParam', 'domainEnvironmentParam', 'domainNetworkParam', 'domainServerParam', 'domainStorageParam'], ["Get"]),
    "DomainEnvironmentParam": MoMeta("DomainEnvironmentParam", "domainEnvironmentParam", "env-param-[name]", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin"], ['domainChassisFeature', 'domainEnvironmentFeature', 'domainFeatureCatalog', 'domainNetworkFeature', 'domainServerFeature', 'domainStorageFeature', 'featureChassisDef', 'featureEnvDef', 'featureNetworkDef', 'featureServerDef', 'featureStorageDef'], [], ["Get"]),
    "DomainEp": MoMeta("DomainEp", "domainEp", "catalog", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin"], ['topRoot'], ['domainFeatureCatalog'], ["Get"]),
    "DomainFamilyCapProvider": MoMeta("DomainFamilyCapProvider", "domainFamilyCapProvider", "model-[model]", VersionMeta.Version121a, "InputOutput", 0x1, [], ["read-only"], ['capabilityCatalogue'], [], ["Get"]),
    "DomainFeatureCatalog": MoMeta("DomainFeatureCatalog", "domainFeatureCatalog", "catalog-[version]", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin"], ['domainEp'], ['domainChassisFeature', 'domainChassisParam', 'domainEnvironmentFeature', 'domainEnvironmentParam', 'domainNetworkFeature', 'domainNetworkParam', 'domainServerFeature', 'domainServerParam', 'domainStorageFeature', 'domainStorageParam'], ["Get"]),
    "DomainNetworkFeature": MoMeta("DomainNetworkFeature", "domainNetworkFeature", "network-feature-[name]", VersionMeta.Version112a, "InputOutput", 0x1, [], [""], ['computeSystem', 'domainFeatureCatalog', 'extpolDomain'], ['domainChassisParam', 'domainEnvironmentParam', 'domainNetworkParam', 'domainServerParam', 'domainStorageParam'], ["Get"]),
    "DomainNetworkParam": MoMeta("DomainNetworkParam", "domainNetworkParam", "network-param-[name]", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin"], ['domainChassisFeature', 'domainEnvironmentFeature', 'domainFeatureCatalog', 'domainNetworkFeature', 'domainServerFeature', 'domainStorageFeature', 'featureChassisDef', 'featureEnvDef', 'featureNetworkDef', 'featureServerDef', 'featureStorageDef'], [], ["Get"]),
    "DomainProfile": MoMeta("DomainProfile", "domainProfile", "domain-profile-[name]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "domain-group-management"], ['fabricSystem', 'orgDomainGroup'], ['domainProfileFsm', 'domainProfileFsmTask', 'eventInst', 'faultInst', 'messageEp'], ["get", "set"]),
    "DomainProfileFsm": MoMeta("DomainProfileFsm", "domainProfileFsm", "fsm", VersionMeta.Version201b, "OutputOnly", 0x1, [], [""], ['domainProfile'], ['domainProfileFsmStage'], [None]),
    "DomainProfileFsmStage": MoMeta("DomainProfileFsmStage", "domainProfileFsmStage", "stage-[name]", VersionMeta.Version201b, "OutputOnly", 0x1, [], [""], ['domainProfileFsm'], [], [None]),
    "DomainProfileFsmTask": MoMeta("DomainProfileFsmTask", "domainProfileFsmTask", "task-[item]", VersionMeta.Version201b, "OutputOnly", 0x1, [], [""], ['domainProfile'], [], [None]),
    "DomainServerFeature": MoMeta("DomainServerFeature", "domainServerFeature", "server-feature-[name]", VersionMeta.Version112a, "InputOutput", 0x1, [], [""], ['computeSystem', 'domainFeatureCatalog', 'extpolDomain'], ['domainChassisParam', 'domainEnvironmentParam', 'domainNetworkParam', 'domainServerParam', 'domainStorageParam'], ["Get"]),
    "DomainServerParam": MoMeta("DomainServerParam", "domainServerParam", "server-param-[name]", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin"], ['domainChassisFeature', 'domainEnvironmentFeature', 'domainFeatureCatalog', 'domainNetworkFeature', 'domainServerFeature', 'domainStorageFeature', 'featureChassisDef', 'featureEnvDef', 'featureNetworkDef', 'featureServerDef', 'featureStorageDef'], [], ["Get"]),
    "DomainServiceProfileItem": MoMeta("DomainServiceProfileItem", "domainServiceProfileItem", "SP[service_profile_dn]", VersionMeta.Version121a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-server", "pn-equipment", "pn-maintenance", "pn-policy"], [], [], ["Get"]),
    "DomainStorageFeature": MoMeta("DomainStorageFeature", "domainStorageFeature", "storage-feature-[name]", VersionMeta.Version112a, "InputOutput", 0x1, [], [""], ['computeSystem', 'domainFeatureCatalog', 'extpolDomain'], ['domainChassisParam', 'domainEnvironmentParam', 'domainNetworkParam', 'domainServerParam', 'domainStorageParam'], ["Get"]),
    "DomainStorageParam": MoMeta("DomainStorageParam", "domainStorageParam", "storage-param-[name]", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin"], ['domainChassisFeature', 'domainEnvironmentFeature', 'domainFeatureCatalog', 'domainNetworkFeature', 'domainServerFeature', 'domainStorageFeature', 'featureChassisDef', 'featureEnvDef', 'featureNetworkDef', 'featureServerDef', 'featureStorageDef'], [], ["Get"]),
    "DpsecMac": MoMeta("DpsecMac", "dpsecMac", "mac-sec", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy"], ['nwctrlDefinition'], [], ["Add", "Get", "Remove", "Set"]),
    "DupeChangeTracker": MoMeta("DupeChangeTracker", "dupeChangeTracker", "changetracker-[id]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], ['dupeChangeTrackerEp'], [], [None]),
    "DupeChangeTrackerEp": MoMeta("DupeChangeTrackerEp", "dupeChangeTrackerEp", "changetracker-ep", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], ['dupeEp'], ['dupeChangeTracker', 'dupeChangeTrackerEpFsm', 'dupeChangeTrackerEpFsmTask', 'eventInst', 'faultInst'], [None]),
    "DupeChangeTrackerEpFsm": MoMeta("DupeChangeTrackerEpFsm", "dupeChangeTrackerEpFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['dupeChangeTrackerEp'], ['dupeChangeTrackerEpFsmStage'], [None]),
    "DupeChangeTrackerEpFsmStage": MoMeta("DupeChangeTrackerEpFsmStage", "dupeChangeTrackerEpFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['dupeChangeTrackerEpFsm'], [], [None]),
    "DupeChangeTrackerEpFsmTask": MoMeta("DupeChangeTrackerEpFsmTask", "dupeChangeTrackerEpFsmTask", "task-[item]", VersionMeta.Version131a, "OutputOnly", 0x1, [], [""], ['dupeChangeTrackerEp'], [], [None]),
    "DupeEp": MoMeta("DupeEp", "dupeEp", "dup-ep", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], ['extpolClient', 'extpolController', 'extpolProvider', 'extpolRegistry'], ['dupeChangeTrackerEp', 'dupeScopeEp'], [None]),
    "DupeExtRequestor": MoMeta("DupeExtRequestor", "dupeExtRequestor", "ext-requestor", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin"], ['dupeScope'], [], [None]),
    "DupeIntRequestor": MoMeta("DupeIntRequestor", "dupeIntRequestor", "int-requestor-[name]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], ['dupeScope'], [], [None]),
    "DupeScope": MoMeta("DupeScope", "dupeScope", "scope-[id]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin"], ['dupeScopeEp'], ['dupeExtRequestor', 'dupeIntRequestor', 'dupeScopeResult'], [None]),
    "DupeScopeEp": MoMeta("DupeScopeEp", "dupeScopeEp", "scope-ep", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], ['dupeEp'], ['dupeScope'], [None]),
    "DupeScopeResult": MoMeta("DupeScopeResult", "dupeScopeResult", "result", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], ['dupeScope'], [], [None]),
    "EpqosDefinition": MoMeta("EpqosDefinition", "epqosDefinition", "ep-qos-[name]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy", "ls-qos-policy", "read-only"], ['orgOrg'], ['epqosEgress'], ["Add", "Get", "Remove", "Set"]),
    "EpqosEgress": MoMeta("EpqosEgress", "epqosEgress", "egress", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy", "ls-qos-policy", "read-only"], ['epqosDefinition'], [], ["Add", "Get", "Remove", "Set"]),
    "EquipmentAdvancedBootOrder": MoMeta("EquipmentAdvancedBootOrder", "equipmentAdvancedBootOrder", "advbootordsupp-[is_supported]", VersionMeta.Version121a, "InputOutput", 0x1, [], [""], ['equipmentBladeCapProvider', 'equipmentRackUnitCapProvider', 'equipmentServerUnitCapProvider'], [], ["Get"]),
    "EquipmentBeaconLed": MoMeta("EquipmentBeaconLed", "equipmentBeaconLed", "beacon", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], ['computeBlade', 'computeRackUnit', 'computeServerUnit', 'equipmentChassis', 'equipmentFanModule', 'equipmentFex', 'equipmentIOCard', 'equipmentPsu'], [], ["Get"]),
    "EquipmentBinding": MoMeta("EquipmentBinding", "equipmentBinding", "chassis", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy", "read-only"], ['equipmentChassisProfile'], [], ["Add", "Get", "Remove", "Set"]),
    "EquipmentBladeCapProvider": MoMeta("EquipmentBladeCapProvider", "equipmentBladeCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], ['capabilityCatalogue'], ['equipmentAdvancedBootOrder', 'equipmentCimcVmedia', 'equipmentDriveSecCap', 'equipmentFruVariant', 'equipmentManufacturingDef', 'equipmentPicture', 'equipmentSecureBoot', 'equipmentServerFeatureCap', 'equipmentStorageProcessorCap'], ["Get"]),
    "EquipmentBreakoutCap": MoMeta("EquipmentBreakoutCap", "equipmentBreakoutCap", "breakout-cap", VersionMeta.Version141a, "InputOutput", 0x1, [], [""], ['equipmentSwitchCapProvider', 'equipmentSwitchIOCardCapProvider'], [], ["Get"]),
    "EquipmentCPMeta": MoMeta("EquipmentCPMeta", "equipmentCPMeta", "cpmeta", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], ['equipmentChassisProfile'], ['messageEp'], ["Get"]),
    "EquipmentChassis": MoMeta("EquipmentChassis", "equipmentChassis", "chassis-[id]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], ['computeSystem'], ['computeBlade', 'computeBoardController', 'computeCartridge', 'computeChassisFeatMask', 'equipmentBeaconLed', 'equipmentChassisOperation', 'equipmentChassisStats', 'equipmentComputeConn', 'equipmentCrossFabricModule', 'equipmentFanModule', 'equipmentHealthLed', 'equipmentIOCard', 'equipmentIndicatorLed', 'equipmentLocatorLed', 'equipmentPcieNode', 'equipmentPsu', 'equipmentSharedIOModule', 'equipmentSwitchIOCard', 'equipmentSystemIOController', 'faultInst', 'mgmtController', 'sesEnclosure', 'storageBlade', 'storageController', 'storageEnclosure', 'storageSasExpander', 'storageVirtualDriveContainer'], ["Get"]),
    "EquipmentChassisAssocCtx": MoMeta("EquipmentChassisAssocCtx", "equipmentChassisAssocCtx", "cp-assoc-ctx", VersionMeta.Version151a, "InputOutput", 0x1, [], ["read-only"], ['equipmentChassisProfileAssocCtx'], [], ["Get"]),
    "EquipmentChassisCapProvider": MoMeta("EquipmentChassisCapProvider", "equipmentChassisCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], ['capabilityCatalogue'], ['equipmentFruVariant', 'equipmentManufacturingDef', 'equipmentPicture'], ["Get"]),
    "EquipmentChassisIssues": MoMeta("EquipmentChassisIssues", "equipmentChassisIssues", "config-issue", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], ['equipmentChassisProfile', 'equipmentInstance'], [], ["Get"]),
    "EquipmentChassisOperation": MoMeta("EquipmentChassisOperation", "equipmentChassisOperation", "remote-oper", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], ['equipmentChassis'], ['faultInst'], ["Get", "Set"]),
    "EquipmentChassisProfile": MoMeta("EquipmentChassisProfile", "equipmentChassisProfile", "cp-[name]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], ['equipmentTemplate', 'equipmentTier', 'orgOrg'], ['computeChassisFeatMask', 'cpmaintAck', 'equipmentBinding', 'equipmentCPMeta', 'equipmentChassisIssues', 'equipmentChassisProfileAssocCtx', 'equipmentChassisProfileFsm', 'equipmentChassisProfileFsmTask', 'equipmentRequirement', 'eventInst', 'faultInst', 'lstorageDiskZoningConfigDef'], ["Add", "Get", "Remove", "Set"]),
    "EquipmentChassisProfileAssocCtx": MoMeta("EquipmentChassisProfileAssocCtx", "equipmentChassisProfileAssocCtx", "cp-assoc-ctx", VersionMeta.Version151a, "InputOutput", 0x1, [], ["read-only"], ['equipmentChassisProfile'], ['equipmentChassisAssocCtx'], ["Get"]),
    "EquipmentChassisProfileFsm": MoMeta("EquipmentChassisProfileFsm", "equipmentChassisProfileFsm", "fsm", VersionMeta.Version151a, "OutputOnly", 0x1, [], [""], ['equipmentChassisProfile'], ['equipmentChassisProfileFsmStage'], [None]),
    "EquipmentChassisProfileFsmStage": MoMeta("EquipmentChassisProfileFsmStage", "equipmentChassisProfileFsmStage", "stage-[name]", VersionMeta.Version151a, "OutputOnly", 0x1, [], [""], ['equipmentChassisProfileFsm'], [], [None]),
    "EquipmentChassisProfileFsmTask": MoMeta("EquipmentChassisProfileFsmTask", "equipmentChassisProfileFsmTask", "task-[item]", VersionMeta.Version151a, "OutputOnly", 0x1, [], [""], ['equipmentChassisProfile'], [], [None]),
    "EquipmentChassisQual": MoMeta("EquipmentChassisQual", "equipmentChassisQual", "chassis-from-[min_id]-to-[max_id]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "pn-policy"], ['equipmentQual'], [], [None]),
    "EquipmentChassisRequirement": MoMeta("EquipmentChassisRequirement", "equipmentChassisRequirement", "chassis-req-[name]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["read-only"], ['orgOrg'], ['equipmentInstance'], ["Get"]),
    "EquipmentChassisStats": MoMeta("EquipmentChassisStats", "equipmentChassisStats", "stats", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['equipmentChassis'], ['equipmentChassisStatsHist'], [None]),
    "EquipmentChassisStatsHist": MoMeta("EquipmentChassisStatsHist", "equipmentChassisStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], ['equipmentChassisStats'], [], [None]),
    "EquipmentCimcVmedia": MoMeta("EquipmentCimcVmedia", "equipmentCimcVmedia", "cimcvmediasupp-[is_supported]", VersionMeta.Version121a, "InputOutput", 0x1, [], [""], ['equipmentBladeCapProvider', 'equipmentRackUnitCapProvider', 'equipmentServerUnitCapProvider'], [], ["Get"]),
    "EquipmentComputeConn": MoMeta("EquipmentComputeConn", "equipmentComputeConn", "compute-conn", VersionMeta.Version201b, "InputOutput", 0x1, [], [""], ['equipmentChassis'], [], ["get"]),
    "EquipmentComputeConnPolicy": MoMeta("EquipmentComputeConnPolicy", "equipmentComputeConnPolicy", "compute-conn-policy-[name]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], ['orgOrg'], [], ["add", "get", "remove", "set"]),
    "EquipmentCrossFabricModule": MoMeta("EquipmentCrossFabricModule", "equipmentCrossFabricModule", "xfm-slot-[id]", VersionMeta.Version201t, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], ['equipmentChassis'], ['equipmentFanModule'], [None]),
    "EquipmentCrossFabricModuleCapProvider": MoMeta("EquipmentCrossFabricModuleCapProvider", "equipmentCrossFabricModuleCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version201t, "InputOutput", 0x1, [], ["admin"], ['capabilityCatalogue'], ['equipmentFanModulesDef', 'equipmentFruVariant', 'equipmentManufacturingDef', 'equipmentPicture', 'equipmentXFMTypeDef'], [None]),
    "EquipmentDriveSecCap": MoMeta("EquipmentDriveSecCap", "equipmentDriveSecCap", "drive-sec-cap", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], ['equipmentBladeCapProvider', 'equipmentLocalDiskControllerCapProvider', 'equipmentRackUnitCapProvider'], [], ["get"]),
    "EquipmentFan": MoMeta("EquipmentFan", "equipmentFan", "fan-[id]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['equipmentFanModule', 'equipmentFex', 'networkElement'], ['equipmentFanStats', 'equipmentNetworkElementFanStats', 'equipmentRackUnitFanStats', 'faultInst'], ["Get"]),
    "EquipmentFanModule": MoMeta("EquipmentFanModule", "equipmentFanModule", "fan-module-[tray]-[id]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['computeRackUnit', 'equipmentChassis', 'equipmentCrossFabricModule', 'equipmentIOCard', 'equipmentSwitchIOCard', 'networkElement'], ['equipmentBeaconLed', 'equipmentFan', 'equipmentFanModuleStats', 'equipmentHealthLed', 'equipmentIndicatorLed', 'equipmentLocatorLed', 'faultInst'], ["Get"]),
    "EquipmentFanModuleCapProvider": MoMeta("EquipmentFanModuleCapProvider", "equipmentFanModuleCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin"], ['capabilityCatalogue'], ['equipmentFruVariant', 'equipmentManufacturingDef', 'equipmentPicture'], ["Get"]),
    "EquipmentFanModuleStats": MoMeta("EquipmentFanModuleStats", "equipmentFanModuleStats", "stats", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['equipmentFanModule'], ['equipmentFanModuleStatsHist'], [None]),
    "EquipmentFanModuleStatsHist": MoMeta("EquipmentFanModuleStatsHist", "equipmentFanModuleStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], ['equipmentFanModuleStats'], [], [None]),
    "EquipmentFanModulesDef": MoMeta("EquipmentFanModulesDef", "equipmentFanModulesDef", "fanmodules", VersionMeta.Version201t, "InputOutput", 0x1, [], [""], ['equipmentCrossFabricModuleCapProvider', 'equipmentIOCardCapProvider', 'equipmentSwitchIOCardCapProvider'], [], [None]),
    "EquipmentFanStats": MoMeta("EquipmentFanStats", "equipmentFanStats", "stats", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['equipmentFan'], ['equipmentFanStatsHist'], [None]),
    "EquipmentFanStatsHist": MoMeta("EquipmentFanStatsHist", "equipmentFanStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], ['equipmentFanStats'], [], [None]),
    "EquipmentFex": MoMeta("EquipmentFex", "equipmentFex", "fex-[id]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy", "pn-equipment", "pn-maintenance", "pn-policy"], ['computeSystem'], ['equipmentBeaconLed', 'equipmentFan', 'equipmentFexEnvStats', 'equipmentFexOperation', 'equipmentFexPowerSummary', 'equipmentHealthLed', 'equipmentIOCard', 'equipmentIndicatorLed', 'equipmentLocatorLed', 'equipmentPsu', 'faultInst', 'firmwareStatus'], ["Get"]),
    "EquipmentFexCapProvider": MoMeta("EquipmentFexCapProvider", "equipmentFexCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], ['capabilityCatalogue'], ['equipmentFruVariant', 'equipmentManufacturingDef', 'equipmentPicture'], ["Get"]),
    "EquipmentFexEnvStats": MoMeta("EquipmentFexEnvStats", "equipmentFexEnvStats", "env-stats", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['equipmentFex'], ['equipmentFexEnvStatsHist'], [None]),
    "EquipmentFexEnvStatsHist": MoMeta("EquipmentFexEnvStatsHist", "equipmentFexEnvStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], ['equipmentFexEnvStats'], [], [None]),
    "EquipmentFexOperation": MoMeta("EquipmentFexOperation", "equipmentFexOperation", "remote-oper", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy", "pn-equipment", "pn-maintenance", "pn-policy"], ['equipmentFex'], ['faultInst'], ["Get", "Set"]),
    "EquipmentFexPowerSummary": MoMeta("EquipmentFexPowerSummary", "equipmentFexPowerSummary", "power-summary", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['equipmentFex'], ['equipmentFexPowerSummaryHist'], ["Get"]),
    "EquipmentFexPowerSummaryHist": MoMeta("EquipmentFexPowerSummaryHist", "equipmentFexPowerSummaryHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], ['equipmentFexPowerSummary'], [], [None]),
    "EquipmentFexPsuInputStats": MoMeta("EquipmentFexPsuInputStats", "equipmentFexPsuInputStats", "fex-psu-input-stats", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['equipmentPsu'], ['equipmentFexPsuInputStatsHist'], [None]),
    "EquipmentFexPsuInputStatsHist": MoMeta("EquipmentFexPsuInputStatsHist", "equipmentFexPsuInputStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], ['equipmentFexPsuInputStats'], [], [None]),
    "EquipmentFruVariant": MoMeta("EquipmentFruVariant", "equipmentFruVariant", "fruVariant-[type]", VersionMeta.Version201b, "InputOutput", 0x1, [], [""], ['adaptorFruCapProvider', 'diagSrvCapProvider', 'equipmentBladeCapProvider', 'equipmentChassisCapProvider', 'equipmentCrossFabricModuleCapProvider', 'equipmentFanModuleCapProvider', 'equipmentFexCapProvider', 'equipmentGemCapProvider', 'equipmentGraphicsCardCapProvider', 'equipmentHostIfCapProvider', 'equipmentIOCardCapProvider', 'equipmentLocalDiskCapProvider', 'equipmentLocalDiskControllerCapProvider', 'equipmentMemoryUnitCapProvider', 'equipmentPcieConnectorCapProvider', 'equipmentPcieNodeCapProvider', 'equipmentProcessorUnitCapProvider', 'equipmentPsuCapProvider', 'equipmentRackUnitCapProvider', 'equipmentServerUnitCapProvider', 'equipmentSwitchCapProvider', 'equipmentSwitchIOCardCapProvider', 'equipmentSystemFruCapProvider'], [], ["get"]),
    "EquipmentGemCapProvider": MoMeta("EquipmentGemCapProvider", "equipmentGemCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], ['capabilityCatalogue'], ['equipmentFruVariant', 'equipmentManufacturingDef', 'equipmentPicture', 'equipmentUnifiedPortCapProvider'], ["Get"]),
    "EquipmentGraphicsCardCapProvider": MoMeta("EquipmentGraphicsCardCapProvider", "equipmentGraphicsCardCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version201v, "InputOutput", 0x1, [], ["admin"], ['capabilityCatalogue'], ['equipmentFruVariant', 'equipmentManufacturingDef', 'equipmentPciDef', 'equipmentPicture'], [None]),
    "EquipmentHealthLed": MoMeta("EquipmentHealthLed", "equipmentHealthLed", "health-led", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], ['computeBlade', 'computeExtBoard', 'computeRackUnit', 'computeServerUnit', 'equipmentChassis', 'equipmentFanModule', 'equipmentFex', 'equipmentIOCard', 'equipmentPsu'], [], ["Get"]),
    "EquipmentHostIfCapProvider": MoMeta("EquipmentHostIfCapProvider", "equipmentHostIfCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin"], ['capabilityCatalogue'], ['equipmentFruVariant', 'equipmentManufacturingDef', 'equipmentPicture'], ["Get"]),
    "EquipmentIOCard": MoMeta("EquipmentIOCard", "equipmentIOCard", "slot-[id]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy", "pn-equipment", "pn-maintenance", "pn-policy"], ['equipmentChassis', 'equipmentFex'], ['equipmentBeaconLed', 'equipmentFanModule', 'equipmentHealthLed', 'equipmentIOCardStats', 'equipmentIndicatorLed', 'equipmentLocatorLed', 'faultInst', 'firmwareStatus', 'mgmtController', 'portGroup'], ["Get", "Set"]),
    "EquipmentIOCardCapProvider": MoMeta("EquipmentIOCardCapProvider", "equipmentIOCardCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], ['capabilityCatalogue'], ['equipmentFanModulesDef', 'equipmentFruVariant', 'equipmentManufacturingDef', 'equipmentPicture'], ["Get"]),
    "EquipmentIOCardStats": MoMeta("EquipmentIOCardStats", "equipmentIOCardStats", "stats", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['equipmentIOCard'], ['equipmentIOCardStatsHist'], [None]),
    "EquipmentIOCardStatsHist": MoMeta("EquipmentIOCardStatsHist", "equipmentIOCardStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], ['equipmentIOCardStats'], [], [None]),
    "EquipmentImpliedStorageEnclosureDef": MoMeta("EquipmentImpliedStorageEnclosureDef", "equipmentImpliedStorageEnclosureDef", "enclosure-def-[enclosure_id]", VersionMeta.Version131a, "InputOutput", 0x1, [], [""], ['equipmentStorageProcessorCap'], [], ["Get"]),
    "EquipmentIndicatorLed": MoMeta("EquipmentIndicatorLed", "equipmentIndicatorLed", "indicator-led-[id]", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy", "read-only"], ['computeBlade', 'computeRackUnit', 'computeServerUnit', 'equipmentChassis', 'equipmentFanModule', 'equipmentFex', 'equipmentIOCard', 'equipmentPsu'], [], ["Get"]),
    "EquipmentInstance": MoMeta("EquipmentInstance", "equipmentInstance", "inst-[id]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server"], ['equipmentChassisRequirement'], ['cpmaintAck', 'equipmentChassisIssues'], ["Get"]),
    "EquipmentInstanceMapping": MoMeta("EquipmentInstanceMapping", "equipmentInstanceMapping", "instmap-[name]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin"], ['computeSystem'], [], ["Get"]),
    "EquipmentLocalDiskCapProvider": MoMeta("EquipmentLocalDiskCapProvider", "equipmentLocalDiskCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin"], ['capabilityCatalogue'], ['equipmentFruVariant', 'equipmentLocalDiskDef', 'equipmentManufacturingDef', 'equipmentPicture'], ["Get"]),
    "EquipmentLocalDiskControllerCapProvider": MoMeta("EquipmentLocalDiskControllerCapProvider", "equipmentLocalDiskControllerCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin"], ['capabilityCatalogue'], ['equipmentDriveSecCap', 'equipmentFruVariant', 'equipmentManufacturingDef', 'equipmentPciDef', 'equipmentPicture'], ["Get"]),
    "EquipmentLocalDiskDef": MoMeta("EquipmentLocalDiskDef", "equipmentLocalDiskDef", "disk", VersionMeta.Version111a, "InputOutput", 0x1, [], [""], ['equipmentLocalDiskCapProvider'], [], ["Get"]),
    "EquipmentLocalTemplDef": MoMeta("EquipmentLocalTemplDef", "equipmentLocalTemplDef", "inst-[id]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["read-only"], ['equipmentTemplate'], [], [None]),
    "EquipmentLocatorLed": MoMeta("EquipmentLocatorLed", "equipmentLocatorLed", "locator-led", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy", "read-only"], ['computeBlade', 'computeExtBoard', 'computeRackUnit', 'computeServerUnit', 'equipmentChassis', 'equipmentFanModule', 'equipmentFex', 'equipmentIOCard', 'equipmentPsu', 'networkElement', 'storageLocalDisk'], ['equipmentLocatorLedOperation'], ["Get", "Set"]),
    "EquipmentLocatorLedOperation": MoMeta("EquipmentLocatorLedOperation", "equipmentLocatorLedOperation", "remote-oper", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], ['equipmentLocatorLed'], ['faultInst'], ["Get", "Set"]),
    "EquipmentManufacturingDef": MoMeta("EquipmentManufacturingDef", "equipmentManufacturingDef", "manufacturing", VersionMeta.Version101a, "InputOutput", 0x1, [], [""], ['adaptorFruCapProvider', 'diagSrvCapProvider', 'equipmentBladeCapProvider', 'equipmentChassisCapProvider', 'equipmentCrossFabricModuleCapProvider', 'equipmentFanModuleCapProvider', 'equipmentFexCapProvider', 'equipmentGemCapProvider', 'equipmentGraphicsCardCapProvider', 'equipmentHostIfCapProvider', 'equipmentIOCardCapProvider', 'equipmentLocalDiskCapProvider', 'equipmentLocalDiskControllerCapProvider', 'equipmentMemoryUnitCapProvider', 'equipmentPcieConnectorCapProvider', 'equipmentPcieNodeCapProvider', 'equipmentProcessorUnitCapProvider', 'equipmentPsuCapProvider', 'equipmentRackUnitCapProvider', 'equipmentServerUnitCapProvider', 'equipmentSwitchCapProvider', 'equipmentSwitchIOCardCapProvider', 'equipmentSystemFruCapProvider'], [], ["Get"]),
    "EquipmentMemoryUnitCapProvider": MoMeta("EquipmentMemoryUnitCapProvider", "equipmentMemoryUnitCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin"], ['capabilityCatalogue'], ['equipmentFruVariant', 'equipmentManufacturingDef', 'equipmentPicture'], ["Get"]),
    "EquipmentNetworkElementFanStats": MoMeta("EquipmentNetworkElementFanStats", "equipmentNetworkElementFanStats", "stats", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['equipmentFan'], ['equipmentNetworkElementFanStatsHist'], [None]),
    "EquipmentNetworkElementFanStatsHist": MoMeta("EquipmentNetworkElementFanStatsHist", "equipmentNetworkElementFanStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], ['equipmentNetworkElementFanStats'], [], [None]),
    "EquipmentPciDef": MoMeta("EquipmentPciDef", "equipmentPciDef", "pci-[name]", VersionMeta.Version151a, "InputOutput", 0x1, [], [""], ['equipmentGraphicsCardCapProvider', 'equipmentLocalDiskControllerCapProvider'], [], ["Get"]),
    "EquipmentPcieConnectorCapProvider": MoMeta("EquipmentPcieConnectorCapProvider", "equipmentPcieConnectorCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version201v, "InputOutput", 0x1, [], ["admin"], ['capabilityCatalogue'], ['equipmentFruVariant', 'equipmentManufacturingDef', 'equipmentPicture'], [None]),
    "EquipmentPcieConnectorUnit": MoMeta("EquipmentPcieConnectorUnit", "equipmentPcieConnectorUnit", "pcie-connector-unit", VersionMeta.Version201v, "InputOutput", 0x1, [], ["read-only"], ['computeBoard'], [], [None]),
    "EquipmentPcieNode": MoMeta("EquipmentPcieNode", "equipmentPcieNode", "pcie-node-[slot_id]", VersionMeta.Version201v, "InputOutput", 0x1, [], ["read-only"], ['computeBlade', 'equipmentChassis'], [], [None]),
    "EquipmentPcieNodeCapProvider": MoMeta("EquipmentPcieNodeCapProvider", "equipmentPcieNodeCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version201v, "InputOutput", 0x1, [], ["admin"], ['capabilityCatalogue'], ['equipmentFruVariant', 'equipmentManufacturingDef', 'equipmentPicture'], [None]),
    "EquipmentPhysicalQual": MoMeta("EquipmentPhysicalQual", "equipmentPhysicalQual", "physicalqual", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "pn-policy"], ['equipmentQual'], [], [None]),
    "EquipmentPicture": MoMeta("EquipmentPicture", "equipmentPicture", "picture-[type]", VersionMeta.Version101a, "InputOutput", 0x1, [], [""], ['adaptorFruCapProvider', 'diagSrvCapProvider', 'equipmentBladeCapProvider', 'equipmentChassisCapProvider', 'equipmentCrossFabricModuleCapProvider', 'equipmentFanModuleCapProvider', 'equipmentFexCapProvider', 'equipmentGemCapProvider', 'equipmentGraphicsCardCapProvider', 'equipmentHostIfCapProvider', 'equipmentIOCardCapProvider', 'equipmentLocalDiskCapProvider', 'equipmentLocalDiskControllerCapProvider', 'equipmentMemoryUnitCapProvider', 'equipmentPcieConnectorCapProvider', 'equipmentPcieNodeCapProvider', 'equipmentProcessorUnitCapProvider', 'equipmentPsuCapProvider', 'equipmentRackUnitCapProvider', 'equipmentServerUnitCapProvider', 'equipmentSwitchCapProvider', 'equipmentSwitchIOCardCapProvider', 'equipmentSystemFruCapProvider'], [], ["Get"]),
    "EquipmentPool": MoMeta("EquipmentPool", "equipmentPool", "equipment-pool-[name]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["read-only"], ['orgOrg'], [], [None]),
    "EquipmentPoolable": MoMeta("EquipmentPoolable", "equipmentPoolable", "chassis-pool-[id]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "EquipmentPoolingPolicy": MoMeta("EquipmentPoolingPolicy", "equipmentPoolingPolicy", "chassis-pooling-policy-[name]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["read-only"], ['orgOrg'], [], [None]),
    "EquipmentProcessorUnitCapProvider": MoMeta("EquipmentProcessorUnitCapProvider", "equipmentProcessorUnitCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin"], ['capabilityCatalogue'], ['equipmentFruVariant', 'equipmentManufacturingDef', 'equipmentPicture'], ["Get"]),
    "EquipmentPsu": MoMeta("EquipmentPsu", "equipmentPsu", "psu-[id]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['computeRackUnit', 'equipmentChassis', 'equipmentFex', 'networkElement'], ['equipmentBeaconLed', 'equipmentFexPsuInputStats', 'equipmentHealthLed', 'equipmentIndicatorLed', 'equipmentLocatorLed', 'equipmentPsuInputStats', 'equipmentPsuOutputStats', 'equipmentPsuStats', 'equipmentRackUnitPsuStats', 'faultInst', 'firmwareBootDefinition', 'firmwareRunning', 'firmwareStatus', 'firmwareUpdatable'], ["Get"]),
    "EquipmentPsuCapProvider": MoMeta("EquipmentPsuCapProvider", "equipmentPsuCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin"], ['capabilityCatalogue'], ['equipmentFruVariant', 'equipmentManufacturingDef', 'equipmentPicture'], ["Get"]),
    "EquipmentPsuInputStats": MoMeta("EquipmentPsuInputStats", "equipmentPsuInputStats", "input-stats", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['equipmentPsu'], ['equipmentPsuInputStatsHist'], [None]),
    "EquipmentPsuInputStatsHist": MoMeta("EquipmentPsuInputStatsHist", "equipmentPsuInputStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], ['equipmentPsuInputStats'], [], [None]),
    "EquipmentPsuOutputStats": MoMeta("EquipmentPsuOutputStats", "equipmentPsuOutputStats", "output-stats", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['equipmentPsu'], ['equipmentPsuOutputStatsHist'], [None]),
    "EquipmentPsuOutputStatsHist": MoMeta("EquipmentPsuOutputStatsHist", "equipmentPsuOutputStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], ['equipmentPsuOutputStats'], [], [None]),
    "EquipmentPsuStats": MoMeta("EquipmentPsuStats", "equipmentPsuStats", "stats", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['equipmentPsu'], ['equipmentPsuStatsHist'], [None]),
    "EquipmentPsuStatsHist": MoMeta("EquipmentPsuStatsHist", "equipmentPsuStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], ['equipmentPsuStats'], [], [None]),
    "EquipmentQual": MoMeta("EquipmentQual", "equipmentQual", "chassis-qualifier-[name]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "pn-policy"], ['orgOrg'], ['equipmentChassisQual', 'equipmentPhysicalQual'], [None]),
    "EquipmentRackUnitCapProvider": MoMeta("EquipmentRackUnitCapProvider", "equipmentRackUnitCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], ['capabilityCatalogue'], ['equipmentAdvancedBootOrder', 'equipmentCimcVmedia', 'equipmentDriveSecCap', 'equipmentFruVariant', 'equipmentManufacturingDef', 'equipmentPicture', 'equipmentSecureBoot', 'equipmentServerFeatureCap', 'equipmentStorageProcessorCap'], ["Get"]),
    "EquipmentRackUnitFanStats": MoMeta("EquipmentRackUnitFanStats", "equipmentRackUnitFanStats", "stats", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['equipmentFan'], ['equipmentRackUnitFanStatsHist'], [None]),
    "EquipmentRackUnitFanStatsHist": MoMeta("EquipmentRackUnitFanStatsHist", "equipmentRackUnitFanStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], ['equipmentRackUnitFanStats'], [], [None]),
    "EquipmentRackUnitPsuStats": MoMeta("EquipmentRackUnitPsuStats", "equipmentRackUnitPsuStats", "rackunit-power-stats", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['equipmentPsu'], ['equipmentRackUnitPsuStatsHist'], [None]),
    "EquipmentRackUnitPsuStatsHist": MoMeta("EquipmentRackUnitPsuStatsHist", "equipmentRackUnitPsuStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], ['equipmentRackUnitPsuStats'], [], [None]),
    "EquipmentRequirement": MoMeta("EquipmentRequirement", "equipmentRequirement", "chassis-req", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy", "read-only"], ['equipmentChassisProfile'], ['faultInst'], ["Get"]),
    "EquipmentSecureBoot": MoMeta("EquipmentSecureBoot", "equipmentSecureBoot", "secBoot", VersionMeta.Version121a, "InputOutput", 0x1, [], [""], ['equipmentBladeCapProvider', 'equipmentRackUnitCapProvider', 'equipmentServerUnitCapProvider'], [], ["Get"]),
    "EquipmentServerFeatureCap": MoMeta("EquipmentServerFeatureCap", "equipmentServerFeatureCap", "server-feature-cap", VersionMeta.Version141a, "InputOutput", 0x1, [], ["read-only"], ['equipmentBladeCapProvider', 'equipmentRackUnitCapProvider', 'equipmentServerUnitCapProvider'], [], ["Get"]),
    "EquipmentServerUnitCapProvider": MoMeta("EquipmentServerUnitCapProvider", "equipmentServerUnitCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin"], ['capabilityCatalogue'], ['equipmentAdvancedBootOrder', 'equipmentCimcVmedia', 'equipmentFruVariant', 'equipmentManufacturingDef', 'equipmentPicture', 'equipmentSecureBoot', 'equipmentServerFeatureCap', 'equipmentStorageProcessorCap'], ["Get"]),
    "EquipmentSharedIOModule": MoMeta("EquipmentSharedIOModule", "equipmentSharedIOModule", "shared-io-module", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy", "pn-equipment", "pn-maintenance", "pn-policy"], ['equipmentChassis', 'equipmentSystemIOController'], ['mgmtController', 'portGroup'], ["Get"]),
    "EquipmentSiocTempStats": MoMeta("EquipmentSiocTempStats", "equipmentSiocTempStats", "temp-stats", VersionMeta.Version151a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [], ['equipmentSiocTempStatsHist'], ["Get"]),
    "EquipmentSiocTempStatsHist": MoMeta("EquipmentSiocTempStatsHist", "equipmentSiocTempStatsHist", "[id]", VersionMeta.Version151a, "OutputOnly", 0x1, [], ["read-only"], ['equipmentSiocTempStats'], [], ["Get"]),
    "EquipmentStorageProcessorCap": MoMeta("EquipmentStorageProcessorCap", "equipmentStorageProcessorCap", "storage-proc-cap", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], ['equipmentBladeCapProvider', 'equipmentRackUnitCapProvider', 'equipmentServerUnitCapProvider'], ['equipmentImpliedStorageEnclosureDef'], ["Get"]),
    "EquipmentSwitchCapProvider": MoMeta("EquipmentSwitchCapProvider", "equipmentSwitchCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], ['capabilityCatalogue'], ['equipmentBreakoutCap', 'equipmentFruVariant', 'equipmentManufacturingDef', 'equipmentPicture', 'equipmentUnifiedPortCapProvider'], ["Get"]),
    "EquipmentSwitchCard": MoMeta("EquipmentSwitchCard", "equipmentSwitchCard", "slot-[id]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], ['networkElement'], ['portGroup'], ["Get"]),
    "EquipmentSwitchIOCard": MoMeta("EquipmentSwitchIOCard", "equipmentSwitchIOCard", "sw-slot-[id]", VersionMeta.Version121a, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy", "pn-equipment", "pn-maintenance", "pn-policy"], ['equipmentChassis'], ['equipmentFanModule', 'mgmtController', 'portGroup'], ["Get"]),
    "EquipmentSwitchIOCardCapProvider": MoMeta("EquipmentSwitchIOCardCapProvider", "equipmentSwitchIOCardCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version121a, "InputOutput", 0x1, [], ["admin"], ['capabilityCatalogue'], ['equipmentBreakoutCap', 'equipmentFanModulesDef', 'equipmentFruVariant', 'equipmentManufacturingDef', 'equipmentPicture', 'equipmentUnifiedPortCapProvider'], ["Get"]),
    "EquipmentSystemFruCapProvider": MoMeta("EquipmentSystemFruCapProvider", "equipmentSystemFruCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin"], ['capabilityCatalogue'], ['equipmentFruVariant', 'equipmentManufacturingDef', 'equipmentPicture'], ["Get"]),
    "EquipmentSystemIOController": MoMeta("EquipmentSystemIOController", "equipmentSystemIOController", "slot-[id]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy", "pn-equipment", "pn-maintenance", "pn-policy"], ['equipmentChassis'], ['computeBoardController', 'equipmentSharedIOModule', 'equipmentSystemIOControllerOperation', 'mgmtController'], ["Get"]),
    "EquipmentSystemIOControllerOperation": MoMeta("EquipmentSystemIOControllerOperation", "equipmentSystemIOControllerOperation", "remote-oper", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy", "pn-equipment", "pn-maintenance", "pn-policy"], ['equipmentSystemIOController'], ['faultInst'], ["Get", "Set"]),
    "EquipmentTemplate": MoMeta("EquipmentTemplate", "equipmentTemplate", "chassis-templ-[name]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["read-only"], ['orgOrg'], ['equipmentChassisProfile', 'equipmentLocalTemplDef'], ["Get"]),
    "EquipmentTemplateMapping": MoMeta("EquipmentTemplateMapping", "equipmentTemplateMapping", "chassis-templmap-[name]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin"], ['computeSystem'], [], ["Get"]),
    "EquipmentTier": MoMeta("EquipmentTier", "equipmentTier", "cp-tier-[name]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy"], ['orgOrg'], ['equipmentChassisProfile'], [None]),
    "EquipmentUnifiedPortCapProvider": MoMeta("EquipmentUnifiedPortCapProvider", "equipmentUnifiedPortCapProvider", "unified-port-cap", VersionMeta.Version131a, "InputOutput", 0x1, [], [""], ['equipmentGemCapProvider', 'equipmentSwitchCapProvider', 'equipmentSwitchIOCardCapProvider'], [], ["Get"]),
    "EquipmentXFMTypeDef": MoMeta("EquipmentXFMTypeDef", "equipmentXFMTypeDef", "type", VersionMeta.Version201v, "InputOutput", 0x1, [], [""], ['equipmentCrossFabricModuleCapProvider'], [], [None]),
    "EquipmentXcvr": MoMeta("EquipmentXcvr", "equipmentXcvr", "transceiver", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['etherPIo', 'etherServerIntFIo', 'etherSwitchIntFIo', 'fcPIo'], [], ["Get"]),
    "EtherErrStats": MoMeta("EtherErrStats", "etherErrStats", "err-stats", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['etherServerIntFIo'], ['etherErrStatsHist'], [None]),
    "EtherErrStatsHist": MoMeta("EtherErrStatsHist", "etherErrStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], ['etherErrStats'], [], [None]),
    "EtherFcoeInterfaceStats": MoMeta("EtherFcoeInterfaceStats", "etherFcoeInterfaceStats", "fcoe-interface-stats", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['fabricFcoeEstcEp'], ['etherFcoeInterfaceStatsHist'], [None]),
    "EtherFcoeInterfaceStatsHist": MoMeta("EtherFcoeInterfaceStatsHist", "etherFcoeInterfaceStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], ['etherFcoeInterfaceStats'], [], [None]),
    "EtherLossStats": MoMeta("EtherLossStats", "etherLossStats", "loss-stats", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['etherServerIntFIo'], ['etherLossStatsHist'], [None]),
    "EtherLossStatsHist": MoMeta("EtherLossStatsHist", "etherLossStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], ['etherLossStats'], [], [None]),
    "EtherPIo": MoMeta("EtherPIo", "etherPIo", "port-[port_id]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['portGroup', 'portSubGroup'], ['equipmentXcvr'], ["Get"]),
    "EtherPauseStats": MoMeta("EtherPauseStats", "etherPauseStats", "pause-stats", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['etherServerIntFIo'], ['etherPauseStatsHist'], [None]),
    "EtherPauseStatsHist": MoMeta("EtherPauseStatsHist", "etherPauseStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], ['etherPauseStats'], [], [None]),
    "EtherRxStats": MoMeta("EtherRxStats", "etherRxStats", "rx-stats", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['etherServerIntFIo'], ['etherRxStatsHist'], [None]),
    "EtherRxStatsHist": MoMeta("EtherRxStatsHist", "etherRxStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], ['etherRxStats'], [], [None]),
    "EtherServerIntFIo": MoMeta("EtherServerIntFIo", "etherServerIntFIo", "port-[port_id]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin"], ['diagSrvCtrl', 'portGroup'], ['equipmentXcvr', 'etherErrStats', 'etherLossStats', 'etherPauseStats', 'etherRxStats', 'etherTxStats', 'faultInst'], ["Get"]),
    "EtherSwitchIntFIo": MoMeta("EtherSwitchIntFIo", "etherSwitchIntFIo", "pc-[port_id]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], ['portGroup'], ['equipmentXcvr'], ["Get"]),
    "EtherTxStats": MoMeta("EtherTxStats", "etherTxStats", "tx-stats", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['etherServerIntFIo'], ['etherTxStatsHist'], [None]),
    "EtherTxStatsHist": MoMeta("EtherTxStatsHist", "etherTxStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], ['etherTxStats'], [], [None]),
    "EventApplication": MoMeta("EventApplication", "eventApplication", "type-[type]ip-[ip]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "EventEpCtrl": MoMeta("EventEpCtrl", "eventEpCtrl", "evctrl", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "fault", "operations"], [], [], ["Get"]),
    "EventHolder": MoMeta("EventHolder", "eventHolder", "event", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], ['topRoot'], ['eventPolicy'], ["Get"]),
    "EventInst": MoMeta("EventInst", "eventInst", "event-[id]", VersionMeta.Version101a, "OutputOnly", 0x1, [], ["read-only"], ['aaaAuthRealm', 'aaaLdapEp', 'aaaRadiusEp', 'aaaTacacsPlusEp', 'aaaUserEp', 'callhomeHolder', 'certRepairEp', 'changeEp', 'commDateTime', 'commSvcEp', 'computeSystem', 'configBackup', 'configConsumerCatalogue', 'configPasswordEncryption', 'consumerInst', 'controllerEp', 'diagSrvCtrlOperation', 'domainProfile', 'dupeChangeTrackerEp', 'equipmentChassisProfile', 'extpolClient', 'extpolEp', 'fabricDceSwSrvPcOperation', 'fabricEthEstcEpOperation', 'fabricEthEstcPcOperation', 'fabricEthLanEpOperation', 'fabricEthLanPcOperation', 'fabricEthMonOperation', 'fabricFcEstcEpOperation', 'fabricFcMonOperation', 'fabricFcSanEpOperation', 'fabricFcSanPcOperation', 'fabricFcZoneProfile', 'fabricFcoeEstcEpOperation', 'fabricFcoeSanEpOperation', 'fabricFcoeSanPcOperation', 'fabricVnetEpSyncEp', 'fdBlade', 'fdRackUnit', 'firmwareDistributable', 'firmwareDownloader', 'glIdentCtxResOp', 'glRequest', 'glRequestVnetEp', 'glRequestVnetEpDomainEp', 'identIdentRequest', 'identMetaSystem', 'licenseDownloader', 'licenseFile', 'licenseInstance', 'lsServer', 'mgmtBackup', 'mgmtBackupTrigger', 'mgmtDataExporter', 'mgmtDataImporter', 'mgmtIf', 'mgmtImporter', 'mgmtRegistryInfo', 'networkElement', 'nfsClientDef', 'nfsExportDef', 'observeObserved', 'orgOrg', 'pkiEp', 'policyControlEpOp', 'policyPolicyScope', 'smartlicenseAgent', 'smartlicenseEntitlementEp', 'smartlicenseHolder', 'smartlicenseTest', 'sysdebugAutoCoreFileExportTarget', 'sysdebugLogControlEp', 'sysdebugManualCoreFileExportTarget', 'sysdebugTechSupport', 'sysfileMutation', 'testingServiceProfile', 'topSystem', 'vnicOutbandMgmtEp'], [], ["Get"]),
    "EventLog": MoMeta("EventLog", "eventLog", "event-log", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "fault", "operations"], ['topRoot'], ['eventRecord'], ["Get"]),
    "EventPolicy": MoMeta("EventPolicy", "eventPolicy", "event-policy", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "read-only"], ['eventHolder'], [], ["Get"]),
    "EventRecord": MoMeta("EventRecord", "eventRecord", "[id]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], ['eventLog'], [], ["Get"]),
    "ExtmgmtArpTargets": MoMeta("ExtmgmtArpTargets", "extmgmtArpTargets", "arp-target-policy", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "domain-group-management", "ext-lan-config"], ['extmgmtIfMonPolicy'], [], ["Add", "Get", "Set"]),
    "ExtmgmtGatewayPing": MoMeta("ExtmgmtGatewayPing", "extmgmtGatewayPing", "gw-ping-policy", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "domain-group-management", "ext-lan-config"], ['extmgmtIfMonPolicy'], [], ["Add", "Get", "Set"]),
    "ExtmgmtIfMonPolicy": MoMeta("ExtmgmtIfMonPolicy", "extmgmtIfMonPolicy", "extmgmt-intf-monitor-policy", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "domain-group-management", "ext-lan-config"], ['orgDomainGroup', 'policyDeviceProfile'], ['extmgmtArpTargets', 'extmgmtGatewayPing', 'extmgmtMiiStatus', 'extmgmtNdiscTargets'], ["Add", "Get", "Remove", "Set"]),
    "ExtmgmtMiiStatus": MoMeta("ExtmgmtMiiStatus", "extmgmtMiiStatus", "mii-status-policy", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "domain-group-management", "ext-lan-config"], ['extmgmtIfMonPolicy'], [], ["Add", "Get", "Set"]),
    "ExtmgmtNdiscTargets": MoMeta("ExtmgmtNdiscTargets", "extmgmtNdiscTargets", "ndisc-target-policy", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin", "domain-group-management", "ext-lan-config"], ['extmgmtIfMonPolicy'], [], ["Get", "Set"]),
    "ExtpolClient": MoMeta("ExtpolClient", "extpolClient", "client-[id]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], ['extpolClientCont'], ['dupeEp', 'eventInst', 'extpolClientFsm', 'extpolClientFsmTask', 'fabricVnetEpSyncEp', 'faultInst', 'mgmtBackup', 'observeObserved', 'policyConfigError', 'policyPolicyScopeCont', 'statsInventoryMeta'], ["Get", "Remove"]),
    "ExtpolClientCont": MoMeta("ExtpolClientCont", "extpolClientCont", "clients", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], ['extpolRegistry'], ['extpolClient', 'extpolDomain', 'extpolHBStatus'], ["Get"]),
    "ExtpolClientFsm": MoMeta("ExtpolClientFsm", "extpolClientFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['extpolClient'], ['extpolClientFsmStage'], [None]),
    "ExtpolClientFsmStage": MoMeta("ExtpolClientFsmStage", "extpolClientFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['extpolClientFsm'], [], [None]),
    "ExtpolClientFsmTask": MoMeta("ExtpolClientFsmTask", "extpolClientFsmTask", "task-[item]", VersionMeta.Version111a, "OutputOnly", 0x1, [], [""], ['extpolClient'], [], [None]),
    "ExtpolController": MoMeta("ExtpolController", "extpolController", "contro-[id]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], ['extpolControllerCont'], ['dupeEp', 'faultInst', 'observeObserved', 'policyPolicyScopeCont'], ["Get"]),
    "ExtpolControllerCont": MoMeta("ExtpolControllerCont", "extpolControllerCont", "controllers", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], ['extpolRegistry'], ['extpolController'], ["Get"]),
    "ExtpolDomain": MoMeta("ExtpolDomain", "extpolDomain", "domain-[guid]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['extpolClientCont'], ['changeEp', 'computeChassisFeatMask', 'computeEnvFeatMask', 'computeNetworkFeatMask', 'computeServerFeatMask', 'computeStorageFeatMask', 'domainChassisFeature', 'domainEnvironmentFeature', 'domainNetworkFeature', 'domainServerFeature', 'domainStorageFeature', 'lstorageBlade'], ["Get"]),
    "ExtpolEp": MoMeta("ExtpolEp", "extpolEp", "extpol", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], ['topRoot'], ['eventInst', 'extpolEpFsm', 'extpolEpFsmTask', 'extpolRegistry', 'faultInst', 'faultSummary'], ["Get"]),
    "ExtpolEpFsm": MoMeta("ExtpolEpFsm", "extpolEpFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['extpolEp'], ['extpolEpFsmStage'], [None]),
    "ExtpolEpFsmStage": MoMeta("ExtpolEpFsmStage", "extpolEpFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['extpolEpFsm'], [], [None]),
    "ExtpolEpFsmTask": MoMeta("ExtpolEpFsmTask", "extpolEpFsmTask", "task-[item]", VersionMeta.Version101a, "OutputOnly", 0x1, [], [""], ['extpolEp'], [], [None]),
    "ExtpolHBStatus": MoMeta("ExtpolHBStatus", "extpolHBStatus", "hb-status", VersionMeta.Version121a, "InputOutput", 0x1, [], ["admin"], ['extpolClientCont'], [], [None]),
    "ExtpolProvider": MoMeta("ExtpolProvider", "extpolProvider", "prov-[type]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], ['extpolProviderCont'], ['dupeEp', 'faultInst', 'observeObserved', 'policyPolicyScopeCont'], ["Get"]),
    "ExtpolProviderCont": MoMeta("ExtpolProviderCont", "extpolProviderCont", "providers", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], ['extpolRegistry'], ['extpolProvider'], ["Get"]),
    "ExtpolRegistry": MoMeta("ExtpolRegistry", "extpolRegistry", "reg", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], ['extpolEp'], ['dupeEp', 'extpolClientCont', 'extpolControllerCont', 'extpolProviderCont', 'extpolRegistryCapability', 'faultInst', 'observeObserved', 'policyPolicyScopeCont'], ["Get"]),
    "ExtpolRegistryCapability": MoMeta("ExtpolRegistryCapability", "extpolRegistryCapability", "cap", VersionMeta.Version121a, "InputOutput", 0x1, [], ["read-only"], ['extpolRegistry'], [], ["Get"]),
    "ExtpolSystemContext": MoMeta("ExtpolSystemContext", "extpolSystemContext", "sysctx", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "ExtpolVersionHolder": MoMeta("ExtpolVersionHolder", "extpolVersionHolder", "versionHolder-[id]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "ExtvmmNetworkSets": MoMeta("ExtvmmNetworkSets", "extvmmNetworkSets", "network-sets", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy"], ['fabricLanCloud'], [], ["Get"]),
    "ExtvmmVMNetworkSets": MoMeta("ExtvmmVMNetworkSets", "extvmmVMNetworkSets", "vm-network-sets", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy"], ['fabricLanCloud'], [], ["Get"]),
    "FabricBreakout": MoMeta("FabricBreakout", "fabricBreakout", "breakout-slot-[slot_id]-port-[port_id]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy", "ext-san-config", "ext-san-policy"], ['fabricCablingSw'], [], ["Get"]),
    "FabricBreakoutOperation": MoMeta("FabricBreakoutOperation", "fabricBreakoutOperation", "remoper-slot-[slot_id]-port-[port_id]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy", "ext-san-config", "ext-san-policy"], ['fabricCablingSw'], ['faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FabricCabling": MoMeta("FabricCabling", "fabricCabling", "Cabling", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy", "ext-san-config", "ext-san-policy"], ['fabricEp'], ['fabricCablingSw', 'statsThresholdPolicy'], ["Get"]),
    "FabricCablingSw": MoMeta("FabricCablingSw", "fabricCablingSw", "[id]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy", "ext-san-config", "ext-san-policy"], ['fabricCabling'], ['fabricBreakout', 'fabricBreakoutOperation'], ["Get"]),
    "FabricCartridgeSlotEp": MoMeta("FabricCartridgeSlotEp", "fabricCartridgeSlotEp", "cart-slot-[slot_id]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], ['fabricChassisEp'], ['fabricCartridgeSlotEpOperation', 'fabricComputeMSlotEp'], ["Get", "Set"]),
    "FabricCartridgeSlotEpOperation": MoMeta("FabricCartridgeSlotEpOperation", "fabricCartridgeSlotEpOperation", "remote-oper", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], ['fabricCartridgeSlotEp'], ['faultInst'], ["Get", "Set"]),
    "FabricCdpLinkPolicy": MoMeta("FabricCdpLinkPolicy", "fabricCdpLinkPolicy", "", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy", "read-only"], [], [], ["Get", "Set"]),
    "FabricChangedObjectRef": MoMeta("FabricChangedObjectRef", "fabricChangedObjectRef", "ChangedObjectRef[id]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['fabricVnetEpSyncEp'], ['faultInst'], [None]),
    "FabricChassisEp": MoMeta("FabricChassisEp", "fabricChassisEp", "chassis-[chassis_id]", VersionMeta.Version112a, "InputOutput", 0x1, [], ["read-only"], ['fabricDceSrv'], ['fabricCartridgeSlotEp', 'fabricComputeSlotEp', 'fabricEnclosureSlotEp'], ["Get"]),
    "FabricComputeMSlotEp": MoMeta("FabricComputeMSlotEp", "fabricComputeMSlotEp", "ins-[server_instance_id]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], ['fabricCartridgeSlotEp'], [], ["Get", "Set"]),
    "FabricComputePhEp": MoMeta("FabricComputePhEp", "fabricComputePhEp", "compute-ep-ven-[vendor]-mod-[model]-ser-[serial]", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], ['fabricDceSrv'], ['fabricComputePhEpOperation'], ["Get", "Set"]),
    "FabricComputePhEpOperation": MoMeta("FabricComputePhEpOperation", "fabricComputePhEpOperation", "remote-oper", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], ['fabricComputePhEp'], ['faultInst'], ["Get", "Set"]),
    "FabricComputeSlotEp": MoMeta("FabricComputeSlotEp", "fabricComputeSlotEp", "slot-[slot_id]", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], ['fabricChassisEp'], ['fabricComputeSlotEpOperation'], ["Get", "Set"]),
    "FabricComputeSlotEpOperation": MoMeta("FabricComputeSlotEpOperation", "fabricComputeSlotEpOperation", "remote-oper", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], ['fabricComputeSlotEp'], ['faultInst'], ["Get", "Set"]),
    "FabricConsumer": MoMeta("FabricConsumer", "fabricConsumer", "ucsm-[client_id]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], ['adaptorVlan', 'fabricVlan', 'fabricVlanEp', 'fabricVsan', 'fabricVsanEp'], [], ["Get", "Remove"]),
    "FabricDceSrv": MoMeta("FabricDceSrv", "fabricDceSrv", "server", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-network-policy"], ['fabricEp'], ['fabricChassisEp', 'fabricComputePhEp', 'fabricDceSwSrv', 'fabricEnclosurePhEp', 'fabricSwChPhEp', 'statsThresholdPolicy'], ["Get"]),
    "FabricDceSwSrv": MoMeta("FabricDceSwSrv", "fabricDceSwSrv", "sw-[id]", VersionMeta.Version121a, "InputOutput", 0x1, [], ["admin", "ls-network-policy"], ['fabricDceSrv'], ['fabricDceSwSrvEp', 'fabricDceSwSrvEpOperation', 'fabricDceSwSrvPc', 'fabricDceSwSrvPcOperation', 'fabricSubGroup'], ["Get"]),
    "FabricDceSwSrvEp": MoMeta("FabricDceSwSrvEp", "fabricDceSwSrvEp", "slot-[slot_id]-port-[port_id]", VersionMeta.Version121a, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy"], ['fabricDceSwSrv', 'fabricSubGroup'], ['fabricEthMonSrcEp', 'fabricEthMonSrcEpOperation'], ["Add", "Get", "Remove", "Set"]),
    "FabricDceSwSrvEpOperation": MoMeta("FabricDceSwSrvEpOperation", "fabricDceSwSrvEpOperation", "remoper-slot-[slot_id]-port-[port_id]", VersionMeta.Version121a, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy"], ['fabricDceSwSrv', 'fabricSubGroup'], ['faultInst'], ["Get", "Set"]),
    "FabricDceSwSrvPc": MoMeta("FabricDceSwSrvPc", "fabricDceSwSrvPc", "pc-[port_id]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy"], ['fabricDceSwSrv'], ['fabricDceSwSrvPcEp', 'fabricSubGroup'], ["Get"]),
    "FabricDceSwSrvPcEp": MoMeta("FabricDceSwSrvPcEp", "fabricDceSwSrvPcEp", "ep-slot-[slot_id]-port-[port_id]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy"], ['fabricDceSwSrvPc', 'fabricSubGroup'], [], ["Get"]),
    "FabricDceSwSrvPcEpOperation": MoMeta("FabricDceSwSrvPcEpOperation", "fabricDceSwSrvPcEpOperation", "remoper-ep-slot-[slot_id]-port-[port_id]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy"], ['fabricDceSwSrvPcOperation', 'fabricSubGroup'], ['faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FabricDceSwSrvPcOperation": MoMeta("FabricDceSwSrvPcOperation", "fabricDceSwSrvPcOperation", "remoper-pc-[port_id]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy"], ['fabricDceSwSrv'], ['eventInst', 'fabricDceSwSrvPcEpOperation', 'fabricDceSwSrvPcOperationFsm', 'fabricEthPortOperationFsm', 'fabricFIPortOperationFsm', 'fabricFIPortOperationFsmTask', 'fabricSubGroup', 'faultInst', 'messageEp', 'vnicEther'], ["Add", "Get", "Remove", "Set"]),
    "FabricDceSwSrvPcOperationFsm": MoMeta("FabricDceSwSrvPcOperationFsm", "fabricDceSwSrvPcOperationFsm", "fsm", VersionMeta.Version151a, "OutputOnly", 0x1, [], [""], ['fabricDceSwSrvPcOperation'], ['fabricDceSwSrvPcOperationFsmStage'], [None]),
    "FabricDceSwSrvPcOperationFsmStage": MoMeta("FabricDceSwSrvPcOperationFsmStage", "fabricDceSwSrvPcOperationFsmStage", "stage-[name]", VersionMeta.Version151a, "OutputOnly", 0x1, [], [""], ['fabricDceSwSrvPcOperationFsm'], [], [None]),
    "FabricDomainEp": MoMeta("FabricDomainEp", "fabricDomainEp", "domain-ep", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin"], ['fabricHolder'], ['fabricSystem', 'policyControlEpOp'], ["Get"]),
    "FabricEnclosurePhEp": MoMeta("FabricEnclosurePhEp", "fabricEnclosurePhEp", "enc-ep-ven-[vendor]-mod-[model]-ser-[serial]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], ['fabricDceSrv'], ['fabricEnclosurePhEpOperation', 'fabricLastAckedSlot'], ["Get"]),
    "FabricEnclosurePhEpOperation": MoMeta("FabricEnclosurePhEpOperation", "fabricEnclosurePhEpOperation", "remote-oper", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], ['fabricEnclosurePhEp'], ['faultInst'], ["Get", "Set"]),
    "FabricEnclosureSlotEp": MoMeta("FabricEnclosureSlotEp", "fabricEnclosureSlotEp", "enc-slot-[slot_id]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], ['fabricChassisEp'], ['fabricEnclosureSlotEpOperation'], ["Get"]),
    "FabricEnclosureSlotEpOperation": MoMeta("FabricEnclosureSlotEpOperation", "fabricEnclosureSlotEpOperation", "remote-oper", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], ['fabricEnclosureSlotEp'], ['faultInst'], ["Get", "Set"]),
    "FabricEp": MoMeta("FabricEp", "fabricEp", "fabric", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin"], ['computeSystem', 'fabricSystem', 'orgDomainGroup'], ['fabricCabling', 'fabricDceSrv', 'fabricEthEstcCloud', 'fabricFcEstcCloud', 'fabricLanAccessMgr', 'fabricLanCloud', 'fabricLanMonCloud', 'fabricSanCloud', 'fabricSanMonCloud'], ["Get"]),
    "FabricEthEstc": MoMeta("FabricEthEstc", "fabricEthEstc", "[id]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], ['fabricEthEstcCloud'], ['fabricEthEstcEp', 'fabricEthEstcEpOperation', 'fabricEthEstcPc', 'fabricEthEstcPcOperation', 'fabricSubGroup'], ["Get"]),
    "FabricEthEstcCloud": MoMeta("FabricEthEstcCloud", "fabricEthEstcCloud", "eth-estc", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], ['fabricEp'], ['fabricEthEstc', 'fabricVlan', 'nwctrlDefinition', 'statsThresholdPolicy'], ["Get"]),
    "FabricEthEstcEp": MoMeta("FabricEthEstcEp", "fabricEthEstcEp", "phys-eth-slot-[slot_id]-port-[port_id]", VersionMeta.Version121a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], ['fabricEthEstc', 'fabricSubGroup'], ['fabricEthMonSrcEp', 'fabricEthTargetEp', 'fabricVlanEp', 'faultInst'], ["Get", "Set"]),
    "FabricEthEstcEpOperation": MoMeta("FabricEthEstcEpOperation", "fabricEthEstcEpOperation", "remoper-phys-eth-slot-[slot_id]-port-[port_id]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], ['fabricEthEstc', 'fabricSubGroup'], ['eventInst', 'fabricEthEstcEpOperationFsm', 'fabricEthMonSrcEpOperation', 'fabricEthPortOperationFsm', 'fabricEthTargetEpOperation', 'fabricFIPortOperationFsm', 'fabricFIPortOperationFsmTask', 'faultInst', 'messageEp', 'vnicEther'], ["Add", "Get", "Remove", "Set"]),
    "FabricEthEstcEpOperationFsm": MoMeta("FabricEthEstcEpOperationFsm", "fabricEthEstcEpOperationFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['fabricEthEstcEpOperation'], ['fabricEthEstcEpOperationFsmStage'], [None]),
    "FabricEthEstcEpOperationFsmStage": MoMeta("FabricEthEstcEpOperationFsmStage", "fabricEthEstcEpOperationFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['fabricEthEstcEpOperationFsm'], [], [None]),
    "FabricEthEstcPc": MoMeta("FabricEthEstcPc", "fabricEthEstcPc", "pc-[port_id]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], ['fabricEthEstc'], ['fabricEthEstcPcEp', 'fabricEthMonSrcEp', 'fabricEthMonSrcEpOperation', 'fabricEthTargetEp', 'fabricSubGroup', 'fabricVlanEp', 'faultInst'], ["Get"]),
    "FabricEthEstcPcEp": MoMeta("FabricEthEstcPcEp", "fabricEthEstcPcEp", "ep-slot-[slot_id]-port-[port_id]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], ['fabricEthEstcPc', 'fabricSubGroup'], [], ["Add", "Get", "Remove", "Set"]),
    "FabricEthEstcPcEpOperation": MoMeta("FabricEthEstcPcEpOperation", "fabricEthEstcPcEpOperation", "remoper-ep-slot-[slot_id]-port-[port_id]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], ['fabricEthEstcPcOperation', 'fabricSubGroup'], ['faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FabricEthEstcPcOperation": MoMeta("FabricEthEstcPcOperation", "fabricEthEstcPcOperation", "remoper-pc-[port_id]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], ['fabricEthEstc'], ['eventInst', 'fabricEthEstcPcEpOperation', 'fabricEthEstcPcOperationFsm', 'fabricEthPortOperationFsm', 'fabricEthTargetEpOperation', 'fabricFIPortOperationFsm', 'fabricFIPortOperationFsmTask', 'fabricSubGroup', 'faultInst', 'messageEp', 'vnicEther'], ["Add", "Get", "Remove", "Set"]),
    "FabricEthEstcPcOperationFsm": MoMeta("FabricEthEstcPcOperationFsm", "fabricEthEstcPcOperationFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['fabricEthEstcPcOperation'], ['fabricEthEstcPcOperationFsmStage'], [None]),
    "FabricEthEstcPcOperationFsmStage": MoMeta("FabricEthEstcPcOperationFsmStage", "fabricEthEstcPcOperationFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['fabricEthEstcPcOperationFsm'], [], [None]),
    "FabricEthLan": MoMeta("FabricEthLan", "fabricEthLan", "[id]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], ['fabricLanCloud'], ['fabricEthLanEp', 'fabricEthLanEpOperation', 'fabricEthLanPc', 'fabricEthLanPcOperation', 'fabricNetGroup', 'fabricSubGroup'], ["Get"]),
    "FabricEthLanEp": MoMeta("FabricEthLanEp", "fabricEthLanEp", "phys-slot-[slot_id]-port-[port_id]", VersionMeta.Version121a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], ['fabricEthLan', 'fabricSubGroup'], ['fabricEthMonSrcEp', 'fabricNetGroupEp', 'fabricVlanEp', 'faultInst'], ["Get", "Set"]),
    "FabricEthLanEpOperation": MoMeta("FabricEthLanEpOperation", "fabricEthLanEpOperation", "remoper-phys-slot-[slot_id]-port-[port_id]", VersionMeta.Version121a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], ['fabricEthLan', 'fabricSubGroup'], ['eventInst', 'fabricEthLanEpOperationFsm', 'fabricEthMonSrcEpOperation', 'fabricEthPortOperationFsm', 'fabricFIPortOperationFsm', 'fabricFIPortOperationFsmTask', 'faultInst', 'messageEp', 'vnicEther'], ["Get", "Set"]),
    "FabricEthLanEpOperationFsm": MoMeta("FabricEthLanEpOperationFsm", "fabricEthLanEpOperationFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['fabricEthLanEpOperation'], ['fabricEthLanEpOperationFsmStage'], [None]),
    "FabricEthLanEpOperationFsmStage": MoMeta("FabricEthLanEpOperationFsmStage", "fabricEthLanEpOperationFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['fabricEthLanEpOperationFsm'], [], [None]),
    "FabricEthLanPc": MoMeta("FabricEthLanPc", "fabricEthLanPc", "pc-[port_id]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], ['fabricEthLan'], ['fabricEthLanPcEp', 'fabricEthMonSrcEp', 'fabricNetGroupEp', 'fabricSubGroup', 'fabricVlanEp', 'faultInst'], ["Get"]),
    "FabricEthLanPcEp": MoMeta("FabricEthLanPcEp", "fabricEthLanPcEp", "ep-slot-[slot_id]-port-[port_id]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], ['fabricEthLanPc', 'fabricSubGroup'], ['faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FabricEthLanPcEpOperation": MoMeta("FabricEthLanPcEpOperation", "fabricEthLanPcEpOperation", "remoper-ep-slot-[slot_id]-port-[port_id]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], ['fabricEthLanPcOperation', 'fabricSubGroup'], ['faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FabricEthLanPcOperation": MoMeta("FabricEthLanPcOperation", "fabricEthLanPcOperation", "remoper-pc-[port_id]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], ['fabricEthLan'], ['eventInst', 'fabricEthLanPcEpOperation', 'fabricEthLanPcOperationFsm', 'fabricEthMonSrcEpOperation', 'fabricEthPortOperationFsm', 'fabricFIPortOperationFsm', 'fabricFIPortOperationFsmTask', 'fabricSubGroup', 'faultInst', 'messageEp', 'vnicEther'], ["Add", "Get", "Remove", "Set"]),
    "FabricEthLanPcOperationFsm": MoMeta("FabricEthLanPcOperationFsm", "fabricEthLanPcOperationFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['fabricEthLanPcOperation'], ['fabricEthLanPcOperationFsmStage'], [None]),
    "FabricEthLanPcOperationFsmStage": MoMeta("FabricEthLanPcOperationFsmStage", "fabricEthLanPcOperationFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['fabricEthLanPcOperationFsm'], [], [None]),
    "FabricEthLinkProfile": MoMeta("FabricEthLinkProfile", "fabricEthLinkProfile", "eth-link-prof-[name]", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], ['fabricLanCloud', 'orgDomainGroup'], ['faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FabricEthMon": MoMeta("FabricEthMon", "fabricEthMon", "eth-mon-[name]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], ['fabricEthMonLan'], ['fabricEthMonDestEp', 'fabricEthMonSrcRef', 'fabricSubGroup'], ["Get"]),
    "FabricEthMonDestEp": MoMeta("FabricEthMonDestEp", "fabricEthMonDestEp", "dest-slot-[slot_id]-port-[port_id]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], ['fabricEthMon', 'fabricEthMonOperation', 'fabricFcMon', 'fabricSubGroup'], [], ["Get"]),
    "FabricEthMonDestEpOperation": MoMeta("FabricEthMonDestEpOperation", "fabricEthMonDestEpOperation", "remoper-dest-slot-[slot_id]-port-[port_id]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], ['fabricEthMonOperation', 'fabricFcMonOperation', 'fabricSubGroup'], ['faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FabricEthMonLan": MoMeta("FabricEthMonLan", "fabricEthMonLan", "[id]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], ['fabricLanMonCloud'], ['fabricEthMon', 'fabricEthMonOperation'], ["Get"]),
    "FabricEthMonOperation": MoMeta("FabricEthMonOperation", "fabricEthMonOperation", "remoper-eth-mon-[name]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], ['fabricEthMonLan'], ['eventInst', 'fabricEthMonDestEp', 'fabricEthMonDestEpOperation', 'fabricEthMonOperationFsm', 'fabricEthPortOperationFsm', 'fabricFIPortOperationFsm', 'fabricFIPortOperationFsmTask', 'fabricSubGroup', 'faultInst', 'messageEp', 'vnicEther'], ["Add", "Get", "Remove", "Set"]),
    "FabricEthMonOperationFsm": MoMeta("FabricEthMonOperationFsm", "fabricEthMonOperationFsm", "fsm", VersionMeta.Version151a, "OutputOnly", 0x1, [], [""], ['fabricEthMonOperation'], ['fabricEthMonOperationFsmStage'], [None]),
    "FabricEthMonOperationFsmStage": MoMeta("FabricEthMonOperationFsmStage", "fabricEthMonOperationFsmStage", "stage-[name]", VersionMeta.Version151a, "OutputOnly", 0x1, [], [""], ['fabricEthMonOperationFsm'], [], [None]),
    "FabricEthMonSrcEp": MoMeta("FabricEthMonSrcEp", "fabricEthMonSrcEp", "mon-src-[name]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], ['adaptorExtEthIf', 'fabricDceSwSrvEp', 'fabricEthEstcEp', 'fabricEthEstcPc', 'fabricEthLanEp', 'fabricEthLanPc', 'fabricFcoeEstcEp', 'fabricFcoeSanEp', 'fabricFcoeSanPc', 'fabricVlan', 'vmNic', 'vnicEther', 'vnicFc', 'vnicIScsi', 'vnicIScsiLCP', 'vnicIniGrpFc', 'vnicIniGrpFcB', 'vnicLstorageIScsi', 'vnicMgmt', 'vnicMonSesFc'], [], ["Get"]),
    "FabricEthMonSrcEpOperation": MoMeta("FabricEthMonSrcEpOperation", "fabricEthMonSrcEpOperation", "remoper-mon-src-[name]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], ['adaptorExtEthIf', 'fabricDceSwSrvEp', 'fabricEthEstcEpOperation', 'fabricEthEstcPc', 'fabricEthLanEpOperation', 'fabricEthLanPcOperation', 'fabricFcoeEstcEpOperation', 'fabricFcoeSanEpOperation', 'fabricFcoeSanPcOperation', 'fabricVlan', 'vnicEther'], ['faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FabricEthMonSrcRef": MoMeta("FabricEthMonSrcRef", "fabricEthMonSrcRef", "src-ref-[id]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], ['fabricEthMon'], [], ["Get"]),
    "FabricEthPortOperationFsm": MoMeta("FabricEthPortOperationFsm", "fabricEthPortOperationFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['fabricDceSwSrvPcOperation', 'fabricEthEstcEpOperation', 'fabricEthEstcPcOperation', 'fabricEthLanEpOperation', 'fabricEthLanPcOperation', 'fabricEthMonOperation'], ['fabricEthPortOperationFsmStage'], [None]),
    "FabricEthPortOperationFsmStage": MoMeta("FabricEthPortOperationFsmStage", "fabricEthPortOperationFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['fabricEthPortOperationFsm'], [], [None]),
    "FabricEthTargetEp": MoMeta("FabricEthTargetEp", "fabricEthTargetEp", "eth-target-ep-[name]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], ['fabricEthEstcEp', 'fabricEthEstcPc'], [], ["Add", "Get", "Remove", "Set"]),
    "FabricEthTargetEpOperation": MoMeta("FabricEthTargetEpOperation", "fabricEthTargetEpOperation", "remoper-eth-target-ep-[name]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], ['fabricEthEstcEpOperation', 'fabricEthEstcPcOperation'], ['faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FabricEthVlanPc": MoMeta("FabricEthVlanPc", "fabricEthVlanPc", "pc-switch-[switch_id]-pc-[port_id]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], ['fabricNetGroup', 'fabricVlan'], [], ["Add", "Get", "Remove", "Set"]),
    "FabricEthVlanPortEp": MoMeta("FabricEthVlanPortEp", "fabricEthVlanPortEp", "phys-switch-[switch_id]-slot-[slot_id]-port-[port_id]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], ['fabricNetGroup', 'fabricSwSubGroup', 'fabricVlan'], [], ["Add", "Get", "Remove", "Set"]),
    "FabricEtherRef": MoMeta("FabricEtherRef", "fabricEtherRef", "EtherRef-[name]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy", "ls-network"], ['adaptorVlan', 'fabricVlan', 'fabricVlanEp', 'fabricVsan', 'fabricVsanEp'], [], [None]),
    "FabricExtension": MoMeta("FabricExtension", "fabricExtension", "extension", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy", "ext-san-config", "ext-san-policy"], ['fabricVlan', 'fabricVsan'], [], [None]),
    "FabricFIPortOperationFsm": MoMeta("FabricFIPortOperationFsm", "fabricFIPortOperationFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['fabricDceSwSrvPcOperation', 'fabricEthEstcEpOperation', 'fabricEthEstcPcOperation', 'fabricEthLanEpOperation', 'fabricEthLanPcOperation', 'fabricEthMonOperation', 'fabricFcEstcEpOperation', 'fabricFcMonOperation', 'fabricFcSanEpOperation', 'fabricFcSanPcOperation', 'fabricFcoeEstcEpOperation', 'fabricFcoeSanEpOperation', 'fabricFcoeSanPcOperation'], ['fabricFIPortOperationFsmStage'], [None]),
    "FabricFIPortOperationFsmStage": MoMeta("FabricFIPortOperationFsmStage", "fabricFIPortOperationFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['fabricFIPortOperationFsm'], [], [None]),
    "FabricFIPortOperationFsmTask": MoMeta("FabricFIPortOperationFsmTask", "fabricFIPortOperationFsmTask", "task-[item]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['fabricDceSwSrvPcOperation', 'fabricEthEstcEpOperation', 'fabricEthEstcPcOperation', 'fabricEthLanEpOperation', 'fabricEthLanPcOperation', 'fabricEthMonOperation', 'fabricFcEstcEpOperation', 'fabricFcMonOperation', 'fabricFcSanEpOperation', 'fabricFcSanPcOperation', 'fabricFcoeEstcEpOperation', 'fabricFcoeSanEpOperation', 'fabricFcoeSanPcOperation'], [], [None]),
    "FabricFcEndpoint": MoMeta("FabricFcEndpoint", "fabricFcEndpoint", "endpoint-[wwpn]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], ['fabricFcUserZone'], [], [None]),
    "FabricFcEstc": MoMeta("FabricFcEstc", "fabricFcEstc", "[id]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], ['fabricFcEstcCloud'], ['fabricFcEstcEp', 'fabricFcEstcEpOperation', 'fabricFcoeEstcEp', 'fabricFcoeEstcEpOperation', 'fabricSubGroup', 'fabricVsan'], ["Get"]),
    "FabricFcEstcCloud": MoMeta("FabricFcEstcCloud", "fabricFcEstcCloud", "fc-estc", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], ['fabricEp'], ['fabricFcEstc', 'fabricFcZoneProfile', 'fabricFcZoneProfileIvt', 'fabricVsan', 'statsThresholdPolicy'], ["Get"]),
    "FabricFcEstcEp": MoMeta("FabricFcEstcEp", "fabricFcEstcEp", "phys-fc-slot-[slot_id]-port-[port_id]", VersionMeta.Version121a, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], ['fabricFcEstc'], ['fabricFcMonSrcEp', 'fabricVsanEp'], ["Get", "Set"]),
    "FabricFcEstcEpOperation": MoMeta("FabricFcEstcEpOperation", "fabricFcEstcEpOperation", "remoper-phys-fc-slot-[slot_id]-port-[port_id]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], ['fabricFcEstc'], ['eventInst', 'fabricFIPortOperationFsm', 'fabricFIPortOperationFsmTask', 'fabricFcEstcEpOperationFsm', 'fabricFcMonSrcEpOperation', 'fabricFcPortOperationFsm', 'faultInst', 'messageEp', 'vnicFc', 'vnicMonSesFc'], ["Add", "Get", "Remove", "Set"]),
    "FabricFcEstcEpOperationFsm": MoMeta("FabricFcEstcEpOperationFsm", "fabricFcEstcEpOperationFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['fabricFcEstcEpOperation'], ['fabricFcEstcEpOperationFsmStage'], [None]),
    "FabricFcEstcEpOperationFsmStage": MoMeta("FabricFcEstcEpOperationFsmStage", "fabricFcEstcEpOperationFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['fabricFcEstcEpOperationFsm'], [], [None]),
    "FabricFcMon": MoMeta("FabricFcMon", "fabricFcMon", "fc-mon-[name]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], ['fabricFcMonSan'], ['fabricEthMonDestEp', 'fabricFcMonDestEp', 'fabricFcMonSrcRef', 'fabricSubGroup'], ["Get"]),
    "FabricFcMonDestEp": MoMeta("FabricFcMonDestEp", "fabricFcMonDestEp", "dest-slot-[slot_id]-port-[port_id]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], ['fabricFcMon', 'fabricFcMonOperation'], [], ["Get"]),
    "FabricFcMonDestEpOperation": MoMeta("FabricFcMonDestEpOperation", "fabricFcMonDestEpOperation", "remoper-dest-slot-[slot_id]-port-[port_id]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], ['fabricFcMonOperation', 'fabricSubGroup'], ['faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FabricFcMonOperation": MoMeta("FabricFcMonOperation", "fabricFcMonOperation", "remoper-fc-mon-[name]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], ['fabricFcMonSan'], ['eventInst', 'fabricEthMonDestEpOperation', 'fabricFIPortOperationFsm', 'fabricFIPortOperationFsmTask', 'fabricFcMonDestEp', 'fabricFcMonDestEpOperation', 'fabricFcMonOperationFsm', 'fabricFcPortOperationFsm', 'fabricSubGroup', 'faultInst', 'messageEp', 'vnicFc', 'vnicMonSesFc'], ["Add", "Get", "Remove", "Set"]),
    "FabricFcMonOperationFsm": MoMeta("FabricFcMonOperationFsm", "fabricFcMonOperationFsm", "fsm", VersionMeta.Version151a, "OutputOnly", 0x1, [], [""], ['fabricFcMonOperation'], ['fabricFcMonOperationFsmStage'], [None]),
    "FabricFcMonOperationFsmStage": MoMeta("FabricFcMonOperationFsmStage", "fabricFcMonOperationFsmStage", "stage-[name]", VersionMeta.Version151a, "OutputOnly", 0x1, [], [""], ['fabricFcMonOperationFsm'], [], [None]),
    "FabricFcMonSan": MoMeta("FabricFcMonSan", "fabricFcMonSan", "[id]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], ['fabricSanMonCloud'], ['fabricFcMon', 'fabricFcMonOperation'], ["Get"]),
    "FabricFcMonSrcEp": MoMeta("FabricFcMonSrcEp", "fabricFcMonSrcEp", "mon-src-[name]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], ['fabricFcEstcEp', 'fabricFcSanEp', 'fabricFcSanPc', 'fabricVsan', 'vmNic', 'vnicEther', 'vnicFc', 'vnicIScsi', 'vnicIScsiLCP', 'vnicIniGrpFc', 'vnicIniGrpFcB', 'vnicLstorageIScsi', 'vnicMgmt', 'vnicMonSesFc'], [], ["Get"]),
    "FabricFcMonSrcEpOperation": MoMeta("FabricFcMonSrcEpOperation", "fabricFcMonSrcEpOperation", "remoper-mon-src-[name]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], ['fabricFcEstcEpOperation', 'fabricFcSanEpOperation', 'fabricFcSanPcOperation', 'fabricVsan', 'vnicFc'], ['faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FabricFcMonSrcRef": MoMeta("FabricFcMonSrcRef", "fabricFcMonSrcRef", "src-ref-[id]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], ['fabricFcMon'], [], ["Get"]),
    "FabricFcPortOperationFsm": MoMeta("FabricFcPortOperationFsm", "fabricFcPortOperationFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['fabricFcEstcEpOperation', 'fabricFcMonOperation', 'fabricFcSanEpOperation', 'fabricFcSanPcOperation', 'fabricFcoeEstcEpOperation', 'fabricFcoeSanEpOperation', 'fabricFcoeSanPcOperation'], ['fabricFcPortOperationFsmStage'], [None]),
    "FabricFcPortOperationFsmStage": MoMeta("FabricFcPortOperationFsmStage", "fabricFcPortOperationFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['fabricFcPortOperationFsm'], [], [None]),
    "FabricFcSan": MoMeta("FabricFcSan", "fabricFcSan", "[id]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], ['fabricSanCloud'], ['fabricFcSanEp', 'fabricFcSanEpOperation', 'fabricFcSanPc', 'fabricFcSanPcOperation', 'fabricFcoeSanEp', 'fabricFcoeSanEpOperation', 'fabricFcoeSanPc', 'fabricFcoeSanPcOperation', 'fabricSubGroup', 'fabricVsan'], ["Get", "Set"]),
    "FabricFcSanEp": MoMeta("FabricFcSanEp", "fabricFcSanEp", "phys-slot-[slot_id]-port-[port_id]", VersionMeta.Version121a, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], ['fabricFcSan'], ['fabricFcMonSrcEp', 'fabricVsanEp', 'fabricVsanMembership'], ["Add", "Get", "Set"]),
    "FabricFcSanEpOperation": MoMeta("FabricFcSanEpOperation", "fabricFcSanEpOperation", "remoper-phys-slot-[slot_id]-port-[port_id]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], ['fabricFcSan'], ['eventInst', 'fabricFIPortOperationFsm', 'fabricFIPortOperationFsmTask', 'fabricFcMonSrcEpOperation', 'fabricFcPortOperationFsm', 'fabricFcSanEpOperationFsm', 'faultInst', 'messageEp', 'vnicFc', 'vnicMonSesFc'], ["Add", "Get", "Remove", "Set"]),
    "FabricFcSanEpOperationFsm": MoMeta("FabricFcSanEpOperationFsm", "fabricFcSanEpOperationFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['fabricFcSanEpOperation'], ['fabricFcSanEpOperationFsmStage'], [None]),
    "FabricFcSanEpOperationFsmStage": MoMeta("FabricFcSanEpOperationFsmStage", "fabricFcSanEpOperationFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['fabricFcSanEpOperationFsm'], [], [None]),
    "FabricFcSanPc": MoMeta("FabricFcSanPc", "fabricFcSanPc", "pc-[port_id]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], ['fabricFcSan'], ['fabricFcMonSrcEp', 'fabricFcSanPcEp', 'fabricVsanEp'], [None]),
    "FabricFcSanPcEp": MoMeta("FabricFcSanPcEp", "fabricFcSanPcEp", "ep-slot-[slot_id]-port-[port_id]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], ['fabricFcSanPc'], [], ["Get"]),
    "FabricFcSanPcEpOperation": MoMeta("FabricFcSanPcEpOperation", "fabricFcSanPcEpOperation", "remoper-ep-slot-[slot_id]-port-[port_id]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], ['fabricFcSanPcOperation'], ['faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FabricFcSanPcOperation": MoMeta("FabricFcSanPcOperation", "fabricFcSanPcOperation", "remoper-pc-[port_id]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], ['fabricFcSan'], ['eventInst', 'fabricFIPortOperationFsm', 'fabricFIPortOperationFsmTask', 'fabricFcMonSrcEpOperation', 'fabricFcPortOperationFsm', 'fabricFcSanPcEpOperation', 'fabricFcSanPcOperationFsm', 'faultInst', 'messageEp', 'vnicFc', 'vnicMonSesFc'], ["Add", "Get", "Remove", "Set"]),
    "FabricFcSanPcOperationFsm": MoMeta("FabricFcSanPcOperationFsm", "fabricFcSanPcOperationFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['fabricFcSanPcOperation'], ['fabricFcSanPcOperationFsmStage'], [None]),
    "FabricFcSanPcOperationFsmStage": MoMeta("FabricFcSanPcOperationFsmStage", "fabricFcSanPcOperationFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['fabricFcSanPcOperationFsm'], [], [None]),
    "FabricFcUplinkOperation": MoMeta("FabricFcUplinkOperation", "fabricFcUplinkOperation", "remote-oper", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], ['fabricSanCloud'], ['faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FabricFcUserZone": MoMeta("FabricFcUserZone", "fabricFcUserZone", "zone-[name]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], ['fabricFcZoneProfile'], ['fabricFcEndpoint', 'messageEp', 'storageVsanRef'], [None]),
    "FabricFcUserZoneIvt": MoMeta("FabricFcUserZoneIvt", "fabricFcUserZoneIvt", "zone-ivt-[name]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], ['fabricFcZoneProfileIvt'], ['storageVsanRefIvt'], [None]),
    "FabricFcVsanPc": MoMeta("FabricFcVsanPc", "fabricFcVsanPc", "pc-switch-[switch_id]-pc-[port_id]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], ['fabricVsan'], [], ["Add", "Get", "Remove", "Set"]),
    "FabricFcVsanPortEp": MoMeta("FabricFcVsanPortEp", "fabricFcVsanPortEp", "phys-switch-[switch_id]-slot-[slot_id]-port-[port_id]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], ['fabricVsan'], [], ["Add", "Get", "Remove", "Set"]),
    "FabricFcZoneProfile": MoMeta("FabricFcZoneProfile", "fabricFcZoneProfile", "zone-profile-[name]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], ['fabricFcEstcCloud'], ['eventInst', 'fabricFcUserZone', 'fabricFcZoneProfileFsm', 'fabricFcZoneProfileFsmTask', 'faultInst'], [None]),
    "FabricFcZoneProfileFsm": MoMeta("FabricFcZoneProfileFsm", "fabricFcZoneProfileFsm", "fsm", VersionMeta.Version201b, "OutputOnly", 0x1, [], [""], ['fabricFcZoneProfile'], ['fabricFcZoneProfileFsmStage'], [None]),
    "FabricFcZoneProfileFsmStage": MoMeta("FabricFcZoneProfileFsmStage", "fabricFcZoneProfileFsmStage", "stage-[name]", VersionMeta.Version201b, "OutputOnly", 0x1, [], [""], ['fabricFcZoneProfileFsm'], [], [None]),
    "FabricFcZoneProfileFsmTask": MoMeta("FabricFcZoneProfileFsmTask", "fabricFcZoneProfileFsmTask", "task-[item]", VersionMeta.Version201b, "OutputOnly", 0x1, [], [""], ['fabricFcZoneProfile'], [], [None]),
    "FabricFcZoneProfileIvt": MoMeta("FabricFcZoneProfileIvt", "fabricFcZoneProfileIvt", "zone-profile-ivt-[name]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], ['fabricFcEstcCloud'], ['fabricFcUserZoneIvt'], [None]),
    "FabricFcoeEstcEp": MoMeta("FabricFcoeEstcEp", "fabricFcoeEstcEp", "phys-fcoe-slot-[slot_id]-port-[port_id]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], ['fabricFcEstc', 'fabricSubGroup'], ['etherFcoeInterfaceStats', 'fabricEthMonSrcEp', 'fabricVsanEp', 'fabricVsanMembership', 'faultInst'], ["Get", "Set"]),
    "FabricFcoeEstcEpOperation": MoMeta("FabricFcoeEstcEpOperation", "fabricFcoeEstcEpOperation", "remoper-phys-fcoe-slot-[slot_id]-port-[port_id]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], ['fabricFcEstc', 'fabricSubGroup'], ['eventInst', 'fabricEthMonSrcEpOperation', 'fabricFIPortOperationFsm', 'fabricFIPortOperationFsmTask', 'fabricFcPortOperationFsm', 'fabricFcoeEstcEpOperationFsm', 'faultInst', 'messageEp', 'vnicFc', 'vnicMonSesFc'], ["Add", "Get", "Remove", "Set"]),
    "FabricFcoeEstcEpOperationFsm": MoMeta("FabricFcoeEstcEpOperationFsm", "fabricFcoeEstcEpOperationFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['fabricFcoeEstcEpOperation'], ['fabricFcoeEstcEpOperationFsmStage'], [None]),
    "FabricFcoeEstcEpOperationFsmStage": MoMeta("FabricFcoeEstcEpOperationFsmStage", "fabricFcoeEstcEpOperationFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['fabricFcoeEstcEpOperationFsm'], [], [None]),
    "FabricFcoeSanEp": MoMeta("FabricFcoeSanEp", "fabricFcoeSanEp", "phys-fcoesanep-slot-[slot_id]-port-[port_id]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], ['fabricFcSan', 'fabricSubGroup'], ['fabricEthMonSrcEp', 'fabricVsanEp', 'fabricVsanMembership', 'faultInst'], ["Get", "Set"]),
    "FabricFcoeSanEpOperation": MoMeta("FabricFcoeSanEpOperation", "fabricFcoeSanEpOperation", "remoper-phys-fcoesanep-slot-[slot_id]-port-[port_id]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], ['fabricFcSan', 'fabricSubGroup'], ['eventInst', 'fabricEthMonSrcEpOperation', 'fabricFIPortOperationFsm', 'fabricFIPortOperationFsmTask', 'fabricFcPortOperationFsm', 'fabricFcoeSanEpOperationFsm', 'faultInst', 'messageEp', 'vnicFc', 'vnicMonSesFc'], ["Add", "Get", "Remove", "Set"]),
    "FabricFcoeSanEpOperationFsm": MoMeta("FabricFcoeSanEpOperationFsm", "fabricFcoeSanEpOperationFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['fabricFcoeSanEpOperation'], ['fabricFcoeSanEpOperationFsmStage'], [None]),
    "FabricFcoeSanEpOperationFsmStage": MoMeta("FabricFcoeSanEpOperationFsmStage", "fabricFcoeSanEpOperationFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['fabricFcoeSanEpOperationFsm'], [], [None]),
    "FabricFcoeSanPc": MoMeta("FabricFcoeSanPc", "fabricFcoeSanPc", "fcoesanpc-[port_id]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], ['fabricFcSan'], ['fabricEthMonSrcEp', 'fabricFcoeSanPcEp', 'fabricSubGroup', 'faultInst'], [None]),
    "FabricFcoeSanPcEp": MoMeta("FabricFcoeSanPcEp", "fabricFcoeSanPcEp", "fcoesanpcep-slot-[slot_id]-port-[port_id]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], ['fabricFcoeSanPc', 'fabricSubGroup'], ['faultInst'], ["Get"]),
    "FabricFcoeSanPcEpOperation": MoMeta("FabricFcoeSanPcEpOperation", "fabricFcoeSanPcEpOperation", "remoper-fcoesanpcep-slot-[slot_id]-port-[port_id]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], ['fabricFcoeSanPcOperation', 'fabricSubGroup'], ['faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FabricFcoeSanPcOperation": MoMeta("FabricFcoeSanPcOperation", "fabricFcoeSanPcOperation", "remoper-fcoesanpc-[port_id]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], ['fabricFcSan'], ['eventInst', 'fabricEthMonSrcEpOperation', 'fabricFIPortOperationFsm', 'fabricFIPortOperationFsmTask', 'fabricFcPortOperationFsm', 'fabricFcoeSanPcEpOperation', 'fabricFcoeSanPcOperationFsm', 'fabricSubGroup', 'faultInst', 'messageEp', 'vnicFc', 'vnicMonSesFc'], ["Add", "Get", "Remove", "Set"]),
    "FabricFcoeSanPcOperationFsm": MoMeta("FabricFcoeSanPcOperationFsm", "fabricFcoeSanPcOperationFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['fabricFcoeSanPcOperation'], ['fabricFcoeSanPcOperationFsmStage'], [None]),
    "FabricFcoeSanPcOperationFsmStage": MoMeta("FabricFcoeSanPcOperationFsmStage", "fabricFcoeSanPcOperationFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['fabricFcoeSanPcOperationFsm'], [], [None]),
    "FabricFcoeVsanPc": MoMeta("FabricFcoeVsanPc", "fabricFcoeVsanPc", "fcoepc-switch-[switch_id]-fcoepc-[port_id]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], ['fabricVsan'], [], ["Add", "Get", "Remove", "Set"]),
    "FabricFcoeVsanPortEp": MoMeta("FabricFcoeVsanPortEp", "fabricFcoeVsanPortEp", "phys-fcoe-switch-[switch_id]-slot-[slot_id]-port-[port_id]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], ['fabricSwSubGroup', 'fabricVsan'], [], ["Add", "Get", "Remove", "Set"]),
    "FabricHolder": MoMeta("FabricHolder", "fabricHolder", "holder", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin"], ['topRoot'], ['fabricDomainEp', 'tagDefEp', 'tagInstanceEp'], ["Get"]),
    "FabricIf": MoMeta("FabricIf", "fabricIf", "mgmt-if-[id]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], [], [], ["Get"]),
    "FabricLacpPolicy": MoMeta("FabricLacpPolicy", "fabricLacpPolicy", "lacp-[name]", VersionMeta.Version121a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], ['orgDomainGroup', 'orgOrg'], [], ["Add", "Get", "Remove", "Set"]),
    "FabricLanAccessMgr": MoMeta("FabricLanAccessMgr", "fabricLanAccessMgr", "lan-access", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['fabricEp'], [], [None]),
    "FabricLanCloud": MoMeta("FabricLanCloud", "fabricLanCloud", "lan", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], ['fabricEp'], ['extvmmNetworkSets', 'extvmmVMNetworkSets', 'fabricEthLan', 'fabricEthLinkProfile', 'fabricLanPinGroup', 'fabricLanPinGroupOperation', 'fabricNetGroup', 'fabricUdldLinkPolicy', 'fabricVlan', 'firmwareAck', 'flowctrlDefinition', 'mgmtInbandProfile', 'qosclassDefinition', 'statsThresholdPolicy', 'vnicNetGroup', 'vnicProfileSet'], ["Get", "Set"]),
    "FabricLanCloudPolicy": MoMeta("FabricLanCloudPolicy", "fabricLanCloudPolicy", "lan-policy", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], ['orgDomainGroup', 'orgOrg'], [], ["Get", "Set"]),
    "FabricLanMonCloud": MoMeta("FabricLanMonCloud", "fabricLanMonCloud", "lanmon", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], ['fabricEp'], ['fabricEthMonLan', 'statsThresholdPolicy'], ["Get"]),
    "FabricLanPinGroup": MoMeta("FabricLanPinGroup", "fabricLanPinGroup", "lan-pin-group-[name]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], ['fabricLanCloud'], ['fabricLanPinTarget'], ["Get"]),
    "FabricLanPinGroupOperation": MoMeta("FabricLanPinGroupOperation", "fabricLanPinGroupOperation", "remoper-lan-pin-group-[name]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], ['fabricLanCloud'], ['fabricLanPinTargetOperation', 'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FabricLanPinTarget": MoMeta("FabricLanPinTarget", "fabricLanPinTarget", "target-[fabric_id]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], ['fabricLanPinGroup'], [], ["Get"]),
    "FabricLanPinTargetOperation": MoMeta("FabricLanPinTargetOperation", "fabricLanPinTargetOperation", "remoper-target-[fabric_id]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], ['fabricLanPinGroupOperation'], ['faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FabricLastAckedSlot": MoMeta("FabricLastAckedSlot", "fabricLastAckedSlot", "last-acked-slot", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], ['fabricEnclosurePhEp'], [], ["Get"]),
    "FabricMulticastPolicy": MoMeta("FabricMulticastPolicy", "fabricMulticastPolicy", "mc-policy-[name]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], ['orgDomainGroup'], [], ["Add", "Get", "Remove", "Set"]),
    "FabricNetGroup": MoMeta("FabricNetGroup", "fabricNetGroup", "net-group-[name]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy", "ls-network"], ['fabricEthLan', 'fabricLanCloud'], ['fabricEthVlanPc', 'fabricEthVlanPortEp', 'fabricPooledVlan', 'fabricSwSubGroup'], ["Add", "Get", "Remove", "Set"]),
    "FabricNetGroupEp": MoMeta("FabricNetGroupEp", "fabricNetGroupEp", "ng-ep-[name]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], ['fabricEthLanEp', 'fabricEthLanPc'], [], [None]),
    "FabricNetGroupPermit": MoMeta("FabricNetGroupPermit", "fabricNetGroupPermit", "ng-permit-[name]", VersionMeta.Version201b, "InputOutput", 0x1, [], [""], ['orgOrg'], [], [None]),
    "FabricNetGroupRef": MoMeta("FabricNetGroupRef", "fabricNetGroupRef", "net-group-ref-[name]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy", "ls-config", "ls-network", "ls-server"], ['dcxVc', 'vnicEther', 'vnicLanConnTempl', 'vnicSanConnTempl'], ['faultInst'], [None]),
    "FabricNetGroupReq": MoMeta("FabricNetGroupReq", "fabricNetGroupReq", "ngreq-[name]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy", "ls-network"], ['orgOrg'], [], [None]),
    "FabricOrgVlanPolicy": MoMeta("FabricOrgVlanPolicy", "fabricOrgVlanPolicy", "org-vlan-policy", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-network"], ['orgOrg'], [], ["Get", "Set"]),
    "FabricPoolableVlan": MoMeta("FabricPoolableVlan", "fabricPoolableVlan", "pool-[id]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "FabricPooledVlan": MoMeta("FabricPooledVlan", "fabricPooledVlan", "net-[name]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], ['fabricNetGroup'], [], ["Add", "Get", "Remove"]),
    "FabricSanCloud": MoMeta("FabricSanCloud", "fabricSanCloud", "san", VersionMeta.Version111a, "InputOutput", 0x1, [], [""], ['fabricEp'], ['fabricFcSan', 'fabricFcUplinkOperation', 'fabricSanPinGroup', 'fabricSanPinGroupOperation', 'firmwareAck', 'statsThresholdPolicy'], ["Get", "Set"]),
    "FabricSanGroup": MoMeta("FabricSanGroup", "fabricSanGroup", "san-group-[name]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "FabricSanGroupRef": MoMeta("FabricSanGroupRef", "fabricSanGroupRef", "san-group-ref-[name]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-network", "ls-server"], ['dcxVc', 'vnicLanConnTempl', 'vnicSanConnTempl'], ['faultInst'], [None]),
    "FabricSanMonCloud": MoMeta("FabricSanMonCloud", "fabricSanMonCloud", "sanmon", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], ['fabricEp'], ['fabricFcMonSan', 'statsThresholdPolicy'], ["Get"]),
    "FabricSanPinGroup": MoMeta("FabricSanPinGroup", "fabricSanPinGroup", "san-pin-group-[name]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], ['fabricSanCloud'], ['fabricSanPinTarget'], ["Get"]),
    "FabricSanPinGroupOperation": MoMeta("FabricSanPinGroupOperation", "fabricSanPinGroupOperation", "remoper-san-pin-group-[name]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], ['fabricSanCloud'], ['fabricSanPinTargetOperation', 'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FabricSanPinTarget": MoMeta("FabricSanPinTarget", "fabricSanPinTarget", "target-[fabric_id]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], ['fabricSanPinGroup'], [], ["Get"]),
    "FabricSanPinTargetOperation": MoMeta("FabricSanPinTargetOperation", "fabricSanPinTargetOperation", "remoper-target-[fabric_id]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], ['fabricSanPinGroupOperation'], ['faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FabricSubGroup": MoMeta("FabricSubGroup", "fabricSubGroup", "slot-[slot_id]-aggr-port-[aggr_port_id]", VersionMeta.Version121a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy", "ext-san-config", "ext-san-policy", "ls-network", "ls-network-policy"], ['fabricDceSwSrv', 'fabricDceSwSrvPc', 'fabricDceSwSrvPcOperation', 'fabricEthEstc', 'fabricEthEstcPc', 'fabricEthEstcPcOperation', 'fabricEthLan', 'fabricEthLanPc', 'fabricEthLanPcOperation', 'fabricEthMon', 'fabricEthMonOperation', 'fabricFcEstc', 'fabricFcMon', 'fabricFcMonOperation', 'fabricFcSan', 'fabricFcoeSanPc', 'fabricFcoeSanPcOperation'], ['fabricDceSwSrvEp', 'fabricDceSwSrvEpOperation', 'fabricDceSwSrvPcEp', 'fabricDceSwSrvPcEpOperation', 'fabricEthEstcEp', 'fabricEthEstcEpOperation', 'fabricEthEstcPcEp', 'fabricEthEstcPcEpOperation', 'fabricEthLanEp', 'fabricEthLanEpOperation', 'fabricEthLanPcEp', 'fabricEthLanPcEpOperation', 'fabricEthMonDestEp', 'fabricEthMonDestEpOperation', 'fabricFcMonDestEpOperation', 'fabricFcoeEstcEp', 'fabricFcoeEstcEpOperation', 'fabricFcoeSanEp', 'fabricFcoeSanEpOperation', 'fabricFcoeSanPcEp', 'fabricFcoeSanPcEpOperation'], ["Get", "Set"]),
    "FabricSwChPhEp": MoMeta("FabricSwChPhEp", "fabricSwChPhEp", "chassis-ep-ven-[vendor]-mod[model]-ser-[serial]", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], ['fabricDceSrv'], ['fabricSwChPhEpOperation'], ["Get", "Set"]),
    "FabricSwChPhEpOperation": MoMeta("FabricSwChPhEpOperation", "fabricSwChPhEpOperation", "remote-oper", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], ['fabricSwChPhEp'], ['faultInst'], ["Get", "Set"]),
    "FabricSwSubGroup": MoMeta("FabricSwSubGroup", "fabricSwSubGroup", "sw-[switch_id]-slot-[slot_id]-aggr-port-[aggr_port_id]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy"], ['fabricNetGroup', 'fabricVlan', 'fabricVsan'], ['fabricEthVlanPortEp', 'fabricFcoeVsanPortEp'], ["Get"]),
    "FabricSystem": MoMeta("FabricSystem", "fabricSystem", "system-[id]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin"], ['fabricDomainEp'], ['domainProfile', 'fabricEp', 'fdChassis', 'fdRackUnit', 'policyControlEp'], ["Get"]),
    "FabricUdldLinkPolicy": MoMeta("FabricUdldLinkPolicy", "fabricUdldLinkPolicy", "udld-link-pol-[name]", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy", "read-only"], ['fabricLanCloud', 'orgDomainGroup'], [], ["Add", "Get", "Remove", "Set"]),
    "FabricUdldPolicy": MoMeta("FabricUdldPolicy", "fabricUdldPolicy", "udld-policy", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], ['orgOrg'], [], ["Get", "Set"]),
    "FabricVCon": MoMeta("FabricVCon", "fabricVCon", "vcon-[id]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ext-lan-policy", "ls-network", "ls-network-policy", "ls-server-policy", "ls-storage-policy"], ['fabricVConProfile', 'lsServer'], [], ["Add", "Get", "Set"]),
    "FabricVConProfile": MoMeta("FabricVConProfile", "fabricVConProfile", "vcon-profile-[name]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['orgOrg'], ['fabricVCon'], ["Add", "Get", "Remove", "Set"]),
    "FabricVlan": MoMeta("FabricVlan", "fabricVlan", "net-[name]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], ['fabricEthEstcCloud', 'fabricLanCloud'], ['fabricConsumer', 'fabricEthMonSrcEp', 'fabricEthMonSrcEpOperation', 'fabricEthVlanPc', 'fabricEthVlanPortEp', 'fabricEtherRef', 'fabricExtension', 'fabricSwSubGroup', 'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FabricVlanEp": MoMeta("FabricVlanEp", "fabricVlanEp", "vlan-[id]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["read-only"], ['fabricEthEstcEp', 'fabricEthEstcPc', 'fabricEthLanEp', 'fabricEthLanPc'], ['fabricConsumer', 'fabricEtherRef'], ["Get"]),
    "FabricVlanGroupReq": MoMeta("FabricVlanGroupReq", "fabricVlanGroupReq", "vlan-group-req-[name]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-network"], ['orgOrg'], [], [None]),
    "FabricVlanPermit": MoMeta("FabricVlanPermit", "fabricVlanPermit", "vlan-permit-[name]", VersionMeta.Version111a, "InputOutput", 0x1, [], [""], ['orgOrg'], [], [None]),
    "FabricVlanPermitItem": MoMeta("FabricVlanPermitItem", "fabricVlanPermitItem", "vlan-permit-item-[vlan_name]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["read-only"], [], ['configOrgItem'], [None]),
    "FabricVlanReq": MoMeta("FabricVlanReq", "fabricVlanReq", "vlan-req-[name]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy", "ls-network"], ['orgOrg'], [], ["Add", "Get", "Remove"]),
    "FabricVnetEpSyncEp": MoMeta("FabricVnetEpSyncEp", "fabricVnetEpSyncEp", "syncEp", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['extpolClient'], ['eventInst', 'fabricChangedObjectRef', 'fabricVnetEpSyncEpFsm', 'fabricVnetEpSyncEpFsmTask', 'faultInst'], [None]),
    "FabricVnetEpSyncEpFsm": MoMeta("FabricVnetEpSyncEpFsm", "fabricVnetEpSyncEpFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['fabricVnetEpSyncEp'], ['fabricVnetEpSyncEpFsmStage'], [None]),
    "FabricVnetEpSyncEpFsmStage": MoMeta("FabricVnetEpSyncEpFsmStage", "fabricVnetEpSyncEpFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['fabricVnetEpSyncEpFsm'], [], [None]),
    "FabricVnetEpSyncEpFsmTask": MoMeta("FabricVnetEpSyncEpFsmTask", "fabricVnetEpSyncEpFsmTask", "task-[item]", VersionMeta.Version111a, "OutputOnly", 0x1, [], [""], ['fabricVnetEpSyncEp'], [], [None]),
    "FabricVsan": MoMeta("FabricVsan", "fabricVsan", "net-[name]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], ['fabricFcEstc', 'fabricFcEstcCloud', 'fabricFcSan'], ['fabricConsumer', 'fabricEtherRef', 'fabricExtension', 'fabricFcMonSrcEp', 'fabricFcMonSrcEpOperation', 'fabricFcVsanPc', 'fabricFcVsanPortEp', 'fabricFcoeVsanPc', 'fabricFcoeVsanPortEp', 'fabricSwSubGroup'], ["Add", "Get", "Remove", "Set"]),
    "FabricVsanEp": MoMeta("FabricVsanEp", "fabricVsanEp", "vsan-[id]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["read-only"], ['fabricFcEstcEp', 'fabricFcSanEp', 'fabricFcSanPc', 'fabricFcoeEstcEp', 'fabricFcoeSanEp'], ['fabricConsumer', 'fabricEtherRef'], ["Get"]),
    "FabricVsanMembership": MoMeta("FabricVsanMembership", "fabricVsanMembership", "vsanmember-[vsan_id]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["read-only"], ['fabricFcSanEp', 'fabricFcoeEstcEp', 'fabricFcoeSanEp'], [], ["Get"]),
    "FaultDomainEp": MoMeta("FaultDomainEp", "faultDomainEp", "domainEp", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "fault", "operations"], ['computeSystem'], ['faultDomainInst', 'faultSummaryInst'], ["Get"]),
    "FaultDomainInst": MoMeta("FaultDomainInst", "faultDomainInst", "domain-fault-[fault_code]-[id]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "fault", "operations"], ['faultDomainEp'], [], ["Get"]),
    "FaultGlobalSeverityHolder": MoMeta("FaultGlobalSeverityHolder", "faultGlobalSeverityHolder", "faultholder", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], ['computeResourceAggrEp'], [], ["Get"]),
    "FaultGlobalTypedHolder": MoMeta("FaultGlobalTypedHolder", "faultGlobalTypedHolder", "type-[type]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], ['computeResourceAggrEp'], [], ["Get"]),
    "FaultHolder": MoMeta("FaultHolder", "faultHolder", "fault", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "fault"], ['topRoot'], ['faultTypedHolder'], ["Get"]),
    "FaultInst": MoMeta("FaultInst", "faultInst", "fault-[code]", VersionMeta.Version101a, "OutputOnly", 0x1, [], ["admin", "fault", "operations"], ['aaaAuthRealm', 'aaaLdapEp', 'aaaRadiusEp', 'aaaTacacsPlusEp', 'aaaUserEp', 'adaptorExtEthIfOperation', 'adaptorHostEthIf', 'adaptorHostEthIfOperation', 'adaptorHostFcIf', 'adaptorHostFcIfOperation', 'adaptorHostIscsiIf', 'adaptorHostIscsiIfOperation', 'adaptorHostScsiIf', 'adaptorUnit', 'adaptorVlan', 'callhomeHolder', 'certRepairEp', 'changeEp', 'commDateTime', 'commSvcEp', 'computeAutoconfigPolicy', 'computeBlade', 'computeBladeInheritPolicy', 'computeBoard', 'computeCartridgeOperation', 'computeChassisConnPolicyOperation', 'computeFactoryResetOp', 'computeGroupMembership', 'computeIOHub', 'computePhysicalOperation', 'computePool', 'computeRemoteOpStatus', 'computeSystem', 'configBackup', 'configConsumerCatalogue', 'configDbConfig', 'configPasswordEncryption', 'consumerInst', 'controllerEp', 'cpmaintAck', 'diagSrvCtrlOperation', 'domainProfile', 'dupeChangeTrackerEp', 'equipmentChassis', 'equipmentChassisOperation', 'equipmentChassisProfile', 'equipmentFan', 'equipmentFanModule', 'equipmentFex', 'equipmentFexOperation', 'equipmentIOCard', 'equipmentLocatorLedOperation', 'equipmentPsu', 'equipmentRequirement', 'equipmentSystemIOControllerOperation', 'etherServerIntFIo', 'extpolClient', 'extpolController', 'extpolEp', 'extpolProvider', 'extpolRegistry', 'fabricBreakoutOperation', 'fabricCartridgeSlotEpOperation', 'fabricChangedObjectRef', 'fabricComputePhEpOperation', 'fabricComputeSlotEpOperation', 'fabricDceSwSrvEpOperation', 'fabricDceSwSrvPcEpOperation', 'fabricDceSwSrvPcOperation', 'fabricEnclosurePhEpOperation', 'fabricEnclosureSlotEpOperation', 'fabricEthEstcEp', 'fabricEthEstcEpOperation', 'fabricEthEstcPc', 'fabricEthEstcPcEpOperation', 'fabricEthEstcPcOperation', 'fabricEthLanEp', 'fabricEthLanEpOperation', 'fabricEthLanPc', 'fabricEthLanPcEp', 'fabricEthLanPcEpOperation', 'fabricEthLanPcOperation', 'fabricEthLinkProfile', 'fabricEthMonDestEpOperation', 'fabricEthMonOperation', 'fabricEthMonSrcEpOperation', 'fabricEthTargetEpOperation', 'fabricFcEstcEpOperation', 'fabricFcMonDestEpOperation', 'fabricFcMonOperation', 'fabricFcMonSrcEpOperation', 'fabricFcSanEpOperation', 'fabricFcSanPcEpOperation', 'fabricFcSanPcOperation', 'fabricFcUplinkOperation', 'fabricFcZoneProfile', 'fabricFcoeEstcEp', 'fabricFcoeEstcEpOperation', 'fabricFcoeSanEp', 'fabricFcoeSanEpOperation', 'fabricFcoeSanPc', 'fabricFcoeSanPcEp', 'fabricFcoeSanPcEpOperation', 'fabricFcoeSanPcOperation', 'fabricLanPinGroupOperation', 'fabricLanPinTargetOperation', 'fabricNetGroupRef', 'fabricSanGroupRef', 'fabricSanPinGroupOperation', 'fabricSanPinTargetOperation', 'fabricSwChPhEpOperation', 'fabricVlan', 'fabricVnetEpSyncEp', 'fcpoolAddr', 'fcpoolInitiators', 'fdBlade', 'fdRackUnit', 'firmwareAck', 'firmwareDistributable', 'firmwareDownloadPolicy', 'firmwareDownloader', 'firmwareInfra', 'firmwareSource', 'glIdentCtxResOp', 'glRequest', 'glRequestVnetEp', 'glRequestVnetEpDomainEp', 'identIdentRequest', 'identMetaSystem', 'ippoolAddr', 'ippoolIpV6Addr', 'ippoolPool', 'iqnpoolAddr', 'iqnpoolPool', 'licenseDownloader', 'licenseFile', 'licenseInstance', 'lsBinding', 'lsIdentityInfo', 'lsIssues', 'lsRequirement', 'lsSPMeta', 'lsServer', 'lsServerOperation', 'lsmaintAck', 'lsmaintMaintPolicy', 'lstorageAck', 'lstorageCtrlServiceOperation', 'lstorageDasScsiLun', 'lstorageProfileBinding', 'macpoolAddr', 'macpoolPool', 'memoryArray', 'memoryBufferUnit', 'memoryUnit', 'mgmtBackup', 'mgmtBackupOperation', 'mgmtBackupPolicy', 'mgmtBackupTrigger', 'mgmtCfgExportPolicy', 'mgmtCmcSecureBootOperation', 'mgmtDataExporter', 'mgmtDataImporter', 'mgmtIf', 'mgmtImportItem', 'mgmtImporter', 'mgmtKmipOperation', 'mgmtRegistryInfo', 'networkElement', 'networkElementOperation', 'nfsClientDef', 'nfsExportDef', 'observeObserved', 'orgDomainGroupPolicy', 'orgOrg', 'pkiEp', 'pkiKeyRing', 'pkiTP', 'policyCommunicationOp', 'policyConfigBackupOp', 'policyConfigError', 'policyControlEpOp', 'policyControlEpOperation', 'policyDateTimeOp', 'policyDiscoveryOp', 'policyDnsOp', 'policyEquipmentOp', 'policyFaultOp', 'policyInfraFirmwareOp', 'policyMEpOp', 'policyModularChassisFanOp', 'policyMonitoringOp', 'policyPolicyScope', 'policyPortConfigOp', 'policyPowerExtendedOp', 'policyPowerMgmtOp', 'policyPowerSaveOp', 'policyPsuOp', 'policySecurityOp', 'policyStorageAutoConfigOp', 'policySystemProfile', 'processorUnit', 'queryDependencyContext', 'queryImportContext', 'queryUsageContext', 'smartlicenseAgent', 'smartlicenseEntitlement', 'smartlicenseEntitlementEp', 'smartlicenseHolder', 'smartlicenseTest', 'storageComputeBladeOperation', 'storageConnectionDef', 'storageConnectionPolicy', 'storageController', 'storageControllerOperation', 'storageFlexFlashControllerOperation', 'storageIniGroup', 'storageInitiator', 'storageIpV4PooledAddr', 'storageItem', 'storageLocalDisk', 'storageLocalDiskOperation', 'storageLunReplica', 'storageLunSnapshot', 'storageMeta', 'storageScsiLun', 'storageVirtualDriveOperation', 'storageVirtualDriveRefOperation', 'storageVsanRef', 'sysdebugAutoCoreFileExportTarget', 'sysdebugCore', 'sysdebugLogControlEp', 'sysdebugManualCoreFileExportTarget', 'sysdebugTechSupport', 'sysdebugTechSupportOp', 'sysdebugTechSupportOperation', 'sysfileMutation', 'testingServiceProfile', 'topSystem', 'trigTest', 'uuidpoolAddr', 'uuidpoolPool', 'vmNic', 'vnicConnDef', 'vnicDynamicConPolicyRef', 'vnicEther', 'vnicEtherIf', 'vnicFault', 'vnicFc', 'vnicFcGroupDef', 'vnicFcGroupTempl', 'vnicFcIf', 'vnicFcNode', 'vnicIPv4PooledIscsiAddr', 'vnicIScsi', 'vnicIScsiBootVnic', 'vnicIScsiLCP', 'vnicIScsiNode', 'vnicIScsiStaticTargetIf', 'vnicIniGrpFc', 'vnicIniGrpFcB', 'vnicIpV4MgmtPooledAddr', 'vnicIpV4PooledAddr', 'vnicIpV6MgmtPooledAddr', 'vnicLanConnTempl', 'vnicLstorageIScsi', 'vnicMgmt', 'vnicMgmtIf', 'vnicMonSesFc', 'vnicOutbandMgmtEp', 'vnicSanConnTempl', 'vnicSriovHpnConPolicyRef', 'vnicStorageEthLif', 'vnicUsnicConPolicyRef', 'vnicVmqConPolicyRef'], [], ["Get"]),
    "FaultLocalTypedHolder": MoMeta("FaultLocalTypedHolder", "faultLocalTypedHolder", "type-[type]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "fault"], ['computeSystem'], [], ["Get"]),
    "FaultPolicy": MoMeta("FaultPolicy", "faultPolicy", "fault-policy", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "fault"], ['orgDomainGroup', 'orgOrg', 'policyDeviceProfile'], [], ["Add", "Get", "Remove", "Set"]),
    "FaultSummary": MoMeta("FaultSummary", "faultSummary", "fault-summary", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], ['extpolEp'], ['faultSvcSummary'], [None]),
    "FaultSummaryInst": MoMeta("FaultSummaryInst", "faultSummaryInst", "fault-summary-[name]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "fault", "operations"], ['faultDomainEp', 'faultSummaryInst'], ['faultSummaryInst'], ["Get"]),
    "FaultSvcSummary": MoMeta("FaultSvcSummary", "faultSvcSummary", "fault-svc-summary-[type]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], ['faultSummary'], [], [None]),
    "FaultTypedHolder": MoMeta("FaultTypedHolder", "faultTypedHolder", "type-[type]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "fault"], ['faultHolder'], [], ["Get"]),
    "FcErrStats": MoMeta("FcErrStats", "fcErrStats", "err-stats", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [], ['fcErrStatsHist'], [None]),
    "FcErrStatsHist": MoMeta("FcErrStatsHist", "fcErrStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], ['fcErrStats'], [], [None]),
    "FcPIo": MoMeta("FcPIo", "fcPIo", "port-[port_id]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['portGroup', 'portSubGroup'], ['equipmentXcvr'], ["Get"]),
    "FcStats": MoMeta("FcStats", "fcStats", "stats", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [], ['fcStatsHist'], [None]),
    "FcStatsHist": MoMeta("FcStatsHist", "fcStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], ['fcStats'], [], [None]),
    "FcpoolAddr": MoMeta("FcpoolAddr", "fcpoolAddr", "[id]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], ['fcpoolUniverse'], ['faultInst', 'identpoolConsumed', 'identpoolPoolable'], ["Get"]),
    "FcpoolBlock": MoMeta("FcpoolBlock", "fcpoolBlock", "block-[r_from]-[to]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "ls-storage-policy"], ['fcpoolInitiators'], ['fcpoolBootTarget'], ["Add", "Get", "Remove"]),
    "FcpoolBootTarget": MoMeta("FcpoolBootTarget", "fcpoolBootTarget", "target-[type]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "ls-storage-policy"], ['fcpoolBlock', 'fcpoolInitiator'], [], ["Get"]),
    "FcpoolFormat": MoMeta("FcpoolFormat", "fcpoolFormat", "format-[format]-[mask]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy", "ls-storage", "ls-storage-policy"], ['fcpoolUniverse'], [], ["Get"]),
    "FcpoolInitiator": MoMeta("FcpoolInitiator", "fcpoolInitiator", "[id]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], ['fcpoolInitiators'], ['fcpoolBootTarget', 'fcpoolInitiatorEp'], ["Add", "Get", "Remove", "Set"]),
    "FcpoolInitiatorEp": MoMeta("FcpoolInitiatorEp", "fcpoolInitiatorEp", "[id]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], ['fcpoolInitiator'], [], [None]),
    "FcpoolInitiators": MoMeta("FcpoolInitiators", "fcpoolInitiators", "wwn-pool-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], ['orgOrg'], ['faultInst', 'fcpoolBlock', 'fcpoolInitiator'], ["Add", "Get", "Remove", "Set"]),
    "FcpoolUniverse": MoMeta("FcpoolUniverse", "fcpoolUniverse", "wwn", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], ['topRoot'], ['fcpoolAddr', 'fcpoolFormat'], ["Get"]),
    "FdBlade": MoMeta("FdBlade", "fdBlade", "blade-[slot_id]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], ['fdChassis'], ['eventInst', 'faultInst', 'fdBladeFsm', 'fdPhysicalFsm', 'fdPhysicalFsmTask', 'identRequestEp', 'messageEp', 'vnicMgmt', 'vnicOutbandMgmtEp'], ["get"]),
    "FdBladeFsm": MoMeta("FdBladeFsm", "fdBladeFsm", "fsm", VersionMeta.Version201b, "OutputOnly", 0x1, [], [""], ['fdBlade'], ['fdBladeFsmStage'], [None]),
    "FdBladeFsmStage": MoMeta("FdBladeFsmStage", "fdBladeFsmStage", "stage-[name]", VersionMeta.Version201b, "OutputOnly", 0x1, [], [""], ['fdBladeFsm'], [], [None]),
    "FdChassis": MoMeta("FdChassis", "fdChassis", "chassis-[chassis_id]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], ['fabricSystem'], ['fdBlade', 'messageEp'], ["get"]),
    "FdPhysicalFsm": MoMeta("FdPhysicalFsm", "fdPhysicalFsm", "fsm", VersionMeta.Version201b, "OutputOnly", 0x1, [], [""], ['fdBlade', 'fdRackUnit'], ['fdPhysicalFsmStage'], [None]),
    "FdPhysicalFsmStage": MoMeta("FdPhysicalFsmStage", "fdPhysicalFsmStage", "stage-[name]", VersionMeta.Version201b, "OutputOnly", 0x1, [], [""], ['fdPhysicalFsm'], [], [None]),
    "FdPhysicalFsmTask": MoMeta("FdPhysicalFsmTask", "fdPhysicalFsmTask", "task-[item]", VersionMeta.Version201b, "OutputOnly", 0x1, [], [""], ['fdBlade', 'fdRackUnit'], [], [None]),
    "FdRackUnit": MoMeta("FdRackUnit", "fdRackUnit", "rack-unit-[id]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], ['fabricSystem'], ['eventInst', 'faultInst', 'fdPhysicalFsm', 'fdPhysicalFsmTask', 'fdRackUnitFsm', 'identRequestEp', 'messageEp', 'vnicMgmt', 'vnicOutbandMgmtEp'], ["get"]),
    "FdRackUnitFsm": MoMeta("FdRackUnitFsm", "fdRackUnitFsm", "fsm", VersionMeta.Version201b, "OutputOnly", 0x1, [], [""], ['fdRackUnit'], ['fdRackUnitFsmStage'], [None]),
    "FdRackUnitFsmStage": MoMeta("FdRackUnitFsmStage", "fdRackUnitFsmStage", "stage-[name]", VersionMeta.Version201b, "OutputOnly", 0x1, [], [""], ['fdRackUnitFsm'], [], [None]),
    "FeatureCatalogEp": MoMeta("FeatureCatalogEp", "featureCatalogEp", "feature-catalog", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin"], ['topSystem'], ['featureChassisDef', 'featureEnvDef', 'featureNetworkDef', 'featureServerDef', 'featureStorageDef'], ["Get"]),
    "FeatureChassisDef": MoMeta("FeatureChassisDef", "featureChassisDef", "chassis-feature-[name]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin"], ['featureCatalogEp'], ['domainChassisParam', 'domainEnvironmentParam', 'domainNetworkParam', 'domainServerParam', 'domainStorageParam'], ["get"]),
    "FeatureEnvDef": MoMeta("FeatureEnvDef", "featureEnvDef", "env-feature-[name]", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin"], ['featureCatalogEp'], ['domainChassisParam', 'domainEnvironmentParam', 'domainNetworkParam', 'domainServerParam', 'domainStorageParam'], ["Get"]),
    "FeatureNetworkDef": MoMeta("FeatureNetworkDef", "featureNetworkDef", "network-feature-[name]", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin"], ['featureCatalogEp'], ['domainChassisParam', 'domainEnvironmentParam', 'domainNetworkParam', 'domainServerParam', 'domainStorageParam'], ["Get"]),
    "FeatureServerDef": MoMeta("FeatureServerDef", "featureServerDef", "server-feature-[name]", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin"], ['featureCatalogEp'], ['domainChassisParam', 'domainEnvironmentParam', 'domainNetworkParam', 'domainServerParam', 'domainStorageParam'], ["Get"]),
    "FeatureStorageDef": MoMeta("FeatureStorageDef", "featureStorageDef", "storage-feature-[name]", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin"], ['featureCatalogEp'], ['domainChassisParam', 'domainEnvironmentParam', 'domainNetworkParam', 'domainServerParam', 'domainStorageParam'], ["Get"]),
    "FirmwareAck": MoMeta("FirmwareAck", "firmwareAck", "ack", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin"], ['fabricLanCloud', 'fabricSanCloud', 'firmwareSystem', 'qosclassDefinition'], ['faultInst'], ["get", "set"]),
    "FirmwareAutoSyncPolicy": MoMeta("FirmwareAutoSyncPolicy", "firmwareAutoSyncPolicy", "fw-auto-sync", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin"], ['orgDomainGroup'], [], ["Get", "Set"]),
    "FirmwareBootDefinition": MoMeta("FirmwareBootDefinition", "firmwareBootDefinition", "fw-boot-def", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], ['equipmentPsu', 'graphicsCard', 'mgmtController', 'osController', 'storageController', 'storageLocalDisk', 'storageOnboardDevice', 'storageSasExpander'], ['firmwareBootUnit'], ["Get"]),
    "FirmwareBootUnit": MoMeta("FirmwareBootUnit", "firmwareBootUnit", "bootunit-[type]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], ['firmwareBootDefinition'], [], ["Get", "Set"]),
    "FirmwareBundleInfo": MoMeta("FirmwareBundleInfo", "firmwareBundleInfo", "bundle-[type]-[version]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "domain-group-management", "ls-compute", "ls-config-policy", "ls-server-policy"], [], [], [None]),
    "FirmwareBundleInfoDigest": MoMeta("FirmwareBundleInfoDigest", "firmwareBundleInfoDigest", "bundleinfo-[type]-version-[version]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "FirmwareBundleType": MoMeta("FirmwareBundleType", "firmwareBundleType", "-type-[type]", VersionMeta.Version101a, "InputOutput", 0x1, [], [""], ['firmwareBundleTypeCapProvider'], [], ["Get"]),
    "FirmwareBundleTypeCapProvider": MoMeta("FirmwareBundleTypeCapProvider", "firmwareBundleTypeCapProvider", "bundle-type-cap", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], ['capabilityCatalogue'], ['firmwareBundleType', 'firmwareChassisComponentSpec', 'firmwareComponentSpec'], ["Get"]),
    "FirmwareCatalogPack": MoMeta("FirmwareCatalogPack", "firmwareCatalogPack", "fw-catalog-pack-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "operations"], ['computeSystem', 'firmwareDomainInfraProfile', 'orgDomainGroup', 'orgOrg'], [], ["Add", "Get", "Remove", "Set"]),
    "FirmwareCatalogPackConfig": MoMeta("FirmwareCatalogPackConfig", "firmwareCatalogPackConfig", "fw-catalog-pack-config[name]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "operations"], ['firmwareDomainInfraProfile', 'orgDomainGroup', 'orgOrg'], [], ["Add", "Get", "Remove", "Set"]),
    "FirmwareCatalogue": MoMeta("FirmwareCatalogue", "firmwareCatalogue", "fw-catalogue", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], ['topSystem'], ['firmwareCompSource', 'firmwareDistributable', 'firmwareDownloader', 'firmwareImage', 'firmwareSource'], ["Get", "Set"]),
    "FirmwareChassisComponentSpec": MoMeta("FirmwareChassisComponentSpec", "firmwareChassisComponentSpec", "chassis-component-spec-[type]", VersionMeta.Version151a, "InputOutput", 0x1, [], [""], ['firmwareBundleTypeCapProvider'], [], ["Get"]),
    "FirmwareChassisPack": MoMeta("FirmwareChassisPack", "firmwareChassisPack", "fw-chassis-pack-[name]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["read-only"], ['orgDomainGroup', 'orgOrg'], ['firmwareExcludeChassisComponent'], ["Add", "Get", "Remove", "Set"]),
    "FirmwareCompSource": MoMeta("FirmwareCompSource", "firmwareCompSource", "source-[inv_tag]-ver-[version]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], ['firmwareCatalogue', 'firmwareRemoteCatalogue'], ['firmwareCompTarget'], [None]),
    "FirmwareCompTarget": MoMeta("FirmwareCompTarget", "firmwareCompTarget", "target-[inv_tag]-ver-[version]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], ['firmwareCompSource'], [], [None]),
    "FirmwareComponentSpec": MoMeta("FirmwareComponentSpec", "firmwareComponentSpec", "component-spec-[type]", VersionMeta.Version141a, "InputOutput", 0x1, [], [""], ['firmwareBundleTypeCapProvider'], [], ["Get"]),
    "FirmwareComputeHostPack": MoMeta("FirmwareComputeHostPack", "firmwareComputeHostPack", "fw-host-pack-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], ['orgDomainGroup', 'orgOrg'], ['firmwareExcludeServerComponent'], ["Add", "Get", "Remove", "Set"]),
    "FirmwareComputeMgmtPack": MoMeta("FirmwareComputeMgmtPack", "firmwareComputeMgmtPack", "fw-mgmt-pack-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config-policy", "ls-server-policy"], ['orgDomainGroup', 'orgOrg'], [], ["Add", "Get", "Remove", "Set"]),
    "FirmwareComputeStoragePack": MoMeta("FirmwareComputeStoragePack", "firmwareComputeStoragePack", "fw-storage-pack-[name]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "ls-storage", "ls-storage-policy"], ['orgDomainGroup', 'orgOrg'], [], [None]),
    "FirmwareConnectionPolicy": MoMeta("FirmwareConnectionPolicy", "firmwareConnectionPolicy", "conn-policy-[type]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin"], ['orgDomainGroup'], [], ["Get", "Set"]),
    "FirmwareDependency": MoMeta("FirmwareDependency", "firmwareDependency", "dep-[ep]-[inv_tag]-[hw_vendor]|[hw_model]|[hw_revision]", VersionMeta.Version101a, "InputOutput", 0x1, [], [""], ['firmwareType'], [], ["Get"]),
    "FirmwareDistImage": MoMeta("FirmwareDistImage", "firmwareDistImage", "distimage-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], ['firmwareDistributable'], [], ["Get"]),
    "FirmwareDistributable": MoMeta("FirmwareDistributable", "firmwareDistributable", "distrib-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], ['firmwareCatalogue', 'firmwareRemoteCatalogue'], ['eventInst', 'faultInst', 'firmwareDistImage', 'firmwareDistributableFsm', 'firmwareDistributableFsmTask'], ["Get", "Set"]),
    "FirmwareDistributableFsm": MoMeta("FirmwareDistributableFsm", "firmwareDistributableFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['firmwareDistributable'], ['firmwareDistributableFsmStage'], [None]),
    "FirmwareDistributableFsmStage": MoMeta("FirmwareDistributableFsmStage", "firmwareDistributableFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['firmwareDistributableFsm'], [], [None]),
    "FirmwareDistributableFsmTask": MoMeta("FirmwareDistributableFsmTask", "firmwareDistributableFsmTask", "task-[item]", VersionMeta.Version101a, "OutputOnly", 0x1, [], [""], ['firmwareDistributable'], [], [None]),
    "FirmwareDomainInfo": MoMeta("FirmwareDomainInfo", "firmwareDomainInfo", "domain-info-[id]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "operations"], ['firmwareDomainInfraProfile'], [], ["Get"]),
    "FirmwareDomainInfraProfile": MoMeta("FirmwareDomainInfraProfile", "firmwareDomainInfraProfile", "domain-infra-profile-[name]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "operations"], ['orgOrg'], ['firmwareCatalogPack', 'firmwareCatalogPackConfig', 'firmwareDomainInfo', 'firmwareProductFamily', 'trigMeta', 'trigSched'], ["Add", "Get", "Remove", "Set"]),
    "FirmwareDownloadPolicy": MoMeta("FirmwareDownloadPolicy", "firmwareDownloadPolicy", "dl-policy-[type]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], ['firmwareSource', 'orgDomainGroup'], ['faultInst'], ["Get", "Set"]),
    "FirmwareDownloader": MoMeta("FirmwareDownloader", "firmwareDownloader", "dnld-[file_name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], ['firmwareCatalogue'], ['eventInst', 'faultInst', 'firmwareDownloaderFsm', 'firmwareDownloaderFsmTask'], ["Add", "Get", "Remove", "Set"]),
    "FirmwareDownloaderFsm": MoMeta("FirmwareDownloaderFsm", "firmwareDownloaderFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['firmwareDownloader'], ['firmwareDownloaderFsmStage'], [None]),
    "FirmwareDownloaderFsmStage": MoMeta("FirmwareDownloaderFsmStage", "firmwareDownloaderFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['firmwareDownloaderFsm'], [], [None]),
    "FirmwareDownloaderFsmTask": MoMeta("FirmwareDownloaderFsmTask", "firmwareDownloaderFsmTask", "task-[item]", VersionMeta.Version101a, "OutputOnly", 0x1, [], [""], ['firmwareDownloader'], [], ["Get"]),
    "FirmwareExcludeChassisComponent": MoMeta("FirmwareExcludeChassisComponent", "firmwareExcludeChassisComponent", "exclude-chassis-component-[chassis_component]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], ['firmwareChassisPack'], [], ["Add", "Get", "Remove"]),
    "FirmwareExcludeServerComponent": MoMeta("FirmwareExcludeServerComponent", "firmwareExcludeServerComponent", "exclude-server-component-[server_component]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config-policy", "ls-server-policy"], ['firmwareComputeHostPack'], [], ["Add", "Get", "Remove"]),
    "FirmwareImage": MoMeta("FirmwareImage", "firmwareImage", "image-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], ['firmwareCatalogue', 'firmwareRemoteCatalogue'], [], ["Get", "Set"]),
    "FirmwareInfra": MoMeta("FirmwareInfra", "firmwareInfra", "fw-infra", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], ['firmwareSystem'], ['faultInst'], ["Get"]),
    "FirmwareInfraPack": MoMeta("FirmwareInfraPack", "firmwareInfraPack", "fw-infra-pack-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "operations"], ['firmwareProductFamily', 'orgDomainGroup', 'orgOrg'], [], ["Add", "Get", "Remove", "Set"]),
    "FirmwareInfraPackConfig": MoMeta("FirmwareInfraPackConfig", "firmwareInfraPackConfig", "fw-infra-pack-config[name]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "operations"], ['firmwareProductFamily', 'orgDomainGroup', 'orgOrg'], [], ["Add", "Get", "Remove", "Set"]),
    "FirmwareInfraPolicy": MoMeta("FirmwareInfraPolicy", "firmwareInfraPolicy", "fw-infra-policy", VersionMeta.Version121a, "InputOutput", 0x1, [], ["admin", "operations"], ['orgDomainGroup', 'orgOrg'], ['firmwareProductFamily'], ["Get", "Set"]),
    "FirmwareInstallImpact": MoMeta("FirmwareInstallImpact", "firmwareInstallImpact", "fw-sys-InstallImpact-[key_dn]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], [], [], ["Get"]),
    "FirmwarePolicy": MoMeta("FirmwarePolicy", "firmwarePolicy", "fw-policy", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "operations"], ['orgDomainGroup'], [], [None]),
    "FirmwareProductFamily": MoMeta("FirmwareProductFamily", "firmwareProductFamily", "fw-family-[family_name]", VersionMeta.Version121a, "InputOutput", 0x1, [], ["admin", "operations"], ['firmwareDomainInfraProfile', 'firmwareInfraPolicy'], ['firmwareInfraPack', 'firmwareInfraPackConfig'], ["Get"]),
    "FirmwareRemoteCatalogue": MoMeta("FirmwareRemoteCatalogue", "firmwareRemoteCatalogue", "remote-fw-catalogue-[server]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], ['topSystem'], ['firmwareCompSource', 'firmwareDistributable', 'firmwareImage'], [None]),
    "FirmwareRunning": MoMeta("FirmwareRunning", "firmwareRunning", "fw-[deployment]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], ['biosUnit', 'equipmentPsu', 'graphicsCard', 'mgmtController', 'osController', 'storageController', 'storageFlexFlashController', 'storageLocalDisk', 'storageOnboardDevice', 'storageSasExpander'], [], ["Get"]),
    "FirmwareSource": MoMeta("FirmwareSource", "firmwareSource", "source-[type]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], ['firmwareCatalogue'], ['faultInst', 'firmwareDownloadPolicy'], ["Get", "Set"]),
    "FirmwareStatus": MoMeta("FirmwareStatus", "firmwareStatus", "fw-status", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], ['computeBlade', 'computeRackUnit', 'computeServerUnit', 'equipmentFex', 'equipmentIOCard', 'equipmentPsu', 'networkElement', 'topSystem'], [], ["Get"]),
    "FirmwareStoragePack": MoMeta("FirmwareStoragePack", "firmwareStoragePack", "storage-pack-[vendor]-[model]-[revision]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], ['orgOrg'], [], [None]),
    "FirmwareSystem": MoMeta("FirmwareSystem", "firmwareSystem", "fw-system", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-server-policy"], ['computeSystem', 'topSystem'], ['firmwareAck', 'firmwareInfra'], ["Get"]),
    "FirmwareType": MoMeta("FirmwareType", "firmwareType", "fw-type-[inv_tag]", VersionMeta.Version101a, "InputOutput", 0x1, [], [""], ['capabilityCatalogue'], ['firmwareDependency'], ["Get"]),
    "FirmwareUpdatable": MoMeta("FirmwareUpdatable", "firmwareUpdatable", "fw-updatable", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], ['equipmentPsu', 'storageOnboardDevice'], [], ["Get", "Set"]),
    "FirmwareUpgradeDetail": MoMeta("FirmwareUpgradeDetail", "firmwareUpgradeDetail", "id-[id]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin"], ['firmwareUpgradeInfo'], [], ["Get"]),
    "FirmwareUpgradeInfo": MoMeta("FirmwareUpgradeInfo", "firmwareUpgradeInfo", "validate-upgrade", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin"], ['computeSystem'], ['firmwareUpgradeDetail'], ["Get"]),
    "FlowctrlDefinition": MoMeta("FlowctrlDefinition", "flowctrlDefinition", "flowctrl", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy", "ls-qos-policy"], ['fabricLanCloud', 'orgDomainGroup'], ['flowctrlItem'], ["Get", "Set"]),
    "FlowctrlItem": MoMeta("FlowctrlItem", "flowctrlItem", "policy-[name]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy", "ls-qos-policy"], ['flowctrlDefinition'], [], ["Add", "Get", "Remove", "Set"]),
    "FsmStatus": MoMeta("FsmStatus", "fsmStatus", "status-[converted_ep_ref]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], ['computeSystem', 'topSystem'], [], ["Get"]),
    "GlAppendRule": MoMeta("GlAppendRule", "glAppendRule", "appendrule", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin"], ['glPolicyNameRuleEp'], [], [None]),
    "GlBlockEp": MoMeta("GlBlockEp", "glBlockEp", "blockep", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], ['glPolicyResolutionEp'], ['glBlockOp'], [None]),
    "GlBlockOp": MoMeta("GlBlockOp", "glBlockOp", "block-[id]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], ['glBlockEp'], ['glConflictEp', 'glRequestorEp', 'messageEp'], [None]),
    "GlByMo": MoMeta("GlByMo", "glByMo", "by-[id]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], ['glPolicyOp', 'glPolicyResOp', 'glRefsEp'], [], [None]),
    "GlComplexRefEp": MoMeta("GlComplexRefEp", "glComplexRefEp", "crefep", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], ['glPolicyResOp'], ['glIdRefEp', 'glPolicyRefEp'], [None]),
    "GlConflictEp": MoMeta("GlConflictEp", "glConflictEp", "cep", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], ['glBlockOp', 'glIdentCtxOp', 'glIdentCtxResOp', 'glPolicyAlgorithmedOp', 'glPolicyOp', 'glPolicyResOp', 'glPoolOp', 'glServerPoolResOp', 'glTemplateOp', 'glTemplateResOp', 'glVxanOp', 'glVxanResOp'], [], [None]),
    "GlConflictResolutionRuleEp": MoMeta("GlConflictResolutionRuleEp", "glConflictResolutionRuleEp", "ruleep", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin"], ['glDomainEp'], ['glPolicyNameRuleEp'], [None]),
    "GlDomainEp": MoMeta("GlDomainEp", "glDomainEp", "domain-[domain_id]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], ['glEp'], ['glConflictResolutionRuleEp', 'glRequest'], [None]),
    "GlEp": MoMeta("GlEp", "glEp", "gl", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], ['topRoot'], ['glDomainEp', 'glRequestVnetEpHolder'], [None]),
    "GlGlobalDefaultPolicyEp": MoMeta("GlGlobalDefaultPolicyEp", "glGlobalDefaultPolicyEp", "gdpep", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], ['glPolicyResolutionEp'], ['glPolicyResOp'], [None]),
    "GlIdRef": MoMeta("GlIdRef", "glIdRef", "iref-[id]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], ['glIdRefEp'], [], [None]),
    "GlIdRefEp": MoMeta("GlIdRefEp", "glIdRefEp", "irefep", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], ['glComplexRefEp'], ['glIdRef'], [None]),
    "GlIdentCtxEp": MoMeta("GlIdentCtxEp", "glIdentCtxEp", "icp", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], ['glOperationEp', 'glPolicyResolutionEp', 'glServiceProfile'], ['glIdentCtxOp', 'glIdentCtxResOp'], [None]),
    "GlIdentCtxOp": MoMeta("GlIdentCtxOp", "glIdentCtxOp", "icop-[id]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], ['glIdentCtxEp'], ['glConflictEp', 'glRequestorEp', 'messageEp'], [None]),
    "GlIdentCtxResOp": MoMeta("GlIdentCtxResOp", "glIdentCtxResOp", "icrop-[id]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin"], ['glIdentCtxEp'], ['eventInst', 'faultInst', 'glConflictEp', 'glIdentCtxResOpFsm', 'glIdentCtxResOpFsmTask', 'glRefsEp', 'glRequestorEp', 'messageEp'], [None]),
    "GlIdentCtxResOpFsm": MoMeta("GlIdentCtxResOpFsm", "glIdentCtxResOpFsm", "fsm", VersionMeta.Version201b, "OutputOnly", 0x1, [], [""], ['glIdentCtxResOp'], ['glIdentCtxResOpFsmStage'], [None]),
    "GlIdentCtxResOpFsmStage": MoMeta("GlIdentCtxResOpFsmStage", "glIdentCtxResOpFsmStage", "stage-[name]", VersionMeta.Version201b, "OutputOnly", 0x1, [], [""], ['glIdentCtxResOpFsm'], [], [None]),
    "GlIdentCtxResOpFsmTask": MoMeta("GlIdentCtxResOpFsmTask", "glIdentCtxResOpFsmTask", "task-[item]", VersionMeta.Version201b, "OutputOnly", 0x1, [], [""], ['glIdentCtxResOp'], [], [None]),
    "GlInventoryEp": MoMeta("GlInventoryEp", "glInventoryEp", "inv-[internal_id]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], ['glPathEp', 'glRequest'], ['glPolicyInvEp', 'glPoolInvEp', 'glSPInvEp'], [None]),
    "GlLsp": MoMeta("GlLsp", "glLsp", "lsp-[id]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin"], ['glRequest'], ['glOperationEp'], [None]),
    "GlMcastPolicy": MoMeta("GlMcastPolicy", "glMcastPolicy", "mc-policy[id]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin"], ['glVnetInvHolder'], ['messageEp'], [None]),
    "GlOperationEp": MoMeta("GlOperationEp", "glOperationEp", "opep", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], ['glLsp', 'glPolicy', 'glPool', 'glRequest', 'glServiceProfile', 'glVnicTemplate'], ['glIdentCtxEp', 'glPolicyEp', 'glPoolEp', 'glTemplateEp', 'glVxanEp'], [None]),
    "GlPathEp": MoMeta("GlPathEp", "glPathEp", "path-[id]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin"], ['glRequest'], ['glInventoryEp'], [None]),
    "GlPolicy": MoMeta("GlPolicy", "glPolicy", "policy-[id]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], ['glPolicyInvEp'], ['glOperationEp', 'glUsageEp', 'messageEp'], [None]),
    "GlPolicyAlgorithmedOp": MoMeta("GlPolicyAlgorithmedOp", "glPolicyAlgorithmedOp", "paop-[id]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], ['glPolicyEp'], ['glConflictEp', 'glRequestorEp', 'messageEp'], [None]),
    "GlPolicyEp": MoMeta("GlPolicyEp", "glPolicyEp", "paep", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], ['glOperationEp', 'glPolicyResolutionEp'], ['glPolicyAlgorithmedOp', 'glPolicyOp', 'glPolicyResOp'], [None]),
    "GlPolicyInvEp": MoMeta("GlPolicyInvEp", "glPolicyInvEp", "policy", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], ['glInventoryEp'], ['glPolicy'], [None]),
    "GlPolicyNameRuleEp": MoMeta("GlPolicyNameRuleEp", "glPolicyNameRuleEp", "policyep", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin"], ['glConflictResolutionRuleEp'], ['glAppendRule'], [None]),
    "GlPolicyOp": MoMeta("GlPolicyOp", "glPolicyOp", "pop-[id]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin"], ['glPolicyEp'], ['glByMo', 'glConflictEp', 'glRefsEp', 'glRequestorEp', 'messageEp'], [None]),
    "GlPolicyRef": MoMeta("GlPolicyRef", "glPolicyRef", "pref-[id]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], ['glPolicyRefEp'], [], [None]),
    "GlPolicyRefEp": MoMeta("GlPolicyRefEp", "glPolicyRefEp", "prefep", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], ['glComplexRefEp'], ['glPolicyRef'], [None]),
    "GlPolicyResOp": MoMeta("GlPolicyResOp", "glPolicyResOp", "presp-[id]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin"], ['glGlobalDefaultPolicyEp', 'glPolicyEp'], ['glByMo', 'glComplexRefEp', 'glConflictEp', 'glRefsEp', 'glRequestorEp', 'messageEp'], [None]),
    "GlPolicyResolutionEp": MoMeta("GlPolicyResolutionEp", "glPolicyResolutionEp", "prep", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin"], ['glRequest'], ['glBlockEp', 'glGlobalDefaultPolicyEp', 'glIdentCtxEp', 'glPolicyEp', 'glSpDefEp', 'glVxanEp'], [None]),
    "GlPool": MoMeta("GlPool", "glPool", "pool-[id]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], ['glPoolInvEp'], ['glOperationEp', 'messageEp'], [None]),
    "GlPoolEp": MoMeta("GlPoolEp", "glPoolEp", "pep", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], ['glOperationEp'], ['glPoolOp'], [None]),
    "GlPoolInvEp": MoMeta("GlPoolInvEp", "glPoolInvEp", "pool", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], ['glInventoryEp'], ['glPool'], [None]),
    "GlPoolOp": MoMeta("GlPoolOp", "glPoolOp", "", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], ['glPoolEp'], ['glConflictEp', 'glRequestorEp', 'messageEp'], [None]),
    "GlRefsEp": MoMeta("GlRefsEp", "glRefsEp", "refsep", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin"], ['glIdentCtxResOp', 'glPolicyOp', 'glPolicyResOp'], ['glByMo'], [None]),
    "GlRequest": MoMeta("GlRequest", "glRequest", "req-[id]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin"], ['glDomainEp'], ['eventInst', 'faultInst', 'glInventoryEp', 'glLsp', 'glOperationEp', 'glPathEp', 'glPolicyResolutionEp', 'glRequestFsm', 'glRequestFsmTask', 'glVnicTemplateEp', 'messageEp'], [None]),
    "GlRequestFsm": MoMeta("GlRequestFsm", "glRequestFsm", "fsm", VersionMeta.Version201b, "OutputOnly", 0x1, [], [""], ['glRequest'], ['glRequestFsmStage'], [None]),
    "GlRequestFsmStage": MoMeta("GlRequestFsmStage", "glRequestFsmStage", "stage-[name]", VersionMeta.Version201b, "OutputOnly", 0x1, [], [""], ['glRequestFsm'], [], [None]),
    "GlRequestFsmTask": MoMeta("GlRequestFsmTask", "glRequestFsmTask", "task-[item]", VersionMeta.Version201b, "OutputOnly", 0x1, [], [""], ['glRequest'], [], [None]),
    "GlRequestVnetEp": MoMeta("GlRequestVnetEp", "glRequestVnetEp", "req-[id]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin"], ['glRequestVnetEpHolder'], ['eventInst', 'faultInst', 'glRequestVnetEpDomainEp', 'glRequestVnetEpFsm', 'glRequestVnetEpFsmTask'], [None]),
    "GlRequestVnetEpDomainEp": MoMeta("GlRequestVnetEpDomainEp", "glRequestVnetEpDomainEp", "domain-[domain_id]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin"], ['glRequestVnetEp'], ['eventInst', 'faultInst', 'glRequestVnetEpDomainEpFsm', 'glRequestVnetEpDomainEpFsmTask', 'glVnetInvHolder'], [None]),
    "GlRequestVnetEpDomainEpFsm": MoMeta("GlRequestVnetEpDomainEpFsm", "glRequestVnetEpDomainEpFsm", "fsm", VersionMeta.Version201b, "OutputOnly", 0x1, [], [""], ['glRequestVnetEpDomainEp'], ['glRequestVnetEpDomainEpFsmStage'], [None]),
    "GlRequestVnetEpDomainEpFsmStage": MoMeta("GlRequestVnetEpDomainEpFsmStage", "glRequestVnetEpDomainEpFsmStage", "stage-[name]", VersionMeta.Version201b, "OutputOnly", 0x1, [], [""], ['glRequestVnetEpDomainEpFsm'], [], [None]),
    "GlRequestVnetEpDomainEpFsmTask": MoMeta("GlRequestVnetEpDomainEpFsmTask", "glRequestVnetEpDomainEpFsmTask", "task-[item]", VersionMeta.Version201b, "OutputOnly", 0x1, [], [""], ['glRequestVnetEpDomainEp'], [], [None]),
    "GlRequestVnetEpFsm": MoMeta("GlRequestVnetEpFsm", "glRequestVnetEpFsm", "fsm", VersionMeta.Version201b, "OutputOnly", 0x1, [], [""], ['glRequestVnetEp'], ['glRequestVnetEpFsmStage'], [None]),
    "GlRequestVnetEpFsmStage": MoMeta("GlRequestVnetEpFsmStage", "glRequestVnetEpFsmStage", "stage-[name]", VersionMeta.Version201b, "OutputOnly", 0x1, [], [""], ['glRequestVnetEpFsm'], [], [None]),
    "GlRequestVnetEpFsmTask": MoMeta("GlRequestVnetEpFsmTask", "glRequestVnetEpFsmTask", "task-[item]", VersionMeta.Version201b, "OutputOnly", 0x1, [], [""], ['glRequestVnetEp'], [], [None]),
    "GlRequestVnetEpHolder": MoMeta("GlRequestVnetEpHolder", "glRequestVnetEpHolder", "reqholder", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin"], ['glEp'], ['glRequestVnetEp'], [None]),
    "GlRequestor": MoMeta("GlRequestor", "glRequestor", "", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], ['glRequestorEp'], [], [None]),
    "GlRequestorEp": MoMeta("GlRequestorEp", "glRequestorEp", "reqep", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], ['glBlockOp', 'glIdentCtxOp', 'glIdentCtxResOp', 'glPolicyAlgorithmedOp', 'glPolicyOp', 'glPolicyResOp', 'glPoolOp', 'glServerPoolResOp', 'glTemplateOp', 'glTemplateResOp', 'glVxanOp', 'glVxanResOp'], ['glRequestor'], [None]),
    "GlSPInvEp": MoMeta("GlSPInvEp", "glSPInvEp", "sp", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], ['glInventoryEp'], ['glServiceProfile'], [None]),
    "GlServerPoolResOp": MoMeta("GlServerPoolResOp", "glServerPoolResOp", "svrprp", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin"], ['glSpDefEp'], ['glConflictEp', 'glRequestorEp', 'messageEp'], [None]),
    "GlServiceProfile": MoMeta("GlServiceProfile", "glServiceProfile", "sp-[id]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], ['glSPInvEp'], ['glIdentCtxEp', 'glOperationEp', 'messageEp'], [None]),
    "GlSpDefEp": MoMeta("GlSpDefEp", "glSpDefEp", "spep", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], ['glPolicyResolutionEp'], ['glServerPoolResOp', 'glTemplateResOp'], [None]),
    "GlTemplateEp": MoMeta("GlTemplateEp", "glTemplateEp", "tep", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], ['glOperationEp'], ['glTemplateOp'], [None]),
    "GlTemplateOp": MoMeta("GlTemplateOp", "glTemplateOp", "", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], ['glTemplateEp'], ['glConflictEp', 'glRequestorEp', 'messageEp'], [None]),
    "GlTemplateResOp": MoMeta("GlTemplateResOp", "glTemplateResOp", "temprp", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin"], ['glSpDefEp'], ['glConflictEp', 'glRequestorEp', 'messageEp'], [None]),
    "GlUsage": MoMeta("GlUsage", "glUsage", "sp-[id]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], ['glUsageEp'], [], [None]),
    "GlUsageEp": MoMeta("GlUsageEp", "glUsageEp", "uep", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], ['glPolicy'], ['glUsage'], [None]),
    "GlVlan": MoMeta("GlVlan", "glVlan", "vlan-[id]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin"], ['glVnetInvHolder'], ['messageEp'], [None]),
    "GlVnetInvHolder": MoMeta("GlVnetInvHolder", "glVnetInvHolder", "vnet", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], ['glRequestVnetEpDomainEp'], ['glMcastPolicy', 'glVlan', 'glVsan'], [None]),
    "GlVnicTemplate": MoMeta("GlVnicTemplate", "glVnicTemplate", "vt-[id]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], ['glVnicTemplateEp'], ['glOperationEp'], [None]),
    "GlVnicTemplateEp": MoMeta("GlVnicTemplateEp", "glVnicTemplateEp", "vtep", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], ['glRequest'], ['glVnicTemplate'], [None]),
    "GlVsan": MoMeta("GlVsan", "glVsan", "vsan-[id]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin"], ['glVnetInvHolder'], ['messageEp'], [None]),
    "GlVxanEp": MoMeta("GlVxanEp", "glVxanEp", "vxep", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], ['glOperationEp', 'glPolicyResolutionEp'], ['glVxanOp', 'glVxanResOp'], [None]),
    "GlVxanOp": MoMeta("GlVxanOp", "glVxanOp", "vxanop-[id]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin"], ['glVxanEp'], ['glConflictEp', 'glRequestorEp', 'messageEp'], [None]),
    "GlVxanResOp": MoMeta("GlVxanResOp", "glVxanResOp", "vxanresop-[id]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin"], ['glVxanEp'], ['glConflictEp', 'glRequestorEp', 'messageEp'], [None]),
    "GmetaClass": MoMeta("GmetaClass", "gmetaClass", "class-[id]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [], ['gmetaProp'], [None]),
    "GmetaPolicyMapElement": MoMeta("GmetaPolicyMapElement", "gmetaPolicyMapElement", "policymapelem-[name]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "GmetaProp": MoMeta("GmetaProp", "gmetaProp", "prop-[order]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['gmetaClass'], [], [None]),
    "GraphicsCard": MoMeta("GraphicsCard", "graphicsCard", "graphics-card-[id]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["read-only"], ['computeBoard'], ['firmwareBootDefinition', 'firmwareRunning', 'graphicsController'], ["Get"]),
    "GraphicsController": MoMeta("GraphicsController", "graphicsController", "graphics-controller-[id]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["read-only"], ['graphicsCard'], [], ["Get"]),
    "GuiGuiComponent": MoMeta("GuiGuiComponent", "guiGuiComponent", "gui-[app_id]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], ['guiGuiCont'], [], [None]),
    "GuiGuiCont": MoMeta("GuiGuiCont", "guiGuiCont", "gui", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], ['topRoot'], ['guiGuiComponent'], [None]),
    "HcAdapterFirmwareItem": MoMeta("HcAdapterFirmwareItem", "hcAdapterFirmwareItem", "adapter-firmware-[item_id]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin"], ['hcServerComponent'], ['hcItemNote', 'hcSupportedAdapterFirmwareItem'], [None]),
    "HcAdapterItem": MoMeta("HcAdapterItem", "hcAdapterItem", "adapter-[item_id]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin"], ['hcServerComponent'], ['hcItemNote', 'hcSupportedAdapterItem'], [None]),
    "HcAdmin": MoMeta("HcAdmin", "hcAdmin", "hc-admin", VersionMeta.Version151a, "InputOutput", 0x1, [], ["read-only"], ['hcHolder'], ['hcCleanup'], ["Get"]),
    "HcCatalog": MoMeta("HcCatalog", "hcCatalog", "hc-catalog-[id]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin"], ['hcHolder'], [], [None]),
    "HcCatalogList": MoMeta("HcCatalogList", "hcCatalogList", "catalog-list", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin"], ['hcHolder'], ['hcCatalogSource'], ["Get"]),
    "HcCatalogSource": MoMeta("HcCatalogSource", "hcCatalogSource", "catalog-source-[type]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin"], ['hcCatalogList'], ['hcDownloadPolicy'], ["Get"]),
    "HcCatalogVersion": MoMeta("HcCatalogVersion", "hcCatalogVersion", "hc-catalog-version-[id]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin"], ['hcHolder'], [], ["Get"]),
    "HcCleanup": MoMeta("HcCleanup", "hcCleanup", "cleanup-[ref_dn]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["read-only"], ['hcAdmin'], [], ["Get"]),
    "HcDownloadPolicy": MoMeta("HcDownloadPolicy", "hcDownloadPolicy", "hc-dl-policy-[type]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin"], ['hcCatalogSource', 'orgDomainGroup'], [], ["Get"]),
    "HcDownloader": MoMeta("HcDownloader", "hcDownloader", "dnld-[file_name]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin"], ['hcHolder'], [], ["Add", "Get", "Remove", "Set"]),
    "HcDriverInfoItem": MoMeta("HcDriverInfoItem", "hcDriverInfoItem", "driver-[id]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin"], ['hcHolder'], [], [None]),
    "HcDriverItem": MoMeta("HcDriverItem", "hcDriverItem", "driver-[item_id]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin"], ['hcServerComponent'], ['hcItemNote', 'hcSupportedDriverItem'], [None]),
    "HcHolder": MoMeta("HcHolder", "hcHolder", "hc-ep", VersionMeta.Version151a, "InputOutput", 0x1, [], ["read-only"], ['topRoot'], ['hcAdmin', 'hcCatalog', 'hcCatalogList', 'hcCatalogVersion', 'hcDownloader', 'hcDriverInfoItem', 'hcOsInfoItem', 'hcReport', 'hcUcsVersionItem'], ["Get"]),
    "HcItemNote": MoMeta("HcItemNote", "hcItemNote", "note-[ref_item_id]-[id]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin"], ['hcAdapterFirmwareItem', 'hcAdapterItem', 'hcDriverItem', 'hcOsItem'], [], [None]),
    "HcOsInfoItem": MoMeta("HcOsInfoItem", "hcOsInfoItem", "os-[id]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin"], ['hcHolder'], [], [None]),
    "HcOsItem": MoMeta("HcOsItem", "hcOsItem", "os-[item_id]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin"], ['hcServerComponent'], ['hcItemNote', 'hcSupportedOsItem'], [None]),
    "HcReport": MoMeta("HcReport", "hcReport", "report-[name]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin"], ['hcHolder'], ['hcScopeDn', 'hcServerComponent'], ["Add", "Get", "Remove", "Set"]),
    "HcScopeDn": MoMeta("HcScopeDn", "hcScopeDn", "scope-dn-[id]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin"], ['hcReport'], [], ["Add", "Get", "Remove", "Set"]),
    "HcServerComponent": MoMeta("HcServerComponent", "hcServerComponent", "server-[component_id]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin"], ['hcReport'], ['hcAdapterFirmwareItem', 'hcAdapterItem', 'hcDriverItem', 'hcOsItem'], [None]),
    "HcSupportedAdapterFirmwareItem": MoMeta("HcSupportedAdapterFirmwareItem", "hcSupportedAdapterFirmwareItem", "supported-adapter-firmware-[item_id]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin"], ['hcAdapterFirmwareItem'], [], [None]),
    "HcSupportedAdapterItem": MoMeta("HcSupportedAdapterItem", "hcSupportedAdapterItem", "supported-adapter-[item_id]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin"], ['hcAdapterItem'], [], [None]),
    "HcSupportedDriverItem": MoMeta("HcSupportedDriverItem", "hcSupportedDriverItem", "supported-driver-[item_id]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin"], ['hcDriverItem'], [], [None]),
    "HcSupportedOsItem": MoMeta("HcSupportedOsItem", "hcSupportedOsItem", "supported-os-[item_id]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin"], ['hcOsItem'], [], [None]),
    "HcUcsVersionItem": MoMeta("HcUcsVersionItem", "hcUcsVersionItem", "ucsversion-[id]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin"], ['hcHolder'], [], [None]),
    "IdentDomainSyncEp": MoMeta("IdentDomainSyncEp", "identDomainSyncEp", "domainsyncep", VersionMeta.Version112a, "InputOutput", 0x1, [], ["read-only"], ['identMetaSystem'], [], [None]),
    "IdentExecutionEp": MoMeta("IdentExecutionEp", "identExecutionEp", "executionEp", VersionMeta.Version112a, "InputOutput", 0x1, [], ["read-only"], ['identMetaSystem'], ['identExecutionRequestEp'], [None]),
    "IdentExecutionRequestEp": MoMeta("IdentExecutionRequestEp", "identExecutionRequestEp", "ExeReqestEp-[name]", VersionMeta.Version112a, "InputOutput", 0x1, [], ["read-only"], ['identExecutionEp'], [], [None]),
    "IdentIdentCtx": MoMeta("IdentIdentCtx", "identIdentCtx", "IdCtx-[seq_num]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], ['identIdentRequest'], [], [None]),
    "IdentIdentRequest": MoMeta("IdentIdentRequest", "identIdentRequest", "IdentQ-[id]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['identMetaSystem'], ['eventInst', 'faultInst', 'identIdentCtx', 'identIdentRequestFsm', 'identIdentRequestFsmTask'], [None]),
    "IdentIdentRequestFsm": MoMeta("IdentIdentRequestFsm", "identIdentRequestFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['identIdentRequest'], ['identIdentRequestFsmStage'], [None]),
    "IdentIdentRequestFsmStage": MoMeta("IdentIdentRequestFsmStage", "identIdentRequestFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['identIdentRequestFsm'], [], [None]),
    "IdentIdentRequestFsmTask": MoMeta("IdentIdentRequestFsmTask", "identIdentRequestFsmTask", "task-[item]", VersionMeta.Version111a, "OutputOnly", 0x1, [], [""], ['identIdentRequest'], [], [None]),
    "IdentMetaSystem": MoMeta("IdentMetaSystem", "identMetaSystem", "metasys", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['identMetaVerse'], ['eventInst', 'faultInst', 'identDomainSyncEp', 'identExecutionEp', 'identIdentRequest', 'identMetaSystemFsm', 'identMetaSystemFsmTask'], [None]),
    "IdentMetaSystemFsm": MoMeta("IdentMetaSystemFsm", "identMetaSystemFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['identMetaSystem'], ['identMetaSystemFsmStage'], [None]),
    "IdentMetaSystemFsmStage": MoMeta("IdentMetaSystemFsmStage", "identMetaSystemFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['identMetaSystemFsm'], [], [None]),
    "IdentMetaSystemFsmTask": MoMeta("IdentMetaSystemFsmTask", "identMetaSystemFsmTask", "task-[item]", VersionMeta.Version111a, "OutputOnly", 0x1, [], [""], ['identMetaSystem'], [], [None]),
    "IdentMetaVerse": MoMeta("IdentMetaVerse", "identMetaVerse", "metaverse", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['topRoot'], ['identMetaSystem'], [None]),
    "IdentRequestEp": MoMeta("IdentRequestEp", "identRequestEp", "IdentQ", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['fdBlade', 'fdRackUnit', 'lsServer'], [], [None]),
    "IdentSysInfo": MoMeta("IdentSysInfo", "identSysInfo", "", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "IdentpoolBlockQual": MoMeta("IdentpoolBlockQual", "identpoolBlockQual", "block-qualifier-[name]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['orgOrg'], ['identpoolDomainGroupQual', 'identpoolIPQual', 'identpoolIPV6Qual'], ["Add", "Get", "Remove", "Set"]),
    "IdentpoolConsumed": MoMeta("IdentpoolConsumed", "identpoolConsumed", "cons-[sys_id]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], ['fcpoolAddr', 'ippoolAddr', 'ippoolIpV6Addr', 'iqnpoolAddr', 'macpoolAddr', 'uuidpoolAddr'], ['identpoolDomain'], [None]),
    "IdentpoolDomain": MoMeta("IdentpoolDomain", "identpoolDomain", "domain", VersionMeta.Version112a, "InputOutput", 0x1, [], ["read-only"], ['identpoolConsumed'], [], [None]),
    "IdentpoolDomainGroupQual": MoMeta("IdentpoolDomainGroupQual", "identpoolDomainGroupQual", "domaingroup-[name]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin"], ['identpoolBlockQual'], [], ["Add", "Get", "Remove"]),
    "IdentpoolIPQual": MoMeta("IdentpoolIPQual", "identpoolIPQual", "ip-[addr]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin"], ['identpoolBlockQual'], [], ["Add", "Get", "Remove"]),
    "IdentpoolIPV6Qual": MoMeta("IdentpoolIPV6Qual", "identpoolIPV6Qual", "ipv6-[addr]", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin"], ['identpoolBlockQual'], [], ["Add", "Get", "Remove", "Set"]),
    "IdentpoolMetaSystem": MoMeta("IdentpoolMetaSystem", "identpoolMetaSystem", "metasys-[sys_id]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], ['identpoolMetaVerse'], [], [None]),
    "IdentpoolMetaVerse": MoMeta("IdentpoolMetaVerse", "identpoolMetaVerse", "metaverse", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], ['topRoot'], ['identpoolMetaSystem'], [None]),
    "IdentpoolPoolable": MoMeta("IdentpoolPoolable", "identpoolPoolable", "pool-[sys_id]-[id]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], ['fcpoolAddr', 'ippoolAddr', 'ippoolIpV6Addr', 'iqnpoolAddr', 'macpoolAddr', 'uuidpoolAddr'], [], [None]),
    "InbandPolicy": MoMeta("InbandPolicy", "inbandPolicy", "inband-[name]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], ['orgDomainGroup'], [], ["get", "set"]),
    "InitiatorFcInitiatorEp": MoMeta("InitiatorFcInitiatorEp", "initiatorFcInitiatorEp", "fc-ini-[name]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], ['initiatorGroupEp'], ['storageEpUser'], [None]),
    "InitiatorGroupEp": MoMeta("InitiatorGroupEp", "initiatorGroupEp", "grp-[name]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], ['initiatorRequestorEp'], ['initiatorFcInitiatorEp', 'initiatorIScsiInitiatorEp', 'initiatorStoreEp', 'storageIScsiInitiatorEp', 'storageNodeEp'], [None]),
    "InitiatorIScsiInitiatorEp": MoMeta("InitiatorIScsiInitiatorEp", "initiatorIScsiInitiatorEp", "scsi-ini-[name]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], ['initiatorGroupEp'], ['storageEpUser'], [None]),
    "InitiatorLunEp": MoMeta("InitiatorLunEp", "initiatorLunEp", "lun-[id]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], ['storageIScsiTargetIf'], [], [None]),
    "InitiatorMemberEp": MoMeta("InitiatorMemberEp", "initiatorMemberEp", "member-[id]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], ['initiatorRequestorGrpEp'], [], [None]),
    "InitiatorRequestorEp": MoMeta("InitiatorRequestorEp", "initiatorRequestorEp", "req-sysid-[sys_id]-id-[id]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], ['topSystem'], ['initiatorGroupEp'], [None]),
    "InitiatorRequestorGrpEp": MoMeta("InitiatorRequestorGrpEp", "initiatorRequestorGrpEp", "req-grp-[id]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], ['topSystem'], ['initiatorMemberEp', 'initiatorUnitEp'], [None]),
    "InitiatorStoreEp": MoMeta("InitiatorStoreEp", "initiatorStoreEp", "store-[id]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], ['initiatorGroupEp'], [], [None]),
    "InitiatorUnitEp": MoMeta("InitiatorUnitEp", "initiatorUnitEp", "unit-[id]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], ['initiatorRequestorGrpEp'], [], [None]),
    "InventoryDomainEp": MoMeta("InventoryDomainEp", "inventoryDomainEp", "domain-[sys_id]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "operations"], ['inventoryHolder'], ['inventoryInventoryMoMeta'], ["get", "set"]),
    "InventoryEp": MoMeta("InventoryEp", "inventoryEp", "inventory", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "operations"], ['topRoot'], ['inventoryHolder'], ["get"]),
    "InventoryGlobalEp": MoMeta("InventoryGlobalEp", "inventoryGlobalEp", "global-ep", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "operations"], ['inventoryHolder'], ['inventoryInventoryMoMeta'], [None]),
    "InventoryHolder": MoMeta("InventoryHolder", "inventoryHolder", "holder-[type]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "operations"], ['inventoryEp'], ['inventoryDomainEp', 'inventoryGlobalEp'], [None]),
    "InventoryInventoryMoMeta": MoMeta("InventoryInventoryMoMeta", "inventoryInventoryMoMeta", "mo-[inst_id]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "operations"], ['inventoryDomainEp', 'inventoryGlobalEp'], [], [None]),
    "IpIPv4Dns": MoMeta("IpIPv4Dns", "ipIPv4Dns", "ipv4-dns-[pref]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "IpIpV4StaticAddr": MoMeta("IpIpV4StaticAddr", "ipIpV4StaticAddr", "addr-[addr]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin"], [], [], ["Add", "Get", "Remove", "Set"]),
    "IpServiceIf": MoMeta("IpServiceIf", "ipServiceIf", "serv-ip-[addr]-port-[port]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin"], ['storageEtherIf'], [], [None]),
    "IppoolAddr": MoMeta("IppoolAddr", "ippoolAddr", "[id]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], ['ippoolUniverse'], ['faultInst', 'identpoolConsumed', 'identpoolPoolable'], ["Get"]),
    "IppoolBlock": MoMeta("IppoolBlock", "ippoolBlock", "block-[r_from]-[to]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "domain-group-management", "ls-network-policy"], ['ippoolPool'], [], ["Add", "Get", "Remove", "Set"]),
    "IppoolIpV6Addr": MoMeta("IppoolIpV6Addr", "ippoolIpV6Addr", "[id]", VersionMeta.Version112a, "InputOutput", 0x1, [], ["read-only"], ['ippoolUniverse'], ['faultInst', 'identpoolConsumed', 'identpoolPoolable'], ["Get"]),
    "IppoolIpV6Block": MoMeta("IppoolIpV6Block", "ippoolIpV6Block", "v6block-[r_from]-[to]", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin", "domain-group-management", "ls-network-policy"], ['ippoolPool'], [], ["Add", "Get", "Remove", "Set"]),
    "IppoolIpV6Pooled": MoMeta("IppoolIpV6Pooled", "ippoolIpV6Pooled", "[id]", VersionMeta.Version112a, "InputOutput", 0x1, [], ["read-only"], ['ippoolPool'], [], ["Get"]),
    "IppoolPool": MoMeta("IppoolPool", "ippoolPool", "ip-pool-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], ['orgDomainGroup', 'orgOrg'], ['faultInst', 'ippoolBlock', 'ippoolIpV6Block', 'ippoolIpV6Pooled', 'ippoolPooled'], ["Add", "Get", "Remove", "Set"]),
    "IppoolPooled": MoMeta("IppoolPooled", "ippoolPooled", "[id]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], ['ippoolPool'], [], ["Get"]),
    "IppoolUniverse": MoMeta("IppoolUniverse", "ippoolUniverse", "ip", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], ['topRoot'], ['ippoolAddr', 'ippoolIpV6Addr'], ["Get"]),
    "IqnpoolAddr": MoMeta("IqnpoolAddr", "iqnpoolAddr", "[id]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], ['iqnpoolUniverse'], ['faultInst', 'identpoolConsumed', 'identpoolPoolable'], ["Get"]),
    "IqnpoolBlock": MoMeta("IqnpoolBlock", "iqnpoolBlock", "iqn-suffix-[suffix]-from-[r_from]-to-[to]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "ls-storage-policy"], ['iqnpoolPool'], [], ["Add", "Get", "Remove"]),
    "IqnpoolFormat": MoMeta("IqnpoolFormat", "iqnpoolFormat", "format-[format]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], ['iqnpoolUniverse'], [], ["Get"]),
    "IqnpoolPool": MoMeta("IqnpoolPool", "iqnpoolPool", "iqn-pool-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], ['orgOrg'], ['faultInst', 'iqnpoolBlock', 'iqnpoolPooled'], ["Add", "Get", "Remove", "Set"]),
    "IqnpoolPooled": MoMeta("IqnpoolPooled", "iqnpoolPooled", "[id]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], ['iqnpoolPool'], [], ["Get"]),
    "IqnpoolTransportBlock": MoMeta("IqnpoolTransportBlock", "iqnpoolTransportBlock", "block-[suffix]-from-[r_from]-to-[to]", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin", "ls-storage-policy"], [], [], ["Get", "Set"]),
    "IqnpoolUniverse": MoMeta("IqnpoolUniverse", "iqnpoolUniverse", "iqn", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], ['topRoot'], ['iqnpoolAddr', 'iqnpoolFormat'], ["Get"]),
    "IscsiAuthProfile": MoMeta("IscsiAuthProfile", "iscsiAuthProfile", "iscsi-auth-profile-[name]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['orgOrg'], [], ["Add", "Get", "Remove", "Set"]),
    "LicenseContents": MoMeta("LicenseContents", "licenseContents", "contents-[feature_name]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['licenseFile'], ['licenseFeatureLine'], ["Get"]),
    "LicenseDomain": MoMeta("LicenseDomain", "licenseDomain", "Domain-[guid]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin"], ['licenseEp'], [], [None]),
    "LicenseDownloader": MoMeta("LicenseDownloader", "licenseDownloader", "dnld-[file_name]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin"], ['licenseEp'], ['eventInst', 'faultInst', 'licenseDownloaderFsm', 'licenseDownloaderFsmTask', 'licenseProp'], ["Add", "Get", "Remove", "Set"]),
    "LicenseDownloaderFsm": MoMeta("LicenseDownloaderFsm", "licenseDownloaderFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['licenseDownloader'], ['licenseDownloaderFsmStage'], [None]),
    "LicenseDownloaderFsmStage": MoMeta("LicenseDownloaderFsmStage", "licenseDownloaderFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['licenseDownloaderFsm'], [], [None]),
    "LicenseDownloaderFsmTask": MoMeta("LicenseDownloaderFsmTask", "licenseDownloaderFsmTask", "task-[item]", VersionMeta.Version111a, "OutputOnly", 0x1, [], [""], ['licenseDownloader'], [], [None]),
    "LicenseEp": MoMeta("LicenseEp", "licenseEp", "license", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], ['topSystem'], ['licenseDomain', 'licenseDownloader', 'licenseFeature', 'licenseFile', 'licenseServerHostId'], ["Get"]),
    "LicenseFeature": MoMeta("LicenseFeature", "licenseFeature", "feature-[name]-[vendor]-[version]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin"], ['licenseEp'], ['licenseInstance'], ["Get"]),
    "LicenseFeatureCapProvider": MoMeta("LicenseFeatureCapProvider", "licenseFeatureCapProvider", "feature-[feature_name]-[lic_vendor]|[lic_version]manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin"], ['capabilityCatalogue'], [], ["Get"]),
    "LicenseFeatureLine": MoMeta("LicenseFeatureLine", "licenseFeatureLine", "FeatureLine-[id]:[type]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['licenseContents'], [], ["Get"]),
    "LicenseFile": MoMeta("LicenseFile", "licenseFile", "file-[scope]:[id]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin"], ['licenseEp'], ['eventInst', 'faultInst', 'licenseContents', 'licenseFileFsm', 'licenseFileFsmTask', 'licenseSource'], ["Get"]),
    "LicenseFileFsm": MoMeta("LicenseFileFsm", "licenseFileFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['licenseFile'], ['licenseFileFsmStage'], [None]),
    "LicenseFileFsmStage": MoMeta("LicenseFileFsmStage", "licenseFileFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['licenseFileFsm'], [], [None]),
    "LicenseFileFsmTask": MoMeta("LicenseFileFsmTask", "licenseFileFsmTask", "task-[item]", VersionMeta.Version111a, "OutputOnly", 0x1, [], [""], ['licenseFile'], [], [None]),
    "LicenseInstance": MoMeta("LicenseInstance", "licenseInstance", "inst-[scope]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin"], ['licenseFeature'], ['eventInst', 'faultInst', 'licenseInstanceFsm', 'licenseInstanceFsmTask', 'licenseProp', 'licenseSourceFile'], ["Get"]),
    "LicenseInstanceFsm": MoMeta("LicenseInstanceFsm", "licenseInstanceFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['licenseInstance'], ['licenseInstanceFsmStage'], [None]),
    "LicenseInstanceFsmStage": MoMeta("LicenseInstanceFsmStage", "licenseInstanceFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['licenseInstanceFsm'], [], [None]),
    "LicenseInstanceFsmTask": MoMeta("LicenseInstanceFsmTask", "licenseInstanceFsmTask", "task-[item]", VersionMeta.Version111a, "OutputOnly", 0x1, [], [""], ['licenseInstance'], [], [None]),
    "LicenseProp": MoMeta("LicenseProp", "licenseProp", "prop-[name]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['licenseDownloader', 'licenseInstance'], [], ["Get"]),
    "LicenseServerHostId": MoMeta("LicenseServerHostId", "licenseServerHostId", "server-host-id-[scope]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['licenseEp'], [], ["Get"]),
    "LicenseSource": MoMeta("LicenseSource", "licenseSource", "source", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['licenseFile'], [], ["Get"]),
    "LicenseSourceFile": MoMeta("LicenseSourceFile", "licenseSourceFile", "src-[id]:[line]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['licenseInstance'], [], ["Get"]),
    "LsBinding": MoMeta("LsBinding", "lsBinding", "pn", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "read-only"], ['lsServer'], ['faultInst'], ["Add", "Get", "Remove", "Set"]),
    "LsFcLocale": MoMeta("LsFcLocale", "lsFcLocale", "fc-local-[switch_id]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ls-storage"], ['computeInstance', 'lsServer'], ['lsFcZoneGroup'], ["Get"]),
    "LsFcZone": MoMeta("LsFcZone", "lsFcZone", "zone-[identity]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ls-storage"], ['lsZoneInitiatorMember'], ['lsZoneTargetMember'], ["Get"]),
    "LsFcZoneGroup": MoMeta("LsFcZoneGroup", "lsFcZoneGroup", "zone-group-[id]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ls-storage"], ['lsFcLocale'], ['lsZoneInitiatorMember'], ["Get"]),
    "LsIdentityInfo": MoMeta("LsIdentityInfo", "lsIdentityInfo", "ls-identity-info", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-server"], ['computeBlade', 'computeRackUnit', 'computeServerUnit', 'lsServer'], ['faultInst'], ["Get"]),
    "LsIssues": MoMeta("LsIssues", "lsIssues", "config-issue", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server"], ['computeInstance', 'lsServer'], ['faultInst'], ["Get"]),
    "LsPower": MoMeta("LsPower", "lsPower", "power", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-oper", "ls-server-policy"], ['computeInstance', 'lsServer'], [], ["Get", "Set"]),
    "LsRequirement": MoMeta("LsRequirement", "lsRequirement", "pn-req", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "read-only"], ['lsServer'], ['faultInst'], ["Add", "Get", "Remove", "Set"]),
    "LsSPMeta": MoMeta("LsSPMeta", "lsSPMeta", "spmeta", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-oper", "ls-server-policy"], ['lsServer'], ['faultInst', 'messageEntry', 'messageEp'], ["Get"]),
    "LsServer": MoMeta("LsServer", "lsServer", "ls-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server"], ['computeTemplate', 'orgOrg'], ['cimcvmediaMountConfigDef', 'computeEnvFeatMask', 'computeNetworkFeatMask', 'computePowerSyncDef', 'computeServerFeatMask', 'computeStorageFeatMask', 'eventInst', 'fabricVCon', 'faultInst', 'identRequestEp', 'lsBinding', 'lsFcLocale', 'lsIdentityInfo', 'lsIssues', 'lsPower', 'lsRequirement', 'lsSPMeta', 'lsServerAssocCtx', 'lsServerExtension', 'lsServerFsm', 'lsServerFsmTask', 'lsServerOperation', 'lsVConAssign', 'lsbootDef', 'lsmaintAck', 'lstorageProfileBinding', 'lstorageProfileDef', 'mgmtInterface', 'storageIniGroup', 'storageIpV4PooledAddr', 'storageIpV4StaticAddr', 'storageLocalDiskConfigDef', 'storageScsiLunInstRef', 'storageVirtualDriveRef', 'vnicConnDef', 'vnicDefBeh', 'vnicDynamicCon', 'vnicEther', 'vnicFc', 'vnicFcNode', 'vnicIScsi', 'vnicIScsiBootParams', 'vnicIScsiLCP', 'vnicIScsiNode', 'vnicIniGrpFc', 'vnicIniGrpFcB', 'vnicIpV4MgmtPooledAddr', 'vnicIpV4PooledAddr', 'vnicIpV4StaticAddr', 'vnicLstorageIScsi', 'vnicMgmt', 'vnicMonSesFc'], ["Add", "Get", "Remove", "Set"]),
    "LsServerAssocCtx": MoMeta("LsServerAssocCtx", "lsServerAssocCtx", "ls-assoc-ctx", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['lsServer'], ['adaptorUnitAssocCtx', 'computePhysicalAssocCtx', 'processorUnitAssocCtx'], ["Get"]),
    "LsServerExtension": MoMeta("LsServerExtension", "lsServerExtension", "extension", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server"], ['lsServer'], [], ["Get", "Set"]),
    "LsServerFsm": MoMeta("LsServerFsm", "lsServerFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['lsServer'], ['lsServerFsmStage'], [None]),
    "LsServerFsmStage": MoMeta("LsServerFsmStage", "lsServerFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['lsServerFsm'], [], [None]),
    "LsServerFsmTask": MoMeta("LsServerFsmTask", "lsServerFsmTask", "task-[item]", VersionMeta.Version111a, "OutputOnly", 0x1, [], [""], ['lsServer'], [], [None]),
    "LsServerOperation": MoMeta("LsServerOperation", "lsServerOperation", "remote-oper", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-oper", "ls-server-policy"], ['computeInstance', 'lsServer'], ['faultInst'], ["Get", "Set"]),
    "LsTier": MoMeta("LsTier", "lsTier", "tier-[name]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy"], ['orgOrg'], [], [None]),
    "LsVConAssign": MoMeta("LsVConAssign", "lsVConAssign", "assign-[transport]-vnic-[vnic_name]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server"], ['lsServer'], [], ["Add", "Get", "Remove", "Set"]),
    "LsWaitingUserAck": MoMeta("LsWaitingUserAck", "lsWaitingUserAck", "waiting-user-ack", VersionMeta.Version121a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server"], ['orgOrg'], [], ["Get"]),
    "LsZoneInitiatorMember": MoMeta("LsZoneInitiatorMember", "lsZoneInitiatorMember", "initiator-[name]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ls-storage"], ['lsFcZoneGroup'], ['lsFcZone'], ["Get"]),
    "LsZoneTargetMember": MoMeta("LsZoneTargetMember", "lsZoneTargetMember", "target-[wwpn]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ls-storage"], ['lsFcZone'], [], ["Get"]),
    "LsbootBootSecurity": MoMeta("LsbootBootSecurity", "lsbootBootSecurity", "boot-security", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], ['lsbootDef', 'lsbootPolicy'], [], ["Add", "Get", "Remove", "Set"]),
    "LsbootDef": MoMeta("LsbootDef", "lsbootDef", "boot-policy", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-storage"], ['computeBlade', 'computeRackUnit', 'computeServerUnit', 'lsServer'], ['lsbootBootSecurity', 'lsbootEFIShell', 'lsbootIScsi', 'lsbootLan', 'lsbootSan', 'lsbootStorage', 'lsbootVirtualMedia'], ["Add", "Get", "Remove", "Set"]),
    "LsbootDefaultLocalImage": MoMeta("LsbootDefaultLocalImage", "lsbootDefaultLocalImage", "local-any", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], ['lsbootLocalStorage'], ['lsbootUEFIBootParam'], ["Add", "Get", "Remove", "Set"]),
    "LsbootEFIShell": MoMeta("LsbootEFIShell", "lsbootEFIShell", "efi-shell", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], ['lsbootDef', 'lsbootPolicy'], [], ["Add", "Get", "Remove", "Set"]),
    "LsbootEmbeddedLocalDiskImage": MoMeta("LsbootEmbeddedLocalDiskImage", "lsbootEmbeddedLocalDiskImage", "embedded-local-jbod", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], ['lsbootLocalStorage'], ['lsbootEmbeddedLocalDiskImagePath', 'lsbootUEFIBootParam'], ["Add", "Get", "Remove", "Set"]),
    "LsbootEmbeddedLocalDiskImagePath": MoMeta("LsbootEmbeddedLocalDiskImagePath", "lsbootEmbeddedLocalDiskImagePath", "diskimgpath-[type]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], ['lsbootEmbeddedLocalDiskImage'], ['lsbootUEFIBootParam'], ["Add", "Get", "Remove", "Set"]),
    "LsbootEmbeddedLocalLunImage": MoMeta("LsbootEmbeddedLocalLunImage", "lsbootEmbeddedLocalLunImage", "embedded-local-lun", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], ['lsbootLocalStorage'], ['lsbootUEFIBootParam'], ["Add", "Get", "Remove", "Set"]),
    "LsbootIScsi": MoMeta("LsbootIScsi", "lsbootIScsi", "iscsi", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], ['lsbootDef', 'lsbootPolicy'], ['lsbootIScsiImagePath'], ["Add", "Get", "Remove", "Set"]),
    "LsbootIScsiImagePath": MoMeta("LsbootIScsiImagePath", "lsbootIScsiImagePath", "path-[type]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], ['lsbootIScsi'], ['lsbootUEFIBootParam', 'vnicIScsiTargetParams'], ["Add", "Get", "Remove", "Set"]),
    "LsbootLan": MoMeta("LsbootLan", "lsbootLan", "lan", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], ['lsbootDef', 'lsbootPolicy'], ['lsbootLanImagePath'], ["Add", "Get", "Remove", "Set"]),
    "LsbootLanImagePath": MoMeta("LsbootLanImagePath", "lsbootLanImagePath", "path-[type]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], ['lsbootLan'], ['lsbootUEFIBootParam', 'vnicIpV4StaticAddr'], ["Add", "Get", "Remove", "Set"]),
    "LsbootLocalDiskImage": MoMeta("LsbootLocalDiskImage", "lsbootLocalDiskImage", "local-jbod", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], ['lsbootLocalStorage'], ['lsbootLocalDiskImagePath', 'lsbootUEFIBootParam'], ["Add", "Get", "Remove", "Set"]),
    "LsbootLocalDiskImagePath": MoMeta("LsbootLocalDiskImagePath", "lsbootLocalDiskImagePath", "diskimgpath-[type]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], ['lsbootLocalDiskImage'], ['lsbootUEFIBootParam'], ["Add", "Get", "Remove", "Set"]),
    "LsbootLocalHddImage": MoMeta("LsbootLocalHddImage", "lsbootLocalHddImage", "local-hdd", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], ['lsbootLocalStorage'], ['lsbootLocalLunImagePath', 'lsbootUEFIBootParam'], ["Add", "Get", "Remove", "Set"]),
    "LsbootLocalLunImagePath": MoMeta("LsbootLocalLunImagePath", "lsbootLocalLunImagePath", "lunimgpath-[type]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], ['lsbootLocalHddImage'], ['lsbootUEFIBootParam'], ["Add", "Get", "Remove", "Set"]),
    "LsbootLocalStorage": MoMeta("LsbootLocalStorage", "lsbootLocalStorage", "local-storage", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], ['lsbootStorage'], ['lsbootDefaultLocalImage', 'lsbootEmbeddedLocalDiskImage', 'lsbootEmbeddedLocalLunImage', 'lsbootLocalDiskImage', 'lsbootLocalHddImage', 'lsbootNvme', 'lsbootUsbExternalImage', 'lsbootUsbFlashStorageImage', 'lsbootUsbInternalImage'], ["Add", "Get", "Remove"]),
    "LsbootNvme": MoMeta("LsbootNvme", "lsbootNvme", "nvme", VersionMeta.Version201f, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], ['lsbootLocalStorage'], ['lsbootNvmeDiskSsd', 'lsbootNvmePciSsd', 'lsbootUEFIBootParam'], [None]),
    "LsbootNvmeDiskSsd": MoMeta("LsbootNvmeDiskSsd", "lsbootNvmeDiskSsd", "nvme-disk-ssd", VersionMeta.Version201f, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], ['lsbootNvme'], [], [None]),
    "LsbootNvmePciSsd": MoMeta("LsbootNvmePciSsd", "lsbootNvmePciSsd", "nvme-pci-ssd", VersionMeta.Version201f, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], ['lsbootNvme'], [], [None]),
    "LsbootPolicy": MoMeta("LsbootPolicy", "lsbootPolicy", "boot-policy-[name]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['orgOrg', 'policySystemEp'], ['lsbootBootSecurity', 'lsbootEFIShell', 'lsbootIScsi', 'lsbootLan', 'lsbootSan', 'lsbootStorage', 'lsbootUpgradeStatus', 'lsbootVirtualMedia'], ["Add", "Get", "Remove", "Set"]),
    "LsbootSan": MoMeta("LsbootSan", "lsbootSan", "san", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], ['lsbootDef', 'lsbootPolicy'], ['lsbootSanCatSanImage'], ["Add", "Get", "Remove", "Set"]),
    "LsbootSanCatSanImage": MoMeta("LsbootSanCatSanImage", "lsbootSanCatSanImage", "sanimg-[type]", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], ['lsbootSan'], ['lsbootSanCatSanImagePath'], ["Add", "Get", "Remove", "Set"]),
    "LsbootSanCatSanImagePath": MoMeta("LsbootSanCatSanImagePath", "lsbootSanCatSanImagePath", "sanimgpath-[type]", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], ['lsbootSanCatSanImage'], ['lsbootUEFIBootParam'], ["Add", "Get", "Remove", "Set"]),
    "LsbootSanImage": MoMeta("LsbootSanImage", "lsbootSanImage", "san-[type]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], ['lsbootStorage'], ['lsbootSanImagePath'], ["Add", "Get", "Remove", "Set"]),
    "LsbootSanImagePath": MoMeta("LsbootSanImagePath", "lsbootSanImagePath", "path-[type]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], ['lsbootSanImage'], ['lsbootUEFIBootParam'], ["Add", "Get", "Remove", "Set"]),
    "LsbootStorage": MoMeta("LsbootStorage", "lsbootStorage", "storage", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], ['lsbootDef', 'lsbootPolicy'], ['lsbootLocalStorage', 'lsbootSanImage'], ["Add", "Get", "Remove", "Set"]),
    "LsbootUEFIBootParam": MoMeta("LsbootUEFIBootParam", "lsbootUEFIBootParam", "uefi-boot-param", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-server-policy", "ls-storage-policy"], ['lsbootDefaultLocalImage', 'lsbootEmbeddedLocalDiskImage', 'lsbootEmbeddedLocalDiskImagePath', 'lsbootEmbeddedLocalLunImage', 'lsbootIScsiImagePath', 'lsbootLanImagePath', 'lsbootLocalDiskImage', 'lsbootLocalDiskImagePath', 'lsbootLocalHddImage', 'lsbootLocalLunImagePath', 'lsbootNvme', 'lsbootSanCatSanImagePath', 'lsbootSanImagePath', 'lsbootUsbExternalImage', 'lsbootUsbFlashStorageImage', 'lsbootUsbInternalImage'], [], ["Add", "Get", "Remove", "Set"]),
    "LsbootUpgradeStatus": MoMeta("LsbootUpgradeStatus", "lsbootUpgradeStatus", "UpgradeStatus", VersionMeta.Version121a, "InputOutput", 0x1, [], ["admin"], ['lsbootPolicy'], [], ["Get", "Set"]),
    "LsbootUsbExternalImage": MoMeta("LsbootUsbExternalImage", "lsbootUsbExternalImage", "usb-extern", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], ['lsbootLocalStorage'], ['lsbootUEFIBootParam'], ["Add", "Get", "Remove", "Set"]),
    "LsbootUsbFlashStorageImage": MoMeta("LsbootUsbFlashStorageImage", "lsbootUsbFlashStorageImage", "sd-card", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], ['lsbootLocalStorage'], ['lsbootUEFIBootParam'], ["Add", "Get", "Remove", "Set"]),
    "LsbootUsbInternalImage": MoMeta("LsbootUsbInternalImage", "lsbootUsbInternalImage", "usb-intern", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], ['lsbootLocalStorage'], ['lsbootUEFIBootParam'], ["Add", "Get", "Remove", "Set"]),
    "LsbootVirtualMedia": MoMeta("LsbootVirtualMedia", "lsbootVirtualMedia", "[access]-vm", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], ['lsbootDef', 'lsbootPolicy'], [], ["Add", "Get", "Remove", "Set"]),
    "LsmaintAck": MoMeta("LsmaintAck", "lsmaintAck", "ack", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server"], ['computeInstance', 'lsServer'], ['faultInst'], ["Get", "Set"]),
    "LsmaintMaintPolicy": MoMeta("LsmaintMaintPolicy", "lsmaintMaintPolicy", "maint-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], ['orgDomainGroup', 'orgOrg'], ['faultInst'], ["Add", "Get", "Remove", "Set"]),
    "LstorageAck": MoMeta("LstorageAck", "lstorageAck", "ack", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "ls-storage"], [], ['faultInst'], [None]),
    "LstorageArrayRequirement": MoMeta("LstorageArrayRequirement", "lstorageArrayRequirement", "strreq-[name]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "ls-storage"], ['orgOrg'], [], [None]),
    "LstorageBlade": MoMeta("LstorageBlade", "lstorageBlade", "lstorage-blade-[name]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], ['extpolDomain'], [], [None]),
    "LstorageControllerDef": MoMeta("LstorageControllerDef", "lstorageControllerDef", "controller-def-[name]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-storage", "ls-storage-policy"], ['lstorageProfile', 'lstorageProfileDef', 'storageController'], ['lstorageControllerModeConfig', 'lstorageControllerQualifier'], [None]),
    "LstorageControllerModeConfig": MoMeta("LstorageControllerModeConfig", "lstorageControllerModeConfig", "controller-mode-config", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-storage", "ls-storage-policy"], ['lstorageControllerDef'], [], [None]),
    "LstorageControllerQualifier": MoMeta("LstorageControllerQualifier", "lstorageControllerQualifier", "controller-qual", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-storage", "ls-storage-policy"], ['lstorageControllerDef'], [], [None]),
    "LstorageControllerRef": MoMeta("LstorageControllerRef", "lstorageControllerRef", "server-[server_id]-controller-[controller_type]-[controller_id]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], ['lstorageDiskSlot'], [], ["Add", "Get", "Remove"]),
    "LstorageCtrlServiceOperation": MoMeta("LstorageCtrlServiceOperation", "lstorageCtrlServiceOperation", "remote-oper", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "ls-storage", "pn-equipment", "pn-maintenance", "pn-policy"], [], ['faultInst'], [None]),
    "LstorageDasScsiLun": MoMeta("LstorageDasScsiLun", "lstorageDasScsiLun", "das-scsi-lun-[name]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-storage", "ls-storage-policy"], ['lstorageProfile', 'lstorageProfileDef'], ['faultInst', 'storageLocalDiskConfigDef'], ["Add", "Get", "Remove", "Set"]),
    "LstorageDiskGroupConfigDef": MoMeta("LstorageDiskGroupConfigDef", "lstorageDiskGroupConfigDef", "disk-group-config", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-storage", "ls-storage-policy"], ['storageVirtualDriveRef'], ['lstorageDiskGroupQualifier', 'lstorageLocalDiskConfigRef', 'lstorageVirtualDriveDef'], ["Get"]),
    "LstorageDiskGroupConfigPolicy": MoMeta("LstorageDiskGroupConfigPolicy", "lstorageDiskGroupConfigPolicy", "disk-group-config-[name]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-storage", "ls-storage-policy"], ['orgOrg'], ['lstorageDiskGroupQualifier', 'lstorageLocalDiskConfigRef', 'lstorageVirtualDriveDef'], ["Add", "Get", "Remove", "Set"]),
    "LstorageDiskGroupQualifier": MoMeta("LstorageDiskGroupQualifier", "lstorageDiskGroupQualifier", "disk-group-qual", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-storage", "ls-storage-policy"], ['lstorageDiskGroupConfigDef', 'lstorageDiskGroupConfigPolicy'], [], ["Add", "Get", "Remove", "Set"]),
    "LstorageDiskSlot": MoMeta("LstorageDiskSlot", "lstorageDiskSlot", "disk-slot-[id]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], ['lstorageDiskZoningConfigDef', 'lstorageDiskZoningPolicy'], ['lstorageControllerRef'], ["Add", "Get", "Remove", "Set"]),
    "LstorageDiskZoningConfigDef": MoMeta("LstorageDiskZoningConfigDef", "lstorageDiskZoningConfigDef", "disk-zoning-def", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], ['equipmentChassisProfile'], ['lstorageDiskSlot'], [None]),
    "LstorageDiskZoningPolicy": MoMeta("LstorageDiskZoningPolicy", "lstorageDiskZoningPolicy", "disk-zoning-policy-[name]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["read-only"], ['orgOrg'], ['lstorageDiskSlot'], ["Add", "Get", "Remove", "Set"]),
    "LstorageDriveSecurity": MoMeta("LstorageDriveSecurity", "lstorageDriveSecurity", "drive", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-storage", "ls-storage-policy"], ['lstorageSecurity'], ['lstorageLocal', 'lstorageRemote'], ["add", "get", "remove"]),
    "LstorageExtension": MoMeta("LstorageExtension", "lstorageExtension", "extension", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "ls-storage"], [], [], [None]),
    "LstorageLocal": MoMeta("LstorageLocal", "lstorageLocal", "local", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-storage", "ls-storage-policy"], ['computeBoard', 'lstorageDriveSecurity'], [], ["add", "get", "remove", "set"]),
    "LstorageLocalDef": MoMeta("LstorageLocalDef", "lstorageLocalDef", "local-def", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-storage", "ls-storage-policy"], ['computeBoard'], [], [None]),
    "LstorageLocalDiskConfigRef": MoMeta("LstorageLocalDiskConfigRef", "lstorageLocalDiskConfigRef", "slot-[slot_num]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-storage", "ls-storage-policy"], ['lstorageDiskGroupConfigDef', 'lstorageDiskGroupConfigPolicy'], [], ["Add", "Get", "Remove", "Set"]),
    "LstorageLocalDiskRef": MoMeta("LstorageLocalDiskRef", "lstorageLocalDiskRef", "diskref-[enclosure_id]-slot-[slot_id]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], [], [], ["Add", "Get", "Remove"]),
    "LstorageLogin": MoMeta("LstorageLogin", "lstorageLogin", "login", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-storage", "ls-storage-policy"], ['lstorageRemote', 'lstorageRemoteDef'], [], ["add", "get", "remove", "set"]),
    "LstorageMeta": MoMeta("LstorageMeta", "lstorageMeta", "meta", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin"], [], [], [None]),
    "LstorageProfile": MoMeta("LstorageProfile", "lstorageProfile", "profile-[name]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-storage", "ls-storage-policy"], ['orgOrg'], ['lstorageControllerDef', 'lstorageDasScsiLun', 'lstorageSecurity'], ["Add", "Get", "Remove", "Set"]),
    "LstorageProfileBinding": MoMeta("LstorageProfileBinding", "lstorageProfileBinding", "profile-binding", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server"], ['lsServer'], ['faultInst'], ["Add", "Get", "Remove", "Set"]),
    "LstorageProfileDef": MoMeta("LstorageProfileDef", "lstorageProfileDef", "profile-def", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-storage", "ls-storage-policy"], ['lsServer'], ['lstorageControllerDef', 'lstorageDasScsiLun', 'lstorageSecurity'], ["Add", "Get", "Remove", "Set"]),
    "LstorageRecurrWindow": MoMeta("LstorageRecurrWindow", "lstorageRecurrWindow", "recurr-window-[name]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "ls-storage", "ls-storage-policy"], ['trigSched'], [], [None]),
    "LstorageRemote": MoMeta("LstorageRemote", "lstorageRemote", "remote", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-storage", "ls-storage-policy"], ['computeBoard', 'lstorageDriveSecurity'], ['lstorageLogin'], ["add", "get", "remove", "set"]),
    "LstorageRemoteDef": MoMeta("LstorageRemoteDef", "lstorageRemoteDef", "remote-def", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-storage", "ls-storage-policy"], ['computeBoard'], ['lstorageLogin'], [None]),
    "LstorageRequestCtx": MoMeta("LstorageRequestCtx", "lstorageRequestCtx", "", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "LstorageSecurity": MoMeta("LstorageSecurity", "lstorageSecurity", "security", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-storage", "ls-storage-policy"], ['lstorageProfile', 'lstorageProfileDef', 'storageLocalDiskConfigDef', 'storageLocalDiskConfigPolicy'], ['lstorageDriveSecurity'], ["add", "get", "remove", "set"]),
    "LstorageVirtualDriveDef": MoMeta("LstorageVirtualDriveDef", "lstorageVirtualDriveDef", "virtual-drive-def", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-storage", "ls-storage-policy"], ['lstorageDiskGroupConfigDef', 'lstorageDiskGroupConfigPolicy'], [], ["Get", "Set"]),
    "MacpoolAddr": MoMeta("MacpoolAddr", "macpoolAddr", "[id]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], ['macpoolUniverse'], ['faultInst', 'identpoolConsumed', 'identpoolPoolable'], ["Get"]),
    "MacpoolBlock": MoMeta("MacpoolBlock", "macpoolBlock", "block-[r_from]-[to]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "ls-network-policy"], ['macpoolPool'], [], ["Add", "Get", "Remove"]),
    "MacpoolFormat": MoMeta("MacpoolFormat", "macpoolFormat", "format-[format]-[mask]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy", "ls-network", "ls-network-policy"], ['macpoolUniverse'], [], ["Get"]),
    "MacpoolPool": MoMeta("MacpoolPool", "macpoolPool", "mac-pool-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], ['orgOrg'], ['faultInst', 'macpoolBlock', 'macpoolPooled'], ["Add", "Get", "Remove", "Set"]),
    "MacpoolPooled": MoMeta("MacpoolPooled", "macpoolPooled", "[id]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], ['macpoolPool'], [], ["Get"]),
    "MacpoolUniverse": MoMeta("MacpoolUniverse", "macpoolUniverse", "mac", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], ['topRoot'], ['macpoolAddr', 'macpoolFormat'], ["Get"]),
    "MemoryArray": MoMeta("MemoryArray", "memoryArray", "memarray-[id]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['computeBoard'], ['faultInst', 'memoryArrayEnvStats', 'memoryNvDimmBattery', 'memoryNvDimmController', 'memoryUnit'], ["Get"]),
    "MemoryArrayEnvStats": MoMeta("MemoryArrayEnvStats", "memoryArrayEnvStats", "array-env-stats", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['memoryArray'], ['memoryArrayEnvStatsHist'], [None]),
    "MemoryArrayEnvStatsHist": MoMeta("MemoryArrayEnvStatsHist", "memoryArrayEnvStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], ['memoryArrayEnvStats'], [], [None]),
    "MemoryBufferUnit": MoMeta("MemoryBufferUnit", "memoryBufferUnit", "sensor-unit-[id]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['computeBoard'], ['faultInst', 'memoryBufferUnitEnvStats'], ["Get"]),
    "MemoryBufferUnitEnvStats": MoMeta("MemoryBufferUnitEnvStats", "memoryBufferUnitEnvStats", "buffer-unit-env-stats", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['memoryBufferUnit'], ['memoryBufferUnitEnvStatsHist'], [None]),
    "MemoryBufferUnitEnvStatsHist": MoMeta("MemoryBufferUnitEnvStatsHist", "memoryBufferUnitEnvStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], ['memoryBufferUnitEnvStats'], [], [None]),
    "MemoryErrorStats": MoMeta("MemoryErrorStats", "memoryErrorStats", "error-stats", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['memoryUnit'], ['memoryErrorStatsHist'], [None]),
    "MemoryErrorStatsHist": MoMeta("MemoryErrorStatsHist", "memoryErrorStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], ['memoryErrorStats'], [], [None]),
    "MemoryNvDimm": MoMeta("MemoryNvDimm", "memoryNvDimm", "nvdimm-[id]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], ['memoryNvDimmController'], [], ["Get"]),
    "MemoryNvDimmBattery": MoMeta("MemoryNvDimmBattery", "memoryNvDimmBattery", "nvdimm-batt-[id]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], ['memoryArray'], [], ["Get"]),
    "MemoryNvDimmController": MoMeta("MemoryNvDimmController", "memoryNvDimmController", "mem-controller-[id]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], ['memoryArray'], ['memoryNvDimm'], ["Get"]),
    "MemoryQual": MoMeta("MemoryQual", "memoryQual", "memory", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "pn-policy", "read-only"], ['computeQual'], [], ["Add", "Get", "Remove", "Set"]),
    "MemoryRuntime": MoMeta("MemoryRuntime", "memoryRuntime", "[type]-mem-rt", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['computeBlade'], ['memoryRuntimeHist'], ["Get"]),
    "MemoryRuntimeHist": MoMeta("MemoryRuntimeHist", "memoryRuntimeHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], ['memoryRuntime'], [], [None]),
    "MemoryUnit": MoMeta("MemoryUnit", "memoryUnit", "mem-[id]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['memoryArray'], ['faultInst', 'memoryErrorStats', 'memoryUnitEnvStats'], ["Get"]),
    "MemoryUnitEnvStats": MoMeta("MemoryUnitEnvStats", "memoryUnitEnvStats", "dimm-env-stats", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['memoryUnit'], ['memoryUnitEnvStatsHist'], [None]),
    "MemoryUnitEnvStatsHist": MoMeta("MemoryUnitEnvStatsHist", "memoryUnitEnvStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], ['memoryUnitEnvStats'], [], [None]),
    "MessageEntry": MoMeta("MessageEntry", "messageEntry", "entry-[id]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin"], ['lsSPMeta', 'messageEp'], [], ["Get"]),
    "MessageEp": MoMeta("MessageEp", "messageEp", "ep", VersionMeta.Version151a, "InputOutput", 0x1, [], ["read-only"], ['domainProfile', 'equipmentCPMeta', 'fabricDceSwSrvPcOperation', 'fabricEthEstcEpOperation', 'fabricEthEstcPcOperation', 'fabricEthLanEpOperation', 'fabricEthLanPcOperation', 'fabricEthMonOperation', 'fabricFcEstcEpOperation', 'fabricFcMonOperation', 'fabricFcSanEpOperation', 'fabricFcSanPcOperation', 'fabricFcUserZone', 'fabricFcoeEstcEpOperation', 'fabricFcoeSanEpOperation', 'fabricFcoeSanPcOperation', 'fdBlade', 'fdChassis', 'fdRackUnit', 'glBlockOp', 'glIdentCtxOp', 'glIdentCtxResOp', 'glMcastPolicy', 'glPolicy', 'glPolicyAlgorithmedOp', 'glPolicyOp', 'glPolicyResOp', 'glPool', 'glPoolOp', 'glRequest', 'glServerPoolResOp', 'glServiceProfile', 'glTemplateOp', 'glTemplateResOp', 'glVlan', 'glVsan', 'glVxanOp', 'glVxanResOp', 'lsSPMeta', 'vnicOutbandMgmtEp'], ['messageEntry'], [None]),
    "MgmtBackup": MoMeta("MgmtBackup", "mgmtBackup", "backup-[hostname]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], ['computeSystem', 'extpolClient', 'topSystem'], ['computeRemoteOpStatus', 'eventInst', 'faultInst', 'mgmtBackupFsm', 'mgmtBackupFsmTask'], ["Add", "Get", "Remove", "Set"]),
    "MgmtBackupFsm": MoMeta("MgmtBackupFsm", "mgmtBackupFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['mgmtBackup'], ['mgmtBackupFsmStage'], [None]),
    "MgmtBackupFsmStage": MoMeta("MgmtBackupFsmStage", "mgmtBackupFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['mgmtBackupFsm'], [], [None]),
    "MgmtBackupFsmTask": MoMeta("MgmtBackupFsmTask", "mgmtBackupFsmTask", "task-[item]", VersionMeta.Version101a, "OutputOnly", 0x1, [], [""], ['mgmtBackup'], [], ["Get"]),
    "MgmtBackupOperation": MoMeta("MgmtBackupOperation", "mgmtBackupOperation", "remote-oper", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin"], ['computeSystem'], ['faultInst'], ["Get", "Set"]),
    "MgmtBackupPolicy": MoMeta("MgmtBackupPolicy", "mgmtBackupPolicy", "db-backup-policy-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "operations"], ['orgDomainGroup', 'orgOrg', 'policyDeviceProfile'], ['faultInst', 'mgmtBackupTrigger'], ["Add", "Get", "Remove", "Set"]),
    "MgmtBackupTrigger": MoMeta("MgmtBackupTrigger", "mgmtBackupTrigger", "trigger", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], ['mgmtBackupPolicy', 'mgmtCfgExportPolicy'], ['eventInst', 'faultInst', 'mgmtBackupTriggerFsm', 'mgmtBackupTriggerFsmTask'], ["Get", "Set"]),
    "MgmtBackupTriggerFsm": MoMeta("MgmtBackupTriggerFsm", "mgmtBackupTriggerFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['mgmtBackupTrigger'], ['mgmtBackupTriggerFsmStage'], [None]),
    "MgmtBackupTriggerFsmStage": MoMeta("MgmtBackupTriggerFsmStage", "mgmtBackupTriggerFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['mgmtBackupTriggerFsm'], [], [None]),
    "MgmtBackupTriggerFsmTask": MoMeta("MgmtBackupTriggerFsmTask", "mgmtBackupTriggerFsmTask", "task-[item]", VersionMeta.Version131a, "OutputOnly", 0x1, [], [""], ['mgmtBackupTrigger'], [], [None]),
    "MgmtCfgExportPolicy": MoMeta("MgmtCfgExportPolicy", "mgmtCfgExportPolicy", "cfg-exp-policy-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "operations"], ['orgDomainGroup', 'orgOrg', 'policyDeviceProfile'], ['faultInst', 'mgmtBackupTrigger'], ["Add", "Get", "Remove", "Set"]),
    "MgmtCmcSecureBoot": MoMeta("MgmtCmcSecureBoot", "mgmtCmcSecureBoot", "mgmt-cmc-secure-boot", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "ls-compute"], ['mgmtController'], ['mgmtCmcSecureBootOperation'], ["Get"]),
    "MgmtCmcSecureBootOperation": MoMeta("MgmtCmcSecureBootOperation", "mgmtCmcSecureBootOperation", "remote-oper", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "ls-compute"], ['mgmtCmcSecureBoot'], ['faultInst'], ["Get", "Set"]),
    "MgmtConnection": MoMeta("MgmtConnection", "mgmtConnection", "mgmt-connection-[type]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin"], ['mgmtController'], [], ["Get", "Set"]),
    "MgmtController": MoMeta("MgmtController", "mgmtController", "mgmt", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-network", "ls-server"], ['adaptorUnit', 'computeBlade', 'computeBoardController', 'computeRackUnit', 'computeServerUnit', 'computeSystem', 'equipmentChassis', 'equipmentIOCard', 'equipmentSharedIOModule', 'equipmentSwitchIOCard', 'equipmentSystemIOController', 'networkElement', 'storageController', 'storageSasExpander', 'topSystem'], ['cimcvmediaActualMountList', 'firmwareBootDefinition', 'firmwareRunning', 'mgmtCmcSecureBoot', 'mgmtConnection', 'mgmtIf', 'mgmtInterface', 'vnicIpV4PooledAddr', 'vnicIpV4ProfDerivedAddr', 'vnicIpV4StaticAddr'], ["Get"]),
    "MgmtDataExporter": MoMeta("MgmtDataExporter", "mgmtDataExporter", "exporter-[hostname]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], ['topSystem'], ['eventInst', 'faultInst', 'mgmtDataExporterFsm', 'mgmtDataExporterFsmTask', 'mgmtDataItem'], ["Get", "Remove", "Set"]),
    "MgmtDataExporterFsm": MoMeta("MgmtDataExporterFsm", "mgmtDataExporterFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['mgmtDataExporter'], ['mgmtDataExporterFsmStage'], [None]),
    "MgmtDataExporterFsmStage": MoMeta("MgmtDataExporterFsmStage", "mgmtDataExporterFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['mgmtDataExporterFsm'], [], [None]),
    "MgmtDataExporterFsmTask": MoMeta("MgmtDataExporterFsmTask", "mgmtDataExporterFsmTask", "task-[item]", VersionMeta.Version101a, "OutputOnly", 0x1, [], [""], ['mgmtDataExporter'], [], ["Get"]),
    "MgmtDataImporter": MoMeta("MgmtDataImporter", "mgmtDataImporter", "importer-[hostname]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], ['topSystem'], ['eventInst', 'faultInst', 'mgmtDataImporterFsm', 'mgmtDataImporterFsmTask', 'mgmtImportItem'], ["Get", "Remove", "Set"]),
    "MgmtDataImporterFsm": MoMeta("MgmtDataImporterFsm", "mgmtDataImporterFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['mgmtDataImporter'], ['mgmtDataImporterFsmStage'], [None]),
    "MgmtDataImporterFsmStage": MoMeta("MgmtDataImporterFsmStage", "mgmtDataImporterFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['mgmtDataImporterFsm'], [], [None]),
    "MgmtDataImporterFsmTask": MoMeta("MgmtDataImporterFsmTask", "mgmtDataImporterFsmTask", "task-[item]", VersionMeta.Version101a, "OutputOnly", 0x1, [], [""], ['mgmtDataImporter'], [], ["Get"]),
    "MgmtDataItem": MoMeta("MgmtDataItem", "mgmtDataItem", "exp-provider-[sysid]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], ['mgmtDataExporter'], [], ["Get"]),
    "MgmtEntity": MoMeta("MgmtEntity", "mgmtEntity", "mgmt-entity-[id]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['computeSystem', 'topSystem'], [], ["Get"]),
    "MgmtEp": MoMeta("MgmtEp", "mgmtEp", "mgmt-ep", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], ['topRoot'], ['mgmtSvc'], [None]),
    "MgmtIPv6IfAddr": MoMeta("MgmtIPv6IfAddr", "mgmtIPv6IfAddr", "if-ipv6", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin", "ext-lan-config"], ['mgmtIPv6IfConfig', 'networkElement'], [], ["Get", "Set"]),
    "MgmtIPv6IfConfig": MoMeta("MgmtIPv6IfConfig", "mgmtIPv6IfConfig", "ifConfig-ipv6", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin", "ext-lan-config"], ['mgmtIf', 'networkElement'], ['mgmtIPv6IfAddr'], ["Get", "Set"]),
    "MgmtIf": MoMeta("MgmtIf", "mgmtIf", "if-[id]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], ['mgmtController'], ['eventInst', 'faultInst', 'mgmtIPv6IfConfig', 'mgmtIfFsm', 'mgmtIfFsmTask'], ["Get"]),
    "MgmtIfFsm": MoMeta("MgmtIfFsm", "mgmtIfFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['mgmtIf'], ['mgmtIfFsmStage'], [None]),
    "MgmtIfFsmStage": MoMeta("MgmtIfFsmStage", "mgmtIfFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['mgmtIfFsm'], [], [None]),
    "MgmtIfFsmTask": MoMeta("MgmtIfFsmTask", "mgmtIfFsmTask", "task-[item]", VersionMeta.Version111a, "OutputOnly", 0x1, [], [""], ['mgmtIf'], [], [None]),
    "MgmtImportItem": MoMeta("MgmtImportItem", "mgmtImportItem", "imp-provider-[sysid]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], ['mgmtDataImporter'], ['faultInst'], ["Get"]),
    "MgmtImporter": MoMeta("MgmtImporter", "mgmtImporter", "import-config-[hostname]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], ['consumerInst', 'topSystem'], ['eventInst', 'faultInst', 'mgmtImporterFsm', 'mgmtImporterFsmTask'], ["Add", "Get", "Remove", "Set"]),
    "MgmtImporterFsm": MoMeta("MgmtImporterFsm", "mgmtImporterFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['mgmtImporter'], ['mgmtImporterFsmStage'], [None]),
    "MgmtImporterFsmStage": MoMeta("MgmtImporterFsmStage", "mgmtImporterFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['mgmtImporterFsm'], [], [None]),
    "MgmtImporterFsmTask": MoMeta("MgmtImporterFsmTask", "mgmtImporterFsmTask", "task-[item]", VersionMeta.Version101a, "OutputOnly", 0x1, [], [""], ['mgmtImporter'], [], ["Get"]),
    "MgmtInbandProfile": MoMeta("MgmtInbandProfile", "mgmtInbandProfile", "ib-profile", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], ['fabricLanCloud'], [], ["Get", "Set"]),
    "MgmtInterface": MoMeta("MgmtInterface", "mgmtInterface", "iface-[mode]", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-network", "ls-server"], ['computeInstance', 'lsServer', 'mgmtController'], ['mgmtVnet'], ["Add", "Get", "Remove", "Set"]),
    "MgmtKmip": MoMeta("MgmtKmip", "mgmtKmip", "kmip", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-storage", "ls-storage-policy"], ['mgmtSecurity'], ['mgmtKmipOperation'], ["get"]),
    "MgmtKmipCertPolicy": MoMeta("MgmtKmipCertPolicy", "mgmtKmipCertPolicy", "kmip-cert", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-oper", "ls-server-policy", "read-only"], ['orgDomainGroup'], [], ["add", "get", "remove", "set"]),
    "MgmtKmipOperation": MoMeta("MgmtKmipOperation", "mgmtKmipOperation", "remote-oper", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-storage", "ls-storage-policy"], ['mgmtKmip'], ['faultInst'], ["get", "set"]),
    "MgmtNamedKmipCertPolicy": MoMeta("MgmtNamedKmipCertPolicy", "mgmtNamedKmipCertPolicy", "kmip-cert-[name]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["aaa", "admin", "domain-group-management", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-oper", "ls-server-policy", "read-only"], ['orgDomainGroup'], [], ["add", "get", "remove", "set"]),
    "MgmtRegistryInfo": MoMeta("MgmtRegistryInfo", "mgmtRegistryInfo", "registryinfo", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "ext-lan-config"], ['topSystem'], ['eventInst', 'faultInst', 'mgmtRegistryInfoFsm', 'mgmtRegistryInfoFsmTask'], [None]),
    "MgmtRegistryInfoFsm": MoMeta("MgmtRegistryInfoFsm", "mgmtRegistryInfoFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['mgmtRegistryInfo'], ['mgmtRegistryInfoFsmStage'], [None]),
    "MgmtRegistryInfoFsmStage": MoMeta("MgmtRegistryInfoFsmStage", "mgmtRegistryInfoFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['mgmtRegistryInfoFsm'], [], [None]),
    "MgmtRegistryInfoFsmTask": MoMeta("MgmtRegistryInfoFsmTask", "mgmtRegistryInfoFsmTask", "task-[item]", VersionMeta.Version101a, "OutputOnly", 0x1, [], [""], ['mgmtRegistryInfo'], [], [None]),
    "MgmtSecurity": MoMeta("MgmtSecurity", "mgmtSecurity", "sec", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-storage", "ls-storage-policy"], ['computeBlade', 'computeRackUnit', 'computeServerUnit'], ['mgmtKmip'], ["get"]),
    "MgmtSvc": MoMeta("MgmtSvc", "mgmtSvc", "mgmt-svc-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], ['mgmtEp'], [], [None]),
    "MgmtVnet": MoMeta("MgmtVnet", "mgmtVnet", "network", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-network", "ls-server"], ['mgmtInterface'], ['storageIpV4PooledAddr', 'storageIpV4StaticAddr', 'vnicIpV4MgmtPooledAddr', 'vnicIpV4PooledAddr', 'vnicIpV4StaticAddr', 'vnicIpV6MgmtPooledAddr', 'vnicIpV6StaticAddr'], ["Add", "Get", "Remove", "Set"]),
    "NetNetGroupPermit": MoMeta("NetNetGroupPermit", "netNetGroupPermit", "ngperm-[name]", VersionMeta.Version201b, "InputOutput", 0x1, [], [""], ['orgOrg'], [], [None]),
    "NetworkElement": MoMeta("NetworkElement", "networkElement", "switch-[id]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "ext-lan-config"], ['computeSystem', 'topSystem'], ['equipmentFan', 'equipmentFanModule', 'equipmentLocatorLed', 'equipmentPsu', 'equipmentSwitchCard', 'eventInst', 'faultInst', 'firmwareStatus', 'mgmtController', 'mgmtIPv6IfAddr', 'mgmtIPv6IfConfig', 'networkElementFsm', 'networkElementFsmTask', 'networkElementOperation', 'networkSystemCACert', 'storageItem', 'swCardEnvStats', 'swEnvStats', 'swSystemStats'], ["Get", "Set"]),
    "NetworkElementFsm": MoMeta("NetworkElementFsm", "networkElementFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['networkElement'], ['networkElementFsmStage'], [None]),
    "NetworkElementFsmStage": MoMeta("NetworkElementFsmStage", "networkElementFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['networkElementFsm'], [], [None]),
    "NetworkElementFsmTask": MoMeta("NetworkElementFsmTask", "networkElementFsmTask", "task-[item]", VersionMeta.Version101a, "OutputOnly", 0x1, [], [""], ['networkElement'], [], [None]),
    "NetworkElementOperation": MoMeta("NetworkElementOperation", "networkElementOperation", "remote-oper", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "ext-lan-config"], ['networkElement'], ['faultInst'], ["get", "set"]),
    "NetworkSystemCACert": MoMeta("NetworkSystemCACert", "networkSystemCACert", "system-ca-cert", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "read-only"], ['networkElement'], [], [None]),
    "NfsClientDef": MoMeta("NfsClientDef", "nfsClientDef", "nfs-client-def-[ip]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], ['nfsExportDef'], ['eventInst', 'faultInst', 'nfsClientDefFsm', 'nfsClientDefFsmTask'], [None]),
    "NfsClientDefFsm": MoMeta("NfsClientDefFsm", "nfsClientDefFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['nfsClientDef'], ['nfsClientDefFsmStage'], [None]),
    "NfsClientDefFsmStage": MoMeta("NfsClientDefFsmStage", "nfsClientDefFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['nfsClientDefFsm'], [], [None]),
    "NfsClientDefFsmTask": MoMeta("NfsClientDefFsmTask", "nfsClientDefFsmTask", "task-[item]", VersionMeta.Version101a, "OutputOnly", 0x1, [], [""], ['nfsClientDef'], [], [None]),
    "NfsEp": MoMeta("NfsEp", "nfsEp", "nfs-ep", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], ['topRoot'], ['nfsExportDef'], [None]),
    "NfsExportDef": MoMeta("NfsExportDef", "nfsExportDef", "nfs-export-def-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], ['nfsEp'], ['eventInst', 'faultInst', 'nfsClientDef', 'nfsExportDefFsm', 'nfsExportDefFsmTask', 'storageItem'], [None]),
    "NfsExportDefFsm": MoMeta("NfsExportDefFsm", "nfsExportDefFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['nfsExportDef'], ['nfsExportDefFsmStage'], [None]),
    "NfsExportDefFsmStage": MoMeta("NfsExportDefFsmStage", "nfsExportDefFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['nfsExportDefFsm'], [], [None]),
    "NfsExportDefFsmTask": MoMeta("NfsExportDefFsmTask", "nfsExportDefFsmTask", "task-[item]", VersionMeta.Version111a, "OutputOnly", 0x1, [], [""], ['nfsExportDef'], [], [None]),
    "NfsMountDef": MoMeta("NfsMountDef", "nfsMountDef", "nfs-mount-def-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], ['consumerInst'], [], [None]),
    "NfsRepositorySpecPolicy": MoMeta("NfsRepositorySpecPolicy", "nfsRepositorySpecPolicy", "repository-spec", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "read-only"], ['orgDomainGroup'], [], [None]),
    "NwctrlDefinition": MoMeta("NwctrlDefinition", "nwctrlDefinition", "nwctrl-[name]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['fabricEthEstcCloud', 'orgDomainGroup', 'orgOrg', 'policySystemEp'], ['dpsecMac'], ["Add", "Get", "Remove", "Set"]),
    "ObserveFilter": MoMeta("ObserveFilter", "observeFilter", "filter-[filter_class_id]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], ['observeObserved'], [], [None]),
    "ObserveObserved": MoMeta("ObserveObserved", "observeObserved", "observed-[data_src_sys_id]-[id]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], ['extpolClient', 'extpolController', 'extpolProvider', 'extpolRegistry', 'observeObservedCont'], ['eventInst', 'faultInst', 'observeFilter', 'observeObservedFsm', 'observeObservedFsmTask'], [None]),
    "ObserveObservedCont": MoMeta("ObserveObservedCont", "observeObservedCont", "observe", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], ['topRoot'], ['observeObserved'], [None]),
    "ObserveObservedFsm": MoMeta("ObserveObservedFsm", "observeObservedFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['observeObserved'], ['observeObservedFsmStage'], [None]),
    "ObserveObservedFsmStage": MoMeta("ObserveObservedFsmStage", "observeObservedFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['observeObservedFsm'], [], [None]),
    "ObserveObservedFsmTask": MoMeta("ObserveObservedFsmTask", "observeObservedFsmTask", "task-[item]", VersionMeta.Version101a, "OutputOnly", 0x1, [], [""], ['observeObserved'], [], [None]),
    "OrgDomainFirmwareInfo": MoMeta("OrgDomainFirmwareInfo", "orgDomainFirmwareInfo", "domain-fw-info-[id]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["read-only"], ['orgMaintTagFirmwareReport'], [], ["Get"]),
    "OrgDomainGroup": MoMeta("OrgDomainGroup", "orgDomainGroup", "domaingroup-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "read-only"], ['orgDomainGroup'], ['aaaAuthRealm', 'aaaEpAuthProfile', 'aaaLdapEp', 'aaaLocale', 'aaaPwdProfile', 'aaaRadiusEp', 'aaaRole', 'aaaTacacsPlusEp', 'aaaUser', 'callhomeEp', 'commCimxml', 'commCoreFile', 'commDateTime', 'commDns', 'commEvtChannel', 'commHttp', 'commHttps', 'commShellSvcLimits', 'commSmashCLP', 'commSnmp', 'commSsh', 'commSyslog', 'commTelnet', 'commWebChannel', 'commWebSvcLimits', 'commWsman', 'commXmlClConnPolicy', 'computeAutoconfigPolicy', 'computeBladeDiscPolicy', 'computeBladeInheritPolicy', 'computeChassisConnPolicy', 'computeChassisDiscPolicy', 'computeDomainHwChangeDiscPolicy', 'computeDomainPortDiscPolicy', 'computeGroupMembershipRef', 'computeHwChangeDiscPolicy', 'computeModularChassisFanPolicy', 'computePortDiscPolicy', 'computePowerExtendedPolicy', 'computePowerSavePolicy', 'computePsuPolicy', 'computeServerDiscPolicy', 'computeServerMgmtPolicy', 'diagRunPolicy', 'domainProfile', 'extmgmtIfMonPolicy', 'fabricEp', 'fabricEthLinkProfile', 'fabricLacpPolicy', 'fabricLanCloudPolicy', 'fabricMulticastPolicy', 'fabricUdldLinkPolicy', 'faultPolicy', 'firmwareAutoSyncPolicy', 'firmwareCatalogPack', 'firmwareCatalogPackConfig', 'firmwareChassisPack', 'firmwareComputeHostPack', 'firmwareComputeMgmtPack', 'firmwareComputeStoragePack', 'firmwareConnectionPolicy', 'firmwareDownloadPolicy', 'firmwareInfraPack', 'firmwareInfraPackConfig', 'firmwareInfraPolicy', 'firmwarePolicy', 'flowctrlDefinition', 'hcDownloadPolicy', 'inbandPolicy', 'ippoolPool', 'lsmaintMaintPolicy', 'mgmtBackupPolicy', 'mgmtCfgExportPolicy', 'mgmtKmipCertPolicy', 'mgmtNamedKmipCertPolicy', 'nfsRepositorySpecPolicy', 'nwctrlDefinition', 'orgDomainGroup', 'pkiTP', 'policyIdentifierPolicy', 'policyLogProfile', 'powerEp', 'powerMgmtPolicy', 'qosclassDefinition', 'qosclassPolicy', 'sysdebugAutoCoreFileExportTarget', 'sysdebugMEpLogPolicy', 'topInfoSyncPolicy', 'trigMeta', 'trigPendingAckCount', 'trigSched', 'trigTest'], ["Add", "Get", "Remove", "Set"]),
    "OrgDomainGroupFirmwareReport": MoMeta("OrgDomainGroupFirmwareReport", "orgDomainGroupFirmwareReport", "firmware-report-[domain_group_dn]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], [], ['orgFirmwareVersionCount'], [None]),
    "OrgDomainGroupPolicy": MoMeta("OrgDomainGroupPolicy", "orgDomainGroupPolicy", "domaingroup-policy-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], ['orgOrg'], ['faultInst'], ["Add", "Get", "Remove", "Set"]),
    "OrgDomainGroupPolicyReport": MoMeta("OrgDomainGroupPolicyReport", "orgDomainGroupPolicyReport", "policy-report-[domain_group_dn]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "OrgExtension": MoMeta("OrgExtension", "orgExtension", "extension", VersionMeta.Version121a, "InputOutput", 0x1, [], ["read-only"], ['orgOrg'], [], ["Get"]),
    "OrgFirmwareVersionCount": MoMeta("OrgFirmwareVersionCount", "orgFirmwareVersionCount", "fw-version-count-[firmware_version]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], ['orgDomainGroupFirmwareReport'], [], [None]),
    "OrgMaintTagFirmwareReport": MoMeta("OrgMaintTagFirmwareReport", "orgMaintTagFirmwareReport", "firmware-report-[maint_tag]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["read-only"], [], ['orgDomainFirmwareInfo'], ["Get"]),
    "OrgOrg": MoMeta("OrgOrg", "orgOrg", "org-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], ['orgOrg'], ['aaaEpAuthProfile', 'adaptorHostEthIfProfile', 'adaptorHostFcIfProfile', 'adaptorHostIscsiIfProfile', 'biosVProfile', 'callhomeEp', 'cimcvmediaMountConfigPolicy', 'commCimxml', 'commCoreFile', 'commDateTime', 'commDns', 'commEvtChannel', 'commHttp', 'commHttps', 'commShellSvcLimits', 'commSmashCLP', 'commSnmp', 'commSsh', 'commSvcPolicy', 'commSyslog', 'commTelnet', 'commWebChannel', 'commWebSvcLimits', 'commWsman', 'computeAutoconfigPolicy', 'computeBladeDiscPolicy', 'computeBladeInheritPolicy', 'computeChassisConnPolicy', 'computeChassisDiscPolicy', 'computeDomainHwChangeDiscPolicy', 'computeDomainPortDiscPolicy', 'computeGraphicsCardPolicy', 'computeHwChangeDiscPolicy', 'computePool', 'computePoolingPolicy', 'computePortDiscPolicy', 'computePowerSyncPolicy', 'computeQual', 'computeRequirement', 'computeScrubPolicy', 'computeServerDiscPolicy', 'computeServerMgmtPolicy', 'computeSystemQual', 'computeTemplate', 'cpmaintMaintPolicy', 'diagRunPolicy', 'epqosDefinition', 'equipmentChassisProfile', 'equipmentChassisRequirement', 'equipmentComputeConnPolicy', 'equipmentPool', 'equipmentPoolingPolicy', 'equipmentQual', 'equipmentTemplate', 'equipmentTier', 'eventInst', 'fabricLacpPolicy', 'fabricLanCloudPolicy', 'fabricNetGroupPermit', 'fabricNetGroupReq', 'fabricOrgVlanPolicy', 'fabricUdldPolicy', 'fabricVConProfile', 'fabricVlanGroupReq', 'fabricVlanPermit', 'fabricVlanReq', 'faultInst', 'faultPolicy', 'fcpoolInitiators', 'firmwareCatalogPack', 'firmwareCatalogPackConfig', 'firmwareChassisPack', 'firmwareComputeHostPack', 'firmwareComputeMgmtPack', 'firmwareComputeStoragePack', 'firmwareDomainInfraProfile', 'firmwareInfraPack', 'firmwareInfraPackConfig', 'firmwareInfraPolicy', 'firmwareStoragePack', 'identpoolBlockQual', 'ippoolPool', 'iqnpoolPool', 'iscsiAuthProfile', 'lsServer', 'lsTier', 'lsWaitingUserAck', 'lsbootPolicy', 'lsmaintMaintPolicy', 'lstorageArrayRequirement', 'lstorageDiskGroupConfigPolicy', 'lstorageDiskZoningPolicy', 'lstorageProfile', 'macpoolPool', 'mgmtBackupPolicy', 'mgmtCfgExportPolicy', 'netNetGroupPermit', 'nwctrlDefinition', 'orgDomainGroupPolicy', 'orgExtension', 'orgOrg', 'orgOrgFsm', 'orgOrgFsmTask', 'orgOrgSource', 'orgSourceMask', 'policyDeviceProfile', 'policyIdentifierPolicy', 'policyLogProfile', 'policySystemProfile', 'powerPolicy', 'smartlicenseEp', 'solPolicy', 'statsThresholdPolicy', 'storageConnectionPolicy', 'storageLocalDiskConfigPolicy', 'testingCliPolicy', 'testingServiceProfile', 'testingSnmpPolicy', 'trigTest', 'uuidpoolPool', 'vnicDynamicCon', 'vnicDynamicConPolicy', 'vnicFcGroupTempl', 'vnicLanConnPolicy', 'vnicLanConnTempl', 'vnicSanConnPolicy', 'vnicSanConnTempl', 'vnicSriovHpnConPolicy', 'vnicUsnicConPolicy', 'vnicVhbaBehPolicy', 'vnicVmqConPolicy', 'vnicVnicBehPolicy'], ["Add", "Get", "Remove", "Set"]),
    "OrgOrgFsm": MoMeta("OrgOrgFsm", "orgOrgFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['orgOrg'], ['orgOrgFsmStage'], [None]),
    "OrgOrgFsmStage": MoMeta("OrgOrgFsmStage", "orgOrgFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['orgOrgFsm'], [], [None]),
    "OrgOrgFsmTask": MoMeta("OrgOrgFsmTask", "orgOrgFsmTask", "task-[item]", VersionMeta.Version101a, "OutputOnly", 0x1, [], [""], ['orgOrg'], [], ["Get"]),
    "OrgOrgSource": MoMeta("OrgOrgSource", "orgOrgSource", "org-source-[client_id]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], ['orgOrg'], [], ["Get"]),
    "OrgSourceMask": MoMeta("OrgSourceMask", "orgSourceMask", "src-mask", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], ['orgOrg'], [], ["Get"]),
    "OsController": MoMeta("OsController", "osController", "os-ctrl", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], ['storageProcessor'], ['firmwareBootDefinition', 'firmwareRunning'], [None]),
    "OsEthBondIntf": MoMeta("OsEthBondIntf", "osEthBondIntf", "bond-intf-[name]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], ['osInstance', 'storageEthLif'], ['osEthIntf'], [None]),
    "OsEthIntf": MoMeta("OsEthIntf", "osEthIntf", "intf-[name]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], ['osEthBondIntf', 'osInstance', 'storageEthLif'], [], [None]),
    "OsInstance": MoMeta("OsInstance", "osInstance", "os", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], ['computeBlade'], ['osEthBondIntf', 'osEthIntf', 'storageEthLif'], ["Get"]),
    "OsPrimarySlave": MoMeta("OsPrimarySlave", "osPrimarySlave", "slave-intf-[name]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "PkiCertReq": MoMeta("PkiCertReq", "pkiCertReq", "certreq", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin"], ['pkiKeyRing'], [], ["Add", "Get", "Remove", "Set"]),
    "PkiEp": MoMeta("PkiEp", "pkiEp", "pki-ext", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin"], ['policyDeviceProfile', 'topSystem'], ['eventInst', 'faultInst', 'pkiEpFsm', 'pkiEpFsmTask', 'pkiKeyRing', 'pkiTP'], ["Get"]),
    "PkiEpFsm": MoMeta("PkiEpFsm", "pkiEpFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['pkiEp'], ['pkiEpFsmStage'], [None]),
    "PkiEpFsmStage": MoMeta("PkiEpFsmStage", "pkiEpFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['pkiEpFsm'], [], [None]),
    "PkiEpFsmTask": MoMeta("PkiEpFsmTask", "pkiEpFsmTask", "task-[item]", VersionMeta.Version112a, "OutputOnly", 0x1, [], [""], ['pkiEp'], [], [None]),
    "PkiKeyRing": MoMeta("PkiKeyRing", "pkiKeyRing", "keyring-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin"], ['pkiEp'], ['faultInst', 'pkiCertReq'], ["Add", "Get", "Remove", "Set"]),
    "PkiTP": MoMeta("PkiTP", "pkiTP", "tp-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin"], ['orgDomainGroup', 'pkiEp'], ['faultInst'], ["Add", "Get", "Remove", "Set"]),
    "PolicyChildClass": MoMeta("PolicyChildClass", "policyChildClass", "child-[name]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], ['policyDestClass'], [], ["get"]),
    "PolicyCluster": MoMeta("PolicyCluster", "policyCluster", "cluster-[converted_dn]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin"], ['policyUniverse'], ['policySource'], ["Get"]),
    "PolicyCommunication": MoMeta("PolicyCommunication", "policyCommunication", "comm-ctrl", VersionMeta.Version131a, "InputOutput", 0x1, [], ["aaa", "admin"], ['policyControlEp'], ['policyControlledInstance', 'policyControlledType'], ["Add", "Get", "Set"]),
    "PolicyCommunicationOp": MoMeta("PolicyCommunicationOp", "policyCommunicationOp", "comm-ctrl", VersionMeta.Version151a, "InputOutput", 0x1, [], ["aaa", "admin"], ['policyControlEpOp'], ['faultInst'], ["Get", "Set"]),
    "PolicyConfigBackup": MoMeta("PolicyConfigBackup", "policyConfigBackup", "cfg-backup-ctrl", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "operations"], ['policyControlEp'], ['policyControlledInstance', 'policyControlledType'], ["Add", "Get", "Set"]),
    "PolicyConfigBackupOp": MoMeta("PolicyConfigBackupOp", "policyConfigBackupOp", "cfg-backup-ctrl", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "operations"], ['policyControlEpOp'], ['faultInst'], ["Get", "Set"]),
    "PolicyConfigError": MoMeta("PolicyConfigError", "policyConfigError", "policy-error", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], ['extpolClient'], ['faultInst'], ["get"]),
    "PolicyContext": MoMeta("PolicyContext", "policyContext", "context-[name]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], ['policySourceApp'], ['policyScope'], ["get"]),
    "PolicyControlEp": MoMeta("PolicyControlEp", "policyControlEp", "control-ep-policy", VersionMeta.Version121a, "InputOutput", 0x1, [], ["admin"], ['computeSystem', 'fabricSystem'], ['policyCommunication', 'policyConfigBackup', 'policyControlEpOperation', 'policyDateTime', 'policyDestEp', 'policyDiscovery', 'policyDns', 'policyEquipment', 'policyFault', 'policyInfraFirmware', 'policyMEp', 'policyModularChassisFan', 'policyMonitoring', 'policyPortConfig', 'policyPowerExtended', 'policyPowerMgmt', 'policyPowerSave', 'policyPsu', 'policySecurity', 'policySourceApp', 'policyStorageAutoConfig'], ["Add", "Get", "Remove", "Set"]),
    "PolicyControlEpOp": MoMeta("PolicyControlEpOp", "policyControlEpOp", "control-ep-[host_name_or_ip]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin"], ['fabricDomainEp'], ['eventInst', 'faultInst', 'policyCommunicationOp', 'policyConfigBackupOp', 'policyControlEpOpFsm', 'policyControlEpOpFsmTask', 'policyDateTimeOp', 'policyDiscoveryOp', 'policyDnsOp', 'policyEquipmentOp', 'policyFaultOp', 'policyInfraFirmwareOp', 'policyMEpOp', 'policyModularChassisFanOp', 'policyMonitoringOp', 'policyPortConfigOp', 'policyPowerExtendedOp', 'policyPowerMgmtOp', 'policyPowerSaveOp', 'policyPsuOp', 'policySecurityOp', 'policyStorageAutoConfigOp'], ["Add", "Get", "Remove", "Set"]),
    "PolicyControlEpOpFsm": MoMeta("PolicyControlEpOpFsm", "policyControlEpOpFsm", "fsm", VersionMeta.Version151a, "OutputOnly", 0x1, [], [""], ['policyControlEpOp'], ['policyControlEpOpFsmStage'], [None]),
    "PolicyControlEpOpFsmStage": MoMeta("PolicyControlEpOpFsmStage", "policyControlEpOpFsmStage", "stage-[name]", VersionMeta.Version151a, "OutputOnly", 0x1, [], [""], ['policyControlEpOpFsm'], [], [None]),
    "PolicyControlEpOpFsmTask": MoMeta("PolicyControlEpOpFsmTask", "policyControlEpOpFsmTask", "task-[item]", VersionMeta.Version151a, "OutputOnly", 0x1, [], [""], ['policyControlEpOp'], [], [None]),
    "PolicyControlEpOperation": MoMeta("PolicyControlEpOperation", "policyControlEpOperation", "remote-oper", VersionMeta.Version121a, "InputOutput", 0x1, [], ["admin"], ['policyControlEp'], ['faultInst'], ["Get", "Set"]),
    "PolicyControlledInstance": MoMeta("PolicyControlledInstance", "policyControlledInstance", "ctrlled-[type]-inst-[name]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin"], ['policyCommunication', 'policyConfigBackup', 'policyDateTime', 'policyDiscovery', 'policyDns', 'policyEquipment', 'policyFault', 'policyInfraFirmware', 'policyMEp', 'policyModularChassisFan', 'policyMonitoring', 'policyPortConfig', 'policyPowerExtended', 'policyPowerMgmt', 'policyPowerSave', 'policyPsu', 'policySecurity', 'policyStorageAutoConfig'], [], ["Get"]),
    "PolicyControlledType": MoMeta("PolicyControlledType", "policyControlledType", "ctrlled-type-[type]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin"], ['policyCommunication', 'policyConfigBackup', 'policyDateTime', 'policyDiscovery', 'policyDns', 'policyEquipment', 'policyFault', 'policyInfraFirmware', 'policyMEp', 'policyModularChassisFan', 'policyMonitoring', 'policyPortConfig', 'policyPowerExtended', 'policyPowerMgmt', 'policyPowerSave', 'policyPsu', 'policySecurity', 'policyStorageAutoConfig'], [], ["Get"]),
    "PolicyDateTime": MoMeta("PolicyDateTime", "policyDateTime", "datetime-ctrl", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-security", "operations"], ['policyControlEp'], ['policyControlledInstance', 'policyControlledType'], ["Add", "Get", "Set"]),
    "PolicyDateTimeOp": MoMeta("PolicyDateTimeOp", "policyDateTimeOp", "datetime-ctrl", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-security", "operations"], ['policyControlEpOp'], ['faultInst'], ["Get", "Set"]),
    "PolicyDestClass": MoMeta("PolicyDestClass", "policyDestClass", "dest-[name]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], ['policyDestEp', 'policyPolicyDestClass'], ['policyChildClass'], ["get"]),
    "PolicyDestEp": MoMeta("PolicyDestEp", "policyDestEp", "dest-ep", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], ['policyControlEp'], ['policyDestClass'], ["get"]),
    "PolicyDeviceProfile": MoMeta("PolicyDeviceProfile", "policyDeviceProfile", "deviceprofile-[name]", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin"], ['orgOrg'], ['aaaAuthRealm', 'aaaLdapEp', 'aaaLocale', 'aaaPwdProfile', 'aaaRadiusEp', 'aaaRole', 'aaaTacacsPlusEp', 'aaaUser', 'callhomeEp', 'commCoreFile', 'commDateTime', 'commDns', 'commHttp', 'commHttps', 'commShellSvcLimits', 'commSnmp', 'commSsh', 'commSyslog', 'commTelnet', 'commWebSvcLimits', 'extmgmtIfMonPolicy', 'faultPolicy', 'mgmtBackupPolicy', 'mgmtCfgExportPolicy', 'pkiEp', 'smartlicenseEp', 'sysdebugAutoCoreFileExportTarget'], ["Get", "Set"]),
    "PolicyDigest": MoMeta("PolicyDigest", "policyDigest", "policy-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "PolicyDiscovery": MoMeta("PolicyDiscovery", "policyDiscovery", "discovery-ctrl", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "pn-policy"], ['policyControlEp'], ['policyControlledInstance', 'policyControlledType'], [None]),
    "PolicyDiscoveryOp": MoMeta("PolicyDiscoveryOp", "policyDiscoveryOp", "discovery-ctrl", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "pn-policy"], ['policyControlEpOp'], ['faultInst'], ["Get", "Set"]),
    "PolicyDns": MoMeta("PolicyDns", "policyDns", "dns-ctrl", VersionMeta.Version131a, "InputOutput", 0x1, [], ["aaa", "admin", "ext-lan-config"], ['policyControlEp'], ['policyControlledInstance', 'policyControlledType'], ["Add", "Get", "Set"]),
    "PolicyDnsOp": MoMeta("PolicyDnsOp", "policyDnsOp", "dns-ctrl", VersionMeta.Version151a, "InputOutput", 0x1, [], ["aaa", "admin", "ext-lan-config"], ['policyControlEpOp'], ['faultInst'], ["Get", "Set"]),
    "PolicyElement": MoMeta("PolicyElement", "policyElement", "element-[converted_dn]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin"], ['policyLocalMap'], [], ["Get"]),
    "PolicyEquipment": MoMeta("PolicyEquipment", "policyEquipment", "equipment-ctrl", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-policy"], ['policyControlEp'], ['policyControlledInstance', 'policyControlledType'], ["Get"]),
    "PolicyEquipmentOp": MoMeta("PolicyEquipmentOp", "policyEquipmentOp", "equipment-ctrl", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-policy"], ['policyControlEpOp'], ['faultInst'], ["Get", "Set"]),
    "PolicyFault": MoMeta("PolicyFault", "policyFault", "fault-ctrl", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "fault"], ['policyControlEp'], ['policyControlledInstance', 'policyControlledType'], ["Add", "Get", "Set"]),
    "PolicyFaultOp": MoMeta("PolicyFaultOp", "policyFaultOp", "fault-ctrl", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "fault"], ['policyControlEpOp'], ['faultInst'], ["Get", "Set"]),
    "PolicyIdentifierPolicy": MoMeta("PolicyIdentifierPolicy", "policyIdentifierPolicy", "identifier-policy", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "ls-config"], ['orgDomainGroup', 'orgOrg'], [], ["Get", "Set"]),
    "PolicyInfraFirmware": MoMeta("PolicyInfraFirmware", "policyInfraFirmware", "fabric-fw-ctrl", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "operations"], ['policyControlEp'], ['policyControlledInstance', 'policyControlledType'], ["Add", "Get", "Set"]),
    "PolicyInfraFirmwareOp": MoMeta("PolicyInfraFirmwareOp", "policyInfraFirmwareOp", "fabric-fw-ctrl", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "operations"], ['policyControlEpOp'], ['faultInst'], ["Get", "Set"]),
    "PolicyLocalMap": MoMeta("PolicyLocalMap", "policyLocalMap", "localmap", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin"], ['topRoot'], ['policyElement'], ["Get"]),
    "PolicyLogProfile": MoMeta("PolicyLogProfile", "policyLogProfile", "logprof-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], ['orgDomainGroup', 'orgOrg'], [], [None]),
    "PolicyMEp": MoMeta("PolicyMEp", "policyMEp", "mep-ctrl", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "operations"], ['policyControlEp'], ['policyControlledInstance', 'policyControlledType'], ["Add", "Get", "Set"]),
    "PolicyMEpOp": MoMeta("PolicyMEpOp", "policyMEpOp", "mep-ctrl", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "operations"], ['policyControlEpOp'], ['faultInst'], ["Get", "Set"]),
    "PolicyModularChassisFan": MoMeta("PolicyModularChassisFan", "policyModularChassisFan", "modularchassisfan-ctrl", VersionMeta.Version201u, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-policy"], ['policyControlEp'], ['policyControlledInstance', 'policyControlledType'], [None]),
    "PolicyModularChassisFanOp": MoMeta("PolicyModularChassisFanOp", "policyModularChassisFanOp", "modularchassisfan-ctrl", VersionMeta.Version201u, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-policy"], ['policyControlEpOp'], ['faultInst'], [None]),
    "PolicyMonitoring": MoMeta("PolicyMonitoring", "policyMonitoring", "monitoring-ctrl", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "operations"], ['policyControlEp'], ['policyControlledInstance', 'policyControlledType'], ["Add", "Get", "Set"]),
    "PolicyMonitoringOp": MoMeta("PolicyMonitoringOp", "policyMonitoringOp", "monitoring-ctrl", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "operations"], ['policyControlEpOp'], ['faultInst'], ["Get", "Set"]),
    "PolicyPolicyDestClass": MoMeta("PolicyPolicyDestClass", "policyPolicyDestClass", "destclass", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], ['policyScope'], ['policyDestClass'], ["get"]),
    "PolicyPolicyEp": MoMeta("PolicyPolicyEp", "policyPolicyEp", "policy-ep", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], ['topRoot'], ['policyPolicyScopeCont', 'policySystemEp'], [None]),
    "PolicyPolicyRequestor": MoMeta("PolicyPolicyRequestor", "policyPolicyRequestor", "requestor-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], ['policyPolicyScope'], [], [None]),
    "PolicyPolicyScope": MoMeta("PolicyPolicyScope", "policyPolicyScope", "scope-[policy_type]-[resolve_type]-[policy_name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], ['policyPolicyScopeContext'], ['eventInst', 'faultInst', 'policyPolicyRequestor', 'policyPolicyScopeFsm', 'policyPolicyScopeFsmTask'], [None]),
    "PolicyPolicyScopeCont": MoMeta("PolicyPolicyScopeCont", "policyPolicyScopeCont", "scope-cont-[app_type]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], ['extpolClient', 'extpolController', 'extpolProvider', 'extpolRegistry', 'policyPolicyEp'], ['policyPolicyScopeContext'], [None]),
    "PolicyPolicyScopeContext": MoMeta("PolicyPolicyScopeContext", "policyPolicyScopeContext", "context-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], ['policyPolicyScopeCont'], ['policyPolicyScope'], [None]),
    "PolicyPolicyScopeFsm": MoMeta("PolicyPolicyScopeFsm", "policyPolicyScopeFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['policyPolicyScope'], ['policyPolicyScopeFsmStage'], [None]),
    "PolicyPolicyScopeFsmStage": MoMeta("PolicyPolicyScopeFsmStage", "policyPolicyScopeFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['policyPolicyScopeFsm'], [], [None]),
    "PolicyPolicyScopeFsmTask": MoMeta("PolicyPolicyScopeFsmTask", "policyPolicyScopeFsmTask", "task-[item]", VersionMeta.Version101a, "OutputOnly", 0x1, [], [""], ['policyPolicyScope'], [], [None]),
    "PolicyPortConfig": MoMeta("PolicyPortConfig", "policyPortConfig", "portconfig-ctrl", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-policy"], ['policyControlEp'], ['policyControlledInstance', 'policyControlledType'], ["Get"]),
    "PolicyPortConfigOp": MoMeta("PolicyPortConfigOp", "policyPortConfigOp", "portconfig-ctrl", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-policy"], ['policyControlEpOp'], ['faultInst'], ["Get", "Set"]),
    "PolicyPowerExtended": MoMeta("PolicyPowerExtended", "policyPowerExtended", "powerextended-ctrl", VersionMeta.Version201u, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-policy"], ['policyControlEp'], ['policyControlledInstance', 'policyControlledType'], [None]),
    "PolicyPowerExtendedOp": MoMeta("PolicyPowerExtendedOp", "policyPowerExtendedOp", "powerextended-ctrl", VersionMeta.Version201u, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-policy"], ['policyControlEpOp'], ['faultInst'], [None]),
    "PolicyPowerMgmt": MoMeta("PolicyPowerMgmt", "policyPowerMgmt", "powermgmt-ctrl", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "power-mgmt"], ['policyControlEp'], ['policyControlledInstance', 'policyControlledType'], ["Add", "Get", "Set"]),
    "PolicyPowerMgmtOp": MoMeta("PolicyPowerMgmtOp", "policyPowerMgmtOp", "powermgmt-ctrl", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "power-mgmt"], ['policyControlEpOp'], ['faultInst'], ["Get", "Set"]),
    "PolicyPowerSave": MoMeta("PolicyPowerSave", "policyPowerSave", "powersave-ctrl", VersionMeta.Version201u, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-policy"], ['policyControlEp'], ['policyControlledInstance', 'policyControlledType'], [None]),
    "PolicyPowerSaveOp": MoMeta("PolicyPowerSaveOp", "policyPowerSaveOp", "powersave-ctrl", VersionMeta.Version201u, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-policy"], ['policyControlEpOp'], ['faultInst'], [None]),
    "PolicyProxyMo": MoMeta("PolicyProxyMo", "policyProxyMo", "", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin"], [], [], [None]),
    "PolicyPsu": MoMeta("PolicyPsu", "policyPsu", "psu-ctrl", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-policy"], ['policyControlEp'], ['policyControlledInstance', 'policyControlledType'], ["Add", "Get", "Set"]),
    "PolicyPsuOp": MoMeta("PolicyPsuOp", "policyPsuOp", "psu-ctrl", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-policy"], ['policyControlEpOp'], ['faultInst'], ["Get", "Set"]),
    "PolicyRequestor": MoMeta("PolicyRequestor", "policyRequestor", "requestor-[name]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], ['policyScope'], [], ["get"]),
    "PolicyScope": MoMeta("PolicyScope", "policyScope", "scope-[policy_type]-[resolve_type]-[policy_name]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], ['policyContext'], ['policyPolicyDestClass', 'policyRequestor'], ["get"]),
    "PolicySecurity": MoMeta("PolicySecurity", "policySecurity", "security-ctrl", VersionMeta.Version131a, "InputOutput", 0x1, [], ["aaa", "admin"], ['policyControlEp'], ['policyControlledInstance', 'policyControlledType'], ["Add", "Get", "Set"]),
    "PolicySecurityOp": MoMeta("PolicySecurityOp", "policySecurityOp", "security-ctrl", VersionMeta.Version151a, "InputOutput", 0x1, [], ["aaa", "admin"], ['policyControlEpOp'], ['faultInst'], ["Get", "Set"]),
    "PolicySource": MoMeta("PolicySource", "policySource", "source-[id]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin"], ['policyCluster'], [], ["Get"]),
    "PolicySourceApp": MoMeta("PolicySourceApp", "policySourceApp", "source-[source_dme]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], ['policyControlEp'], ['policyContext'], ["get"]),
    "PolicyStorageAutoConfig": MoMeta("PolicyStorageAutoConfig", "policyStorageAutoConfig", "storage-autoconfig-ctrl", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "ls-storage", "pn-policy"], ['policyControlEp'], ['policyControlledInstance', 'policyControlledType'], [None]),
    "PolicyStorageAutoConfigOp": MoMeta("PolicyStorageAutoConfigOp", "policyStorageAutoConfigOp", "storage-autoconfig-ctrl", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "ls-storage", "pn-policy"], ['policyControlEpOp'], ['faultInst'], ["Get", "Set"]),
    "PolicySystemEp": MoMeta("PolicySystemEp", "policySystemEp", "system-policies", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], ['policyPolicyEp'], ['adaptorHostEthIfProfile', 'lsbootPolicy', 'nwctrlDefinition', 'powerPolicy', 'solPolicy'], [None]),
    "PolicySystemProfile": MoMeta("PolicySystemProfile", "policySystemProfile", "SystemProfile", VersionMeta.Version112a, "InputOutput", 0x1, [], ["read-only"], ['orgOrg'], ['faultInst'], ["Get", "Set"]),
    "PolicyTracker": MoMeta("PolicyTracker", "policyTracker", "policytracker-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "PolicyUniverse": MoMeta("PolicyUniverse", "policyUniverse", "universe-[type]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin"], ['topRoot'], ['policyCluster'], ["Get"]),
    "PortGroup": MoMeta("PortGroup", "portGroup", "[type]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['equipmentIOCard', 'equipmentSharedIOModule', 'equipmentSwitchCard', 'equipmentSwitchIOCard'], ['etherPIo', 'etherServerIntFIo', 'etherSwitchIntFIo', 'fcPIo', 'portSubGroup'], ["Get"]),
    "PortSubGroup": MoMeta("PortSubGroup", "portSubGroup", "aggr-port-[aggr_port_id]", VersionMeta.Version121a, "InputOutput", 0x1, [], ["read-only"], ['portGroup'], ['etherPIo', 'fcPIo'], ["Get", "Set"]),
    "PowerBudget": MoMeta("PowerBudget", "powerBudget", "budget", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "power-mgmt"], ['computeExtBoard', 'storageBlade'], ['powerProfiledPower'], ["Get", "Set"]),
    "PowerChassisMember": MoMeta("PowerChassisMember", "powerChassisMember", "ch-member-[id]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "power-mgmt", "read-only"], ['powerGroup'], [], ["Add", "Get", "Remove"]),
    "PowerEp": MoMeta("PowerEp", "powerEp", "power-ep", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "power-mgmt"], ['orgDomainGroup'], ['powerGroup'], ["Get"]),
    "PowerGroup": MoMeta("PowerGroup", "powerGroup", "group-[name]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-config-policy", "read-only"], ['powerEp'], ['powerChassisMember'], ["Get"]),
    "PowerGroupQual": MoMeta("PowerGroupQual", "powerGroupQual", "power-group-[group_name]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['computeQual'], [], [None]),
    "PowerGroupStats": MoMeta("PowerGroupStats", "powerGroupStats", "stats", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [], ['powerGroupStatsHist'], [None]),
    "PowerGroupStatsHist": MoMeta("PowerGroupStatsHist", "powerGroupStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], ['powerGroupStats'], [], [None]),
    "PowerMgmtPolicy": MoMeta("PowerMgmtPolicy", "powerMgmtPolicy", "pwr-mgmt-policy", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "domain-group-management", "power-mgmt"], ['orgDomainGroup'], [], ["Add", "Get", "Remove", "Set"]),
    "PowerPolicy": MoMeta("PowerPolicy", "powerPolicy", "power-policy-[name]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['orgOrg', 'policySystemEp'], [], ["Add", "Get", "Remove", "Set"]),
    "PowerProfiledPower": MoMeta("PowerProfiledPower", "powerProfiledPower", "prof-power", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "power-mgmt"], ['powerBudget'], [], ["Get"]),
    "ProcDoer": MoMeta("ProcDoer", "procDoer", "doer[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], ['procManager'], [], ["Get"]),
    "ProcManager": MoMeta("ProcManager", "procManager", "proc-info", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], ['topRoot'], ['procDoer', 'procPrt', 'procPrtCounts', 'procStimulusCounts', 'procSvc', 'procTxCounts'], ["Get"]),
    "ProcPrt": MoMeta("ProcPrt", "procPrt", "prt[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], ['procManager'], [], ["Get"]),
    "ProcPrtCounts": MoMeta("ProcPrtCounts", "procPrtCounts", "prtCnt", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], ['procManager'], [], ["Get"]),
    "ProcStimulusCounts": MoMeta("ProcStimulusCounts", "procStimulusCounts", "stim", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], ['procManager', 'procSvc'], [], ["Get"]),
    "ProcSvc": MoMeta("ProcSvc", "procSvc", "svc-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], ['procManager'], ['procStimulusCounts', 'procTxCounts'], ["Get"]),
    "ProcTxCounts": MoMeta("ProcTxCounts", "procTxCounts", "tx", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], ['procManager', 'procSvc'], [], ["Get"]),
    "ProcessorEnvStats": MoMeta("ProcessorEnvStats", "processorEnvStats", "env-stats", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['processorUnit'], ['processorEnvStatsHist'], [None]),
    "ProcessorEnvStatsHist": MoMeta("ProcessorEnvStatsHist", "processorEnvStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], ['processorEnvStats'], [], [None]),
    "ProcessorErrorStats": MoMeta("ProcessorErrorStats", "processorErrorStats", "error-stats", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['processorUnit'], ['processorErrorStatsHist'], [None]),
    "ProcessorErrorStatsHist": MoMeta("ProcessorErrorStatsHist", "processorErrorStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], ['processorErrorStats'], [], [None]),
    "ProcessorQual": MoMeta("ProcessorQual", "processorQual", "cpu", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "pn-policy", "read-only"], ['computeQual'], [], ["Add", "Get", "Remove", "Set"]),
    "ProcessorRuntime": MoMeta("ProcessorRuntime", "processorRuntime", "cpu-rt", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['computeBlade'], ['processorRuntimeHist'], [None]),
    "ProcessorRuntimeHist": MoMeta("ProcessorRuntimeHist", "processorRuntimeHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], ['processorRuntime'], [], [None]),
    "ProcessorUnit": MoMeta("ProcessorUnit", "processorUnit", "cpu-[id]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['computeBoard'], ['faultInst', 'processorEnvStats', 'processorErrorStats'], ["Get"]),
    "ProcessorUnitAssocCtx": MoMeta("ProcessorUnitAssocCtx", "processorUnitAssocCtx", "procunit-assoc-ctx", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['lsServerAssocCtx'], [], ["Get"]),
    "QosclassDefinition": MoMeta("QosclassDefinition", "qosclassDefinition", "classes", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ext-lan-qos", "ext-san-qos", "ls-network", "ls-network-policy", "ls-qos-policy"], ['fabricLanCloud', 'orgDomainGroup'], ['firmwareAck', 'qosclassEthBE', 'qosclassEthClassified', 'qosclassFc'], ["Get", "Set"]),
    "QosclassEthBE": MoMeta("QosclassEthBE", "qosclassEthBE", "class-best-effort", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ext-lan-qos", "ext-san-qos", "ls-network", "ls-network-policy", "ls-qos-policy"], ['qosclassDefinition', 'qosclassPolicy'], [], ["Get", "Set"]),
    "QosclassEthClassified": MoMeta("QosclassEthClassified", "qosclassEthClassified", "class-[priority]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ext-lan-qos", "ext-san-qos", "ls-network", "ls-network-policy", "ls-qos-policy"], ['qosclassDefinition', 'qosclassPolicy'], [], ["Get", "Set"]),
    "QosclassFc": MoMeta("QosclassFc", "qosclassFc", "class-fc", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ext-lan-qos", "ext-san-qos", "ls-network", "ls-network-policy", "ls-qos-policy"], ['qosclassDefinition', 'qosclassPolicy'], [], ["Get", "Set"]),
    "QosclassPolicy": MoMeta("QosclassPolicy", "qosclassPolicy", "qosclass-[name]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "ext-lan-qos", "ext-san-qos", "ls-network", "ls-network-policy", "ls-qos-policy"], ['orgDomainGroup'], ['qosclassEthBE', 'qosclassEthClassified', 'qosclassFc'], ["add", "get", "remove", "set"]),
    "QueryDependencyContext": MoMeta("QueryDependencyContext", "queryDependencyContext", "dependency-[session_id]", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin"], ['queryEp'], ['faultInst', 'queryresultDomainGroupEp', 'queryresultOrgEp'], ["Add", "Get", "Remove", "Set"]),
    "QueryDependencyRef": MoMeta("QueryDependencyRef", "queryDependencyRef", "depref-[index]", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin"], ['queryImportContext'], [], ["Add", "Get", "Remove", "Set"]),
    "QueryEp": MoMeta("QueryEp", "queryEp", "query", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin"], ['topRoot'], ['queryDependencyContext', 'queryImportContext', 'queryUsageContext'], ["Get"]),
    "QueryImportContext": MoMeta("QueryImportContext", "queryImportContext", "import-[session_id]", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin"], ['queryEp'], ['faultInst', 'queryDependencyRef'], ["Add", "Get", "Remove", "Set"]),
    "QueryUsageContext": MoMeta("QueryUsageContext", "queryUsageContext", "usage-[session_id]", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin"], ['queryEp'], ['faultInst', 'queryresultUsage'], ["Add", "Get", "Remove", "Set"]),
    "QueryresultDependency": MoMeta("QueryresultDependency", "queryresultDependency", "dependency-[ref_converted_dn]", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin"], ['queryresultDomainGroupEp', 'queryresultOrgEp'], [], ["Get"]),
    "QueryresultDomainGroupEp": MoMeta("QueryresultDomainGroupEp", "queryresultDomainGroupEp", "dg-ep", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin"], ['queryDependencyContext'], ['queryresultDependency'], ["Get"]),
    "QueryresultOrgEp": MoMeta("QueryresultOrgEp", "queryresultOrgEp", "org-ep", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin"], ['queryDependencyContext'], ['queryresultDependency'], ["Get"]),
    "QueryresultUsage": MoMeta("QueryresultUsage", "queryresultUsage", "usage-[ref_converted_dn]", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin"], ['queryUsageContext'], [], ["Get"]),
    "SecurityUnit": MoMeta("SecurityUnit", "securityUnit", "security-unit-[id]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["read-only"], ['computeBoard'], [], ["Get"]),
    "SesDiskSlotEp": MoMeta("SesDiskSlotEp", "sesDiskSlotEp", "disk-slot-ep-[enc_id]-id-[id]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["read-only"], ['sesEnclosure'], [], [None]),
    "SesEnclosure": MoMeta("SesEnclosure", "sesEnclosure", "ses-enc-[id]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["read-only"], ['equipmentChassis'], ['sesDiskSlotEp'], [None]),
    "SmartcallhomeHttpProxy": MoMeta("SmartcallhomeHttpProxy", "smartcallhomeHttpProxy", "proxy", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "operations"], ['callhomeEp'], [], ["Add", "Get", "Remove", "Set"]),
    "SmartcallhomePeriodicInventoryStatus": MoMeta("SmartcallhomePeriodicInventoryStatus", "smartcallhomePeriodicInventoryStatus", "inventory-status", VersionMeta.Version141a, "InputOutput", 0x1, [], ["read-only"], ['callhomeHolder'], [], ["Get"]),
    "SmartcallhomePeriodicSystemInventory": MoMeta("SmartcallhomePeriodicSystemInventory", "smartcallhomePeriodicSystemInventory", "smart-periodic-inventory", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "operations"], ['callhomeEp'], [], ["Get", "Set"]),
    "SmartcallhomePolicy": MoMeta("SmartcallhomePolicy", "smartcallhomePolicy", "smart-policy-[cause]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "fault"], ['callhomeEp'], [], ["Add", "Get", "Remove", "Set"]),
    "SmartcallhomeProfile": MoMeta("SmartcallhomeProfile", "smartcallhomeProfile", "smart-profile-[name]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "operations"], ['callhomeEp'], [], ["Get"]),
    "SmartcallhomeSource": MoMeta("SmartcallhomeSource", "smartcallhomeSource", "sch-source", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "operations"], ['callhomeEp'], [], ["Get", "Set"]),
    "SmartcallhomeTransportGateway": MoMeta("SmartcallhomeTransportGateway", "smartcallhomeTransportGateway", "transport-gateway", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "operations"], ['callhomeEp'], [], ["Add", "Get", "Remove", "Set"]),
    "SmartlicenseAgent": MoMeta("SmartlicenseAgent", "smartlicenseAgent", "Agent", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin"], ['smartlicenseHolder'], ['eventInst', 'faultInst', 'smartlicenseAgentFsm', 'smartlicenseAgentFsmTask', 'smartlicenseTest'], ["Get"]),
    "SmartlicenseAgentFsm": MoMeta("SmartlicenseAgentFsm", "smartlicenseAgentFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['smartlicenseAgent'], ['smartlicenseAgentFsmStage'], [None]),
    "SmartlicenseAgentFsmStage": MoMeta("SmartlicenseAgentFsmStage", "smartlicenseAgentFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['smartlicenseAgentFsm'], [], [None]),
    "SmartlicenseAgentFsmTask": MoMeta("SmartlicenseAgentFsmTask", "smartlicenseAgentFsmTask", "task-[item]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['smartlicenseAgent'], [], [None]),
    "SmartlicenseEntitlement": MoMeta("SmartlicenseEntitlement", "smartlicenseEntitlement", "entitlement[tag]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin"], ['smartlicenseEntitlementEp', 'smartlicenseHolder'], ['faultInst'], ["Get"]),
    "SmartlicenseEntitlementEp": MoMeta("SmartlicenseEntitlementEp", "smartlicenseEntitlementEp", "entitlement-ep", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin"], ['smartlicenseHolder'], ['eventInst', 'faultInst', 'smartlicenseEntitlement', 'smartlicenseEntitlementEpFsm', 'smartlicenseEntitlementEpFsmTask'], ["Get"]),
    "SmartlicenseEntitlementEpFsm": MoMeta("SmartlicenseEntitlementEpFsm", "smartlicenseEntitlementEpFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['smartlicenseEntitlementEp'], ['smartlicenseEntitlementEpFsmStage'], [None]),
    "SmartlicenseEntitlementEpFsmStage": MoMeta("SmartlicenseEntitlementEpFsmStage", "smartlicenseEntitlementEpFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['smartlicenseEntitlementEpFsm'], [], [None]),
    "SmartlicenseEntitlementEpFsmTask": MoMeta("SmartlicenseEntitlementEpFsmTask", "smartlicenseEntitlementEpFsmTask", "task-[item]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['smartlicenseEntitlementEp'], [], [None]),
    "SmartlicenseEp": MoMeta("SmartlicenseEp", "smartlicenseEp", "smart-license", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin"], ['orgOrg', 'policyDeviceProfile', 'smartlicenseHolder'], [], ["Get"]),
    "SmartlicenseHolder": MoMeta("SmartlicenseHolder", "smartlicenseHolder", "smartlicense", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin"], ['topRoot'], ['callhomeEp', 'eventInst', 'faultInst', 'smartlicenseAgent', 'smartlicenseEntitlement', 'smartlicenseEntitlementEp', 'smartlicenseEp', 'smartlicenseHolderFsm', 'smartlicenseHolderFsmTask'], ["Get"]),
    "SmartlicenseHolderFsm": MoMeta("SmartlicenseHolderFsm", "smartlicenseHolderFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['smartlicenseHolder'], ['smartlicenseHolderFsmStage'], [None]),
    "SmartlicenseHolderFsmStage": MoMeta("SmartlicenseHolderFsmStage", "smartlicenseHolderFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['smartlicenseHolderFsm'], [], [None]),
    "SmartlicenseHolderFsmTask": MoMeta("SmartlicenseHolderFsmTask", "smartlicenseHolderFsmTask", "task-[item]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['smartlicenseHolder'], [], [None]),
    "SmartlicenseTest": MoMeta("SmartlicenseTest", "smartlicenseTest", "Test", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin"], ['smartlicenseAgent'], ['eventInst', 'faultInst', 'smartlicenseTestFsm', 'smartlicenseTestFsmTask'], [None]),
    "SmartlicenseTestFsm": MoMeta("SmartlicenseTestFsm", "smartlicenseTestFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['smartlicenseTest'], ['smartlicenseTestFsmStage'], [None]),
    "SmartlicenseTestFsmStage": MoMeta("SmartlicenseTestFsmStage", "smartlicenseTestFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['smartlicenseTestFsm'], [], [None]),
    "SmartlicenseTestFsmTask": MoMeta("SmartlicenseTestFsmTask", "smartlicenseTestFsmTask", "task-[item]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['smartlicenseTest'], [], [None]),
    "SolPolicy": MoMeta("SolPolicy", "solPolicy", "sol-[name]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "read-only"], ['orgOrg', 'policySystemEp'], [], ["Add", "Get", "Remove", "Set"]),
    "StatsChartContainer": MoMeta("StatsChartContainer", "statsChartContainer", "container-[name]", VersionMeta.Version111b, "InputOutput", 0x1, [], ["admin", "stats-management"], ['statsChartContainer', 'statsCustomEp'], ['statsChartContainer', 'statsCustomChart'], ["Get"]),
    "StatsCollectionPolicy": MoMeta("StatsCollectionPolicy", "statsCollectionPolicy", "coll-policy-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "operations"], ['statsHolder'], [], ["Get", "Set"]),
    "StatsCustomChart": MoMeta("StatsCustomChart", "statsCustomChart", "custom-chart-[name]domain-[chart_domain]", VersionMeta.Version111b, "InputOutput", 0x1, [], ["admin", "stats-management"], ['statsChartContainer', 'statsCustomEp'], [], ["Get"]),
    "StatsCustomEp": MoMeta("StatsCustomEp", "statsCustomEp", "customcharts", VersionMeta.Version111b, "InputOutput", 0x1, [], ["read-only"], ['topSystem'], ['statsChartContainer', 'statsCustomChart'], ["Get"]),
    "StatsDbMigrationStatus": MoMeta("StatsDbMigrationStatus", "statsDbMigrationStatus", "dbMigrationStatus", VersionMeta.Version111b, "InputOutput", 0x1, [], ["admin"], ['statsHolder'], [], ["Get"]),
    "StatsDbSummaryMeta": MoMeta("StatsDbSummaryMeta", "statsDbSummaryMeta", "summary-meta", VersionMeta.Version111b, "InputOutput", 0x1, [], ["admin"], ['topRoot'], [], ["Get"]),
    "StatsHolder": MoMeta("StatsHolder", "statsHolder", "stats", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "operations"], ['topRoot'], ['statsCollectionPolicy', 'statsDbMigrationStatus', 'statsPasadenaCollectionPolicy'], ["Get"]),
    "StatsInventoryMeta": MoMeta("StatsInventoryMeta", "statsInventoryMeta", "invMeta", VersionMeta.Version121a, "InputOutput", 0x1, [], ["admin"], ['extpolClient'], [], ["Get", "Set"]),
    "StatsPasadenaCollectionPolicy": MoMeta("StatsPasadenaCollectionPolicy", "statsPasadenaCollectionPolicy", "pasadena-coll-policy", VersionMeta.Version111b, "InputOutput", 0x1, [], ["admin", "operations"], ['statsHolder'], [], ["Get"]),
    "StatsStandardChart": MoMeta("StatsStandardChart", "statsStandardChart", "standard-chart-[name]domain-[chart_domain]", VersionMeta.Version111b, "InputOutput", 0x1, [], ["admin", "stats-management"], ['statsStandardEp'], [], ["Get"]),
    "StatsStandardEp": MoMeta("StatsStandardEp", "statsStandardEp", "standardcharts", VersionMeta.Version111b, "InputOutput", 0x1, [], ["read-only"], ['topSystem'], ['statsStandardChart'], ["Get"]),
    "StatsStatsQuery": MoMeta("StatsStatsQuery", "statsStatsQuery", "query-[query_id]", VersionMeta.Version111b, "InputOutput", 0x1, [], ["read-only"], ['statsStatsQueryHolder'], [], ["Get"]),
    "StatsStatsQueryHolder": MoMeta("StatsStatsQueryHolder", "statsStatsQueryHolder", "statsQuery", VersionMeta.Version111b, "InputOutput", 0x1, [], ["admin", "operations"], ['topRoot'], ['statsStatsQuery'], ["Get"]),
    "StatsThr32Definition": MoMeta("StatsThr32Definition", "statsThr32Definition", "[prop_id]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "operations"], ['statsThresholdClass'], ['statsThr32Value', 'statsThr64Value', 'statsThrFloatValue'], ["Add", "Get", "Remove", "Set"]),
    "StatsThr32Value": MoMeta("StatsThr32Value", "statsThr32Value", "[direction]-[severity]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "operations"], ['statsThr32Definition', 'statsThr64Definition', 'statsThrFloatDefinition'], [], ["Add", "Get", "Set"]),
    "StatsThr64Definition": MoMeta("StatsThr64Definition", "statsThr64Definition", "[prop_id]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "operations"], ['statsThresholdClass'], ['statsThr32Value', 'statsThr64Value', 'statsThrFloatValue'], ["Add", "Get", "Remove", "Set"]),
    "StatsThr64Value": MoMeta("StatsThr64Value", "statsThr64Value", "[direction]-[severity]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "operations"], ['statsThr32Definition', 'statsThr64Definition', 'statsThrFloatDefinition'], [], ["Add", "Get", "Set"]),
    "StatsThrFloatDefinition": MoMeta("StatsThrFloatDefinition", "statsThrFloatDefinition", "[prop_id]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "operations"], ['statsThresholdClass'], ['statsThr32Value', 'statsThr64Value', 'statsThrFloatValue'], ["Add", "Get", "Remove", "Set"]),
    "StatsThrFloatValue": MoMeta("StatsThrFloatValue", "statsThrFloatValue", "[direction]-[severity]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "operations"], ['statsThr32Definition', 'statsThr64Definition', 'statsThrFloatDefinition'], [], ["Get"]),
    "StatsThresholdClass": MoMeta("StatsThresholdClass", "statsThresholdClass", "[stats_class_id]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "operations"], ['statsThresholdPolicy'], ['statsThr32Definition', 'statsThr64Definition', 'statsThrFloatDefinition'], ["Add", "Get", "Remove", "Set"]),
    "StatsThresholdPolicy": MoMeta("StatsThresholdPolicy", "statsThresholdPolicy", "thr-policy-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], ['fabricCabling', 'fabricDceSrv', 'fabricEthEstcCloud', 'fabricFcEstcCloud', 'fabricLanCloud', 'fabricLanMonCloud', 'fabricSanCloud', 'fabricSanMonCloud', 'orgOrg'], ['statsThresholdClass'], ["Add", "Get", "Remove", "Set"]),
    "StorageArray": MoMeta("StorageArray", "storageArray", "array-[name]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin"], ['storageCloud'], ['storageDiskGroup', 'storagePartition', 'storageProcessor'], ["Get"]),
    "StorageAuthKey": MoMeta("StorageAuthKey", "storageAuthKey", "key-[type]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin"], ['storageIScsiTargetIf'], [], [None]),
    "StorageBlade": MoMeta("StorageBlade", "storageBlade", "storage-blade-[slot_id]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], ['equipmentChassis'], ['computeBladeEp', 'powerBudget', 'storageComputeBladeOperation', 'storageEnclosure', 'storageMeta'], ["Get"]),
    "StorageCloud": MoMeta("StorageCloud", "storageCloud", "storage", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin"], ['computeSystem', 'topRoot'], ['storageArray', 'storageClusterIdUniverse', 'trigMeta', 'trigSched'], [None]),
    "StorageClusterIdUniverse": MoMeta("StorageClusterIdUniverse", "storageClusterIdUniverse", "cluster-id-universe", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], ['storageCloud'], [], [None]),
    "StorageComputeBladeOperation": MoMeta("StorageComputeBladeOperation", "storageComputeBladeOperation", "remote-oper", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], ['storageBlade'], ['faultInst'], ["Get"]),
    "StorageConnectionDef": MoMeta("StorageConnectionDef", "storageConnectionDef", "storage-conndef", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy", "ls-config", "ls-server", "ls-storage", "ls-storage-policy"], ['vnicFcGroupDef'], ['faultInst', 'storageFcTargetEp'], ["Add", "Get", "Remove", "Set"]),
    "StorageConnectionPolicy": MoMeta("StorageConnectionPolicy", "storageConnectionPolicy", "storage-connpolicy-[name]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['orgOrg'], ['faultInst', 'storageFcTargetEp'], ["Add", "Get", "Remove", "Set"]),
    "StorageController": MoMeta("StorageController", "storageController", "storage-[type]-[id]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-storage"], ['computeBoard', 'equipmentChassis'], ['faultInst', 'firmwareBootDefinition', 'firmwareRunning', 'lstorageControllerDef', 'mgmtController', 'storageControllerOperation', 'storageEmbeddedStorage', 'storageEnclosure', 'storageLocalDisk', 'storageLocalDiskConfigDef', 'storageLocalDiskEp', 'storageLocalLun', 'storageMezzFlashLife', 'storageNvmeStats', 'storageNvmeStorage', 'storageOnboardDevice', 'storageOperation', 'storageRaidBattery', 'storageSsdHealthStats', 'storageVirtualDrive', 'storageVirtualDriveEp'], ["Get"]),
    "StorageControllerEp": MoMeta("StorageControllerEp", "storageControllerEp", "controller-ep-[id]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["read-only"], ['storageLocalDisk', 'storageVirtualDrive'], [], ["Get"]),
    "StorageControllerOperation": MoMeta("StorageControllerOperation", "storageControllerOperation", "remote-oper", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], ['storageController'], ['faultInst'], ["Get"]),
    "StorageControllerRef": MoMeta("StorageControllerRef", "storageControllerRef", "server-[server_id]-controller-[controller_type]-[controller_id]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["read-only"], ['storageEnclosureDiskSlotEp'], [], ["Get"]),
    "StorageCtrlStorageStats": MoMeta("StorageCtrlStorageStats", "storageCtrlStorageStats", "ctrl-storage-stats", VersionMeta.Version131a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [], ['storageCtrlStorageStatsHist'], [None]),
    "StorageCtrlStorageStatsHist": MoMeta("StorageCtrlStorageStatsHist", "storageCtrlStorageStatsHist", "[id]", VersionMeta.Version131a, "OutputOnly", 0x1, [], ["read-only"], ['storageCtrlStorageStats'], [], [None]),
    "StorageDiskEnvStats": MoMeta("StorageDiskEnvStats", "storageDiskEnvStats", "disk-env-stats", VersionMeta.Version201b, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['storageLocalDisk'], ['storageDiskEnvStatsHist'], [None]),
    "StorageDiskEnvStatsHist": MoMeta("StorageDiskEnvStatsHist", "storageDiskEnvStatsHist", "[id]", VersionMeta.Version201b, "OutputOnly", 0x1, [], ["read-only"], ['storageDiskEnvStats'], [], [None]),
    "StorageDiskEp": MoMeta("StorageDiskEp", "storageDiskEp", "disk-[id]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], ['storageDiskGroup'], [], ["Get"]),
    "StorageDiskGroup": MoMeta("StorageDiskGroup", "storageDiskGroup", "disk-group-[id]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "ls-storage"], ['storageArray'], ['storageDiskEp'], ["Get", "Set"]),
    "StorageEmbeddedStorage": MoMeta("StorageEmbeddedStorage", "storageEmbeddedStorage", "embedded-storage", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-storage"], ['storageController'], [], ["Get"]),
    "StorageEnclosure": MoMeta("StorageEnclosure", "storageEnclosure", "enc-[id]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "ls-storage"], ['computeBlade', 'computeRackUnit', 'computeServerUnit', 'equipmentChassis', 'storageBlade', 'storageController'], ['storageEnclosureDiskSlotEp', 'storageLocalDisk'], ["Get"]),
    "StorageEnclosureDiskSlotEp": MoMeta("StorageEnclosureDiskSlotEp", "storageEnclosureDiskSlotEp", "disk-slot-[id]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], ['storageEnclosure'], ['storageControllerRef'], ["Get"]),
    "StorageEnclosureLocalDiskConfig": MoMeta("StorageEnclosureLocalDiskConfig", "storageEnclosureLocalDiskConfig", "enc-disk-config-[id]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["read-only"], [], ['storageSasPort'], ["Get"]),
    "StorageEpUser": MoMeta("StorageEpUser", "storageEpUser", "user-[name]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin"], ['initiatorFcInitiatorEp', 'initiatorIScsiInitiatorEp', 'storageIScsiInitiatorEp'], [], [None]),
    "StorageEthLif": MoMeta("StorageEthLif", "storageEthLif", "eth-lif-[name]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-network", "ls-server", "read-only"], ['osInstance', 'storageProcessor'], ['osEthBondIntf', 'osEthIntf', 'vnicFault', 'vnicIPv4If'], ["Get"]),
    "StorageEtherIf": MoMeta("StorageEtherIf", "storageEtherIf", "ether-[name]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin"], ['storageIScsiTargetIf'], ['ipServiceIf'], ["Get"]),
    "StorageFcIf": MoMeta("StorageFcIf", "storageFcIf", "fc-[name]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], ['storageFcTargetIf'], [], ["Get"]),
    "StorageFcTargetEp": MoMeta("StorageFcTargetEp", "storageFcTargetEp", "fc-target-ep-[targetwwpn]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy", "ls-storage", "ls-storage-policy"], ['storageConnectionDef', 'storageConnectionPolicy'], ['storageVsanRef'], ["Add", "Get", "Remove", "Set"]),
    "StorageFcTargetIf": MoMeta("StorageFcTargetIf", "storageFcTargetIf", "fc-tgt-[id]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], [], ['storageFcIf'], ["Get"]),
    "StorageFlexFlashCard": MoMeta("StorageFlexFlashCard", "storageFlexFlashCard", "card-[slot_number]", VersionMeta.Version112a, "InputOutput", 0x1, [], ["read-only"], ['storageFlexFlashController'], ['storageFlexFlashDrive'], ["Get"]),
    "StorageFlexFlashController": MoMeta("StorageFlexFlashController", "storageFlexFlashController", "storage-flexflash-[id]", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin"], ['computeBoard'], ['firmwareRunning', 'storageFlexFlashCard', 'storageFlexFlashControllerOperation', 'storageFlexFlashVirtualDrive', 'storageLocalDiskConfigDef'], ["Get"]),
    "StorageFlexFlashControllerOperation": MoMeta("StorageFlexFlashControllerOperation", "storageFlexFlashControllerOperation", "remote-oper", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin"], ['storageFlexFlashController'], ['faultInst'], [None]),
    "StorageFlexFlashDrive": MoMeta("StorageFlexFlashDrive", "storageFlexFlashDrive", "drive-[name]", VersionMeta.Version112a, "InputOutput", 0x1, [], ["read-only"], ['storageFlexFlashCard'], [], ["Get"]),
    "StorageFlexFlashVirtualDrive": MoMeta("StorageFlexFlashVirtualDrive", "storageFlexFlashVirtualDrive", "vd-[id]", VersionMeta.Version112a, "InputOutput", 0x1, [], ["read-only"], ['storageFlexFlashController'], [], ["Get"]),
    "StorageHddMotherBoardTempStats": MoMeta("StorageHddMotherBoardTempStats", "storageHddMotherBoardTempStats", "hdd-mobo-temp-stats", VersionMeta.Version151a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [], ['storageHddMotherBoardTempStatsHist'], [None]),
    "StorageHddMotherBoardTempStatsHist": MoMeta("StorageHddMotherBoardTempStatsHist", "storageHddMotherBoardTempStatsHist", "[id]", VersionMeta.Version151a, "OutputOnly", 0x1, [], ["read-only"], ['storageHddMotherBoardTempStats'], [], [None]),
    "StorageIScsiInitiatorEp": MoMeta("StorageIScsiInitiatorEp", "storageIScsiInitiatorEp", "scsi-ini-[iqn]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], ['initiatorGroupEp', 'storageLunMaskGroup'], ['storageEpUser'], ["Get"]),
    "StorageIScsiTargetIf": MoMeta("StorageIScsiTargetIf", "storageIScsiTargetIf", "iscsi-tgt-[name]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin"], ['storageNodeEp'], ['initiatorLunEp', 'storageAuthKey', 'storageEtherIf'], ["Get"]),
    "StorageIniGroup": MoMeta("StorageIniGroup", "storageIniGroup", "grp-[name]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-server", "ls-storage", "ls-storage-policy"], ['lsServer', 'vnicSanConnPolicy'], ['faultInst', 'storageInitiator', 'vnicFcGroupDef'], ["Add", "Get", "Remove", "Set"]),
    "StorageInitiator": MoMeta("StorageInitiator", "storageInitiator", "ini-[name]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-server", "ls-storage", "ls-storage-policy"], ['storageIniGroup'], ['faultInst'], ["Add", "Get", "Remove"]),
    "StorageInitiatorRef": MoMeta("StorageInitiatorRef", "storageInitiatorRef", "lun-ref-[name]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], ['storageScsiLun'], [], ["Get"]),
    "StorageIpV4PooledAddr": MoMeta("StorageIpV4PooledAddr", "storageIpV4PooledAddr", "storage-ipv4-pooled-addr", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "ls-storage"], ['computeInstance', 'lsServer', 'mgmtVnet', 'vnicIPv4If', 'vnicMgmtIf'], ['faultInst'], ["Get"]),
    "StorageIpV4StaticAddr": MoMeta("StorageIpV4StaticAddr", "storageIpV4StaticAddr", "storage-ipv4-addr", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "ls-storage"], ['computeInstance', 'lsServer', 'mgmtVnet', 'vnicIPv4If', 'vnicMgmtIf'], [], ["Get"]),
    "StorageItem": MoMeta("StorageItem", "storageItem", "stor-part-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], ['networkElement', 'nfsExportDef'], ['faultInst'], ["Get"]),
    "StorageLocalDisk": MoMeta("StorageLocalDisk", "storageLocalDisk", "disk-[id]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-storage"], ['storageController', 'storageEnclosure'], ['equipmentLocatorLed', 'faultInst', 'firmwareBootDefinition', 'firmwareRunning', 'storageControllerEp', 'storageDiskEnvStats', 'storageLocalDiskOperation', 'storageLocalDiskPartition', 'storageOperation', 'storageSasPort'], ["Get"]),
    "StorageLocalDiskConfigDef": MoMeta("StorageLocalDiskConfigDef", "storageLocalDiskConfigDef", "local-disk-config", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-storage", "ls-storage-policy"], ['lsServer', 'lstorageDasScsiLun', 'storageController', 'storageFlexFlashController'], ['lstorageSecurity', 'storageLocalDiskPartition'], ["Add", "Get", "Remove", "Set"]),
    "StorageLocalDiskConfigPolicy": MoMeta("StorageLocalDiskConfigPolicy", "storageLocalDiskConfigPolicy", "local-disk-config-[name]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['orgOrg'], ['lstorageSecurity', 'storageLocalDiskPartition'], ["Add", "Get", "Remove", "Set"]),
    "StorageLocalDiskEp": MoMeta("StorageLocalDiskEp", "storageLocalDiskEp", "disk-ep-[enc_id]-id-[id]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], ['storageController'], [], ["Get"]),
    "StorageLocalDiskOperation": MoMeta("StorageLocalDiskOperation", "storageLocalDiskOperation", "remote-oper", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], ['storageLocalDisk'], ['faultInst'], ["Get", "Set"]),
    "StorageLocalDiskPartition": MoMeta("StorageLocalDiskPartition", "storageLocalDiskPartition", "partition-[id]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], ['storageLocalDisk', 'storageLocalDiskConfigDef', 'storageLocalDiskConfigPolicy'], [], ["Get"]),
    "StorageLocalLun": MoMeta("StorageLocalLun", "storageLocalLun", "lun-[id]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], ['storageController'], [], ["Get"]),
    "StorageLunCounters": MoMeta("StorageLunCounters", "storageLunCounters", "lun-counters", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], ['storagePartition'], [], [None]),
    "StorageLunDisk": MoMeta("StorageLunDisk", "storageLunDisk", "disk-[id]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], ['storageVirtualDrive'], [], ["Get"]),
    "StorageLunMaskGroup": MoMeta("StorageLunMaskGroup", "storageLunMaskGroup", "lunmask-grp-[name]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], ['storagePartition'], ['storageIScsiInitiatorEp', 'storageScsiLunMask'], ["Get"]),
    "StorageLunReplica": MoMeta("StorageLunReplica", "storageLunReplica", "lun-replica-[name]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-storage"], ['storagePartition'], ['faultInst', 'storageScsiLunRef'], ["Get"]),
    "StorageLunResourceSelectionLog": MoMeta("StorageLunResourceSelectionLog", "storageLunResourceSelectionLog", "selection-log-[order]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-storage"], ['storageVirtualDriveRef'], [], [None]),
    "StorageLunSnapshot": MoMeta("StorageLunSnapshot", "storageLunSnapshot", "snapshot-[name]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-storage"], ['storagePartition'], ['faultInst', 'storageScsiLunRef'], ["Get"]),
    "StorageMeta": MoMeta("StorageMeta", "storageMeta", "meta", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin"], ['storageBlade'], ['faultInst'], [None]),
    "StorageMezzFlashLife": MoMeta("StorageMezzFlashLife", "storageMezzFlashLife", "flash-life-", VersionMeta.Version121a, "InputOutput", 0x1, [], ["read-only"], ['storageController'], [], ["Get"]),
    "StorageNodeEp": MoMeta("StorageNodeEp", "storageNodeEp", "node-[id]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], ['initiatorGroupEp'], ['storageIScsiTargetIf'], [None]),
    "StorageNvmeStats": MoMeta("StorageNvmeStats", "storageNvmeStats", "nvme-stats", VersionMeta.Version201b, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['storageController'], ['storageNvmeStatsHist'], [None]),
    "StorageNvmeStatsHist": MoMeta("StorageNvmeStatsHist", "storageNvmeStatsHist", "[id]", VersionMeta.Version201b, "OutputOnly", 0x1, [], ["read-only"], ['storageNvmeStats'], [], [None]),
    "StorageNvmeStorage": MoMeta("StorageNvmeStorage", "storageNvmeStorage", "nvme-storage", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-storage"], ['storageController'], [], [None]),
    "StorageOnboardDevice": MoMeta("StorageOnboardDevice", "storageOnboardDevice", "onboard-device-[device_type]-[id]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-storage"], ['storageController', 'storageSasExpander'], ['firmwareBootDefinition', 'firmwareRunning', 'firmwareUpdatable'], ["Get"]),
    "StorageOperation": MoMeta("StorageOperation", "storageOperation", "op-[name]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], ['storageController', 'storageLocalDisk', 'storageRaidBattery', 'storageVirtualDrive'], [], ["Get"]),
    "StoragePartition": MoMeta("StoragePartition", "storagePartition", "part-[name]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], ['storageArray'], ['storageLunCounters', 'storageLunMaskGroup', 'storageLunReplica', 'storageLunSnapshot', 'storageScsiLun', 'storageUsageCounters', 'storageVolume'], ["Get"]),
    "StorageProcessor": MoMeta("StorageProcessor", "storageProcessor", "processor-[name]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], ['storageArray'], ['commLocale', 'osController', 'storageEthLif', 'storageProcessorRuntime'], ["Get"]),
    "StorageProcessorEp": MoMeta("StorageProcessorEp", "storageProcessorEp", "proc-ep-[name]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], [], [], ["Get"]),
    "StorageProcessorRuntime": MoMeta("StorageProcessorRuntime", "storageProcessorRuntime", "proc-runtime", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], ['storageProcessor'], [], ["Get"]),
    "StorageQual": MoMeta("StorageQual", "storageQual", "local-storage", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "pn-policy", "read-only"], ['computeQual'], [], ["Add", "Get", "Remove", "Set"]),
    "StorageRaidBattery": MoMeta("StorageRaidBattery", "storageRaidBattery", "raid-battery", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['storageController'], ['storageOperation', 'storageTransportableFlashModule'], ["Get"]),
    "StorageReplicationCtx": MoMeta("StorageReplicationCtx", "storageReplicationCtx", "repl-ctx", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-storage"], ['storageScsiLun'], [], ["Get"]),
    "StorageSasExpander": MoMeta("StorageSasExpander", "storageSasExpander", "sas-expander-[id]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], ['computeBoard', 'equipmentChassis'], ['firmwareBootDefinition', 'firmwareRunning', 'mgmtController', 'storageOnboardDevice', 'storageSasUpLink'], [None]),
    "StorageSasPort": MoMeta("StorageSasPort", "storageSasPort", "sas-port-[id]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["read-only"], ['storageEnclosureLocalDiskConfig', 'storageLocalDisk'], [], ["Get"]),
    "StorageSasUpLink": MoMeta("StorageSasUpLink", "storageSasUpLink", "sas-uplink-server-[server_id]-controller-[controller_type]-[controller_id]-id-[id]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["read-only"], ['storageSasExpander'], [], ["Get"]),
    "StorageScsiDeviceDescriptor": MoMeta("StorageScsiDeviceDescriptor", "storageScsiDeviceDescriptor", "scsi-descriptor-[type]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], ['storageScsiLun'], [], [None]),
    "StorageScsiLun": MoMeta("StorageScsiLun", "storageScsiLun", "lun-[name]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-storage"], ['storagePartition'], ['faultInst', 'storageInitiatorRef', 'storageReplicationCtx', 'storageScsiDeviceDescriptor', 'storageScsiLunCtx', 'storageScsiLunRef', 'storageSnapshotCtx'], [None]),
    "StorageScsiLunCtx": MoMeta("StorageScsiLunCtx", "storageScsiLunCtx", "lun-ctx", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-storage"], ['storageScsiLun'], [], [None]),
    "StorageScsiLunInstRef": MoMeta("StorageScsiLunInstRef", "storageScsiLunInstRef", "lun-inst-ref-[lun_item_name]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-storage"], ['lsServer'], [], [None]),
    "StorageScsiLunMask": MoMeta("StorageScsiLunMask", "storageScsiLunMask", "lunmask-[name]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], ['storageLunMaskGroup'], [], ["Get"]),
    "StorageScsiLunRef": MoMeta("StorageScsiLunRef", "storageScsiLunRef", "scsi-lun-ref-[id]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], ['storageLunReplica', 'storageLunSnapshot', 'storageScsiLun', 'storageVirtualDrive'], [], ["Get"]),
    "StorageSnapshotCtx": MoMeta("StorageSnapshotCtx", "storageSnapshotCtx", "snap-ctx", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-storage"], ['storageScsiLun'], [], ["Get"]),
    "StorageSsdHealthStats": MoMeta("StorageSsdHealthStats", "storageSsdHealthStats", "ssd-health-stats-[id]", VersionMeta.Version201b, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['storageController'], ['storageSsdHealthStatsHist'], [None]),
    "StorageSsdHealthStatsHist": MoMeta("StorageSsdHealthStatsHist", "storageSsdHealthStatsHist", "[id]", VersionMeta.Version201b, "OutputOnly", 0x1, [], ["read-only"], ['storageSsdHealthStats'], [], [None]),
    "StorageStorageStats": MoMeta("StorageStorageStats", "storageStorageStats", "storage-stats", VersionMeta.Version131a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [], ['storageStorageStatsHist'], [None]),
    "StorageStorageStatsHist": MoMeta("StorageStorageStatsHist", "storageStorageStatsHist", "[id]", VersionMeta.Version131a, "OutputOnly", 0x1, [], ["read-only"], ['storageStorageStats'], [], [None]),
    "StorageSystem": MoMeta("StorageSystem", "storageSystem", "system", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], [], [], ["Get"]),
    "StorageTransportableFlashModule": MoMeta("StorageTransportableFlashModule", "storageTransportableFlashModule", "flash-module", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], ['storageRaidBattery'], [], ["Get"]),
    "StorageUsageCounters": MoMeta("StorageUsageCounters", "storageUsageCounters", "storage-usage", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], ['storagePartition'], [], ["Get"]),
    "StorageVDMemberEp": MoMeta("StorageVDMemberEp", "storageVDMemberEp", "member-[id]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], ['storageVirtualDrive'], [], ["Get"]),
    "StorageVirtualDrive": MoMeta("StorageVirtualDrive", "storageVirtualDrive", "vd-[id]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-storage"], ['storageController', 'storageVirtualDriveContainer'], ['storageControllerEp', 'storageLunDisk', 'storageOperation', 'storageScsiLunRef', 'storageVDMemberEp', 'storageVirtualDriveOperation'], ["Get", "Set"]),
    "StorageVirtualDriveContainer": MoMeta("StorageVirtualDriveContainer", "storageVirtualDriveContainer", "vd-container-[id]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["read-only"], ['computeBlade', 'computeRackUnit', 'computeServerUnit', 'equipmentChassis'], ['storageVirtualDrive'], ["Get"]),
    "StorageVirtualDriveEp": MoMeta("StorageVirtualDriveEp", "storageVirtualDriveEp", "vd-ep-[container_id]-id-[id]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["read-only"], ['storageController'], [], ["Get"]),
    "StorageVirtualDriveOperation": MoMeta("StorageVirtualDriveOperation", "storageVirtualDriveOperation", "remote-oper", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], ['storageVirtualDrive'], ['faultInst'], ["Get", "Set"]),
    "StorageVirtualDriveRef": MoMeta("StorageVirtualDriveRef", "storageVirtualDriveRef", "vdrive-ref-[lun_item_name]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-storage"], ['computeInstance', 'lsServer'], ['lstorageDiskGroupConfigDef', 'storageLunResourceSelectionLog', 'storageVirtualDriveRefOperation'], ["Get"]),
    "StorageVirtualDriveRefOperation": MoMeta("StorageVirtualDriveRefOperation", "storageVirtualDriveRefOperation", "remote-oper", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], ['storageVirtualDriveRef'], ['faultInst'], ["Get", "Set"]),
    "StorageVolume": MoMeta("StorageVolume", "storageVolume", "vol-[name]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], ['storagePartition'], [], ["Get"]),
    "StorageVsanRef": MoMeta("StorageVsanRef", "storageVsanRef", "vsan-ref", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy", "ls-storage", "ls-storage-policy"], ['fabricFcUserZone', 'storageFcTargetEp'], ['faultInst', 'vnicFc'], ["Add", "Get", "Set"]),
    "StorageVsanRefIvt": MoMeta("StorageVsanRefIvt", "storageVsanRefIvt", "vsan-ref-ivt", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy", "ls-storage", "ls-storage-policy"], ['fabricFcUserZoneIvt'], [], [None]),
    "SwCardEnvStats": MoMeta("SwCardEnvStats", "swCardEnvStats", "cardenvstats", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['networkElement'], ['swCardEnvStatsHist'], [None]),
    "SwCardEnvStatsHist": MoMeta("SwCardEnvStatsHist", "swCardEnvStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], ['swCardEnvStats'], [], [None]),
    "SwEnvStats": MoMeta("SwEnvStats", "swEnvStats", "envstats", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['networkElement'], ['swEnvStatsHist'], [None]),
    "SwEnvStatsHist": MoMeta("SwEnvStatsHist", "swEnvStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], ['swEnvStats'], [], [None]),
    "SwSystemStats": MoMeta("SwSystemStats", "swSystemStats", "sysstats", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], ['networkElement'], ['swSystemStatsHist'], [None]),
    "SwSystemStatsHist": MoMeta("SwSystemStatsHist", "swSystemStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], ['swSystemStats'], [], [None]),
    "SyntheticDirectory": MoMeta("SyntheticDirectory", "syntheticDirectory", "dir-[ino]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], ['syntheticDirectory', 'topSystem'], ['syntheticDirectory', 'syntheticFile'], ["Get"]),
    "SyntheticFile": MoMeta("SyntheticFile", "syntheticFile", "file-[ino]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], ['syntheticDirectory'], [], ["Get"]),
    "SyntheticFileSystem": MoMeta("SyntheticFileSystem", "syntheticFileSystem", "FS-", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], ['topRoot'], [], ["Get"]),
    "SyntheticFsObj": MoMeta("SyntheticFsObj", "syntheticFsObj", "file-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], ['topSystem'], [], ["Get"]),
    "SyntheticTime": MoMeta("SyntheticTime", "syntheticTime", "time-[ts]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], [], [], ["Get"]),
    "SysdebugAutoCoreFileExportTarget": MoMeta("SysdebugAutoCoreFileExportTarget", "sysdebugAutoCoreFileExportTarget", "file-export", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "operations"], ['orgDomainGroup', 'policyDeviceProfile', 'sysdebugEp'], ['eventInst', 'faultInst', 'sysdebugAutoCoreFileExportTargetFsm', 'sysdebugAutoCoreFileExportTargetFsmTask'], ["Add", "Get", "Remove", "Set"]),
    "SysdebugAutoCoreFileExportTargetFsm": MoMeta("SysdebugAutoCoreFileExportTargetFsm", "sysdebugAutoCoreFileExportTargetFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['sysdebugAutoCoreFileExportTarget'], ['sysdebugAutoCoreFileExportTargetFsmStage'], [None]),
    "SysdebugAutoCoreFileExportTargetFsmStage": MoMeta("SysdebugAutoCoreFileExportTargetFsmStage", "sysdebugAutoCoreFileExportTargetFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['sysdebugAutoCoreFileExportTargetFsm'], [], [None]),
    "SysdebugAutoCoreFileExportTargetFsmTask": MoMeta("SysdebugAutoCoreFileExportTargetFsmTask", "sysdebugAutoCoreFileExportTargetFsmTask", "task-[item]", VersionMeta.Version101a, "OutputOnly", 0x1, [], [""], ['sysdebugAutoCoreFileExportTarget'], [], ["Get"]),
    "SysdebugBackupBehavior": MoMeta("SysdebugBackupBehavior", "sysdebugBackupBehavior", "backup", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "domain-group-management", "operations"], ['sysdebugMEpLogPolicy'], [], ["Get", "Set"]),
    "SysdebugCore": MoMeta("SysdebugCore", "sysdebugCore", "file-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "operations"], ['sysdebugCoreFileRepository'], ['faultInst', 'sysdebugManualCoreFileExportTarget', 'sysfileMutation'], ["Get"]),
    "SysdebugCoreFileRepository": MoMeta("SysdebugCoreFileRepository", "sysdebugCoreFileRepository", "corefiles", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "operations"], ['topSystem'], ['sysdebugCore', 'sysfileMutation'], ["Get"]),
    "SysdebugDiagnosticLog": MoMeta("SysdebugDiagnosticLog", "sysdebugDiagnosticLog", "diag-log-[name]-[switch_id]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "operations"], ['computeBlade', 'computeRackUnit', 'computeServerUnit'], [], [None]),
    "SysdebugEp": MoMeta("SysdebugEp", "sysdebugEp", "sysdebug", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], ['topSystem'], ['sysdebugAutoCoreFileExportTarget', 'sysdebugLogControlEp'], ["Get"]),
    "SysdebugLogControlDestinationFile": MoMeta("SysdebugLogControlDestinationFile", "sysdebugLogControlDestinationFile", "file", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "operations"], ['sysdebugLogControlDomain'], [], ["Get", "Set"]),
    "SysdebugLogControlDestinationSyslog": MoMeta("SysdebugLogControlDestinationSyslog", "sysdebugLogControlDestinationSyslog", "syslog", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "operations"], ['sysdebugLogControlDomain'], [], ["Get", "Set"]),
    "SysdebugLogControlDomain": MoMeta("SysdebugLogControlDomain", "sysdebugLogControlDomain", "domain-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "operations"], ['sysdebugLogControlEp'], ['sysdebugLogControlDestinationFile', 'sysdebugLogControlDestinationSyslog', 'sysdebugLogControlModule'], ["Get", "Set"]),
    "SysdebugLogControlEp": MoMeta("SysdebugLogControlEp", "sysdebugLogControlEp", "logcontrol", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "operations"], ['sysdebugEp'], ['eventInst', 'faultInst', 'sysdebugLogControlDomain', 'sysdebugLogControlEpFsm', 'sysdebugLogControlEpFsmTask'], ["Get", "Set"]),
    "SysdebugLogControlEpFsm": MoMeta("SysdebugLogControlEpFsm", "sysdebugLogControlEpFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['sysdebugLogControlEp'], ['sysdebugLogControlEpFsmStage'], [None]),
    "SysdebugLogControlEpFsmStage": MoMeta("SysdebugLogControlEpFsmStage", "sysdebugLogControlEpFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['sysdebugLogControlEpFsm'], [], [None]),
    "SysdebugLogControlEpFsmTask": MoMeta("SysdebugLogControlEpFsmTask", "sysdebugLogControlEpFsmTask", "task-[item]", VersionMeta.Version101a, "OutputOnly", 0x1, [], [""], ['sysdebugLogControlEp'], [], [None]),
    "SysdebugLogControlModule": MoMeta("SysdebugLogControlModule", "sysdebugLogControlModule", "module-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "operations"], ['sysdebugLogControlDomain'], [], ["Get", "Set"]),
    "SysdebugMEpLogPolicy": MoMeta("SysdebugMEpLogPolicy", "sysdebugMEpLogPolicy", "log-[type]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "domain-group-management", "operations"], ['orgDomainGroup'], ['sysdebugBackupBehavior'], ["Add", "Get", "Remove", "Set"]),
    "SysdebugManualCoreFileExportTarget": MoMeta("SysdebugManualCoreFileExportTarget", "sysdebugManualCoreFileExportTarget", "export-to-[hostname]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "operations"], ['sysdebugCore'], ['eventInst', 'faultInst', 'sysdebugManualCoreFileExportTargetFsm', 'sysdebugManualCoreFileExportTargetFsmTask'], ["Get"]),
    "SysdebugManualCoreFileExportTargetFsm": MoMeta("SysdebugManualCoreFileExportTargetFsm", "sysdebugManualCoreFileExportTargetFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['sysdebugManualCoreFileExportTarget'], ['sysdebugManualCoreFileExportTargetFsmStage'], [None]),
    "SysdebugManualCoreFileExportTargetFsmStage": MoMeta("SysdebugManualCoreFileExportTargetFsmStage", "sysdebugManualCoreFileExportTargetFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['sysdebugManualCoreFileExportTargetFsm'], [], [None]),
    "SysdebugManualCoreFileExportTargetFsmTask": MoMeta("SysdebugManualCoreFileExportTargetFsmTask", "sysdebugManualCoreFileExportTargetFsmTask", "task-[item]", VersionMeta.Version101a, "OutputOnly", 0x1, [], [""], ['sysdebugManualCoreFileExportTarget'], [], [None]),
    "SysdebugTechSupFileRepository": MoMeta("SysdebugTechSupFileRepository", "sysdebugTechSupFileRepository", "tech-support-files", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "operations"], ['computeSystem', 'topSystem'], ['sysdebugTechSupport', 'sysdebugTechSupportOp', 'sysdebugTechSupportOperation'], ["Get"]),
    "SysdebugTechSupport": MoMeta("SysdebugTechSupport", "sysdebugTechSupport", "tech-support-[creation_ts]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "operations"], ['sysdebugTechSupFileRepository'], ['eventInst', 'faultInst', 'sysdebugTechSupportCmdOpt', 'sysdebugTechSupportFsm', 'sysdebugTechSupportFsmTask'], ["Add", "Get", "Remove", "Set"]),
    "SysdebugTechSupportCmdOpt": MoMeta("SysdebugTechSupportCmdOpt", "sysdebugTechSupportCmdOpt", "tech-support-cmd-opt", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "operations"], ['sysdebugTechSupport', 'sysdebugTechSupportOp', 'sysdebugTechSupportOperation'], [], ["Add", "Get", "Set"]),
    "SysdebugTechSupportFsm": MoMeta("SysdebugTechSupportFsm", "sysdebugTechSupportFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['sysdebugTechSupport'], ['sysdebugTechSupportFsmStage'], [None]),
    "SysdebugTechSupportFsmStage": MoMeta("SysdebugTechSupportFsmStage", "sysdebugTechSupportFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['sysdebugTechSupportFsm'], [], [None]),
    "SysdebugTechSupportFsmTask": MoMeta("SysdebugTechSupportFsmTask", "sysdebugTechSupportFsmTask", "task-[item]", VersionMeta.Version101a, "OutputOnly", 0x1, [], [""], ['sysdebugTechSupport'], [], [None]),
    "SysdebugTechSupportOp": MoMeta("SysdebugTechSupportOp", "sysdebugTechSupportOp", "remote-oper-[creation_ts]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "operations"], ['sysdebugTechSupFileRepository'], ['faultInst', 'sysdebugTechSupportCmdOpt'], ["Add", "Get", "Remove", "Set"]),
    "SysdebugTechSupportOperation": MoMeta("SysdebugTechSupportOperation", "sysdebugTechSupportOperation", "remote-oper", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin", "operations"], ['sysdebugTechSupFileRepository'], ['faultInst', 'sysdebugTechSupportCmdOpt'], ["Get", "Set"]),
    "SysfileDigest": MoMeta("SysfileDigest", "sysfileDigest", "filedigest-[name]-[creation_ts]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "SysfileMutation": MoMeta("SysfileMutation", "sysfileMutation", "mutation", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "operations"], ['sysdebugCore', 'sysdebugCoreFileRepository'], ['eventInst', 'faultInst', 'sysfileMutationFsm', 'sysfileMutationFsmTask'], ["Add", "Get"]),
    "SysfileMutationFsm": MoMeta("SysfileMutationFsm", "sysfileMutationFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['sysfileMutation'], ['sysfileMutationFsmStage'], [None]),
    "SysfileMutationFsmStage": MoMeta("SysfileMutationFsmStage", "sysfileMutationFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['sysfileMutationFsm'], [], [None]),
    "SysfileMutationFsmTask": MoMeta("SysfileMutationFsmTask", "sysfileMutationFsmTask", "task-[item]", VersionMeta.Version101a, "OutputOnly", 0x1, [], [""], ['sysfileMutation'], [], [None]),
    "TagDef": MoMeta("TagDef", "tagDef", "type-[name]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "tag"], ['tagDefEp'], ['tagItem'], ["Add", "Get", "Remove", "Set"]),
    "TagDefEp": MoMeta("TagDefEp", "tagDefEp", "tag-def-ep", VersionMeta.Version151a, "InputOutput", 0x1, [], ["read-only"], ['fabricHolder'], ['tagDef'], [None]),
    "TagDriver": MoMeta("TagDriver", "tagDriver", "type-[def_name]-inst-[value]-obj-[tagged_object_dn]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["aaa", "admin", "ext-lan-config", "ext-lan-policy", "ext-lan-qos", "ext-lan-security", "ext-san-config", "ext-san-policy", "ext-san-qos", "ext-san-security", "fault", "ls-compute", "ls-config", "ls-config-policy", "ls-ext-access", "ls-network", "ls-network-policy", "ls-qos", "ls-qos-policy", "ls-security", "ls-security-policy", "ls-server", "ls-server-oper", "ls-server-policy", "ls-storage", "ls-storage-policy", "operations", "org-management", "pn-equipment", "pn-maintenance", "pn-policy", "pn-security", "pod-config", "pod-policy", "pod-qos", "pod-security", "read-only", "stats-management", "tag"], ['tagInstanceEp'], [], ["Add", "Get", "Remove", "Set"]),
    "TagInstance": MoMeta("TagInstance", "tagInstance", "type-[def_name]-inst-[value]-obj-[tagged_object_dn]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["aaa", "admin", "ext-lan-config", "ext-lan-policy", "ext-lan-qos", "ext-lan-security", "ext-san-config", "ext-san-policy", "ext-san-qos", "ext-san-security", "fault", "ls-compute", "ls-config", "ls-config-policy", "ls-ext-access", "ls-network", "ls-network-policy", "ls-qos", "ls-qos-policy", "ls-security", "ls-security-policy", "ls-server", "ls-server-oper", "ls-server-policy", "ls-storage", "ls-storage-policy", "operations", "org-management", "pn-equipment", "pn-maintenance", "pn-policy", "pn-security", "pod-config", "pod-policy", "pod-qos", "pod-security", "read-only", "stats-management", "tag"], ['tagInstanceEp'], [], ["Add", "Get", "Remove"]),
    "TagInstanceEp": MoMeta("TagInstanceEp", "tagInstanceEp", "tag-ep", VersionMeta.Version151a, "InputOutput", 0x1, [], ["read-only"], ['fabricHolder'], ['tagDriver', 'tagInstance', 'tagSoftwareInst'], [None]),
    "TagInstanceItem": MoMeta("TagInstanceItem", "tagInstanceItem", "tag-instance-item", VersionMeta.Version151a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "TagItem": MoMeta("TagItem", "tagItem", "tag-[value]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "tag"], ['tagDef'], [], [None]),
    "TagSoftwareInst": MoMeta("TagSoftwareInst", "tagSoftwareInst", "type-[def_name]-inst-[value]-obj-[tagged_object_dn]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["aaa", "admin", "ext-lan-config", "ext-lan-policy", "ext-lan-qos", "ext-lan-security", "ext-san-config", "ext-san-policy", "ext-san-qos", "ext-san-security", "fault", "ls-compute", "ls-config", "ls-config-policy", "ls-ext-access", "ls-network", "ls-network-policy", "ls-qos", "ls-qos-policy", "ls-security", "ls-security-policy", "ls-server", "ls-server-oper", "ls-server-policy", "ls-storage", "ls-storage-policy", "operations", "org-management", "pn-equipment", "pn-maintenance", "pn-policy", "pn-security", "pod-config", "pod-policy", "pod-qos", "pod-security", "read-only", "stats-management", "tag"], ['tagInstanceEp'], [], ["Add", "Get", "Remove", "Set"]),
    "TestingCliPolicy": MoMeta("TestingCliPolicy", "testingCliPolicy", "cli-policy-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "read-only"], ['orgOrg', 'topSystem'], [], [None]),
    "TestingServiceProfile": MoMeta("TestingServiceProfile", "testingServiceProfile", "service-profile-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "read-only"], ['orgOrg'], ['eventInst', 'faultInst', 'testingServiceProfileFsm', 'testingServiceProfileFsmTask'], [None]),
    "TestingServiceProfileFsm": MoMeta("TestingServiceProfileFsm", "testingServiceProfileFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['testingServiceProfile'], ['testingServiceProfileFsmStage'], [None]),
    "TestingServiceProfileFsmStage": MoMeta("TestingServiceProfileFsmStage", "testingServiceProfileFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['testingServiceProfileFsm'], [], [None]),
    "TestingServiceProfileFsmTask": MoMeta("TestingServiceProfileFsmTask", "testingServiceProfileFsmTask", "task-[item]", VersionMeta.Version101a, "OutputOnly", 0x1, [], [""], ['testingServiceProfile'], [], [None]),
    "TestingSnmpCommunity": MoMeta("TestingSnmpCommunity", "testingSnmpCommunity", "snmp-community-[community]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "read-only"], ['testingSnmpSupport'], [], [None]),
    "TestingSnmpPolicy": MoMeta("TestingSnmpPolicy", "testingSnmpPolicy", "snmp-policy-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "read-only"], ['orgOrg', 'topSystem'], ['testingSnmpSupport'], [None]),
    "TestingSnmpSupport": MoMeta("TestingSnmpSupport", "testingSnmpSupport", "snmp-support-[version]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "read-only"], ['testingSnmpPolicy'], ['testingSnmpCommunity', 'testingSnmpTrap'], [None]),
    "TestingSnmpTrap": MoMeta("TestingSnmpTrap", "testingSnmpTrap", "snmp-trap-[hostname]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "read-only"], ['testingSnmpSupport'], [], [None]),
    "TopInfoSyncPolicy": MoMeta("TopInfoSyncPolicy", "topInfoSyncPolicy", "info-sync-policy", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-san-config"], ['orgDomainGroup'], [], ["Get", "Set"]),
    "TopMetaInf": MoMeta("TopMetaInf", "topMetaInf", "meta", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], ['topRoot'], [], ["Get"]),
    "TopRoot": MoMeta("TopRoot", "topRoot", "", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], [], ['aaaLog', 'callhomeHolder', 'capabilityCatalogue', 'clitestTypeTest', 'clitestTypeTest2', 'computeResourceAggrEp', 'configImpactAnalyzerEp', 'consumerUniverse', 'controllerEp', 'domainEp', 'eventHolder', 'eventLog', 'extpolEp', 'fabricHolder', 'faultHolder', 'fcpoolUniverse', 'glEp', 'guiGuiCont', 'hcHolder', 'identMetaVerse', 'identpoolMetaVerse', 'inventoryEp', 'ippoolUniverse', 'iqnpoolUniverse', 'macpoolUniverse', 'mgmtEp', 'nfsEp', 'observeObservedCont', 'orgDomainGroup', 'orgOrg', 'policyLocalMap', 'policyPolicyEp', 'policyUniverse', 'procManager', 'queryEp', 'smartlicenseHolder', 'statsDbSummaryMeta', 'statsHolder', 'statsStatsQueryHolder', 'storageCloud', 'syntheticFileSystem', 'topMetaInf', 'topSystem', 'uuidpoolUniverse'], ["Get"]),
    "TopSystem": MoMeta("TopSystem", "topSystem", "sys", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "ext-lan-config"], ['topRoot'], ['aaaAuthRealm', 'aaaLdapEp', 'aaaRadiusEp', 'aaaTacacsPlusEp', 'aaaUserEp', 'certRepairEp', 'commSvcEp', 'configCatalogue', 'configDbConfig', 'configPasswordEncryption', 'eventInst', 'faultInst', 'featureCatalogEp', 'firmwareCatalogue', 'firmwareRemoteCatalogue', 'firmwareStatus', 'firmwareSystem', 'fsmStatus', 'initiatorRequestorEp', 'initiatorRequestorGrpEp', 'licenseEp', 'mgmtBackup', 'mgmtController', 'mgmtDataExporter', 'mgmtDataImporter', 'mgmtEntity', 'mgmtImporter', 'mgmtRegistryInfo', 'networkElement', 'pkiEp', 'statsCustomEp', 'statsStandardEp', 'syntheticDirectory', 'syntheticFsObj', 'sysdebugCoreFileRepository', 'sysdebugEp', 'sysdebugTechSupFileRepository', 'testingCliPolicy', 'testingSnmpPolicy', 'topSystemFsm', 'topSystemFsmTask', 'trigMeta', 'trigSched', 'versionEp'], ["Get", "Set"]),
    "TopSystemFsm": MoMeta("TopSystemFsm", "topSystemFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['topSystem'], ['topSystemFsmStage'], [None]),
    "TopSystemFsmStage": MoMeta("TopSystemFsmStage", "topSystemFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], ['topSystemFsm'], [], [None]),
    "TopSystemFsmTask": MoMeta("TopSystemFsmTask", "topSystemFsmTask", "task-[item]", VersionMeta.Version101a, "OutputOnly", 0x1, [], [""], ['topSystem'], [], [None]),
    "TrigAbsWindow": MoMeta("TrigAbsWindow", "trigAbsWindow", "abs-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "operations"], ['trigSched'], [], ["Add", "Get", "Remove", "Set"]),
    "TrigMeta": MoMeta("TrigMeta", "trigMeta", "meta-trig-[sched_name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], ['firmwareDomainInfraProfile', 'orgDomainGroup', 'storageCloud', 'topSystem'], ['trigServerToken', 'trigTokenRequestor', 'trigTriggered'], ["Get"]),
    "TrigPendingAckCount": MoMeta("TrigPendingAckCount", "trigPendingAckCount", "pending-ack-count", VersionMeta.Version121a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server"], ['orgDomainGroup'], [], ["Get"]),
    "TrigRecurrWindow": MoMeta("TrigRecurrWindow", "trigRecurrWindow", "recurr-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server"], ['trigSched'], [], ["Add", "Get", "Remove", "Set"]),
    "TrigSched": MoMeta("TrigSched", "trigSched", "sched-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "operations"], ['firmwareDomainInfraProfile', 'orgDomainGroup', 'storageCloud', 'topSystem'], ['lstorageRecurrWindow', 'trigAbsWindow', 'trigRecurrWindow'], ["Add", "Get", "Remove", "Set"]),
    "TrigServerToken": MoMeta("TrigServerToken", "trigServerToken", "servertoken-[id]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], ['trigMeta'], [], ["Get"]),
    "TrigTest": MoMeta("TrigTest", "trigTest", "test-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], ['orgDomainGroup', 'orgOrg'], ['faultInst'], ["Get"]),
    "TrigTokenRequestor": MoMeta("TrigTokenRequestor", "trigTokenRequestor", "tokenreq-[id]-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "domain-group-management", "ls-compute", "ls-config", "ls-server"], ['trigMeta'], [], ["Get", "Set"]),
    "TrigTriggered": MoMeta("TrigTriggered", "trigTriggered", "trig-[tr_id]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], ['trigMeta'], [], ["Get"]),
    "UuidpoolAddr": MoMeta("UuidpoolAddr", "uuidpoolAddr", "[id]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], ['uuidpoolUniverse'], ['faultInst', 'identpoolConsumed', 'identpoolPoolable'], ["Get"]),
    "UuidpoolBlock": MoMeta("UuidpoolBlock", "uuidpoolBlock", "block-from-[r_from]-to-[to]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "pn-policy"], ['uuidpoolPool'], [], ["Add", "Get", "Remove"]),
    "UuidpoolFormat": MoMeta("UuidpoolFormat", "uuidpoolFormat", "format-[format]-[mask]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "ls-storage", "ls-storage-policy"], ['uuidpoolUniverse'], [], ["Get"]),
    "UuidpoolPool": MoMeta("UuidpoolPool", "uuidpoolPool", "uuid-pool-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], ['orgOrg'], ['faultInst', 'uuidpoolBlock', 'uuidpoolPooled'], ["Add", "Get", "Remove", "Set"]),
    "UuidpoolPooled": MoMeta("UuidpoolPooled", "uuidpoolPooled", "[id]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], ['uuidpoolPool'], [], ["Get"]),
    "UuidpoolUniverse": MoMeta("UuidpoolUniverse", "uuidpoolUniverse", "uuid", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], ['topRoot'], ['uuidpoolAddr', 'uuidpoolFormat'], ["Get"]),
    "VersionApplication": MoMeta("VersionApplication", "versionApplication", "application", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], ['versionEp'], [], ["Get"]),
    "VersionEp": MoMeta("VersionEp", "versionEp", "version", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], ['topSystem'], ['versionApplication', 'versionMatrix', 'versionProduct'], [None]),
    "VersionFilter": MoMeta("VersionFilter", "versionFilter", "filter-[capability]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], ['versionMatrix'], [], [None]),
    "VersionMatrix": MoMeta("VersionMatrix", "versionMatrix", "matrix", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], ['versionEp'], ['versionFilter'], ["Get"]),
    "VersionProduct": MoMeta("VersionProduct", "versionProduct", "product", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], ['versionEp'], [], ["Get"]),
    "VmNic": MoMeta("VmNic", "vmNic", "nic-[name]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "read-only"], [], ['adaptorEthPortBySizeLargeStats', 'adaptorEthPortBySizeSmallStats', 'adaptorEthPortErrStats', 'adaptorEthPortMcastStats', 'adaptorEthPortOutsizedStats', 'adaptorEthPortStats', 'adaptorFcPortStats', 'adaptorVnicStats', 'fabricEthMonSrcEp', 'fabricFcMonSrcEp', 'faultInst'], ["Get"]),
    "VnicBootIpPolicy": MoMeta("VnicBootIpPolicy", "vnicBootIpPolicy", "", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-network", "ls-server"], [], [], ["Get"]),
    "VnicBootTarget": MoMeta("VnicBootTarget", "vnicBootTarget", "boot-target", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-server", "ls-storage"], ['vnicFc'], [], ["Get"]),
    "VnicConnDef": MoMeta("VnicConnDef", "vnicConnDef", "conn-def", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server"], ['lsServer'], ['faultInst'], ["Add", "Get", "Remove", "Set"]),
    "VnicDefBeh": MoMeta("VnicDefBeh", "vnicDefBeh", "def-beh-[type]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-server"], ['lsServer'], [], ["Add", "Get", "Remove", "Set"]),
    "VnicDynamicCon": MoMeta("VnicDynamicCon", "vnicDynamicCon", "dynamic-con", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-network", "ls-network-policy", "ls-server"], ['lsServer', 'orgOrg'], [], ["Get", "Set"]),
    "VnicDynamicConPolicy": MoMeta("VnicDynamicConPolicy", "vnicDynamicConPolicy", "dynamic-con-[name]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['orgOrg'], [], ["Add", "Get", "Remove", "Set"]),
    "VnicDynamicConPolicyRef": MoMeta("VnicDynamicConPolicyRef", "vnicDynamicConPolicyRef", "con-ref-[con_policy_name]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-network", "ls-network-policy", "ls-server"], ['vnicEther', 'vnicLanConnTempl'], ['faultInst'], ["Add", "Get", "Remove"]),
    "VnicEthLif": MoMeta("VnicEthLif", "vnicEthLif", "eth-lif-[name]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "ls-storage"], [], [], ["Get"]),
    "VnicEther": MoMeta("VnicEther", "vnicEther", "ether-[name]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-network", "ls-server"], ['computeInstance', 'computeLocalTemplDef', 'fabricDceSwSrvPcOperation', 'fabricEthEstcEpOperation', 'fabricEthEstcPcOperation', 'fabricEthLanEpOperation', 'fabricEthLanPcOperation', 'fabricEthMonOperation', 'lsServer', 'vnicLanConnPolicy', 'vnicNetGroup', 'vnicNetGroupRef'], ['fabricEthMonSrcEp', 'fabricEthMonSrcEpOperation', 'fabricFcMonSrcEp', 'fabricNetGroupRef', 'faultInst', 'vnicDynamicConPolicyRef', 'vnicEtherIf', 'vnicFcOEIf', 'vnicLifVlan', 'vnicSriovHpnConPolicyRef', 'vnicUsnicConPolicyRef', 'vnicVmqConPolicyRef'], ["Add", "Get", "Remove", "Set"]),
    "VnicEtherIf": MoMeta("VnicEtherIf", "vnicEtherIf", "if-[name]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-network", "ls-server"], ['vnicEther', 'vnicLanConnTempl'], ['faultInst', 'vnicFault', 'vnicIPv4If'], ["Add", "Get", "Remove", "Set"]),
    "VnicFault": MoMeta("VnicFault", "vnicFault", "fault-if", VersionMeta.Version112a, "InputOutput", 0x1, [], ["read-only"], ['storageEthLif', 'vnicEtherIf', 'vnicFcIf', 'vnicFcOEIf', 'vnicIPv4If', 'vnicIPv6If', 'vnicIniGrpFcBIf', 'vnicIniGrpFcIf', 'vnicLifVlan', 'vnicLifVsan', 'vnicMgmtIf', 'vnicMonSesFcIf', 'vnicStorageEthLif', 'vnicVlan'], ['faultInst'], ["Get"]),
    "VnicFc": MoMeta("VnicFc", "vnicFc", "fc-[name]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-network", "ls-server", "ls-storage"], ['computeInstance', 'computeLocalTemplDef', 'fabricFcEstcEpOperation', 'fabricFcMonOperation', 'fabricFcSanEpOperation', 'fabricFcSanPcOperation', 'fabricFcoeEstcEpOperation', 'fabricFcoeSanEpOperation', 'fabricFcoeSanPcOperation', 'lsServer', 'storageVsanRef', 'vnicSanConnPolicy'], ['fabricEthMonSrcEp', 'fabricFcMonSrcEp', 'fabricFcMonSrcEpOperation', 'faultInst', 'vnicBootTarget', 'vnicFcIf'], ["Add", "Get", "Remove", "Set"]),
    "VnicFcGroupDef": MoMeta("VnicFcGroupDef", "vnicFcGroupDef", "fc-group", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-storage"], ['storageIniGroup'], ['faultInst', 'storageConnectionDef', 'vnicIniGrpFc', 'vnicIniGrpFcB'], ["Add", "Get", "Set"]),
    "VnicFcGroupTempl": MoMeta("VnicFcGroupTempl", "vnicFcGroupTempl", "fc-group-templ-[name]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-server", "ls-storage", "ls-storage-policy"], ['orgOrg'], ['faultInst'], [None]),
    "VnicFcIf": MoMeta("VnicFcIf", "vnicFcIf", "if-default", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-network", "ls-server"], ['vnicFc', 'vnicSanConnTempl'], ['faultInst', 'vnicFault'], ["Add", "Get", "Remove", "Set"]),
    "VnicFcLif": MoMeta("VnicFcLif", "vnicFcLif", "eth-lif-[name]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], [], [], ["Get"]),
    "VnicFcNode": MoMeta("VnicFcNode", "vnicFcNode", "fc-node", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-server", "ls-storage"], ['lsServer', 'vnicSanConnPolicy'], ['faultInst'], ["Add", "Get", "Remove", "Set"]),
    "VnicFcOEIf": MoMeta("VnicFcOEIf", "vnicFcOEIf", "fcoe", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy", "ext-san-config", "ext-san-policy", "ls-config", "ls-network", "ls-server", "ls-storage"], ['vnicEther', 'vnicLanConnTempl'], ['vnicFault'], ["Get"]),
    "VnicIPv4Dhcp": MoMeta("VnicIPv4Dhcp", "vnicIPv4Dhcp", "ipv4-dhcp", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-network", "ls-server", "ls-storage"], ['vnicIPv4If'], [], ["Get", "Remove"]),
    "VnicIPv4Dns": MoMeta("VnicIPv4Dns", "vnicIPv4Dns", "ipv4-dns-[pref]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-network", "ls-server"], ['vnicIPv4If', 'vnicIPv4IscsiAddr', 'vnicIPv4PooledIscsiAddr'], [], ["Get"]),
    "VnicIPv4If": MoMeta("VnicIPv4If", "vnicIPv4If", "ipv4", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-network", "ls-server", "ls-storage"], ['storageEthLif', 'vnicEtherIf', 'vnicIScsiBootVnic', 'vnicStorageEthLif', 'vnicVlan'], ['storageIpV4PooledAddr', 'storageIpV4StaticAddr', 'vnicFault', 'vnicIPv4Dhcp', 'vnicIPv4Dns', 'vnicIPv4IscsiAddr', 'vnicIPv4PooledIscsiAddr', 'vnicIPv4StaticRoute', 'vnicIpV4MgmtPooledAddr', 'vnicIpV4PooledAddr', 'vnicIpV4ProfDerivedAddr', 'vnicIpV4StaticAddr'], ["Add", "Get", "Remove", "Set"]),
    "VnicIPv4IscsiAddr": MoMeta("VnicIPv4IscsiAddr", "vnicIPv4IscsiAddr", "ipv4iscsi", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-network", "ls-server", "ls-storage"], ['vnicIPv4If', 'vnicIScsi'], ['vnicIPv4Dns'], ["Add", "Get", "Remove", "Set"]),
    "VnicIPv4PooledIscsiAddr": MoMeta("VnicIPv4PooledIscsiAddr", "vnicIPv4PooledIscsiAddr", "ipv4-pooled-iscsiaddr", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-network", "ls-server", "ls-storage"], ['vnicIPv4If'], ['faultInst', 'vnicIPv4Dns'], ["Add", "Get", "Remove", "Set"]),
    "VnicIPv4StaticRoute": MoMeta("VnicIPv4StaticRoute", "vnicIPv4StaticRoute", "ipv4-route-[addr]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-network", "ls-server"], ['vnicIPv4If'], [], ["Get"]),
    "VnicIPv6If": MoMeta("VnicIPv6If", "vnicIPv6If", "", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-network", "ls-server", "ls-storage"], [], ['vnicFault'], [None]),
    "VnicIScsi": MoMeta("VnicIScsi", "vnicIScsi", "iscsi-[name]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-network", "ls-server", "ls-storage"], ['computeInstance', 'computeLocalTemplDef', 'lsServer'], ['fabricEthMonSrcEp', 'fabricFcMonSrcEp', 'faultInst', 'vnicIPv4IscsiAddr', 'vnicIScsiAutoTargetIf', 'vnicIScsiInitiatorParams', 'vnicIScsiStaticTargetIf', 'vnicVlan'], ["Add", "Get", "Remove", "Set"]),
    "VnicIScsiAutoTargetIf": MoMeta("VnicIScsiAutoTargetIf", "vnicIScsiAutoTargetIf", "auto", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-network", "ls-server", "ls-storage"], ['vnicIScsi', 'vnicIScsiBootVnic', 'vnicIScsiTargetParams', 'vnicVlan'], [], ["Add", "Get", "Remove", "Set"]),
    "VnicIScsiBootParams": MoMeta("VnicIScsiBootParams", "vnicIScsiBootParams", "iscsi-boot-params", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-network", "ls-server", "ls-storage"], ['lsServer'], ['vnicIScsiBootVnic'], ["Add", "Get", "Remove", "Set"]),
    "VnicIScsiBootVnic": MoMeta("VnicIScsiBootVnic", "vnicIScsiBootVnic", "boot-vnic-[name]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-network", "ls-server", "ls-storage"], ['vnicIScsiBootParams', 'vnicIScsiInitiatorParams'], ['faultInst', 'vnicIPv4If', 'vnicIScsiAutoTargetIf', 'vnicIScsiStaticTargetIf'], ["Add", "Get", "Remove", "Set"]),
    "VnicIScsiInitiatorParams": MoMeta("VnicIScsiInitiatorParams", "vnicIScsiInitiatorParams", "iscsi-initiator-params", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-network", "ls-server", "ls-storage"], ['vnicIScsi', 'vnicIScsiLCP'], ['vnicIScsiBootVnic'], ["Get"]),
    "VnicIScsiLCP": MoMeta("VnicIScsiLCP", "vnicIScsiLCP", "iscsi-[name]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-network", "ls-server", "ls-storage"], ['lsServer', 'vnicLanConnPolicy'], ['fabricEthMonSrcEp', 'fabricFcMonSrcEp', 'faultInst', 'vnicIScsiInitiatorParams', 'vnicVlan'], ["Add", "Get", "Remove", "Set"]),
    "VnicIScsiNode": MoMeta("VnicIScsiNode", "vnicIScsiNode", "iscsi-node", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-network", "ls-server"], ['lsServer', 'vnicLanConnPolicy'], ['faultInst'], ["Add", "Get", "Remove", "Set"]),
    "VnicIScsiStaticTargetIf": MoMeta("VnicIScsiStaticTargetIf", "vnicIScsiStaticTargetIf", "[priority]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-network", "ls-server", "ls-storage"], ['vnicIScsi', 'vnicIScsiBootVnic', 'vnicIScsiTargetParams', 'vnicVlan'], ['faultInst', 'vnicLun'], ["Add", "Get", "Remove", "Set"]),
    "VnicIScsiTargetParams": MoMeta("VnicIScsiTargetParams", "vnicIScsiTargetParams", "iscsi-target-params", VersionMeta.Version131a, "InputOutput", 0x1, [], [""], ['lsbootIScsiImagePath'], ['vnicIScsiAutoTargetIf', 'vnicIScsiStaticTargetIf'], [None]),
    "VnicIniGrpFc": MoMeta("VnicIniGrpFc", "vnicIniGrpFc", "inigrp-fc", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-network", "ls-server", "ls-storage"], ['lsServer', 'vnicFcGroupDef'], ['fabricEthMonSrcEp', 'fabricFcMonSrcEp', 'faultInst', 'vnicIniGrpFcIf'], ["Get"]),
    "VnicIniGrpFcB": MoMeta("VnicIniGrpFcB", "vnicIniGrpFcB", "inigrp-fcb", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-server", "ls-storage"], ['lsServer', 'vnicFcGroupDef'], ['fabricEthMonSrcEp', 'fabricFcMonSrcEp', 'faultInst', 'vnicIniGrpFcBIf'], ["get"]),
    "VnicIniGrpFcBIf": MoMeta("VnicIniGrpFcBIf", "vnicIniGrpFcBIf", "inigrp-fcb-if-[name]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-network", "ls-server"], ['vnicIniGrpFcB'], ['vnicFault'], ["get"]),
    "VnicIniGrpFcIf": MoMeta("VnicIniGrpFcIf", "vnicIniGrpFcIf", "inigrp-fc-if-[name]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-network", "ls-server"], ['vnicIniGrpFc'], ['vnicFault'], ["Get"]),
    "VnicIpV4MgmtPooledAddr": MoMeta("VnicIpV4MgmtPooledAddr", "vnicIpV4MgmtPooledAddr", "ipv4-pooled-addr", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-network", "ls-server"], ['computeInstance', 'lsServer', 'mgmtVnet', 'vnicIPv4If', 'vnicMgmtIf'], ['faultInst'], ["Add", "Get", "Remove", "Set"]),
    "VnicIpV4PooledAddr": MoMeta("VnicIpV4PooledAddr", "vnicIpV4PooledAddr", "ipv4-pooled-addr", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-network", "ls-server"], ['computeInstance', 'lsServer', 'mgmtController', 'mgmtVnet', 'vnicIPv4If', 'vnicMgmtIf', 'vnicOutbandMgmtEp'], ['faultInst'], ["Get"]),
    "VnicIpV4ProfDerivedAddr": MoMeta("VnicIpV4ProfDerivedAddr", "vnicIpV4ProfDerivedAddr", "ipv4-prof-addr", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], ['mgmtController', 'vnicIPv4If'], [], ["Get"]),
    "VnicIpV4StaticAddr": MoMeta("VnicIpV4StaticAddr", "vnicIpV4StaticAddr", "ipv4-static-addr", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-network", "ls-server"], ['computeInstance', 'lsServer', 'lsbootLanImagePath', 'mgmtController', 'mgmtVnet', 'vnicIPv4If', 'vnicMgmtIf', 'vnicOutbandMgmtEp'], [], ["Add", "Get", "Remove", "Set"]),
    "VnicIpV6MgmtPooledAddr": MoMeta("VnicIpV6MgmtPooledAddr", "vnicIpV6MgmtPooledAddr", "ipv6-pooled-addr", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-network", "ls-server"], ['mgmtVnet', 'vnicMgmtIf'], ['faultInst'], ["Add", "Get", "Remove", "Set"]),
    "VnicIpV6StaticAddr": MoMeta("VnicIpV6StaticAddr", "vnicIpV6StaticAddr", "ipv6-static-addr", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-network", "ls-server"], ['mgmtVnet', 'vnicMgmtIf'], [], ["Add", "Get", "Remove", "Set"]),
    "VnicLanConnPolicy": MoMeta("VnicLanConnPolicy", "vnicLanConnPolicy", "lan-conn-pol-[name]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['orgOrg'], ['vnicEther', 'vnicIScsiLCP', 'vnicIScsiNode'], ["Add", "Get", "Remove", "Set"]),
    "VnicLanConnTempl": MoMeta("VnicLanConnTempl", "vnicLanConnTempl", "lan-conn-templ-[name]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['orgOrg'], ['fabricNetGroupRef', 'fabricSanGroupRef', 'faultInst', 'vnicDynamicConPolicyRef', 'vnicEtherIf', 'vnicFcOEIf', 'vnicSriovHpnConPolicyRef', 'vnicUsnicConPolicyRef', 'vnicVmqConPolicyRef'], ["Add", "Get", "Remove", "Set"]),
    "VnicLifVlan": MoMeta("VnicLifVlan", "vnicLifVlan", "vlan-[vnet]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-network", "ls-server", "read-only"], ['vnicEther'], ['vnicFault'], ["Get"]),
    "VnicLifVsan": MoMeta("VnicLifVsan", "vnicLifVsan", "vsan-[vnet]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-network", "ls-server", "read-only"], [], ['vnicFault'], ["Get"]),
    "VnicLstorageIScsi": MoMeta("VnicLstorageIScsi", "vnicLstorageIScsi", "lstorageIScsi-[name]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-network", "ls-server", "ls-storage"], ['lsServer'], ['fabricEthMonSrcEp', 'fabricFcMonSrcEp', 'faultInst', 'vnicVlan'], ["Get"]),
    "VnicLun": MoMeta("VnicLun", "vnicLun", "lun", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-server", "ls-storage"], ['vnicIScsiStaticTargetIf'], [], ["Add", "Get", "Remove", "Set"]),
    "VnicMgmt": MoMeta("VnicMgmt", "vnicMgmt", "mgmt", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-server", "ls-storage"], ['fdBlade', 'fdRackUnit', 'lsServer'], ['fabricEthMonSrcEp', 'fabricFcMonSrcEp', 'faultInst', 'vnicMgmtIf'], ["Add", "Get", "Remove", "Set"]),
    "VnicMgmtIf": MoMeta("VnicMgmtIf", "vnicMgmtIf", "mgmt-if", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-network", "ls-server"], ['vnicMgmt'], ['faultInst', 'storageIpV4PooledAddr', 'storageIpV4StaticAddr', 'vnicFault', 'vnicIpV4MgmtPooledAddr', 'vnicIpV4PooledAddr', 'vnicIpV4StaticAddr', 'vnicIpV6MgmtPooledAddr', 'vnicIpV6StaticAddr'], ["Add", "Get", "Remove", "Set"]),
    "VnicMonSesFc": MoMeta("VnicMonSesFc", "vnicMonSesFc", "monses-fc-[name]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-server", "ls-storage"], ['fabricFcEstcEpOperation', 'fabricFcMonOperation', 'fabricFcSanEpOperation', 'fabricFcSanPcOperation', 'fabricFcoeEstcEpOperation', 'fabricFcoeSanEpOperation', 'fabricFcoeSanPcOperation', 'lsServer'], ['fabricEthMonSrcEp', 'fabricFcMonSrcEp', 'faultInst', 'vnicMonSesFcIf'], ["Get"]),
    "VnicMonSesFcIf": MoMeta("VnicMonSesFcIf", "vnicMonSesFcIf", "monses-fc-if-[name]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-network", "ls-server"], ['vnicMonSesFc'], ['vnicFault'], ["Get"]),
    "VnicNetGroup": MoMeta("VnicNetGroup", "vnicNetGroup", "ng-[name]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin"], ['fabricLanCloud'], ['vnicEther', 'vnicNetGroupRef'], [None]),
    "VnicNetGroupRef": MoMeta("VnicNetGroupRef", "vnicNetGroupRef", "ngref-[name]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin"], ['vnicNetGroup'], ['vnicEther'], [None]),
    "VnicOutbandMgmtEp": MoMeta("VnicOutbandMgmtEp", "vnicOutbandMgmtEp", "outband-ep", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], ['fdBlade', 'fdRackUnit'], ['eventInst', 'faultInst', 'messageEp', 'vnicIpV4PooledAddr', 'vnicIpV4StaticAddr', 'vnicOutbandMgmtEpFsm', 'vnicOutbandMgmtEpFsmTask'], ["get"]),
    "VnicOutbandMgmtEpFsm": MoMeta("VnicOutbandMgmtEpFsm", "vnicOutbandMgmtEpFsm", "fsm", VersionMeta.Version201b, "OutputOnly", 0x1, [], [""], ['vnicOutbandMgmtEp'], ['vnicOutbandMgmtEpFsmStage'], [None]),
    "VnicOutbandMgmtEpFsmStage": MoMeta("VnicOutbandMgmtEpFsmStage", "vnicOutbandMgmtEpFsmStage", "stage-[name]", VersionMeta.Version201b, "OutputOnly", 0x1, [], [""], ['vnicOutbandMgmtEpFsm'], [], [None]),
    "VnicOutbandMgmtEpFsmTask": MoMeta("VnicOutbandMgmtEpFsmTask", "vnicOutbandMgmtEpFsmTask", "task-[item]", VersionMeta.Version201b, "OutputOnly", 0x1, [], [""], ['vnicOutbandMgmtEp'], [], [None]),
    "VnicProfileSet": MoMeta("VnicProfileSet", "vnicProfileSet", "profiles", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy"], ['fabricLanCloud'], ['vnicRackServerDiscoveryProfile'], ["Get"]),
    "VnicRackServerDiscoveryProfile": MoMeta("VnicRackServerDiscoveryProfile", "vnicRackServerDiscoveryProfile", "vnic-[name]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["read-only"], ['vnicProfileSet'], [], ["Get", "Set"]),
    "VnicSanConnPolicy": MoMeta("VnicSanConnPolicy", "vnicSanConnPolicy", "san-conn-pol-[name]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['orgOrg'], ['storageIniGroup', 'vnicFc', 'vnicFcNode'], ["Add", "Get", "Remove", "Set"]),
    "VnicSanConnTempl": MoMeta("VnicSanConnTempl", "vnicSanConnTempl", "san-conn-templ-[name]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['orgOrg'], ['fabricNetGroupRef', 'fabricSanGroupRef', 'faultInst', 'vnicFcIf'], ["Add", "Get", "Remove", "Set"]),
    "VnicSriovHpnConPolicy": MoMeta("VnicSriovHpnConPolicy", "vnicSriovHpnConPolicy", "sriov-hpn-con-[name]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy", "ls-server"], ['orgOrg'], [], [None]),
    "VnicSriovHpnConPolicyRef": MoMeta("VnicSriovHpnConPolicyRef", "vnicSriovHpnConPolicyRef", "sriov-hpn-con-ref", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-network", "ls-server"], ['vnicEther', 'vnicLanConnTempl'], ['faultInst'], [None]),
    "VnicStorageEthLif": MoMeta("VnicStorageEthLif", "vnicStorageEthLif", "eth-lif-[name]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-network", "ls-server", "ls-storage"], [], ['faultInst', 'vnicFault', 'vnicIPv4If'], [None]),
    "VnicUsnicConPolicy": MoMeta("VnicUsnicConPolicy", "vnicUsnicConPolicy", "usnic-con-[name]", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy", "ls-server"], ['orgOrg'], [], ["Add", "Get", "Remove", "Set"]),
    "VnicUsnicConPolicyRef": MoMeta("VnicUsnicConPolicyRef", "vnicUsnicConPolicyRef", "usnic-con-ref", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-network", "ls-server"], ['vnicEther', 'vnicLanConnTempl'], ['faultInst'], ["Add", "Get", "Remove"]),
    "VnicVhbaBehPolicy": MoMeta("VnicVhbaBehPolicy", "vnicVhbaBehPolicy", "beh-vhba", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['orgOrg'], [], ["Get", "Set"]),
    "VnicVlan": MoMeta("VnicVlan", "vnicVlan", "vlan", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-network", "ls-server"], ['vnicIScsi', 'vnicIScsiLCP', 'vnicLstorageIScsi'], ['vnicFault', 'vnicIPv4If', 'vnicIScsiAutoTargetIf', 'vnicIScsiStaticTargetIf'], ["Add", "Get", "Remove", "Set"]),
    "VnicVmqConPolicy": MoMeta("VnicVmqConPolicy", "vnicVmqConPolicy", "vmq-con-[name]", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-network", "ls-network-policy", "ls-server"], ['orgOrg'], [], ["Add", "Get", "Remove", "Set"]),
    "VnicVmqConPolicyRef": MoMeta("VnicVmqConPolicyRef", "vnicVmqConPolicyRef", "vmq-con-ref", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-network", "ls-server"], ['vnicEther', 'vnicLanConnTempl'], ['faultInst'], ["Add", "Get", "Remove"]),
    "VnicVnicBehPolicy": MoMeta("VnicVnicBehPolicy", "vnicVnicBehPolicy", "beh-vnic", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], ['orgOrg'], [], ["Get", "Set"]),
}


METHOD_CLASS_ID = frozenset([
    "AaaChangeSelfPassword",
    "AaaCheckComputeAuthToken",
    "AaaCheckComputeExtAccess",
    "AaaGetAuthTokenClient",
    "AaaGetAuthTokenInternal",
    "AaaGetComputeAuthToken",
    "AaaGetKVMLaunchUrlInternal",
    "AaaGetNComputeAuthTokenByDn",
    "AaaGetNComputeAuthTokenInternalByDn",
    "AaaGetRemoteUserRoles",
    "AaaGetUserLocales",
    "AaaKeepAlive",
    "AaaLogin",
    "AaaLoginByToken",
    "AaaLogout",
    "AaaRefresh",
    "AaaTokenLogin",
    "AaaTokenRefresh",
    "CliviewConfMos",
    "ComputeGetQualifiedServers",
    "ComputeGetServerCatalog",
    "ComputeReQualifyMembership",
    "ConfigCheckHardwareCompatibility",
    "ConfigClone",
    "ConfigConfFiltered",
    "ConfigConfMo",
    "ConfigConfMoGroup",
    "ConfigConfMos",
    "ConfigConfRename",
    "ConfigDeleteMo",
    "ConfigFindDependencies",
    "ConfigFindDnsByClassId",
    "ConfigFindPolicyUsage",
    "ConfigGetAckables",
    "ConfigGetConnectedEndpoints",
    "ConfigGetEstimateImpact",
    "ConfigGetIdUniverseUsage",
    "ConfigGetLastBackedUpDomains",
    "ConfigGetNetRefs",
    "ConfigGetPolicyDomainGroup",
    "ConfigGetQualifiedDomains",
    "ConfigGetTokenRequestors",
    "ConfigInstantiateNNamedTemplate",
    "ConfigInstantiateNTemplate",
    "ConfigInstantiateTemplate",
    "ConfigMoChangeEvent",
    "ConfigPublishVlan",
    "ConfigPublishVsan",
    "ConfigRefreshIdentity",
    "ConfigReleaseResolveContext",
    "ConfigRemoteSearch",
    "ConfigRenewResolveContext",
    "ConfigResolveAncestor",
    "ConfigResolveChildren",
    "ConfigResolveChildrenSorted",
    "ConfigResolveClass",
    "ConfigResolveClassDB",
    "ConfigResolveClassFilterIdx",
    "ConfigResolveClassIdx",
    "ConfigResolveClassSorted",
    "ConfigResolveClasses",
    "ConfigResolveClassesSorted",
    "ConfigResolveContext",
    "ConfigResolveDn",
    "ConfigResolveDns",
    "ConfigResolveDomainElements",
    "ConfigResolveParent",
    "ConfigResolveSpotLightIdx",
    "ConfigScope",
    "ConfigSendAppImpactResponse",
    "ConfigTags",
    "ConfigTemplatise",
    "ConfigUCEstimateImpact",
    "EquipmentClone",
    "EquipmentInstantiateNNamedTemplate",
    "EquipmentInstantiateNTemplate",
    "EquipmentInstantiateTemplate",
    "EquipmentTemplatise",
    "EventSendHeartbeat",
    "EventSubscribe",
    "EventSubscribeApps",
    "FabricPermitsForExistingVlanNames",
    "FabricResolveVlanPermits",
    "FabricVnetIdEpOverlapCheck",
    "FaultAckFault",
    "FaultAckFaultByDn",
    "FaultAckFaults",
    "FaultAckFaultsByDn",
    "FaultResolveFault",
    "FirmwareEstimatePackImpact",
    "FirmwareInstallAll",
    "FsmDebugAction",
    "IdentGetBlockReport",
    "IdentGetIdUsage",
    "IdentGetSortedIds",
    "LoggingSyncOcns",
    "LsClone",
    "LsInstantiateNNamedTemplate",
    "LsInstantiateNTemplate",
    "LsInstantiateTemplate",
    "LsTemplatise",
    "LstorageClone",
    "MethodVessel",
    "OrgGetDomainFirmwareReport",
    "OrgGetDomainPolicyReport",
    "OrgGetImpactedDomains",
    "OrgGetNumImpactedDomains",
    "OrgGetSubscribedDomains",
    "OrgResolveElements",
    "OrgResolveInScope",
    "OrgResolveLogicalParents",
    "PolicyResolveNames",
    "PoolResolveInScope",
    "SnmpFindVar",
    "StatsBuildChartResult",
    "StatsBuildCustomChart",
    "StatsBuildStandardChart",
    "StatsClearInterval",
    "StatsSubscribe",
    "SyntheticFSObjInventory",
    "SyntheticFSObjInventoryB",
    "SyntheticTestTx",
])


OTHER_TYPE_CLASS_ID = {
    "Method": "ucscbasetype",
    "MethodSet": "ucscbasetype",
    "AllbitsFilter": "ucscfiltertype",
    "AndFilter": "ucscfiltertype",
    "AnybitFilter": "ucscfiltertype",
    "BwFilter": "ucscfiltertype",
    "ClassId": "ucscbasetype",
    "ClassIdSet": "ucscbasetype",
    "ConfigConfig": "ucscbasetype",
    "ConfigMap": "ucscbasetype",
    "ConfigSet": "ucscbasetype",
    "Dn": "ucscbasetype",
    "DnSet": "ucscbasetype",
    "EqFilter": "ucscfiltertype",
    "FilterFilter": "ucscbasetype",
    "GeFilter": "ucscfiltertype",
    "GtFilter": "ucscfiltertype",
    "Id": "ucscbasetype",
    "IdSet": "ucscbasetype",
    "LeFilter": "ucscfiltertype",
    "LtFilter": "ucscfiltertype",
    "NeFilter": "ucscfiltertype",
    "NotFilter": "ucscfiltertype",
    "OrFilter": "ucscfiltertype",
    "Pair": "ucscbasetype",
    "WcardFilter": "ucscfiltertype",
}
