# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NgfwArgs', 'Ngfw']

@pulumi.input_type
class NgfwArgs:
    def __init__(__self__, *,
                 endpoint_mode: pulumi.Input[_builtins.str],
                 subnet_mappings: pulumi.Input[Sequence[pulumi.Input['NgfwSubnetMappingArgs']]],
                 vpc_id: pulumi.Input[_builtins.str],
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 app_id_version: Optional[pulumi.Input[_builtins.str]] = None,
                 automatic_upgrade_app_id_version: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 global_rulestack: Optional[pulumi.Input[_builtins.str]] = None,
                 link_id: Optional[pulumi.Input[_builtins.str]] = None,
                 multi_vpc: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 rulestack: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Ngfw resource.
        :param pulumi.Input[_builtins.str] endpoint_mode: Set endpoint mode from the following options. Valid values are `ServiceManaged` or `CustomerManaged`.
        :param pulumi.Input[Sequence[pulumi.Input['NgfwSubnetMappingArgs']]] subnet_mappings: Subnet mappings.
        :param pulumi.Input[_builtins.str] vpc_id: The vpc id.
        :param pulumi.Input[_builtins.str] account_id: The account ID. This field is mandatory if using multiple accounts.
        :param pulumi.Input[_builtins.str] app_id_version: App-ID version number.
        :param pulumi.Input[_builtins.bool] automatic_upgrade_app_id_version: Automatic App-ID upgrade version number. Defaults to `true`.
        :param pulumi.Input[_builtins.str] description: The description.
        :param pulumi.Input[_builtins.str] global_rulestack: The global rulestack for this NGFW.
        :param pulumi.Input[_builtins.str] link_id: A unique identifier for establishing and managing the link between the Cloud NGFW and other AWS resources.
        :param pulumi.Input[_builtins.bool] multi_vpc: Share NGFW with Multiple VPCs. This feature can be enabled only if the endpoint_mode is CustomerManaged.
        :param pulumi.Input[_builtins.str] name: The NGFW name.
        :param pulumi.Input[_builtins.str] rulestack: The rulestack for this NGFW.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tags.
        """
        pulumi.set(__self__, "endpoint_mode", endpoint_mode)
        pulumi.set(__self__, "subnet_mappings", subnet_mappings)
        pulumi.set(__self__, "vpc_id", vpc_id)
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if app_id_version is not None:
            pulumi.set(__self__, "app_id_version", app_id_version)
        if automatic_upgrade_app_id_version is not None:
            pulumi.set(__self__, "automatic_upgrade_app_id_version", automatic_upgrade_app_id_version)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if global_rulestack is not None:
            pulumi.set(__self__, "global_rulestack", global_rulestack)
        if link_id is not None:
            pulumi.set(__self__, "link_id", link_id)
        if multi_vpc is not None:
            pulumi.set(__self__, "multi_vpc", multi_vpc)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if rulestack is not None:
            pulumi.set(__self__, "rulestack", rulestack)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="endpointMode")
    def endpoint_mode(self) -> pulumi.Input[_builtins.str]:
        """
        Set endpoint mode from the following options. Valid values are `ServiceManaged` or `CustomerManaged`.
        """
        return pulumi.get(self, "endpoint_mode")

    @endpoint_mode.setter
    def endpoint_mode(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "endpoint_mode", value)

    @_builtins.property
    @pulumi.getter(name="subnetMappings")
    def subnet_mappings(self) -> pulumi.Input[Sequence[pulumi.Input['NgfwSubnetMappingArgs']]]:
        """
        Subnet mappings.
        """
        return pulumi.get(self, "subnet_mappings")

    @subnet_mappings.setter
    def subnet_mappings(self, value: pulumi.Input[Sequence[pulumi.Input['NgfwSubnetMappingArgs']]]):
        pulumi.set(self, "subnet_mappings", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[_builtins.str]:
        """
        The vpc id.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The account ID. This field is mandatory if using multiple accounts.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter(name="appIdVersion")
    def app_id_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        App-ID version number.
        """
        return pulumi.get(self, "app_id_version")

    @app_id_version.setter
    def app_id_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "app_id_version", value)

    @_builtins.property
    @pulumi.getter(name="automaticUpgradeAppIdVersion")
    def automatic_upgrade_app_id_version(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Automatic App-ID upgrade version number. Defaults to `true`.
        """
        return pulumi.get(self, "automatic_upgrade_app_id_version")

    @automatic_upgrade_app_id_version.setter
    def automatic_upgrade_app_id_version(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "automatic_upgrade_app_id_version", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="globalRulestack")
    def global_rulestack(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The global rulestack for this NGFW.
        """
        return pulumi.get(self, "global_rulestack")

    @global_rulestack.setter
    def global_rulestack(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "global_rulestack", value)

    @_builtins.property
    @pulumi.getter(name="linkId")
    def link_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A unique identifier for establishing and managing the link between the Cloud NGFW and other AWS resources.
        """
        return pulumi.get(self, "link_id")

    @link_id.setter
    def link_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "link_id", value)

    @_builtins.property
    @pulumi.getter(name="multiVpc")
    def multi_vpc(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Share NGFW with Multiple VPCs. This feature can be enabled only if the endpoint_mode is CustomerManaged.
        """
        return pulumi.get(self, "multi_vpc")

    @multi_vpc.setter
    def multi_vpc(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "multi_vpc", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The NGFW name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def rulestack(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The rulestack for this NGFW.
        """
        return pulumi.get(self, "rulestack")

    @rulestack.setter
    def rulestack(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rulestack", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _NgfwState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 app_id_version: Optional[pulumi.Input[_builtins.str]] = None,
                 automatic_upgrade_app_id_version: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint_service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 firewall_id: Optional[pulumi.Input[_builtins.str]] = None,
                 global_rulestack: Optional[pulumi.Input[_builtins.str]] = None,
                 link_id: Optional[pulumi.Input[_builtins.str]] = None,
                 link_status: Optional[pulumi.Input[_builtins.str]] = None,
                 multi_vpc: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 rulestack: Optional[pulumi.Input[_builtins.str]] = None,
                 statuses: Optional[pulumi.Input[Sequence[pulumi.Input['NgfwStatusArgs']]]] = None,
                 subnet_mappings: Optional[pulumi.Input[Sequence[pulumi.Input['NgfwSubnetMappingArgs']]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 update_token: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Ngfw resources.
        :param pulumi.Input[_builtins.str] account_id: The account ID. This field is mandatory if using multiple accounts.
        :param pulumi.Input[_builtins.str] app_id_version: App-ID version number.
        :param pulumi.Input[_builtins.bool] automatic_upgrade_app_id_version: Automatic App-ID upgrade version number. Defaults to `true`.
        :param pulumi.Input[_builtins.str] description: The description.
        :param pulumi.Input[_builtins.str] endpoint_mode: Set endpoint mode from the following options. Valid values are `ServiceManaged` or `CustomerManaged`.
        :param pulumi.Input[_builtins.str] endpoint_service_name: The endpoint service name.
        :param pulumi.Input[_builtins.str] firewall_id: The Id of the NGFW.
        :param pulumi.Input[_builtins.str] global_rulestack: The global rulestack for this NGFW.
        :param pulumi.Input[_builtins.str] link_id: A unique identifier for establishing and managing the link between the Cloud NGFW and other AWS resources.
        :param pulumi.Input[_builtins.str] link_status: The link status.
        :param pulumi.Input[_builtins.bool] multi_vpc: Share NGFW with Multiple VPCs. This feature can be enabled only if the endpoint_mode is CustomerManaged.
        :param pulumi.Input[_builtins.str] name: The NGFW name.
        :param pulumi.Input[_builtins.str] rulestack: The rulestack for this NGFW.
        :param pulumi.Input[Sequence[pulumi.Input['NgfwSubnetMappingArgs']]] subnet_mappings: Subnet mappings.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tags.
        :param pulumi.Input[_builtins.str] update_token: The update token.
        :param pulumi.Input[_builtins.str] vpc_id: The vpc id.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if app_id_version is not None:
            pulumi.set(__self__, "app_id_version", app_id_version)
        if automatic_upgrade_app_id_version is not None:
            pulumi.set(__self__, "automatic_upgrade_app_id_version", automatic_upgrade_app_id_version)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if endpoint_mode is not None:
            pulumi.set(__self__, "endpoint_mode", endpoint_mode)
        if endpoint_service_name is not None:
            pulumi.set(__self__, "endpoint_service_name", endpoint_service_name)
        if firewall_id is not None:
            pulumi.set(__self__, "firewall_id", firewall_id)
        if global_rulestack is not None:
            pulumi.set(__self__, "global_rulestack", global_rulestack)
        if link_id is not None:
            pulumi.set(__self__, "link_id", link_id)
        if link_status is not None:
            pulumi.set(__self__, "link_status", link_status)
        if multi_vpc is not None:
            pulumi.set(__self__, "multi_vpc", multi_vpc)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if rulestack is not None:
            pulumi.set(__self__, "rulestack", rulestack)
        if statuses is not None:
            pulumi.set(__self__, "statuses", statuses)
        if subnet_mappings is not None:
            pulumi.set(__self__, "subnet_mappings", subnet_mappings)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if update_token is not None:
            pulumi.set(__self__, "update_token", update_token)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The account ID. This field is mandatory if using multiple accounts.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter(name="appIdVersion")
    def app_id_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        App-ID version number.
        """
        return pulumi.get(self, "app_id_version")

    @app_id_version.setter
    def app_id_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "app_id_version", value)

    @_builtins.property
    @pulumi.getter(name="automaticUpgradeAppIdVersion")
    def automatic_upgrade_app_id_version(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Automatic App-ID upgrade version number. Defaults to `true`.
        """
        return pulumi.get(self, "automatic_upgrade_app_id_version")

    @automatic_upgrade_app_id_version.setter
    def automatic_upgrade_app_id_version(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "automatic_upgrade_app_id_version", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="endpointMode")
    def endpoint_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Set endpoint mode from the following options. Valid values are `ServiceManaged` or `CustomerManaged`.
        """
        return pulumi.get(self, "endpoint_mode")

    @endpoint_mode.setter
    def endpoint_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "endpoint_mode", value)

    @_builtins.property
    @pulumi.getter(name="endpointServiceName")
    def endpoint_service_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The endpoint service name.
        """
        return pulumi.get(self, "endpoint_service_name")

    @endpoint_service_name.setter
    def endpoint_service_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "endpoint_service_name", value)

    @_builtins.property
    @pulumi.getter(name="firewallId")
    def firewall_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Id of the NGFW.
        """
        return pulumi.get(self, "firewall_id")

    @firewall_id.setter
    def firewall_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "firewall_id", value)

    @_builtins.property
    @pulumi.getter(name="globalRulestack")
    def global_rulestack(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The global rulestack for this NGFW.
        """
        return pulumi.get(self, "global_rulestack")

    @global_rulestack.setter
    def global_rulestack(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "global_rulestack", value)

    @_builtins.property
    @pulumi.getter(name="linkId")
    def link_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A unique identifier for establishing and managing the link between the Cloud NGFW and other AWS resources.
        """
        return pulumi.get(self, "link_id")

    @link_id.setter
    def link_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "link_id", value)

    @_builtins.property
    @pulumi.getter(name="linkStatus")
    def link_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The link status.
        """
        return pulumi.get(self, "link_status")

    @link_status.setter
    def link_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "link_status", value)

    @_builtins.property
    @pulumi.getter(name="multiVpc")
    def multi_vpc(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Share NGFW with Multiple VPCs. This feature can be enabled only if the endpoint_mode is CustomerManaged.
        """
        return pulumi.get(self, "multi_vpc")

    @multi_vpc.setter
    def multi_vpc(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "multi_vpc", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The NGFW name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def rulestack(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The rulestack for this NGFW.
        """
        return pulumi.get(self, "rulestack")

    @rulestack.setter
    def rulestack(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rulestack", value)

    @_builtins.property
    @pulumi.getter
    def statuses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NgfwStatusArgs']]]]:
        return pulumi.get(self, "statuses")

    @statuses.setter
    def statuses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NgfwStatusArgs']]]]):
        pulumi.set(self, "statuses", value)

    @_builtins.property
    @pulumi.getter(name="subnetMappings")
    def subnet_mappings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NgfwSubnetMappingArgs']]]]:
        """
        Subnet mappings.
        """
        return pulumi.get(self, "subnet_mappings")

    @subnet_mappings.setter
    def subnet_mappings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NgfwSubnetMappingArgs']]]]):
        pulumi.set(self, "subnet_mappings", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="updateToken")
    def update_token(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The update token.
        """
        return pulumi.get(self, "update_token")

    @update_token.setter
    def update_token(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_token", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The vpc id.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)


@pulumi.type_token("cloudngfwaws:index/ngfw:Ngfw")
class Ngfw(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 app_id_version: Optional[pulumi.Input[_builtins.str]] = None,
                 automatic_upgrade_app_id_version: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 global_rulestack: Optional[pulumi.Input[_builtins.str]] = None,
                 link_id: Optional[pulumi.Input[_builtins.str]] = None,
                 multi_vpc: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 rulestack: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NgfwSubnetMappingArgs', 'NgfwSubnetMappingArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws
        import pulumi_cloudngfwaws as cloudngfwaws

        rs = cloudngfwaws.CommitRulestack("rs", rulestack="my-rulestack")
        example_vpc = aws.index.Vpc("example",
            cidr_block=172.16.0.0/16,
            tags={
                name: tf-example,
            })
        subnet1 = aws.index.Subnet("subnet1",
            vpc_id=my_vpc.id,
            cidr_block=172.16.10.0/24,
            availability_zone=us-west-2a,
            tags={
                name: tf-example,
            })
        subnet2 = aws.index.Subnet("subnet2",
            vpc_id=my_vpc.id,
            cidr_block=172.16.20.0/24,
            availability_zone=us-west-2b,
            tags={
                name: tf-example,
            })
        example = cloudngfwaws.Ngfw("example",
            name="example-instance",
            vpc_id=example_vpc["id"],
            account_id="12345678",
            description="Example description",
            link_id="Link-81e80ccc-357a-4e4e-8325-1ed1d830cba5",
            endpoint_mode="ServiceManaged",
            subnet_mappings=[
                {
                    "subnet_id": subnet1["id"],
                },
                {
                    "subnet_id": subnet2["id"],
                },
            ],
            rulestack=rs.rulestack,
            tags={
                "Foo": "bar",
            })
        ```

        ## Import

        import name is <account_id>:<name>

        ```sh
        $ pulumi import cloudngfwaws:index/ngfw:Ngfw example 12345678:example-instance
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: The account ID. This field is mandatory if using multiple accounts.
        :param pulumi.Input[_builtins.str] app_id_version: App-ID version number.
        :param pulumi.Input[_builtins.bool] automatic_upgrade_app_id_version: Automatic App-ID upgrade version number. Defaults to `true`.
        :param pulumi.Input[_builtins.str] description: The description.
        :param pulumi.Input[_builtins.str] endpoint_mode: Set endpoint mode from the following options. Valid values are `ServiceManaged` or `CustomerManaged`.
        :param pulumi.Input[_builtins.str] global_rulestack: The global rulestack for this NGFW.
        :param pulumi.Input[_builtins.str] link_id: A unique identifier for establishing and managing the link between the Cloud NGFW and other AWS resources.
        :param pulumi.Input[_builtins.bool] multi_vpc: Share NGFW with Multiple VPCs. This feature can be enabled only if the endpoint_mode is CustomerManaged.
        :param pulumi.Input[_builtins.str] name: The NGFW name.
        :param pulumi.Input[_builtins.str] rulestack: The rulestack for this NGFW.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NgfwSubnetMappingArgs', 'NgfwSubnetMappingArgsDict']]]] subnet_mappings: Subnet mappings.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tags.
        :param pulumi.Input[_builtins.str] vpc_id: The vpc id.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NgfwArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws
        import pulumi_cloudngfwaws as cloudngfwaws

        rs = cloudngfwaws.CommitRulestack("rs", rulestack="my-rulestack")
        example_vpc = aws.index.Vpc("example",
            cidr_block=172.16.0.0/16,
            tags={
                name: tf-example,
            })
        subnet1 = aws.index.Subnet("subnet1",
            vpc_id=my_vpc.id,
            cidr_block=172.16.10.0/24,
            availability_zone=us-west-2a,
            tags={
                name: tf-example,
            })
        subnet2 = aws.index.Subnet("subnet2",
            vpc_id=my_vpc.id,
            cidr_block=172.16.20.0/24,
            availability_zone=us-west-2b,
            tags={
                name: tf-example,
            })
        example = cloudngfwaws.Ngfw("example",
            name="example-instance",
            vpc_id=example_vpc["id"],
            account_id="12345678",
            description="Example description",
            link_id="Link-81e80ccc-357a-4e4e-8325-1ed1d830cba5",
            endpoint_mode="ServiceManaged",
            subnet_mappings=[
                {
                    "subnet_id": subnet1["id"],
                },
                {
                    "subnet_id": subnet2["id"],
                },
            ],
            rulestack=rs.rulestack,
            tags={
                "Foo": "bar",
            })
        ```

        ## Import

        import name is <account_id>:<name>

        ```sh
        $ pulumi import cloudngfwaws:index/ngfw:Ngfw example 12345678:example-instance
        ```

        :param str resource_name: The name of the resource.
        :param NgfwArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NgfwArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 app_id_version: Optional[pulumi.Input[_builtins.str]] = None,
                 automatic_upgrade_app_id_version: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 global_rulestack: Optional[pulumi.Input[_builtins.str]] = None,
                 link_id: Optional[pulumi.Input[_builtins.str]] = None,
                 multi_vpc: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 rulestack: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NgfwSubnetMappingArgs', 'NgfwSubnetMappingArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NgfwArgs.__new__(NgfwArgs)

            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["app_id_version"] = app_id_version
            __props__.__dict__["automatic_upgrade_app_id_version"] = automatic_upgrade_app_id_version
            __props__.__dict__["description"] = description
            if endpoint_mode is None and not opts.urn:
                raise TypeError("Missing required property 'endpoint_mode'")
            __props__.__dict__["endpoint_mode"] = endpoint_mode
            __props__.__dict__["global_rulestack"] = global_rulestack
            __props__.__dict__["link_id"] = link_id
            __props__.__dict__["multi_vpc"] = multi_vpc
            __props__.__dict__["name"] = name
            __props__.__dict__["rulestack"] = rulestack
            if subnet_mappings is None and not opts.urn:
                raise TypeError("Missing required property 'subnet_mappings'")
            __props__.__dict__["subnet_mappings"] = subnet_mappings
            __props__.__dict__["tags"] = tags
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["endpoint_service_name"] = None
            __props__.__dict__["firewall_id"] = None
            __props__.__dict__["link_status"] = None
            __props__.__dict__["statuses"] = None
            __props__.__dict__["update_token"] = None
        super(Ngfw, __self__).__init__(
            'cloudngfwaws:index/ngfw:Ngfw',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[_builtins.str]] = None,
            app_id_version: Optional[pulumi.Input[_builtins.str]] = None,
            automatic_upgrade_app_id_version: Optional[pulumi.Input[_builtins.bool]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            endpoint_mode: Optional[pulumi.Input[_builtins.str]] = None,
            endpoint_service_name: Optional[pulumi.Input[_builtins.str]] = None,
            firewall_id: Optional[pulumi.Input[_builtins.str]] = None,
            global_rulestack: Optional[pulumi.Input[_builtins.str]] = None,
            link_id: Optional[pulumi.Input[_builtins.str]] = None,
            link_status: Optional[pulumi.Input[_builtins.str]] = None,
            multi_vpc: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            rulestack: Optional[pulumi.Input[_builtins.str]] = None,
            statuses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NgfwStatusArgs', 'NgfwStatusArgsDict']]]]] = None,
            subnet_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NgfwSubnetMappingArgs', 'NgfwSubnetMappingArgsDict']]]]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            update_token: Optional[pulumi.Input[_builtins.str]] = None,
            vpc_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'Ngfw':
        """
        Get an existing Ngfw resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: The account ID. This field is mandatory if using multiple accounts.
        :param pulumi.Input[_builtins.str] app_id_version: App-ID version number.
        :param pulumi.Input[_builtins.bool] automatic_upgrade_app_id_version: Automatic App-ID upgrade version number. Defaults to `true`.
        :param pulumi.Input[_builtins.str] description: The description.
        :param pulumi.Input[_builtins.str] endpoint_mode: Set endpoint mode from the following options. Valid values are `ServiceManaged` or `CustomerManaged`.
        :param pulumi.Input[_builtins.str] endpoint_service_name: The endpoint service name.
        :param pulumi.Input[_builtins.str] firewall_id: The Id of the NGFW.
        :param pulumi.Input[_builtins.str] global_rulestack: The global rulestack for this NGFW.
        :param pulumi.Input[_builtins.str] link_id: A unique identifier for establishing and managing the link between the Cloud NGFW and other AWS resources.
        :param pulumi.Input[_builtins.str] link_status: The link status.
        :param pulumi.Input[_builtins.bool] multi_vpc: Share NGFW with Multiple VPCs. This feature can be enabled only if the endpoint_mode is CustomerManaged.
        :param pulumi.Input[_builtins.str] name: The NGFW name.
        :param pulumi.Input[_builtins.str] rulestack: The rulestack for this NGFW.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NgfwSubnetMappingArgs', 'NgfwSubnetMappingArgsDict']]]] subnet_mappings: Subnet mappings.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tags.
        :param pulumi.Input[_builtins.str] update_token: The update token.
        :param pulumi.Input[_builtins.str] vpc_id: The vpc id.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NgfwState.__new__(_NgfwState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["app_id_version"] = app_id_version
        __props__.__dict__["automatic_upgrade_app_id_version"] = automatic_upgrade_app_id_version
        __props__.__dict__["description"] = description
        __props__.__dict__["endpoint_mode"] = endpoint_mode
        __props__.__dict__["endpoint_service_name"] = endpoint_service_name
        __props__.__dict__["firewall_id"] = firewall_id
        __props__.__dict__["global_rulestack"] = global_rulestack
        __props__.__dict__["link_id"] = link_id
        __props__.__dict__["link_status"] = link_status
        __props__.__dict__["multi_vpc"] = multi_vpc
        __props__.__dict__["name"] = name
        __props__.__dict__["rulestack"] = rulestack
        __props__.__dict__["statuses"] = statuses
        __props__.__dict__["subnet_mappings"] = subnet_mappings
        __props__.__dict__["tags"] = tags
        __props__.__dict__["update_token"] = update_token
        __props__.__dict__["vpc_id"] = vpc_id
        return Ngfw(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The account ID. This field is mandatory if using multiple accounts.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter(name="appIdVersion")
    def app_id_version(self) -> pulumi.Output[_builtins.str]:
        """
        App-ID version number.
        """
        return pulumi.get(self, "app_id_version")

    @_builtins.property
    @pulumi.getter(name="automaticUpgradeAppIdVersion")
    def automatic_upgrade_app_id_version(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Automatic App-ID upgrade version number. Defaults to `true`.
        """
        return pulumi.get(self, "automatic_upgrade_app_id_version")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="endpointMode")
    def endpoint_mode(self) -> pulumi.Output[_builtins.str]:
        """
        Set endpoint mode from the following options. Valid values are `ServiceManaged` or `CustomerManaged`.
        """
        return pulumi.get(self, "endpoint_mode")

    @_builtins.property
    @pulumi.getter(name="endpointServiceName")
    def endpoint_service_name(self) -> pulumi.Output[_builtins.str]:
        """
        The endpoint service name.
        """
        return pulumi.get(self, "endpoint_service_name")

    @_builtins.property
    @pulumi.getter(name="firewallId")
    def firewall_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Id of the NGFW.
        """
        return pulumi.get(self, "firewall_id")

    @_builtins.property
    @pulumi.getter(name="globalRulestack")
    def global_rulestack(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The global rulestack for this NGFW.
        """
        return pulumi.get(self, "global_rulestack")

    @_builtins.property
    @pulumi.getter(name="linkId")
    def link_id(self) -> pulumi.Output[_builtins.str]:
        """
        A unique identifier for establishing and managing the link between the Cloud NGFW and other AWS resources.
        """
        return pulumi.get(self, "link_id")

    @_builtins.property
    @pulumi.getter(name="linkStatus")
    def link_status(self) -> pulumi.Output[_builtins.str]:
        """
        The link status.
        """
        return pulumi.get(self, "link_status")

    @_builtins.property
    @pulumi.getter(name="multiVpc")
    def multi_vpc(self) -> pulumi.Output[_builtins.bool]:
        """
        Share NGFW with Multiple VPCs. This feature can be enabled only if the endpoint_mode is CustomerManaged.
        """
        return pulumi.get(self, "multi_vpc")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The NGFW name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def rulestack(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The rulestack for this NGFW.
        """
        return pulumi.get(self, "rulestack")

    @_builtins.property
    @pulumi.getter
    def statuses(self) -> pulumi.Output[Sequence['outputs.NgfwStatus']]:
        return pulumi.get(self, "statuses")

    @_builtins.property
    @pulumi.getter(name="subnetMappings")
    def subnet_mappings(self) -> pulumi.Output[Sequence['outputs.NgfwSubnetMapping']]:
        """
        Subnet mappings.
        """
        return pulumi.get(self, "subnet_mappings")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        The tags.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="updateToken")
    def update_token(self) -> pulumi.Output[_builtins.str]:
        """
        The update token.
        """
        return pulumi.get(self, "update_token")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[_builtins.str]:
        """
        The vpc id.
        """
        return pulumi.get(self, "vpc_id")

