# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .client_facing_resource import ClientFacingResource
from .source_auth_type import SourceAuthType


class ClientFacingProviderDetailed(UniversalBaseModel):
    name: str = pydantic.Field()
    """
    Name of source of information
    """

    slug: str = pydantic.Field()
    """
    Slug for designated source
    """

    description: str = pydantic.Field()
    """
    Description of source of information
    """

    logo: typing.Optional[str] = pydantic.Field(default=None)
    """
    URL for source logo
    """

    auth_type: typing.Optional[SourceAuthType] = None
    supported_resources: typing.Optional[typing.List[ClientFacingResource]] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
