# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .ethnicity import Ethnicity
from .gender import Gender
from .gender_identity import GenderIdentity
from .guarantor_details import GuarantorDetails
from .race import Race
from .sexual_orientation import SexualOrientation


class PatientDetailsWithValidation(UniversalBaseModel):
    """
    Patient details with validation for first_name, last_name, email, and dob.
    """

    first_name: str
    last_name: str
    dob: str
    gender: Gender
    phone_number: str
    email: str
    medical_proxy: typing.Optional[GuarantorDetails] = pydantic.Field(default=None)
    """
    Parent/medical_proxy details. Required if patient is a minor.
    """

    race: typing.Optional[Race] = pydantic.Field(default=None)
    """
    If not provided, will be set to 'Not Specified'
    """

    ethnicity: typing.Optional[Ethnicity] = pydantic.Field(default=None)
    """
    If not provided, will be set to 'Not Specified'
    """

    sexual_orientation: typing.Optional[SexualOrientation] = pydantic.Field(default=None)
    """
    If not provided, will be set to 'Not Specified'
    """

    gender_identity: typing.Optional[GenderIdentity] = pydantic.Field(default=None)
    """
    If not provided, will be set to 'Not Specified'
    """

    household_income: typing.Optional[int] = pydantic.Field(default=None)
    """
    Household income in USD. If not provided, will be set to None
    """

    household_size: typing.Optional[int] = pydantic.Field(default=None)
    """
    Household size. If not provided, will be set to None
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
