from setuptools import setup, find_packages

with open("README.md", "r", encoding="utf-8") as fh:
    long_description = fh.read()

with open("requirements.txt", "r", encoding="utf-8") as fh:
    requirements = [line.strip() for line in fh if line.strip() and not line.startswith("#")]

setup(
    name="lark-ld",
    version="1.0.0",
    author="Farshore AI",
    author_email="3306065226@qq.com",
    description="A byte-level language detection model supporting 102 languages",
    long_description=long_description,
    long_description_content_type="text/markdown",
    url="https://github.com/farshore-byte/LarkDetect.git",
    packages=find_packages(),
    classifiers=[
        "Development Status :: 4 - Beta",
        "Intended Audience :: Developers",
        "Intended Audience :: Science/Research",
        "License :: OSI Approved :: MIT License",
        "Operating System :: OS Independent",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.8",
        "Programming Language :: Python :: 3.9",
        "Programming Language :: Python :: 3.10",
        "Programming Language :: Python :: 3.11",
        "Topic :: Scientific/Engineering :: Artificial Intelligence",
        "Topic :: Text Processing :: Linguistic",
    ],
    python_requires=">=3.8",
    install_requires=requirements,
    include_package_data=True,
    package_data={
        "lark": ["*.json"],
    },
    entry_points={
        "console_scripts": [
            "lark-detect=lark.cli:main",
        ],
    },
    keywords="language-detection, nlp, machine-learning, deep-learning",
)
