# localization

# region common
l_on = {
    'ru': "вкл",
    'en': "on",
    'es': "en",
    'fr': "en",
    'zh': "包括",
    'ar': "بما في ذلك",
}
l_off = {
    'ru': "выкл",
    'en': "off",
    'es': "de",
    'fr': "de",
    'zh': "离开",
    'ar': "عن",
}
l_yes = {
    'ru': "да",
    'en': "yes",
    'es': "sí",
    'fr': "oui",
    'zh': "是的",
    'ar': "نعم",
}
l_no = {
    'ru': "нет",
    'en': "no",
    'es': "no",
    'fr': "non",
    'zh': "不",
    'ar': "لا",
}
l_yes_percent = {
    'ru': "👩🏽‍💻 Да, 100%",
    'en': "👩🏽‍💻 Yes, 100%",
    'es': "👩🏽‍💻 Sí, 100%",
    'fr': "👩🏽‍💻 Oui, 100%",
    'zh': "👩🏽‍💻 是的，100%",
    'ar': "👩🏽‍💻 نعم ، 100٪",
}
l_no_percent = {
    'ru': "👩🏽‍💻 Нет, 0%",
    'en': "👩🏽‍💻 No, 0%",
    'es': "👩🏽‍💻 No, 0%",
    'fr': "👩🏽‍💻 Non, 0%",
    'zh': "👩🏽‍💻 没有，0%",
    'ar': "👩🏽‍💻 لا ، 0٪",
}
l_creturn_text = {
    'ru': "✖️ <b>Сбросить</b> настройки по умолчанию (до рекомендуемых) для [<b>{0}</b>]?",
    'en': "✖️ <b>Reset</b> default settings (to recommended) for [<b>{0}</b>]?",
    'es': "✖️ ¿ <b>Restablecer</b> la configuración predeterminada (a la recomendada) para [<b>{0}</b>]?",
    'fr': "✖️ <b>Réinitialiser</b> les paramètres par défaut (sur recommandé) pour [<b>{0}</b>] ?",
    'zh': "✖️<b>重置</b>[<b>{0}</b>] 的默认设置（推荐）？",
    'ar': "✖️ <b>إعادة تعيين</b> الإعدادات الافتراضية (إلى الموصى به) لـ [<b>{0}</b>]؟",
}
l_all_ans = {
    'ru': "все",
    'en': "all",
    'es': "todo",
    'fr': "tous",
    'zh': "全部",
    'ar': "الجميع",
}
l_menu = {
    'ru': "🔙 Меню",
    'en': "🔙 Menu",
    'es': "🔙 Menú",
    'fr': "🔙 Menu",
    'zh': "🔙 菜单",
    'ar': "🔙 القائمة",
}
l_back = {
    'ru': "🔙 Назад",
    'en': "🔙 Back",
    'es': "🔙 Atrás",
    'fr': "🔙 Retour",
    'zh': "🔙 返回",
    'ar': "🔙 رجوع",
}
l_forever = {
    'ru': "навсегда",
    'en': "forever",
    'es': "para siempre",
    'fr': "pour toujours",
    'zh': "永远",
    'ar': "للأبد",
}
l_members = {
    'ru': "участ.",
    'en': "participation.",
    'es': "participación.",
    'fr': "participation.",
    'zh': "参与。",
    'ar': "مشاركة.",
}
l_add = {
    'ru': "✅ Добавить",
    'en': "✅ Add",
    'es': "✅ Agregar",
    'fr': "✅ Ajouter",
    'zh': "✅ 添加",
    'ar': "✅ أضف",
}
l_remove = {
    'ru': "🚫 Удалить",
    'en': "🚫 Delete",
    'es': "🚫 Eliminar",
    'fr': "🚫 Supprimer",
    'zh': "🚫 删除",
    'ar': "🚫 حذف",
}
l_try_again = {
    'ru': "👩🏽‍💻 <b>Попробуйте</b> позже",
    'en': "👩🏽‍💻 Try again later",
    'es': "🚫 Eliminar",
    'fr': "🚫 Supprimer",
    'zh': "🚫 删除",
    'ar': "🚫 حذف",
}
l_please_subscribe = {
    'ru': "👩🏽‍💻 Оформи ежемесячную подписку",
    'en': "🔔 You need to ⚙️Customize at least one post",
    'es': "🔔 Necesitas ⚙️Personalizar al menos una publicación",
    'fr': "🔔 Vous devez ⚙️Personnaliser au moins une publication",
    'zh': "🔔 你需要⚙️自定义至少一个帖子",
    'ar': "🔔 أنت بحاجة إلى تخصيص منشور واحد على الأقل",
}
l_please_subscribe_need = {
    'ru': "👩🏽‍💻 <b>Необходимо</b> оформить подписку!",
    'en': "🔔 You need to ⚙️Customize at least one post",
    'es': "🔔 Necesitas ⚙️Personalizar al menos una publicación",
    'fr': "🔔 Vous devez ⚙️Personnaliser au moins une publication",
    'zh': "🔔 你需要⚙️自定义至少一个帖子",
    'ar': "🔔 أنت بحاجة إلى تخصيص منشور واحد على الأقل",
}
l_subscribe_spoiler = {
    'ru': "оформи подписку",
    'en': "оформи подписку",
    'es': "🔔 Necesitas ⚙️Personalizar al menos una publicación",
    'fr': "🔔 Vous devez ⚙️Personnaliser au moins une publication",
    'zh': "🔔 你需要⚙️自定义至少一个帖子",
    'ar': "🔔 أنت بحاجة إلى تخصيص منشور واحد على الأقل",
}
l_subscribe_channel_for_post = {
    'ru': "👩🏽‍💻 <b>Подпишись</b> на @{0}, чтобы снять ограничения",
    'en': "🔔 You need to ⚙️Customize at least one post",
    'es': "🔔 Necesitas ⚙️Personalizar al menos una publicación",
    'fr': "🔔 Vous devez ⚙️Personnaliser au moins une publication",
    'zh': "🔔 你需要⚙️自定义至少一个帖子",
    'ar': "🔔 أنت بحاجة إلى تخصيص منشور واحد على الأقل",
}

l_choose_direction = {
    'ru': "👇🏽 <b>Выбери</b> направление",
    'en': "👇🏽 <b>Choose</b> a direction",
    'es': "👇🏽 <b>Elige</b> una dirección",
    'fr': "👇🏽 <b>Choisissez</b> une direction",
    'zh': "👇🏽<b>选择</b>方向",
    'ar': "👇🏽 <b>اختر</b> الاتجاه",
}
l_about = {
    'ru': "<b>👩🏽‍💻 Ferey проекты</b>:\n\n▪️проекты: @FereyDemoBot\n▪️конструктор: @FereyBotBot\n▪️приватные посты: @FereyPostBot\n▪️публичные медиа: @FereyMediaBot\n▪️администрирование: @FereyChannelBot\n▪️модерация: @FereyGroupBot\n▪️поиск: @FereyFindBot\n▪️таргет: @FereyTargetBot\n▪️инструменты: @FereyToolsBot\n▪️vpn: @FereyVPNBot\n▪️ai: @FereyAIBot\n▪️автоматизация: @FereyUserBot\n▪️вакансии: @FereyWorkBot\n▪️реклама: @FereyAdsBot",
    'en': "<b>👩🏽‍💻 Ferey projects</b>:\n\n▪️projects: @FereyDemoBot\n▪️constructor: @FereyBotBot\n▪️private_posts: @FereyPostBot\n▪️public_media: @FereyMediaBot\n▪️administration: @FereyChannelBot\n▪️moderation: @FereyGroupBot\n▪️search: @FereyFindBot\n▪️target: @FereyTargetBot\n▪️tools: @FereyToolsBot\n▪️vpn: @FereyVPNBot\n▪️ai: @FereyAIBot\n▪️automation: @FereyUserBot\n▪️vacancies: @FereyWorkBot\n▪️advert: @FereyAdsBot",
    'es': "<b>👩🏽‍💻 Proyectos de Ferey</b> :\n\n▪️proyectos: @FereyDemoBot\n▪️constructor: @FereyBotBot\n▪️publicaciones_privadas: @FereyPostBot\n▪️medios_públicos: @FereyMediaBot\n▪️administración: @FereyChannelBot\n▪️moderación: @FereyGroupBot\nƒ️búsqueda: @FereyFindBot\nƒ️objetivo: @FereyTargetBot\nƒ️herramientas: @FereyToolsBot\nƒ️vpn: @FereyVPNBot\nƒ️ai: @FereyAIBot\nƒ️automatización: @FereyUserBot\nƒ️vacantes: @FereyWorkBot\n▪️anuncio: @FereyAdsBot",
    'fr': "<b>👩🏽‍💻 Projets Ferey</b> :\n\n▪️projets : @FereyDemoBot\n▪️constructeur : @FereyBotBot\n▪️public_medias : @FereyPostBot\n▪️public_media : @FereyMediaBot\n▪️administration : @FereyChannelBot\n▪️modération : @FereyGroupBot\n▪️recherche : @FereyFindBot\n▪️cible : @FereyTargetBot\n▪️outils : @FereyToolsBot\n▪️vpn : @FereyVPNBot\n▪️ai : @FereyAIBot\n▪️automatisation : @FereyUserBot\n▪️postes vacants : @FereyWorkBot\n▪️annonce : @FereyAdsBot",
    'zh': "<b>👩🏽‍💻 Ferey 项目</b>：\n\n▪️projects： @FereyDemoBot\n▪️constructor： @FereyBotBot\n▪️private_posts： @FereyPostBot\n▪️public_media： @FereyMediaBot\n▪️administration： @FereyChannelBot\n▪️moderation： @FereyGroupBot\n▪️搜索： @FereyFindBot\n▪️目标： @FereyTargetBot\n▪️工具： @FereyToolsBot\n▪️vpn： @FereyVPNBot\n▪️ai： @FereyAIBot\n▪️自动化： @FereyUserBot\n▪️空缺： @FereyWorkBot\n▪️广告： @FereyAdsBot",
    'ar': "<b>👩🏽‍💻 المشاريع السريعة</b> :\n\n▪️ المشاريع: @FereyDemoBot\n▪️ المُنشئ: @FereyBotBot\n▪️private_posts: @FereyPostBot\n▪️public_media: @FereyMediaBot\n▪️administration: @FereyChannelBot : @ @FereyGroupBot\n▪️search: @FereyFindBot\n▪️ الهدف: @FereyTargetBot\n▪️ الأدوات: @FereyToolsBot\n▪️vpn: @FereyVPNBot\n▪️ai: @FereyAIBot\n▪️automation: @FereyUserBot @FereyWorkBot\nإعلان: @FereyAdsBot",
}
l_subscribe_btn = {
    'ru': "👩🏽‍💻 Я подписался",
    'en': "👩🏽‍💻 I subscribed",
    'es': "👩🏽‍💻 Me suscribí",
    'fr': "👩🏽‍💻 je me suis abonné",
    'zh': "👩🏽‍💻 我订阅了",
    'ar': "👩🏽‍💻 لقد اشتركت",
}
l_subscribe_all = {
    'ru': "¹ Все боты и проекты",
    'en': "¹ Все боты и проекты",
    'es': "¹ All bots & projects",
    'fr': "¹ All bots & projects",
    'zh': "¹ All bots & projects",
    'ar': "¹ All bots & projects",
}
l_subscribe_already = {
    'ru': "👩🏽‍💻 У вас уже есть активная подписка",
    'en': "¹ All bots & projects",
    'es': "¹ All bots & projects",
    'fr': "¹ All bots & projects",
    'zh': "¹ All bots & projects",
    'ar': "¹ All bots & projects",
}
l_subscribe_wait = {
    'ru': "👩🏽‍💻 Обработка @donate..\n\n#длительность 1мин",
    'en': "¹ All bots & projects",
    'es': "¹ All bots & projects",
    'fr': "¹ All bots & projects",
    'zh': "¹ All bots & projects",
    'ar': "¹ All bots & projects",
}
l_subscribe_success = {
    'ru': "👩🏽‍💻 <b>Успешный</b> донат!",
    'en': "👩🏽‍💻 Успешный донат!",
    'es': "¹ All bots & projects",
    'fr': "¹ All bots & projects",
    'zh': "¹ All bots & projects",
    'ar': "¹ All bots & projects",
}
l_subscribe_balance = {
    'ru': "👩🏽‍💻 Текущий /balance {0}{1}",
    'en': "👩🏽‍💻 Current /balance {0}{1}",
    'es': "¹ All bots & projects",
    'fr': "¹ All bots & projects",
    'zh': "¹ All bots & projects",
    'ar': "¹ All bots & projects",
}
l_subscribe_deposit = {
    'ru': "² Донат на баланс",
    'en': "² Donate to balance",
    'es': "👩🏽‍💻 <b>Regístrese para obtener</b> una\n\n¹ <i>suscripción</i> mensual a @{0}-bot [{1} ₽]\n▪️ sin anuncios\n▪️ tareas creativas\n² Suscríbase a <u>todos</u> los bots [{2} ₽]",
    'fr': "👩🏽‍💻 <b>Inscrivez-vous pour</b> un <i>abonnement</i>\n\n¹ mensuel à @{0}-bot [{1} ₽]\n▪️ pas de publicité\n▪️ tâches créatives\n² Abonnez-vous à <u>tous</u> les bots [{2} ₽]",
    'zh': "👩🏽‍💻<b>注册</b>每月\n\n¹<i>订阅</i>@{0}-bot [{1} ₽]\n▪️ 无广告\n▪️ 创意任务\n² 订阅<u>所有</u>机器人 [{2} ₽]",
    'ar': "👩🏽‍💻 <b>اشترك للحصول على</b> <i>اشتراك</i> شهري\n\n¹ في @ {0} -bot [{1} ₽]\n▪️ بلا إعلانات\n▪️ مهام إبداعية\n² اشترك في <u>جميع</u> برامج التتبُّع [{2} ₽]",
}

l_language_get = {
    'ru': "🌏 <b>Выбери</b> один из доступных языков",
    'en': "🌏 <b>Choose</b> one of the available languages",
    'es': "🌏 <b>Elige</b> uno de los idiomas disponibles",
    'fr': "🌏 <b>Choisissez</b> l'une des langues disponibles",
    'zh': "🌏<b>选择</b>一种可用的语言",
    'ar': "🌏 <b>اختر</b> إحدى اللغات المتاحة",
}
l_language_set = {
    'ru': "{0} Текущий язык: {1}",
    'en': "{0} Current language: {1}",
    'es': "{0} Idioma actual: {1}",
    'fr': "{0} Langue actuelle : {1}",
    'zh': "{0} 当前语言：{1}",
    'ar': "{0} اللغة الحالية: {1}",
}
l_ferey_like = {
    'ru': "💔 Like",
    'en': "💔 Like",
    'es': "💔 Me gusta",
    'fr': "💔 J'aime",
    'zh': "💔 喜欢",
    'ar': "💔 مثل",
}
# endregion


# region post
l_post_text = {
    'ru': "✏️ 1. <b>Введи текст</b> для нового поста (не забудь использовать <i>форматирование</i>)\n\n(<i>или нажми «➡️️/Next», чтобы пропустить этот шаг</i>)",
    'en': "✏️ 1. <b>Enter the text</b> for the new post (don&#x27;t forget to use <i>formatting</i> )\n\n( <i>or press &quot;➡️️/Next&quot; to skip this step</i> )",
    'es': "✏️ 1. <b>Ingresa el texto</b> de la nueva publicación (no olvides usar <i>el formato</i> )\n\n( <i>o presiona &quot;➡️️/Siguiente&quot; para omitir este paso</i> )",
    'fr': "✏️ 1. <b>Saisissez le texte</b> du nouveau message (n&#x27;oubliez pas d&#x27;utiliser <i>le formatage</i> )\n\n( <i>ou appuyez sur &quot;➡️️/Suivant&quot; pour ignorer cette étape</i> )",
    'zh': "✏️ 1.<b>输入新帖子的文本</b>（不要忘记使用<i>格式</i>）\n\n（<i>或按“➡️️/下一步”跳过此步骤</i>）",
    'ar': "✏️ 1. <b>أدخل نص</b> المنشور الجديد (لا تنس استخدام <i>التنسيق</i> )\n\n( <i>أو اضغط على &quot;➡️️ / التالي&quot; لتخطي هذه الخطوة</i> )",
}
l_post_text_limit = {
    'ru': "❗️ <b>Количество символов</b> текста (<i>включая форматирование</i>): <u>{0}</u> больше допустимых 1024",
    'en': "❗️ <b>Number of characters</b> of text ( <i>including formatting</i> ): <u>{0}</u> more than allowed 1024",
    'es': "❗️ <b>Número de caracteres</b> de texto ( <i>incluido el formato</i> ): <u>{0}</u> más de los permitidos 1024",
    'fr': "❗️ <b>Nombre de caractères</b> de texte ( <i>y compris le formatage</i> ) : <u>{0}</u> plus que autorisé 1024",
    'zh': "❗️ 文本<b>字符数</b>（<i>包括格式</i>）： <u>{0}</u>超过允许的 1024",
    'ar': "❗️ <b>عدد أحرف</b> النص ( <i>بما في ذلك التنسيق</i> ): <u>{0}</u> أكثر من العدد المسموح به وهو 1024",
}
l_post_text_empty = {
    'ru': "❗️ Пост пустой, попробуй сначала\n\n{0}",
    'en': "❗️ Post is empty, try again\n\n{0}",
    'es': "❗️ La publicación está vacía, inténtalo de nuevo\n\n{0}",
    'fr': "❗️ La publication est vide, réessayez\n\n{0}",
    'zh': "❗️ 帖子为空，请重试\n\n{0}",
    'ar': "❗️ النشر فارغ ، حاول مرة أخرى\n\n{0}",
}
l_post_edit = {
    'ru': "✏️ 1. <b>Введи измененный текст</b> для текущего поста\n\n(<i>или нажми «➡️️/Next», чтобы пропустить этот шаг</i>)",
    'en': "✏️ 1. <b>Enter the modified text</b> for the current post\n\n( <i>or press &quot;➡️️/Next&quot; to skip this step</i> )",
    'es': "✏️ 1. <b>Ingresa el texto modificado</b> para la publicación actual\n\n( <i>o presiona &quot;➡️️/Siguiente&quot; para omitir este paso</i> )",
    'fr': "✏️ 1. <b>Entrez le texte modifié</b> pour le message actuel\n\n( <i>ou appuyez sur &quot;➡️️/Suivant&quot; pour ignorer cette étape</i> )",
    'zh': "✏️ 1.<b>输入当前帖子的修改文本</b>\n\n（<i>或按“➡️️/Next”跳过此步骤</i>）",
    'ar': "✏️ 1. <b>أدخل النص المعدل</b> للنشر الحالي\n\n( <i>أو اضغط على &quot;➡️️ / التالي&quot; لتخطي هذه الخطوة</i> )",
}
l_post_media = {
    'ru': "✏️ 2. <b>Прикрепи медиа</b> контент: фото/гиф/видео/аудио/документ/стикер или запиши голосовое/видео-заметку в кружке\n\n(<i>или нажми «➡️️/Next», чтобы пропустить этот шаг</i>)",
    'en': "✏️ 2. <b>Attach media</b> content: photo/gif/video/audio/document/sticker or write a voice/video note in a circle\n\n( <i>or press &quot;➡️️/Next&quot; to skip this step</i> )",
    'es': "✏️ 2. <b>Adjunte contenido multimedia</b> : foto/gif/video/audio/documento/pegatina o escriba una nota de voz/video en un círculo\n\n( <i>o presione &quot;➡️️/Siguiente&quot; para omitir este paso</i> )",
    'fr': "✏️ 2. <b>Joignez du contenu multimédia</b> : photo/gif/vidéo/audio/document/autocollant ou écrivez une note vocale/vidéo dans un cercle\n\n( <i>ou appuyez sur &quot;➡️️/Suivant&quot; pour ignorer cette étape</i> )",
    'zh': "✏️ 2.<b>附上媒体</b>内容：照片/gif/视频/音频/文档/贴纸或在圈内写语音/视频备注\n\n（<i>或按“➡️️/下一步”跳过此步骤</i>）",
    'ar': "✏️ 2. <b>أرفق محتوى وسائط</b> : صورة / gif / فيديو / صوت / مستند / ملصق أو اكتب ملاحظة صوتية / فيديو في دائرة\n\n( <i>أو اضغط على &quot;➡️️ / التالي&quot; لتخطي هذه الخطوة</i> )",
}
l_post_media_wait = {
    'ru': "👩🏽‍💻 <b>Обработка</b> {0}..\n#длительность {1}мин",
    'en': "👩🏽‍💻 <b>Processing</b> {0}..\n#duration {1}min",
    'es': "👩🏽‍💻 <b>Procesando</b> {0}..\n#duración {1}min",
    'fr': "👩🏽‍💻 <b>Traitement</b> {0}..\n#durée {1}min",
    'zh': "👩🏽‍💻<b>处理</b>{0}..\n#duration {1}min",
    'ar': "👩🏽‍💻 <b>المعالجة</b> {0} ..\n# مدة {1} دقيقة",
}
l_post_media_toobig = {
    'ru': "👩🏽‍💻 Файл больше 20 Мб, загрузи меньший обьем",
    'en': "👩🏽‍💻 The file is larger than 20 MB, please upload a smaller size",
    'es': "👩🏽‍💻 El archivo tiene más de 20 MB, cargue un tamaño más pequeño",
    'fr': "👩🏽‍💻 Le fichier fait plus de 20 Mo, veuillez télécharger une taille plus petite",
    'zh': "👩🏽‍💻文件大于20MB，请上传较小的文件",
    'ar': "👩🏽‍💻 الملف أكبر من 20 ميغا بايت ، يرجى تحميل حجم أصغر",
}
l_post_tgph = {
    'ru': "✏️ *2. Использовать загруженный <b>media</b>-контент в виде <u>предпросмотра</u> внизу поста (работает только с <i>jpg|png|gif|mp4</i>-файлами до 5Mb)?\n\n(<i>или нажми «➡️️/Next», чтобы пропустить этот шаг</i>)",
    'en': "✏️ *2. Use uploaded <b>media</b> content as <u>a preview</u> at the bottom of the post (only works with <i>jpg|png|gif|mp4</i> files up to 5Mb)?\n\n( <i>or press &quot;➡️️/Next&quot; to skip this step</i> )",
    'es': "✏️ *2. ¿Usar el contenido <b>multimedia</b> cargado como <u>una vista previa</u> en la parte inferior de la publicación (solo funciona con archivos <i>jpg|png|gif|mp4</i> de hasta 5 Mb)?\n\n( <i>o presione &quot;➡️️/Siguiente&quot; para omitir este paso</i> )",
    'fr': "✏️ *2. Utiliser le contenu <b>multimédia</b> téléchargé comme <u>aperçu</u> au bas de la publication (fonctionne uniquement avec les fichiers <i>jpg|png|gif|mp4</i> jusqu&#x27;à 5 Mo) ?\n\n( <i>ou appuyez sur &quot;➡️️/Suivant&quot; pour ignorer cette étape</i> )",
    'zh': "✏️ *2。使用上传的<b>媒体</b>内容作为帖子底部的<u>预览</u>（仅适用于最大 5Mb 的<i>jpg|png|gif|mp4</i>文件）？\n\n（<i>或按“➡️️/下一步”跳过此步骤</i>）",
    'ar': "✏️ * 2. استخدم محتوى <b>الوسائط</b> الذي تم تحميله <u>كمعاينة</u> أسفل المنشور (يعمل فقط مع ملفات <i>jpg | png | gif | mp4</i> حتى 5 ميغا بايت)؟\n\n( <i>أو اضغط على &quot;➡️️ / التالي&quot; لتخطي هذه الخطوة</i> )",
}
l_post_tgph_yes = {
    'ru': "✅ Да",
    'en': "✅ Yes",
    'es': "✅ Sí",
    'fr': "✅ Oui",
    'zh': "✅ 是的",
    'ar': "✅ نعم",
}
l_post_tgph_no = {
    'ru': "☑️ Нет",
    'en': "☑️ No",
    'es': "☑️No",
    'fr': "☑️ Non",
    'zh': "☑️没有",
    'ar': "☑️ لا",
}
l_post_button = {
    'ru': "✏️ 3. <b>Введи названия</b> для кнопок и <b>ссылки</b> в формате (одну или несколько; кликни на образец ниже, чтобы скопировать):\n\n<code>[🐳 Link | https://t.me/XXXXX]\n\n[❤️ Like][💔 Foo]</code>\n\n(<i>или нажми «➡️️/Next», чтобы пропустить этот шаг</i>)",
    'en': "✏️ 3. <b>Enter button names</b> and <b>links</b> in the format (one or more; click on the sample below to copy):\n\n[🐳 Link | https://t.me/XXXXX]\n\nor\n\n[❤️ Интересно][💔 Не пиши]\n\n( <i>or press &quot;➡️️/Next&quot; to skip this step</i> )",
    'es': "✏️ 3. <b>Ingrese los nombres de los botones</b> y <b>los enlaces</b> en el formato (uno o más; haga clic en la muestra a continuación para copiar):\n\n[🐳 Link | https://t.me/XXXXX]\n\ni\n\n[❤️ Интересно][💔 Не пиши]\n\n( <i>o presiona &quot;➡️️/Siguiente&quot; para omitir este paso</i> )",
    'fr': "✏️ 3. <b>Saisissez les noms des boutons</b> et <b>les liens</b> au format (un ou plusieurs ; cliquez sur l&#x27;exemple ci-dessous pour le copier) :\n\n[🐳 Link | https://t.me/XXXXX]\n\nor\n\n[❤️ Интересно][💔 Не пиши]\n\n( <i>ou appuyez sur &quot;➡️️/Suivant&quot; pour ignorer cette étape</i> )",
    'zh': "✏️ 3.<b>输入按钮名称</b>和<b>链接</b>格式（一个或多个；点击下方示例复制）：\n\n[🐳 Link | https://t.me/XXXXX]\n\nor\n\n[❤️ Интересно][💔 Не пиши]\n\n（<i>或按“➡️️/Next”跳过这一步</i>）",
    'ar': "✏️ 3. <b>أدخل أسماء الأزرار</b> <b>والارتباطات</b> بالتنسيق (واحد أو أكثر ؛ انقر على النموذج أدناه لنسخه):\n\n[🐳 Link | https://t.me/XXXXX]\n\ ولا\n\n[❤️ Интересно][💔 Не пиши]\n\n( <i>أو اضغط على &quot;➡️️ / التالي&quot; لتخطي هذه الخطوة</i> )",
}
l_post_button_urlinvalid = {
    'ru': "🔗 Ссылка {0} не действительна",
    'en': "🔗 Link {0} is invalid",
    'es': "🔗 El enlace {0} no es válido",
    'fr': "🔗 Le lien {0} est invalide",
    'zh': "🔗 链接 {0} 无效",
    'ar': "🔗 الرابط {0} غير صالح",
}
l_post_pin = {
    'ru': "✏️ 3. Закреплять (<b>pin</b>) сообщение сверху экрана: да | нет?\n\n(<i>или нажми «➡️️/Next», чтобы <u>не закреплять</u> сообщение</i>)",
    'en': "✏️ 3. Pin ( <b>pin</b> ) the message on top of the screen: да | нет ?\n\n( <i>or press &quot;➡️️/Next&quot; to <u>not pin</u> the message</i> )",
    'es': "✏️ 3. Pin ( <b>pin</b> ) el mensaje en la parte superior de la pantalla: да | нет ?\n\n( <i>o presione &quot;➡️️/Siguiente&quot; para <u>no fijar</u> el mensaje</i> )",
    'fr': "✏️ 3. Epingler ( <b>épingler</b> ) le message en haut de l&#x27;écran : да | нет ?\n\n( <i>ou appuyez sur &quot;➡️️/Suivant&quot; pour <u>ne pas épingler</u> le message</i> )",
    'zh': "✏️ 3. 将消息置顶（<b>置顶</b>）： да | нет ？\n\n（<i>或按“➡️️/下一步”<u>不固定</u>消息</i>）",
    'ar': "✏️ 3. قم بتثبيت ( <b>تثبيت</b> ) الرسالة أعلى الشاشة: да | нет ؟\n\n( <i>أو اضغط على &quot;➡️️ / التالي&quot; لعدم <u>تثبيت</u> الرسالة</i> )",
}
l_post_date = {
    'ru': "✏️ 4. <b>Выбери дату</b> на календаре\n\n(<i>или нажми «➡️️/Next», чтобы пропустить этот шаг</i>)",
    'en': "✏️ 4. <b>Select a date</b> on the calendar\n\n( <i>or press &quot;➡️️/Next&quot; to skip this step</i> )",
    'es': "✏️ 4. <b>Selecciona una fecha</b> en el calendario\n\n( <i>o presiona &quot;➡️️/Siguiente&quot; para omitir este paso</i> )",
    'fr': "✏️ 4. <b>Sélectionnez une date</b> sur le calendrier\n\n( <i>ou appuyez sur &quot;➡️️/Suivant&quot; pour ignorer cette étape</i> )",
    'zh': "✏️ 4. 在日历上<b>选择一个日期</b>\n\n（<i>或按“➡️️/Next”跳过此步骤</i>）",
    'ar': "✏️ 4. <b>حدد تاريخًا</b> في التقويم\n\n( <i>أو اضغط على &quot;➡️️ / التالي&quot; لتخطي هذه الخطوة</i> )",
}
l_post_window = {
    'ru': "✏️ *<b>Введи</b> текст (без форматирования) для <i>диалогового окна</i> при нажатии на <u>кнопки</u> <b>поста</b> (по умолчанию: ❤️)\n\n(<i>или нажми «➡️️/Next», чтобы пропустить этот шаг</i>)",
    'en': "✅ <b>Post is ready</b>\n\n<i>Press &quot;➡️️/Next&quot; to confirm, and then press the button 🔗 Publish</i>",
    'es': "✅ <b>La publicación está lista</b>\n\n<i>Presiona &quot;➡️️/Siguiente&quot; para confirmar y luego presiona el botón 🔗 Publicar</i>",
    'fr': "✅ <b>La publication est prête</b>\n\n<i>Appuyez sur &quot;➡️️/Suivant&quot; pour confirmer, puis appuyez sur le bouton 🔗 Publier</i>",
    'zh': "✅<b>发布准备就绪</b>\n\n<i>按“➡️️/Next”确认，然后按按钮🔗发布</i>",
    'ar': "✅ <b>النشر جاهز</b>\n\n<i>اضغط على &quot;➡️️ / التالي&quot; للتأكيد ، ثم اضغط على الزر 🔗 نشر</i>",
}
l_post_window_limit = {
    'ru': "❗️ <b>Количество символов</b> диалогового окна: <u>{0}</u> больше допустимых 200",
    'en': "❗️ <b>Number of characters</b> of text ( <i>including formatting</i> ): <u>{0}</u> more than allowed 1024",
    'es': "❗️ <b>Número de caracteres</b> de texto ( <i>incluido el formato</i> ): <u>{0}</u> más de los permitidos 1024",
    'fr': "❗️ <b>Nombre de caractères</b> de texte ( <i>y compris le formatage</i> ) : <u>{0}</u> plus que autorisé 1024",
    'zh': "❗️ 文本<b>字符数</b>（<i>包括格式</i>）： <u>{0}</u>超过允许的 1024",
    'ar': "❗️ <b>عدد أحرف</b> النص ( <i>بما في ذلك التنسيق</i> ): <u>{0}</u> أكثر من العدد المسموح به وهو 1024",
}
l_post_finish = {
    'ru': "✅ <b>Пост готов</b>\n\n<i>Нажми «➡️️/Next», чтобы подтвердить, а затем на кнопку 🔗 Опубликовать</i>",
    'en': "✅ <b>Post is ready</b>\n\n<i>Press &quot;➡️️/Next&quot; to confirm, and then press the button 🔗 Publish</i>",
    'es': "✅ <b>La publicación está lista</b>\n\n<i>Presiona &quot;➡️️/Siguiente&quot; para confirmar y luego presiona el botón 🔗 Publicar</i>",
    'fr': "✅ <b>La publication est prête</b>\n\n<i>Appuyez sur &quot;➡️️/Suivant&quot; pour confirmer, puis appuyez sur le bouton 🔗 Publier</i>",
    'zh': "✅<b>发布准备就绪</b>\n\n<i>按“➡️️/Next”确认，然后按按钮🔗发布</i>",
    'ar': "✅ <b>النشر جاهز</b>\n\n<i>اضغط على &quot;➡️️ / التالي&quot; للتأكيد ، ثم اضغط على الزر 🔗 نشر</i>",
}
l_switch_pm_text = {
    'ru': "🔗 Создать пост с кнопкой",
    'en': "🔗 Create post with button",
    'es': "🔗 Crear publicación con botón",
    'fr': "🔗 Créer un message avec le bouton",
    'zh': "🔗 使用按钮创建帖子",
    'ar': "🔗 إنشاء وظيفة مع زر",
}
l_post_new = {
    'ru': "⛰ Создать",
    'en': "⛰ Create",
    'es': "⛰ Crear",
    'fr': "⛰ Créer",
    'zh': "⛰ 创建",
    'ar': "⛰ خلق",
}
l_post_delete = {
    'ru': "🚫 Удалить",
    'en': "🚫 Delete",
    'es': "🚫 Eliminar",
    'fr': "🚫 Supprimer",
    'zh': "🚫 删除",
    'ar': "🚫 حذف",
}
l_post_change = {
    'ru': "♻️ Изменить",
    'en': "♻️ Change",
    'es': "♻️ Cambiar",
    'fr': "♻️ Changer",
    'zh': "♻️改变",
    'ar': "♻️ التغيير",
}
l_post_creation = {
    'ru': "<b>Дата создания</b>",
    'en': "<b>date of creation</b>",
    'es': "<b>fecha de creación</b>",
    'fr': "<b>date de création</b>",
    'zh': "<b>创建日期</b>",
    'ar': "<b>تاريخ الخلق</b>",
}

l_post_publish = {
    'ru': "🔗 Опубликовать",
    'en': "🔗 Post",
    'es': "🔗 Publicar",
    'fr': "🔗 Publier",
    'zh': "🔗 发布",
    'ar': "🔗 مشاركة",
}
l_post_pub = {
    'ru': "👩🏽‍💻 Пост опубликован",
    'en': "👩🏽‍💻 Post published",
    'es': "👩🏽‍💻 Publicación publicada",
    'fr': "👩🏽‍💻 Article publié",
    'zh': "👩🏽‍💻 帖子已发布",
    'ar': "👩🏽‍💻 تم نشر المنشور",
}
l_post_btn_answer = {
    'ru': "✅ Пользователь <b>{0}</b> (username={1}, id={2}) <i>нажал</i> на [<b>{3}</b>] в посте #<u>{4}</u>",
    'en': "✅ User <b>{0}</b> (username={1}, id= {2} ) <i>clicked</i> on [<b>{3}</b>] in post # <u>{4}</u>",
    'es': "✅ El usuario <b>{0}</b> (username={1}, id= {2} ) <i>hizo clic</i> en [<b>{3}</b>] en la publicación n.º <u>{4}</u>",
    'fr': "✅ L'utilisateur <b>{0}</b> (username={1}, id= {2} ) <i>a cliqué</i> sur [<b>{3}</b>] dans le post # <u>{4}</u>",
    'zh': "✅ 用户<b>{0}</b> （用户名 = {1}，id = {2} ）在帖子 # <u>{4}</u>中<i>点击了</i>[<b>{3}</b>]",
    'ar': "✅ المستخدم <b>{0}</b> (اسم المستخدم = {1} ، المعرف = {2} ) <i>نقر</i> على [<b>{3}</b>] في المشاركة رقم <u>{4}</u>",
}
l_post_datetime = {
    'ru': "<b>Дата публикации</b>",
    'en': "<b>Publication date</b>",
    'es': "<b>Fecha de publicación</b>",
    'fr': "<b>Date de publication</b>",
    'zh': "<b>发布日期</b>",
    'ar': "<b>تاريخ النشر</b>",
}
l_post_preview = {
    'ru': "<b>Превью</b>",
    'en': "<b>Preview</b>",
    'es': "<b>Avance</b>",
    'fr': "<b>Aperçu</b>",
    'zh': "<b>预览</b>",
    'ar': "<b>معاينة</b>",
}
l_post_buttons = {
    'ru': "<b>Кнопки</b>",
    'en': "<b>Buttons</b>",
    'es': "<b>Botones</b>",
    'fr': "<b>Boutons</b>",
    'zh': "<b>纽扣</b>",
    'ar': "<b>أزرار</b>",
}
l_post_pins = {
    'ru': "<b>Закреп</b>",
    'en': "<b>Fix</b>",
    'es': "<b>Arreglar</b>",
    'fr': "<b>Réparer</b>",
    'zh': "<b>使固定</b>",
    'ar': "<b>يصلح</b>",
}

l_btn = {
    'ru': "кнопки",
    'en': "buttons",
    'es': "botones",
    'fr': "boutons",
    'zh': "纽扣",
    'ar': "أزرار",
}
l_pin = {
    'ru': "закреп",
    'en': "fixed",
    'es': "fijado",
    'fr': "fixé",
    'zh': "固定的",
    'ar': "مُثَبَّت",
}
l_silence = {
    'ru': "тихо",
    'en': "quiet",
    'es': "tranquilo",
    'fr': "calme",
    'zh': "安静的",
    'ar': "هادئ",
}
l_gallery = {
    'ru': "галерея",
    'en': "gallery",
    'es': "galería",
    'fr': "galerie",
    'zh': "画廊",
    'ar': "صالة عرض",
}
l_preview = {
    'ru': "превью",
    'en': "preview",
    'es': "avance",
    'fr': "aperçu",
    'zh': "预览",
    'ar': "معاينة",
}
l_spoiler = {
    'ru': "спойлер",
    'en': "spoiler",
    'es': "revelación",
    'fr': "divulgacher",
    'zh': "剧透",
    'ar': "المفسد",
}
l_notice = {
    'ru': "нотис",
    'en': "notice",
    'es': "revelación",
    'fr': "divulgacher",
    'zh': "剧透",
    'ar': "المفسد",
}
l_window = {
    'ru': "окно",
    'en': "window",
    'es': "revelación",
    'fr': "divulgacher",
    'zh': "剧透",
    'ar': "المفسد",
}

l_buttons_text = {
    'ru': "👩🏽‍💻 Режим [кнопки] доступен, если создана хотя бы 1 кнопка при создании поста",
    'en': "👩🏽‍💻 [Buttons] mode is available if at least 1 button is created when creating a post",
    'es': "👩🏽‍💻 El modo [Botones] está disponible si se crea al menos 1 botón al crear una publicación",
    'fr': "👩🏽‍💻 Le mode [Boutons] est disponible si au moins 1 bouton est créé lors de la création d'une publication",
    'zh': "👩🏽‍💻 如果在创建帖子时至少创建了 1 个按钮，则可以使用 [按钮] 模式",
    'ar': "يكون وضع [الأزرار] متاحًا إذا تم إنشاء زر واحد على الأقل عند إنشاء منشور",
}
l_preview_text = {
    'ru': "👩🏽‍💻 Режим [превью] используется с одиночными jpg|png|gif|mp4-файлами до 5Mb",
    'en': "👩🏽‍💻 The [preview] mode is used with single jpg|png|gif|mp4 files up to 5Mb",
    'es': "👩🏽‍💻 El modo [vista previa] se usa con archivos individuales jpg|png|gif|mp4 de hasta 5Mb",
    'fr': "👩🏽‍💻 Le mode [aperçu] est utilisé avec des fichiers jpg|png|gif|mp4 uniques jusqu'à 5 Mo",
    'zh': "👩🏽‍💻 [预览] 模式用于最大 5Mb 的单个 jpg|png|gif|mp4 文件",
    'ar': "👩🏽‍💻 يتم استخدام وضع [المعاينة] مع ملفات jpg واحدة | png | gif | mp4 حتى 5 ميغا بايت",
}
l_gallery_text = {
    'ru': "👩🏽‍💻 Режим [галерея] доступен для 2 и более медиа файлов",
    'en': "👩🏽‍💻 [Gallery] mode is available for 2 or more media files",
    'es': "👩🏽‍💻 El modo [Galería] está disponible para 2 o más archivos multimedia",
    'fr': "👩🏽‍💻 Le mode [Galerie] est disponible pour 2 fichiers multimédias ou plus",
    'zh': "👩🏽‍💻 [图库] 模式可用于 2 个或更多媒体文件",
    'ar': "وضع [المعرض] متاح لملفات وسائط أو أكثر",
}
l_spoiler_text = {
    'ru': "👩🏽‍💻 Режим [спойлер] доступен для photo/gif/video",
    'en': "👩🏽‍💻 [spoiler] mode available for photo/gif/video",
    'es': "👩🏽‍💻 Modo [spoiler] disponible para foto/gif/video",
    'fr': "👩🏽‍💻 Mode [spoiler] disponible pour photo/gif/vidéo",
    'zh': "👩🏽‍💻 [剧透] 模式可用于照片/gif/视频",
    'ar': "👩🏽‍💻 وضع [المفسد] متاح للصور / gif / الفيديو",
}
l_window_text = {
    'ru': "👩🏽‍💻 Режим [окно] доступен для постов с кнопками без ссылок",
    'en': "👩🏽‍💻 [spoiler] mode available for photo/gif/video",
    'es': "👩🏽‍💻 Modo [spoiler] disponible para foto/gif/video",
    'fr': "👩🏽‍💻 Mode [spoiler] disponible pour photo/gif/vidéo",
    'zh': "👩🏽‍💻 [剧透] 模式可用于照片/gif/视频",
    'ar': "👩🏽‍💻 وضع [المفسد] متاح للصور / gif / الفيديو",
}
l_post_has_restricted = {
    'ru': "👩🏽‍💻 У вас premium-аккаунт! В настройках <b>[Конфиденциальность]</b> добавь @{0} в <i>исключения</i> для <b>[Голосовые сообщения]</b>, чтобы отобразить видео-заметку/голосовое",
    'en': "👩🏽‍💻 You have a premium account! In the <b>[Privacy]</b> settings, add @{0} to <i>the exclusions</i> for <b>[Voice Messages]</b> to display видео-заметку / голосовое",
    'es': "👩🏽‍💻 ¡Tienes una cuenta premium! En la configuración <b>de [Privacidad]</b> , agregue @{0} a <i>las exclusiones</i> de <b>[Mensajes de voz]</b> para mostrar видео-заметку / голосовое",
    'fr': "👩🏽‍💻 Vous avez un compte premium ! Dans les paramètres <b>[Confidentialité]</b> , ajoutez @{0} aux <i>exclusions</i> pour <b>[Messages vocaux]</b> pour afficher видео-заметку / голосовое",
    'zh': "👩🏽‍💻 您拥有高级帐户！在<b>[隐私]</b>设置中，将@{0}添加到<b>[语音消息]</b>的<i>排除项</i>中以显示видео-заметку / голосовое",
    'ar': "👩🏽‍💻 لديك حساب مميز! في إعدادات <b>[الخصوصية]</b> ، أضف @ {0} إلى <i>استثناءات</i> <b>[الرسائل الصوتية]</b> لعرض видео-заметку / голосовое",
}
l_post_tz = {
    'ru': "📍 <b>Часовой пояс</b> геопозиции установлен\n\n🕐 <b>Текуще</b>е время: <u>{0}</u> ({1}{2} по Гринвичу)",
    'en': "📍 Location <b>time zone</b> set\n\n🕐 <b>Current</b> time: <u>{0}</u> ({1}{2} GMT)",
    'es': "📍 Configuración <b>de la zona horaria</b> de la ubicación\n\n🕐 Hora <b>actual</b> : <u>{0}</u> ({1}{2} GMT)",
    'fr': "📍 <b>Fuseau horaire</b> de l&#x27;emplacement défini\n\n🕐 Heure <b>actuelle</b> : <u>{0}</u> ({1}{2} GMT)",
    'zh': "📍 位置<b>时区</b>设置\n\n🕐<b>当前</b>时间： <u>{0}</u> （{1}{2} GMT）",
    'ar': "📍 تعيين <b>المنطقة الزمنية</b> للموقع\n\n🕐 الوقت <b>الحالي</b> : <u>{0}</u> ({1} {2} GMT)",
}
l_post_time_future = {
    'ru': "🕒 Укажи время в будущем",
    'en': "🕒 Set time in the future",
    'es': "🕒 Establecer tiempo en el futuro",
    'fr': "🕒 Réglez l'heure dans le futur",
    'zh': "🕒 设定未来的时间",
    'ar': "🕒 حدد الوقت في المستقبل",
}
l_me = {
    'ru': "👤 Себе",
    'en': "👤 Yourself",
    'es': "👤 tú mismo",
    'fr': "👤 Vous-même",
    'zh': "👤 你自己",
    'ar': "👤 نفسك",
}
l_all = {
    'ru': "👥 Всем",
    'en': "👥 Everyone",
    'es': "👥 Todos",
    'fr': "👥 Tout le monde",
    'zh': "👥 大家",
    'ar': "👥 الجميع",
}
l_channel = {
    'ru': "⛰️ Канал",
    'en': "⛰️ Channel",
    'es': "⛰️ Canal",
    'fr': "⛰️ Chaîne",
    'zh': "⛰️频道",
    'ar': "⛰️ قناة",
}
l_group = {
    'ru': "⛰️ Group",
    'en': "⛰️ Group",
    'es': "⛰️ Grupo",
    'fr': "⛰️ Groupe",
    'zh': "⛰️组",
    'ar': "⛰️ المجموعة",
}
l_bot = {
    'ru': "⛰️ Бот",
    'en': "⛰️ Bot",
    'es': "⛰️Bot",
    'fr': "⛰️ Robot",
    'zh': "⛰️ 机器人",
    'ar': "⛰️ بوت",
}
l_ids = {
    'ru': "🙌🏽 По id",
    'en': "🙌🏽 By id",
    'es': "🙌🏽 Por identificación",
    'fr': "🙌🏽 Par identifiant",
    'zh': "🙌🏽 通过 id",
    'ar': "🙌🏽 بالمعرف",
}
l_recipient = {
    'ru': "👩🏽‍💻 <b>Выбери</b> получателя",
    'en': "👩🏽‍💻 <b>Choose</b> recipient",
    'es': "👩🏽‍💻 <b>Elegir</b> destinatario",
    'fr': "👩🏽‍💻 <b>Choisissez</b> le destinataire",
    'zh': "👩🏽‍💻<b>选择</b>收件人",
    'ar': "👩🏽‍💻 <b>اختر</b> المستلم",
}
l_enter = {
    'ru': "👩🏽‍💻 <b>Введи</b> Ids получателей через <i>пробельные или разделительные</i> символы",
    'en': "👩🏽‍💻 <b>Enter</b> recipient Ids separated by spaces or separator characters",
    'es': "👩🏽‍💻 <b>Ingrese</b> las identificaciones de los destinatarios separadas por espacios o caracteres separadores",
    'fr': "👩🏽‍💻 <b>Entrez</b> les identifiants des destinataires séparés par des espaces ou des caractères de séparation",
    'zh': "👩🏽‍💻<b>输入</b>以空格或分隔符分隔的收件人 ID",
    'ar': "👩🏽‍💻 <b>أدخل</b> معرفات المستلمين مفصولة بمسافات أو أحرف فاصلة",
}
l_post_time_zone = {
    'ru': "📍 <b>Часовой пояс</b> геопозиции установлен\n\n🕐 <b>Текущее</b> время: <u>{0}</u> ({1}{2} по Гринвичу)",
    'en': "📍 Location <b>time zone</b> set\n\n🕐 <b>Current</b> time: <u>{0}</u> ({1}{2} GMT)",
    'es': "📍 Configuración <b>de la zona horaria</b> de la ubicación\n\n🕐 Hora <b>actual</b> : <u>{0}</u> ({1}{2} GMT)",
    'fr': "📍 <b>Fuseau horaire</b> de l&#x27;emplacement défini\n\n🕐 Heure <b>actuelle</b> : <u>{0}</u> ({1}{2} GMT)",
    'zh': "📍 位置<b>时区</b>设置\n\n🕐<b>当前</b>时间： <u>{0}</u> （{1}{2} GMT）",
    'ar': "📍 تعيين <b>المنطقة الزمنية</b> للموقع\n\n🕐 الوقت <b>الحالي</b> : <u>{0}</u> ({1} {2} GMT)",
}
l_broadcast_plan = {
    'ru': "📧 <b>Готово!</b> Рассылка запланирована",
    'en': "📧 <b>Done!</b> Newsletter scheduled",
    'es': "📧 <b>Listo!</b> Boletín programado",
    'fr': "📧 <b>C&#x27;est fait !</b> Newsletter prévue",
    'zh': "📧<b>完成！</b>已安排时事通讯",
    'ar': "📧 <b>انتهى!</b> النشرة الإخبارية المجدولة",
}
l_broadcast_plan_bot = {
    'ru': "📧 <b>Готово!</b> Рассылка запланирована в @{0}",
    'en': "📧 <b>Done!</b> Mailing scheduled for @{0}",
    'es': "📧 <b>Listo!</b> Envío programado para @{0}",
    'fr': "📧 <b>C&#x27;est fait !</b> Envoi prévu pour @{0}",
    'zh': "📧<b>完成！</b>邮寄安排在@{0}",
    'ar': "📧 <b>انتهى!</b> تمت جدولة الإرسال في @ {0}",
}
l_broadcast_start = {
    'ru': "📧 <b>Старт</b> рассылки..\n#длительность {0}min",
    'en': "📧 Newsletter <b>start</b> ..\n#duration {0}min",
    'es': "📧 <b>Inicio</b> del boletín ..\n#duración {0}min",
    'fr': "📧 <b>Début</b> de la newsletter ..\n#durée {0}min",
    'zh': "📧 时事通讯<b>开始</b>..\n#duration {0}min",
    'ar': "📧 <b>بدء النشرة</b> ..\n# مدة {0} دقيقة",
}
l_broadcast_process = {
    'ru': "📧 <b>Рассылка</b>..{0}%",
    'en': "📧 <b>Newsletter</b> ..{0}%",
    'es': "📧 <b>Boletín</b> ..{0}%",
    'fr': "📧 <b>Newsletter</b> ..{0}%",
    'zh': "📧<b>时事通讯</b>..{0}%",
    'ar': "📧 <b>النشرة الإخبارية</b> .. {0}٪",
}
l_broadcast_finish = {
    'ru': "🏁 <b>Рассылка</b> завершена\n\n📧 <b>Количество</b> пользователей, получивших сообщение: <u>{0}</u>",
    'en': "🏁 <b>Newsletter</b> completed\n\n📧 <b>Number</b> of users who received the message: <u>{0}</u>",
    'es': "🏁 <b>Boletín</b> completado\n\n📧 <b>Número</b> de usuarios que recibieron el mensaje: <u>{0}</u>",
    'fr': "🏁 <b>Newsletter</b> terminée\n\n📧 <b>Nombre</b> d&#x27;utilisateurs ayant reçu le message : <u>{0}</u>",
    'zh': "🏁<b>通讯</b>已完成\n\n📧 收到消息的用户<b>数</b>： <u>{0}</u>",
    'ar': "🏁 اكتملت <b>النشرة الإخبارية</b>\n\n📧 <b>عدد</b> المستخدمين الذين تلقوا الرسالة: <u>{0}</u>",
}

l_generate_calendar_time = {
    'ru': "🕒 <b>Отправь время</b> поста на {0} в формате {1}. Текущее время: <u>{2}</u> ({3} по Гринвичу)\n\n🔗 Пришли <b>геопозицию</b>, чтобы <i>автоматически</i> определить часовой пояс",
    'en': "🕒 <b>Send the time</b> of the post to {0} in the format {1} . Current time: <u>{2}</u> ({3} GMT)\n\n🔗 Send <b>geolocation</b> to <i>automatically</i> determine the time zone",
    'es': "🕒 <b>Envía la hora</b> de la publicación a {0} en el formato {1} . Hora actual: <u>{2}</u> ({3} GMT)\n\n🔗 Enviar <b>geolocalización</b> para determinar <i>automáticamente</i> la zona horaria",
    'fr': "🕒 <b>Envoyez l&#x27;heure</b> de la publication à {0} au format {1} . Heure actuelle : <u>{2}</u> ({3} GMT)\n\n🔗 Envoyez <b>la géolocalisation</b> pour déterminer <i>automatiquement</i> le fuseau horaire",
    'zh': "🕒 以{1}格式将帖子<b>时间发送到</b>{0}。当前时间： <u>{2}</u> ({3} GMT)\n\n🔗 发送<b>地理定位</b>以<i>自动</i>确定时区",
    'ar': "🕒 <b>أرسل وقت</b> النشر إلى {0} بالتنسيق {1} . الوقت الحالي: <u>{2}</u> ({3} GMT)\n\n🔗 أرسل <b>الموقع الجغرافي</b> لتحديد المنطقة الزمنية <i>تلقائيًا</i>",
}
l_month_1 = {
    'ru': "Янв",
    'en': "Jan",
    'es': "Ene",
    'fr': "Jan",
    'zh': "简",
    'ar': "يناير",
}
l_month_2 = {
    'ru': "Фев",
    'en': "Feb",
    'es': "Feb",
    'fr': "Fév",
    'zh': "二月",
    'ar': "فبراير",
}
l_month_3 = {
    'ru': "Мар",
    'en': "Mar",
    'es': "Mar",
    'fr': "Mar",
    'zh': "三月",
    'ar': "مارس",
}
l_month_4 = {
    'ru': "Апр",
    'en': "Apr",
    'es': "Abr",
    'fr': "Avr",
    'zh': "4月",
    'ar': "أبريل",
}
l_month_5 = {
    'ru': "Май",
    'en': "Maybe",
    'es': "Tal vez",
    'fr': "Peut être",
    'zh': "或许",
    'ar': "ربما",
}
l_month_6 = {
    'ru': "Июн",
    'en': "June",
    'es': "Junio",
    'fr': "Juin",
    'zh': "六月",
    'ar': "يونيو",
}
l_month_7 = {
    'ru': "Июл",
    'en': "July",
    'es': "Julio",
    'fr': "Juillet",
    'zh': "七月",
    'ar': "يوليو",
}
l_month_8 = {
    'ru': "Авг",
    'en': "Aug",
    'es': "Ago",
    'fr': "Août",
    'zh': "八月",
    'ar': "أغسطس",
}
l_month_9 = {
    'ru': "Сен",
    'en': "You",
    'es': "Tú",
    'fr': "Toi",
    'zh': "你",
    'ar': "أنت",
}
l_month_10 = {
    'ru': "Окт",
    'en': "Oct",
    'es': "Oct",
    'fr': "Oct",
    'zh': "十月",
    'ar': "أكتوبر",
}
l_month_11 = {
    'ru': "Ноя",
    'en': "But I",
    'es': "Pero yo",
    'fr': "Mais je",
    'zh': "但是我",
    'ar': "لكن أنا",
}
l_month_12 = {
    'ru': "Дек",
    'en': "Dec",
    'es': "Dic",
    'fr': "Déc",
    'zh': "十二月",
    'ar': "ديسمبر",
}

l_weekday_1 = {
    'ru': "пн",
    'en': "mon",
    'es': "lun",
    'fr': "lun",
    'zh': "星期一",
    'ar': "mon",
}
l_weekday_2 = {
    'ru': "вт",
    'en': "tue",
    'es': "mar",
    'fr': "mar",
    'zh': "星期二",
    'ar': "الثلاثاء",
}
l_weekday_3 = {
    'ru': "ср",
    'en': "sr",
    'es': "señor",
    'fr': "sr",
    'zh': "高级",
    'ar': "ريال سعودى",
}
l_weekday_4 = {
    'ru': "чт",
    'en': "ch",
    'es': "ch",
    'fr': "ch",
    'zh': "通道",
    'ar': "الفصل",
}
l_weekday_5 = {
    'ru': "пт",
    'en': "pt",
    'es': "punto",
    'fr': "pt",
    'zh': "点",
    'ar': "نقطة",
}
l_weekday_6 = {
    'ru': "сб",
    'en': "coll",
    'es': "col",
    'fr': "coll",
    'zh': "科尔",
    'ar': "كول",
}
l_weekday_7 = {
    'ru': "вс",
    'en': "vs",
    'es': "contra",
    'fr': "contre",
    'zh': "对比",
    'ar': "ضد",
}

l_inline_demo = {
    'ru': "обо всех проектах",
    'en': "about all projects",
    'es': "sobre todos los proyectos",
    'fr': "sur tous les projets",
    'zh': "关于所有项目",
    'ar': "عن جميع المشاريع",
}
l_inline_bot = {
    'ru': "конструктор ботов",
    'en': "bot constructor",
    'es': "constructor de bots",
    'fr': "constructeur de bot",
    'zh': "机器人构造器",
    'ar': "منشئ الروبوت",
}
l_inline_post = {
    'ru': "конструктор офферов",
    'en': "offer constructor",
    'es': "constructor de ofertas",
    'fr': "offre constructeur",
    'zh': "提供构造函数",
    'ar': "عرض منشئ",
}
l_inline_media = {
    'ru': "конструктор медиа-заметок",
    'en': "media note builder",
    'es': "generador de notas de medios",
    'fr': "constructeur de note média",
    'zh': "媒体笔记生成器",
    'ar': "منشئ الملاحظات الإعلامية",
}
l_inline_channel = {
    'ru': "администратор каналов",
    'en': "channel administrator",
    'es': "administrador del canal",
    'fr': "administrateur de la chaîne",
    'zh': "频道管理员",
    'ar': "مدير القناة",
}
l_inline_group = {
    'ru': "администратор групп",
    'en': "group administrator",
    'es': "administrador de grupo",
    'fr': "administrateur de groupe",
    'zh': "群管理员",
    'ar': "مسؤول المجموعة",
}
l_inline_find = {
    'ru': "бот для поиска",
    'en': "search bot",
    'es': "robot de búsqueda",
    'fr': "robot de recherche",
    'zh': "搜索机器人",
    'ar': "بحث بوت",
}
l_inline_ai = {
    'ru': "бот с нейросетью",
    'en': "bot with neural network",
    'es': "bot con red neuronal",
    'fr': "bot avec réseau de neurones",
    'zh': "具有神经网络的机器人",
    'ar': "بوت مع الشبكة العصبية",
}
l_inline_ads = {
    'ru': "рекламный бот",
    'en': "advertising bot",
    'es': "robot publicitario",
    'fr': "robot publicitaire",
    'zh': "广告机器人",
    'ar': "روبوت إعلاني",
}
l_inline_vpn = {
    'ru': "vpn-бот",
    'en': "vpn-bot",
    'es': "vpn-bot",
    'fr': "vpn-bot",
    'zh': "vpn机器人",
    'ar': "vpn- بوت",
}
l_inline_target = {
    'ru': "таргет-бот",
    'en': "target bot",
    'es': "robot objetivo",
    'fr': "robot cible",
    'zh': "目标机器人",
    'ar': "الهدف الروبوت",
}
l_inline_user = {
    'ru': "администратор пользователя",
    'en': "user administrator",
    'es': "administrador de usuarios",
    'fr': "administrateur d'utilisateurs",
    'zh': "用户管理员",
    'ar': "مسؤول المستخدم",
}
l_inline_tools = {
    'ru': "Telegram-инструменты",
    'en': "Telegram tools",
    'es': "Herramientas de telegramas",
    'fr': "Outils de télégramme",
    'zh': "电报工具",
    'ar': "أدوات Telegram",
}
l_inline_work = {
    'ru': "вакансии/конкурсы",
    'en': "vacancies/competitions",
    'es': "vacantes/concursos",
    'fr': "postes vacants/concours",
    'zh': "职位空缺/竞争",
    'ar': "الشواغر / المسابقات",
}
# endregion


# region FereyBotBot
l_bot_btn1 = {
    'ru': "⛰ Боты",
    'en': "⛰ Bots",
    'es': "⛰ Bots",
    'fr': "⛰ Bots",
    'zh': "⛰ 靴子",
    'ar': "⛰ أحذية",
}
l_bot_btn2 = {
    'ru': "🌬 Подписка",
    'en': "🌬 Subscription",
    'es': "🌬 Suscripción",
    'fr': "🌬 Abonnement",
    'zh': "🌬订阅",
    'ar': "🌬 الاشتراك",
}
l_bot_welcome = {
    'ru': "🌱 {0}, добро пожаловать в <i>лендинг-бот</i> автоматизации <b>Telegram</b>-ботов:\n\n▪️авто-постинг и <b>авто-перевод</b>\n▪️<b>авто-ответы</b> и оповещения\n▪️нейросети: графика и текст бота\n▪️интеграции и платежи\n\n❗️Регулярно-обновляемый /content",
    'en': "🌱 {0}, welcome to the <b>Telegram</b> bot автоматизации <i>landing bot</i> :\n\n▪️auto-posting and <b>auto-translation</b>\n▪️ <b>auto-replies</b> and notifications\n▪️integrations and payments\n▪️users and administrators\n\n❗️You can also order the development of a chatbot in our ferey studio",
    'es': "🌱 {0}, bienvenido al <i>bot de aterrizaje</i> автоматизации de bots <b>de Telegram</b> :\n\n▪️auto-publicación y <b>auto-traducción</b>\n▪️auto <b>-respuestas</b> y notificaciones\n▪️integraciones y pagos\n▪️usuarios y administradores\n\n❗️también puedes encargar el desarrollo de un chatbot en nuestro ferey studio",
    'fr': "🌱 {0}, bienvenue dans le <i>bot d&#x27;atterrissage</i> автоматизации du bot <b>Telegram</b> :\n\n▪️publication et <b>traduction automatiques</b>\n▪️ <b>réponses et notifications automatiques</b>\n▪️intégrations et paiements\n▪️utilisateurs et administrateurs\n\n❗️Vous pouvez également commander le développement d'un chatbot dans notre studio ferey",
    'zh': "🌱 {0}，欢迎使用<b>Telegram</b>机器人автоматизации<i>登陆机器人</i>：\n\n▪️自动发布和<b>自动翻译</b>\n▪️<b>自动回复</b>和通知\n▪️集成和支付\n▪️用户和管理员\n\n❗️您也可以在我们的ferey工作室订购聊天机器人的开发",
    'ar': "🌱 {0} ، مرحبًا بك في <i>الروبوت الهبوط</i> автоматизации لروبوت <b>Telegram</b> :\n\n▪️ النشر التلقائي <b>والترجمة التلقائية</b>\n▪️ <b>الردود التلقائية</b> والإشعارات\n▪️ عمليات الدمج والمدفوعات\nالمستخدمون والمسؤولون\n\n❗️ يمكنك أيضًا طلب تطوير روبوت محادثة في استوديو ferey الخاص بنا",
}
l_subscribe_bot = {
    'ru': "👩🏽‍💻 <b>Оформи</b> ежемесячную <i>подписку</i>:\n\n¹ [<b>Все боты</b> и проекты (-<u>5</u>%)]\n² [@{0}-бот]:\n▪️авто-перевод\n(<i>в том числе, текста кнопок</i>)\n▪️авто-ответ\n(<i>chatgpt видит блоки бота</i>)\n▪️приоритетная поддержка\n\n👩🏽‍💻 /balance",
    'en': "👩🏽‍💻 <b>Sign up for</b> a monthly\n\n¹ <i>subscription</i> to @{0}-bot [{1} ₽]\n▪️ no ads\n▪️ creative tasks\n² Subscribe to <u>all</u> bots [{2} ₽]",
    'es': "👩🏽‍💻 <b>Regístrese para obtener</b> una\n\n¹ <i>suscripción</i> mensual a @{0}-bot [{1} ₽]\n▪️ sin anuncios\n▪️ tareas creativas\n² Suscríbase a <u>todos</u> los bots [{2} ₽]",
    'fr': "👩🏽‍💻 <b>Inscrivez-vous pour</b> un <i>abonnement</i>\n\n¹ mensuel à @{0}-bot [{1} ₽]\n▪️ pas de publicité\n▪️ tâches créatives\n² Abonnez-vous à <u>tous</u> les bots [{2} ₽]",
    'zh': "👩🏽‍💻<b>注册</b>每月\n\n¹<i>订阅</i>@{0}-bot [{1} ₽]\n▪️ 无广告\n▪️ 创意任务\n² 订阅<u>所有</u>机器人 [{2} ₽]",
    'ar': "👩🏽‍💻 <b>اشترك للحصول على</b> <i>اشتراك</i> شهري\n\n¹ في @ {0} -bot [{1} ₽]\n▪️ بلا إعلانات\n▪️ مهام إبداعية\n² اشترك في <u>جميع</u> برامج التتبُّع [{2} ₽]",
}

l_add_bot_button = {
    'ru': "➕ Добавить бота",
    'en': "➕ Add a bot",
    'es': "➕ Agregar un bot",
    'fr': "➕ Ajouter un robot",
    'zh': "➕ 添加机器人",
    'ar': "➕ أضف بوت",
}
l_add_bot_call = {
    'ru': "➕ Оформи подписку для >1 бота или открепи активного бота, чтобы добавить нового",
    'en': "➕ Subscribe for >1 bot or unsubscribe active bot to add a new one",
    'es': "➕ Suscríbete a >1 bot o cancela la suscripción de un bot activo para agregar uno nuevo",
    'fr': "➕ Abonnez-vous pour > 1 bot ou désabonnez-vous du bot actif pour en ajouter un nouveau",
    'zh': "➕ 订阅 >1 个机器人或取消订阅活动机器人以添加新机器人",
    'ar': "➕ اشترك في> 1 bot أو إلغاء الاشتراك في bot النشط لإضافة واحد جديد",
}
l_test_bot_desc = {
    'ru': "🫥 Описание @{0}-бота:\n\n▪️телеграф блог\n▪️авто-перевод\n▪️оповещения и utm-рефералы\n▪️интеграции",
    'en': "🫥 @{0}-bot description:\n\n▪️telegraph blog\n▪️auto-translation\n▪️alerts and utm referrals\n▪️integrations",
    'es': "🫥 @{0}-bot description:\n\n▪️telegraph blog\n▪️traducción automática\n▪️alertas y referencias utm\n▪️integraciones",
    'fr': "🫥 @{0}-bot description :\n\n▪️blog télégraphique\n▪️traduction automatique\n▪️alertes et références utm\n▪️intégrations",
    'zh': "🫥 @{0}-bot 描述：\n\n▪️电报博客\n▪️自动翻译\n▪️提醒和 utm 推荐\n▪️集成",
    'ar': "🫥 @ {0} وصف البرنامج الآلي:\n\n▪️ مدونة telegraph\n▪️ ترجمة تلقائية\n▪️ تنبيهات وإحالات UTM\n▪️ تكامل",
}
l_clone_bot_button = {
    'ru': "©️ Клонировать бота",
    'en': "©️ Clone the bot",
    'es': "©️ Clonar el bot",
    'fr': "©️ Cloner le bot",
    'zh': "©️ 克隆机器人",
    'ar': "© ️ استنساخ الروبوت",
}
l_clone_bot_call = {
    'ru': "©️ Оформи подписку для >1 бота или открепи активного бота, чтобы склонировать бота конкурента",
    'en': "©️ Subscribe >1 bot or unpin an active bot to clone a competitor's bot",
    'es': "©️ Suscríbete >1 bot o desancla un bot activo para clonar el bot de un competidor",
    'fr': "©️ Abonnez-vous >1 bot ou désépinglez un bot actif pour cloner le bot d'un concurrent",
    'zh': "©️ 订阅 >1 个机器人或取消固定一个活跃的机器人以克隆竞争对手的机器人",
    'ar': "© ️ اشترك> 1 بوت أو قم بإلغاء تثبيت روبوت نشط لاستنساخ روبوت منافس",
}
l_clone_bot_text = {
    'ru': "©️ <b>Вставь</b> корректную ссылку на бота, чтобы склонировать его",
    'en': "©️ <b>Paste</b> the correct link to the bot to clone it",
    'es': "©️ <b>Pega</b> el enlace correcto al bot para clonarlo",
    'fr': "©️ <b>Collez</b> le bon lien vers le bot pour le cloner",
    'zh': "©️ 将正确的链接<b>粘贴</b>到机器人以克隆它",
    'ar': "© ️ <b>الصق</b> الرابط الصحيح إلى الروبوت لاستنساخه",
}
l_clone_bot_wait = {
    'ru': "©️ <b>Клонирование</b> бота\n\n#длительность 1мин",
    'en': "©️ Bot <b>cloning</b>\n\n#duration 1 min",
    'es': "©️ <b>Clonación</b> de bots\n\n#duración 1 min",
    'fr': "©️ <b>Clonage</b> de bot\n\n#durée 1 min",
    'zh': "©️ Bot<b>克隆</b>\n\n#duration 1 分钟",
    'ar': "© ️ <b>استنساخ</b> الروبوت\n\n# المدة 1 دقيقة",
}
l_addbot_handler = {
    'ru': "➕ Пришли корректный <b>ТОКЕН</b> Telegram-бота, полученный с помощью @botFather-бота\n\n👩🏽‍💻 Например, 117783159:BBAD2Kz2h8AQtHYiVtuyyyASdMN",
    'en': "➕ We sent the correct Telegram bot <b>TOKEN</b> received using @botFather bot\n\n👩🏽‍💻 For example, 117783159:BBAD2Kz2h8AQtHYiVtuyyyASdMN",
    'es': "➕ Enviamos el <b>TOKEN</b> de bot de Telegram correcto recibido usando @botFather bot\n\n👩🏽‍💻 Por ejemplo, 117783159:BBAD2Kz2h8AQtHYiVtuyyyASdMN",
    'fr': "➕ Nous avons envoyé le bon <b>jeton</b> de bot Telegram reçu à l&#x27;aide du bot @botFather\n\n👩🏽‍💻 Par exemple, 117783159:BBAD2Kz2h8AQtHYiVtuyyyASdMN",
    'zh': "➕ 我们发送了使用@botFather bot\n\n👩🏽‍💻 收到的正确的 Telegram bot <b>TOKEN</b>例如， 117783159:BBAD2Kz2h8AQtHYiVtuyyyASdMN",
    'ar': "➕ أرسلنا <b>برنامج</b> Telegram bot الصحيح الذي تم استلامه باستخدام @botFather bot\n\n👩🏽‍💻 على سبيل المثال ، 117783159:BBAD2Kz2h8AQtHYiVtuyyyASdMN",
}
l_wait_for_translate_bot = {
    'ru': "👩🏽‍💻 <b>Перевод</b> {0}-бота на <i>{1}</i>-язык\n\n#длительность 0мин",
    'en': "👩🏽‍💻 <b>Translation of</b> {0}-bot into <i>{1}</i> -language\n\n#duration 0min",
    'es': "👩🏽‍💻 <b>Traducción de</b> {0}-bot a <i>{1}</i> -idioma\n\n#duración 0min",
    'fr': "👩🏽‍💻 <b>Traduction de</b> {0}-bot en <i>{1}</i> -langue\n\n#durée 0min",
    'zh': "👩🏽‍💻 将 {0}-bot<b>翻译</b>成<i>{1}</i> -language\n\n#duration 0min",
    'ar': "👩🏽‍💻 <b>ترجمة</b> {0} - الروبوت إلى <i>{1}</i> -اللغة\n\n# المدة 0 دقيقة",
}
l_template_is_ready = {
    'ru': "👩🏽‍💻 <b>Шаблон</b> для @{0} готов!",
    'en': "👩🏽‍💻 <b>Template</b> for @{0} is ready!",
    'es': "👩🏽‍💻 ¡ <b>La plantilla</b> para @{0} está lista!",
    'fr': "👩🏽‍💻 <b>Le modèle</b> pour @{0} est prêt !",
    'zh': "👩🏽‍💻 @{0} 的<b>模板</b>已准备就绪！",
    'ar': "👩🏽‍💻 <b>نموذج</b> @ {0} جاهز!",
}
l_payment_successful = {
    'ru': "👩🏽‍💻 <b>Пользователь</b> {0} 💰Внес оплату в размере {1} {2}",
    'en': "👩🏽‍💻 <b>User</b> {0} 💰Paid payment in the amount of {1} {2}",
    'es': "👩🏽‍💻 <b>Usuario</b> {0} 💰Pago pagado por la cantidad de {1} {2}",
    'fr': "👩🏽‍💻 <b>Utilisateur</b> {0} 💰Paiement payé d'un montant de {1} {2}",
    'zh': "👩🏽‍💻<b>用户</b>{0} 💰支付金额为{1} {2}",
    'ar': "👩🏽‍💻 <b>المستخدم</b> {0} 💰 دفعة مدفوعة بمبلغ {1} {2}",
}
l_promocode_activated = {
    'ru': "👩🏽‍💻 *Промокод*: `{txt}` активирован",
    'en': "👩🏽‍💻 *Promo code*: `{txt}` activated",
    'es': "👩🏽‍💻 *Código promocional*: `{txt}` activado",
    'fr': "👩🏽‍💻 *Code promotionnel* : `{txt}` activé",
    'zh': "👩🏽‍💻 *促销代码*：`{txt}` 激活",
    'ar': "👩🏽‍💻 * الرمز الترويجي *: '{txt}` مفعل",
}

# region commands
l_bot_commands_handler = {
    'ru': "⚙️ <b>Команды</b> /cmd для <b>@{0}</b>\n\n/info   <i>информация</i>\n/stat   <i>аналитика</i>\n/status <i>статус</i>\n/on     <i>включение</i>\n/off    <i>выключение</i>\n/restart  <i>перезагрузка</i>\n\n/parse [premium|admin|utm|ban]\n/admin [id]    <i>администраторы</i>\n/promo      <i>промокод</i>\n/ban [id/@username]   <i>список</i>\n/unban     <i>разбан</i>",
    'en': "⚙️ <b>Commands</b> /cmd for <b>@{0}</b>\n\n/info <i>info</i>\n/stat <i>analytics</i>\n/status <i>status</i>\n/on <i>enable</i>\n/off <i>disable</i>\n/restart <i>reload</i>\n\n/parse [premium| admin|utm|ban]\n/admin [id] <i>admins</i>\n/promo <i>promo code</i>\n/ban [id/ @username ] <i>list</i>\n/unban <i>unbanned</i>",
    'es': "⚙️ <b>Comandos</b> /cmd para <b>@{0}</b>\n\n/info <i>info</i>\n/stat <i>analytics</i>\n/status <i>status</i>\n/on <i>enable</i>\n/off <i>disabled</i>\n/restart <i>reload</i>\n\n/parse [premium| admin|utm|ban]\n/admin [id] <i>administradores</i>\n/promo <i>código de promoción</i>\n/ban [id/ @username ] <i>lista</i>\n/unban <i>no baneado</i>",
    'fr': "⚙️ <b>Commandes</b> /cmd pour <b>@{0}</b>\n\n/info <i>info</i>\n/stat <i>analytics</i>\n/status <i>status</i>\n/on <i>enable</i>\n/off <i>disable</i>\n/restart <i>recharger</i>\n\n/parse [premium| admin|utm|ban]\n/admin [id] <i>admins</i>\n/promo <i>code promo</i>\n/ban [id/ @username ] <i>list</i>\n/unban <i>unbanned</i>",
    'zh': "⚙️<b>命令</b>/cmd for <b>@{0}</b>\n\n/info <i>info</i>\n/stat <i>analytics</i>\n/status <i>status</i>\n/on <i>enable</i>\n/off <i>disable</i>\n/restart <i>reload</i>\n\n/parse [premium| admin|utm|ban]\n/admin [id] <i>admins</i>\n/promo<i>促销代码</i>\n/ban [id/ @username ] <i>list</i>\n/unban <i>unbanned</i>",
    'ar': "⚙️ <b>أوامر</b> / cmd لـ <b>@ {0}</b>\n\n/ info <i>info</i>\n/ stat <i>analytics</i>\n/ status <i>status</i>\n/ on <i>تمكين</i>\n/off <i>تعطيل</i>\n/restart <i>تحميل</i>\n\n/ parse [premium | admin | utm | ban]\n/ admin [id] <i>admins</i>\n/ <i>promo code</i>\n/ ban [id / @username ] <i>list</i>\n/ <i>unsanned</i>",
}
l_bot_status_handler = {
    'ru': "👩🏽‍💻 <b>Статус</b> @{0}-бота: {1}",
    'en': "👩🏽‍💻 <b>Status</b> @{0}-bot: {1}",
    'es': "👩🏽‍💻 <b>Estado</b> @{0}-bot: {1}",
    'fr': "👩🏽‍💻 <b>Statut</b> @{0}-bot : {1}",
    'zh': "👩🏽‍💻<b>状态</b>@{0}-bot：{1}",
    'ar': "👩🏽‍💻 <b>الحالة</b> @ {0} -روبوت: {1}",
}
l_bot_on_handler = {
    'ru': "👩🏽‍💻 <b>Запуск</b> @{0}-бота..\n\n#длительность 1мин",
    'en': "👩🏽‍💻 <b>Launch</b> @{0}-bot..\n\n#duration 1 min",
    'es': "👩🏽‍💻 <b>Lanzar</b> @{0}-bot..\n\n#duración 1 min",
    'fr': "👩🏽‍💻 <b>Lancer</b> @{0}-bot..\n\n#durée 1 min",
    'zh': "👩🏽‍💻<b>启动</b>@{0}-bot..\n\n#duration 1 分钟",
    'ar': "👩🏽‍💻 <b>Launch</b> @ {0} -bot ..\n\n# المدة 1 دقيقة",
}
l_bot_on_handler_already = {
    'ru': "👩🏽‍💻 <b>@{0}</b>-бот уже запущен",
    'en': "👩🏽‍💻 <b>@{0}</b> - the bot is already running",
    'es': "👩🏽‍💻 <b>@{0}</b> : el bot ya se está ejecutando",
    'fr': "👩🏽‍💻 <b>@{0}</b> - le bot est déjà en cours d'exécution",
    'zh': "👩🏽‍💻 <b>@{0}</b> - 机器人已经在运行",
    'ar': "👩🏽‍💻 <b>@ {0}</b> - الروبوت قيد التشغيل بالفعل",
}
l_bot_off_handler = {
    'ru': "👩🏽‍💻 <b>Остановка</b> @{0}-бота..\n\n#длительность 1мин",
    'en': "👩🏽‍💻 @{0}-bot <b>stop</b> ..\n\n#duration 1 min",
    'es': "👩🏽‍💻 @{0}-bot <b>parada</b> ..\n\n#duración 1 min",
    'fr': "👩🏽‍💻 @{0}-bot <b>stop</b> ..\n\n#durée 1 min",
    'zh': "👩🏽‍💻 @{0}-bot<b>停止</b>..\n\n#duration 1 分钟",
    'ar': "👩🏽‍💻 @ {0} -bot <b>stop</b> ..\n\n# المدة 1 دقيقة",
}
l_bot_off_handler_already = {
    'ru': "👩🏽‍💻 <b>@{0}</b>-бот уже выключен",
    'en': "👩🏽‍💻 <b>@{0}</b> -bot is already off",
    'es': "👩🏽‍💻 <b>@{0}</b> -bot ya está apagado",
    'fr': "👩🏽‍💻 <b>@{0}</b> -bot est déjà désactivé",
    'zh': "👩🏽‍💻 <b>@{0}</b> -bot 已经关闭",
    'ar': "الروبوت 👩🏽‍💻 <b>@ {0}</b> متوقف بالفعل",
}
l_bot_off_handler_done = {
    'ru': "👩🏽‍💻 <b>@{0}</b>-бот выключен",
    'en': "👩🏽‍💻 <b>@{0}</b> -bot is off",
    'es': "👩🏽‍💻 <b>@{0}</b> -bot está apagado",
    'fr': "👩🏽‍💻 <b>@{0}</b> -bot est désactivé",
    'zh': "👩🏽‍💻 <b>@{0}</b> -bot 已关闭",
    'ar': "👩🏽‍💻 <b>@ {0}</b> -الروبوت غير مفعّل",
}
l_bot_restart_handler = {
    'ru': "👩🏽‍💻 <b>Перезапуск</b> @{0}-бота..\n\n#длительность 1мин",
    'en': "👩🏽‍💻 @{0}-bot <b>restart</b> ..\n\n#duration 1 min",
    'es': "👩🏽‍💻 @{0}-bot <b>reinicio</b> ..\n\n#duración 1 min",
    'fr': "👩🏽‍💻 @{0}-bot <b>restart</b> ..\n\n#durée 1 min",
    'zh': "👩🏽‍💻@{0}-bot<b>重启</b>..\n\n#duration 1 分钟",
    'ar': "👩🏽‍💻 @ {0} -bot <b>إعادة التشغيل</b> ..\n\n# المدة 1 دقيقة",
}
# endregion


# region bot
l_bot_config = {
    ("cctor", "👩🏽‍💻", "☑"): {
        'ru': "Конструктор ᴺᴱᵂ",
        'en': "Builder ᴺᴱᵂ",
        'es': "Builder ᴺᴱᵂ",
        'fr': "Builder ᴺᴱᵂ",
        'zh': "Builder ᴺᴱᵂ",
        'ar': "Builder ᴺᴱᵂ",
    },
    ("cban", "🕵🏽", "☑"): {
        'ru': "Авто-бан",
        'en': "Auto-ban",
        'es': "Prohibición automática",
        'fr': "Interdiction automatique",
        'zh': "自動禁止",
        'ar': "حظر تلقائي",
    },
    ("ctranslate", "文", "☐"): {
        'ru': "Авто-перевод",
        'en': "Auto-translate",
        'es': "Saludo automático",
        'fr': "Message d'accueil automatique",
        'zh': "自動問候",
        'ar': "الترحيب التلقائي",
    },
    ("canswer", "👋🏽", "☐"): {
        'ru': "Авто-ответ",
        'en': "Auto-answer",
        'es': "Saludo automático",
        'fr': "Message d'accueil automatique",
        'zh': "自動問候",
        'ar': "الترحيب التلقائي",
    },
    ("cpost", "🔔", "☐"): {
        'ru': "Авто-постинг",
        'en': "Auto-posting",
        'es': "Publicación automática",
        'fr': "Publication automatique",
        'zh': "自動發布",
        'ar': "النشر التلقائي",
    },

    ("cpayment", "💳", "☐"): {
        'ru': "Платежи",
        'en': "Payments",
        'es': "Prohibición automática",
        'fr': "Interdiction automatique",
        'zh': "自動禁止",
        'ar': "حظر تلقائي",
    },
    ("cintegration", "🗝️", "☐"): {
        'ru': "Интеграции",
        'en': "Integrations",
        'es': "Publicación automática",
        'fr': "Publication automatique",
        'zh': "自動發布",
        'ar': "النشر التلقائي",
    },
    ("cnotification", "💬", "☑"): {
        'ru': "Оповещения",
        'en': "Notifications",
        'es': "Mensajes con 文/ب/y",
        'fr': "Messagerie avec 文/ب/y",
        'zh': "與消息 文/ب/y",
        'ar': "文/ب/y الرسائل ذات",
    },
    ("cuser", "👥", "☑"): {
        'ru': "Пользователи",
        'en': "Users",
        'es': "Mensajes con 文/ب/y",
        'fr': "Messagerie avec 文/ب/y",
        'zh': "與消息 文/ب/y",
        'ar': "文/ب/y الرسائل ذات",
    },
    ("cadmin", "👮🏽", "☑"): {
        'ru': "Администраторы",
        'en': "Administrators",
        'es': "Mensajes con 文/ب/y",
        'fr': "Messagerie avec 文/ب/y",
        'zh': "與消息 文/ب/y",
        'ar': "文/ب/y الرسائل ذات",
    },
}
l_remove_bot = {
    'ru': "🚫Убрать бота",
    'en': "🚫Remove bot",
    'es': "🚫Eliminar bot",
    'fr': "🚫Supprimer le robot",
    'zh': "🚫删除机器人",
    'ar': "🚫 إزالة البوت",
}

l_show_bots = {
    'ru': "👩🏽‍💻 <b>Добавленные боты</b>\n\n[команды /cmd]",
    'en': "👩🏽‍💻 <b>Added bots</b>\n\n[commands /cmd]",
    'es': "👩🏽‍💻 <b>Se agregaron bots</b>\n\n[comandos /cmd]",
    'fr': "👩🏽‍💻 <b>Ajout de bots</b>\n\n[commandes /cmd]",
    'zh': "👩🏽‍💻<b>添加了机器人</b>\n\n[命令/cmd]",
    'ar': "👩🏽‍💻 <b>الروبوتات المضافة</b>\n\n[أوامر / cmd]",
}

l_creturntext = {
    'ru': "✖️ <b>Сбросить</b> настройки по умолчанию (до рекомендуемых) для бота [<b>{0}</b>]?",
    'en': "✖️ <b>Reset</b> default settings (recommended) for bot [<b>{0}</b>]?",
    'es': "✖️ <b>¿Restablecer</b> la configuración predeterminada (recomendado) para el bot [<b>{0}</b>]?",
    'fr': "✖️ <b>Réinitialiser</b> les paramètres par défaut (recommandé) pour le bot [<b>{0}</b>] ?",
    'zh': "✖️<b>重置</b>机器人 [<b>{0}</b>] 的默认设置（推荐）？",
    'ar': "✖️ <b>إعادة تعيين</b> الإعدادات الافتراضية (موصى به) للروبوت [<b>{0}</b>]؟",
}
l_creturnanswer = {
    'ru': "✖️ Настройки бота [<b>{0}</b>] успешно сброшены!",
    'en': "✖️ Bot settings [<b>{0}</b>] successfully reset!",
    'es': "✖️ ¡La configuración del bot [<b>{0}</b>] se restableció correctamente!",
    'fr': "✖️ Les paramètres du bot [<b>{0}</b>] ont été réinitialisés avec succès !",
    'zh': "✖️ 机器人设置 [<b>{0}</b>] 成功重置！",
    'ar': "✖️ تم إعادة تعيين إعدادات البوت [<b>{0}</b>] بنجاح!",
}
l_cdeletetext = {
    'ru': "🚫 <b>Убрать</b> привязку бота [<b>{0}</b>]?",
    'en': "🚫 Remove bot binding [<b>{0}</b>]?",
    'es': "🚫 ¿Eliminar el enlace del bot [<b>{0}</b>]?",
    'fr': "🚫 Supprimer la liaison du bot [<b>{0}</b>] ?",
    'zh': "🚫 删除机器人绑定 [<b>{0}</b>]？",
    'ar': "🚫 إزالة ربط البوت [<b>{0}</b>]؟",
}
l_cdeleteanswer = {
    'ru': "🚫 Бот успешно откреплен [<b>{0}</b>]",
    'en': "🚫 Bot successfully unlocked [<b>{0}</b>]",
    'es': "🚫 Bot desbloqueado con éxito [<b>{0}</b>]",
    'fr': "🚫 Bot déverrouillé avec succès [<b>{0}</b>]",
    'zh': "🚫 机器人成功解锁 [<b>{0}</b>]",
    'ar': "🚫 تم فتح بوت بنجاح [<b>{0}</b>]",
}
l_transfer_success = {
    'ru': "👩🏽‍💻 <b>Права</b> владения на @{0}-бота успешно переданы @{1}-аккаунту!\n\n👩🏽‍💻 Теперь для передачи прав/настройки можно использовать @botfather-бота",
    'en': "👩🏽‍💻 <b>Ownership</b> of @{0}-bot successfully transferred to @{1}-account!\n\n👩🏽‍💻 You can now use @botfather -bot to transfer ownership/configuration",
    'es': "👩🏽‍💻 ¡ <b>La propiedad</b> de @{0}-bot se transfirió con éxito a @{1}-cuenta!\n\n👩🏽‍💻 Ahora puedes usar @botfather -bot para transferir la propiedad/configuración",
    'fr': "👩🏽‍💻 <b>La propriété</b> de @{0}-bot a été transférée avec succès vers @{1}-compte !\n\n👩🏽‍💻 Vous pouvez maintenant utiliser @botfather -bot pour transférer la propriété/configuration",
    'zh': "👩🏽‍💻 @{0}-bot 的<b>所有权</b>已成功转移到@{1}-帐户！\n\n👩🏽‍💻 您现在可以使用@botfather -bot 转移所有权/配置",
    'ar': "👩🏽‍💻 تم نقل <b>ملكية</b> @ {0} -bot بنجاح إلى @ {1} -account!\n\n👩🏽‍💻 يمكنك الآن استخدام @botfather -bot لنقل الملكية / التهيئة",
}
# endregion


# region config
# region ctranslate_
l_ctranslate_text = {
    'ru': "文 <b>Жми</b> на ✅/☑️ чтобы <b>Вкл/Выкл</b> авто-перевод для <i>исходящих</i> сообщений бота на язык пользователя при /start-запуске бота",
    'en': "文<b>Click</b> on ✅/☑️ to <b>enable/disable</b> auto-translate for <i>outgoing</i> bot messages into the user's language when /start-starting the bot",
    'es': "文<b>Haga clic</b> en ✅/☑️ para <b>habilitar/deshabilitar</b> la traducción automática de los mensajes <i>salientes</i> del bot al idioma del usuario cuando/inicie el bot",
    'fr': "文<b>Cliquez</b> sur ✅/☑️ pour <b>activer/désactiver</b> la traduction automatique des messages <i>sortants</i> du bot dans la langue de l'utilisateur lors du/démarrage du bot",
    'zh': "文<b>单击</b>✅/☑️<b>启用/禁用</b>在/启动机器人时将<i>传出的</i>机器人消息自动翻译成用户的语言",
    'ar': "文<b>انقر</b> فوق ✅ / ☑️ <b>لتمكين / تعطيل</b> الترجمة التلقائية لرسائل الروبوت <i>الصادرة</i> إلى لغة المستخدم عند / بدء تشغيل الروبوت",
}
l_ctranslate_in_on = {
    'ru': "✅☑Вкл перевод входящих",
    'en': "✅☑On translation of incoming",
    'es': "✅☑Sobre la traducción de entrantes",
    'fr': "✅☑Sur la traduction des entrants",
    'zh': "✅☑关于来电翻译",
    'ar': "✅☑على ترجمة واردة",
}
l_ctranslate_in_off = {
    'ru': "☑️☐Выкл перевод входящих",
    'en': "☑️☐Off incoming translation",
    'es': "☑️☐Traducción entrante desactivada",
    'fr': "☑️☐Désactiver la traduction entrante",
    'zh': "☑️☐关闭传入翻译",
    'ar': "☑️☐ إيقاف الترجمة الواردة",
}
l_ctranslate_out_on = {
    'ru': "✅☑Вкл перевод исходящих",
    'en': "✅☑On outgoing translation",
    'es': "✅☑Sobre la traducción saliente",
    'fr': "✅☑Sur la traduction sortante",
    'zh': "✅☑关于传出翻译",
    'ar': "✅☑ على الترجمة الصادرة",
}
l_ctranslate_out_off = {
    'ru': "☑️☐Выкл перевод исходящих",
    'en': "☑️☐Off transfer outgoing",
    'es': "☑️☐Fuera de transferencia saliente",
    'fr': "☑️☐Off transfert sortant",
    'zh': "☑️☐关闭转出",
    'ar': "☑️☐Off تحويل الصادرة",
}
# endregion


# region canswer_
l_canswer_text = {
    'ru': "👋🏽 <b>Жми</b> на ✅/☑️ чтобы <b>Вкл/Выкл</b> режим авто-ответа на текстовые сообщения с помощью нейросети",
    'en': "👋🏽 <b>Press</b> ✅/☑️ to <b>turn on/off</b> auto-reply to text messages using neural network",
    'es': "👋🏽 <b>Presione</b> ✅/☑️ para <b>activar/desactivar</b> la respuesta automática a los mensajes de texto usando la red neuronal",
    'fr': "👋🏽 <b>Appuyez sur</b> ✅/☑️ pour <b>activer/désactiver</b> la réponse automatique aux messages texte à l'aide du réseau neuronal",
    'zh': "👋🏽<b>按</b>✅/☑️ 使用神经网络<b>打开/关闭</b>自动回复短信",
    'ar': "👋🏽 <b>اضغط</b> <b>على ✅ / ☑️ لتشغيل / إيقاف</b> الرد التلقائي على الرسائل النصية باستخدام الشبكة العصبية",
}
# endregion


# region cpayment_
l_cpayment_alert = {
    'ru': "💳️ Нужно ⚙️Настроить хотя бы один платежный токен",
    'en': "💳️ You need to ⚙️Set up at least one payment token",
    'es': "💳️ Debes ⚙️Configurar al menos un token de pago",
    'fr': "💳️ Vous devez ⚙️Configurer au moins un jeton de paiement",
    'zh': "💳️您需要⚙️设置至少一个支付令牌",
    'ar': "💳️ تحتاج إلى إعداد رمز دفع واحد على الأقل",
}
l_cpayment_text = {
    'ru': "💳️ <b>Жми</b> на ✅/☑️ чтобы <b>Вкл/Выкл</b> платежи в @{0}-боте\n\n👩🏽‍💻 <b>Текущий</b> платежный токен:\n{1}",
    'en': "💳️ <b>Click</b> on ✅/☑️ to <b>turn on/off</b> payments in @{0}-bot\n\n👩🏽‍💻 <b>Current</b> payment token:\n{1}",
    'es': "💳️ <b>Haz clic</b> en ✅/☑️ para <b>activar o desactivar</b> los pagos en @{0}-bot\n\n👩🏽‍💻 Token de pago <b>actual</b> :\n{1}",
    'fr': "💳️ <b>Cliquez</b> sur ✅/☑️ pour <b>activer/désactiver</b> les paiements dans @{0}-bot\n\n👩🏽‍💻 Jeton de paiement <b>actuel</b> :\n{1}",
    'zh': "💳️<b>点击</b>✅/☑️ 在@{0}-bot 中<b>打开/关闭</b>支付\n\n👩🏽‍💻<b>当前</b>支付令牌：\n{1}",
    'ar': "💳️ <b>انقر</b> على ✅ / ☑️ <b>لتشغيل / إيقاف</b> المدفوعات في @ {0} -bot\n\n👩🏽‍💻 رمز الدفع <b>الحالي</b> :\n{1}",
}
l_cpayment_token = {
    'ru': "💳️ <b>Вставь</b> платежный токен, полученный из @BotFather-бота\n\n👩🏽‍💻 <b>Например</b>\n401643678:7049d0b3-f0267096c4a1\n\n👩🏽‍💻 <b>Текущий</b> токен:\n{0}",
    'en': "💳️ <b>Insert</b> payment token received from @BotFather -bot\n\n👩🏽‍💻 <b>For example</b>\n401643678:7049d0b3-f0267096c4a1\n\n👩🏽‍💻 <b>Current</b> token:\n{0}",
    'es': "💳️ <b>Inserte</b> el token de pago recibido de @BotFather -bot\n\n👩🏽‍💻 <b>Por ejemplo,</b>\n401643678:7049d0b3-f0267096c4a1\n\n👩🏽‍💻 Token <b>actual</b> :\n{0}",
    'fr': "💳️ <b>Insérez</b> le jeton de paiement reçu de @BotFather -bot\n\n👩🏽‍💻 <b>Par exemple</b>\n401643678:7049d0b3-f0267096c4a1\n\n👩🏽‍💻 Jeton <b>actuel</b> :\n{0}",
    'zh': "💳️<b>插入</b>从@BotFather -bot 收到的支付令牌\n\n👩🏽‍💻<b>例如</b>\n401643678:7049d0b3-f0267096c4a1\n\n👩🏽‍💻<b>当前</b>令牌：\n{0}",
    'ar': "💳️ <b>أدخل</b> رمز الدفع المستلم من @BotFather -bot\n\n👩🏽‍💻 <b>على سبيل المثال</b>\n401643678:7049d0b3-f0267096c4a1\n\n👩🏽‍💻 الرمز <b>المميز الحالي</b> :\n{0}",
}
l_cpayment_done = {
    'ru': "💳️ <b>Готово!</b>\n\n👩🏽‍💻 <b>Текущий</b> платежный токен для @{0}-бота:\n\n{1}",
    'en': "💳️ <b>Done!</b>\n\n👩🏽‍💻 <b>Current</b> payment token for @{0}-bot:\n\n{1}",
    'es': "💳️ <b>Listo!</b>\n\n👩🏽‍💻 Token de pago <b>actual</b> para @{0}-bot:\n\n{1}",
    'fr': "💳️ <b>C&#x27;est fait !</b>\n\n👩🏽‍💻 Jeton de paiement <b>actuel</b> pour @{0}-bot :\n\n{1}",
    'zh': "💳️<b>完成！</b>\n\n👩🏽‍💻 @{0}-bot 的<b>当前</b>支付令牌：\n\n{1}",
    'ar': "💳️ <b>انتهى!</b>\n\n👩🏽‍💻 رمز الدفع <b>الحالي</b> لـ @ {0} -bot:\n\n{1}",
}
# endregion


# region cintegration_
l_cintegration_alert = {
    'ru': "🗝️ Нужно ⚙️Настроить ССЫЛКУ доступа",
    'en': "🗝️ You need to ⚙️Set up an access link",
    'es': "🗝️ Debes ⚙️Configurar un enlace de acceso",
    'fr': "🗝️ Vous devez ⚙️Configurer un lien d'accès",
    'zh': "🗝️您需要⚙️设置访问链接",
    'ar': "🗝️ تحتاج إلى إعداد ارتباط وصول",
}
l_cintegration_text = {
    'ru': "🗝️ <b>Жми</b> на ✅/☑️ чтобы <b>Вкл/Выкл</b> интеграцию базы пользователей с <i><b>google</b>-crm/<b>airtable</b>-crm</i>\n\n👩🏽‍💻 Например, опция [<b>{0}</b>] означает возможность интеграции базы пользователей с <i>google-crm</i>",
    'en': "🗝️ <b>Click</b> on ✅/☑️ to <b>enable/disable</b> integration of user base with <i><b>google</b> -crm/ <b>airtable</b> -crm</i>\n\n👩🏽‍💻 For example, option [<b>{0}</b>] means the ability to integrate user base with <i>google-crm</i>",
    'es': "🗝️ <b>Haga clic</b> en ✅/☑️ para <b>habilitar/deshabilitar</b> la integración de la base de usuarios con <i><b>google</b> -crm/ <b>airtable</b> -crm</i>\n\n👩🏽‍💻 Por ejemplo, la opción [<b>{0}</b>] significa la capacidad de integrar la base de usuarios con <i>google-crm</i>",
    'fr': "🗝️ <b>Cliquez</b> sur ✅/☑️ pour <b>activer/désactiver</b> l&#x27;intégration de la base d&#x27;utilisateurs avec <i><b>google</b> -crm/ <b>airtable</b> -crm</i>\n\n👩🏽‍💻 Par exemple, l&#x27;option [<b>{0}</b>] signifie la possibilité d&#x27;intégrer la base d&#x27;utilisateurs avec <i>google-crm</i>",
    'zh': "🗝️<b>点击</b>✅/☑️<b>启用/禁用</b>用户群与<i><b>google</b> -crm/ <b>airtable</b> -crm</i>\n\n👩🏽‍💻 例如，选项 [<b>{0}</b>] 表示能够将用户群与<i>google-crm</i>集成",
    'ar': "🗝️ <b>انقر</b> على ✅ / ☑️ <b>لتمكين / تعطيل</b> تكامل قاعدة المستخدمين مع <i><b>google</b> -crm / <b>airtable</b> -crm</i>\n\n👩🏽‍💻 على سبيل المثال ، الخيار [<b>{0}</b>] يعني القدرة على تكامل قاعدة المستخدمين مع <i>google-crm</i>",
}

l_cintegration_google_on = {
    'ru': "✅☑Вкл google-crm",
    'en': "✅☑Includes google-crm",
    'es': "✅☑Incluye google-crm",
    'fr': "✅☑Inclut google-crm",
    'zh': "✅☑包括谷歌客户关系管理",
    'ar': "✅☑ يشمل google-crm",
}
l_cintegration_google_off = {
    'ru': "☑️☐Выкл google-crm",
    'en': "☑️☐Выкл google-crm",
    'es': "☑️☐Выкл google-crm",
    'fr': "☑️☐Выкл google-crm",
    'zh': "☑️☐Выкл 谷歌客户关系管理",
    'ar': "☑️☐Выкл google-crm",
}
l_cintegration_airtable_on = {
    'ru': "✅☑Вкл airtable-crm",
    'en': "✅☑Includes airtable-crm",
    'es': "✅☑Incluye airtable-crm",
    'fr': "✅☑Comprend airtable-crm",
    'zh': "✅☑包括 airtable-crm",
    'ar': "✅☑ يشمل airtable-crm",
}
l_cintegration_airtable_off = {
    'ru': "☑️☐Выкл airtable-crm",
    'en': "☑️☐Выкл airtable-crm",
    'es': "☑️☐Выкл airtable-crm",
    'fr': "☑️☐Выкл airtable-crm",
    'zh': "☑️☐Выкл airtable-crm",
    'ar': "☑️☐Выкл airtable-crm",
}

l_cintegration_google = {
    'ru': "🗝️ <b>Вставь ссылку</b> на пустую google-таблицу (<i>с открытым доступом для редактирования</i>) для интеграции с базой пользователей @{0}-бота\n\n👩🏽‍💻 <b>Например</b>, https://docs.google.com/spreadsheets/d/1aWGYLL0WWZP/edit?usp=sharing\n\n👩🏽‍💻 <b>Текущая</b> ссылка:\n{1}",
    'en': "🗝️ <b>Insert a link</b> to an empty google spreadsheet ( <i>with open access for editing</i> ) to integrate with the @{0}-bot user base\n\n👩🏽‍💻 <b>For example</b> , https://docs.google.com/spreadsheets/d/1aWGYLL0WWZP/edit?usp=sharing\n\n👩🏽‍💻 <b>Current</b> URL:\n{1}",
    'es': "🗝️ <b>Inserta un enlace</b> a una hoja de cálculo de Google vacía ( <i>con acceso abierto para editar</i> ) para integrarla con la base de usuarios de @{0}-bot\n\n👩🏽‍💻 <b>Por ejemplo</b> , https://docs.google.com/spreadsheets/d/1aWGYLL0WWZP/edit?usp=sharing\n\n👩🏽‍💻 URL <b>actual</b> :\n{1}",
    'fr': "🗝️ <b>Insérez un lien</b> vers une feuille de calcul Google vide ( <i>avec accès ouvert pour modification</i> ) à intégrer à la base d&#x27;utilisateurs @{0}-bot\n\n👩🏽‍💻 <b>Par exemple</b> , https://docs.google.com/spreadsheets/d/1aWGYLL0WWZP/edit?usp=sharing\n\n👩🏽‍💻 URL <b>actuelle</b> :\n{1}",
    'zh': "🗝️<b>插入指向空谷歌电子表格的链接</b>（<i>开放编辑权限</i>）以与@{0}-bot 用户群集成\n\n👩🏽‍💻<b>例如</b>，https: https://docs.google.com/spreadsheets/d/1aWGYLL0WWZP/edit?usp=sharing\n\n👩🏽‍💻<b>当前</b>网址：\n{1}",
    'ar': "🗝️ <b>أدخل رابطًا</b> إلى جدول بيانات google فارغ ( <i>مع وصول مفتوح للتعديل</i> ) للتكامل مع @ {0} -bot user base\n\n👩🏽‍💻 <b>على سبيل المثال</b> ، https://docs.google.com/spreadsheets/d/1aWGYLL0WWZP/edit?usp=sharing\n\n👩🏽‍💻 عنوان URL <b>الحالي</b> :\n{1}",
}
l_cintegration_airtable = {
    'ru': "🗝️ <b>Вставь ссылку</b> на пустую airtable-таблицу (<i>с открытым доступом для редактирования и любого e-mail</i>) для интеграции с базой пользователей @{0}-бота\n\n👩🏽‍💻 <b>Например</b>, https://airtable.com/invite/l?inviteId=inv4VGM&inviteToken=f1d31f9aba6b&utm_medium=email\n\n👩🏽‍💻 <b>Текущая</b> ссылка:\n{1}",
    'en': "🗝️ <b>Insert a link</b> to an empty airtable-table ( <i>with open access for editing and any e-mail</i> ) for integration with the @{0}-bot user base\n\n👩🏽‍💻 <b>For example</b> , https://airtable.com/invite/l?inviteId=inv4VGM&amp;inviteToken=f1d31f9aba6b&amp;utm_medium=email\n\n👩🏽‍💻 <b>Current</b> URL:\n{1}",
    'es': "🗝️ <b>Inserte un enlace</b> a una mesa de aire vacía ( <i>con acceso abierto para editar y cualquier correo electrónico</i> ) para la integración con la base de usuarios de @{0}-bot\n\n👩🏽‍💻 <b>Por ejemplo</b> , https://airtable.com/invite/l?inviteId=inv4VGM&amp;inviteToken=f1d31f9aba6b&amp;utm_medium=email\n\n👩🏽‍💻 URL <b>actual</b> :\n{1}",
    'fr': "🗝️ <b>Insérez un lien</b> vers une table airtable vide ( <i>avec un accès ouvert pour l&#x27;édition et tout e-mail</i> ) pour l&#x27;intégration avec la base d&#x27;utilisateurs @{0}-bot\n\n👩🏽‍💻 <b>Par exemple</b> , https://airtable.com/invite/l?inviteId=inv4VGM&amp;inviteToken=f1d31f9aba6b&amp;utm_medium=email\n\n👩🏽‍💻 URL <b>actuelle</b> :\n{1}",
    'zh': "🗝️<b>插入一个指向空的 airtable-table 的链接</b>（<i>具有编辑和任何电子邮件的开放访问权限</i>）以与 @{0}-bot 用户群集成\n\n👩🏽‍💻<b>例如</b>， https://airtable.com/invite/l?inviteId=inv4VGM&amp;inviteToken=f1d31f9aba6b&amp;utm_medium=email\n\n👩🏽‍💻<b>当前</b>网址：\n{1}",
    'ar': "🗝️ <b>أدخل ارتباطًا</b> إلى جدول airtable فارغ ( <i>مع وصول مفتوح للتحرير وأي بريد إلكتروني</i> ) للتكامل مع @ {0} -bot user base\n\n👩🏽‍💻 <b>على سبيل المثال</b> ، https://airtable.com/invite/l?inviteId=inv4VGM&amp;inviteToken=f1d31f9aba6b&amp;utm_medium=email <b>؟</b>",
}
l_cintegration_done = {
    'ru': "🗝️ <b>Готово!</b>\n\n👩🏽‍💻 <b>Текущая</b> ссылка:\n{0}",
    'en': "🗝️ <b>Done!</b>\n\n👩🏽‍💻 <b>Current</b> URL:\n{0}",
    'es': "🗝️ <b>Listo!</b>\n\n👩🏽‍💻 URL <b>actual</b> :\n{0}",
    'fr': "🗝️ <b>C&#x27;est fait !</b>\n\n👩🏽‍💻 URL <b>actuelle</b> :\n{0}",
    'zh': "🗝️<b>完成！</b>\n\n👩🏽‍💻<b>当前</b>网址：\n{0}",
    'ar': "🗝️ <b>انتهى!</b>\n\n👩🏽‍💻 عنوان URL <b>الحالي</b> :\n{0}",
}
# endregion


# region cnotification_
l_cnotification_text = {
    'ru': "💬 <b>Жми</b> на ✅/☑️ чтобы <b>Вкл/Выкл</b> оповещения о <i><b>/start-stop</b> запуске/блокировке бота пользователем и попадании пользователя в <b>/ban</b>-список/<b>нажатии</b> на кнопки пользователем/<b>диалоге</b> с администраторами/<b>всех</b> действиях пользователя</i>\n\n👩🏽‍💻 Например, опция [<b>{0}</b>] означает показ сообщений от пользователя администраторам бота (/admin) с возможностью реплай-ответа на сообщения",
    'en': "💬 <b>Click</b> on ✅/☑️ to <b>turn on/off</b> notifications about <i><b>/start-stop</b> launching/blocking the bot by the user and getting the user into the <b>/ban</b> -list/ <b>pressing</b> buttons by the user/ <b>dialog</b> with administrators/ <b>all</b> user actions</i>\n\n👩🏽‍💻 For example, the option [<b>{0}</b>] means показ messages from the user to bot administrators (/admin) with the ability to replay response to messages",
    'es': "💬 <b>Haga clic</b> en ✅/☑️ para <b>activar/desactivar</b> las notificaciones sobre <i><b>/iniciar y detener</b> el lanzamiento/bloqueo del bot por parte del usuario y colocar al usuario en la <b>/lista de prohibición</b> / <b>pulsar</b> botones por parte del usuario/ <b>diálogo</b> con los administradores/ <b>todas</b> las acciones del usuario \</i> n\n👩🏽‍💻 Por ejemplo, la opción [<b>{0}</b>] significa показ los mensajes del usuario a los administradores del bot (/admin) con la capacidad de reproducir la respuesta a los mensajes.",
    'fr': "💬 <b>Cliquez</b> sur ✅/☑️ pour <b>activer/désactiver</b> les notifications sur <i><b>/start-stop</b> lancer/bloquer le bot par l&#x27;utilisateur et faire entrer l&#x27;utilisateur dans la <b>/banni</b> -liste/ <b>appuyer sur</b> les boutons par l&#x27;utilisateur/ <b>dialogue</b> avec les administrateurs/ <b>toutes</b> les actions de l&#x27;utilisateur \</i> n\n👩🏽‍💻 Par exemple, l&#x27;option [<b>{0}</b>] signifie показ les messages de l'utilisateur aux administrateurs du bot (/admin) avec la possibilité de rejouer la réponse aux messages",
    'zh': "💬<b>单击</b>✅/☑️ 以<b>打开/关闭</b><i>关于<b>/start-stop</b>启动/阻止用户的机器人并让用户进入<b>/ban</b>列表/用户<b>按下</b>按钮/与管理员<b>对话</b>/<b>所有</b>用户操作的通知 \</i> n\n👩🏽‍💻 例如，选项 [<b>{0}</b>] 表示将用户的消息показ给机器人管理员 (/admin)，并能够重播对消息的响应",
    'ar': "💬 <b>انقر</b> فوق ✅ / ☑️ <b>لتشغيل / إيقاف تشغيل</b> <i>الإشعارات حول <b>/ بدء - إيقاف</b> تشغيل / حظر الروبوت من قبل المستخدم وإدخال المستخدم في أزرار <b>/ قائمة الحظر</b> / <b>الضغط</b> بواسطة المستخدم / <b>الحوار</b> مع المسؤولين / <b>جميع</b> إجراءات المستخدم \</i> n\n👩🏽‍💻 على سبيل المثال ، الخيار [<b>{0}</b>] يعني показ الرسائل من المستخدم إلى المشرفين (/ admin) مع إمكانية إعادة الرد على الرسائل",
}
l_cnotification_start_on = {
    'ru': "✅☑Вкл /start-stop-/ban",
    'en': "✅☑On /start-stop-/ban",
    'es': "✅☑Activar/iniciar-detener-/prohibir",
    'fr': "✅☑On /start-stop-/interdiction",
    'zh': "✅☑开/启-停-/禁",
    'ar': "✅☑ On / start-stop- / ban",
}
l_cnotification_start_off = {
    'ru': "☑️☐Выкл /start-stop-/ban",
    'en': "☑️☐Выкл /start-stop-/ban",
    'es': "☑️☐Выкл /start-stop-/ban",
    'fr': "☑️☐Выкл /start-stop-/ban",
    'zh': "☑️☐Выкл /开始-停止-/禁止",
    'ar': "☑️☐Выкл / start-stop- / الحظر",
}
l_cnotification_push_on = {
    'ru': "✅☑Вкл нажатие на кнопки",
    'en': "✅☑On pressing buttons",
    'es': "✅☑Al presionar botones",
    'fr': "✅☑En appuyant sur les boutons",
    'zh': "✅☑按下按钮",
    'ar': "✅☑ عند الضغط على الأزرار",
}
l_cnotification_push_off = {
    'ru': "☑️☐Выкл нажатие на кнопки",
    'en': "☑️☐Off pressing the buttons",
    'es': "☑️☐Apagado presionando los botones",
    'fr': "☑️☐Off en appuyant sur les boutons",
    'zh': "☑️☐关闭按钮",
    'ar': "☑️☐ إيقاف الضغط على الأزرار",
}

l_cnotification_dialog_on = {
    'ru': "✅☑Вкл диалог",
    'en': "✅☑Dialogue included",
    'es': "✅☑Diálogo incluido",
    'fr': "✅☑Dialogue inclus",
    'zh': "✅☑包括对话",
    'ar': "✅☑ متضمن الحوار",
}
l_cnotification_dialog_off = {
    'ru': "☑️☐Выкл диалог",
    'en': "☑️☐Disable dialogue",
    'es': "☑️☐Desactivar diálogo",
    'fr': "☑️☐Désactiver les dialogues",
    'zh': "☑️☐禁用对话",
    'ar': "☑️☐ تعطيل الحوار",
}
l_cnotification_all_on = {
    'ru': "✅☑Вкл все действия",
    'en': "✅☑Including all actions",
    'es': "✅☑Incluyendo todas las acciones",
    'fr': "✅☑Incluant toutes les actions",
    'zh': "✅☑包括所有动作",
    'ar': "✅☑ بما في ذلك جميع الإجراءات",
}
l_cnotification_all_off = {
    'ru': "☑️☐Выкл все действия",
    'en': "☑️☐Off all actions",
    'es': "☑️☐Desactivar todas las acciones",
    'fr': "☑️☐Désactiver toutes les actions",
    'zh': "☑️☐关闭所有操作",
    'ar': "☑️☐ إيقاف جميع الإجراءات",
}

l_cnotification_dialog = {
    'ru': "💬 <b>Пользователь</b>: {0} [<b>id</b>={1}] написал в @{2}-боте:",
    'en': "💬 <b>User</b> : {0} [<b>id</b> = {1}] wrote in @{2}-bot:",
    'es': "💬 <b>Usuario</b> : {0} [<b>id</b> = {1}] escribió en @{2}-bot:",
    'fr': "💬 <b>Utilisateur</b> : {0} [<b>id</b> = {1}] a écrit dans @{2}-bot :",
    'zh': "💬<b>用户</b>：{0} [<b>id</b> = {1}] 在@{2}-bot 中写道：",
    'ar': "💬 <b>المستخدم</b> : {0} [<b>id</b> = {1}] كتب في @ {2} -bot:",
}
# endregion


# region cuser_
l_cuser_text2 = {
    'ru': "👥 <b>Жми</b> на ✅/☑️ чтобы <b>Вкл/Выкл</b> <i>замену голосовых/телескопов на <b>audio/video</b> (*рекомендуется, если premium-пользователи установили такой запрет)/сервисные <b>статусы</b> бота (печатает..записывает видео..)/ведение списка <b>/utm-рефералов</b></i>\n\n👩🏽‍💻 <b>Команды</b>:\n/cmd - все команды\n/parse - вывести всех пользователей\n/utm - вывести utm-рефералов\n/link - создать реферальную /utm ссылку",
    'en': "👥 <b>Click</b> on ✅/☑️ to <b>enable/disable</b> <i>the replacement of voice/telescopes with <b>audio/video</b> (*recommended if</i> premium <i>users have set such a ban)/bot service <b>statuses</b> (prints..records video..)/maintaining a list of <b>/utm referrals</b></i>\n\n👩🏽‍💻 <b>Commands</b> :\n/cmd - all commands\n/parse - display all users\n/utm - display utm referrals\n/link - create a referral /utm link",
    'es': "👥 <b>Haga clic</b> en ✅/☑️ para <b>habilitar/deshabilitar</b> <i>el reemplazo de voz/telescopios con <b>audio/video</b> (*recomendado si</i> los usuarios premium <i>han establecido dicha prohibición)/ <b>estados</b> de servicio de bot (imprime... graba video...)/mantiene una lista de <b>/utm referencias</b></i>\n\n👩🏽‍💻 <b>Comandos</b> :\n/cmd - todos los comandos\n/parse - mostrar todos los usuarios\n/utm - mostrar referencias utm\n/link - crear un enlace de referencia /utm",
    'fr': "👥 <b>Cliquez</b> sur ✅/☑️ pour <b>activer/désactiver</b> <i>le remplacement de la voix/des télescopes par <b>l&#x27;audio/la vidéo</b> (*recommandé si</i> les utilisateurs premium <i>ont défini une telle interdiction)/ <b>les statuts</b> du service de bot (imprime..enregistre la vidéo..)/maintient une liste de <b>/références utm</b></i>\n\n👩🏽‍💻 <b>Commandes</b> :\n/cmd - toutes les commandes\n/parse - afficher tous les utilisateurs\n/utm - afficher les références utm\n/lien - créer une référence /lien utm",
    'zh': "👥<b>点击</b>✅/☑️<b>启用/禁用</b><i>用音频<b>/视频</b>替换语音/望远镜（*如果</i>premium<i>用户设置了此类禁令，则推荐）/机器人服务<b>状态</b>（打印..记录视频..）/维护列表<b>/utm referrals</b></i>\n\n👩🏽‍💻<b>命令</b>：\n/cmd - 所有命令\n/parse - 显示所有用户\n/utm - 显示 utm referrals\n/link - 创建一个推荐 /utm 链接",
    'ar': "👥 <b>انقر</b> فوق ✅ / ☑️ <b>لتمكين / تعطيل</b> <i>استبدال الصوت / التلسكوبات بالصوت <b>/ الفيديو</b> (* يوصى به إذا</i> قام المستخدمون premium <i>بتعيين مثل هذا الحظر) / <b>حالات</b> خدمة الروبوت (طباعة .. تسجيلات فيديو ..) / الاحتفاظ بقائمة من <b>إحالات / utm</b></i>\n\n👩🏽‍💻 <b>الأوامر</b> :\n/ cmd - كافة الأوامر\n/ parse - عرض كافة المستخدمين\n/ utm - عرض إحالات utm\n/ link - إنشاء ارتباط إحالة / utm",
}
l_cuser_restricted_on = {
    'ru': "✅☑Вкл audio/video замена",
    'en': "✅☑Includes audio/video replacement",
    'es': "✅☑Incluye reemplazo de audio/video",
    'fr': "✅☑Comprend le remplacement audio/vidéo",
    'zh': "✅☑包括音频/视频替换",
    'ar': "✅☑ يشمل استبدال الصوت / الفيديو",
}
l_cuser_restricted_off = {
    'ru': "☑️☐Выкл audio/video замена",
    'en': "☑️☐Off audio/video replacement",
    'es': "☑️☐Reemplazo de audio/video apagado",
    'fr': "☑️☐Off remplacement audio/vidéo",
    'zh': "☑️☐关闭音频/视频替换",
    'ar': "☑️☐ إيقاف استبدال الصوت / الفيديو",
}
l_cuser_status_on = {
    'ru': "✅☑Вкл сервисные статусы",
    'en': "✅☑On service statuses",
    'es': "✅☑Sobre estados de servicio",
    'fr': "✅☑Sur les états de service",
    'zh': "✅☑关于服务状态",
    'ar': "✅☑على حالات الخدمة",
}
l_cuser_status_off = {
    'ru': "☑️☐Выкл сервисные статусы",
    'en': "☑️☐Off service statuses",
    'es': "☑️☐Estados de servicio desactivados",
    'fr': "☑️☐Hors statuts de service",
    'zh': "☑️☐关闭服务状态",
    'ar': "☑️☐ إيقاف حالات الخدمة",
}
l_cuser_utm_on = {
    'ru': "✅☑Вкл utm-рефералы",
    'en': "✅☑On utm referrals",
    'es': "✅☑Sobre referencias utm",
    'fr': "✅☑Sur les références utm",
    'zh': "✅☑关于 utm 推荐",
    'ar': "✅☑On الإحالات UTM",
}
l_cuser_utm_off = {
    'ru': "☑️☐Выкл utm-рефералы",
    'en': "☑️☐Off utm referrals",
    'es': "☑️☐Off referencias utm",
    'fr': "☑️☐Hors références utm",
    'zh': "☑️☐关闭utm推荐",
    'ar': "☑️☐ Off إحالات UTM",
}
l_bot_is_off = {
    'ru': "👩🏽‍💻 <b>@{0}-бот</b> выключен\n\n/on - включить бот",
    'en': "👩🏽‍💻 <b>@{0}-bot</b> off\n\n/on - enable bot",
    'es': "👩🏽‍💻 <b>@{0}-bot</b> apagado\n\n/encendido - habilitar bot",
    'fr': "👩🏽‍💻 <b>@{0}-bot</b> off\n\n/on - activer le bot",
    'zh': "👩🏽‍💻 <b>@{0}-bot</b> off\n\n/on - 启用机器人",
    'ar': "👩🏽‍💻 <b>@ {0} -bot</b> off\n\n/ on - قم بتمكين الروبوت",
}
l_cuser_utm = {
    'ru': "👥 <b>Готово!</b> <b>/utm-список</b> реферальных пользователей @{0}-бота\n\n👩🏽‍💻 <b>Вывести</b> рефералов конкретного пользователя можно командой:\n/utm id или /utm @username\n\n👩🏽‍💻 <b>Текущее</b> число utm-рефералов: <u>{1}</u>",
    'en': "👥 <b>Done!</b> <b>/utm-list</b> of referral users of @{0}-bot\n\n👩🏽‍💻 You can <b>display</b> referrals of a specific user with the command:\n/utm id or /utm @username\n\n👩🏽‍💻 <b>Current</b> number of utm-referrals : <u>{1}</u>",
    'es': "👥 <b>Listo!</b> <b>/utm-lista</b> de usuarios de referencia de @{0}-bot\n\n👩🏽‍💻 Puede <b>mostrar</b> referencias de un usuario específico con el comando:\n/utm id o /utm @username\n\n👩🏽 ‍💻 Número <b>actual</b> de referencias utm: <u>{1}</u>",
    'fr': "👥 <b>C&#x27;est fait !</b> <b>/utm-list</b> des utilisateurs référents de @{0}-bot\n\n👩🏽‍💻 Vous pouvez <b>afficher</b> les références d&#x27;un utilisateur spécifique avec la commande :\n/utm id ou /utm @username\n\n👩🏽 ‍💻 Nombre <b>actuel</b> de références utm : <u>{1}</u>",
    'zh': "👥<b>完成！</b> <b>/utm-@{0}-bot 的推荐用户列表</b>\n\n👩🏽‍💻 您可以使用以下命令<b>显示</b>特定用户的推荐：\n/utm id或/utm @username\n\n👩🏽 ‍💻<b>当前</b>的 utm-referrals 数量： <u>{1}</u>",
    'ar': "👥 <b>انتهى!</b> <b>/ utm-list</b> لمستخدمي الإحالة لـ @ {0} -bot\n\n👩🏽‍💻 يمكنك <b>عرض</b> إحالات مستخدم معين بالأمر:\n/utm id أو /utm @username\n\n👩🏽 ‍💻 العدد <b>الحالي</b> لإحالات UTM: <u>{1}</u>",
}
l_cuser_link_done = {
    'ru': "👥 <b>Готово!</b> Реферальная /utm ссылка на @{0}-бота (размести ее на любой площадке, чтобы понимать, что пользователи перешли в бота с этой площадки):\n\n{1}",
    'en': "👥 <b>Done!</b> Referral /utm link to the @{0}-bot (place it on any site to understand that users have switched to the bot from this site):\n\n{1}",
    'es': "👥 <b>Listo!</b> Enlace de referencia /utm al @{0}-bot (colóquelo en cualquier sitio para comprender que los usuarios han cambiado al bot desde este sitio):\n\n{1}",
    'fr': "👥 <b>C&#x27;est fait !</b> Lien de parrainage /utm vers le @{0}-bot (placez-le sur n&#x27;importe quel site pour comprendre que les utilisateurs sont passés au bot depuis ce site) :\n\n{1}",
    'zh': "👥<b>完成！</b> @{0}-bot 的引荐 /utm 链接（将其放在任何站点上以了解用户已从该站点切换到该 bot）：\n\n{1}",
    'ar': "👥 <b>انتهى!</b> رابط الإحالة / utm إلى @ {0} -bot (ضعه على أي موقع لفهم أن المستخدمين قد تحولوا إلى الروبوت من هذا الموقع):\n\n{1}",
}
l_cuser_link_start = {
    'ru': "👥 <b>Придумай</b> название для /utm ссылки (*после ?start= может быть <u>любое</u> имя источника из цифр и/или латинских букв)\n\n👩🏽‍💻 <b>Например</b>, ссылки /utm-рефералов для отслеживания:\nhttps://t.me/{0}?start={1} - <i>реферальных пользователей</i> {1}-<i>пользователя</i>\nhttps://t.me/{0}?start=instagram - <i>пользователей из instagram</i>",
    'en': "👥 <b>Think of</b> a name for the /utm link (*after ?start= there can be <u>any</u> source name from numbers and/or Latin letters)\n\n👩🏽‍💻 <b>For example</b> , /utm referral links for tracking:\nhttps://t .me/{0}?start={1} - <i>referral users</i> {1} - <i>user</i>\nhttps://t.me/{0}?start=instagram - <i>users from instagram</i>",
    'es': "👥 <b>Piense en</b> un nombre para el enlace /utm (*después de ?start= puede haber <u>cualquier</u> nombre de fuente de números y/o letras latinas)\n\n👩🏽‍💻 <b>Por ejemplo</b> , enlaces de referencia /utm para el seguimiento:\nhttps ://t .me/{0}?start={1} - <i>usuarios de referencia</i> {1} - <i>usuario</i>\nhttps://t.me/{0}?start=instagram - <i>usuarios de instagram</i>",
    'fr': "👥 <b>Pensez à</b> un nom pour le lien /utm (*après ?start= il peut y avoir <u>n&#x27;importe quel</u> nom de source à partir de chiffres et/ou de lettres latines)\n\n👩🏽‍💻 <b>Par exemple</b> , les liens de référence /utm pour le suivi :\nhttps ://t .me/{0}?start={1} - <i>utilisateurs de référence</i> {1} - <i>utilisateur</i>\nhttps://t.me/{0}?start=instagram - <i>utilisateurs d&#x27;instagram</i>",
    'zh': "👥<b>为 /utm 链接想</b>一个名字（*在?start=之后可以有<u>任何</u>来自数字和/或拉丁字母的源名称）\n\n👩🏽‍💻<b>例如</b>，用于跟踪的 /utm 推荐链接：\nhttps ://t .me/{0}?start={1} -<i>推荐用户</i>{1} -<i>用户</i>\nhttps://t.me/{0}?start=instagram -<i>来自 instagram 的用户</i>",
    'ar': "👥 <b>فكر في</b> اسم ارتباط / utm (* after ?start= يمكن أن يكون هناك <u>أي</u> اسم مصدر من الأرقام و / أو الأحرف اللاتينية)\n\n👩🏽‍💻 <b>على سبيل المثال</b> ، روابط الإحالة / utm للتتبع:\nhttps : // t .me / {0}؟ start = {1} - <i>المستخدمون المحالون</i> {1} - <i>المستخدم</i>\nhttps: //t.me/ {0}؟ start = instagram - <i>المستخدمون من instagram</i>",
}
l_promo_done = {
    'ru': "👩🏽‍💻 <b>Готово!</b>\n\n👩🏽‍💻 <i>Текущий /promo-код</i>:\n{0}\n👩🏽‍💻 <i>Удалить /promo-код</i>:\n/promo 0",
    'en': "👩🏽‍💻 <b>Done!</b>\n\n👩🏽‍💻 <i>Current /promo code</i> :\n{0}\n👩🏽‍💻 <i>Delete /promo code</i> :\n/promo 0",
    'es': "👩🏽‍💻 <b>Listo!</b>\n\n👩🏽‍💻 <i>Código /promocional actual</i> :\n{0}\n👩🏽‍💻 <i>Eliminar código /promocional</i> :\n/promo 0",
    'fr': "👩🏽‍💻 <b>C&#x27;est fait !</b>\n\n👩🏽‍💻 <i>Code /promo actuel</i> :\n{0}\n👩🏽‍💻 <i>Supprimer le code /promo</i> :\n/promo 0",
    'zh': "👩🏽‍💻<b>完成！</b>\n\n👩🏽‍💻<i>当前/促销代码</i>：\n{0}\n👩🏽‍💻<i>删除/促销代码</i>：\n/promo 0",
    'ar': "👩🏽‍💻 <b>انتهى!</b>\n\n👩🏽‍💻 <i>الرمز الحالي / الترويجي</i> :\n{0}\n👩🏽‍💻 <i>حذف / الرمز الترويجي</i> :\n/promo 0",
}
l_promo_start = {
    'ru': "👩🏽‍💻 <b>Введи</b> /promo-код для @{0}-бота:\n\n👩🏽‍💻 <i>Текущий /promo-код</i>:\n{1}\n👩🏽‍💻 <i>Удалить /promo-код</i>:\n/promo 0",
    'en': "👩🏽‍💻 <b>Enter</b> /promo code for @{0}-bot:\n\n👩🏽‍💻 <i>Current /promo code</i> :\n{1}\n👩🏽‍💻 <i>Delete /promo code</i> :\n/promo 0",
    'es': "👩🏽‍💻 <b>Ingresa el</b> /código de promoción para @{0}-bot:\n\n👩🏽‍💻 <i>Actual /código de promoción</i> :\n{1}\n👩🏽‍💻 <i>Eliminar /código de promoción</i> :\n/promo 0",
    'fr': "👩🏽‍💻 <b>Entrez</b> /code promo pour @{0}-bot :\n\n👩🏽‍💻 <i>Code /code promo actuel</i> :\n{1}\n👩🏽‍💻 <i>Supprimer /code promo</i> :\n/promo 0",
    'zh': "👩🏽‍💻<b>输入</b>@{0}-bot 的 /promo 代码：\n\n👩🏽‍💻<i>当前 /promo 代码</i>：\n{1}\n👩🏽‍💻<i>删除 /promo 代码</i>：\n/promo 0",
    'ar': "👩🏽‍💻 <b>أدخل</b> / الرمز الترويجي لـ @ {0} -bot:\n\n👩🏽‍💻 <i>الرمز الحالي / الترويجي</i> :\n{1}\n👩🏽‍💻 <i>حذف / الرمز الترويجي</i> :\n/promo 0",
}
# endregion


# region cadmin_
l_cadmin_text2 = {
    'ru': "👮🏽 <b>Жми</b> на ✅/☑️ чтобы <b>Вкл/Выкл</b> <i>доступ добавленных администраторов к функционалу <b>[💬 Оповещения]</b></i>\n\n👩🏽‍💻 <b>Команды</b>:\n/cmd - все команды\n/admin - добавить/удалить администратора\n/parse - вывести всех пользователей",
    'en': "👮🏽 <b>Click</b> on ✅/☑️ to <b>enable/disable</b> <i>access of added administrators to functionality <b>[💬 Notifications]</b></i>\n\n👩🏽‍💻 <b>Commands</b> :\n/cmd - all commands\n/admin - add/remove administrator\n/parse - display all users",
    'es': "👮🏽 <b>Haga clic</b> en ✅/☑️ para <b>habilitar/deshabilitar</b> <i>el acceso de los administradores agregados a la funcionalidad <b>[💬 Notificaciones]</b></i>\n\n👩🏽‍💻 <b>Comandos</b> :\n/cmd - todos los comandos\n/admin - agregar/eliminar administrador\n/ analizar - mostrar todos los usuarios",
    'fr': "👮🏽 <b>Cliquez</b> sur ✅/☑️ pour <b>activer/désactiver</b> <i>l&#x27;accès des administrateurs ajoutés à la fonctionnalité <b>[💬 Notifications]</b></i>\n\n👩🏽‍💻 <b>Commandes</b> :\n/cmd - toutes les commandes\n/admin - ajouter/supprimer un administrateur\n/ parse - affiche tous les utilisateurs",
    'zh': "👮🏽<b>单击</b>✅/☑️<b>启用/禁用</b><i>添加的管理员对功能的访问<b>[💬 通知]</b></i>\n\n👩🏽‍💻<b>命令</b>：\n/cmd - 所有命令\n/admin - 添加/删除管理员\n/ parse - 显示所有用户",
    'ar': "👮🏽 <b>انقر</b> فوق ✅ / ☑️ <b>لتمكين / تعطيل</b> <i>وصول المسؤولين المضافين إلى الوظائف <b>[💬 إعلامات]</b></i>\n\n👩🏽‍💻 <b>الأوامر</b> :\n/ cmd - كافة الأوامر\n/ admin - إضافة / إزالة المسؤول\n/ تحليل - عرض جميع المستخدمين",
}
l_cadmin_done = {
    'ru': "👮🏽 <b>Готово!</b>/admin-список @{0}-бота:\n\n{1}\n\n👩🏽‍💻 <b>Команды</b>:\n/cmd - все команды\n/admin - добавить/удалить администратора\n/parse - вывести всех пользователей\n\n👩🏽‍💻 <b>Текущее</b> число администраторов: <u>{2}/10</u>",
    'en': "👮🏽 <b>Done!</b> /admin-list @{0}-bot:\n\n{1}\n\n👩🏽‍💻 <b>Commands</b> :\n/cmd - all commands\n/admin - add/remove administrator\n/parse - display all users\n\n👩🏽‍💻 <b>Current</b> number of admins: <u>{2}/10</u>",
    'es': "👮🏽 <b>Listo!</b> /admin-list @{0}-bot:\n\n{1}\n\n👩🏽‍💻 <b>Comandos</b> :\n/cmd - todos los comandos\n/admin - agregar/eliminar administrador\n/parse - mostrar todos los usuarios\n\n👩🏽‍💻 Número <b>actual</b> de administradores: <u>{2}/10</u>",
    'fr': "👮🏽 <b>C&#x27;est fait !</b> /admin-list @{0}-bot :\n\n{1}\n\n👩🏽‍💻 <b>Commandes</b> :\n/cmd - toutes les commandes\n/admin - ajouter/supprimer un administrateur\n/parse - afficher tous les utilisateurs\n\n👩🏽‍💻 Nombre <b>actuel</b> d&#x27;administrateurs : <u>{2}/10</u>",
    'zh': "👮🏽<b>完成！</b> /admin-list @{0}-bot:\n\n{1}\n\n👩🏽‍💻<b>命令</b>：\n/cmd - 所有命令\n/admin - 添加/删除管理员\n/parse - 显示所有用户\n\n👩🏽‍💻<b>当前</b>管理员人数： <u>{2}/10</u>",
    'ar': "👮🏽 <b>انتهى!</b> / admin-list @ {0} -bot:\n\n{1}\n\n👩🏽‍💻 <b>الأوامر</b> :\n/ cmd - جميع الأوامر\n/ admin - إضافة / إزالة المسؤول\n/ parse - عرض جميع المستخدمين\n\n👩🏽‍💻 العدد <b>الحالي</b> للمسؤولين: <u>{2} / 10</u>",
}
l_cadmin_add = {
    'ru': "👮🏽 <b>Введи</b> до 10 id-пользователей через <i>пробельные или разделительные</i> символы, чтобы добавить их в /admin-список\n\n👩🏽‍💻 <b>Текущее</b> число администраторов: <u>{0}</u>",
    'en': "👮🏽 <b>Enter</b> user id separated by spaces or separators to add them to /admin-list\n\n👩🏽‍💻 <b>Current</b> number of admins: <u>{0}</u>",
    'es': "👮🏽 <b>Ingrese</b> id de usuario separados por espacios o separadores para agregarlos a /admin-list\n\n👩🏽‍💻 Número <b>actual</b> de administradores: <u>{0}</u>",
    'fr': "👮🏽 <b>Entrez</b> id des utilisateurs séparés par des espaces ou des séparateurs pour les ajouter à /admin-list\n\n👩🏽‍💻 Nombre <b>actuel</b> d&#x27;administrateurs : <u>{0}</u>",
    'zh': "👮🏽<b>输入</b>以空格或分隔符分隔的用户id ，以将其添加到 /admin-list\n\n👩🏽‍💻<b>当前</b>管理员人数： <u>{0}</u>",
    'ar': "👮🏽 <b>أدخل</b> id المستخدمين مفصولة بمسافات أو فواصل لإضافتها إلى / قائمة المشرف\n\n👩🏽‍💻 العدد <b>الحالي</b> للمسؤولين: <u>{0}</u>",
}
l_cadmin_remove = {
    'ru': "👮🏽 <b>Введи</b> id пользователей через <i>пробельные или разделительные</i> символы, чтобы удалить их из /admin-список\n\n👩🏽‍💻 <b>Текущее</b> число администраторов: <u>{0}</u>",
    'en': "👮🏽 <b>Enter</b> user id separated by spaces or separators to remove them from /admin-list\n\n👩🏽‍💻 <b>Current</b> number of admins: <u>{0}</u>",
    'es': "👮🏽 <b>Ingrese</b> id de usuario separados por espacios o separadores para eliminarlos de /admin-list\n\n👩🏽‍💻 Número <b>actual</b> de administradores: <u>{0}</u>",
    'fr': "👮🏽 <b>Entrez</b> id d&#x27;utilisateur séparés par des espaces ou des séparateurs pour les supprimer de /admin-list\n\n👩🏽‍💻 Nombre <b>actuel</b> d&#x27;administrateurs : <u>{0}</u>",
    'zh': "👮🏽<b>输入</b>以空格或分隔符分隔的用户id ，以将其从 /admin-list 中删除\n\n👩🏽‍💻<b>当前</b>管理员数量： <u>{0}</u>",
    'ar': "👮🏽 <b>أدخل</b> id المستخدمين مفصولة بمسافات أو فواصل لإزالتها من / قائمة المشرف\n\n👩🏽‍💻 العدد <b>الحالي</b> للمسؤولين: <u>{0}</u>",
}
l_parse_text = {
    'ru': "👩🏽‍💻 <b>Готово!</b> Парсинг пользователей (<u>{0}</u>) @{1}-бота\n\n👩🏽‍💻 <b>Команды</b>:\n/cmd - все команды\n/parse - вывести всех пользователей\n/parse premium - вывести premium-пользователей\n/parse admin - вывести admin-пользователей\n/parse utm - вывести utm-рефералов\n",
    'en': "👩🏽‍💻 <b>Done!</b> Parsing users ( <u>{0}</u> ) @{1}-bot\n\n👩🏽‍💻 <b>Commands</b> :\n/cmd - all commands\n/parse - print all users\n/parse premium - print premium users\n/parse admin - display admin users\n/parse utm - display utm referrals\n",
    'es': "👩🏽‍💻 <b>Listo!</b> Analizando usuarios ( <u>{0}</u> ) @{1}-bot\n\n👩🏽‍💻 <b>Comandos</b> :\n/cmd - todos los comandos\n/parse - imprimir todos los usuarios\n/parse premium - imprimir usuarios premium\n/parse admin - mostrar usuarios administradores\n/parse utm - mostrar referencias utm\n",
    'fr': "👩🏽‍💻 <b>C&#x27;est fait !</b> Analyse des utilisateurs ( <u>{0}</u> ) @{1}-bot\n\n👩🏽‍💻 <b>Commandes</b> :\n/cmd - toutes les commandes\n/parse - imprimer tous les utilisateurs\n/parse premium - imprimer les utilisateurs premium\n/parse admin - affiche les utilisateurs administrateurs\n/parse utm - affiche les références utm\n",
    'zh': "👩🏽‍💻<b>完成！</b>解析用户（ <u>{0}</u> ）@{1}-bot\n\n👩🏽‍💻<b>命令</b>：\n/cmd - 所有命令\n/parse - 打印所有用户\n/parse premium - 打印高级用户\n/parse admin - 显示管理员用户\n/parse utm - 显示 utm 引用\n",
    'ar': "👩🏽‍💻 <b>انتهى!</b> تحليل المستخدمين ( <u>{0}</u> ) @ {1} -bot\n\n👩🏽‍💻 <b>الأوامر</b> :\n/ cmd - جميع الأوامر\n/ تحليل - طباعة جميع المستخدمين\n/parse premium - طباعة المستخدمين المتميزين\n/parse admin - عرض المستخدمين المسؤولين\n/parse utm - عرض إحالات UTM\n",
}
# endregion
# endregion


# region client
l_idea = {
    'ru': "💡 Идея!",
    'en': "💡 Idea!",
    'es': "💡 Idea!",
    'fr': "💡 Idée !",
    'zh': "💡 想法！",
    'ar': "💡 فكرة!",
}
l_have_read = {
    'ru': "👩🏽‍💻 {0} прочитал сообщение",
    'en': "👩🏽‍💻 {0} read the message",
    'es': "👩🏽‍💻 {0} lee el mensaje",
    'fr': "👩🏽‍💻 {0} lire le message",
    'zh': "👩🏽‍💻 {0}阅读消息",
    'ar': "👩🏽‍💻 {0} اقرأ الرسالة",
}
l_telegraph_title = {
    'ru': "📰 Telegraph блог",
    'en': "📰 Telegraph Blog",
    'es': "📰Blog de telégrafo",
    'fr': "📰 Blog télégraphique",
    'zh': "📰 电报博客",
    'ar': "📰 مدونة التلغراف",
}
l_telegraph_blog = {
    'ru': "<figure><img src='{0}'/><figcaption>Фото профиля: @{1}</figcaption></figure><blockquote>Лэндинг-блог для продвижения в <i>Telegram</i></blockquote>👩🏽‍💻 <b>бот:</b> {2}<br>[<b>id</b>={3}]<br><b>Био:</b> {4}<br><aside>Описание</aside>{5}",
    'en': "Profile photo: @{1}Landing blog for promotion in <i>Telegram</i> 👩🏽‍💻 <b>bot:</b> {2}[<b>id</b> = {3}] <b>Bio:</b> {4}Description{5}",
    'es': "Foto de perfil: @{1}Blog de aterrizaje para promoción en <i>Telegram</i> 👩🏽‍💻 <b>bot:</b> {2}[<b>id</b> = {3}] <b>Bio:</b> {4}Descripción{5}",
    'fr': "Photo de profil : @{1}Blog d'atterrissage pour la promotion dans <i>Telegram</i> 👩🏽‍💻 <b>bot :</b> {2}[<b>id</b> = {3}] <b>Bio :</b> {4}Description{5}",
    'zh': "个人资料照片：@{1}登陆博客以在<i>Telegram</i> 👩🏽‍💻<b>机器人中进行推广：</b> {2}[<b>id</b> = {3}]<b>简介：</b> {4}说明{5}",
    'ar': "صورة الملف الشخصي: @ {1} مدونة الهبوط للترويج في <i>Telegram</i> 👩🏽‍💻 <b>bot:</b> {2} [<b>id</b> = {3}] <b>السيرة الذاتية:</b> {4} الوصف {5}",
}
l_no_permission_table = {
    'ru': "👩🏽‍💻 <b>Нет прав</b> для записи в данную таблицу: {0}\n\n👩🏽‍💻 <b>Необходимо</b> заново добавить корректную ссылку на таблицу в @{1}-боте",
    'en': "Profile photo: @{1}Landing blog for promotion in <i>Telegram</i> 👩🏽‍💻 <b>bot:</b> {2}[<b>id</b> = {3}] <b>Bio:</b> {4}Description{5}",
    'es': "Foto de perfil: @{1}Blog de aterrizaje para promoción en <i>Telegram</i> 👩🏽‍💻 <b>bot:</b> {2}[<b>id</b> = {3}] <b>Bio:</b> {4}Descripción{5}",
    'fr': "Photo de profil : @{1}Blog d'atterrissage pour la promotion dans <i>Telegram</i> 👩🏽‍💻 <b>bot :</b> {2}[<b>id</b> = {3}] <b>Bio :</b> {4}Description{5}",
    'zh': "个人资料照片：@{1}登陆博客以在<i>Telegram</i> 👩🏽‍💻<b>机器人中进行推广：</b> {2}[<b>id</b> = {3}]<b>简介：</b> {4}说明{5}",
    'ar': "صورة الملف الشخصي: @ {1} مدونة الهبوط للترويج في <i>Telegram</i> 👩🏽‍💻 <b>bot:</b> {2} [<b>id</b> = {3}] <b>السيرة الذاتية:</b> {4} الوصف {5}",
}
# endregion


# region extra bot
l_show_admin_panel_md = {
    'ru': "*👩🏽‍💻 Создание и редактирование блога*\n\n👩🏽‍💻 Вы зашли как *Администратор* и можете создавать и редактировать блоги, но не удалять их\n\n¹ Авторизация (в течение 10сек) по ссылке в браузере:\n`{0}`\n\n² Перейди (в течение 10сек) по нужной ссылке для редактирования публикации (жми, чтобы скопировать):\n\n",
    'en': "*👩🏽‍💻 Creating and editing a blog*\n\n👩🏽‍💻 You are logged in as *Administrator* and can create and edit blogs, but not delete them\n\n¹ Authorization via link in browser:\n`{0 }`\n\n² Go (within 10 seconds) to the desired link to edit the post (click to copy):\n\n",
    'es': "*👩🏽‍💻 Crear y editar un blog*\n\n👩🏽‍💻 Ha iniciado sesión como *Administrador* y puede crear y editar blogs, pero no eliminarlos\n\n¹ Autorización a través de un enlace en el navegador:\n`{0 }`\n\n² Vaya (dentro de 10 segundos) al enlace deseado para editar la publicación (haga clic para copiar):\n\n",
    'fr': "*👩🏽‍💻 Créer et modifier un blog*\n\n👩🏽‍💻 Vous êtes connecté en tant qu'*administrateur* et vous pouvez créer et modifier des blogs, mais pas les supprimer\n\n¹ Autorisation via un lien dans le navigateur :\n`{0 }`\n\n² Accédez (dans les 10 secondes) au lien souhaité pour modifier le message (cliquez pour copier) :\n\n",
    'zh': "*👩🏽‍💻 创建和编辑博客*\n\n👩🏽‍💻 您以*管理员*身份登录，可以创建和编辑博客，但不能删除它们\n\n¹ 通过浏览器中的链接授权：\n`{0 }`\n\n²（在 10 秒内）转到所需的链接以编辑帖子（单击以复制）：\n\n",
    'ar': "* 👩🏽‍💻 إنشاء مدونة وتحريرها *\n\n👩🏽‍💻 تم تسجيل دخولك بصفتك * المسؤول * ويمكنك إنشاء المدونات وتحريرها ، ولكن لا يمكنك حذفها\n\n¹ التفويض عبر الارتباط في المستعرض:\n'{0}`\n\n² انتقل (في غضون 10 ثوانٍ) إلى الرابط المطلوب لتعديل المشاركة (انقر للنسخ):\n\n",
}
l_show_admin_panel_html = {
    'ru': "<b>👩🏽‍💻 Создание и редактирование блога</b>\n\n👩🏽‍💻 Вы зашли как <b>Администратор</b> и можете создавать и редактировать блоги, но не удалять их\n\n1. Авторизация по ссылке в браузере:\n{0}\n\n2. Перейди (в течение 10сек) по нужной ссылке для редактирования публикации (жми, чтобы скопировать):\n\n",
    'en': "<b>👩🏽‍💻 Creating and editing a blog</b>\n\n👩🏽‍💻 You are logged in as <b>Administrator</b> and can create and edit blogs, but not delete them\n\n1. Authorization by link in browser:\n{0}\n\n2. Go (within 10 seconds) to the desired link to edit the publication (click to copy):\n\n",
    'es': "<b>👩🏽‍💻 Crear y editar un blog</b>\n\n👩🏽‍💻 Ha iniciado sesión como <b>Administrador</b> y puede crear y editar blogs, pero no borrarlos\n\n1. Autorización por enlace en el navegador:\n{0}\n\n2. Vaya (dentro de 10 segundos) al enlace deseado para editar la publicación (haga clic para copiar):\n\n",
    'fr': "<b>👩🏽‍💻 Créer et modifier un blog</b>\n\n👩🏽‍💻 Vous êtes connecté en tant <b>qu&#x27;administrateur</b> et pouvez créer et modifier des blogs, mais pas les supprimer\n\n1. Autorisation par lien dans le navigateur :\n{0}\n\n2. Accédez (dans les 10 secondes) au lien souhaité pour modifier la publication (cliquez pour copier) :\n\n",
    'zh': "<b>👩🏽‍💻 创建和编辑博客</b>\n\n👩🏽‍💻 您以<b>管理员</b>身份登录，可以创建和编辑博客，但不能删除它们\n\n1.通过浏览器中的链接授权：\n{0}\n\n2.转到（在 10 秒内）所需的链接以编辑发布（单击以复制）：\n\n",
    'ar': "<b>👩🏽‍💻 إنشاء مدونة وتحريرها</b>\n\n👩🏽‍💻 قمت بتسجيل الدخول <b>كمسؤول</b> ويمكنك إنشاء المدونات وتحريرها ، ولكن لا يمكنك حذفها\n\n1. التفويض بالارتباط في المتصفح:\n{0}\n\n2. انتقل (في غضون 10 ثوانٍ) إلى الارتباط المطلوب لتحرير المنشور (انقر للنسخ):\n\n",
}
l_show_admin_panel_create = {
    'ru': "🆕 Создать",
    'en': "🆕 Create",
    'es': "🆕 Crear",
    'fr': "🆕 Créer",
    'zh': "🆕 创建",
    'ar': "🆕 خلق",
}
l_show_admin_panel_auth = {
    'ru': "👩🏽‍💻 Авторизация",
    'en': "👩🏽‍💻 Authorization",
    'es': "👩🏽‍💻 Autorización",
    'fr': "👩🏽‍💻 Autorisation",
    'zh': "👩🏽‍💻授权",
    'ar': "👩🏽‍💻 إذن",
}
# endregion


# region html
l_burger_save = {
    'ru': "Сохранить",
    'en': "Save",
    'es': "Ahorrar",
    'fr': "Sauvegarder",
    'zh': "节省",
    'ar': "يحفظ",
}
l_burger_gen = {
    'ru': "Сгенерировать бота",
    'en': "Generate bot",
    'es': "Generar bot",
    'fr': "Générer un robot",
    'zh': "生成机器人",
    'ar': "توليد بوت",
}
l_burger_import = {
    'ru': "Импортировать .bot",
    'en': "Import .bot",
    'es': "Importar .bot",
    'fr': "Importer .bot",
    'zh': "导入.bot",
    'ar': "استيراد .bot",
}
l_burger_export = {
    'ru': "Экспортировать как >",
    'en': "Export as >",
    'es': "Exportar como >",
    'fr': "Exporter sous >",
    'zh': "导出为 >",
    'ar': "تصدير باسم>",
}
l_burger_clear = {
    'ru': "Очистить",
    'en': "Cleaning",
    'es': "Limpieza",
    'fr': "Nettoyage",
    'zh': "打扫",
    'ar': "تنظيف",
}
l_burger_gen_alert = {
    'ru': "Создать нового бота?",
    'en': "Create a new bot?",
    'es': "¿Crear un nuevo bot?",
    'fr': "Créer un nouveau bot ?",
    'zh': "创建一个新的机器人？",
    'ar': "إنشاء روبوت جديد؟",
}
l_burger_import_alert = {
    'ru': "Загрузка..",
    'en': "Loading..",
    'es': "Cargando..",
    'fr': "Chargement..",
    'zh': "加载中..",
    'ar': "تحميل..",
}
l_burger_clear_alert = {
    'ru': "Очистить сцену?",
    'en': "Clear the scene?",
    'es': "Limpiar la escena?",
    'fr': "Vider la scène ?",
    'zh': "清理现场？",
    'ar': "مسح المشهد؟",
}

l_ent_close = {
    'ru': "Закрыть",
    'en': "Close",
    'es': "Cerca",
    'fr': "Fermer",
    'zh': "关闭",
    'ar': "يغلق",
}
l_ent_save = {
    'ru': "Сохранить",
    'en': "Save",
    'es': "Ahorrar",
    'fr': "Sauvegarder",
    'zh': "节省",
    'ar': "يحفظ",
}
l_ent_delete = {
    'ru': "Удалить",
    'en': "Delete",
    'es': "Borrar",
    'fr': "Supprimer",
    'zh': "删除",
    'ar': "يمسح",
}
l_copied = {
    'ru': "Скопировано",
    'en': "Copied",
    'es': "Copiado",
    'fr': "Copié",
    'zh': "已复制",
    'ar': "نسخ",
}
l_web_gen_img = {
    'ru': "Сгенерировать Образ",
    'en': "Generate Image",
    'es': "Generar imagen",
    'fr': "Générer une image",
    'zh': "生成图像",
    'ar': "توليد الصورة",
}
l_web_gen_txt = {
    'ru': "Сгенерировать Текст",
    'en': "Generate Text",
    'es': "Generar Texto",
    'fr': "Générer du texte",
    'zh': "生成文本",
    'ar': "توليد نص",
}
l_all_trg = {
    'ru': ": все триггеры",
    'en': ": all triggers",
    'es': ": todos los disparadores",
    'fr': ": tous les déclencheurs",
    'zh': ": 所有触发器",
    'ar': ": جميع المشغلات",
}
l_one_trg = {
    'ru': ": 1 триггер",
    'en': ": 1 trigger",
    'es': ": 1 gatillo",
    'fr': ": 1 gâchette",
    'zh': "：1个触发器",
    'ar': ": 1 الزناد",
}
l_actions = {
    'ru': ": действия",
    'en': ": actions",
    'es': ": acciones",
    'fr': ": Actions",
    'zh': "：行动",
    'ar': ": أجراءات",
}
l_trigger = {
    'ru': "Триггер",
    'en': "Trigger",
    'es': "Desencadenar",
    'fr': "Déclencher",
    'zh': "扳机",
    'ar': "مشغل",
}
l_action = {
    'ru': "Действие",
    'en': "Action",
    'es': "Acción",
    'fr': "Action",
    'zh': "行动",
    'ar': "فعل",
}
l_message = {
    'ru': "Сообщение",
    'en': "Message",
    'es': "Mensaje",
    'fr': "Message",
    'zh': "信息",
    'ar': "رسالة",
}

l_trg_add = {
    'ru': "+ Добавить Триггер",
    'en': "+ Add Trigger",
    'es': "+ Agregar disparador",
    'fr': "+ Ajouter un déclencheur",
    'zh': "+ 添加触发器",
    'ar': "+ إضافة مشغل",
}
l_trg_cmd = {
    'ru': "+ команда",
    'en': "+ command",
    'es': "+ comando",
    'fr': "+ commande",
    'zh': "+ 命令",
    'ar': "+ الأمر",
}
l_trg_txt = {
    'ru': "+ текст",
    'en': "+ text",
    'es': "+ texto",
    'fr': "+ texte",
    'zh': "+ 文字",
    'ar': "+ نص",
}
l_trg_btn = {
    'ru': "+ кнопка",
    'en': "+ button",
    'es': "+ botón",
    'fr': "+ bouton",
    'zh': "+ 按钮",
    'ar': "+ زر",
}
l_trg_var = {
    'ru': "+ переменная",
    'en': "+ variable",
    'es': "+ variables",
    'fr': "+ variable",
    'zh': "+ 变量",
    'ar': "+ متغير",
}
l_trg_lst = {
    'ru': "+ список",
    'en': "+ list",
    'es': "+ lista",
    'fr': "+ liste",
    'zh': "+ 列表",
    'ar': "+ قائمة",
}

l_act_add = {
    'ru': "+ Добавить Действие",
    'en': "+ Add Action",
    'es': "+ Agregar acción",
    'fr': "+ Ajouter une action",
    'zh': "+ 添加动作",
    'ar': "+ إضافة عمل",
}
l_act_dly = {
    'ru': "+ задержка",
    'en': "+ delay",
    'es': "+ retraso",
    'fr': "+ délai",
    'zh': "+延迟",
    'ar': "+ تأخير",
}
l_act_wait = {
    'ru': "+ ожидание",
    'en': "+ waiting",
    'es': "+ esperando",
    'fr': "+ attente",
    'zh': "+ 等待",
    'ar': "+ الانتظار",
}
l_act_req = {
    'ru': "+ запрос",
    'en': "+ request",
    'es': "+ solicitud",
    'fr': "+ demande",
    'zh': "+ 要求",
    'ar': "+ طلب",
}

l_msg_text = {
    'ru': ": text",
    'en': ": text",
    'es': ": texto",
    'fr': ": texte",
    'zh': "： 文本",
    'ar': ": نص",
}
l_msg_photo = {
    'ru': ": фото",
    'en': ": photo",
    'es': ": foto",
    'fr': ": photo",
    'zh': "： 照片",
    'ar': ": صورة",
}
l_msg_gif = {
    'ru': ": гиф",
    'en': ": gif",
    'es': ": gif",
    'fr': ": gif",
    'zh': ": 动图",
    'ar': ": gif",
}
l_msg_video = {
    'ru': ": видео",
    'en': ": video",
    'es': ": video",
    'fr': ": vidéo",
    'zh': "： 视频",
    'ar': ": فيديو",
}
l_msg_video_note = {
    'ru': ": телескоп",
    'en': ": telescope",
    'es': ": telescopio",
    'fr': ": télescope",
    'zh': ": 望远镜",
    'ar': ": تلسكوب",
}
l_msg_audio = {
    'ru': ": аудио",
    'en': ": audio",
    'es': ": sonido",
    'fr': ": l'audio",
    'zh': "： 声音的",
    'ar': ": صوتي",
}
l_msg_voice = {
    'ru': ": голосовое",
    'en': ": voice",
    'es': ": voz",
    'fr': ": voix",
    'zh': "： 嗓音",
    'ar': ": صوت",
}
l_msg_document = {
    'ru': ": документ",
    'en': ": document",
    'es': ": documento",
    'fr': ": document",
    'zh': "： 文档",
    'ar': ": وثيقة",
}
l_msg_sticker = {
    'ru': ": стикер",
    'en': ": sticker",
    'es': ": pegatina",
    'fr': ": autocollant",
    'zh': "： 贴纸",
    'ar': ": ملصق",
}
l_msg_quiz = {
    'ru': ": опрос",
    'en': ": survey",
    'es': ": encuesta",
    'fr': ": enquête",
    'zh': "： 民意调查",
    'ar': ": استطلاع",
}
l_msg_dice = {
    'ru': ": игра",
    'en': ": game",
    'es': ": juego",
    'fr': ": jeu",
    'zh': "： 游戏",
    'ar': ": لعبة",
}

l_btn_button_in = {
    'ru': "✅ Кнопка ↑",
    'en': "✅ Button ↑",
    'es': "✅ Botón ↑",
    'fr': "✅ Bouton ↑",
    'zh': "✅按钮↑",
    'ar': "✅ زر ↑",
}
l_btn_link = {
    'ru': "🔗 Ссылка",
    'en': "🔗 Link",
    'es': "🔗 Enlace",
    'fr': "🔗 Lien",
    'zh': "🔗 链接",
    'ar': "🔗 رابط",
}
l_btn_pay = {
    'ru': "💳 Оплата",
    'en': "💳 Payment",
    'es': "💳 Pago",
    'fr': "💳 Paiement",
    'zh': "💳付款",
    'ar': "💳 الدفع",
}
l_btn_search = {
    'ru': "🔎 Поиск",
    'en': "🔎 Search",
    'es': "🔎 Buscar",
    'fr': "🔎 Rechercher",
    'zh': "🔎 搜索",
    'ar': "🔎 بحث",
}
l_btn_like = {
    'ru': "❤️ Лайк",
    'en': "❤️ Like",
    'es': "❤️ Me gusta",
    'fr': "❤️ J'aime",
    'zh': "❤️喜欢",
    'ar': "❤️ مثل",
}
l_btn_button_kb = {
    'ru': "✅ Кнопка ↓",
    'en': "✅ Button ↓",
    'es': "✅ Botón ↓",
    'fr': "✅ Bouton ↓",
    'zh': "✅按钮↓",
    'ar': "✅ زر ↓",
}
l_btn_phone = {
    'ru': "📞 Сотовый",
    'en': "📞 Cellular",
    'es': "📞 Celular",
    'fr': "📞 Cellulaire",
    'zh': "📞 手机",
    'ar': "📞 خلوي",
}
l_btn_geo = {
    'ru': "📍 Гео",
    'en': "📍 Geo",
    'es': "📍 Geo",
    'fr': "📍 Géo",
    'zh': "📍地理",
    'ar': "📍 جيو",
}
l_btn_blog = {
    'ru': "📰 Блог",
    'en': "📰 Blog",
    'es': "📰Blog",
    'fr': "📰 Blogue",
    'zh': "📰 博客",
    'ar': "📰 مدونة",
}
l_btn_name = {
    'ru': "Имя:",
    'en': "Name:",
    'es': "Nombre:",
    'fr': "Nom:",
    'zh': "姓名：",
    'ar': "اسم:",
}
l_btn_type = {
    'ru': "Тип:",
    'en': "Type:",
    'es': "Tipo:",
    'fr': "Taper:",
    'zh': "类型：",
    'ar': "يكتب:",
}

l_check_box_pin_message = {
    'ru': "Закреп сообщения",
    'en': "Pin messages",
    'es': "Anclar mensajes",
    'fr': "Épingler les messages",
    'zh': "固定消息",
    'ar': "تثبيت الرسائل",
}
l_check_box_protect_message = {
    'ru': "Защита сообщения",
    'en': "Message protection",
    'es': "Protección de mensajes",
    'fr': "Protection des messages",
    'zh': "消息保护",
    'ar': "حماية الرسائل",
}
l_check_box_edit_message = {
    'ru': "Изменить текущее сообщение",
    'en': "Edit current message",
    'es': "Editar mensaje actual",
    'fr': "Modifier le message actuel",
    'zh': "编辑当前消息",
    'ar': "تحرير الرسالة الحالية",
}
l_check_box_auto_format = {
    'ru': "Авто формат сообщения",
    'en': "Auto message format",
    'es': "Formato de mensaje automático",
    'fr': "Format de message automatique",
    'zh': "自动消息格式",
    'ar': "تنسيق الرسالة التلقائي",
}
l_check_box_auto_typing = {
    'ru': "Авто печатание сообщения",
    'en': "Auto typing message",
    'es': "Mensaje de escritura automática",
    'fr': "Message de saisie automatique",
    'zh': "自动输入信息",
    'ar': "رسالة الكتابة التلقائية",
}
l_check_box_preview = {
    'ru': "Превью контент",
    'en': "Preview content",
    'es': "Vista previa del contenido",
    'fr': "Prévisualiser le contenu",
    'zh': "预览内容",
    'ar': "معاينة المحتوى",
}
l_check_box_spoiler = {
    'ru': "Гиф/фото/видео спойлер",
    'en': "GIF/photo/video spoiler",
    'es': "Spoiler de GIF/foto/video",
    'fr': "Spoiler GIF/photo/vidéo",
    'zh': "GIF/照片/视频剧透",
    'ar': "مفسد GIF / صور / فيديو",
}
l_check_box_silence = {
    'ru': "Тихое сообщение",
    'en': "Quiet message",
    'es': "Mensaje tranquilo",
    'fr': "Message silencieux",
    'zh': "悄悄话",
    'ar': "رسالة هادئة",
}
# endregion
# endregion


# region FereyUserBot
l_subscribe_user = {
    'ru': "👩🏽‍💻 <b>Оформи</b> ежемесячную <i>подписку</i>:\n\n¹ [<b>Все боты</b> и проекты (-<u>5</u>%)]\n² [@{0}-бот]:\n▪️до 5 <b>рассылок</b> пользователям\n▪️<b>авто-ответ</b> с chatgpt\n▪️<b>экстра</b> бот\n\n👩🏽‍💻 /balance",
    'en': "👩🏽‍💻 <b>Sign up for</b> a monthly\n\n¹ <i>subscription</i> to @{0}-bot [{1} ₽]\n▪️ no ads\n▪️ creative tasks\n² Subscribe to <u>all</u> bots [{2} ₽]",
    'es': "👩🏽‍💻 <b>Regístrese para obtener</b> una\n\n¹ <i>suscripción</i> mensual a @{0}-bot [{1} ₽]\n▪️ sin anuncios\n▪️ tareas creativas\n² Suscríbase a <u>todos</u> los bots [{2} ₽]",
    'fr': "👩🏽‍💻 <b>Inscrivez-vous pour</b> un <i>abonnement</i>\n\n¹ mensuel à @{0}-bot [{1} ₽]\n▪️ pas de publicité\n▪️ tâches créatives\n² Abonnez-vous à <u>tous</u> les bots [{2} ₽]",
    'zh': "👩🏽‍💻<b>注册</b>每月\n\n¹<i>订阅</i>@{0}-bot [{1} ₽]\n▪️ 无广告\n▪️ 创意任务\n² 订阅<u>所有</u>机器人 [{2} ₽]",
    'ar': "👩🏽‍💻 <b>اشترك للحصول على</b> <i>اشتراك</i> شهري\n\n¹ في @ {0} -bot [{1} ₽]\n▪️ بلا إعلانات\n▪️ مهام إبداعية\n² اشترك في <u>جميع</u> برامج التتبُّع [{2} ₽]",
}
# endregion


# region FereyChannelBot
l_chn_btn1 = {
    'ru': "⛰️ Каналы",
    'en': "⛰️ Channels",
    'es': "⛰️ Canales",
    'fr': "⛰️ Chaînes",
    'zh': "⛰️频道",
    'ar': "⛰️ القنوات",
}
l_chn_btn2 = {
    'ru': "🌬 Подписка",
    'en': "🌬 Subscription",
    'es': "🌬 Suscripción",
    'fr': "🌬 Abonnement",
    'zh': "🌬订阅",
    'ar': "🌬 الاشتراك",
}
l_chn_welcome = {
    'ru': "🌱 {0}, добро пожаловать в <i>лендинг-бот</i> администрирования <b>Telegram</b>-каналов:\n\n▪️<b>защита</b> канала от вступления шпионов\n▪️<b>организация</b> бана и антифлуда\n▪️<b>сбор</b> подписчиков\n▪️<b>кнопочный</b> счетчик\n▪️<b>реакции</b> и просмотры\n▪️<b>авто-декор</b> поста\n\n❗️Регулярно-обновляемый /content",
    'en': "🌱 {0}, welcome to the <b>Telegram</b> channel администрирования <i>landing bot</i> :\n\n▪️ <b>protection</b> of the channel from spyware entry\n▪️display <b>of statistics</b> and engagement (%)\n▪️restriction of rights before <b>subscribing</b> to the channel\n▪️ <b>organization</b> of a ban and anti-flood\n\n❗️you can also order the development of a chat bot in our Ferey studio",
    'es': "🌱 {0}, bienvenido al <i>bot de aterrizaje</i> администрирования de canales <b>de Telegram</b> :\n\ <b>n▪️protección</b> del canal contra la entrada de software espía\n▪️visualización <b>de estadísticas</b> e interacción (%)\n▪️restricción de derechos antes de <b>suscribirse</b> al canal\n▪️ <b>organización</b> de una prohibición y anti-inundación\n\n❗️también puedes encargar el desarrollo de un chatbot en nuestro estudio Ferey",
    'fr': "🌱 {0}, bienvenue dans le <i>landing bot</i> администрирования de la chaîne <b>Telegram</b> :\n\n▪️ <b>protection</b> de la chaîne contre l&#x27;entrée de logiciels espions\n▪️affichage <b>des statistiques</b> et de l&#x27;engagement (%)\n▪️restriction des droits avant de <b>s&#x27;abonner</b> à la chaîne\n<b>▪️organisation</b> d'une interdiction et anti-flood\n\n❗️vous pouvez également commander le développement d'un chat bot dans notre studio de Ferey",
    'zh': "🌱 {0}，欢迎使用<b>Telegram</b>频道администрирования<i>登陆机器人</i>：\n\n▪️<b>保护</b>频道免受间谍软件入侵\n▪️ 显示<b>统计信息</b>和参与度 (%)\n▪️<b>订阅</b>频道前的权利限制\n▪️<b>组织</b>禁令和反洪水\n\n❗️您也可以在我们的Ferey工作室订购聊天机器人的开发",
    'ar': "🌱 {0} ، مرحبًا بك في <i>روبوت</i> администрирования قناة <b>Telegram</b> :\n\n▪️ <b>حماية</b> القناة من إدخال برامج التجسس\n▪️ <b>عرض الإحصائيات</b> والمشاركة (٪)\n▪️ تقييد الحقوق قبل <b>الاشتراك</b> في القناة\n▪️ <b>تنظيم</b> حظر ومكافحة الفيضانات\n\n❗️ يمكنك أيضًا طلب تطوير روبوت محادثة في استوديو Ferey الخاص بنا",
}
l_subscribe_channel = {
    'ru': "👩🏽‍💻 <b>Оформи</b> ежемесячную <i>подписку</i>:\n\n¹ [<b>Все боты</b> и проекты (-<u>5</u>%)]\n² [@{0}-бот]:\n▪️до 75 <b>реакций</b>/просмотров на пост\n▪️<b>/parse</b> базы пользователей\n\n👩🏽‍💻 /balance",
    'en': "👩🏽‍💻 <b>Sign up for</b> a monthly\n\n¹ <i>subscription</i> to @{0}-bot [{1} ₽]\n▪️ no ads\n▪️ creative tasks\n² Subscribe to <u>all</u> bots [{2} ₽]",
    'es': "👩🏽‍💻 <b>Regístrese para obtener</b> una\n\n¹ <i>suscripción</i> mensual a @{0}-bot [{1} ₽]\n▪️ sin anuncios\n▪️ tareas creativas\n² Suscríbase a <u>todos</u> los bots [{2} ₽]",
    'fr': "👩🏽‍💻 <b>Inscrivez-vous pour</b> un <i>abonnement</i>\n\n¹ mensuel à @{0}-bot [{1} ₽]\n▪️ pas de publicité\n▪️ tâches créatives\n² Abonnez-vous à <u>tous</u> les bots [{2} ₽]",
    'zh': "👩🏽‍💻<b>注册</b>每月\n\n¹<i>订阅</i>@{0}-bot [{1} ₽]\n▪️ 无广告\n▪️ 创意任务\n² 订阅<u>所有</u>机器人 [{2} ₽]",
    'ar': "👩🏽‍💻 <b>اشترك للحصول على</b> <i>اشتراك</i> شهري\n\n¹ في @ {0} -bot [{1} ₽]\n▪️ بلا إعلانات\n▪️ مهام إبداعية\n² اشترك في <u>جميع</u> برامج التتبُّع [{2} ₽]",
}

l_add_chn_text = {
    'ru': "👮🏽‍♀️ <b>Добавь</b> @{0}-бота как  <b>Administrator</b> через настройки своего канала: ‹👤Add Admin›\n\n👮🏽‍♀️ <b>Опция</b> [✅ Назначение администраторов] позволит сделать парсинг старых пользователей, даже если в канале более 200 пользователей",
    'en': "👮🏽‍♀️ <b>Add</b> @{0}-bot as <b>an Administrator</b> via your channel settings: ‹👤Add Admin›\n\n👮🏽‍♀️ The [✅ Assign Admins] <b>option</b> will allow you to parse old users, even if there are more than 200 users in the channel",
    'es': "👮🏽‍♀️ <b>Agregue</b> @{0}-bot como <b>administrador</b> a través de la configuración de su canal: ‹👤Agregar administrador›\n\n👮🏽‍♀️ La <b>opción</b> [✅ Asignar administradores] le permitirá analizar usuarios antiguos, incluso si hay hay mas de 200 usuarios en el canal",
    'fr': "👮🏽‍♀️ <b>Ajoutez</b> @{0}-bot en tant <b>qu&#x27;administrateur</b> via les paramètres de votre chaîne : ‹👤Add Admin›\n\n👮🏽‍♀️ L&#x27; <b>option</b> [✅ Assign Admins] vous permettra d'analyser les anciens utilisateurs, même s'il y a sont plus de 200 utilisateurs dans le canal",
    'zh': "👮🏽‍♀️ 通过您的频道设置将@{0}-bot<b>添加</b>为<b>管理员</b>：‹👤添加管理员›\n\n👮🏽‍♀️ [✅ 分配管理员]<b>选项</b>将允许您解析旧用户，即使有频道中有超过 200 个用户",
    'ar': "👮🏽‍♀️ <b>إضافة</b> @ {0} -bot <b>كمسؤول</b> عبر إعدادات القناة: ‹👤 إضافة مسؤول›\n\n👮🏽‍♀️ سيسمح لك <b>خيار</b> [✅ تعيين المسؤولين] بتحليل المستخدمين القدامى ، حتى لو كان هناك أكثر من 200 مستخدم في القناة",
}
l_add_chn_txt_call = {
    'ru': "👮🏽‍♀️ Добавь @{0}-бота как Administrator через настройки своего канала: ‹👤Add Admin›",
    'en': "👮🏽‍♀️ Add @{0}-bot as Administrator via your channel settings: ‹👤Add Admin›",
    'es': "👮🏽‍♀️ Agrega @{0}-bot como administrador a través de la configuración de tu canal: ‹👤Agregar administrador›",
    'fr': "👮🏽‍♀️ Ajoutez @{0}-bot en tant qu'administrateur via les paramètres de votre chaîne : ‹👤Ajouter un administrateur›",
    'zh': "👮🏽‍♀️ 通过您的频道设置将@{0}-bot 添加为管理员：‹👤添加管理员›",
    'ar': "👮🏽‍♀️ إضافة @ {0} -bot كمسؤول عبر إعدادات القناة: ‹👤 إضافة مسؤول›",
}
l_add_chn_button = {
    'ru': "➕ Добавить канал",
    'en': "➕ Add channel",
    'es': "➕ Agregar canal",
    'fr': "➕ Ajouter une chaîne",
    'zh': "➕ 添加频道",
    'ar': "➕ إضافة قناة",
}
l_bot_removed = {
    'ru': "🚫 @{0}-бот удален из <b>{1}</b> ({2})",
    'en': "🚫 @{0}-bot removed from <b>{1}</b> ( {2} )",
    'es': "🚫 @{0}-bot eliminado de <b>{1}</b> ( {2} )",
    'fr': "🚫 @{0}-bot supprimé de <b>{1}</b> ( {2} )",
    'zh': "🚫 @{0}-bot 从<b>{1}</b> ( {2} ) 中移除",
    'ar': "🚫 @ {0} -إزالة الروبوت من <b>{1}</b> ( {2} )",
}

l_chn_config = {
    ("cban", "🕵🏽", "☑"): {
        'ru': "Авто-бан",
        'en': "Auto-ban",
        'es': "Prohibición automática",
        'fr': "Interdiction automatique",
        'zh': "自動禁止",
        'ar': "حظر تلقائي",
    },
    ("cpost", "🔔", "☐"): {
        'ru': "Авто-постинг",
        'en': "Auto-posting",
        'es': "Publicación automática",
        'fr': "Publication automatique",
        'zh': "自動發布",
        'ar': "النشر التلقائي",
    },
    ("creact", "👍🏽", "☐"): {
        'ru': "Авто-реакции",
        'en': "System messages",
        'es': "Mensajes del sistema",
        'fr': "Messages système",
        'zh': "系統消息",
        'ar': "رسائل النظام",
    },
    ("cview", "👁️‍🗨️", "☐"): {
        'ru': "Авто-просмотры",
        'en': "System messages",
        'es': "Mensajes del sistema",
        'fr': "Messages système",
        'zh': "系統消息",
        'ar': "رسائل النظام",
    },
    ("cdecor", "🪄", "☐"): {
        'ru': "Авто-декор",
        'en': "System messages",
        'es': "Mensajes del sistema",
        'fr': "Messages système",
        'zh': "系統消息",
        'ar': "رسائل النظام",
    },
    ("cmember", "👥", "☐"): {
        'ru': "Сбор подписчиков",
        'en': "System messages",
        'es': "Mensajes del sistema",
        'fr': "Messages système",
        'zh': "系統消息",
        'ar': "رسائل النظام",
    },
    ("ccheck", "👮🏽", "☐"): {
        'ru': "Запрос на вступление",
        'en': "Join request",
        'es': "Entrar en control",
        'fr': "Prenez le contrôle",
        'zh': "進入控制",
        'ar': "أدخل السيطرة",
    },
}
l_to_default = {
    'ru': "✖️Сброс настроек",
    'en': "✖️Reset settings",
    'es': "✖️Restablecer configuración",
    'fr': "✖️Réinitialiser les paramètres",
    'zh': "✖️重置设置",
    'ar': "✖️ إعادة ضبط الإعدادات",
}
l_remove_channel = {
    'ru': "🚫Убрать канал",
    'en': "🚫Clear channel",
    'es': "🚫Borrar canal",
    'fr': "🚫Canal clair",
    'zh': "🚫畅通频道",
    'ar': "🚫 قناة واضحة",
}
l_show_channels = {
    'ru': "👩🏽‍💻 <b>Добавленные каналы</b>\n\n[команды /cmd]",
    'en': "👩🏽‍💻 <b>Added channels</b>\n\n[commands /cmd]",
    'es': "👩🏽‍💻 <b>Canales añadidos</b>\n\n[comandos /cmd]",
    'fr': "👩🏽‍💻 <b>Chaînes ajoutées</b>\n\n[commandes /cmd]",
    'zh': "👩🏽‍💻<b>添加频道</b>\n\n[命令/cmd]",
    'ar': "👩🏽‍💻 <b>القنوات المضافة</b>\n\n[أوامر / cmd]",
}
l_show_settings = {
    'ru': "⚙️ <b>Выбери</b> опцию для /cmd <i>настройки</i> [<b>{0}</b>] {1}",
    'en': "⚙️ <b>Select</b> option for /cmd <i>settings</i> [<b>{0}</b>] {1}",
    'es': "⚙️ <b>Seleccione</b> la opción para <i>la configuración de</i> /cmd [<b>{0}</b>] {1}",
    'fr': "⚙️ <b>Sélectionnez</b> l&#x27;option pour <i>les paramètres</i> /cmd [<b>{0}</b>] {1}",
    'zh': "⚙️<b>选择</b>/cmd<i>设置</i>选项 [<b>{0}</b>] {1}",
    'ar': "⚙️ <b>تحديد</b> خيار <i>إعدادات</i> / cmd [<b>{0}</b>] {1}",
}
l_chat_join_request_handler = {
    'ru': "👮🏽 {0}, ты отправил(а) заявку на вступление в <b>{1}</b>\n\n👉🏼 <b>Выбери</b> <i>правильный вариант</i> в соответствии с заданием на картинке, чтобы твоя <i>заявка</i> на вступление была <b>одобрена</b>",
    'en': "👮🏽 {0}, you submitted an application to join <b>{1}</b>\n\n👉🏼 <b>Choose</b> <i>the correct option</i> according to заданием in the picture so that your <i>application</i> to join is <b>approved</b>",
    'es': "👮🏽 {0}, envió una solicitud para unirse <b>{1}</b>\n\n👉🏼 <b>Elija</b> <i>la opción correcta</i> de acuerdo con заданием en la imagen para que se <b>apruebe</b> su <i>solicitud</i> para unirse",
    'fr': "👮🏽 {0}, vous avez soumis une candidature pour rejoindre <b>{1}</b>\n\n👉🏼 <b>Choisissez</b> <i>la bonne option</i> en fonction de заданием dans l&#x27;image afin que votre <i>candidature</i> soit <b>approuvée</b>",
    'zh': "👮🏽 {0}，你提交了加入<b>{1}</b>的申请\n\n👉🏼 根据图片中的заданием<b>选择</b><i>正确的选项</i>，这样你的加入<i>申请</i>就<b>通过了</b>",
    'ar': "👮🏽 {0} ، لقد قدمت طلبًا للانضمام <b>{1}</b>\n\n👉🏼 <b>اختر</b> <i>الخيار الصحيح</i> وفقًا заданием الموجودة في الصورة حتى تتم <b>الموافقة على</b> <i>طلبك</i> للانضمام",
}
l_content_types_sub_button = {
    'ru': "👮🏽 Я подписался",
    'en': "👮🏽 I subscribed",
    'es': "👮🏽 me suscribí",
    'fr': "👮🏽 je me suis abonné",
    'zh': "👮🏽 我订阅了",
    'ar': "👮🏽 لقد اشتركت",
}
l_content_types_subscribe = {
    'ru': "👮🏽 {0}, подпишись на {1}, чтобы твоя заявка на вступление была одобрена",
    'en': "👮🏽 {0}, follow {1} to get your application approved",
    'es': "👮🏽 {0}, sigue a {1} para que se apruebe tu solicitud",
    'fr': "👮🏽 {0}, suivez {1} pour faire valider votre candidature",
    'zh': "👮🏽 {0}，按照{1}让您的申请获得批准",
    'ar': "👮🏽 {0} ، تابع {1} للحصول على الموافقة على طلبك",
}
l_wait_1_min = {
    'ru': "🕐 Подожди 1мин",
    'en': "🕐 Wait 1min",
    'es': "🕐 Espera 1 minuto",
    'fr': "🕐 Attendez 1min",
    'zh': "🕐 等一分钟",
    'ar': "🕐 انتظر 1 دقيقة",
}

l_creturn_answer = {
    'ru': "✖️ Настройки для [<b>{0}</b>] успешно сброшены!",
    'en': "✖️ Settings for [<b>{0}</b>] reset successfully!",
    'es': "✖️ ¡La configuración de [<b>{0}</b>] se restableció correctamente!",
    'fr': "✖️ Les paramètres de [<b>{0}</b>] ont été réinitialisés avec succès !",
    'zh': "✖️ [<b>{0}</b>] 的设置重置成功！",
    'ar': "✖️ تمت إعادة تعيين إعدادات [<b>{0}</b>] بنجاح!",
}
l_cdelete_text = {
    'ru': "🚫 <b>Убрать</b> привязку бота к [<b>{0}</b>]?",
    'en': "🚫 Remove bot binding to [<b>{0}</b>]?",
    'es': "🚫 ¿Eliminar la vinculación del bot a [<b>{0}</b>]?",
    'fr': "🚫 Supprimer la liaison du bot à [<b>{0}</b>] ?",
    'zh': "🚫 删除绑定到 [<b>{0}</b>] 的机器人？",
    'ar': "🚫 هل تريد إزالة ربط البوت بـ [<b>{0}</b>]؟",
}
l_cdelete_answer = {
    'ru': "🚫 <b>Бот</b> успешно отвязан от [<b>{0}</b>] и не числится его в участниках!",
    'en': "🚫 <b>The bot</b> has successfully unlinked from [<b>{0}</b>] and is not listed as a member!",
    'es': "🚫 ¡ <b>El bot</b> se ha desvinculado con éxito de [<b>{0}</b>] y no aparece como miembro!",
    'fr': "🚫 <b>Le bot</b> s&#x27;est dissocié avec succès de [<b>{0}</b>] et n'est pas répertorié en tant que membre !",
    'zh': "🚫<b>该机器人</b>已成功取消与 [<b>{0}</b>] 的链接，并且未被列为成员！",
    'ar': "🚫 قام <b>الروبوت</b> بإلغاء ارتباطه بـ [<b>{0}</b>] ولم يتم إدراجه كعضو!",
}

l_ccheck_btn_name = {
    'ru': "✔ Я человек",
    'en': "✔ I am human",
    'es': "✔ soy humano",
    'fr': "✔ Je suis humain",
    'zh': "✔ 我是人",
    'ar': "✔ أنا إنسان",
}
l_ccheck_hello_txt = {
    'ru': "🌱 {name}, добро пожаловать в нашу <b>канал</b> {title}!",
    'en': "🌱 {name}, welcome to our {title} <b>channel</b> !",
    'es': "🌱 {name}, ¡bienvenido a nuestro <b>canal</b> {title}!",
    'fr': "🌱 {name}, bienvenue sur notre <b>chaîne</b> {title} !",
    'zh': "🌱 {name}，欢迎来到我们的 {title}<b>频道</b>！",
    'ar': "🌱 {name} ، مرحبًا بك في <b>قناة</b> {title}!",
}
l_ccheck_add_channel = {
    'ru': "👮🏽 Для <i>проверки подписки</i> необходимо добавить канал командой:\n\n/channel ССЫЛКА НА КАНАЛ",
    'en': "👮🏽 To <i>check the subscription,</i> you need to add a channel with the command:\n\n/channel LINK TO THE CHANNEL",
    'es': "👮🏽 Para <i>verificar la suscripción,</i> debe agregar un canal con el comando:\n\n/canal ENLACE AL CANAL",
    'fr': "👮🏽 Pour <i>vérifier l&#x27;abonnement,</i> vous devez ajouter une chaîne avec la commande :\n\n/channel LIEN VERS LA CHAÎNE",
    'zh': "👮🏽 要<i>查看订阅，</i>您需要使用以下命令添加频道：\n\n/channel LINK TO THE CHANNEL",
    'ar': "👮🏽 <i>للتحقق من الاشتراك ،</i> تحتاج إلى إضافة قناة باستخدام الأمر:\n\n/ channel LINK TO THE CHANNEL",
}

# region commands
l_update_text = {
    'ru': "👩🏽‍💻 <b>Данные</b> о канале успешно обновлены:\n\n<b>{0}</b> [{1}]\n{2}\n<i>{3}</i>\n\n⚙️ <b>Команды</b> /cmd",
    'en': "👩🏽‍💻 Channel <b>data</b> successfully updated:\n\n<b>{0}</b> [{1}]\n{2}\n<i>{3}</i>\n\n⚙️ <b>Commands</b> /cmd",
    'es': "👩🏽‍💻 <b>Datos</b> del canal actualizados con éxito:\n\n<b>{0}</b> [{1}]\n{2}\n<i>{3}</i>\n\n⚙️ <b>Comandos</b> /cmd",
    'fr': "👩🏽‍💻 <b>Les données</b> de la chaîne ont été mises à jour :\n\n<b>{0}</b> [{1}]\n{2}\n<i>{3}</i>\n\n⚙️ <b>Commandes</b> /cmd",
    'zh': "👩🏽‍💻 频道<b>数据</b>成功更新：\n\n<b>{0}</b> [{1}]\n{2}\n<i>{3}</i>\n\n⚙️<b>命令</b>/cmd",
    'ar': "👩🏽‍💻 تم تحديث <b>بيانات</b> القناة بنجاح:\n\n<b>{0}</b> [{1}]\n{2}\n<i>{3}</i>\n\n⚙️ <b>الأوامر</b> / cmd",
}
l_chn_commands_handler = {
    'ru': "⚙️ <b>Настройка</b> канала <b>{0}</b> {1}\n\n<b>⛏ Admin-команды @{2}</b>\n/update <i>обновление параметров</i>\n/transfer   <i>передача admin-прав</i>\n/info   <i>информация</i>\n/stat   <i>статистика</i>\n/parse  <i>выгрузка базы подписчиков</i>\n/videochat 1 1 <i>анонс видео-трансляции</i>\n/clean  <i>долгая очистка канала от deleted/scam/fake-аккаунтов, а также по 🕵🏽 Авто-бан правилам</i>\n/channel NAME   <i>добавить другой канал для проверки подписки</i>",
    'en': "⚙️ Channel <b>setup</b> <b>{0}</b> {1}\n\n<b>⛏ Admin commands @{2}</b>\n/update <i>update parameters</i>\n/transfer <i>transfer admin rights</i>\n/info <i>information</i>\n/stat <i>statistics</i>\n/parse <i>upload subscriber bases</i>\n/videochat 1 1 <i>announcement of video broadcast</i>\n/clean <i>long channel cleaning from deleted/scam/fake accounts, as well as according to 🕵🏽 Auto-ban rules</i>\n/channel NAME <i>add another channel to check subscription</i>",
    'es': "⚙️ <b>Configuración</b> del canal <b>{0}</b> {1}\n\n<b>⛏ Comandos de administrador @{2}</b>\n/actualizar <i>parámetros de actualización</i>\n/transferir <i>transferir derechos de administrador</i>\n/ <i>información</i> de información\n/ <i>estadísticas</i>\n/analizar <i>cargar bases de suscriptores</i>\n/videochat 1 1 <i>anuncio de transmisión de video</i>\n/limpie <i>la limpieza de canales largos de cuentas eliminadas/estafas/falsas, así como de acuerdo con las 🕵🏽 reglas de prohibición automática</i>\n/NOMBRE del canal <i>agregue otro canal para verificar la suscripción</i>",
    'fr': "⚙️ <b>Configuration</b> de la chaîne <b>{0}</b> {1}\n\n<b>⛏ Commandes d&#x27;administration @{2}</b>\n/update <i>update parameters</i>\n/transfer <i>transfer admin rights</i>\n/info <i>information</i>\n/stat <i>statistics</i>\n/parse <i>upload subscriber bases</i>\n/videochat 1 1 <i>annonce de la diffusion vidéo</i>\n/nettoyer <i>le nettoyage des longues chaînes des comptes supprimés/arnaques/faux, ainsi que selon les 🕵🏽 règles d&#x27;interdiction automatique</i>\n/channel NAME <i>ajouter une autre chaîne pour vérifier l&#x27;abonnement</i>",
    'zh': "⚙️ 频道<b>设置{0}</b> {1}\n\n<b>⛏ 管理员命令@{2}</b>\n/update<i>更新参数</i>\n/transfer<i>转移管理员权限</i>\n/info<i>信息</i>\n/stat<i>统计</i>\n/parse<i>上传用户群</i>\n/videochat 1 1<i>视频广播公告</i>\n/clean<i>长频道清理已删除/诈骗/假账号，以及根据🕵🏽自动封禁规则</i>\n/channel NAME<i>添加另一个频道查看订阅</i>",
    'ar': "⚙️ <b>إعداد</b> القناة <b>{0}</b> {1}\n\n<b>⛏ أوامر المسؤول @ {2}</b>\n/ <i>تحديث المعلمات</i>\n/ <i>نقل حقوق المسؤول</i>\n/ معلومات <i>المعلومات</i>\n/ <i>الإحصائيات</i> الإحصائية\n/ تحليل <i>قواعد المشتركين في التحميل</i>\n/ videochat 1 1 <i>إعلان عن بث الفيديو</i>\n/ <i>تنظيف قناة طويلة من الحسابات المحذوفة / الاحتيالية / المزيفة ، وكذلك وفقًا لقواعد 🕵🏽 الحظر التلقائي</i>\n/ <i>إضافة قناة أخرى للتحقق من الاشتراك</i>",
}
l_info_restrict = {
    'ru': "запрещено\n",
    'en': "запрещено\n",
    'es': "запрещено\n",
    'fr': "запрещено\n",
    'zh': "запрещено\n",
    'ar': "запрещено\n",
}
l_info_allow = {
    'ru': "разрешено\n",
    'en': "разрешено\n",
    'es': "разрешено\n",
    'fr': "разрешено\n",
    'zh': "разрешено\n",
    'ar': "разрешено\n",
}
l_info_protect = {
    'ru': "<b>Сохранение контента</b>: ",
    'en': "<b>Content saving</b> :",
    'es': "<b>Ahorro de contenido</b> :",
    'fr': "<b>Sauvegarde du contenu</b> :",
    'zh': "<b>内容保存</b>：",
    'ar': "<b>حفظ المحتوى</b> :",
}
l_info_request = {
    'ru': "<b>Вступление после одобрения</b>: ",
    'en': "<b>Entry after approval</b> :",
    'es': "<b>Entrada después de la aprobación</b> :",
    'fr': "<b>Entrée après approbation</b> :",
    'zh': "<b>批准后进入</b>：",
    'ar': "<b>الدخول بعد الموافقة</b> :",
}
l_info_send = {
    'ru': "<b>Возможность писать после вступления</b>: ",
    'en': "<b>Possibility to write after joining</b> :",
    'es': "<b>Posibilidad de escribir después de unirse</b> :",
    'fr': "<b>Possibilité d&#x27;écrire après adhésion</b> :",
    'zh': "<b>加入后可以写</b>：",
    'ar': "<b>إمكانية الكتابة بعد الانضمام</b> :",
}
l_info_subscribe = {
    'ru': "<b>Проверка подписки при вступлении в канал</b>: ",
    'en': "<b>Checking a subscription when joining a channel</b> :",
    'es': "<b>Comprobación de una suscripción al unirse a un canal</b> :",
    'fr': "<b>Vérifier un abonnement lors de l&#x27;adhésion à une chaîne</b> :",
    'zh': "<b>加入频道时检查订阅</b>：",
    'ar': "<b>التحقق من الاشتراك عند الانضمام إلى قناة</b> :",
}
l_info_cmd = {
    'ru': "⚙️ <b>Команды</b> /cmd",
    'en': "⚙️ <b>Commands</b> /cmd",
    'es': "⚙️ <b>Comandos</b> /cmd",
    'fr': "⚙️ <b>Commandes</b> /cmd",
    'zh': "⚙️<b>命令</b>/cmd",
    'ar': "⚙️ <b>أوامر</b> / كمد",
}

l_change_chn_info = {
    'ru': "Изменение профиля канала",
    'en': "Change channel profile",
    'es': "Cambiar perfil de canal",
    'fr': "Modifier le profil de la chaîne",
    'zh': "更改频道配置文件",
    'ar': "تغيير ملف تعريف القناة",
}
l_send_messages = {
    'ru': "Отправка сообщений",
    'en': "Sending messages",
    'es': "Enviando mensajes",
    'fr': "Envoi de messages",
    'zh': "发送信息",
    'ar': "إرسال الرسائل",
}
l_info_reactions = {
    'ru': "Допуск emoji-реакций",
    'en': "Allow emoji reactions",
    'es': "Permitir reacciones emoji",
    'fr': "Autoriser les réactions emoji",
    'zh': "允许表情符号反应",
    'ar': "السماح بردود فعل الرموز التعبيرية",
}
l_admins = {
    'ru': "Администраторы",
    'en': "Administrators",
    'es': "Administradores",
    'fr': "Administrateurs",
    'zh': "管理员",
    'ar': "المسؤولين",
}

l_info_invite_admins = {
    'ru': "Приглашение других админов для",
    'en': "Invite other admins to",
    'es': "Invitar a otros administradores a",
    'fr': "Invitez d'autres administrateurs à",
    'zh': "邀请其他管理员",
    'ar': "قم بدعوة مدراء آخرين إلى",
}
l_chn_info_start1 = {
    'ru': "ℹ️ <b>Общая информация о канале</b>\n\n<b>Название</b>: {0} [id={1}, <i>{2} {3}</i>, <u>{4}</u> участ.]{5}{6}{7}",
    'en': "ℹ️ <b>General information about the channel</b>\n\n<b>Name</b> : {0} [id= {1} , <i>{2} {3}</i> , <u>{4}</u> members]{5}{6}{7}",
    'es': "ℹ️ <b>Información general sobre el canal</b>\n\n<b>Nombre</b> : {0} [id= {1} , <i>{2} {3}</i> , <u>{4}</u> miembros]{5}{6}{7}",
    'fr': "ℹ️ <b>Informations générales sur la chaîne</b>\n\n<b>Nom</b> : {0} [id= {1} , <i>{2} {3}</i> , <u>{4}</u> membres]{5}{6}{7}",
    'zh': "ℹ️<b>有关频道的一般信息</b>\n\n<b>名称</b>：{0} [id= {1} , <i>{2} {3}</i> , <u>{4}</u>成员]{5}{6}{7}",
    'ar': "ℹ️ <b>معلومات عامة عن القناة</b>\n\n<b>الاسم</b> : {0} [id = {1} ، <i>{2} {3}</i> ، <u>{4}</u> members] {5} {6} {7}",
}
l_chn_stat_start1 = {
    'ru': "ℹ️ <b>Общая статистика канала</b>\n\n<b>Название</b>: {0} [id={1}, <i>{2} {3}</i>, <u>{4}</u> участ.]{5}{6}{7}",
    'en': "ℹ️ <b>General channel statistics</b>\n\n<b>Title</b> : {0} [id= {1} , <i>{2} {3}</i> , <u>{4}</u> members]{5}{6}{7}",
    'es': "ℹ️ <b>Estadísticas generales del canal</b>\n\n<b>Nombre</b> : {0} [id= {1} , <i>{2} {3}</i> , <u>{4}</u> miembros]{5}{6}{7}",
    'fr': "ℹ️ <b>Statistiques générales de la chaîne</b>\n\n<b>Titre</b> : {0} [id= {1} , <i>{2} {3}</i> , <u>{4}</u> membres]{5}{6}{7}",
    'zh': "ℹ️<b>一般频道统计信息</b>\n\n<b>标题</b>：{0} [id= {1} , <i>{2} {3}</i> , <u>{4}</u>成员]{5}{6}{7}",
    'ar': "ℹ️ <b>إحصائيات القناة العامة</b>\n\n<b>العنوان</b> : {0} [id = {1} ، <i>{2} {3}</i> ، <u>{4}</u> members] {5} {6} {7}",
}
l_chn_stat_start2 = {
    'ru': "\n<b>Ссылка</b>: {0}\n<b>Описание</b>: {1}\n<b>Привязанная группа</b>: {2}\n",
    'en': "\n<b>Link</b> : {0}\n<b>Description</b> : {1}\n<b>Link Group</b> : {2}\n",
    'es': "\n<b>Enlace</b> : {0}\n<b>Descripción</b> : {1}\n<b>Grupo de enlaces</b> : {2}\n",
    'fr': "\n<b>Lien</b> : {0}\n<b>Description</b> : {1}\n<b>Groupe de liens</b> : {2}\n",
    'zh': "\n<b>链接</b>：{0}\n<b>描述</b>：{1}\n<b>链接组</b>： {2}\n",
    'ar': "\n<b>الارتباط</b> : {0}\n<b>الوصف</b> : {1}\n<b>مجموعة الروابط</b> : {2}\n",
}
l_chn_stat_start3 = {
    'ru': "\n<b>ID последнего поста</b>: {0}\n<b>Посты</b>: {1}\n<b>Реакции</b>: {2}\n<b>Просмотры</b>: {3}\n<b>Комментарии</b>: {4}\n<b>$кэштеги</b>: {5}\n<b>#хэштеги</b>: {6}\n",
    'en': "\n<b>Last Post ID</b> : {0}\n<b>Posts</b> : {1}\n<b>Reactions</b> : {2}\n<b>Views</b> : {3}\n<b>Comments</b> : {4}\n<b>$cashtags</b> : {5}\n<b>#hashtags</b> : {6}\n",
    'es': "\n<b>ID de la última publicación</b> : {0}\n<b>Publicaciones</b> : {1}\n<b>Reacciones</b> : {2}\n<b>Vistas</b> : {3}\n<b>Comentarios</b> : {4}\n<b>$cashtags</b> : {5}\n<b>#hashtags</b> : {6}\n",
    'fr': "\n<b>ID du dernier message</b> : {0}\n<b>Messages</b> : {1}\n<b>Réactions</b> : {2}\n<b>Vues</b> : {3}\n<b>Commentaires</b> : {4}\n<b>$cashtags</b> : {5}\n<b>#hashtags</b> : {6}\n",
    'zh': "\n<b>最后的帖子 ID</b> ：{0}\n<b>帖子</b>：{1}\n<b>反应</b>：{2}\n<b>浏览量</b>：{3}\n<b>评论</b>：{4}\n<b>$cashtags</b> ：{5}\n<b>#hashtags</b> ： {6}\n",
    'ar': "\n<b>معرّف آخر مشاركة</b> : {0}\n<b>المشاركات</b> : {1}\n<b>ردود الفعل</b> : {2}\n<b>المشاهدات</b> : {3}\n<b>التعليقات</b> : {4}\n<b>$ cashtags</b> : {5}\n<b>#hashtags</b> : {6}\n",
}
l_top_hashtags = {
    'ru': "\n<b>Топ #хэштеги</b>:\n{0}\n",
    'en': "\n<b>Group</b> <b>#хэштеги</b> :\n{0}\n",
    'es': "\n<b>#хэштеги</b> <b>de grupo</b> :\n{0}\n",
    'fr': "\n<b>Groupe</b> <b>#хэштеги</b> :\n{0}\n",
    'zh': "\n<b>组#хэштеги</b> ：\n{0}\n",
    'ar': "\n<b>Group</b> <b>#хэштеги</b> :\n{0}\n",
}

l_transfer_start = {
    'ru': "⚠️ Пользователь {0} должен /start-запустить @{1}",
    'en': "⚠️ User {0} must /start-start @{1}",
    'es': "⚠️ El usuario {0} debe /start-start @{1}",
    'fr': "⚠️ L'utilisateur {0} doit /start-start @{1}",
    'zh': "⚠️ 用户 {0} 必须 /start-start @{1}",
    'ar': "⚠️ المستخدم {0} must / start-start @ {1}",
}
l_transfer_admin = {
    'ru': "⚠️ Пользователь {0} должен быть <b>администратором</b> в <b>{1}</b>",
    'en': "⚠️ User {0} must be <b>an administrator</b> in <b>{1}</b>",
    'es': "⚠️ El usuario {0} debe ser <b>administrador</b> en <b>{1}</b>",
    'fr': "⚠️ L'utilisateur {0} doit être <b>administrateur</b> dans <b>{1}</b>",
    'zh': "⚠️ 用户 {0} 必须是<b>{1}</b>的<b>管理员</b>",
    'ar': "⚠️ يجب أن يكون المستخدم {0} <b>مسؤولاً</b> في <b>{1}</b>",
}
l_transfer_transfer = {
    'ru': "⚠️ Передать <b>admin</b>-права на <b>{0}</b> пользователю {1} в @{2}-боте?",
    'en': "⚠️ Transfer <b>admin</b> rights to <b>{0}</b> to user {1} in @{2}-bot?",
    'es': "⚠️ ¿Transferir los derechos <b>de administrador</b> de <b>{0}</b> al usuario {1} en @{2}-bot?",
    'fr': "⚠️ Transférer les droits <b>d&#x27;administrateur</b> de <b>{0}</b> à l'utilisateur {1} dans @{2}-bot ?",
    'zh': "⚠️ 在@{2}-bot 中将<b>{0}的管理员</b>权限转让给用户 {1}？",
    'ar': "⚠️ نقل حقوق <b>المسؤول</b> إلى <b>{0}</b> إلى المستخدم {1} في @ {2} -bot؟",
}
l_transfer_text = {
    'ru': "⚠️ Для передачи admin-прав канала в @{0}-боте используй команду: /transfer ID-ПОЛЬЗОВАТЕЛЯ (/id), где пользователь: администратор канала и участник @{0}-бота\n\n⚙️ <b>Команды</b> /cmd",
    'en': "⚠️ To transfer channel admin rights to @{0}-bot, use the command: /transfer ID-ПОЛЬЗОВАТЕЛЯ (/id), where user: channel administrator and member of @{0}-bot\n\n⚙️ <b>Commands</b> /cmd",
    'es': "⚠️ Para transferir los derechos de administrador del canal a @{0}-bot, usa el comando: /transfer ID-ПОЛЬЗОВАТЕЛЯ (/id), donde usuario: administrador del canal y miembro de @{0}-bot\n\n⚙️ <b>Comandos</b> /cmd",
    'fr': "⚠️ Pour transférer les droits d'administrateur du canal à @{0}-bot, utilisez la commande : /transfer ID-ПОЛЬЗОВАТЕЛЯ (/id), où utilisateur : administrateur du canal et membre de @{0}-bot\n\n⚙️ <b>Commandes</b> /cmd",
    'zh': "⚠️ 要将频道管理员权限转移给@{0}-bot，请使用命令： /transfer ID-ПОЛЬЗОВАТЕЛЯ (/id)，其中用户：频道管理员和@{0}-bot 的成员\n\n⚙️<b>命令</b>/cmd",
    'ar': "⚠️ لنقل حقوق مسؤول القناة إلى @ {0} -bot ، استخدم الأمر: /transfer ID-ПОЛЬЗОВАТЕЛЯ (/ id) ، حيث المستخدم: مسؤول القناة وعضو @ {0} -bot\n\n⚙️ <b>Commands</b> / cmd",
}
l_transfer_done_to = {
    'ru': "⚠️ <b>Admin</b>-права на [<b>{0}</b>] успешно переданы {1}",
    'en': "⚠️ <b>Admin</b> rights to [<b>{0}</b>] successfully transferred to {1}",
    'es': "⚠️ Derechos <b>de administrador</b> de [<b>{0}</b>] transferidos con éxito a {1}",
    'fr': "⚠️ Les droits <b>d&#x27;administrateur</b> de [<b>{0}</b>] ont été transférés avec succès à {1}",
    'zh': "⚠️ [<b>{0}</b>] 的<b>管理员</b>权限已成功转移给 {1}",
    'ar': "⚠️ تم نقل حقوق <b>المسؤول</b> لـ [<b>{0}</b>] بنجاح إلى {1}",
}
l_transfer_done_from = {
    'ru': "⚠️ <b>Admin</b>-права на [<b>{0}</b>] успешно получены от {1}",
    'en': "⚠️ <b>Admin</b> rights to [<b>{0}</b>] successfully obtained from {1}",
    'es': "⚠️ Derechos <b>de administrador</b> para [<b>{0}</b>] obtenidos con éxito de {1}",
    'fr': "⚠️ Les droits <b>d&#x27;administrateur</b> de [<b>{0}</b>] ont été obtenus avec succès auprès de {1}",
    'zh': "⚠️ 已成功从 {1} 获得 [<b>{0}</b>] 的<b>管理员</b>权限",
    'ar': "⚠️ تم الحصول على حقوق <b>المسؤول</b> لـ [<b>{0}</b>] بنجاح من {1}",
}
l_chn_check = {
    'ru': "⚙️ Добавь @{0}-бота в канал для проверки подписки на него. Пришли мне корректную ссылку на канал:",
    'en': "⚙️ Add @{0}-bot to the channel to check if you subscribe to it. Send me the correct link to the channel:",
    'es': "⚙️ Agrega @{0}-bot al canal para comprobar si estás suscrito. Envíame el enlace correcto al canal:",
    'fr': "⚙️ Ajoutez @{0}-bot à la chaîne pour vérifier si vous y êtes abonné. Envoyez-moi le bon lien vers la chaîne :",
    'zh': "⚙️ 将@{0}-bot 添加到频道以检查您是否订阅了它。向我发送正确的频道链接：",
    'ar': "⚙️ أضف @ {0} -bot إلى القناة للتحقق مما إذا كنت مشتركًا فيها. أرسل لي الرابط الصحيح للقناة:",
}
l_videochat_rights = {
    'ru': "🎥 В настройках [Администраторы] вкл опцию для @{0}-бота:\n[✅ Назначение администраторов]\n[✅ Управление трансляциями]\n\n🕚Подожди 1min",
    'en': "🎥 In the [Administrators] settings, enable the option for @{0}-bot:\n[✅ Assign administrators]\n[✅ Manage broadcasts]\n\n🕚Wait 1min",
    'es': "🎥 En la configuración de [Administradores], habilita la opción para @{0}-bot:\n[✅ Asignar administradores]\n[✅ Administrar transmisiones]\n\n🕚Espera 1 minuto",
    'fr': "🎥 Dans les paramètres [Administrateurs], activez l'option pour @{0}-bot :\n[✅ Attribuer des administrateurs]\n[✅ Gérer les diffusions]\n\n🕚Attendez 1 min",
    'zh': "🎥 在 [Administrators] 设置中，启用 @{0}-bot 的选项：\n[✅ 分配管理员]\n[✅ 管理广播]\n\n🕚等待 1 分钟",
    'ar': "🎥 في إعدادات [Administrators] ، قم بتمكين خيار @ {0} -bot:\n[✅ تعيين المسؤولين]\n[✅ إدارة عمليات البث]\n\n🕚 انتظر لمدة دقيقة",
}
l_videochat_handler = {
    'ru': "🎥 Автоматическое анонсирование <b>видео-трансляции</b> [/videochat d h] каждый <u>d</u>-день (1-31) на <u>h</u>-часов (1-168). Текущее значение: /videochat {0}\n\n👩🏽‍💻 Например,\n/videochat 1 1 (ежедневный видео-анонс длительностью 1 час)\n/videochat 0 (отключение опции)\n\n⚙️ <b>Команды</b> /cmd",
    'en': "🎥 Automatic announcement <b>of the video broadcast</b> [/videochat dh] every <u>d</u> -day (1-31) for <u>h</u> -hours (1-168). Current value: /videochat {0}\n\n👩🏽‍💻 For example\n/videochat 1 1 (daily 1 hour video announcement)\n/videochat 0 (disable option)\n\n⚙️ <b>Commands</b> /cmd",
    'es': "🎥 Anuncio automático <b>de la transmisión de video</b> [/videochat dh] cada <u>d</u> -día (1-31) durante <u>h</u> -horas (1-168). Valor actual: /videochat {0}\n\n👩🏽‍💻 Por ejemplo\n/videochat 1 1 (anuncio de video diario de 1 hora)\n/videochat 0 (opción deshabilitada)\n\n⚙️ <b>Comandos</b> /cmd",
    'fr': "🎥 Annonce automatique <b>de la diffusion vidéo</b> [/videochat dh] tous <u>les j</u> -jours (1-31) pendant <u>h</u> -heures (1-168). Valeur actuelle : /videochat {0}\n\n👩🏽‍💻 Par exemple\n/videochat 1 1 (annonce vidéo quotidienne d&#x27;une heure)\n/videochat 0 (option de désactivation)\n\n⚙️ <b>Commandes</b> /cmd",
    'zh': "🎥 每<u>d</u>天（1-31）自动播报<b>视频广播</b>[/videochat dh] ，持续<u>h</u>小时（1-168）。当前值：/videochat {0}\n\n👩🏽‍💻 例如\n/videochat 1 1 （每日 1 小时视频公告）\n/videochat 0 （禁用选项）\n\n⚙️<b>命令</b>/cmd",
    'ar': "🎥 الإعلان التلقائي <b>عن بث الفيديو</b> [/videochat dh] كل يوم <u>يوم</u> (1-31) لمدة <u>ساعة</u> (1-168). القيمة الحالية: / videochat {0}\n\n👩🏽‍💻 على سبيل المثال\n/videochat 1 1 (إعلان فيديو لمدة ساعة يوميًا)\n/videochat 0 (خيار تعطيل)\n\n⚙️ <b>أوامر</b> / cmd",
}
l_videochat_on = {
    'ru': "🎥 Анонсирована <b>видео-трансляция</b>: каждый <u>{0}</u> день на <u>{1}</u> часов\n\n⚙️ <b>Команды</b> /cmd",
    'en': "🎥 <b>Video stream</b> announced : every <u>{0}</u> day for <u>{1}</u> hours\n\n⚙️ <b>Commands</b> /cmd",
    'es': "🎥 <b>Transmisión de video</b> anunciada: cada <u>{0}</u> día durante <u>{1}</u> horas\n\n⚙️ <b>Comandos</b> /cmd",
    'fr': "🎥 <b>Flux vidéo</b> annoncé : tous les <u>{0}</u> jours pendant <u>{1}</u> heures\n\n⚙️ <b>Commandes</b> /cmd",
    'zh': "🎥<b>视频流</b>公布：每<u>{0}</u>天<u>{1}</u>小时\n\n⚙️<b>命令</b>/cmd",
    'ar': "🎥 الإعلان عن <b>بث الفيديو</b> : كل <u>{0}</u> يوم لمدة <u>{1}</u> ساعات\n\n⚙️ <b>أوامر</b> / cmd",
}
l_videochat_off = {
    'ru': "🎥 Анонсирование <b>видео-трансляции</b> отключено\n\n⚙️ <b>Команды</b> /cmd",
    'en': "🎥 <b>Video broadcast</b> announcements are disabled\n\n⚙️ <b>Commands</b> /cmd",
    'es': "🎥 Los anuncios <b>de transmisión de video</b> están deshabilitados\n\n⚙️ <b>Comandos</b> /cmd",
    'fr': "🎥 Les annonces <b>de diffusion vidéo</b> sont désactivées\n\n⚙️ <b>Commandes</b> /cmd",
    'zh': "🎥<b>视频广播</b>公告被禁用\n\n⚙️<b>命令</b>/cmd",
    'ar': "🎥 إعلانات <b>بث الفيديو</b> معطلة\n\n<b>أوامر</b> / cmd",
}
l_ban_users_start = {
    'ru': "👩🏽‍💻 <b>Очистка</b> запущена\n<b>Текущее</b> количество пользователей в базе: <u>{0}</u>",
    'en': "👩🏽‍💻 <b>Cleanup</b> started\n<b>Current</b> number of users in the database: <u>{0}</u>",
    'es': "👩🏽‍💻 <b>Limpieza</b> iniciada\nNúmero <b>actual</b> de usuarios en la base de datos: <u>{0}</u>",
    'fr': "👩🏽‍💻 <b>Le nettoyage</b> a commencé\nNombre <b>actuel</b> d&#x27;utilisateurs dans la base de données : <u>{0}</u>",
    'zh': "👩🏽‍💻<b>清理</b>开始\n数据库中的<b>当前</b>用户数： <u>{0}</u>",
    'ar': "👩🏽‍💻 بدأ <b>التنظيف</b>\nالعدد <b>الحالي</b> للمستخدمين في قاعدة البيانات: <u>{0}</u>",
}
l_ban_users_stop = {
    'ru': "👩🏽‍💻 <b>Очистка</b> завершена\n<b>Текущее</b> количество пользователей в базе: <u>{0}</u> (-{1})",
    'en': "👩🏽‍💻 <b>Cleanup</b> completed\n<b>Current</b> number of users in the database: <u>{0}</u> (-{1})",
    'es': "👩🏽‍💻 <b>Limpieza</b> completada\nNúmero <b>actual</b> de usuarios en la base de datos: <u>{0}</u> (-{1})",
    'fr': "👩🏽‍💻 <b>Nettoyage</b> terminé\nNombre <b>actuel</b> d&#x27;utilisateurs dans la base de données : <u>{0}</u> (-{1})",
    'zh': "👩🏽‍💻<b>清理</b>完成\n数据库中的<b>当前</b>用户数： <u>{0}</u> (-{1})",
    'ar': "👩🏽‍💻 اكتمل <b>التنظيف</b>\nالعدد <b>الحالي</b> للمستخدمين في قاعدة البيانات: <u>{0}</u> (- {1})",
}
l_chn_ccheck_handler = {
    'ru': "👮🏽 <b>Жми</b> на ✅/🔘, чтобы <b>переключить</b> тип <i>проверки</i> пользователя при <u>вступлении</u> по сгенерированной ссылке: {0} (только для ЧАСТНЫХ каналов)\n\n👉🏼 Для <b>проверки подписки</b> на другой канал <i>добавь</i> @{1}-бота в канал и выполни команду: /channel {2}\n\n👉🏼 Для <i>защиты от атаки</i> на канал включи режим <b>антирейд</b> (блокировка <u>всех</u> вступающих)",
    'en': "👮🏽 <b>Click</b> on ✅/🔘 to <b>switch</b> user <i>verification</i> type when <u>joining</u> via generated link: {0} (only for ЧАСТНЫХ channels)\n\n👉🏼 To <b>check subscription</b> to another channel, <i>add</i> @{1}-bot to the channel and run the command: /channel {2}\n\n👉🏼 To <i>protect against an attack</i> on the channel, turn on <b>the anti-raid</b> mode (block <u>all</u> intruders)",
    'es': "👮🏽 <b>Haz clic</b> en ✅/🔘 para <b>cambiar</b> el tipo <i>de verificación</i> de usuario al <u>unirse</u> a través del enlace generado: {0} (solo para canales ЧАСТНЫХ )\n\n👉🏼 Para <b>verificar la suscripción</b> a otro canal, <i>agrega</i> @{1}-bot al canal y ejecuta el comando: /channel {2}\n\n👉🏼 Para <i>protegerte contra un ataque</i> en el canal, activa <b>el modo anti-raid</b> (bloquea <u>a todos</u> los intrusos)",
    'fr': "👮🏽 <b>Cliquez</b> sur ✅/🔘 pour <b>changer</b> le type <i>de vérification</i> de l&#x27;utilisateur lors <u>de la connexion</u> via un lien généré : {0} (uniquement pour les canaux ЧАСТНЫХ )\n\n👉🏼 Pour <b>vérifier l&#x27;abonnement</b> à un autre canal, <i>ajoutez</i> @{1}-bot au canal et lancez la commande : /channel {2}\n\n👉🏼 Pour <i>vous protéger contre une attaque</i> sur le channel, activez <b>le mode anti-raid</b> (bloquer <u>tous</u> les intrus)",
    'zh': "👮🏽<b>点击</b>✅/🔘 在通过生成的链接<u>加入</u>时<b>切换</b>用户<i>验证</i>类型：{0}（仅适用于ЧАСТНЫХ频道）\n\n👉🏼 要<b>检查对另一个频道的订阅</b>，请将 @{1}-bot<i>添加</i>到频道并运行命令： /channel {2}\n\n👉🏼 为<i>防止通道受到攻击</i>，请开启<b>防突袭</b>模式（阻止<u>所有</u>入侵者）",
    'ar': "👮🏽 <b>انقر</b> على ✅ / 🔘 <b>لتبديل</b> نوع <i>التحقق</i> من المستخدم عند <u>الانضمام</u> عبر الرابط الذي تم إنشاؤه: {0} (للقنوات ЧАСТНЫХ فقط)\n\n👉🏼 للتحقق <b>من الاشتراك</b> في قناة أخرى ، <i>أضف</i> @ {1} -bot إلى القناة وقم بتشغيل الأمر: /channel {2}\n\n👉🏼 <i>للحماية من هجوم</i> على القناة ، قم بتشغيل الوضع <b>المضاد للغارة</b> (حظر <u>جميع</u> المتسللين)",
}
l_ccheck_call = {
    'ru': "👮🏽 Для проверки подписки необходимо добавить дополнительный канал командой:\n\n/channel ССЫЛКА НА КАНАЛ",
    'en': "👮🏽 To check the subscription, you need to add an additional channel with the command:\n\n/channel LINK TO THE CHANNEL",
    'es': "👮🏽 Para verificar la suscripción, debe agregar un canal adicional con el comando:\n\n/canal ENLACE AL CANAL",
    'fr': "👮🏽 Pour vérifier l'abonnement, vous devez ajouter une chaîne supplémentaire avec la commande :\n\n/channel LIEN VERS LA CHAÎNE",
    'zh': "👮🏽 要检查订阅，您需要使用以下命令添加一个额外的频道：\n\n/channel LINK TO THE CHANNEL",
    'ar': "👮🏽 للتحقق من الاشتراك ، تحتاج إلى إضافة قناة إضافية باستخدام الأمر:\n\n/ channel LINK TO THE CHANNEL",
}
l_ccheck_call2 = {
    'ru': "👮🏽 В настройках [Администраторы] вкл опцию для @{0}-бота:\n[✅ Удаление сообщ]\n[✅ Блокировка польз]\n[✅ Добавление участ]\n\n🕚Подожди 1min",
    'en': "👮🏽 In the [Administrators] settings, enable the option for @{0}-bot:\n[✅ Delete messages]\n[✅ Block users]\n[✅ Add members]\n\n🕚Wait 1min",
    'es': "👮🏽 En la configuración de [Administradores], habilita la opción para @{0}-bot:\n[✅ Eliminar mensajes]\n[✅ Bloquear usuarios]\n[✅ Agregar miembros]\n\n🕚Espera 1 minuto",
    'fr': "👮🏽 Dans les paramètres [Administrateurs], activez l'option pour @{0}-bot :\n[✅ Supprimer les messages]\n[✅ Bloquer les utilisateurs]\n[✅ Ajouter des membres]\n\n🕚Attendez 1min",
    'zh': "👮🏽 在 [管理员] 设置中，启用@{0}-bot 的选项：\n[✅ 删除消息]\n[✅ 阻止用户]\n[✅ 添加成员]\n\n🕚 等待 1 分钟",
    'ar': "👮🏽 في إعدادات [Administrators] ، قم بتمكين خيار @ {0} -bot:\n[✅ حذف الرسائل]\n[✅ حظر المستخدمين]\n[✅ إضافة أعضاء]\n\n🕚 انتظر دقيقة واحدة",
}
l_ccheck_chn_finish = {
    'ru': "👮🏽 <b>{0}</b>, <b>добро пожаловать</b>:\n\n{1}",
    'en': "👮🏽 <b>{0}</b> , <b>welcome</b> :\n\n{1}",
    'es': "👮🏽 <b>{0}</b> , <b>bienvenido</b> :\n\n{1}",
    'fr': "👮🏽 <b>{0}</b> , <b>bienvenue</b> :\n\n{1}",
    'zh': "👮🏽 <b>{0}</b> ，<b>欢迎</b>：\n\n{1}",
    'ar': "👮🏽 <b>{0}</b> ، <b>مرحبًا بك</b> :\n\n{1}",
}
l_ccheck_free_on = {
    'ru': "✅☑Вкл свободный вход",
    'en': "✅☑Free entry included",
    'es': "✅☑Incluye entrada gratuita",
    'fr': "✅☑Entrée gratuite incluse",
    'zh': "✅包括免费入场",
    'ar': "✅☑ يشمل الدخول المجاني",
}
l_ccheck_free_off = {
    'ru': "🔘️☐Выкл свободный вход",
    'en': "🔘️☐Off free entry",
    'es': "🔘️☐Entrada gratuita",
    'fr': "🔘️☐Hors entrée gratuite",
    'zh': "🔘️☐关闭免费入场",
    'ar': "🔘️☐ من الدخول المجاني",
}
l_ccheck_button_on = {
    'ru': "✅☑Вкл нажатие на кнопку",
    'en': "✅☑On pressing the button",
    'es': "✅☑Al presionar el botón",
    'fr': "✅☑En appuyant sur le bouton",
    'zh': "✅☑按下按钮",
    'ar': "عند الضغط على الزر",
}
l_ccheck_button_off = {
    'ru': "🔘️☐Выкл нажатие на кнопку",
    'en': "🔘️☐Off button press",
    'es': "🔘️☐Presione el botón de apagado",
    'fr': "🔘️☐ Appuyez sur le bouton Off",
    'zh': "🔘️☐按下关闭按钮",
    'ar': "اضغط على زر Off",
}
l_ccheck_subscribe_on = {
    'ru': "✅☑Вкл подписку",
    'en': "✅☑Include subscription",
    'es': "✅☑Incluye suscripción",
    'fr': "✅☑Inclure l'abonnement",
    'zh': "✅☑包括订阅",
    'ar': "✅☑ تضمين الاشتراك",
}
l_ccheck_subscribe_off = {
    'ru': "🔘☐Выкл подписку",
    'en': "🔘☐Subscribe off",
    'es': "🔘☐Suscríbete",
    'fr': "🔘☐Abonnez-vous",
    'zh': "🔘☐取消订阅",
    'ar': "🔘☐Subscribe off",
}
l_ccheck_eq_on = {
    'ru': "✅☑Вкл решение уравнения",
    'en': "✅☑Includes solving equations",
    'es': "✅☑Incluye resolución de ecuaciones",
    'fr': "✅☑Comprend la résolution d'équations",
    'zh': "✅☑包括解方程",
    'ar': "✅☑ يتضمن حل المعادلات",
}
l_ccheck_eq_off = {
    'ru': "🔘️☐Выкл решение уравнения",
    'en': "🔘️☐Off Equation Solving",
    'es': "🔘️☐Resolución de ecuaciones",
    'fr': "🔘️☐Hors résolution d'équations",
    'zh': "🔘️☐解方程",
    'ar': "🔘️☐ Off حل المعادلات",
}
l_ccheck_captcha_on = {
    'ru': "✅☑Вкл решение капчи",
    'en': "✅☑Includes captcha solution",
    'es': "✅☑Incluye solución captcha",
    'fr': "✅☑Comprend une solution captcha",
    'zh': "✅☑包括验证码解决方案",
    'ar': "✅☑ يتضمن حل captcha",
}
l_ccheck_captcha_off = {
    'ru': "🔘️☐Выкл решение капчи",
    'en': "🔘️☐Turn off captcha solution",
    'es': "🔘️☐Desactivar solución captcha",
    'fr': "🔘️☐Désactiver la solution captcha",
    'zh': "🔘️☐关闭验证码解决方案",
    'ar': "🔘️☐ قم بإيقاف تشغيل حل captcha",
}
l_ccheck_request_on = {
    'ru': "✅☑Вкл подачу заявки",
    'en': "✅☑On application submission",
    'es': "✅☑Sobre la presentación de la solicitud",
    'fr': "✅☑Sur dépôt de candidature",
    'zh': "✅ 递交申请",
    'ar': "✅☑ عند تقديم الطلب",
}
l_ccheck_request_off = {
    'ru': "🔘️☐Выкл подачу заявки",
    'en': "🔘️☐Turn off application submission",
    'es': "🔘️☐Desactivar el envío de solicitudes",
    'fr': "🔘️☐Désactiver la soumission de candidature",
    'zh': "🔘️☐关闭申请提交",
    'ar': "🔘️☐ قم بإيقاف تقديم الطلب",
}
l_ccheck_antiraid_on = {
    'ru': "✅☑Вкл анти-рейд",
    'en': "✅☑Enable anti-raid",
    'es': "✅☑Activar anti-incursión",
    'fr': "✅☑Activer l'anti-raid",
    'zh': "✅☑启用防突袭",
    'ar': "✅☑ تمكين مكافحة الغارة",
}
l_ccheck_antiraid_off = {
    'ru': "🔘️☐Выкл антирейд",
    'en': "🔘️☐Off anti-raid",
    'es': "🔘️☐Desactivado anti-raid",
    'fr': "🔘️☐Off anti-raid",
    'zh': "🔘️☐关闭防突袭",
    'ar': "🔘️☐ Off مكافحة الغارة",
}
# endregion


# region cban_
l_cban_add = {
    'ru': "🕵🏽 <b>Введи</b> id или @username пользователей  через <i>пробельные или разделительные</i> символы, чтобы добавить их в /ban-список (*даже тех, кого нет <u>{0}</u>-файле)\n\n👩🏽‍💻 <b>Текущее</b> число пользователей /ban-списка: <u>{1}</u>",
    'en': "🕵🏽 <b>Enter</b> user id or @username separated by spaces or separators to add them to the /ban list (*even those not in the <u>{0}</u> file)\n\n👩🏽‍💻 <b>Current</b> number of users on the /ban list : <u>{1}</u>",
    'es': "🕵🏽 <b>Ingrese</b> id de usuario o @username usuario separados por espacios o separadores para agregarlos a la lista de /ban (*incluso aquellos que no están en el archivo <u>{0}</u> )\n\n👩🏽‍💻 Número <b>actual</b> de usuarios en la lista de /ban : <u>{1}</u>",
    'fr': "🕵🏽 <b>Entrez</b> id ou @username d&#x27;utilisateur séparés par des espaces ou des séparateurs pour les ajouter à la liste /ban (*même ceux qui ne figurent pas dans le fichier <u>{0}</u> )\n\n👩🏽‍💻 Nombre <b>actuel</b> d&#x27;utilisateurs sur la liste /ban : <u>{1}</u>",
    'zh': "🕵🏽<b>输入</b>用空格或分隔符分隔的用户id或@username ，将他们添加到 /ban 列表（*即使那些不在<u>{0}</u>文件中的）\n\n👩🏽‍💻 /ban 列表中的<b>当前</b>用户数： <u>{1}</u>",
    'ar': "🕵🏽 <b>أدخل</b> id المستخدم أو @username مفصولة بمسافات أو فواصل لإضافتهما إلى / قائمة الحظر (* حتى أولئك غير الموجودين في <u>{0}</u> الملف)\n\n👩🏽‍💻 العدد <b>الحالي</b> للمستخدمين في / قائمة الحظر : <u>{1}</u>",
}
l_cban_remove = {
    'ru': "🕵🏽 <b>Введи</b> id или @username пользователей из <u>{0}</u>-файла через <i>пробельные или разделительные</i> символы, чтобы удалить их из /ban-списка\n\n👩🏽‍💻 <b>Текущее</b> число пользователей /ban-списка: <u>{1}</u>",
    'en': "🕵🏽 <b>Enter</b> id or @username of users from <u>{0}</u> -file separated by spaces or separators to remove them from /ban-list\n\n👩🏽‍💻 <b>Current</b> number of users /ban-list: <u>{1}</u>",
    'es': "🕵🏽 <b>Ingrese</b> id o @username de los usuarios de <u>{0}</u> -archivo separado por espacios o separadores para eliminarlos de /ban-list\n\n👩🏽‍💻 Número <b>actual</b> de usuarios /ban-list: <u>{1}</u>",
    'fr': "🕵🏽 <b>Entrez</b> id ou @username utilisateur des utilisateurs de <u>{0}</u> -fichier séparés par des espaces ou des séparateurs pour les supprimer de /ban-list\n\n👩🏽‍💻 Nombre <b>actuel</b> d&#x27;utilisateurs /ban-list : <u>{1}</u>",
    'zh': "🕵🏽<b>输入</b><u>{0}</u>文件中用户的id或@username ，以空格或分隔符分隔，以将其从 /ban-list 中删除\n\n👩🏽‍💻<b>当前</b>用户数 /ban-list： <u>{1}</u>",
    'ar': "🕵🏽 <b>أدخل</b> id أو @username للمستخدمين من <u>{0}</u> - ملف مفصول بمسافات أو فواصل لإزالتهم من / ban-list\n\n👩🏽‍💻 العدد <b>الحالي</b> للمستخدمين / قائمة الحظر: <u>{1}</u>",
}
l_cban_added = {
    'ru': "🕵🏽 Пользователь {0} добавлен в /ban-список (причина: <i>{1}</i>)",
    'en': "🕵🏽 User {0} added to /ban list (reason: <i>{1}</i> )",
    'es': "🕵🏽 Usuario {0} agregado a /lista de prohibición (razón: <i>{1}</i> )",
    'fr': "🕵🏽 L'utilisateur {0} a été ajouté à la liste /ban (raison : <i>{1}</i> )",
    'zh': "🕵🏽 用户 {0} 添加到 /ban 列表（原因： <i>{1}</i> ）",
    'ar': "🕵🏽 تمت إضافة المستخدم {0} إلى / قائمة الحظر (السبب: <i>{1}</i> )",
}
l_cban_text = {
    'ru': "🕵🏽 <b>Жми</b> на ✅/☑️ чтобы <b>Вкл/Выкл</b> бан <u>пользователей</u> бота: <i>с недавно зарегистрированными new-id/аккаунтов без @username/аккаунтов из <a href='https://cas.chat'>Anti-Spam Системы</a>/аккаунтов с 文-глиф, ب-араб/ <a href='https://www.zalgo.org'>zalgo-символами</a></i>\n\n👩🏽‍💻 <b>Команды</b>:\n/cmd - все команды\n/ban - блок/разблок пользователя\n/parse - вывести всех пользователей",
    'en': "🕵🏽 <b>Click</b> on ✅/☑️ to <b>enable/disable</b> ban of bot <u>users</u> : <i>with newly registered new-id/accounts without</i> <i>@username</i> <i>/accounts from</i> <i>Anti-Spam System</i> <i>/accounts with 文-glyph, ب-arab/</i> <i>zalgo-characters</i>\n\ n👩🏽‍💻 <b>Commands</b> :\n/cmd - all commands\n/ban - block/unblock user\n/parse - list all users",
    'es': "🕵🏽 <b>Haga clic</b> en ✅/☑️ para <b>habilitar/deshabilitar</b> la prohibición de <u>usuarios</u> de bots: <i>con nueva identificación recién registrada/cuentas sin</i> <i>@username</i> <i>/cuentas del</i> <i>sistema antispam</i> <i>/cuentas con 文-glyph, ب-arab/</i> <i>zalgo-characters</i>\n\ n👩🏽‍💻 <b>Comandos</b> :\n/cmd - todos los comandos\n/ban - bloquear/desbloquear usuario\n/parse - enumerar todos los usuarios",
    'fr': "🕵🏽 <b>Cliquez</b> sur ✅/☑️ pour <b>activer/désactiver</b> l&#x27;interdiction des <u>utilisateurs</u> de bot : <i>avec un nouvel identifiant nouvellement enregistré/des comptes sans</i> <i>@username</i> <i>/des comptes du</i> <i>système anti-spam</i> <i>/des comptes avec</i> <i>les caractères 文-glyph, ب-arab/ zalgo-characters</i>\n\ n👩🏽‍💻 <b>Commandes</b> :\n/cmd - toutes les commandes\n/ban - bloquer/débloquer l'utilisateur\n/parse - lister tous les utilisateurs",
    'zh': "🕵🏽<b>点击</b>✅/☑️ 以<b>启用/禁用</b>机器人<u>用户</u>的禁令：<i>新注册的新 ID/帐户没有@username</i> <i>/来自反垃圾邮件系统的</i>帐户<i>/带有文字形、Ø-arab/</i> <i>zalgo-characters 的</i>帐户\n\ n👩🏽‍💻<b>命令</b>：\n/cmd - 所有命令\n/ban - 阻止/取消阻止用户\n/parse - 列出所有用户",
    'ar': "🕵🏽 <b>انقر</b> فوق ✅ / ☑️ <b>لتمكين / تعطيل</b> حظر <u>مستخدمي</u> الروبوت: <i>مع معرف / حسابات جديدة مسجلة حديثًا بدون</i> <i>@username</i> <i>/ حسابات من</i> <i>نظام مكافحة البريد العشوائي</i> <i>/ الحسابات ذات الأحرف 文 -glyph و b- arab /</i> <i>zalgo-character</i>\n\n👩🏽‍💻 <b>الأوامر</b> :\n/ cmd - كافة الأوامر\n/ حظر - حظر / إلغاء حظر المستخدم\n/ تحليل - سرد كافة المستخدمين",
}
l_cban_done = {
    'ru': "🕵🏽 <b>Готово!</b> /ban-список нежелательных пользователей @{0}-бота\n\n👩🏽‍💻 <b>Команды</b>:\n/cmd - все команды\n/ban - блок/разблок пользователя\n/parse - вывести всех пользователей\n\n👩🏽‍💻 <b>Текущее</b> число пользователей /ban-списка: <u>{1}</u>",
    'en': "🕵🏽 <b>Done!</b> /ban-list of unwanted users of @{0}-bot\n\n👩🏽‍💻 <b>Commands</b> :\n/cmd - all commands\n/ban - block/unblock user\n/parse - list all users\n\n👩🏽‍💻 <b>Current</b> number of users/ban-list: <u>{1}</u>",
    'es': "🕵🏽 <b>Listo!</b> /lista de prohibición de usuarios no deseados de @{0}-bot\n\n👩🏽‍💻 <b>Comandos</b> :\n/cmd - todos los comandos\n/prohibición - bloquear/desbloquear usuario\n/parse - enumerar todos los usuarios\n\n👩🏽‍💻 Número <b>actual</b> de usuarios/lista de prohibición: <u>{1}</u>",
    'fr': "🕵🏽 <b>C&#x27;est fait !</b> /ban-list des utilisateurs indésirables de @{0}-bot\n\n👩🏽‍💻 <b>Commandes</b> :\n/cmd - toutes les commandes\n/ban - bloquer/débloquer l&#x27;utilisateur\n/parse - lister tous les utilisateurs\n\n👩🏽‍💻 Nombre <b>actuel</b> d&#x27;utilisateurs/ban-list : <u>{1}</u>",
    'zh': "🕵🏽<b>完成！</b> /ban-list of unblock users of @{0}-bot\n\n👩🏽‍💻<b>命令</b>：\n/cmd - 所有命令\n/ban - 阻止/取消阻止用户\n/parse - 列出所有用户\n\n👩🏽‍💻<b>当前</b>用户数/黑名单： <u>{1}</u>",
    'ar': "🕵🏽 <b>انتهى!</b> / ban-list of غير المرغوب فيهم لـ @ {0} -bot\n\n👩🏽‍💻 <b>الأوامر</b> :\n/ cmd - جميع الأوامر\n/ الحظر - حظر / إلغاء حظر المستخدم\n/ parse - سرد كافة المستخدمين\n\n👩🏽‍💻 العدد <b>الحالي</b> للمستخدمين / قائمة الحظر: <u>{1}</u>",
}
l_cban_correct = {
    'ru': "🕵🏽 <b>Введи</b> корректный id или @username пользователя или выведи всех пользователей в бана: /ban",
    'en': "🕵🏽 <b>Enter</b> a valid user id or @username or ban all users: /ban",
    'es': "🕵🏽 <b>Ingrese</b> una identificación de usuario válida o @username o prohíba a todos los usuarios: /ban",
    'fr': "🕵🏽 <b>Entrez</b> un identifiant ou @username d'utilisateur valide ou bannissez tous les utilisateurs : /ban",
    'zh': "🕵🏽<b>输入</b>有效的用户 ID 或@username或禁止所有用户：/ban",
    'ar': "🕵🏽 <b>أدخل</b> معرف مستخدم صالحًا أو @username أو احظر جميع المستخدمين: / ban",
}

l_cban_handler = {
    'ru': "🕵🏽 <b>Жми</b> на ✅/☑️, чтобы <b>Вкл/Выкл</b> <u>авто</u>-бан <i>аккаунтов с недавно зарегистрированными new-id/без @username/аккаунтов из <a href='https://cas.chat'>Anti-Spam Системы</a>/аккаунтов с 文-глиф, ب-араб/ <a href='https://www.zalgo.org'>zalgo-символами</a></i>\n\n👉🏼 Например, опция <b>new-id</b> блокирует аккаунты со <i>свежим</i> <u>id</u>",
    'en': "🕵🏽 <b>Click</b> on ✅/☑️ to <b>enable/disable</b> <u>auto</u> -ban <i>of accounts with newly registered new-id/without</i> <i>@username</i> <i>/accounts from</i> <i>the Anti-Spam System</i> <i>/accounts with 文-glyph, ب-arab/</i> <i>zalgo-characters</i>\n\ n👉🏼 For example, the <b>new-id</b> option blocks accounts with <i>a fresh</i> <u>id</u>",
    'es': "🕵🏽 <b>Haga clic</b> en ✅/☑️ para <b>habilitar/deshabilitar</b> la prohibición <u>automática</u> <i>de cuentas con nueva identificación recién registrada/sin</i> <i>@username</i> <i>/cuentas del</i> <i>sistema antispam</i> <i>/cuentas con 文-glyph, ب-arab/</i> <i>zalgo-characters</i>\n\ n👉🏼 Por ejemplo, la opción <b>new-id</b> bloquea cuentas con <i>una nueva</i> <u>identificación</u>",
    'fr': "🕵🏽 <b>Cliquez</b> sur ✅/☑️ pour <b>activer/désactiver</b> l&#x27;interdiction <u>automatique</u> <i>des comptes avec un nouvel identifiant nouvellement enregistré/sans</i> <i>@username</i> <i>/comptes du</i> <i>système anti-spam</i> <i>/comptes avec 文-glyphe, ب-arabe/</i> <i>zalgo-caractères</i>\n\ n👉🏼 Par exemple, l&#x27;option <b>new-id</b> bloque les comptes avec <i>un nouvel</i> <u>identifiant</u>",
    'zh': "🕵🏽<b>单击</b>✅/☑️<b>启用/禁用</b><u>自动</u>禁止<i>具有新注册的 new-id/不带@username</i>的帐户<i>/来自反垃圾邮件系统的帐户/具有 text-glyph、ب-arab/</i> <i>zalgo-characters</i>\n的帐户\n👉🏼 例如<b>new-id</b>选项屏蔽<i>新</i><u>id</u>的账号",
    'ar': "🕵🏽 <b>انقر</b> فوق ✅ / ☑️ <b>لتمكين / تعطيل</b> الحظر <u>التلقائي</u> <i>للحسابات ذات المعرف الجديد المسجل حديثًا / بدون</i> <i>@username</i> <i>/ الحسابات من</i> <i>نظام مكافحة البريد العشوائي</i> <i>/ الحسابات ذات</i> <i>الأحرف 文 -glyph و b- arab / zalgo-character</i>\n\n👉🏼 على سبيل المثال ، يقوم خيار <b>المعرف الجديد</b> بحظر الحسابات ذات <u>المعرف</u> <i>الجديد</i>",
}
l_cban_new_on = {
    'ru': "✅☑Вкл new-id-бан",
    'en': "✅☑Includes new-id-ban",
    'es': "✅☑Incluye nuevo-id-ban",
    'fr': "✅☑Comprend une nouvelle interdiction d'identité",
    'zh': "✅☑包括新身份禁令",
    'ar': "✅☑ يشمل حظر معرف جديد",
}
l_cban_new_off = {
    'ru': "☑️☐Выкл new-id-бан",
    'en': "☑️☐Vykl new-id-ban",
    'es': "☑️☐Vykl nuevo-id-prohibición",
    'fr': "☑️☐Vykl new-id-ban",
    'zh': "☑️☐Vykl 新身份禁令",
    'ar': "☑️☐Vykl new-id-ban",
}
l_cban_nousername_on = {
    'ru': "✅☑Вкл без @username-бан",
    'en': "✅☑Vkl without @username -ban",
    'es': "✅☑Vkl sin @username -ban",
    'fr': "✅☑Vkl sans @username -ban",
    'zh': "✅☑Vkl 没有@username -ban",
    'ar': "✅☑Vkl بدون @username -ban",
}
l_cban_nousername_off = {
    'ru': "☑️☐Выкл без @username-бан",
    'en': "☑️☐Vykl without @username -ban",
    'es': "☑️☐Vykl sin @username -ban",
    'fr': "☑️☐Vykl sans @username -ban",
    'zh': "☑️☐没有@username -ban 的Vykl",
    'ar': "☑️☐Vykl بدون @username -ban",
}
l_cban_cas_on = {
    'ru': "✅☑Вкл CAS-бан",
    'en': "✅☑Includes CAS-ban",
    'es': "✅☑Incluye CAS-ban",
    'fr': "✅☑Inclut CAS-interdiction",
    'zh': "✅☑包括 CAS 禁令",
    'ar': "✅☑ يتضمن حظر CAS",
}
l_cban_cas_off = {
    'ru': "☑️☐Выкл CAS-бан",
    'en': "☑️☐Disable CAS ban",
    'es': "☑️☐Deshabilitar la prohibición de CAS",
    'fr': "☑️☐Désactiver l'interdiction CAS",
    'zh': "☑️☐禁用CAS禁令",
    'ar': "☑️☐ تعطيل حظر CAS",
}
l_cban_symbols_on = {
    'ru': "✅☑Вкл 文ب-бан",
    'en': "✅☑Incl. 文ب-ban",
    'es': "✅☑Incl. 文ب-prohibición",
    'fr': "✅☑Y compris 文ب-interdiction",
    'zh': "✅☑包括文Ho禁令",
    'ar': "✅☑Incl. 文 ب- الحظر",
}
l_cban_symbols_off = {
    'ru': "☑️☐Выкл 文ب-бан",
    'en': "☑️☐Выкл 文ب-бан",
    'es': "☑️☐Выкл 文ب-бан",
    'fr': "☑️☐Выкл 文ب-бан",
    'zh': "☑️☐Выкл 文ب-бан",
    'ar': "☑️☐Выкл 文 ب- бан",
}
l_cban_zalgo_on = {
    'ru': "✅☑Вкл zalgo-бан",
    'en': "✅☑Incl. pledge-ban",
    'es': "✅☑Incl. prohibición de compromiso",
    'fr': "✅☑Incl.",
    'zh': "✅☑包括质押禁令",
    'ar': "✅☑Incl. تعهد الحظر",
}
l_cban_zalgo_off = {
    'ru': "☑️☐Выкл zalgo-бан",
    'en': "☑️☐Vykl pledge-ban",
    'es': "☑️☐ Prohibición de compromiso de Vykl",
    'fr': "☑️☐Vykl pledge-ban",
    'zh': "☑️☐Vykl 质押禁令",
    'ar': "Vykl تعهد الحظر",
}
# endregion


# region cpost_
l_cpost_call = {
    'ru': "🔔 Нужно ⚙️Настроить хотя бы один пост",
    'en': "🔔 You need to ⚙️Customize at least one post",
    'es': "🔔 Necesitas ⚙️Personalizar al menos una publicación",
    'fr': "🔔 Vous devez ⚙️Personnaliser au moins une publication",
    'zh': "🔔 你需要⚙️自定义至少一个帖子",
    'ar': "🔔 أنت بحاجة إلى تخصيص منشور واحد على الأقل",
}
l_cpost_text = {
    'ru': "🔔 <b>Жми</b> на ✅/☑️, чтобы <b>Вкл/Выкл</b> <b>авто</b>-постинг по дате\n\n👉🏼 <b>Текущее</b> количество постов <u>{0}</u>",
    'en': "🔔 <b>Click</b> on ✅/☑️ to <b>turn on/off</b> <b>auto</b> -posting by date\n\n👉🏼 <b>Current</b> number of posts <u>{0}</u>",
    'es': "🔔 <b>Haz clic</b> en ✅/☑️ para <b>activar/desactivar</b> la publicación <b>automática</b> por fecha\n\n👉🏼 Número <b>actual</b> de publicaciones <u>{0}</u>",
    'fr': "🔔 <b>Cliquez</b> sur ✅/☑️ pour <b>activer/désactiver</b> la publication <b>automatique</b> par date\n\n👉🏼 Nombre <b>actuel</b> de publications <u>{0}</u>",
    'zh': "🔔<b>单击</b>✅/☑️ 以<b>打开/关闭</b>按日期<b>自动</b>发布\n\n👉🏼<b>当前</b>的帖子数<u>{0}</u>",
    'ar': "🔔 <b>انقر</b> على ✅ / ☑️ <b>لتشغيل / إيقاف</b> النشر <b>التلقائي</b> حسب التاريخ\n\n👉🏼 العدد <b>الحالي</b> من المشاركات <u>{0}</u>",
}
l_fsm_post_call = {
    'ru': "🔔 В настройках [Администраторы] вкл опцию для @{0}-бота:\n[✅ Отправка сообщений]\n[✅ Редактирование постов]\n\n🕚Подожди 1min",
    'en': "🔔 In the [Administrators] settings, enable the option for @{0}-bot:\n[✅ Send messages]\n[✅ Edit posts]\n\n🕚Wait 1min",
    'es': "🔔 En la configuración de [Administradores], habilita la opción para @{0}-bot:\n[✅ Enviar mensajes]\n[✅ Editar publicaciones]\n\n🕚Espera 1 minuto",
    'fr': "🔔 Dans les paramètres [Administrateurs], activez l'option pour @{0}-bot :\n[✅ Envoyer des messages]\n[✅ Modifier les messages]\n\n🕚Attendez 1 min",
    'zh': "🔔 在 [Administrators] 设置中，启用 @{0}-bot 的选项：\n[✅ 发送消息]\n[✅ 编辑帖子]\n\n🕚等待 1 分钟",
    'ar': "🔔 في إعدادات [Administrators] ، قم بتمكين خيار @ {0} -bot:\n[✅ إرسال رسائل]\n[✅ تحرير المشاركات]\n\n🕚 انتظر دقيقة واحدة",
}
l_fsm_post_pin_call = {
    'ru': "🔔 В настройках [Администраторы] вкл опцию для @{0}-бота:\n[✅ Закрепление сообщений]\n\n🕚Подожди 1min",
    'en': "🔔 In the [Administrators] settings, enable the option for @{0}-bot:\n[✅ Pin messages]\n\n🕚Wait 1min",
    'es': "🔔 En la configuración de [Administradores], habilita la opción para @{0}-bot:\n[✅ Anclar mensajes]\n\n🕚Espera 1 minuto",
    'fr': "🔔 Dans les paramètres [Administrateurs], activez l'option pour @{0}-bot :\n[✅ Épingler les messages]\n\n🕚Attendez 1 min",
    'zh': "🔔 在 [Administrators] 设置中，启用 @{0}-bot 选项：\n[✅ Pin messages]\n\n🕚Wait 1min",
    'ar': "🔔 في إعدادات [Administrators] ، قم بتمكين خيار @ {0} -bot:\n[✅ تثبيت الرسائل]\n\n🕚 انتظر دقيقة واحدة",
}
# endregion


# region creact_
l_creact_text = {
    'ru': "👍🏽 <b>Жми</b> на ✅/☑️, чтобы <b>Вкл/Выкл</b> креативные авто-реакции на последний пост канала\n\n👩🏽‍💻 Используй команду <code>/react {0}</code>, чтобы задать количество авто-реакций на пост (без подписки: <u>{1}</u>)\n\n👍🏽 <b>Tекущее</b> количество: <u>{0}</u>",
    'en': "👍🏽 <b>Click</b> on ✅/☑️ to <b>turn on/off</b> creative auto-reactions on the last post of the channel\n\n👩🏽‍💻 Use the command /react {0} to set the number of auto-reactions per post ( <b>current</b> number: <u>{0 }</u> )",
    'es': "👍🏽 <b>Haz clic</b> en ✅/☑️ para <b>activar/desactivar</b> las reacciones automáticas creativas en la última publicación del canal\n\n👩🏽‍💻 Usa el comando /react {0} para configurar el número de reacciones automáticas por publicación ( número <b>actual</b> : <u>{0 }</u> )",
    'fr': "👍🏽 <b>Cliquez</b> sur ✅/☑️ pour <b>activer/désactiver</b> les auto-réactions créatives sur la dernière publication de la chaîne\n\n👩🏽‍💻 Utilisez la commande /réagir {0} pour définir le nombre d&#x27;auto-réactions par publication ( numéro <b>actuel</b> : <u>{0 }</u> )",
    'zh': "👍🏽<b>点击</b>✅/☑️<b>打开/关闭</b>频道最后一个帖子的创意自动反应\n\n👩🏽‍💻 使用命令 /react {0} 设置每个帖子的自动反应数量 (<b>当前</b>号码： <u>{0 }</u> )",
    'ar': "👍🏽 <b>انقر</b> على ✅ / ☑️ <b>لتشغيل / إيقاف</b> ردود الفعل التلقائية الإبداعية في آخر مشاركة للقناة\n\n👩🏽‍💻 استخدم الأمر / رد الفعل {0} لتعيين عدد التفاعلات التلقائية لكل مشاركة ( الرقم <b>الحالي</b> : <u>{0}</u> )",
}
l_creact_call = {
    'ru': "👍🏽 В настройках [Администраторы] для @{0} вкл:\n[✅ Добавление участ]\n\n🕚Подожди 1min",
    'en': "👍🏽 In the [Administrators] settings for @{0} on:\n[✅ Add member]\n\n🕚Wait 1min",
    'es': "👍🏽 En la configuración de [Administradores] para @{0} en:\n[✅ Agregar miembro]\n\n🕚Espera 1 minuto",
    'fr': "👍🏽 Dans les paramètres [Administrateurs] pour @{0} sur :\n[✅ Ajouter un membre]\n\n🕚Attendez 1min",
    'zh': "👍🏽在@{0}的[管理员]设置中：\n[✅添加成员]\n\n🕚等待1分钟",
    'ar': "👍🏽 في إعدادات [Administrators] لـ @ {0} على:\n[✅ إضافة عضو]\n\n🕚 انتظر دقيقة واحدة",
}
l_creact_correct = {
    'ru': "👍🏽 <b>Введи</b> корректное <b>число</b> креативных авто-реакций на последний пост канала\n\n👩🏽‍💻 Используй команду <code>/react {0}</code>, чтобы задать количество авто-реакций (без подписки: <u>{1}</u>)",
    'en': "👍🏽 <b>Enter</b> the correct <b>number</b> of creative auto-reactions to the last post of the channel\n\n👩🏽‍💻 Use the /react {0} command to set the number of auto-reactions ( <b>current</b> number: <u>{0}</u> )",
    'es': "👍🏽 <b>Ingresa</b> el <b>número</b> correcto de reacciones automáticas creativas a la última publicación del canal\n\n👩🏽‍💻 Usa el comando /react {0} para establecer el número de reacciones automáticas (número <b>actual</b> : <u>{0}</u> )",
    'fr': "👍🏽 <b>Saisissez</b> le <b>nombre</b> correct de réactions automatiques créatives au dernier message de la chaîne\n\n👩🏽‍💻 Utilisez la commande /react {0} pour définir le nombre de réactions automatiques (nombre <b>actuel</b> : <u>{0}</u> )",
    'zh': "👍🏽<b>输入</b>频道最后一个帖子的正确创意自动反应<b>数量</b>\n\n👩🏽‍💻 使用/react {0}命令设置自动反应数量（<b>当前</b>数量： <u>{0}</u> ）",
    'ar': "👍🏽 <b>أدخل</b> <b>العدد</b> الصحيح من ردود الفعل التلقائية الإبداعية على آخر مشاركة للقناة\n\n👩🏽‍💻 استخدم الأمر /react {0} لتعيين عدد التفاعلات التلقائية (الرقم <b>الحالي</b> : <u>{0}</u> )",
}
l_creact_on = {
    'ru': "👍🏽 <b>Готово!</b> Текущее количество <b>авто-реакций</b> на пост канала установлено в значение <u>{0}</u> (без подписки: <u>{1}</u>)",
    'en': "👍🏽 <b>Done!</b> The current number of <b>auto-reactions</b> per channel post is set to <u>{0}</u>",
    'es': "👍🏽 <b>Listo!</b> El número actual de <b>reacciones automáticas</b> por publicación de canal está establecido en <u>{0}</u>",
    'fr': "👍🏽 <b>C&#x27;est fait !</b> Le nombre actuel de <b>réactions automatiques</b> par publication de chaîne est défini sur <u>{0}</u>",
    'zh': "👍🏽<b>完成！</b>每个频道帖子的当前<b>自动反应</b>数设置为<u>{0}</u>",
    'ar': "👍🏽 <b>انتهى!</b> تم تعيين العدد الحالي <b>للردود التلقائية</b> لكل مشاركة على القناة على <u>{0}</u>",
}
l_creact_off = {
    'ru': "👍🏽 <b>Режим</b> /react-авто-реакций отключен",
    'en': "👍🏽 /react mode is disabled",
    'es': "👍🏽 El modo /reaccionar está deshabilitado",
    'fr': "👍🏽 Le mode /react est désactivé",
    'zh': "👍🏽/反应模式被禁用",
    'ar': "👍🏽 / وضع رد الفعل معطل",
}
# endregion


# region cview_
l_cview_text = {
    'ru': "👁️‍🗨️ <b>Жми</b> на ✅/☑️, чтобы <b>Вкл/Выкл</b> авто-просмотры поста канала\n\n👩🏽‍💻 Используй команду <code>/view {0}</code>, чтобы задать количество авто-просмотров (без подписки: <u>{1}</u>)\n\n👁️‍🗨️ <b>Tекущее</b> количество: <u>{0}</u>",
    'en': "👁️‍🗨️ <b>Press</b> ✅/☑️ to <b>turn on/off</b> channel post auto views\n\n👩🏽‍💻 Use command /view {0} to set number of auto views ( <b>current</b> number: <u>{0}</u> )",
    'es': "👁️‍🗨️ <b>Presiona</b> ✅/☑️ para <b>activar/desactivar</b> las vistas automáticas de las publicaciones del canal\n\n👩🏽‍💻 Usa el comando /view {0} para establecer el número de vistas automáticas (número <b>actual</b> : <u>{0}</u> )",
    'fr': "👁️‍🗨️ <b>Appuyez sur</b> ✅/☑️ pour <b>activer/désactiver</b> les vues automatiques des publications de la chaîne\n\n👩🏽‍💻 Utilisez la commande /view {0} pour définir le nombre de vues automatiques (nombre <b>actuel</b> : <u>{0}</u> )",
    'zh': "👁️‍🗨️<b>按</b>✅/☑️<b>打开/关闭</b>频道帖子自动观看\n\n👩🏽‍💻 使用命令 /view {0} 设置自动观看次数（<b>当前</b>次数： <u>{0}</u> ）",
    'ar': "👁️‍🗨️ <b>اضغط على</b> ✅ / ☑️ <b>لتشغيل / إيقاف</b> العرض التلقائي لنشر القناة\n\n👩🏽‍💻 استخدم الأمر / العرض {0} لتعيين عدد المشاهدات التلقائية (الرقم <b>الحالي</b> : <u>{0}</u> )",
}
l_cview_call = {
    'ru': "👁️‍🗨️ В настройках [Администраторы] для @{0} вкл:\n[✅ Добавление участ]\n\n🕚Подожди 1min",
    'en': "👁️‍🗨️ In the [Administrators] settings for @{0} on:\n[✅ Add member]\n\n🕚Please wait 1min",
    'es': "👁️‍🗨️ En la configuración de [Administradores] para @{0} en:\n[✅ Agregar miembro]\n\n🕚Espere 1 minuto",
    'fr': "👁️‍🗨️ Dans les paramètres [Administrateurs] pour @{0} sur :\n[✅ Ajouter un membre]\n\n🕚Veuillez patienter 1 min",
    'zh': "👁️‍🗨️ 在@{0}的[管理员]设置中：\n[✅添加成员]\n\n🕚请稍候1分钟",
    'ar': "👁️‍🗨️ في إعدادات [Administrators] لـ @ {0} على:\n[✅ إضافة عضو]\n\n🕚 يرجى الانتظار لمدة دقيقة",
}
l_cview_correct = {
    'ru': "👁️‍🗨️ <b>Введи</b> корректное <b>число</b> авто-просмотров последнего поста канала\n\n👩🏽‍💻 Используй команду <code>/view {0}</code>, чтобы задать количество авто-просмотров (без подписки: <u>{1}</u>)",
    'en': "👁️‍🗨️ <b>Enter</b> the correct <b>number of</b> auto-views for the last post of the channel\n\n👩🏽‍💻 Use /view {0} to set the number of auto-views ( <b>current</b> number: <u>{0}</u> )",
    'es': "👁️‍🗨️ <b>Ingresa</b> la <b>cantidad correcta de</b> vistas automáticas para la última publicación del canal\n\n👩🏽‍💻 Usa /view {0} para establecer la cantidad de vistas automáticas (número <b>actual</b> : <u>{0}</u> )",
    'fr': "👁️‍🗨️ <b>Entrez</b> le <b>nombre correct de</b> vues automatiques pour le dernier message de la chaîne\n\n👩🏽‍💻 Utilisez /view {0} pour définir le nombre de vues automatiques (nombre <b>actuel</b> : <u>{0}</u> )",
    'zh': "👁️‍🗨️ 为频道的最后一个帖子<b>输入</b>正确<b>的自动观看次数</b>\n\n👩🏽‍💻 使用/view {0}设置自动观看次数（<b>当前</b>次数： <u>{0}</u> ）",
    'ar': "👁️‍🗨️ <b>أدخل</b> <b>العدد</b> الصحيح للمشاهدات التلقائية لآخر مشاركة للقناة\n\n👩🏽‍💻 استخدم /view {0} لتعيين عدد المشاهدات التلقائية (الرقم <b>الحالي</b> : <u>{0}</u> )",
}
l_cview_on = {
    'ru': "👁️‍🗨️ <b>Готово!</b> Текущее количество <b>авто-просмотров</b> на последний пост канала установлено в значение <u>{0}</u> (без подписки: <u>{1}</u>)",
    'en': "👁️‍🗨️ <b>Done!</b> The current number of <b>auto-views</b> for the channel&#x27;s last post is set to <u>{0}</u>",
    'es': "👁️‍🗨️ <b>Listo!</b> El número actual de <b>visualizaciones automáticas</b> de la última publicación del canal está establecido en <u>{0}.</u>",
    'fr': "👁️‍🗨️ <b>C&#x27;est fait !</b> Le nombre actuel de <b>vues automatiques</b> pour le dernier message de la chaîne est défini sur <u>{0}</u>",
    'zh': "👁️‍🗨️<b>完成！</b>频道上一篇帖子的当前<b>自动观看</b>次数设置为<u>{0}</u>",
    'ar': "👁️‍🗨️ <b>انتهى!</b> تم تعيين العدد الحالي <b>للمشاهدات التلقائية</b> لآخر مشاركة على القناة على <u>{0}</u>",
}
l_cview_off = {
    'ru': "👁️‍🗨️ <b>Режим</b> /view-авто-просмотров отключен",
    'en': "👁️‍🗨️ /view-auto-views disabled",
    'es': "👁️‍🗨️ /view-auto-views deshabilitado",
    'fr': "👁️‍🗨️ /view-auto-views désactivé",
    'zh': "👁️‍🗨️ /view-auto-views 已禁用",
    'ar': "👁️‍🗨️ / عرض-طرق العرض التلقائي معطلة",
}
# endregion


# region cdecor_
l_cdecor_text = {
    'ru': "🪄 <b>Жми</b> на ✅/☑️, чтобы <b>Вкл/Выкл</b> авто-декор публикуемого поста: <i><b>пагинация</b> (порядковый номер поста)/креативный <b>формат текста</b> (<b>жирный</b>/<i>курсив</i>/<u>подчеркнутый</u>/моно/<tg-spoiler>спойлер</tg-spoiler>/#хэштег/<a href='{0}'>ссылка</a>)/<b>футер</b> (текстовое окончание поста)</i>\n\n👉🏼 Например, опция <b>[✅☑Вкл формат текста]</b> означает креативное изменение поста с использованием 7 стилей",
    'en': "🪄 <b>Click</b> on ✅/☑️ to <b>turn on/off</b> the auto-decor of the published post: <i><b>pagination</b> (post serial number)/creative <b>text format</b> ( <b>bold</b> /italic/ <u>underlined</u> /</i> моно <i>/spoiler/</i> <i>#хэштег</i> <i>/link)/ <b>footer</b> (post text ending)</i>\n\n👉🏼 For example, the option <b>[✅☑Enable Text Format]</b> means creative post editing using 7 styles",
    'es': "🪄 <b>Haga clic</b> en ✅/☑️ para <b>activar/desactivar</b> la decoración automática de la publicación: <i><b>paginación</b> (número de serie de la publicación)/ <b>formato de texto</b> creativo ( <b>negrita</b> /cursiva/ <u>subrayado</u> /</i> моно <i>/spoiler/</i> <i>#хэштег</i> <i>/enlace)/ <b>pie de página</b> (publicación final del texto)</i>\n\n👉🏼 Por ejemplo, la opción <b>[✅☑Habilitar formato de texto]</b> significa edición creativa de publicaciones usando 7 estilos",
    'fr': "🪄 <b>Cliquez</b> sur ✅/☑️ pour <b>activer/désactiver</b> le décor automatique de l&#x27;article publié : <i><b>pagination</b> (numéro de série de l&#x27;article)/ <b>format du texte</b> créatif ( <b>gras</b> /italique/ <u>souligné</u> /</i> моно <i>/spoiler/</i> <i>#хэштег</i> <i>/lien)/ <b>pied de page</b> (article fin du texte)</i>\n\n👉🏼 Par exemple, l&#x27;option <b>[✅☑Activer le format de texte]</b> signifie une post-édition créative utilisant 7 styles",
    'zh': "🪄<b>点击</b>✅/☑️<b>开启/关闭</b>已发布帖子的自动装饰：<i><b>分页</b>（帖子序列号）/创意<b>文本格式</b>（<b>粗体</b>/斜体/<u>下划线</u>/</i> моно <i>/剧透/</i> <i>#хэштег</i> <i>/link）/<b>页脚</b>（帖子text ending)</i>\n\n👉🏼 例如选项<b>[✅☑Enable Text Format]</b>表示使用 7 种样式进行创意后期编辑",
    'ar': "🪄 <b>انقر</b> فوق ✅ / ☑️ <b>لتشغيل / إيقاف</b> الديكور التلقائي للمنشور المنشور: <i><b>ترقيم الصفحات</b> (الرقم التسلسلي للرسالة) / <b>تنسيق النص</b> الإبداعي ( <b>غامق</b> / مائل / <u>تحته خط</u> /</i> моно <i>/ سبويلر /</i> <i>#хэштег</i> <i>/ رابط) / تذييل ( <b>منشور</b> ) نهاية النص)</i>\n\n👉🏼 على سبيل المثال ، الخيار <b>[✅☑ تمكين تنسيق النص]</b> يعني تحرير المنشور الإبداعي باستخدام 7 أنماط",
}
l_cdecor_footer_call = {
    'ru': "🪄 Футер пустой, необходимо его ⚙️Настроить",
    'en': "🪄 The footer is empty, you need to set it up ⚙️",
    'es': "🪄 El pie de página está vacío, debes configurarlo ⚙️",
    'fr': "🪄 Le pied de page est vide, vous devez le paramétrer ⚙️",
    'zh': "🪄 footer 是空的，需要设置一下⚙️",
    'ar': "🪄 التذييل فارغ ، تحتاج إلى إعداده ⚙️",
}
l_cdecor_footer_call2 = {
    'ru': "🪄 В настройках [Администраторы] вкл опцию для @{0}-бота:\n[✅ Редактирование постов]\n\n🕚Подожди 1min",
    'en': "🪄 In the [Administrators] settings, enable the option for @{0}-bot:\n[✅ Post editing]\n\n🕚Wait 1min",
    'es': "🪄 En la configuración de [Administradores], habilita la opción para @{0}-bot:\n[✅ Edición posterior]\n\n🕚Espera 1 minuto",
    'fr': "🪄 Dans les paramètres [Administrateurs], activez l'option pour @{0}-bot :\n[✅ Post-édition]\n\n🕚Attendez 1 min",
    'zh': "🪄 在 [Administrators] 设置中，启用 @{0}-bot 的选项：\n[✅ Post editing]\n\n🕚Wait 1min",
    'ar': "🪄 في إعدادات [Administrators] ، قم بتمكين خيار @ {0} -bot:\n[✅ نشر التحرير]\n\n🕚 انتظر دقيقة واحدة",
}
l_cdecor_footer_config = {
    'ru': "🪄 <b>Введи</b> краткий <b>текст</b>, который будет добавляться в окончание к постам канала (например, часто используемые #хэштеги)",
    'en': "🪄 <b>Enter</b> a short <b>text</b> that will be added to the end of the channel posts (for example, frequently used #хэштеги )",
    'es': "🪄 <b>Ingrese</b> un <b>texto</b> breve que se agregará al final de las publicaciones del canal (por ejemplo, #хэштеги de uso frecuente)",
    'fr': "🪄 <b>Entrez</b> un court <b>texte</b> qui sera ajouté à la fin des publications de la chaîne (par exemple, #хэштеги fréquemment utilisés)",
    'zh': "🪄<b>输入</b>将添加到频道帖子末尾的短<b>文本</b>（例如，经常使用的#хэштеги ）",
    'ar': "🪄 <b>أدخل</b> <b>نصًا</b> قصيرًا سيتم إضافته إلى نهاية منشورات القناة (على سبيل المثال ، #хэштеги المستخدمة بشكل متكرر)",
}
l_cdecor_footer_done = {
    'ru': "🪄 <b>Готово!</b> <b>Футер</b> из <u>{0}</u>-символов будет использоваться как окончание поста в канале\n\n👩🏽‍💻 Опцию можно включить, нажав <b>[✅☑Вкл футер]</b>",
    'en': "🪄 <b>Done!</b> <b>The footer</b> of <u>{0}</u> characters will be used as the end of the post in the channel\n\nThis option can be enabled by pressing <b>[✅☑Enable footer]</b>",
    'es': "🪄 <b>Listo!</b> <b>El pie de página</b> de <u>{0}</u> caracteres se utilizará como final de la publicación en el canal\n\nEsta opción se puede habilitar presionando <b>[✅☑Habilitar pie de página]</b>",
    'fr': "🪄 <b>C&#x27;est fait !</b> <b>Le pied de page</b> de <u>{0}</u> caractères sera utilisé comme fin de message dans le canal\n\nCette option peut être activée en appuyant sur <b>[✅☑Activer le pied de page]</b>",
    'zh': "🪄<b>完成！</b> <u>{0}</u>个字符的<b>页脚</b>将用作频道中帖子的结尾\n\n可以通过按<b>[✅☑启用页脚]</b>来启用此选项",
    'ar': "🪄 <b>انتهى!</b> سيتم استخدام <b>تذييل مكون</b> من <u>{0}</u> حرفًا كنهاية للنشر في القناة\n\nيمكن تمكين هذا الخيار بالضغط على <b>[✅☑ تمكين التذييل]</b>",
}
l_cdecor_page_on = {
    'ru': "✅☑Вкл пагинация",
    'en': "✅☑Including pagination",
    'es': "✅☑Incluye paginación",
    'fr': "✅☑Incluant la pagination",
    'zh': "✅☑包括分页",
    'ar': "✅☑ بما في ذلك ترقيم الصفحات",
}
l_cdecor_page_off = {
    'ru': "☑️☐Выкл пагинация",
    'en': "☑️☐Off pagination",
    'es': "☑️☐ Fuera de paginación",
    'fr': "☑️☐ Hors pagination",
    'zh': "☑️☐关闭分页",
    'ar': "☑️☐ من ترقيم الصفحات",
}
l_cdecor_footer_on = {
    'ru': "✅☑Вкл футер",
    'en': "✅☑On footer",
    'es': "✅☑A pie de página",
    'fr': "✅☑En pied de page",
    'zh': "✅在页脚",
    'ar': "✅☑ في التذييل",
}
l_cdecor_footer_off = {
    'ru': "☑️☐Выкл футер",
    'en': "☑️☐Off footer",
    'es': "☑️☐Fuera del pie de página",
    'fr': "☑️☐Hors pied de page",
    'zh': "☑️☐关闭页脚",
    'ar': "☑️☐ من التذييل",
}
l_cdecor_format_on = {
    'ru': "✅☑Вкл формат текста",
    'en': "✅☑Includes text format",
    'es': "✅☑Incluye formato de texto",
    'fr': "✅☑Inclut le format texte",
    'zh': "✅☑包括文本格式",
    'ar': "✅☑ يتضمن تنسيق النص",
}
l_cdecor_format_off = {
    'ru': "☑️☐Выкл формат текста",
    'en': "☑️☐Off text format",
    'es': "☑️☐Fuera de formato de texto",
    'fr': "☑️☐ Hors format texte",
    'zh': "☑️☐关闭文本格式",
    'ar': "☑️☐إيقاف تنسيق النص",
}
# endregion


# region cmember_
l_cmember_text = {
    'ru': "👥 <b>Жми</b> на ✅/☑️, чтобы <b>Вкл/Выкл</b> сбор подписчиков канала\n\n👩🏽‍💻 Для выгрузки подписчиков канала выполни команду /parse",
    'en': "👥 <b>Click</b> on ✅/☑️ to <b>turn on/off</b> the collection of channel subscribers (from the moment the bot joins the channel)\n\n👩🏽‍💻 To unload channel subscribers, run the /parse command",
    'es': "👥 <b>Haz clic</b> en ✅/☑️ para <b>activar/desactivar</b> la recopilación de suscriptores del canal (desde el momento en que el bot se une al canal)\n\n👩🏽‍💻 Para descargar suscriptores del canal, ejecuta el comando /parse",
    'fr': "👥 <b>Cliquez</b> sur ✅/☑️ pour <b>activer/désactiver</b> la collecte des abonnés à la chaîne (à partir du moment où le bot rejoint la chaîne)\n\n👩🏽‍💻 Pour décharger les abonnés à la chaîne, exécutez la commande /parse",
    'zh': "👥<b>点击</b>✅/☑️<b>打开/关闭</b>频道订阅者的收集（从机器人加入频道的那一刻起）\n\n👩🏽‍💻 要卸载频道订阅者，运行 /parse 命令",
    'ar': "👥 <b>انقر</b> فوق ✅ / ☑️ <b>لتشغيل / إيقاف</b> مجموعة مشتركي القناة (من لحظة انضمام الروبوت إلى القناة)\n\n👩🏽‍💻 لإلغاء تحميل مشتركي القناة ، قم بتشغيل الأمر / parse",
}
l_cmember_on = {
    'ru': "👁️‍🗨️ <b>Готово!</b> Текущее количество <b>авто-просмотров</b> на последний пост канала установлено в значение <u>{0}</u>",
    'en': "👁️‍🗨️ <b>Done!</b> The current number of <b>auto-views</b> for the channel&#x27;s last post is set to <u>{0}</u>",
    'es': "👁️‍🗨️ <b>Listo!</b> El número actual de <b>visualizaciones automáticas</b> de la última publicación del canal está establecido en <u>{0}.</u>",
    'fr': "👁️‍🗨️ <b>C&#x27;est fait !</b> Le nombre actuel de <b>vues automatiques</b> pour le dernier message de la chaîne est défini sur <u>{0}</u>",
    'zh': "👁️‍🗨️<b>完成！</b>频道上一篇帖子的当前<b>自动观看</b>次数设置为<u>{0}</u>",
    'ar': "👁️‍🗨️ <b>انتهى!</b> تم تعيين العدد الحالي <b>للمشاهدات التلقائية</b> لآخر مشاركة على القناة على <u>{0}</u>",
}
l_cmember_off = {
    'ru': "👁️‍🗨️ <b>Режим</b> /view-авто-просмотров отключен",
    'en': "👁️‍🗨️ /view-auto-views disabled",
    'es': "👁️‍🗨️ /view-auto-views deshabilitado",
    'fr': "👁️‍🗨️ /view-auto-views désactivé",
    'zh': "👁️‍🗨️ /view-auto-views 已禁用",
    'ar': "👁️‍🗨️ / عرض-طرق العرض التلقائي معطلة",
}
l_cmember_parse = {
    'ru': "👥 <b>Собрано</b> реальных участников: <u>{0}</u>\n\n👩🏽‍💻 <b>Старые</b> подписчики будут постепенно пополнять базу, пока у @{1}-бота есть права:\n[✅ <i>Назначение администраторов</i>]\n\n{2}\n👩🏽‍💻 <b>Для получения</b> имен пользователей должна быть <a href='{3}'>оформлена подписка</a>",
    'en': "👥 <b>Done!</b> Collected real participants: <u>{0}</u>\n\n👩🏽‍💻 Old subscribers will gradually replenish the database as long as the @{1}-bot has rights [✅ Appointment of administrators]\n\n{2}",
    'es': "👥 <b>Listo!</b> Participantes reales recopilados: <u>{0}</u>\n\n👩🏽‍💻 Los suscriptores antiguos repondrán gradualmente la base de datos siempre que el @{1}-bot tenga derechos [✅ Nombramiento de administradores]\n\n{2}",
    'fr': "👥 <b>C&#x27;est fait !</b> Participants réels collectés : <u>{0}</u>\n\n👩🏽‍💻 Les anciens abonnés reconstitueront progressivement la base de données tant que le @{1}-bot aura des droits [✅ Nomination d'administrateurs]\n\n{2}",
    'zh': "👥<b>完成！</b>收集到的真实参与者： <u>{0}</u>\n\n👩🏽‍💻 只要@{1}-bot 有权限，老订阅者就会逐渐补充数据库【✅管理员任命】\n\n{2}",
    'ar': "👥 <b>انتهى!</b> المشاركون الحقيقيون الذين تم جمعهم: <u>{0}</u>\n\n👩🏽‍💻 سوف يقوم المشتركون القدامى بتجديد قاعدة البيانات تدريجيًا طالما أن @ {1} الروبوت لديه حقوق [✅ تعيين المسؤولين]\n\n{2}",
}
l_parse_rights = {
    'ru': "👥 В настройках [Администраторы] вкл опцию для @{0}-бота:\n[✅ Назначение администраторов]\n🕚Подожди 1min\n👩🏽‍💻 Выполни команду /parse\n\n⚙️ <b>Команды</b> /cmd",
    'en': "👥 In the [Administrators] settings, enable the option for @{0}-bot:\n[✅ Assign administrators]\n🕚Wait 1min\n👩🏽‍💻 Execute /parse\n\n⚙️ <b>Commands</b> /cmd",
    'es': "👥 En la configuración de [Administradores], habilita la opción para @{0}-bot:\n[✅ Asignar administradores]\n🕚Espera 1 minuto\n👩🏽‍💻 Ejecuta /parse\n\n⚙️ <b>Comandos</b> /cmd",
    'fr': "👥 Dans les paramètres [Administrateurs], activez l'option pour @{0}-bot :\n[✅ Affecter des administrateurs]\n🕚Attendez 1min\n👩🏽‍💻 Exécutez /parse\n\n⚙️ <b>Commandes</b> /cmd",
    'zh': "👥 在【管理员】设置中，启用@{0}-bot的选项：\n[✅分配管理员]\n🕚等待1分钟\n👩🏽‍💻执行/parse\n\n⚙️<b>命令</b>/cmd",
    'ar': "👥 في إعدادات [Administrators] ، قم بتمكين خيار @ {0} -bot:\n[✅ تعيين المسؤولين]\n🕚 انتظر دقيقة واحدة\n👩🏽‍💻 تنفيذ / تحليل\n\n⚙️ <b>أوامر</b> / cmd",
}
# endregion
# endregion


# region FereyGroupBot
l_group_btn1 = {
    'ru': "⛰️ Группы",
    'en': "⛰️ Groups",
    'es': "⛰️ Grupos",
    'fr': "⛰️ Groupes",
    'zh': "⛰️ 团体",
    'ar': "⛰️ المجموعات",
}
l_group_btn2 = {
    'ru': "🌬 Подписка",
    'en': "🌬 Subscription",
    'es': "🌬 Suscripción",
    'fr': "🌬 Abonnement",
    'zh': "🌬订阅",
    'ar': "🌬 الاشتراك",
}
l_group_welcome = {
    'ru': "🌱 {0}, добро пожаловать в <i>лендинг-бот</i> администрирования <b>Telegram</b>-групп:\n\n▪️<b>защита</b> группы от вступления шпионов\n▪️вывод <b>статистики</b> и вовлеченности (%)\n▪️ограничение прав до <b>подписки</b>\n▪️<b>организация</b> бана и антифлуда\n▪️<b>авто-ответы</b> и стоп-слова\n▪️<b>кнопочный</b> счетчик\n\n❗️Регулярно-обновляемый /content",
    'en': "🌱 {0}, welcome to <i>the landing bot</i> администрирования <b>Telegram</b> groups:\n\n▪️ <b>protecting</b> the group from spyware\n▪️displaying <b>statistics</b> and engagement (%)\n▪️restricting rights before <b>subscribing</b> to the channel\n▪️ <b>organizing</b> a ban and anti-flood\n\n❗️you can also order the development of a chat bot in our Ferey studio",
    'es': "🌱 {0}, bienvenido al <i>bot de aterrizaje</i> администрирования grupos <b>de Telegram</b> :\n\ <b>n▪️proteger</b> al grupo de spyware\n▪️mostrar <b>estadísticas</b> e interacción (%)\n▪️restringir los derechos antes de <b>suscribirse</b> al canal\ <b>n▪️organizar</b> un prohibición y anti-inundación\n\n❗️también puede solicitar el desarrollo de un bot de chat en nuestro estudio Ferey",
    'fr': "🌱 {0}, bienvenue dans <i>le landing bot</i> администрирования des groupes <b>Telegram</b> :\n\n▪️ <b>protéger</b> le groupe des spywares\n▪️afficher <b>les statistiques</b> et l&#x27;engagement (%)\n▪️restreindre les droits avant de <b>s&#x27;abonner</b> à la chaîne\n▪️ <b>organiser</b> un interdiction et anti-flood\n\n❗️vous pouvez également commander le développement d'un chat bot dans notre studio de Ferey",
    'zh': "🌱 {0}，欢迎使用администрирования <b>Telegram</b>群组的<i>登陆机器人</i>：\n\n▪️<b>保护</b>群组免受间谍软件的侵害\n▪️ 显示<b>统计数据</b>和参与度 (%)\n▪️ 在<b>订阅</b>频道之前限制权利\n▪️<b>组织</b>一个ban 和 anti-flood\n\n❗️您也可以在我们的Ferey工作室订购聊天机器人的开发",
    'ar': "🌱 {0} ، مرحبًا بك في <i>الروبوت الهبوط</i> администрирования مجموعات <b>Telegram</b> :\n\n▪️ <b>حماية</b> المجموعة من برامج التجسس\n▪️ عرض <b>الإحصائيات</b> والمشاركة (٪)\n▪️ تقييد الحقوق قبل <b>الاشتراك</b> في القناة\n▪️ <b>تنظيم</b> الحظر ومكافحة الفيضانات\n\n❗️ يمكنك أيضًا طلب تطوير روبوت محادثة في استوديو Ferey الخاص بنا",
}
l_subscribe_group = {
    'ru': "👩🏽‍💻 <b>Оформи</b> ежемесячную <i>подписку</i>:\n\n¹ [<b>Все боты</b> и проекты (-<u>5</u>%)]\n² [@{0}-бот]:\n▪️до 50 <b>стоп-слов</b>\n▪️до 10 <b>старт-слова</b>\n▪️до 5 <b>авто-приглашений</b>\n\n👩🏽‍💻 /balance",
    'en': "👩🏽‍💻 <b>Sign up for</b> a monthly\n\n¹ <i>subscription</i> to @{0}-bot [{1} ₽]\n▪️ no ads\n▪️ creative tasks\n² Subscribe to <u>all</u> bots [{2} ₽]",
    'es': "👩🏽‍💻 <b>Regístrese para obtener</b> una\n\n¹ <i>suscripción</i> mensual a @{0}-bot [{1} ₽]\n▪️ sin anuncios\n▪️ tareas creativas\n² Suscríbase a <u>todos</u> los bots [{2} ₽]",
    'fr': "👩🏽‍💻 <b>Inscrivez-vous pour</b> un <i>abonnement</i>\n\n¹ mensuel à @{0}-bot [{1} ₽]\n▪️ pas de publicité\n▪️ tâches créatives\n² Abonnez-vous à <u>tous</u> les bots [{2} ₽]",
    'zh': "👩🏽‍💻<b>注册</b>每月\n\n¹<i>订阅</i>@{0}-bot [{1} ₽]\n▪️ 无广告\n▪️ 创意任务\n² 订阅<u>所有</u>机器人 [{2} ₽]",
    'ar': "👩🏽‍💻 <b>اشترك للحصول على</b> <i>اشتراك</i> شهري\n\n¹ في @ {0} -bot [{1} ₽]\n▪️ بلا إعلانات\n▪️ مهام إبداعية\n² اشترك في <u>جميع</u> برامج التتبُّع [{2} ₽]",
}

l_add_group_text = {
    'ru': "👇🏽 <b>Жми</b> на ‹➕ Добавить группу›, чтобы добавить в свою группу (с настройками по ум) бота: @{0}\n\n👮🏽‍♀️ Или добавь бота как <b>Administrator</b> через настройки своей группы: ‹👤Add Admin›\n\n👮🏽‍♀️ Если не добавляется группа, то измени <b>Должность</b> (см. скрин)",
    'en': "👇🏽 <b>Click</b> on ‹➕ Add group› to add a bot to your group (with custom settings): @{0}\n\n👮🏽‍♀️ Or add a bot as <b>Administrator</b> through your group settings: ‹👤Add Admin›\n\n👮🏽‍♀️ If the group is not added, then change <b>the Position</b> (see screenshot)",
    'es': "👇🏽 <b>Haz clic</b> en ‹➕ Agregar grupo› para agregar un bot a tu grupo (con configuraciones personalizadas): @{0}\n\n👮🏽‍♀️ O agrega un bot como <b>administrador</b> a través de la configuración de tu grupo: ‹👤Agregar administrador›\n\n👮🏽‍♀️ Si el grupo no se agrega, cambie <b>la Posición</b> (ver captura de pantalla)",
    'fr': "👇🏽 <b>Cliquez</b> sur ‹➕ Ajouter un groupe› pour ajouter un bot à votre groupe (avec des paramètres personnalisés) : @{0}\n\n👮🏽‍♀️ Ou ajoutez un bot en tant <b>qu&#x27;administrateur</b> via les paramètres de votre groupe : ‹👤Ajouter un administrateur›\n\n👮🏽‍♀️ Si le groupe n&#x27;est pas ajouté, alors changez <b>la position</b> (voir capture d'écran)",
    'zh': "👇🏽<b>点击</b>‹➕添加组›将机器人添加到您的组（使用自定义设置）：@{0}\n\n👮🏽‍♀️或通过您的组设置将机器人添加为<b>管理员</b>：‹👤添加管理员›\n\n👮🏽‍♀️ 如果没有添加组，则更改<b>位置</b>（见截图）",
    'ar': "👇🏽 <b>انقر</b> فوق ‹➕ إضافة مجموعة› لإضافة روبوت إلى مجموعتك (بإعدادات مخصصة): @ {0}\n\n👮🏽‍♀️ أو أضف روبوتًا <b>كمسؤول</b> من خلال إعدادات مجموعتك: ‹👤 إضافة مسؤول›\n\n👮🏽‍♀️ إذا لم تتم إضافة المجموعة ، فقم بتغيير <b>الموضع</b> (انظر لقطة الشاشة)",
}
l_add_group_button = {
    'ru': "➕ Добавить группу",
    'en': "➕ Add group",
    'es': "➕ Agregar grupo",
    'fr': "➕ Ajouter un groupe",
    'zh': "➕加群",
    'ar': "➕ أضف مجموعة",
}

# region group
l_group_config = {
    ("ccheck", "👮🏽", "☑"): {
        'ru': "Входной контроль",
        'en': "Enter control",
        'es': "Entrar en control",
        'fr': "Prenez le contrôle",
        'zh': "進入控制",
        'ar': "أدخل السيطرة",
    },
    ("chello", "👋🏽", "☐"): {
        'ru': "Авто-приветствие",
        'en': "Auto-greeting",
        'es': "Saludo automático",
        'fr': "Message d'accueil automatique",
        'zh': "自動問候",
        'ar': "الترحيب التلقائي",
    },
    ("cban", "🕵🏽", "☑"): {
        'ru': "Авто-бан",
        'en': "Auto-ban",
        'es': "Prohibición automática",
        'fr': "Interdiction automatique",
        'zh': "自動禁止",
        'ar': "حظر تلقائي",
    },
    ("cpost", "🔔", "☐"): {
        'ru': "Авто-постинг",
        'en': "Auto-posting",
        'es': "Publicación automática",
        'fr': "Publication automatique",
        'zh': "自動發布",
        'ar': "النشر التلقائي",
    },
    ("cinvite", "🚶", "☐"): {
        'ru': "Авто-инвайтинг",
        'en': "Auto-inviting",
        'es': "Invitación automática",
        'fr': "Invitation automatiquel",
        'zh': "自動邀請",
        'ar': "دعوة تلقائية",
    },
    ("csystem", "👣", "☐"): {
        'ru': "Сообщ системные",
        'en': "System messages",
        'es': "Mensajes del sistema",
        'fr': "Messages système",
        'zh': "系統消息",
        'ar': "رسائل النظام",
    },
    ("cchannel", "🫥", "☐"): {
        'ru': "Cообщ от‍ имени канала",
        'en': "Msgs from channel name",
        'es': "Msjs del nombre del canal",
        'fr': "Msgs du nom de la chaîne",
        'zh': "來自頻道名稱的消息",
        'ar': "رسائل من اسم القناة",
    },
    ("clink", "🔗", "☑"): {
        'ru': "Cообщ с ссылками",
        'en': "Messages with links",
        'es': "Mensajes con enlaces",
        'fr': "Messages avec liens",
        'zh': "帶有鏈接的消息",
        'ar': "الرسائل ذات الروابط",
    },
    ("csymbol", "文", "☐"): {
        'ru': "Cообщ с 文/ب/ȳ̵͘̚",
        'en': "Messages with 文/ب/ȳ̵͘̚",
        'es': "Mensajes con 文/ب/y",
        'fr': "Messagerie avec 文/ب/y",
        'zh': "與消息 文/ب/y",
        'ar': "文/ب/y الرسائل ذات",
    },
    ("cmedia", "🗣", "☐"): {
        'ru': "Сообщ с медиа",
        'en': "Messages with media",
        'es': "Mensajes con medios",
        'fr': "Msgs avec les médias",
        'zh': "與媒體的消息",
        'ar': "الرسائل بوسائل الإعلام",
    },
    ("cstart", "🚀", "☐"): {
        'ru': "Старт-слова",
        'en': "Start-words",
        'es': "Palabras de inicio",
        'fr': "Mots de départ",
        'zh': "起始詞",
        'ar': "بداية الكلمات",
    },
    ("cstop", "🧾", "☐"): {
        'ru': "Стоп-слова",
        'en': "Stop-words",
        'es': "Para las palabras",
        'fr': "Mots vides",
        'zh': "停用詞",
        'ar': "كلمات التوقف",
    },
    ("cflood", "💬", "☐"): {
        'ru': "Стоп-флуд",
        'en': "Stop-flood",
        'es': "Stop-inundación",
        'fr': "Arrêt-inondation",
        'zh': "止水",
        'ar': "وقف الفيضان",
    },
    ("cuser", "👥", "☑"): {
        'ru': "Пользователи",
        'en': "Users",
        'es': "Usuarias",
        'fr': "Utilisatrices",
        'zh': "用戶",
        'ar': "المستخدمون",
    },
    ("cadmin", "👮🏽", "☑"): {
        'ru': "Администраторы",
        'en': "Admins",
        'es': "Administradoras",
        'fr': "Administratrices",
        'zh': "管理員",
        'ar': "المشرفون",
    },
}
l_remove_group = {
    'ru': "🚫Убрать группу",
    'en': "🚫Remove group",
    'es': "🚫Eliminar grupo",
    'fr': "🚫Supprimer le groupe",
    'zh': "🚫移除群组",
    'ar': "🚫إزالة المجموعة",
}
l_show_groups = {
    'ru': "👩🏽‍💻 <b>Добавленные группы</b>\n\n[команды /cmd]",
    'en': "👩🏽‍💻 <b>Added groups</b>\n\n[commands /cmd]",
    'es': "👩🏽‍💻 <b>Grupos agregados</b>\n\n[comandos /cmd]",
    'fr': "👩🏽‍💻 <b>Groupes ajoutés</b>\n\n[commandes /cmd]",
    'zh': "👩🏽‍💻<b>添加组</b>\n\n[命令/cmd]",
    'ar': "👩🏽‍💻 <b>المجموعات المضافة</b>\n\n[أوامر / cmd]",
}

l_GROUPP_CCHECKBTNNAME = {
    'ru': "✔ Я человек",
    'en': "✔ I am human",
    'es': "✔ soy humano",
    'fr': "✔ Je suis humain",
    'zh': "✔ 我是人",
    'ar': "✔ أنا إنسان",
}
l_GROUPP_CHELLOTEXT = {
    'ru': "🌱 {name}, добро пожаловать в нашу <b>группу</b> {title}!",
    'en': "🌱 {name}, welcome to our <b>group</b> {title}!",
    'es': "🌱 {name}, ¡bienvenido a nuestro <b>grupo</b> {title}!",
    'fr': "🌱 {name}, bienvenue dans notre <b>groupe</b> {title} !",
    'zh': "🌱 {name}，欢迎加入我们的<b>群组</b>{title}！",
    'ar': "🌱 {name} ، مرحبًا بك في <b>مجموعتنا</b> {title}!",
}
l_GROUPP_CCHECKCHANNEL = {
    'ru': "👮🏽 Для <i>проверки подписки</i> необходимо добавить канал командой:\n\n/channel ССЫЛКА НА КАНАЛ",
    'en': "👮🏽 To <i>check the subscription,</i> you need to add a channel with the command:\n\n/channel LINK TO THE CHANNEL",
    'es': "👮🏽 Para <i>verificar la suscripción,</i> debe agregar un canal con el comando:\n\n/canal ENLACE AL CANAL",
    'fr': "👮🏽 Pour <i>vérifier l&#x27;abonnement,</i> vous devez ajouter une chaîne avec la commande :\n\n/channel LIEN VERS LA CHAÎNE",
    'zh': "👮🏽 要<i>查看订阅，</i>您需要使用以下命令添加频道：\n\n/channel LINK TO THE CHANNEL",
    'ar': "👮🏽 <i>للتحقق من الاشتراك ،</i> تحتاج إلى إضافة قناة باستخدام الأمر:\n\n/ channel LINK TO THE CHANNEL",
}
# endregion


# region commands
l_group_commands_handler = {
    'ru': "⚙️ <b>Настройка</b> группы <b>{0}</b> {1}\n\n<b>⛏ Admin-команды @{2}</b>\n/update <i>обновление параметров</i>\n/transfer   <i>передача admin-прав</i>\n/info   <i>информация</i>\n/stat   <i>статистика</i>\n/log   <i>посмотреть логи</i>\n/parse  <i>[all|old|premium|active|online]</i>\n/parse old - <i>парсинг старых id-аккаунтов</i>\n\n<b>⛏ Команды администраторов</b>\n/ban 5m|1h|10d <i>удаление из группы на время</i>\n/unban\n/mute 5m|1h|10d <i>ограничение в группе на время</i>\n/unmute\n/warn+сообщ <i>предупреждение</i>\n/status\n/karma  [+|-]\n/tag+сообщ   <i>@tager random-аккаунтов</i>\n/stop  <i>добавить стоп-слово</i>\n/channel NAME   <i>добавить канал для проверки подписки</i>\n/button NAME    <i>добавить имя кнопки входного контроля</i>\n/delay MIN      <i>установить количество min для задержки 1го сообщ</i>\n/flood NUM      <i>установить количество сообщ для flood</i>\n\n<b>⛏ Команды пользователей</b>\n/help   <i>вывод команд</i>\n/rules  <i>правила группы</i>\n/report <i>сообщить о нарушении</i>\n/happy  <i>получить радость</i>\n/thanks <i>поблагодарить</i>",
    'en': "⚙️ Group <b>setting</b> <b>{0}</b> {1}\n\n<b>⛏ Admin commands @{2}</b>\n/update <i>update parameters</i>\n/transfer <i>transfer admin rights</i>\n/info <i>information</i>\n/stat <i>statistics</i>\n/log <i>view logs</i>\n/parse <i>[all|old|premium|active|online]</i>\n/parse old - <i>parse old account ids</i>\n\n<b>⛏ Commands for administrators</b>\n/ban 5m|1h|10d <i>temporary removal from the group</i>\n/unban\n/mute 5m|1h|10d <i>group time limit</i>\n/unmute\n/warn+mess <i>warning</i>\n/status\n/karma [+|-]\n/tag+mess <i>@tager</i> <i>random- accounts</i>\n/stop <i>add a stopword</i>\n/channel NAME <i>add a channel for checking subscription</i>\n/button NAME <i>add a name for input control button</i>\n/delay MIN <i>set the min amount to delay 1 message</i>\n/flood NUM <i>set the number of messages for flood</i>\n\n<b>⛏ User commands</b>\n/help <i>command output</i>\n/rules <i>group rules</i>\n/report report <i>abuse</i>\n/happy <i>get joy</i>\n/thanks <i>thank</i>",
    'es': "⚙️ <b>Configuración</b> de grupo <b>{0}</b> {1}\n\n<b>⛏ Comandos de administrador @{2}</b>\n/actualizar <i>actualizar parámetros</i>\n/transferir <i>transferir derechos de administrador</i>\n/ <i>información</i> de información\n/ <i>estadísticas</i>\n/registrar <i>ver registros</i> \ n/parse <i>[todos|antiguos|premium|activos|en línea]</i>\n/parse old : <i>analiza los ID de cuentas antiguos</i>\n\n<b>⛏ Comandos para administradores</b>\n/ban 5m|1h|10d <i>eliminación temporal del grupo</i>\n/unban\n/silencio 5m|1h| <i>límite de tiempo de grupo</i> 10d\n/no silenciar\n/advertencia+mensaje <i>advertencia</i>\n/estado\n/karma [+|-]\n/tag+mess <i>@tager</i> <i>cuentas aleatorias</i>\n/ detener <i>agregar una palabra vacía</i>\n/NOMBRE del canal <i>agregar un canal para verificar la suscripción</i>\n/NOMBRE del botón <i>agregar un nombre para el botón de control de entrada</i>\n/retardo MIN <i>establecer la cantidad mínima para retrasar 1 mensaje</i>\n/inundación NUM <i>establecer el número de mensajes para inundación</i>\n\n<b>⛏ Comandos de usuario</b>\n/ <i>salida de comando</i> de ayuda\n/ <i>reglas reglas de grupo</i>\n/informar informar <i>abuso</i>\n/feliz <i>obtener alegría</i>\n/gracias <i>gracias</i>",
    'fr': "⚙️ <b>Paramètres</b> de groupe <b>{0}</b> {1}\n\n<b>⛏ Commandes d&#x27;administration @{2}</b>\n/mettre à jour <i>les paramètres de mise à jour</i>\n/transférer <i>les droits d&#x27;administrateur de transfert</i>\n/ <i>informations d&#x27;information</i>\n/ <i>statistiques</i>\n/journal <i>afficher les journaux</i> \ n/parse <i>[all|old|premium|active|online]</i>\n/parse old - <i>analyse les anciens identifiants de compte</i>\n\n<b>⛏ Commandes pour les administrateurs</b>\n/ban 5m|1h|10d <i>suppression temporaire du groupe</i>\n/unban\n/mute 5m|1h|10d <i>limite de temps de groupe</i>\n/unmute\n/warn+mess <i>warning</i>\n/status\n/karma [+|-]\n/tag+mess <i>@tager</i> <i>random- accounts</i>\n/ stop <i>ajouter un mot vide</i>\n/channel NAME <i>ajouter un canal pour vérifier l&#x27;abonnement</i>\n/button NAME <i>ajouter un nom pour le bouton de contrôle d&#x27;entrée</i>\n/delay MIN <i>définir le montant minimum pour retarder 1 message</i>\n/flood NUM <i>définir le nombre de messages for flood</i>\n\n<b>⛏ Commandes utilisateur</b>\n/ <i>sortie de la commande d&#x27;</i> aide\n/ <i>rules règles du groupe</i>\n/signaler signaler un <i>abus</i>\n/happy <i>get joy</i>\n/merci <i>merci</i>",
    'zh': "⚙️ 群组<b>设置{0}</b> {1}\n\n<b>⛏ 管理员命令@{2}</b>\n/update<i>更新参数</i>\n/transfer<i>转移admin 权限</i>\n/info<i>信息</i>\n/stat<i>统计</i>\n/log<i>查看日志</i>\ n/parse <i>[all|old|premium|active|online]</i>\n/parse old -<i>解析旧帐户 ID</i>\n\n<b>⛏ 管理员命令</b>\n/ban 5m|1h|10d<i>临时从组中删除</i>\n/unban\n/mute 5m|1h|10d<i>群限时</i>\n/unmute\n/warn+mess<i>警告</i>\n/status\n/karma[+|-]\n/tag+mess <i>@tager</i> <i>random-accounts</i>\n/ stop<i>添加停用词</i>\n/channel NAME<i>添加检查订阅的频道</i>\n/button NAME<i>添加输入控制按钮的名称</i>\n/delay MIN<i>设置延迟 1 条消息的最小量</i>\n/flood NUM<i>设置消息数for flood</i>\n\n<b>⛏ 用户命令</b>\n/help<i>命令输出</i>\n/rules<i>组规则</i>\n/report 报告<i>滥用</i>\n/happy <i>get joy</i>\n/thanks <i>thank</i>",
    'ar': "⚙️ <b>إعداد</b> المجموعة <b>{0}</b> {1}\n\n<b>⛏ أوامر المسؤول @ {2}</b>\n/ <i>تحديث المعلمات</i>\n/ <i>نقل حقوق المسؤول</i>\n/ معلومات <i>المعلومات</i>\n/ <i>الإحصائيات</i> الإحصائية\n/ <i>سجلات عرض السجل</i>\n/ parse <i>[all | old | premium | active | online]</i>\n/parse old - <i>تحليل معرفات الحساب القديم</i>\n\n<b>⛏ أوامر للمسؤولين</b>\n/ ban 5m | 1h | 10d <i>إزالة مؤقتة من المجموعة</i>\n/ Unban\n/ mute 5m | 1h | 10d <i>وقت المجموعة</i>\n/ unmute\n/ warn + <i>تحذير</i> الفوضى\n/ status\n/ karma [+ | -]\n/ tag + <i>@tager</i> <i>random- حسابات</i>\n/ إيقاف <i>إضافة كلمة إيقاف</i>\n/ قناة NAME <i>إضافة قناة للتحقق من الاشتراك</i>\n/ زر NAME <i>إضافة اسم لزر التحكم في الإدخال</i>\n/ تأخير MIN <i>قم بتعيين الحد الأدنى للمبلغ لتأخير رسالة واحدة</i>\n/ إغراق NUM <i>قم بتعيين عدد الرسائل من أجل الفيضان</i>\n\n<b>⛏ أوامر المستخدم</b>\n/ <i>إخراج أمر</i> المساعدة\n/ <i>قواعد المجموعة</i>\n/ الإبلاغ عن <i>إساءة استخدام</i>\n/ سعيد <i>الحصول على الفرح</i>\n/ <i>شكرًا</i> جزيلاً",
}
l_update_handler00 = {
    'ru': "🛡 Для дальнейшего <b>администрирования</b> данной группы запустите @{0}-бота и добавьте его в группу как <b>Administrator</b>",
    'en': "🛡 For further <b>administration</b> of this group, run the @{0}-bot and add it to the group as <b>Administrator</b>",
    'es': "🛡 Para una mayor <b>administración</b> de este grupo, ejecute @{0}-bot y agréguelo al grupo como <b>Administrador</b>",
    'fr': "🛡 Pour <b>une administration</b> plus poussée de ce groupe, exécutez le @{0}-bot et ajoutez-le au groupe en tant <b>qu&#x27;administrateur</b>",
    'zh': "🛡 要进一步<b>管理</b>该组，请运行 @{0}-bot 并将其作为<b>管理员</b>添加到组中",
    'ar': "🛡 لمزيد من <b>الإدارة</b> لهذه المجموعة ، قم بتشغيل @ {0} -bot وأضفه إلى المجموعة <b>كمسؤول</b>",
}
l_update_handler01 = {
    'ru': "🛡 Группа добавлена в @{0}-бота и готова к администрированию",
    'en': "🛡 Group added to @{0}-bot and ready for administration",
    'es': "🛡 Grupo agregado a @{0}-bot y listo para administración",
    'fr': "🛡 Groupe ajouté à @{0}-bot et prêt pour l'administration",
    'zh': "🛡 组已添加到@{0}-bot 并准备好进行管理",
    'ar': "🛡 تمت إضافة المجموعة إلى الروبوت @ {0} وجاهزة للإدارة",
}
l_update_handler10 = {
    'ru': "🛡 Группа обновлена и администрируется в @{0}-боте",
    'en': "🛡 Group updated and administrated in @{0}-bot",
    'es': "🛡 Grupo actualizado y administrado en @{0}-bot",
    'fr': "🛡 Groupe mis à jour et administré dans @{0}-bot",
    'zh': "🛡 在@{0}-bot 中更新和管理群组",
    'ar': "🛡 تم تحديث المجموعة وإدارتها في @ {0} -bot",
}
l_update_handler100 = {
    'ru': "🛡 Группа обновлена, но не подключена @{0}-боту! Для дальнейшего <b>администрирования</b> данной группы зайдите в @{0}-бота и нажмите /start",
    'en': "🛡 Group updated, but not connected to @{0}-bot! To further <b>administer</b> this group, go to the @{0}-bot and press /start",
    'es': "🛡 ¡Grupo actualizado, pero no conectado a @{0}-bot! Para seguir <b>administrando</b> este grupo, ve al @{0}-bot y presiona /start",
    'fr': "🛡 Groupe mis à jour, mais non connecté à @{0}-bot ! Pour <b>administrer</b> davantage ce groupe, accédez au @{0}-bot et appuyez sur /start",
    'zh': "🛡 组已更新，但未连接到@{0}-bot！要进一步<b>管理</b>该组，请转到 @{0}-bot 并按 /start",
    'ar': "🛡 تم تحديث المجموعة ولكنها غير مرتبطة بـ @ {0} -bot! <b>لإدارة</b> هذه المجموعة بشكل أكبر ، انتقل إلى @ {0} -bot واضغط / ابدأ",
}
l_group_info_start1 = {
    'ru': "ℹ️ <b>Общая информация о группе</b>\n\n<b>Название</b>: {0} [id={1}, <i>{2} {3}</i>, <u>{4}</u> участ.]{5}{6}{7}",
    'en': "ℹ️ <b>General information about the group</b>\n\n<b>Name</b> : {0} [id= {1} , <i>{2} {3}</i> , <u>{4}</u> members]{5}{6}{7}",
    'es': "ℹ️ <b>Información general sobre el grupo</b>\n\n<b>Nombre</b> : {0} [id= {1} , <i>{2} {3}</i> , <u>{4}</u> miembros]{5}{6}{7}",
    'fr': "ℹ️ <b>Informations générales sur le groupe</b>\n\n<b>Nom</b> : {0} [id= {1} , <i>{2} {3}</i> , <u>{4}</u> membres]{5}{6}{7}",
    'zh': "ℹ️<b>有关群组的一般信息</b>\n\n<b>名称</b>：{0} [id= {1} , <i>{2} {3}</i> , <u>{4}</u>成员]{5}{6}{7}",
    'ar': "ℹ️ <b>معلومات عامة عن المجموعة</b>\n\n<b>الاسم</b> : {0} [id = {1} ، <i>{2} {3}</i> ، <u>{4}</u> الأعضاء] {5} {6} {7}",
}
l_group_stat_start = {
    'ru': "ℹ️ <b>Общая информация о статистике группы</b>\n\n",
    'en': "ℹ️ <b>General information about group statistics</b>\n\n",
    'es': "ℹ️ <b>Información general sobre las estadísticas del grupo</b>\n\n",
    'fr': "ℹ️ <b>Informations générales sur les statistiques de groupe</b>\n\n",
    'zh': "ℹ️<b>关于组统计的一般信息</b>\n\n",
    'ar': "ℹ️ <b>معلومات عامة حول إحصائيات المجموعة</b>\n\n",
}
l_group_stat_start1 = {
    'ru': "ℹ️ <b>Общая статистика группы</b>\n\n<b>Название</b>: {0} [id={1}, <i>{2} {3}</i>, <u>{4}</u> участ.]{5}{6}{7}",
    'en': "ℹ️ <b>General group statistics</b>\n\n<b>Name</b> : {0} [id= {1} , <i>{2} {3}</i> , <u>{4}</u> members]{5}{6}{7}",
    'es': "ℹ️ <b>Estadísticas generales del grupo</b>\n\n<b>Nombre</b> : {0} [id= {1} , <i>{2} {3}</i> , <u>{4}</u> miembros]{5}{6}{7}",
    'fr': "ℹ️ <b>Statistiques générales du groupe</b>\n\n<b>Nom</b> : {0} [id= {1} , <i>{2} {3}</i> , <u>{4}</u> membres]{5}{6}{7}",
    'zh': "ℹ️<b>一般群组统计信息</b>\n\n<b>姓名</b>：{0} [id= {1} , <i>{2} {3}</i> , <u>{4}</u>成员]{5}{6}{7}",
    'ar': "ℹ️ <b>إحصائيات عامة للمجموعة</b>\n\n<b>الاسم</b> : {0} [id = {1} ، <i>{2} {3}</i> ، <u>{4}</u> أعضاء] {5} {6} {7}",
}
l_group_stat_start2 = {
    'ru': "\n<b>Ссылка</b>: {0}\n<b>Описание</b>: {1}\n<b>Привязанный канал</b>: {2}\n",
    'en': "\n<b>Link</b> : {0}\n<b>Description</b> : {1}\n<b>Link channel</b> : {2}\n",
    'es': "\n<b>Enlace</b> : {0}\n<b>Descripción</b> : {1}\n<b>Canal de enlace</b> : {2}\n",
    'fr': "\n<b>Lien</b> : {0}\n<b>Description</b> : {1}\n<b>Lien canal</b> : {2}\n",
    'zh': "\n<b>链接</b>：{0}\n<b>描述</b>：{1}\n<b>链接通道</b>： {2}\n",
    'ar': "\n<b>الارتباط</b> : {0}\n<b>الوصف</b> : {1}\n<b>قناة الارتباط</b> : {2}\n",
}
l_group_stat_start3 = {
    'ru': "<b>Сообщения</b>: {0}\n<b>Дата 1го сообщ</b>: ~{1}\n<b>ID последнего сообщ</b>: {2}\n",
    'en': "<b>Messages</b> : {0}\n<b>Date of 1st message</b> : ~{1}\n<b>Last message ID</b> : {2}\n",
    'es': "<b>Mensajes</b> : {0}\n<b>Fecha del primer mensaje</b> : ~{1}\n<b>ID del último mensaje</b> : {2}\n",
    'fr': "<b>Messages</b> : {0}\n<b>Date du 1er message</b> : ~{1}\n<b>ID du dernier message</b> : {2}\n",
    'zh': "<b>消息</b>：{0}\n<b>第一条消息的日期</b>：~{1}\n<b>最后一条消息 ID</b> ：{2}\n",
    'ar': "<b>الرسائل</b> : {0}\n<b>تاريخ الرسالة الأولى</b> : ~ {1}\n<b>معرّف الرسالة الأخيرة</b> : {2}\n",
}
l_participants = {
    'ru': "участ.",
    'en': "participation.",
    'es': "participación.",
    'fr': "participation.",
    'zh': "参与。",
    'ar': "مشاركة.",
}
l_info_opportunity = {
    'ru': "<b>Возможность просмотра увидевших сообщ</b>: Да (до 50участ.)\n",
    'en': "<b>Ability to View Seen Messages</b> : Да (до 50участ.)\n",
    'es': "<b>Capacidad para ver mensajes vistos</b> : Да (до 50участ.)\n",
    'fr': "<b>Possibilité d&#x27;afficher les messages vus</b> : Да (до 50участ.)\n",
    'zh': "<b>查看已读消息的能力</b>： Да (до 50участ.)\n",
    'ar': "<b>القدرة على عرض الرسائل المرئية</b> : Да (до 50участ.)\n",
}
l_info_history = {
    'ru': "<b>История для новых участников</b>: ",
    'en': "<b>History for new members</b> :",
    'es': "<b>Historial para nuevos miembros</b> :",
    'fr': "<b>Historique pour les nouveaux membres</b> :",
    'zh': "<b>新成员的历史</b>：",
    'ar': "<b>التاريخ للأعضاء الجدد</b> :",
}
l_info_history_show = {
    'ru': "видна\n",
    'en': "видна\n",
    'es': "видна\n",
    'fr': "видна\n",
    'zh': "видна\n",
    'ar': "видна\n",
}
l_info_history_hide = {
    'ru': "скрыта\n",
    'en': "скрыта\n",
    'es': "скрыта\n",
    'fr': "скрыта\n",
    'zh': "скрыта\n",
    'ar': "скрыта\n",
}
l_info_autodel = {
    'ru': "<b>Автоудаление сообщений</b>: ",
    'en': "<b>Auto delete messages</b> :",
    'es': "<b>Eliminar mensajes automáticamente</b> :",
    'fr': "<b>Supprimer automatiquement les messages</b> :",
    'zh': "<b>自动删除消息</b>：",
    'ar': "<b>رسائل الحذف التلقائي</b> :",
}
l_info_slowmode = {
    'ru': "<b>Как часто можно писать</b>: ",
    'en': "<b>How often can you write</b> :",
    'es': "<b>¿Con qué frecuencia puede escribir</b> :",
    'fr': "<b>À quelle fréquence pouvez-vous écrire</b> :",
    'zh': "<b>你多久可以写一次</b>：",
    'ar': "<b>كم مرة يمكنك أن تكتب</b> :",
}
l_info_slowmode_limitless = {
    'ru': "без ограничений\n",
    'en': "без ограничений\n",
    'es': "без ограничений\n",
    'fr': "без ограничений\n",
    'zh': "без ограничений\n",
    'ar': "без ограничений\n",
}
l_info_oppforpart = {
    'ru': "Возможности участников",
    'en': "Member Opportunities",
    'es': "Oportunidades para miembros",
    'fr': "Opportunités pour les membres",
    'zh': "会员机会",
    'ar': "فرص الأعضاء",
}
l_change_group_info = {
    'ru': "Изменение профиля группы",
    'en': "Changing a group profile",
    'es': "Cambiar un perfil de grupo",
    'fr': "Modification d'un profil de groupe",
    'zh': "更改组配置文件",
    'ar': "تغيير ملف تعريف المجموعة",
}
l_pin_message = {
    'ru': "Закрепление сообщений",
    'en': "Pinning messages",
    'es': "Fijar mensajes",
    'fr': "Épingler des messages",
    'zh': "固定消息",
    'ar': "تثبيت الرسائل",
}
l_add_members = {
    'ru': "Добавление участников",
    'en': "Adding members",
    'es': "Agregar miembros",
    'fr': "Ajouter des membres",
    'zh': "添加成员",
    'ar': "إضافة الأعضاء",
}
l_embed_links = {
    'ru': "Предпросмотр ссылок",
    'en': "Link Preview",
    'es': "Vista previa del enlace",
    'fr': "Aperçu du lien",
    'zh': "链接预览",
    'ar': "معاينة الارتباط",
}
l_send_media = {
    'ru': "Отправка фото и видео",
    'en': "Sending photos and videos",
    'es': "Envío de fotos y videos",
    'fr': "Envoi de photos et de vidéos",
    'zh': "发送照片和视频",
    'ar': "إرسال الصور ومقاطع الفيديو",
}
l_send_polls = {
    'ru': "Отправка опросов",
    'en': "Submit surveys",
    'es': "Enviar encuestas",
    'fr': "Soumettre des sondages",
    'zh': "提交调查",
    'ar': "إرسال الاستطلاعات",
}
l_send_stickers = {
    'ru': "Отправка sticker/giff/via_bot",
    'en': "Send sticker/giff/via_bot",
    'es': "Enviar pegatina/giff/via_bot",
    'fr': "Envoyer autocollant/gif/via_bot",
    'zh': "发送贴纸/giff/via_bot",
    'ar': "إرسال الملصق / giff / via_bot",
}
l_info_anonymous_for = {
    'ru': "Анонимность для",
    'en': "Anonymity for",
    'es': "Anonimato para",
    'fr': "Anonymat pour",
    'zh': "匿名",
    'ar': "عدم الكشف عن هويته ل",
}

l_stat_msg_cnt = {
    'ru': "Количество сообщ",
    'en': "Number of messages",
    'es': "Número de mensajes",
    'fr': "Nombre de messages",
    'zh': "消息数",
    'ar': "عدد الرسائل",
}
l_stat_history_for_new = {
    'ru': "История для новых участников",
    'en': "History for new members",
    'es': "Historial para nuevos miembros",
    'fr': "Historique pour les nouveaux membres",
    'zh': "新成员的历史",
    'ar': "التاريخ للأعضاء الجدد",
}
l_stat_history_turn_on = {
    'ru': "(для просмотра статистики <u>включите</u> [Историю группы])",
    'en': "(to view statistics <u>, turn on</u> [Group History])",
    'es': "(para ver las estadísticas <u>, active</u> [Historial del grupo])",
    'fr': "(pour afficher les statistiques <u>, activez</u> [Historique du groupe])",
    'zh': "（要查看统计数据<u>，请打开</u>[群组历史记录]）",
    'ar': "(لعرض الإحصائيات <u>، قم بتشغيل</u> [سجل المجموعة])",
}
l_stat_first_msg_date = {
    'ru': "Дата 1-го сообщ",
    'en': "Date of 1st communication",
    'es': "Fecha de la 1ª comunicación",
    'fr': "Date de la 1ère communication",
    'zh': "第一次通讯日期",
    'ar': "تاريخ الاتصال الأول",
}
l_stat_involved = {
    'ru': "Вовлеченность в чате",
    'en': "Chat engagement",
    'es': "Participación en el chat",
    'fr': "Interaction avec le chat",
    'zh': "聊天参与",
    'ar': "المشاركة الدردشة",
}
l_stat_sent = {
    'ru': "{0}\n@{1} написал(а): {2}  сообщ",
    'en': "{0}\n@{1} wrote: {2} messages",
    'es': "{0}\n@{1} escribió: {2} mensajes",
    'fr': "{0}\n@{1} a écrit : {2} messages",
    'zh': "{0}\n@{1} 写道：{2} 封邮件",
    'ar': "{0}\n@ {1} كتب: {2} رسائل",
}
l_stat_meet = {
    'ru': "{0}\n{1}. <i>{2}</i>..: встретилось {3} раз",
    'en': "{0}\n{1}. <i>{2}</i> ..: encountered {3} times",
    'es': "{0}\n{1}. <i>{2}</i> ..: encontrado {3} veces",
    'fr': "{0}\n{1}. <i>{2}</i> .. : rencontré {3} fois",
    'zh': "{0}\n{1}。 <i>{2}</i> ..：遇到 {3} 次",
    'ar': "{0}\n{1}. <i>{2}</i> ..: تمت مواجهته {3} مرة",
}
l_stat_top5users = {
    'ru': "Топ 5 пользователей (на 1000 сообщ)",
    'en': "Top 5 users (per 1000 messages)",
    'es': "Los 5 usuarios principales (por 1000 mensajes)",
    'fr': "Top 5 des utilisateurs (pour 1000 messages)",
    'zh': "前 5 名用户（每 1000 个帖子）",
    'ar': "أعلى 5 مستخدمين (لكل 1000 رسالة)",
}
l_stat_top5msgs = {
    'ru': "Топ 5 сообщ (из 1000)",
    'en': "Top 5 posts (out of 1000)",
    'es': "Las 5 publicaciones principales (de 1000)",
    'fr': "Top 5 des messages (sur 1000)",
    'zh': "前 5 个帖子（共 1000 个）",
    'ar': "أعلى 5 مشاركات (من أصل 1000)",
}
l_status_for = {
    'ru': "⚠️ Статус <b>{0}</b> для {1}:\n\n",
    'en': "⚠️ Status <b>{0}</b> for {1}:\n\n",
    'es': "⚠️ Estado <b>{0}</b> para {1}:\n\n",
    'fr': "⚠️ Statut <b>{0}</b> pour {1} :\n\n",
    'zh': "⚠️ {1} 的状态<b>{0}</b> ：\n\n",
    'ar': "⚠️ الحالة <b>{0}</b> لـ {1}:\n\n",
}

l_transfer_reply = {
    'ru': "⚠️ <b>Используй</b> команду /transfer в <b>ответном</b> сообщении пользователя, которому вы хотите передать права",
    'en': "⚠️ Use the /transfer command in <b>the response</b> message of the user you want to transfer rights to",
    'es': "⚠️ Use el comando /transfer en <b>el mensaje de respuesta</b> del usuario al que desea transferir los derechos",
    'fr': "⚠️ Utilisez la commande /transfer dans <b>le message de réponse</b> de l'utilisateur à qui vous souhaitez transférer les droits",
    'zh': "⚠️ 在你想转让权限的用户的<b>响应</b>消息中使用 /transfer 命令",
    'ar': "⚠️ استخدم الأمر / transfer في رسالة <b>استجابة</b> المستخدم الذي تريد نقل الحقوق إليه",
}
l_button_handler = {
    'ru': "👮🏽 <b>Готово!</b> Текущее <b>имя кнопки</b> на <i>входном контроле</i> установлено: {0}",
    'en': "👮🏽 <b>Done!</b> The current <b>button name</b> on <i>the input control</i> is set to: {0}",
    'es': "👮🏽 <b>Listo!</b> El <b>nombre del botón</b> actual en <i>el control de entrada</i> se establece en: {0}",
    'fr': "👮🏽 <b>C&#x27;est fait !</b> Le <b>nom actuel du bouton</b> sur <i>le contrôle d&#x27;entrée</i> est défini sur : {0}",
    'zh': "👮🏽<b>完成！</b><i>输入控件</i>上的当前<b>按钮名称</b>设置为：{0}",
    'ar': "👮🏽 <b>انتهى!</b> تم تعيين <b>اسم الزر</b> الحالي في <i>عنصر تحكم الإدخال</i> على: {0}",
}
l_button_correct = {
    'ru': "👮🏽 <b>Введи</b> корректное название <i>для имени кнопки</i> Входного контроля\n\n👉🏼 Например, /button {0}",
    'en': "👮🏽 <b>Please enter</b> a valid name <i>for the Input Control button name</i>\n\n👉🏼 For example, /button {0}",
    'es': "👮🏽 <b>Ingrese</b> un nombre válido <i>para el nombre del botón de control de entrada</i>\n\n👉🏼 Por ejemplo, /button {0}",
    'fr': "👮🏽 <b>Veuillez saisir</b> un nom valide <i>pour le nom du bouton de contrôle d&#x27;entrée</i>\n\n👉🏼 Par exemple, /button {0}",
    'zh': "👮🏽 请<i>为输入控件按钮名称</i><b>输入</b>有效名称\n\n👉🏼 例如， /button {0}",
    'ar': "👮🏽 <b>الرجاء إدخال</b> اسم صالح <i>لاسم زر التحكم في الإدخال</i>\n\n👉🏼 على سبيل المثال ، /button {0}",
}
l_channel_check = {
    'ru': "⚙️ Добавь @{0}-бота в канал для проверки подписки на него. Пришли мне корректную ссылку на канал:",
    'en': "⚙️ Add @{0}-bot to the channel to check if you subscribe to it. Send me the correct link to the channel:",
    'es': "⚙️ Agrega @{0}-bot al canal para comprobar si estás suscrito. Envíame el enlace correcto al canal:",
    'fr': "⚙️ Ajoutez @{0}-bot à la chaîne pour vérifier si vous y êtes abonné. Envoyez-moi le bon lien vers la chaîne :",
    'zh': "⚙️ 将@{0}-bot 添加到频道以检查您是否订阅了它。向我发送正确的频道链接：",
    'ar': "⚙️ أضف @ {0} -bot إلى القناة للتحقق مما إذا كنت مشتركًا فيها. أرسل لي الرابط الصحيح للقناة:",
}
l_channel_done = {
    'ru': "👮🏽 <b>Готово!</b> Проверка подписки на {0} настроена\n\nОпцию можно включить в настройках, нажав [✅☑Вкл подписку]",
    'en': "👮🏽 <b>Done!</b> Checking subscription to {0} is configured\n\nThe option can be enabled in the settings by pressing [✅☑Enable subscription]",
    'es': "👮🏽 <b>Listo!</b> Verificar que la suscripción a {0} está configurada\n\nLa opción se puede habilitar en la configuración presionando [✅☑Habilitar suscripción]",
    'fr': "👮🏽 <b>C&#x27;est fait !</b> Vérifier que l'abonnement à {0} est configuré\n\nL'option peut être activée dans les paramètres en appuyant sur [✅☑Activer l'abonnement]",
    'zh': "👮🏽<b>完成！</b>检查对 {0} 的订阅是否已配置\n\n可以通过按 [✅☑启用订阅] 在设置中启用该选项",
    'ar': "👮🏽 <b>انتهى!</b> التحقق من الاشتراك في {0} مهيأ\n\nيمكن تمكين الخيار في الإعدادات بالضغط على [✅☑ تمكين الاشتراك]",
}
l_channel_correct = {
    'ru': "👮🏽 Добавь @{0}-бота в канал и отправь корректную <i>ссылку</i> этого канала\n\n👉🏼 Например, /channel @{1}",
    'en': "👮🏽 Add @{0}-bot to the channel and send the correct <i>link</i> of this channel\n\n👉🏼 For example, /channel @{1}",
    'es': "👮🏽 Agrega @{0}-bot al canal y envía el <i>enlace</i> correcto de este canal\n\n👉🏼 Por ejemplo, /channel @{1}",
    'fr': "👮🏽 Ajoutez @{0}-bot au canal et envoyez le <i>lien</i> correct de ce canal\n\n👉🏼 Par exemple, /channel @{1}",
    'zh': "👮🏽 将@{0}-bot 添加到频道并发送该频道的正确<i>链接</i>\n\n👉🏼 例如， /channel @{1}",
    'ar': "👮🏽 Add @ {0} -bot إلى القناة وأرسل <i>الرابط</i> الصحيح لهذه القناة\n\n👉🏼 على سبيل المثال ، /channel @{1}",
}
l_delay_correct = {
    'ru': "👥 <b>Введи</b> корректное <i>число</i> минут для первичного ограничения новых пользователей\n\n👉🏼 Например, /delay 1\n\nИли используй <b>медленный режим</b> в настройках группы для <u>1</u> сообщения",
    'en': "👥 <b>Enter</b> the correct <i>number of</i> minutes to limit new users for the first time\n\n👉🏼 For example, /delay 1\n\nOr use <b>slow mode</b> in group settings for <u>1</u> message",
    'es': "👥 <b>Ingrese</b> la <i>cantidad correcta de</i> minutos para limitar nuevos usuarios por primera vez\n\n👉🏼 Por ejemplo, /delay 1\n\nO use <b>el modo lento</b> en la configuración del grupo para <u>1</u> mensaje",
    'fr': "👥 <b>Entrez</b> le <i>nombre correct de</i> minutes pour limiter les nouveaux utilisateurs pour la première fois\n\n👉🏼 Par exemple, /delay 1\n\nOu utilisez <b>le mode lent</b> dans les paramètres de groupe pour <u>1</u> message",
    'zh': "👥 第一次<b>输入</b>正确的分钟<i>数</i>限制新用户\n\n👉🏼 例如/delay 1\n\n或者在群设置中使用<b>慢速模式</b><u>1条</u>消息",
    'ar': "👥 <b>أدخل</b> <i>العدد</i> الصحيح للدقائق لتقييد المستخدمين الجدد لأول مرة\n\n👉🏼 على سبيل المثال ، /delay 1\n\nأو استخدم <b>الوضع البطيء</b> في إعدادات المجموعة لرسالة <u>واحدة</u>",
}
l_parse_error = {
    'ru': "📇 Осуществить парсинг пользователей  не удалось",
    'en': "📇 Failed to parse users",
    'es': "📇 No se pudieron analizar los usuarios",
    'fr': "📇 Échec de l'analyse des utilisateurs",
    'zh': "📇 解析用户失败",
    'ar': "📇 فشل تحليل المستخدمين",
}
l_parse_done = {
    'ru': "🔥 <b>Готово!</b> Собрано реальных участников: <u>{0}</u>. Можно сразу сделать <b>рассылку</b> или подписку-<b>инвайт</b> в чат по <i>полученным</i> лидам{1}",
    'en': "🔥 <b>Done!</b> Collected real participants: <u>{0}</u> . You can immediately make <b>a mailing</b> or subscription - <b>invite</b> to the chat according to <i>the received</i> leads{1}",
    'es': "🔥 <b>Listo!</b> Participantes reales recopilados: <u>{0}</u> . Puede enviar <b>un correo</b> o suscribirse de inmediato: <b>invite</b> al chat de acuerdo con <i>los clientes potenciales recibidos</i> {1}",
    'fr': "🔥 <b>C&#x27;est fait !</b> Participants réels collectés : <u>{0}</u> . Vous pouvez immédiatement faire <b>un envoi</b> ou un abonnement - <b>inviter</b> au chat en fonction <i>des prospects reçus</i> {1}",
    'zh': "🔥<b>完成！</b>收集到的真实参与者： <u>{0}</u> 。您可以立即<b>邮寄</b>或订阅 - 根据<i>收到的</i>线索<b>邀请</b>聊天{1}",
    'ar': "🔥 <b>انتهى!</b> تم جمع المشاركين الحقيقيين: <u>{0}</u> . يمكنك إجراء <b>رسالة بريدية</b> أو اشتراك على الفور - <b>ادعُ</b> إلى الدردشة وفقًا للعملاء <i>المحتملين المستلمين</i> {1}",
}
l_parse_btnsend = {
    'ru': "📨️ Рассылка",
    'en': "📨️ Newsletter",
    'es': "📨️ Boletín",
    'fr': "📨️ Newsletter",
    'zh': "📨️ 时事通讯",
    'ar': "📨️ النشرة الإخبارية",
}
l_parse_btninvite = {
    'ru': "🚶🏽 Инвайт",
    'en': "🚶🏽 Invite",
    'es': "🚶🏽 invitar",
    'fr': "🚶🏽 Inviter",
    'zh': "🚶🏽邀请",
    'ar': "🚶🏽 دعوة",
}
l_parse_start = {
    'ru': "📇 <b>Начинаем</b> парсинг..",
    'en': "📇 Let's start parsing..",
    'es': "📇 Empecemos a analizar..",
    'fr': "📇 Commençons l'analyse..",
    'zh': "📇 让我们开始解析..",
    'ar': "📇 لنبدأ في التحليل ..",
}
l_ban_handler = {
    'ru': "🪦 Пользователь {0} в бане на {1}",
    'en': "🪦 User {0} is banned on {1}",
    'es': "🪦 El usuario {0} está prohibido en {1}",
    'fr': "🪦 L'utilisateur {0} est banni sur {1}",
    'zh': "🪦 用户 {0} 在 {1} 被封禁",
    'ar': "🪦 المستخدم {0} محظور على {1}",
}
l_ban_error = {
    'ru': "🪦 Формат бана: /ban (1m|1h|10d)",
    'en': "🪦 Ban format: /ban (1m|1h|10d)",
    'es': "🪦 Formato de prohibición: /ban (1m|1h|10d)",
    'fr': "🪦 Format d'interdiction : /ban (1m|1h|10j)",
    'zh': "🪦 禁令格式：/ban (1m|1h|10d)",
    'ar': "🪦 تنسيق الحظر: / ban (1m | 1h | 10d)",
}
l_ban_unban = {
    'ru': "🪦 Пользователь возвращен из бана",
    'en': "🪦 User returned from ban",
    'es': "🪦 Usuario regresado de baneo",
    'fr': "🪦 L'utilisateur est revenu de l'interdiction",
    'zh': "🪦 用户从禁令中恢复",
    'ar': "🪦 عاد المستخدم من الحظر",
}
l_mute_handler = {
    'ru': "💤 Пользователь {0} обеззвучен на {1}",
    'en': "💤 User {0} mute on {1}",
    'es': "💤 Usuario {0} silenciado en {1}",
    'fr': "💤 Utilisateur {0} muet sur {1}",
    'zh': "💤 用户 {0} 在 {1} 上静音",
    'ar': "💤 المستخدم {0} كتم الصوت في {1}",
}
l_mute_error = {
    'ru': "💤 Формат обеззвучивания: /mute (1m|1h|10d)",
    'en': "💤 Mute format: /mute (1m|1h|10d)",
    'es': "💤 Formato de silencio: /mute (1m|1h|10d)",
    'fr': "💤 Format muet : /muet (1m|1h|10j)",
    'zh': "💤 静音格式：/mute (1m|1h|10d)",
    'ar': "💤 تنسيق كتم الصوت: / كتم الصوت (1 م | 1 س | 10 د)",
}
l_mute_unmute = {
    'ru': "💤 Пользователь {0} больше не обеззвучен",
    'en': "💤 User {0} is no longer mute",
    'es': "💤 El usuario {0} ya no está silenciado",
    'fr': "💤 L'utilisateur {0} n'est plus muet",
    'zh': "💤 用户 {0} 不再是静音",
    'ar': "💤 المستخدم {0} لم يعد كتم الصوت",
}
l_warn_handler = {
    'ru': "⚠️ От имени группы <b>{0}</b> выносится предупреждение {1}{2}",
    'en': "⚠️ Warning {1}{2} on behalf of group <b>{0}</b>",
    'es': "⚠️ Advertencia {1}{2} en nombre del grupo <b>{0}</b>",
    'fr': "⚠️ Avertissement {1}{2} de la part du groupe <b>{0}</b>",
    'zh': "⚠️ 代表<b>{0}</b>组警告{1}{2}",
    'ar': "⚠️ تحذير {1} {2} نيابة عن المجموعة <b>{0}</b>",
}
l_status_pin = {
    'ru': "Закреп сообщ",
    'en': "Fix message",
    'es': "Corregir mensaje",
    'fr': "Corriger le message",
    'zh': "修复消息",
    'ar': "إصلاح الرسالة",
}
l_status_profile = {
    'ru': "Изменение профиля группы",
    'en': "Changing a group profile",
    'es': "Cambiar un perfil de grupo",
    'fr': "Modification d'un profil de groupe",
    'zh': "更改组配置文件",
    'ar': "تغيير ملف تعريف المجموعة",
}
l_sendmsg = {
    'ru': "Отправка сообщ",
    'en': "Sending messages",
    'es': "Enviando mensajes",
    'fr': "Envoi de messages",
    'zh': "发送信息",
    'ar': "إرسال الرسائل",
}
l_status_limit = {
    'ru': "Ограничения до",
    'en': "Restrictions to",
    'es': "Restricciones a",
    'fr': "Restrictions à",
    'zh': "限制",
    'ar': "قيود على",
}
l_status_without = {
    'ru': "(отсутствует) для",
    'en': "(missing) for",
    'es': "(desaparecido) para",
    'fr': "(manquant) pour",
    'zh': "（失踪）为了",
    'ar': "(مفقود) من أجل",
}

l_karma_current = {
    'ru': "Текущая карма пользователя",
    'en': "User's current karma",
    'es': "Karma actual del usuario",
    'fr': "Karma actuel de l'utilisateur",
    'zh': "用户当前业力",
    'ar': "الكارما الحالية للمستخدم",
}
l_karma_in_group = {
    'ru': "в группе",
    'en': "in Group",
    'es': "en grupo",
    'fr': "en groupe",
    'zh': "在集团",
    'ar': "في مجموعة",
}
l_karma_all = {
    'ru': "🪺 Карма пользователей группы <b>{0}</b>",
    'en': "🪺 User group karma <b>{0}</b>",
    'es': "🪺 Karma del grupo de usuarios <b>{0}</b>",
    'fr': "🪺 Karma du groupe d'utilisateurs <b>{0}</b>",
    'zh': "🪺 用户组业力<b>{0}</b>",
    'ar': "🪺 مجموعة المستخدمين karma <b>{0}</b>",
}
l_karma_off = {
    'ru': "🪹 Карма пользователей группы <b>{0}</b> не установлена",
    'en': "🪹 The karma of group <b>{0}</b> users is not set",
    'es': "🪹 El karma de los usuarios del grupo <b>{0}</b> no está configurado",
    'fr': "🪹 Le karma des utilisateurs du groupe <b>{0}</b> n'est pas défini",
    'zh': "🪹 <b>{0}</b>组用户的业力未设置",
    'ar': "🪹 لم يتم تعيين كارما مستخدمي المجموعة <b>{0}</b>",
}
l_tag_handler = {
    'ru': "@ Необходимо ввести сообщение",
    'en': "@ You must enter a message",
    'es': "@ Debes ingresar un mensaje",
    'fr': "@ Vous devez entrer un message",
    'zh': "@你必须输入信息",
    'ar': "@ يجب عليك إدخال رسالة",
}
l_help_handler = {
    'ru': "👉🏼 <b>Команды</b> пользователя:\n\n/rules - правила группы\n/report - сообщить о нарушении\n/happy - получить радость\n/thanks - поблагодарить",
    'en': "👉🏼 User <b>commands</b> :\n\n/rules - group rules\n/report - report violation\n/happy - get joy\n/thanks - give thanks",
    'es': "👉🏼 <b>Comandos</b> de usuario:\n\n/reglas - reglas de grupo\n/reportar - reportar violación\n/feliz - alegría\n/gracias - dar gracias",
    'fr': "👉🏼 <b>Commandes</b> utilisateur :\n\n/règles - règles de groupe\n/signaler - signaler une violation\n/heureux - obtenir de la joie\n/merci - rendre grâce",
    'zh': "👉🏼 用户<b>命令</b>：\n\n/rules - 组规则\n/report - 报告违规\n/happy - 获得快乐\n/thanks - 给予感谢",
    'ar': "👉🏼 <b>أوامر</b> المستخدم:\n\n/ القواعد - قواعد المجموعة\n/ الإبلاغ - الإبلاغ عن انتهاك\n/ سعيد - ابتهج\n/ شكرًا - شكر",
}
l_report_handler = {
    'ru': "❗️ Информация передана администратору. Пользователь {0} взят на карандаш",
    'en': "❗️ The information has been sent to the administrator. User {0} is penciled",
    'es': "❗️ La información ha sido enviada al administrador. El usuario {0} está escrito a lápiz",
    'fr': "❗️ L'information a été transmise à l'administrateur. L'utilisateur {0} est au crayon",
    'zh': "❗️资料已发给管理员。用户 {0} 已使用铅笔",
    'ar': "❗️ تم إرسال المعلومات إلى المسؤول. المستخدم {0} مرسوم بالقلم الرصاص",
}
l_report_admin = {
    'ru': "❗️ Пользователь {0} в группе <b>{1}</b> просит обратить внимание на сообщение {2}{3}",
    'en': "❗️ User {0} in group <b>{1}</b> asks to pay attention to message {2}{3}",
    'es': "❗️ El usuario {0} del grupo <b>{1}</b> pide prestar atención al mensaje {2}{3}",
    'fr': "❗️ L'utilisateur {0} du groupe <b>{1}</b> demande à prêter attention au message {2}{3}",
    'zh': "❗️ 群组<b>{1}</b>中的用户{0}要求关注消息{2}{3}",
    'ar': "❗️ يطلب المستخدم {0} في مجموعة <b>{1}</b> الانتباه إلى الرسالة {2} {3}",
}
l_report_reply = {
    'ru': "❗ Отправь эту команду в ответ на сообщение",
    'en': "❗ Send this command in response to a message",
    'es': "❗ Envía este comando en respuesta a un mensaje",
    'fr': "❗ Envoyer cette commande en réponse à un message",
    'zh': "❗发送此命令以响应消息",
    'ar': "❗ أرسل هذا الأمر ردًا على رسالة",
}
l_thanks_handler = {
    'ru': "🎉 От имени группы <b>{0}</b> обьявляется благодарность {1}{2}",
    'en': "🎉 Thank you {1}{2} on behalf of the group <b>{0}</b>",
    'es': "🎉 Gracias {1}{2} en nombre del grupo <b>{0}</b>",
    'fr': "🎉 Merci {1}{2} au nom du groupe <b>{0}</b>",
    'zh': "🎉 代表小组<b>{0}</b>感谢{1}{2}",
    'ar': "🎉 شكرًا لك {1} {2} بالنيابة عن المجموعة <b>{0}</b>",
}
l_thanks_reply = {
    'ru': "🎉 Отправь эту команду в ответ на сообщение",
    'en': "🎉 Send this command as a reply to a message",
    'es': "🎉 Envía este comando como respuesta a un mensaje",
    'fr': "🎉 Envoyez cette commande en réponse à un message",
    'zh': "🎉发送此命令作为对消息的回复",
    'ar': "🎉 أرسل هذا الأمر كرد على رسالة",
}
l_birthday_handler = {
    'ru': "🥳 От имени группы <b>{0}</b> поздравляем с днем рождения {1}{2}",
    'en': "🥳 On behalf of the group <b>{0}</b> , happy birthday to {1}{2}",
    'es': "🥳 En nombre del grupo <b>{0}</b> , feliz cumpleaños a {1}{2}",
    'fr': "🥳 Au nom du groupe <b>{0}</b> , joyeux anniversaire à {1}{2}",
    'zh': "🥳 代表小组<b>{0}</b> ，祝{1}{2}生日快乐",
    'ar': "🥳 نيابة عن المجموعة <b>{0}</b> ، عيد ميلاد سعيد لـ {1} {2}",
}
l_birthday_reply = {
    'ru': "🥳 Отправь эту команду в ответ на сообщение",
    'en': "🥳 Send this command as a reply to a message",
    'es': "🥳 Envía este comando como respuesta a un mensaje",
    'fr': "🥳 Envoyez cette commande en réponse à un message",
    'zh': "🥳 发送此命令作为对消息的回复",
    'ar': "🥳 أرسل هذا الأمر كرد على رسالة",
}
l_videochat_text = {
    'ru': "🎥 Автоматическое анонсирование <b>видео-трансляции</b> [/videochat d h] каждый <u>d</u>-день (1-31) на <u>h</u>-часов (1-168). Текущее значение: /videochat {0}\n\n👩🏽‍💻 Например,\n/videochat 1 1 (ежедневный видео-анонс длительностью 1 час)\n/videochat 0 (отключение опции)",
    'en': "🎥 Automatic announcement <b>of the video broadcast</b> [/videochat dh] every <u>d</u> -day (1-31) for <u>h</u> -hours (1-168). Current value: /videochat {0}\n\n👩🏽‍💻 For example\n/videochat 1 1 (daily 1 hour video announcement)\n/videochat 0 (disable option)",
    'es': "🎥 Anuncio automático <b>de la transmisión de video</b> [/videochat dh] cada <u>d</u> -día (1-31) durante <u>h</u> -horas (1-168). Valor actual: /videochat {0}\n\n👩🏽‍💻 Por ejemplo\n/videochat 1 1 (anuncio de video diario de 1 hora)\n/videochat 0 (opción deshabilitada)",
    'fr': "🎥 Annonce automatique <b>de la diffusion vidéo</b> [/videochat dh] tous <u>les j</u> -jours (1-31) pendant <u>h</u> -heures (1-168). Valeur actuelle : /videochat {0}\n\n👩🏽‍💻 Par exemple\n/videochat 1 1 (annonce vidéo quotidienne d&#x27;une heure)\n/videochat 0 (option de désactivation)",
    'zh': "🎥 每<u>d</u>天（1-31）自动播报<b>视频广播</b>[/videochat dh] ，持续<u>h</u>小时（1-168）。当前值：/videochat {0}\n\n👩🏽‍💻 例如\n/videochat 1 1 （每天1小时视频公告）\n/videochat 0 （禁用选项）",
    'ar': "🎥 الإعلان التلقائي <b>عن بث الفيديو</b> [/videochat dh] كل يوم <u>يوم</u> (1-31) لمدة <u>ساعة</u> (1-168). القيمة الحالية: / videochat {0}\n\n👩🏽‍💻 على سبيل المثال\n/videochat 1 1 (إعلان فيديو لمدة ساعة يوميًا)\n/videochat 0 (خيار تعطيل)",
}
l_flood_text = {
    'ru': "💬 <b>Введи</b> корректное <i>число</i> сообщений от <u>3</u> до <u>10</u>\n\n👉🏼 <b>Текущее</b> значение /flood {0}\n\n👩🏽‍💻 Например, /flood 3 (идентификация 3х сообщений подряд как flood)\n/flood 0 (отключение опции)",
    'en': "💬 Please <b>enter</b> a valid <i>number</i> of messages from <u>3</u> to <u>10</u>\n\n👉🏼 <b>Current</b> value /flood {0}\n\n👩🏽‍💻 For example, /flood 3 (identifies 3 messages in a row as a flood)\n/flood 0 (disables options)",
    'es': "💬 <b>Ingrese</b> un <i>número</i> válido de mensajes de <u>3</u> a <u>10</u>\n\n👉🏼 Valor <b>actual</b> /flood {0}\n\n👩🏽‍💻 Por ejemplo, /inundación 3 (identifica 3 mensajes seguidos como una inundación)\n/inundación 0 (deshabilita opciones)",
    'fr': "💬 Veuillez <b>entrer</b> un <i>nombre</i> valide de messages de <u>3</u> à <u>10</u>\n\n👉🏼 Valeur <b>actuelle</b> /flood {0}\n\n👩🏽‍💻 Par exemple, /flood 3 (identifie 3 messages à la suite comme une inondation)\n/flood 0 (désactive les options)",
    'zh': "💬<b>请输入</b><u>3</u>到<u>10</u>之间的有效消息<i>数</i>\n\n👉🏼<b>当前</b>值/flood {0}\n\n👩🏽‍💻 例如 /flood 3（连续 3 条消息标识为洪水）\n/flood 0（禁用选项）",
    'ar': "💬 الرجاء <b>إدخال</b> <i>رقم</i> صالح للرسائل من <u>3</u> إلى <u>10</u>\n\n👉🏼 القيمة <b>الحالية</b> /flood {0}\n\n👩🏽‍💻 على سبيل المثال ، / فيضان 3 (يحدد 3 رسائل في صف واحد كفيضان)\n/ فيضان 0 (تعطيل الخيارات)",
}
l_flood_on = {
    'ru': "💬 <b>Установлен</b> flood-режим: {0} сообщения подряд",
    'en': "💬 Set flood mode: {0} messages in a row",
    'es': "💬 Establecer modo de inundación: {0} mensajes seguidos",
    'fr': "💬 Définir le mode flood : {0} messages d'affilée",
    'zh': "💬 设置泛洪模式：连续 {0} 条消息",
    'ar': "💬 ضبط وضع الفيضان: {0} رسائل متتالية",
}
l_flood_off = {
    'ru': "💬 <b>Режим</b> flood отключен",
    'en': "💬 Flood mode disabled",
    'es': "💬 Modo de inundación deshabilitado",
    'fr': "💬 Mode inondation désactivé",
    'zh': "💬洪水模式禁用",
    'ar': "💬 وضع الفيضان معطل",
}
l_delay_text = {
    'ru': "👥 <b>Введи</b> корректное <i>число</i> минут для первичного ограничения новых пользователей\n\n👉🏼 <b>Текущее</b> значение /delay {0}\n\n👩🏽‍💻 Например, /delay 3 (ограничение на 3 min)\n/delay 0 (отключение опции)",
    'en': "👥 <b>Please enter</b> the correct <i>number</i> of minutes for the initial limit of new users\n\n👉🏼 <b>The current</b> value of /delay {0}\n\n👩🏽‍💻 For example, /delay 3 (3 min limit)\n/delay 0 (disable option )",
    'es': "👥 <b>Ingrese</b> la <i>cantidad</i> correcta de minutos para el límite inicial de nuevos usuarios\n\n👉🏼 <b>El valor actual</b> de /delay {0}\n\n👩🏽‍💻 Por ejemplo, /delay 3 (límite de 3 min)\ n/delay 0 (opción deshabilitar)",
    'fr': "👥 <b>Veuillez entrer</b> le <i>nombre</i> correct de minutes pour la limite initiale de nouveaux utilisateurs\n\n👉🏼 <b>La valeur actuelle</b> de /delay {0}\n\n👩🏽‍💻 Par exemple, /delay 3 (3 min limit)\ n/délai 0 (désactiver l'option )",
    'zh': "👥<b>请输入</b>正确的新用户初始限制分钟<i>数</i>\n\n👉🏼 /delay {0}<b>当前</b>值{0}\n\n👩🏽‍💻 例如/delay 3（3分钟限制）\ n/delay 0（禁用选项）",
    'ar': "👥 <b>الرجاء إدخال</b> <i>العدد</i> الصحيح للدقائق للحد الأولي للمستخدمين الجدد\n\n👉🏼 القيمة <b>الحالية</b> لـ /delay {0}\n\n👩🏽‍💻 على سبيل المثال ، / delay 3 (3 min limit) \ ن / تأخير 0 (تعطيل الخيار)",
}
l_delay_on = {
    'ru': "👥 <b>Готово!</b> Текущая первичная задержка для <u>новых</u> пользователей (перед написанием их <u>1</u>го сообщ) установлена в значение <u>{0}</u> min",
    'en': "👥 <b>Done!</b> The current initial delay for <u>new</u> users (before writing their <u>1st</u> message) is set to <u>{0}</u> min",
    'es': "👥 <b>Listo!</b> El retraso inicial actual para <u>nuevos</u> usuarios (antes de escribir su <u>primer</u> mensaje) se establece en <u>{0}</u> min",
    'fr': "👥 <b>C&#x27;est fait !</b> Le délai initial actuel pour <u>les nouveaux</u> utilisateurs (avant d&#x27;écrire leur <u>1er</u> message) est défini sur <u>{0}</u> min",
    'zh': "👥<b>完成！</b><u>新</u>用户的当前初始延迟（在编写他们的<u>第一条</u>消息之前）设置为<u>{0}</u>分钟",
    'ar': "👥 <b>انتهى!</b> تم تعيين التأخير الأولي الحالي للمستخدمين <u>الجدد</u> (قبل كتابة رسالتهم <u>الأولى</u> ) على <u>{0}</u> دقيقة",
}
l_delay_off = {
    'ru': "👥 <b>Режим</b> delay отключен",
    'en': "👥 Delay mode disabled",
    'es': "👥 Modo de retraso deshabilitado",
    'fr': "👥 Mode délai désactivé",
    'zh': "👥 禁用延迟模式",
    'ar': "👥 وضع التأخير معطل",
}
l_rules_handler = {
    'ru': "👉🏼 <b>Правила</b> группы <b>{0}</b>:\n\n{1}",
    'en': "👉🏼 Group <b>rules</b> <b>{0}</b> :\n\n{1}",
    'es': "👉🏼 <b>Reglas</b> de grupo <b>{0}</b> :\n\n{1}",
    'fr': "👉🏼 <b>Règles</b> de groupe <b>{0}</b> :\n\n{1}",
    'zh': "👉🏼 组<b>规则{0}</b> :\n\n{1}",
    'ar': "👉🏼 <b>قواعد</b> المجموعة <b>{0}</b> :\n\n{1}",
}
l_rules_on = {
    'ru': "👉🏼 <b>Установлены</b> <u>новые</u> <b>правила</b> для группы <b>{0}</b>:\n\n{1}",
    'en': "👉🏼 <u>New</u> <b>rules</b> set for group <b>{0}</b> :\n\n{1}",
    'es': "👉🏼 <u>Nuevas</u> <b>reglas</b> establecidas para el grupo <b>{0}</b> :\n\n{1}",
    'fr': "👉🏼 <u>Nouvelles</u> <b>règles</b> définies pour le groupe <b>{0}</b> :\n\n{1}",
    'zh': "👉🏼 为组<b>{0}</b>设置的<u>新</u><b>规则</b>：\n\n{1}",
    'ar': "👉🏼 تم تعيين <b>قواعد</b> <u>جديدة</u> للمجموعة <b>{0}</b> :\n\n{1}",
}
l_rules_off = {
    'ru': "👉🏼 <b>Правила</b> в группе <b>{0}</b> не установлены. Необходимо <u>ответить на пост</u> с правилами <b>командой</b> /rules",
    'en': "👉🏼 <b>The rules</b> in group <b>{0}</b> are not set. <u>Reply to a post</u> with rules with the /rules <b>command</b>",
    'es': "👉🏼 <b>Las reglas</b> del grupo <b>{0}</b> no están establecidas. <u>Responda a una publicación</u> con reglas con el <b>comando</b> /rules",
    'fr': "👉🏼 <b>Les règles</b> du groupe <b>{0}</b> ne sont pas définies. <u>Répondre à un message</u> avec des règles avec la <b>commande</b> /rules",
    'zh': "👉🏼组<b>{0}</b>中的<b>规则</b>未设置。使用 /rules<b>命令</b><u>回复带有规则的帖子</u>",
    'ar': "👉🏼 لم يتم تعيين <b>القواعد</b> في المجموعة <b>{0}</b> . <u>قم بالرد على منشور</u> بالقواعد باستخدام <b>الأمر</b> / rules",
}
# endregion


# region ccheck
l_ccheck_handler = {
    'ru': "👮🏽 <b>Жми</b> на ✅/🔘, чтобы <b>переключить</b> тип <i>проверки</i> пользователя при <u>вступлении</u> в группу\n\n👉🏼 Для установки имени <b>нажимаемой кнопки</b>, выполни команду: /button {0}\n\n👉🏼 Для <b>проверки подписки</b> на канал <i>добавь</i> @{1}-бота в канал и выполни команду: /channel {2}\n\n👉🏼 Для <i>защиты от атаки</i> на группу включи режим <b>антирейд</b> (блокировка <u>всех</u> вступающих)",
    'en': "👮🏽 <b>Click</b> on ✅/🔘 to <b>switch</b> the type of user <i>verification</i> when <u>joining</u> a group\n\n👉🏼 To set the name <b>of the button to be pressed</b> , run the command: /button {0}\n\n👉🏼 To <b>check the subscription</b> to the channel <i>, add</i> @ {1}-bot into the channel and execute the command: /channel {2}\n\n👉🏼 To <i>protect against an attack</i> on the group, turn on the <b>anti-raid</b> mode (blocking <u>all</u> joiners)",
    'es': "👮🏽 <b>Haz clic</b> en ✅/🔘 para <b>cambiar</b> el tipo de <i>verificación</i> de usuario al <u>unirte a</u> un grupo\n\n👉🏼 Para establecer el nombre <b>del botón que se presionará</b> , ejecuta el comando: /button {0}\n\n👉🏼 Para <b>verificar la suscripción</b> al canal <i>, agregue</i> @ {1}-bot al canal y ejecute el comando: /channel {2}\n\n👉🏼 Para <i>protegerse contra un ataque</i> al grupo, active el modo <b>anti-raid</b> (bloqueando <u>a todos</u> los carpinteros)",
    'fr': "👮🏽 <b>Cliquez</b> sur ✅/🔘 pour <b>changer</b> le type de <i>vérification</i> de l&#x27;utilisateur lors <u>de l&#x27;adhésion à</u> un groupe\n\n👉🏼 Pour définir le nom <b>du bouton à appuyer</b> , exécutez la commande : /button {0}\n\n👉🏼 Pour <b>vérifier l&#x27;abonnement</b> au canal <i>, ajoutez</i> @{1}-bot dans le canal et exécutez la commande : /channel {2}\n\n👉🏼 Pour <i>vous protéger contre une attaque</i> sur le groupe, activez le mode <b>anti-raid</b> (bloquant <u>tous</u> les participants)",
    'zh': "👮🏽<b>点击</b>✅/🔘<b>切换</b><u>加入</u>群组时的用户<i>验证</i>类型\n\n👉🏼 要设置<b>要按下的按钮</b>的名称，运行命令： /button {0}\n\n👉🏼<b>查看频道订阅情况</b><i>，将@{1}-bot 添加</i>到频道，执行命令： /channel {2}\n\n👉🏼 为<i>防止群内攻击</i>，开启<b>防突袭</b>模式（阻止<u>所有</u>加入者）",
    'ar': "👮🏽 <b>انقر</b> فوق ✅ / 🔘 <b>لتبديل</b> نوع <i>التحقق</i> من المستخدم عند <u>الانضمام إلى</u> مجموعة\n\n👉🏼 لتعيين اسم <b>الزر المراد الضغط عليه</b> ، قم بتشغيل الأمر: /button {0}\n\n👉🏼 للتحقق <b>من الاشتراك</b> في القناة <i>، أضف</i> @ {1} -bot إلى القناة ونفذ الأمر: /channel {2}\n\n👉🏼 <i>للحماية من هجوم</i> على المجموعة ، شغّل وضع <b>anti-raid</b> (حظر <u>جميع</u> النجارين)",
}
l_ccheck_add = {
    'ru': "\n\nВ настройках [Администраторы] вкл для {0}-бота:\n[✅ Удаление сообщ]\n[✅ Блокировка польз]\n[✅ Добавление участ]\n\n🕚Подожди 1min",
    'en': "\n\nIn [Administrators] settings, on for {0}-bot:\n[✅ Deleting messages]\n[✅ Blocking users]\n[✅ Adding members]\n\n🕚Wait 1min",
    'es': "\n\nEn la configuración de [Administradores], activado para {0}-bot:\n[✅ Eliminación de mensajes]\n[✅ Bloqueo de usuarios]\n[✅ Adición de miembros]\n\n🕚Espera 1 minuto",
    'fr': "\n\nDans les paramètres [Administrateurs], activé pour {0}-bot :\n[✅ Suppression de messages]\n[✅ Blocage d'utilisateurs]\n[✅ Ajout de membres]\n\n🕚Attendez 1 min",
    'zh': "\n\n在 [管理员] 设置中，为 {0}-bot 打开：\n[✅ 删除消息]\n[✅ 阻止用户]\n[✅ 添加成员]\n\n🕚 等待 1 分钟",
    'ar': "\n\nفي إعدادات [Administrators] ، مفعَّلة لـ {0} - الروبوت:\n[✅ حذف الرسائل]\n[✅ حظر المستخدمين]\n[✅ إضافة أعضاء]\n\n🕚 انتظر دقيقة واحدة",
}
l_ccheck_call_request_on = {
    'ru': "👮🏽 В настройках [Тип группы] вкл:\n[✅ Заявки на вступление]{0}",
    'en': "👮🏽 In [Group type] settings, on:\n[✅ Applications to join]{0}",
    'es': "👮🏽 En la configuración de [Tipo de grupo], en:\n[✅ Solicitudes para unirse]{0}",
    'fr': "👮🏽 Dans les paramètres [Type de groupe], sur :\n[✅ Candidatures à rejoindre]{0}",
    'zh': "👮🏽 在【群组类型】设置中，开启：\n【✅申请加入】{0}",
    'ar': "👮🏽 في إعدادات [نوع المجموعة] ، في:\n[✅ تطبيقات للانضمام] {0}",
}
l_ccheck_call_request_off = {
    'ru': "👮🏽 В настройках [Тип группы] выкл:\n[☑️ Заявки на вступление]{0}",
    'en': "👮🏽 In [Group Type] settings off:\n[☑️ Applications to join]{0}",
    'es': "👮🏽 En la configuración de [Tipo de grupo] desactivado:\n[☑️ Solicitudes para unirse]{0}",
    'fr': "👮🏽 Dans les paramètres [Type de groupe] désactivé :\n[☑️ Candidatures à rejoindre]{0}",
    'zh': "👮🏽 在[组类型]设置中关闭：\n[☑️申请加入]{0}",
    'ar': "👮🏽 في إعدادات [نوع المجموعة] متوقف:\n[☑️ تطبيقات للانضمام] {0}",
}
l_ccheck_other_person = {
    'ru': "👮🏽 Эта кнопка не для тебя",
    'en': "👮🏽 This button is not for you",
    'es': "👮🏽 Este botón no es para ti",
    'fr': "👮🏽 Ce bouton n'est pas pour vous",
    'zh': "👮🏽 这个按钮不适合你",
    'ar': "👮🏽 هذا الزر ليس لك",
}
l_ccheckchannel_link = {
    'ru': "👮🏽 Ссылка на {0} не доступна",
    'en': "👮🏽 Link to {0} is not available",
    'es': "👮🏽 El enlace a {0} no está disponible",
    'fr': "👮🏽 Le lien vers {0} n'est pas disponible",
    'zh': "👮🏽 指向 {0} 的链接不可用",
    'ar': "👮🏽 الرابط إلى {0} غير متاح",
}
l_ccheckchannel_chn = {
    'ru': "👮🏽 Ты не вступил в {0}\n\nПопробуй ещё раз позже",
    'en': "👮🏽 You didn't join {0}\n\nPlease try again later",
    'es': "👮🏽 No te uniste {0}\n\nPor favor, inténtalo de nuevo más tarde",
    'fr': "👮🏽 Vous n'avez pas rejoint {0}\n\nVeuillez réessayer plus tard",
    'zh': "👮🏽您没有加入{0}\n\n请稍后再试",
    'ar': "👮🏽 لم تنضم إلى {0}\n\nالرجاء المحاولة مرة أخرى لاحقًا",
}
l_ccheck_ban = {
    'ru': "👮🏽‍ Пользователь {0} не прошел входной контроль и был удален из группы",
    'en': "👮🏽‍ User {0} failed entry control and was removed from the group",
    'es': "👮🏽‍ El usuario {0} falló el control de entrada y fue eliminado del grupo",
    'fr': "👮🏽‍ L'utilisateur {0} a échoué au contrôle d'entrée et a été retiré du groupe",
    'zh': "👮🏽‍ 用户 {0} 未能通过访问控制并被移出群组",
    'ar': "👮🏽‍ المستخدم {0} فشل في التحكم في الدخول وتمت إزالته من المجموعة",
}
l_ccheckchannel_error = {
    'ru': "👮🏽 Ошибка проверки",
    'en': "👮🏽 Validation Error",
    'es': "👮🏽 Error de validación",
    'fr': "👮🏽 Erreur de validation",
    'zh': "👮🏽 验证错误",
    'ar': "👮🏽 خطأ في التحقق من الصحة",
}
l_ccheck_wrong = {
    'ru': "👮🏽 К сожалению, ответ неверный\n\nПопробуй ещё раз позже",
    'en': "👮🏽 Unfortunately, the answer is incorrect\n\nPlease try again later",
    'es': "👮🏽 Lamentablemente, la respuesta es incorrecta\n\nPor favor, inténtalo de nuevo más tarde",
    'fr': "👮🏽 Malheureusement, la réponse est incorrecte\n\nVeuillez réessayer plus tard",
    'zh': "👮🏽 很遗憾，答案不正确\n\n请稍后再试",
    'ar': "👮🏽 لسوء الحظ ، الإجابة غير صحيحة\n\nالرجاء المحاولة مرة أخرى لاحقًا",
}
l_ccheck_time = {
    'ru': "👮🏽 Входной контроль пройден за {0} sec",
    'en': "👮🏽 Entry Control Passed in {0} sec",
    'es': "👮🏽 Control de entrada superado en {0} s",
    'fr': "👮🏽 Contrôle d'entrée passé en {0} sec",
    'zh': "👮🏽 在 {0} 秒内通过了入口控制",
    'ar': "تم تمرير التحكم في الدخول خلال {0} ثانية",
}
# endregion


# region chello_
l_chello_call = {
    'ru': "🔔 Нет ни одного приветствия, необходимо ⚙️Настроить",
    'en': "🔔 No greetings needed ⚙️Customize",
    'es': "🔔 No se necesitan saludos ⚙️Personalizar",
    'fr': "🔔 Aucune salutation nécessaire ⚙️Personnaliser",
    'zh': "🔔无需问候⚙️自定义",
    'ar': "🔔 لا حاجة لتحيات ⚙️ التخصيص",
}
l_chello_your_hello = {
    'ru': "Ваше приветствие",
    'en': "Your greeting",
    'es': "Tu saludo",
    'fr': "Votre message d'accueil",
    'zh': "你的问候",
    'ar': "تحياتك",
}
l_chello_text = {
    'ru': "👋🏽 <b>Жми</b> на ✅/☑️, чтобы <b>Вкл/Выкл</b> приветствие, а также его ⚙️Настроить\n\n👉🏼 Например, {0}{1}",
    'en': "👋🏽 <b>Click</b> on ✅/☑️ to <b>turn on/off</b> the greeting, as well as its ⚙️Customize\n\n👉🏼 For example, {0} {1}",
    'es': "👋🏽 <b>Haz clic</b> en ✅/☑️ para <b>activar o desactivar</b> el saludo, así como su ⚙️Personalizar\n\n👉🏼 Por ejemplo, {0} {1}",
    'fr': "👋🏽 <b>Cliquez</b> sur ✅/☑️ pour <b>activer/désactiver</b> le message d&#x27;accueil, ainsi que sa ⚙️Personnaliser\n\n👉🏼 Par exemple, {0} {1}",
    'zh': "👋🏽<b>点击</b>✅/☑️<b>打开/关闭</b>问候语，以及它的 ⚙️自定义\n\n👉🏼 例如， {0} {1}",
    'ar': "👋🏽 <b>انقر</b> على ✅ / ☑️ <b>لتشغيل / إيقاف</b> الترحيب ، بالإضافة إلى تخصيص\n\n👉🏼 على سبيل المثال ، {0} {1}",
}
l_btn_on = {
    'ru': "✅☑Вкл",
    'en': "✅☑Incl",
    'es': "✅☑Incluye",
    'fr': "✅☑Inclus",
    'zh': "✅☑包括",
    'ar': "✅☑Incl",
}
l_btn_off = {
    'ru': "☑️☐Выкл",
    'en': "☑️☐Выкл",
    'es': "☑️☐Выкл",
    'fr': "☑️☐Выкл",
    'zh': "☑️☐Выкл",
    'ar': "ыкл",
}
l_btn_settings = {
    'ru': "⚙️Настроить",
    'en': "⚙️Customize",
    'es': "⚙️Personalizar",
    'fr': "⚙️Personnaliser",
    'zh': "⚙️自定义",
    'ar': "⚙️ تخصيص",
}
l_chellochange_handler = {
    'ru': "👋🏽 Отправь мне <b>текст</b>/<b>медиа</b> контент с текстом: фото/гиф/видео/аудио/документ или запиши голосовое/видео-заметку в кружке\n\n👉🏼 Например, {0}",
    'en': "👋🏽 Send me <b>text</b> / <b>media</b> content with text: photo / gif / video / audio / document or write a voice / video note in a circle\n\n👉🏼 For example, {0}",
    'es': "👋🏽 Envíame <b>texto</b> /contenido <b>multimedia</b> con texto: foto/gif/video/audio/documento o escribe una nota de voz/video en un círculo\n\n👉🏼 Por ejemplo, {0}",
    'fr': "👋🏽 Envoyez-moi <b>du texte</b> /du contenu <b>multimédia</b> avec du texte : photo/gif/vidéo/audio/document ou écrivez une note vocale/vidéo dans un cercle\n\n👉🏼 Par exemple, {0}",
    'zh': "👋🏽 向我发送<b>文字</b>/<b>媒体</b>内容并附上文字：照片/gif/视频/音频/文档或将语音/视频笔记写成一个圆圈\n\n👉🏼 例如， {0}",
    'ar': "👋🏽 أرسل لي محتوى <b>نصيًا</b> / <b>وسائط</b> مع نص: صورة / gif / فيديو / صوت / مستند أو اكتب ملاحظة صوتية / فيديو في دائرة\n\n👉🏼 على سبيل المثال ، {0}",
}
l_fsm_hello_finish = {
    'ru': "👋🏽 Приветствие записано!\n\nОпцию можно включить в настройках [👋🏽Авто-приветствие], нажав [✅☑Вкл]",
    'en': "👋🏽 Greeting recorded!\n\nThe option can be enabled in the settings [👋🏽Auto-greeting] by pressing [✅☑On]",
    'es': "👋🏽 ¡Saludo grabado!\n\nLa opción se puede habilitar en la configuración [👋🏽 Saludo automático] presionando [✅☑On]",
    'fr': "👋🏽 Message d'accueil enregistré !\n\nL'option peut être activée dans les paramètres [👋🏽Salutation automatique] en appuyant sur [✅☑On]",
    'zh': "👋🏽问候语已录制！\n\n可以在设置[👋🏽自动问候语]中按[✅☑开启]启用该选项",
    'ar': "👋🏽 تم تسجيل الترحيب!\n\nيمكن تمكين الخيار في الإعدادات [الترحيب التلقائي] بالضغط على [تشغيل]",
}
# endregion


# region cinvite_
l_cinvite_call = {
    'ru': "👮🏽 В настройках [Разрешения] вкл опцию:\n\n[✅ Добавление участ]\n\n🕚Подожди 1min",
    'en': "👮🏽 In the [Permissions] settings, enable the option:\n\n[✅ Adding a part]\n\n🕚Wait 1min",
    'es': "👮🏽 En la configuración de [Permisos], habilita la opción:\n\n[✅ Agregar una parte]\n\n🕚Espera 1 minuto",
    'fr': "👮🏽 Dans les paramètres [Autorisations], activez l'option :\n\n[✅ Ajout d'une pièce]\n\n🕚Attendez 1min",
    'zh': "👮🏽 在[权限]设置中，启用选项：\n\n[✅添加零件]\n\n🕚等待1分钟",
    'ar': "👮🏽 في إعدادات [الأذونات] ، قم بتمكين الخيار:\n\n[✅ إضافة جزء]\n\n🕚 انتظر دقيقة واحدة",
}
l_cinvite_text_add = {
    'ru': "\n\n👉🏼 Приглашается <u>{0}</u> пользователей в сутки из группы {1}",
    'en': "\n\n👉🏼 <u>{0}</u> users per day from {1} group are invited",
    'es': "\n\n👉🏼 <u>{0}</u> usuarios por día del grupo {1} están invitados",
    'fr': "\n\n👉🏼 <u>{0}</u> utilisateurs par jour de {1} groupe sont invités",
    'zh': "\n\n👉🏼 每天邀请来自 {1} 个组的<u>{0} 个</u>用户",
    'ar': "\n\n👉🏼 تمت دعوة <u>{0} من</u> المستخدمين يوميًا من مجموعة {1}",
}
l_cinvite_text = {
    'ru': "🚶🏽 <b>Жми</b> на ✅/☑️, чтобы <b>Вкл/Выкл</b> авто-инвайт пользователей в <b>{0}</b>-группу\n\n👩🏽‍💻 <b>Текущие</b> настройки авто-рассылки: {1}",
    'en': "🚶🏽 <b>Click</b> on ✅/☑️ to <b>enable/disable</b> auto-invite users to <b>{0}</b> -group\n\n👩🏽‍💻 <b>Current</b> auto-mailing settings: {1}",
    'es': "🚶🏽 <b>Haz clic</b> en ✅/☑️ para <b>habilitar o deshabilitar</b> la invitación automática de usuarios a <b>{0}</b> -group\n\n👩🏽‍💻 Configuración <b>actual</b> de correo automático: {1}",
    'fr': "🚶🏽 <b>Cliquez</b> sur ✅/☑️ pour <b>activer/désactiver</b> l&#x27;invitation automatique des utilisateurs au <b>{0}</b> -groupe\n\n👩🏽‍💻 Paramètres de messagerie automatique <b>actuels</b> : {1}",
    'zh': "🚶🏽<b>单击</b>✅/☑️<b>启用/禁用</b>自动邀请用户加入<b>{0}</b> -组\n\n👩🏽‍💻<b>当前</b>自动邮件设置：{1}",
    'ar': "🚶🏽 <b>انقر</b> على ✅ / ☑️ <b>لتمكين / تعطيل</b> دعوة المستخدمين تلقائيًا إلى <b>{0}</b> مجموعة\n\n👩🏽‍💻 إعدادات البريد التلقائي <b>الحالية</b> : {1}",
}

l_cinvite_current = {
    'ru': "🚶🏽 <b>Текущие</b> настройки авто-инвайта в группу:\n\n<u>{0}</u> пользователей/сутки\n<u>{1}</u> источник",
    'en': "🚶🏽 <b>Current</b> group auto-invite settings:\n\n<u>{0}</u> users/day\n<u>{1}</u> source",
    'es': "🚶🏽 Configuración de invitación automática de grupo <b>actual</b> :\n\n<u>{0}</u> usuarios/día\n<u>{1}</u> fuente",
    'fr': "🚶🏽 Paramètres <b>actuels</b> d&#x27;invitation automatique du groupe :\n\n<u>{0}</u> utilisateurs/jour\n<u>{1}</u> source",
    'zh': "🚶🏽<b>当前</b>组自动邀请设置：\n\n<u>{0}</u>用户/天\n<u>{1}</u>来源",
    'ar': "🚶🏽 الإعدادات <b>الحالية</b> للدعوة التلقائية للمجموعة:\n\n<u>{0}</u> المستخدمون / اليوم\n<u>{1}</u> المصدر",
}
l_cinvite_cnt = {
    'ru': "{0} польз/сутки",
    'en': "{0} users/day",
    'es': "{0} usuarios/día",
    'fr': "{0} utilisateurs/jour",
    'zh': "{0} 个用户/天",
    'ar': "{0} مستخدم / يوم",
}
l_cinvite_src = {
    'ru': "{0} источник",
    'en': "{0} source",
    'es': "{0} fuente",
    'fr': "{0} sources",
    'zh': "{0} 个来源",
    'ar': "{0} المصدر",
}
l_cinvitechange_handler = {
    'ru': "🚶🏽 Пришли мне <b>ссылку</b> на группу, откуда будем брать подписчиков\n\n👉🏼 Например, <code>https://t.me/likeconcentrat</code> - <b>Жми</b> на ссылку, чтобы скопировать",
    'en': "🚶🏽 Send me <b>a link</b> to the group from where we will take subscribers\n\n👉🏼 For example, https://t.me/likeconcentrat - <b>Click</b> on the link to copy",
    'es': "🚶🏽 Envíame <b>un enlace</b> al grupo desde donde tomaremos suscriptores\n\n👉🏼 Por ejemplo, https://t.me/likeconcentrat - <b>Haz clic</b> en el enlace para copiar",
    'fr': "🚶🏽 Envoyez-moi <b>un lien</b> vers le groupe d&#x27;où nous prendrons des abonnés\n\n👉🏼 Par exemple, https://t.me/likeconcentrat - <b>Cliquez</b> sur le lien pour copier",
    'zh': "🚶🏽 向我发送指向我们将从中接收订阅者的群组<b>的链接</b>\n\n👉🏼 例如， https://t.me/likeconcentrat -<b>单击</b>链接进行复制",
    'ar': "🚶🏽 أرسل لي <b>رابطًا</b> للمجموعة التي سنأخذ منها المشتركين\n\n👉🏼 على سبيل المثال ، https://t.me/likeconcentrat - <b>انقر</b> فوق الارتباط للنسخ",
}
l_correct_link = {
    'ru': "👩🏽‍💻 <b>Вставь</b> корректные данные или повтори операцию",
    'en': "👩🏽‍💻 <b>Insert</b> correct data or try again",
    'es': "👩🏽‍💻 <b>Inserta</b> los datos correctos o vuelve a intentarlo",
    'fr': "👩🏽‍💻 <b>Insérez</b> les données correctes ou réessayez",
    'zh': "👩🏽‍💻<b>插入</b>正确的数据或重试",
    'ar': "👩🏽‍💻 <b>أدخل</b> البيانات الصحيحة أو حاول مرة أخرى",
}
l_admin_require = {
    'ru': "👩🏽‍💻 Требуются права администратора",
    'en': "👩🏽‍💻 Administrator rights required",
    'es': "👩🏽‍💻 Se requieren derechos de administrador",
    'fr': "👩🏽‍💻 Droits d'administrateur requis",
    'zh': "👩🏽‍💻 需要管理员权限",
    'ar': "👩🏽‍💻 حقوق المسؤول المطلوبة",
}
l_group_not_channel = {
    'ru': "🚶🏽 Вставь ссылку на группу, а не канал",
    'en': "🚶🏽 Paste the link to the group, not the channel",
    'es': "🚶🏽 Pega el enlace al grupo, no al canal",
    'fr': "🚶🏽 Collez le lien vers le groupe, pas la chaîne",
    'zh': "🚶🏽 将链接粘贴到组，而不是频道",
    'ar': "الصق رابط المجموعة وليس القناة",
}
l_no_participants = {
    'ru': "🚶🏽 Нет доступных подписчиков",
    'en': "🚶🏽 No followers available",
    'es': "🚶🏽 No hay seguidores disponibles",
    'fr': "🚶🏽 Aucun abonné disponible",
    'zh': "🚶🏽没有可用的关注者",
    'ar': "🚶🏽 لا يوجد متابعون متاحون",
}
l_current_participants = {
    'ru': "🚶🏽 Для {0}<b>текущее количество</b> реальных подписчиков: <u>{1}</u>\n\n▪️ <b>Введи</b> <i>число</i> подписчиков, которое необходимо подписывать <b>ежедневно</b> от 1 до 3 (без подписки +{2}):",
    'en': "🚶🏽 For {0} <b>current number of</b> real followers: <u>{1}</u>\n\n▪️ <b>Enter</b> <i>the number</i> of followers you need to subscribe <b>daily</b> from 1 to 3 (no subscription +{2}):",
    'es': "🚶🏽 Para {0} <b>número actual de</b> seguidores reales: <u>{1}</u>\n\n▪️ <b>Ingresa</b> <i>el número</i> de seguidores que necesitas para suscribirte <b>diariamente</b> de 1 a 3 (sin suscripción +{2}):",
    'fr': "🚶🏽 Pour {0} <b>nombre actuel de</b> vrais abonnés : <u>{1}</u>\n\n▪️ <b>Entrez</b> <i>le nombre</i> d&#x27;abonnés dont vous avez besoin pour vous abonner <b>quotidiennement</b> de 1 à 3 (pas d'abonnement +{2}) :",
    'zh': "🚶🏽 对于 {0}<b>当前真实粉丝数</b>： <u>{1}</u>\n\n▪️<b>输入</b>您<b>每天</b>需要订阅的粉丝<i>数</i>，从 1 到 3（没有订阅 +{2}）：",
    'ar': "🚶🏽 بالنسبة إلى {0} <b>العدد الحالي من</b> المتابعين الحقيقيين: <u>{1}</u>\n\n▪️ <b>أدخل</b> <i>عدد</i> المتابعين الذين تحتاجهم للاشتراك <b>يوميًا</b> من 1 إلى 3 (بدون اشتراك + {2}):",
}
l_everyday_participants = {
    'ru': "🚶🏽 <b>Введи</b> количество пользователей для ежедневной подписки от 1 до 3 включительно",
    'en': "🚶🏽 <b>Enter</b> the number of users for a daily subscription from 1 to 3 inclusive",
    'es': "🚶🏽 <b>Ingrese</b> el número de usuarios para una suscripción diaria de 1 a 3 inclusive",
    'fr': "🚶🏽 <b>Entrez</b> le nombre d'utilisateurs pour un abonnement journalier de 1 à 3 inclus",
    'zh': "🚶🏽<b>输入</b>每日订阅的用户数量，从 1 到 3（含）",
    'ar': "🚶🏽 <b>أدخل</b> عدد المستخدمين للاشتراك اليومي من 1 إلى 3 ضمناً",
}
l_invite_need_subscribe = {
    'ru': "🚶🏽 Для инвайта > 1 пользователя в день необходимо приобрести подписку. Оформи подписку или введи 1:",
    'en': "🚶🏽 For an invite > 1 user per day, you need to purchase a subscription. Subscribe or enter 1:",
    'es': "🚶🏽 Para una invitación > 1 usuario por día, debe comprar una suscripción. Suscríbete o ingresa 1:",
    'fr': "🚶🏽 Pour une invitation > 1 utilisateur par jour, vous devez acheter un abonnement. Abonnez-vous ou entrez 1 :",
    'zh': "🚶🏽 对于每天超过 1 位用户的邀请，您需要购买订阅。订阅或输入1：",
    'ar': "🚶🏽 لدعوة> مستخدم واحد في اليوم ، تحتاج إلى شراء اشتراك. اشترك أو أدخل 1:",
}
l_invite_correct_num = {
    'ru': "🚶🏽 <b>Введи</b> корректное число",
    'en': "🚶🏽 <b>Please enter</b> the correct number",
    'es': "🚶🏽 <b>Por favor ingrese</b> el número correcto",
    'fr': "🚶🏽 <b>Veuillez entrer</b> le bon numéro",
    'zh': "🚶🏽<b>请输入</b>正确的号码",
    'ar': "🚶🏽 <b>الرجاء إدخال</b> الرقم الصحيح",
}
l_fsm_invite_finish = {
    'ru': "🚶🏽 <b>Готово!</b> Настроен <b>авто</b>-инвайт <u>{0}</u> пользователей в сутки из группы {1}",
    'en': "🚶🏽 <b>Done!</b> Configured <b>auto</b> -invite <u>{0}</u> users per day from the group {1}",
    'es': "🚶🏽 <b>Listo!</b> Invitación <b>automática</b> configurada a <u>{0}</u> usuarios por día del grupo {1}",
    'fr': "🚶🏽 <b>C&#x27;est fait !</b> Configuration de l&#x27;invitation <b>automatique</b> de <u>{0}</u> utilisateurs par jour à partir du groupe {1}",
    'zh': "🚶🏽<b>完成！</b>配置为每天从组 {1} 中<b>自动</b>邀请<u>{0}</u>位用户",
    'ar': "🚶🏽 <b>انتهى!</b> تم تهيئة مستخدمي <u>{0}</u> الدعوة <b>تلقائيًا</b> يوميًا من المجموعة {1}",
}
l_cinvite_nosrc = {
    'ru': "🚶🏽 Не задан источник для инвайта пользователей в группу",
    'en': "🚶🏽 The source for inviting users to the group is not set",
    'es': "🚶🏽 La fuente para invitar usuarios al grupo no está configurada",
    'fr': "🚶🏽 La source d'invitation des utilisateurs au groupe n'est pas définie",
    'zh': "🚶🏽 未设置邀请用户入群的来源",
    'ar': "لم يتم تعيين مصدر دعوة المستخدمين إلى المجموعة",
}
l_cinvite_group = {
    'ru': "🚶🏽 Группа",
    'en': "🚶🏽 Group",
    'es': "🚶🏽 Grupo",
    'fr': "🚶🏽 Groupe",
    'zh': "🚶🏽组",
    'ar': "🚶🏽 المجموعة",
}
l_cinvite_file = {
    'ru': "🚶🏽 Файл",
    'en': "🚶🏽 File",
    'es': "🚶🏽 Archivo",
    'fr': "🚶🏽 Fichier",
    'zh': "🚶🏽 文件",
    'ar': "🚶🏽 ملف",
}
l_cinvite_geo = {
    'ru': "🚶🏽 Гео",
    'en': "🚶🏽 Geo",
    'es': "🚶🏽 Geo",
    'fr': "🚶🏽 Géo",
    'zh': "🚶🏽地理",
    'ar': "🚶🏽 جيو",
}
l_cinvite_choose_src = {
    'ru': "🚶🏽 <b>Выбери источник</b>, откуда будем брать @username для авто-инвайта",
    'en': "🚶🏽 <b>Choose a source</b> from where we will take @username for auto-invite",
    'es': "🚶🏽 <b>Elija una fuente</b> de donde tomaremos @username para invitaciones automáticas",
    'fr': "🚶🏽 <b>Choisissez une source</b> d'où nous prendrons @username pour l'auto-invitation",
    'zh': "🚶🏽 选择我们将@username用于自动邀请的<b>来源</b>",
    'ar': "🚶🏽 <b>اختر مصدرًا</b> حيث سنأخذ @username للدعوات التلقائية",
}
l_cinvite_choose_cnt = {
    'ru': "🚶🏽 <b>Введи</b> <b>количество</b> пользователей для авто-инвайта, которые будут приглашаться ежедневно (без подписки: 1 польз)",
    'en': "🚶🏽 <b>Enter</b> <b>the number of</b> auto-invite users that will be invited daily (without subscription: 1 user)",
    'es': "🚶🏽 <b>Ingrese</b> <b>la cantidad de</b> usuarios de invitación automática que serán invitados diariamente (sin suscripción: 1 usuario)",
    'fr': "🚶🏽 <b>Saisissez</b> <b>le nombre d&#x27;</b> utilisateurs à invitation automatique qui seront invités quotidiennement (sans abonnement : 1 utilisateur)",
    'zh': "🚶🏽<b>输入</b>每天将被邀请的自动邀请用户<b>数</b>（没有订阅：1 位用户）",
    'ar': "<b>أدخل</b> <b>عدد</b> المستخدمين الذين تتم دعوتهم تلقائيًا والذين ستتم دعوتهم يوميًا (بدون اشتراك: مستخدم واحد)",
}
l_cinvite_choose_group = {
    'ru': "🚶🏽 Отправь <b>ссылку</b> на группу, чтобы сделать авто-инвайт по ее @username",
    'en': "🚶🏽 Send <b>a link</b> to a group to auto-invite by its @username",
    'es': "🚶🏽 Envía <b>un enlace</b> a un grupo para autoinvitarlo con su @username",
    'fr': "🚶🏽 Envoyer <b>un lien</b> vers un groupe pour s'inviter automatiquement par son @username",
    'zh': "🚶🏽 发送群组<b>链接</b>以通过其@username自动邀请",
    'ar': "🚶🏽 أرسل <b>رابطًا</b> إلى مجموعة للدعوة تلقائيًا بواسطة @username الخاص بها",
}
l_cinvite_choose_file = {
    'ru': "🚶🏽 Отправь текстовый <b>файл</b> со списком @username, чтобы сделать по ним авто-инвайт",
    'en': "🚶🏽 Send a text <b>file</b> with @username list to auto-invite them",
    'es': "🚶🏽 Envíe un <b>archivo</b> de texto con la lista @username para invitarlos automáticamente",
    'fr': "🚶🏽 Envoyez un <b>fichier</b> texte avec la liste @username pour les inviter automatiquement",
    'zh': "🚶🏽 发送带有@username列表的文本<b>文件</b>以自动邀请他们",
    'ar': "🚶🏽 أرسل <b>ملفًا</b> نصيًا مع قائمة @username لدعوتهم تلقائيًا",
}
l_cinvite_choose_geo = {
    'ru': "🚶🏽 Отправь <b>геопозицию</b>, чтобы получить гео-@username для авто-инвайта",
    'en': "🚶🏽 Send <b>geolocation</b> to get @username geo for auto-invite",
    'es': "🚶🏽 Enviar <b>geolocalización</b> para obtener @username geo para invitación automática",
    'fr': "🚶🏽 Envoyez <b>la géolocalisation</b> pour obtenir @username geo pour l'auto-invitation",
    'zh': "🚶🏽 发送<b>地理位置</b>以获取@username geo 以进行自动邀请",
    'ar': "🚶🏽 أرسل <b>الموقع الجغرافي</b> للحصول على @username الجغرافي للدعوة التلقائية",
}
l_cinvite_csv_table = {
    'ru': "🚶🏽 В csv-файле @username или ссылка должны быть в 3м столбце",
    'en': "🚶🏽 In the csv file @username or link must be in the 3rd column",
    'es': "🚶🏽 En el archivo csv @username o enlace debe estar en la 3ra columna",
    'fr': "🚶🏽 Dans le fichier csv @username ou lien doit être dans la 3ème colonne",
    'zh': "🚶🏽 在 csv 文件中@username或链接必须在第 3 列",
    'ar': "🚶🏽 في ملف csv ، يجب أن يكون @username أو الرابط في العمود الثالث",
}
l_cinvite_csv_file = {
    'ru': "🚶🏽 Пришли корректный текстовый <b>файл</b> со списком @username",
    'en': "🚶🏽 Correct text <b>file</b> with @username list",
    'es': "🚶🏽 <b>Archivo</b> de texto correcto con la lista @username",
    'fr': "🚶🏽 Corriger <b>le fichier</b> texte avec la liste @username",
    'zh': "🚶🏽 使用@username列表更正文本<b>文件</b>",
    'ar': "🚶🏽 تصحيح <b>الملف</b> النصي مع قائمة @username",
}
l_cinvite_src_empty = {
    'ru': "🚶🏽 No @usernames in {0} for {1}",
    'en': "🚶🏽 No @usernames in {0} for {1}",
    'es': "🚶🏽 No hay @usernames en {0} para {1}",
    'fr': "🚶🏽 Pas @usernames dans {0} pour {1}",
    'zh': "🚶🏽 {1} 的 {0} 中没有@usernames",
    'ar': "🚶🏽 لا توجد @usernames في {0} لـ {1}",
}
l_cinvite_choose = {
    'ru': "Выбрать",
    'en': "Choose",
    'es': "Elegir",
    'fr': "Choisir",
    'zh': "选择",
    'ar': "يختار",
}
# endregion


# region csystem_
l_csystem_text = {
    'ru': "👣 <b>Жми</b> на ✅/☑️, чтобы <b>Вкл/Выкл</b> <i>системные</i> сообщения\n\n👉🏼 Например, <i>Пользователь вступил(а) в группу</i>",
    'en': "👣 <b>Click</b> on ✅/☑️ to turn <i>system</i> messages <b>on/off</b>\n\n👉🏼 For example, <i>User joined a group</i>",
    'es': "👣 <b>Haz clic</b> en ✅/☑️ para activar <b>o desactivar</b> los mensajes <i>del sistema</i>\n\n👉🏼 Por ejemplo, <i>el usuario se unió a un grupo</i>",
    'fr': "👣 <b>Cliquez</b> sur ✅/☑️ pour activer <b>/désactiver</b> les messages <i>système</i>\n\n👉🏼 Par exemple, <i>l&#x27;utilisateur a rejoint un groupe</i>",
    'zh': "👣<b>点击</b>✅/☑️ 打开<b>/关闭</b><i>系统</i>消息\n\n👉🏼 例如，<i>用户加入了一个群组</i>",
    'ar': "👣 <b>انقر</b> فوق ✅ / ☑️ لتشغيل <b>/ إيقاف</b> تشغيل رسائل <i>النظام</i>\n\n👉🏼 على سبيل المثال ، <i>انضم المستخدم إلى مجموعة</i>",
}
# endregion


# region cchannel_
l_cchannel_text = {
    'ru': "🫥 <b>Жми</b> на ✅/☑️, чтобы <b>Вкл/Выкл</b> <i>возможность</i> пользователю в группе писать <i>анонимно</i> (от имени <b>его</b> канала)",
    'en': "🫥 <b>Click</b> on ✅/☑️ to <b>enable/disable</b> <i>the ability</i> for a user in a group to write <i>anonymously</i> (on behalf of <b>his</b> channel)",
    'es': "🫥 <b>Haga clic</b> en ✅/☑️ para <b>habilitar/deshabilitar</b> <i>la capacidad</i> de que un usuario en un grupo escriba <i>de forma anónima</i> (en nombre de <b>su</b> canal)",
    'fr': "🫥 <b>Cliquez</b> sur ✅/☑️ pour <b>activer/désactiver</b> <i>la possibilité</i> pour un utilisateur d&#x27;un groupe d&#x27;écrire <i>de manière anonyme</i> (au nom de <b>sa</b> chaîne)",
    'zh': "🫥<b>单击</b>✅/☑️<b>启用/禁用</b>组中用户<i>匿名</i>写作的<i>能力</i>（代表<b>他</b>的频道）",
    'ar': "🫥 <b>انقر</b> فوق ✅ / ☑️ <b>لتمكين / تعطيل</b> <i>قدرة</i> مستخدم في مجموعة على الكتابة <i>بشكل مجهول</i> (نيابة عن <b>قناته</b> )",
}

# endregion


# region clink_
l_clink_text = {
    'ru': "🔗 <b>Жми</b> на ✅/☑️, чтобы <b>Вкл/Выкл</b> <i>внешние <b>ссылки</b>/telegram-<b>ссылки</b>/forward</i>-<b>ссылки</b>\n\n👉🏼 Например, [✅☑Вкл forward-ссылки] означает разрешение на <b>forward-пересылку</b> сообщений из <u>других</u> Telegram-<i>каналов/групп/аккаунтов</i> в <u>нашу</u> группу",
    'en': "🔗 <b>Click</b> on ✅/☑️ to <b>enable/disable</b> <i>external <b>links</b> /telegram- <b>links</b> /forward</i> - <b>links</b>\n\n👉🏼 For example, [✅☑On forward links] means permission to <b>forward</b> messages from <u>other</u> Telegram <i>channels/ groups/accounts</i> to <u>our</u> group",
    'es': "🔗 <b>Haga clic</b> en ✅/☑️ para <b>habilitar/deshabilitar</b> <i><b>enlaces</b> externos/ <b>enlaces</b> de Telegram/</i> <b>enlaces</b> de reenvío\n\n👉🏼 Por ejemplo, [✅☑En enlaces de reenvío] significa permiso para <b>reenviar</b> mensajes de <u>otros</u> <i>canales/grupos/cuentas</i> de Telegram a <u>nuestro</u> grupo",
    'fr': "🔗 <b>Cliquez</b> sur ✅/☑️ pour <b>activer/désactiver</b> <i><b>les liens</b> externes/telegram- <b>links</b> /forward</i> - <b>links</b>\n\n👉🏼 Par exemple, [✅☑On forward links] signifie l&#x27;autorisation de <b>transférer</b> des messages d&#x27; <u>autres</u> <i>chaînes/groupes/comptes</i> Telegram vers <u>notre</u> groupe",
    'zh': "🔗<b>点击</b>✅/☑️<b>启用/禁用</b><i>外部<b>链接</b>/telegram- <b>links</b> /forward-</i> <b>links</b>\n\n👉🏼 例如，[✅☑On forward links] 表示允许将来自<u>其他</u>Telegram<i>频道/组/帐户的</i>消息<b>转发到</b><u>我们</u>组",
    'ar': "🔗 <b>انقر</b> فوق ✅ / ☑️ <b>لتمكين / تعطيل</b> <i><b>الروابط</b> الخارجية / <b>روابط</b> التلغرام / إعادة التوجيه</i> - <b>الروابط</b>\n\n👉🏼 على سبيل المثال ، [✅☑عند توجيه الروابط] يعني الإذن بإعادة <b>توجيه</b> الرسائل من <i>قنوات / مجموعات / حسابات</i> Telegram <u>الأخرى</u> إلى <u>مجموعتنا</u>",
}
l_clink_http_on = {
    'ru': "✅☑Вкл внешние-ссылки",
    'en': "✅☑Include external-links",
    'es': "✅☑Incluir enlaces externos",
    'fr': "✅☑Inclure des liens externes",
    'zh': "✅☑包括外部链接",
    'ar': "✅☑ تضمين روابط خارجية",
}
l_clink_http_off = {
    'ru': "☑️☐Выкл внешние-ссылки",
    'en': "☑️☐Off external-links",
    'es': "☑️☐Fuera de enlaces externos",
    'fr': "☑️☐Hors liens externes",
    'zh': "☑️☐关闭外部链接",
    'ar': "☑️☐ إيقاف الروابط الخارجية",
}
l_clink_telegram_on = {
    'ru': "✅☑Вкл @telegram-ссылки",
    'en': "✅☑On @telegram -links",
    'es': "✅☑En @telegram -enlaces",
    'fr': "✅☑Sur les liens @telegram",
    'zh': "✅☑On @telegram -links",
    'ar': "✅☑On @telegram -الروابط",
}
l_clink_telegram_off = {
    'ru': "☑️☐Выкл @telegram-ссылки",
    'en': "☑️☐Off @telegram -links",
    'es': "☑️☐Desactivado @telegram -enlaces",
    'fr': "☑️☐Off @telegram -liens",
    'zh': "☑️☐关闭@telegram -links",
    'ar': "روابط Off @telegram -links",
}
l_clink_forward_on = {
    'ru': "✅☑Вкл forward-ссылки",
    'en': "✅☑Enable forward links",
    'es': "✅☑Habilitar enlaces hacia adelante",
    'fr': "✅☑Activer les liens vers l'avant",
    'zh': "✅☑启用转发链接",
    'ar': "✅☑ تمكين الروابط الأمامية",
}
l_clink_forward_off = {
    'ru': "☑️☐Выкл forward-ссылки",
    'en': "☑️☐Disable forward links",
    'es': "☑️☐Deshabilitar enlaces de reenvío",
    'fr': "☑️☐Désactiver les liens vers l'avant",
    'zh': "☑️☐禁用转发链接",
    'ar': "☑️☐ تعطيل الروابط الأمامية",
}
# endregion


# region csymbol_
l_csymbol_text = {
    'ru': "文 <b>Жми</b> на ✅/☑️, чтобы <b>Вкл/Выкл</b> <u>авто</u>-бан <i>слов с 文-глиф, ب-араб/ <a href='https://www.zalgo.org'>zalgo-символами</a></i>\n\n👉🏼 Например, опция <b>zalgo-бан</b> удаляет сообщения такого вида <i>h̴̢̝̱̜͓̠̮̪̞͓͚̦͓͆͗̅̎̂͑̃̋͜e̷̡̧͙̹̥͓̣͍̰̮͙̻͍̐͒̒̍̈́̒̎̅̈́ḻ̸̨̢̘̥͛̈́̔̀̇̏̈́̂̎͠l̶̡̡͖͚̥͇͙͈̜̲͚̼̻͇͙̹̔̀̾̾͛͑́̏͆̕͜͝ô̶͍̼͎͈̬̩̩̰̱͙̒͗͐̊̐̐͛̾́͗̈́̚͝͝ͅ</i>",
    'en': "<b>Text</b> to ✅/☑️ to <b>enable/disable</b> <u>auto</u> -ban <i>for words with glyphs, Arabic/</i> <i>zalgo-symbols</i>\n\n👉🏼 For example, the <b>zalgo-ban</b> option removes messages like this <i>̢̥l̶̡̡͖͚̥͇͙͈̜̲͚̼̻͇͙̹̔̀̾̾͛͑́̏͆̕͜͝ô̶̒͗͐͝ ͍̼͎͈̬̩̩̰̱͙̐̐͛̾́͗̈́̚͝͝</i>",
    'es': "Envía <b>un mensaje de texto</b> a ✅/☑️ para <b>activar/desactivar</b> la prohibición <u>automática</u> <i>de palabras con glifos,</i> <i>símbolos árabes/zalgo</i>\n\n👉🏼 Por ejemplo, la opción <b>de prohibición de zalgo</b> elimina mensajes como este <i>̢̥l̶̡̡͖͚̥͇͙͈̜̲͚̼̻͇͙̹̔̀̾̾͛͑́̏͆ ̕͜͝ô̶̒͗͐͝ ͍̼͎͈̬̩̩̰̱͙̐̐͛̾́͗̈́̚͝͝</i>",
    'fr': "<b>Envoyez un SMS</b> à ✅/☑️ pour <b>activer/désactiver</b> l&#x27;interdiction <u>automatique</u> <i>des mots avec des glyphes,</i> <i>des symboles arabes/zalgo</i>\n\n👉🏼 Par exemple, l&#x27;option <b>zalgo-ban</b> supprime les messages comme celui-ci <i>̢̥l̶̡̡͖͚̥͇͙͈̜̲͚̼̻͇͙̹̔̀̾̾͛͑́̏ ͆̕͜͝ô̶̒͗͐͝ ͍̼͎͈̬̩̩̰̱͙̐̐͛̾́͗̈́̚͝͝</i>",
    'zh': "向 ✅/☑️<b>发送文本</b>以<b>启用/禁用</b><i>带有字形、阿拉伯语/</i> <i>zalgo 符号</i>的单词的<u>自动</u>禁止\n\n👉🏼 例如， <b>zalgo-ban</b>选项会删除以下类型的消息<i>：̢̥l̶̡̡͖͚̥͇͙͈̜̲͚̼̻͇͙̹̔̀̾̾͛͑́ ̏͆̕͜͝ô̶͍̼͎͈̬̩̩̰̱͙̒͗͐̐̐͛̾́͗̈́̚͝͝͝</i>",
    'ar': "أرسل <b>رسالة نصية</b> إلى ✅ / ☑️ <b>لتمكين / تعطيل</b> الحظر <u>التلقائي</u> <i>للكلمات ذات الحروف الرسومية والعربية /</i> <i>رموز zalgo</i>\n\n👉🏼 على سبيل المثال ، يزيل خيار <b>zalgo-ban</b> رسائل مثل هذه <i>̢̥l̶̡̡͖͚̥͇͙͈̜̲͚̼̻͇͙̹̔̀̾̾͛͑́̏͆̕͜͝ô̶̒͗͐͝ ͍̼͎͈̬̩̩̰̱͙̐̐͛̾́͗̈́̚͝͝</i>",
}
l_csymbol_symbols_on = {
    'ru': "✅☑Вкл 文ب-бан",
    'en': "✅☑Incl. 文ب-ban",
    'es': "✅☑Incl. 文ب-prohibición",
    'fr': "✅☑Y compris 文ب-interdiction",
    'zh': "✅☑包括文Ho禁令",
    'ar': "✅☑Incl. 文 ب- الحظر",
}
l_csymbol_symbols_off = {
    'ru': "☑️☐Выкл 文ب-бан",
    'en': "☑️☐Выкл 文ب-бан",
    'es': "☑️☐Выкл 文ب-бан",
    'fr': "☑️☐Выкл 文ب-бан",
    'zh': "☑️☐Выкл 文ب-бан",
    'ar': "☑️☐Выкл 文 ب- бан",
}
l_csymbol_zalgo_on = {
    'ru': "✅☑Вкл zalgo-бан",
    'en': "✅☑Incl. pledge-ban",
    'es': "✅☑Incl. prohibición de compromiso",
    'fr': "✅☑Incl.",
    'zh': "✅☑包括质押禁令",
    'ar': "✅☑Incl. تعهد الحظر",
}
l_csymbol_zalgo_off = {
    'ru': "☑️☐Выкл zalgo-бан",
    'en': "☑️☐Vykl pledge-ban",
    'es': "☑️☐ Prohibición de compromiso de Vykl",
    'fr': "☑️☐Vykl pledge-ban",
    'zh': "☑️☐Vykl 质押禁令",
    'ar': "Vykl تعهد الحظر",
}
# endregion


# region cmedia_
l_cmedia_text = {
    'ru': "🗣 <b>Жми</b> на ✅/☑️, чтобы <b>Вкл/Выкл</b> разрешение на <i>media</i>-сообщения\n\n👉🏼 Например, [☑️☐Выкл видео-заметки] означает запрет на <b>видео-заметки в кружочке</b> в нашей группе\n\n👉🏼 Чтобы разрешить/запретить конкретный стикерпак, жми [⚙️Настроить]",
    'en': "🗣 <b>Click</b> on ✅/☑️ to <b>enable/disable</b> permission for <i>media</i> messages\n\n👉🏼 For example, [☑️☐Disable video notes] means no <b>video notes in a circle</b> in our group\n\n👉🏼 To allow/deny a specific sticker pack, press [⚙️Customize]",
    'es': "🗣 <b>Haz clic</b> en ✅/☑️ para <b>habilitar/deshabilitar</b> el permiso para mensajes <i>multimedia</i>\n\n👉🏼 Por ejemplo, [☑️☐Deshabilitar notas de video] significa que no hay <b>notas de video en un círculo</b> en nuestro grupo\n\n👉🏼 Para permitir/denegar un paquete de calcomanías específico, presiona [⚙️Personalizar]",
    'fr': "🗣 <b>Cliquez</b> sur ✅/☑️ pour <b>activer/désactiver</b> l&#x27;autorisation des messages <i>multimédias</i>\n\n👉🏼 Par exemple, [☑️☐Désactiver les notes vidéo] signifie qu&#x27;il n&#x27;y a pas <b>de notes vidéo dans un cercle</b> dans notre groupe\n\n👉🏼 Autoriser/refuser un pack d'autocollants spécifique, appuyez sur [⚙️Personnaliser]",
    'zh': "🗣<b>点击</b>✅/☑️<b>开启/关闭</b><i>媒体</i>消息权限\n\n👉🏼 例如，[☑️☐ 关闭视频笔记] 表示我们群里的<b>圈子里没有视频笔记</b>\n\n👉🏼 允许/拒绝一个特定的贴纸包，按[⚙️Customize]",
    'ar': "🗣 <b>انقر</b> فوق ✅ / ☑️ <b>لتمكين / تعطيل</b> الإذن لرسائل <i>الوسائط</i>\n\n👉🏼 على سبيل المثال ، يعني [☑️☐ تعطيل ملاحظات الفيديو] عدم وجود <b>ملاحظات فيديو في دائرة</b> في مجموعتنا\n\n👉🏼 للسماح / الرفض حزمة ملصقات محددة ، اضغط على [تخصيص]",
}
l_cmedia_photo_on = {
    'ru': "✅☑Вкл photo",
    'en': "✅☑Photo included",
    'es': "✅☑Foto incluida",
    'fr': "✅☑Photo incluse",
    'zh': "✅附照片",
    'ar': "✅☑ الصور المدرجة",
}
l_cmedia_photo_off = {
    'ru': "☑️☐Выкл photo",
    'en': "☑️☐Выкл photo",
    'es': "☑️☐Выкл foto",
    'fr': "☑️☐Выкл photo",
    'zh': "☑️☐Выкл 照片",
    'ar': "صور",
}
l_cmedia_video_on = {
    'ru': "✅☑Вкл video",
    'en': "✅☑On video",
    'es': "✅☑En video",
    'fr': "✅☑En vidéo",
    'zh': "✅☑在视频中",
    'ar': "✅☑ على الفيديو",
}
l_cmedia_video_off = {
    'ru': "☑️☐Выкл video",
    'en': "☑️☐Выкл video",
    'es': "☑️☐Выкл video",
    'fr': "☑️☐Выкл vidéo",
    'zh': "☑️☐Выкл视频",
    'ar': "☑️☐Выкл الفيديو",
}
l_cmedia_giff_on = {
    'ru': "✅☑Вкл giff",
    'en': "✅☑ Turn on",
    'es': "✅☑ Encender",
    'fr': "✅☑ Activer",
    'zh': "✅☑ 开启",
    'ar': "✅☑ تشغيل",
}
l_cmedia_giff_off = {
    'ru': "☑️☐Выкл giff",
    'en': "☑️☐ Turn off",
    'es': "☑️☐ Apagar",
    'fr': "☑️☐ Désactiver",
    'zh': "☑️☐ 关闭",
    'ar': "☑️☐ إيقاف",
}
l_cmedia_audio_on = {
    'ru': "✅☑Вкл audio",
    'en': "✅☑On audio",
    'es': "✅☑En audio",
    'fr': "✅☑Sur le son",
    'zh': "✅☑关于音频",
    'ar': "✅☑ على الصوت",
}
l_cmedia_audio_off = {
    'ru': "☑️☐Выкл audio",
    'en': "☑️☐Выкл audio",
    'es': "☑️☐Выкл audio",
    'fr': "☑️☐Выкл audio",
    'zh': "☑️☐Выкл 音频",
    'ar': "صوت ☑️☐Выкл",
}
l_cmedia_emoji_on = {
    'ru': "✅☑Вкл emoji",
    'en': "✅☑Emoji included",
    'es': "✅☑Emoji incluido",
    'fr': "✅☑Emoji inclus",
    'zh': "✅☑包括表情符号",
    'ar': "✅☑ يتضمن إيموجي",
}
l_cmedia_emoji_off = {
    'ru': "☑️☐Выкл emoji",
    'en': "☑️☐Выкл emoji",
    'es': "Emoji ☑️☐Выкл",
    'fr': "☑️☐Выкл emoji",
    'zh': "☑️☐Выкл 表情符号",
    'ar': "☑️☐Выкл الرموز التعبيرية",
}
l_cmedia_docum_on = {
    'ru': "✅☑Вкл docum",
    'en': "✅☑Docum included",
    'es': "✅☑Docum incluido",
    'fr': "✅☑Docum inclus",
    'zh': "✅☑包括文件",
    'ar': "✅☑ الوثيقة متضمنة",
}
l_cmedia_docum_off = {
    'ru': "☑️☐Выкл docum",
    'en': "☑️☐Выкл docum",
    'es': "☑️☐Выкл docum",
    'fr': "☑️☐Выкл docum",
    'zh': "☑️☐Выкл 文档",
    'ar': "☑️☐Выкл Document",
}
l_cmedia_viabot_on = {
    'ru': "✅☑Вкл via_bot",
    'en': "✅☑Вкл via_bot",
    'es': "✅☑Вкл via_bot",
    'fr': "✅☑Вкл via_bot",
    'zh': "✅☑Вклvia_bot",
    'ar': "✅☑Вкл via_bot",
}
l_cmedia_viabot_off = {
    'ru': "☑️☐Выкл via_bot",
    'en': "☑️☐View via_bot",
    'es': "☑️☐Ver a través de_bot",
    'fr': "☑️☐Voir via_bot",
    'zh': "☑️☐查看via_bot",
    'ar': "☑️☐ مشاهدة عبر_بوت",
}
l_cmedia_poll_on = {
    'ru': "✅☑Вкл опросы",
    'en': "✅☑On polls",
    'es': "✅☑Sobre las encuestas",
    'fr': "✅☑Sur les sondages",
    'zh': "✅☑在民意调查中",
    'ar': "✅☑ في استطلاعات الرأي",
}
l_cmedia_poll_off = {
    'ru': "☑️☐Выкл опросы",
    'en': "☑️☐Off Polls",
    'es': "☑️☐Fuera de encuestas",
    'fr': "☑️☐Hors sondages",
    'zh': "☑️☐关闭民意调查",
    'ar': "☑️☐ خارج استطلاعات الرأي",
}
l_cmedia_sticker_on = {
    'ru': "✅☑Вкл sticker",
    'en': "✅☑ Sticker included",
    'es': "✅☑ Adhesivo incluido",
    'fr': "✅☑ Autocollant inclus",
    'zh': "✅附贴纸",
    'ar': "✅☑ ملصق متضمن",
}
l_cmedia_sticker_off = {
    'ru': "☑️☐Выкл sticker",
    'en': "☑️☐Выкл sticker",
    'es': "☑️☐Выкл pegatina",
    'fr': "☑️☐Выкл autocollant",
    'zh': "☑️☐Выкл贴纸",
    'ar': "ملصق ☑️☐Выкл",
}
l_cmedia_voice_on = {
    'ru': "✅☑Вкл голосовые",
    'en': "✅☑Voice on",
    'es': "✅☑Voz en",
    'fr': "✅☑Voix sur",
    'zh': "✅☑开语音",
    'ar': "✅☑ تشغيل الصوت",
}
l_cmedia_voice_off = {
    'ru': "☑️☐Выкл голосовые",
    'en': "☑️☐Turn off voice",
    'es': "☑️☐Apagar voz",
    'fr': "☑️☐Désactiver la voix",
    'zh': "☑️☐关闭语音",
    'ar': "☑️☐ قم بإيقاف تشغيل الصوت",
}
l_cmedia_videonote_on = {
    'ru': "✅☑Вкл видео-заметки",
    'en': "✅☑Include video notes",
    'es': "✅☑Incluye notas de video",
    'fr': "✅☑Inclure des notes vidéo",
    'zh': "✅☑包括视频笔记",
    'ar': "✅☑ تضمين ملاحظات الفيديو",
}
l_cmedia_videonote_off = {
    'ru': "☑️☐Выкл видео-заметки",
    'en': "☑️☐Off video notes",
    'es': "☑️☐Fuera de notas de video",
    'fr': "☑️☐Hors notes vidéo",
    'zh': "☑️☐关闭视频笔记",
    'ar': "ملاحظات ☑️☐Off الفيديو",
}
l_cmedia_call_photo = {
    'ru': "👮🏽 В настройках [Разрешения] включи опцию:\n\n[✅ Отправка фото и видео]\n\n🕚Подожди 1min",
    'en': "👮🏽 In the [Permissions] settings, enable the option:\n\n[✅ Send photos and videos]\n\n🕚Wait 1min",
    'es': "👮🏽 En la configuración de [Permisos], habilita la opción:\n\n[✅ Enviar fotos y videos]\n\n🕚Espera 1min",
    'fr': "👮🏽 Dans les paramètres [Autorisations], activez l'option :\n\n[✅ Envoyer des photos et des vidéos]\n\n🕚Attendez 1min",
    'zh': "👮🏽 在[权限]设置中，启用选项：\n\n[✅发送照片和视频]\n\n🕚等待1分钟",
    'ar': "👮🏽 في إعدادات [الأذونات] ، قم بتمكين الخيار:\n\n[✅ إرسال الصور ومقاطع الفيديو]\n\n🕚 انتظر لمدة دقيقة",
}
l_cmedia_call_sticker_giff = {
    'ru': "👮🏽 В настройках [Разрешения] включи опцию:\n\n[✅ Отправка стикеров и GIF]\n\n🕚Подожди 1min",
    'en': "👮🏽 In the [Permissions] settings, enable the option:\n\n[✅ Send stickers and GIFs]\n\n🕚Wait 1min",
    'es': "👮🏽 En la configuración de [Permisos], habilita la opción:\n\n[✅ Enviar pegatinas y GIF]\n\n🕚Espera 1 minuto",
    'fr': "👮🏽 Dans les paramètres [Autorisations], activez l'option :\n\n[✅ Envoyer des autocollants et des GIF]\n\n🕚Attendez 1min",
    'zh': "👮🏽 在[权限]设置中，启用选项：\n\n[✅发送贴纸和GIF]\n\n🕚等待1分钟",
    'ar': "👮🏽 في إعدادات [الأذونات] ، قم بتمكين الخيار:\n\n[✅ إرسال ملصقات وصور GIF]\n\n🕚 انتظر دقيقة واحدة",
}
l_cmedia_call_poll = {
    'ru': "👮🏽 В настройках [Разрешения] включи опцию:\n\n[✅ Отправка опросов]\n\n🕚Подожди 1min",
    'en': "👮🏽 In the [Permissions] settings, enable the option:\n\n[✅ Send surveys]\n\n🕚Wait 1min",
    'es': "👮🏽 En la configuración de [Permisos], habilita la opción:\n\n[✅ Enviar encuestas]\n\n🕚Espera 1min",
    'fr': "👮🏽 Dans les paramètres [Autorisations], activez l'option :\n\n[✅ Envoyer des sondages]\n\n🕚Attendez 1min",
    'zh': "👮🏽 在[权限]设置中，启用选项：\n\n[✅发送调查]\n\n🕚等待1分钟",
    'ar': "👮🏽 في إعدادات [الأذونات] ، قم بتمكين الخيار:\n\n[✅ إرسال استطلاعات الرأي]\n\n🕚 انتظر دقيقة واحدة",
}
l_cstickerconfig_text = {
    'ru': "🦊 <b>Исключения</b> для стикерпаков в {0}-файле:\n\n+ Разрешенные: <u>{1}</u>\n- Запрещенные: <u>{2}</u>\n\n[✅ Разрешить] пропускает указанные стикерпаки <i>в качестве исключения</i>, когда выбрана опция [☑️☐Выкл sticker]\n\n[🚫 Запретить] запрещает указанные стикерпаки <i>в качестве исключения</i>, когда выбрана опция [✅☑Вкл sticker]",
    'en': "🦊 <b>Exclusions</b> for sticker packs in {0} -file:\n\n+ Allowed: <u>{1}</u>\n- Forbidden: <u>{2}</u>\n\n[✅ Allow] skips specified sticker packs <i>as an exception</i> when [☑️☐Off] is selected sticker]\n\n[🚫 Disable] disables the specified sticker packs <i>as an exception</i> when [✅☑Enable sticker] is selected",
    'es': "🦊 <b>Exclusiones</b> para paquetes de pegatinas en {0} -archivo:\n\n+ Permitido: <u>{1}</u>\n- Prohibido: <u>{2}</u>\n\n[✅ Permitir] omite paquetes de pegatinas especificados <i>como una excepción</i> cuando [☑️☐Desactivado] es la etiqueta seleccionada]\n\n[🚫 Deshabilitar] deshabilita los paquetes de etiquetas especificados <i>como una excepción</i> cuando se selecciona [✅☑Habilitar etiqueta]",
    'fr': "🦊 <b>Exclusions</b> pour les packs d&#x27;autocollants dans {0} -file :\n\n+ Autorisé : <u>{1}</u>\n- Interdit : <u>{2}</u>\n\n[✅ Autoriser] ignore les packs d&#x27;autocollants spécifiés <i>comme exception</i> lorsque [☑️☐Off] est l&#x27;autocollant sélectionné]\n\n[🚫 Désactiver] désactive les packs d&#x27;autocollants spécifiés <i>comme exception</i> lorsque [✅☑Activer l'autocollant] est sélectionné",
    'zh': "🦊 {0}中贴纸包的<b>排除</b>：\n\n+ 允许： <u>{1}</u>\n- 禁止： <u>{2}</u>\n\n[✅ 允许] 跳过指定的贴纸包<i>作为例外</i>[☑️☐关闭]被选中的贴纸]\n\n[🚫禁用]在选择[✅☑启用贴纸]时<i>作为例外</i>禁用指定的贴纸包",
    'ar': "🦊 <b>استثناءات</b> حزم الملصقات في {0} -الملف:\n\n+ المسموح بها: <u>{1}</u>\n- ممنوع: <u>{2}</u>\n\n[✅ السماح] بتخطي حزم الملصقات المحددة <i>كاستثناء</i> عند [☑️☐ إيقاف] هو ملصق محدد]\n\n[تعطيل] يعطل حزم الملصقات المحددة <i>كاستثناء</i> عند تحديد [✅☑ تمكين الملصق]",
}
l_cstickerpack_1 = {
    'ru': "✅ Разрешить",
    'en': "✅ Allow",
    'es': "✅ Permitir",
    'fr': "✅ Autoriser",
    'zh': "✅ 允许",
    'ar': "✅ سماح",
}
l_cstickerpack_0 = {
    'ru': "🚫 Запретить",
    'en': "🚫 Deny",
    'es': "🚫 negar",
    'fr': "🚫 Refuser",
    'zh': "🚫 拒绝",
    'ar': "🚫 رفض",
}
l_coperation_1 = {
    'ru': "✅ Добавить",
    'en': "✅ Add",
    'es': "✅ Agregar",
    'fr': "✅ Ajouter",
    'zh': "✅ 添加",
    'ar': "✅ أضف",
}
l_coperation_0 = {
    'ru': "🚫 Удалить",
    'en': "🚫 Delete",
    'es': "🚫 Eliminar",
    'fr': "🚫 Supprimer",
    'zh': "🚫 删除",
    'ar': "🚫 حذف",
}
l_GROUPP_CSTICKER1_NUM1 = {
    'ru': "🦊 Текущее количество <b>разрешенных</b> стикерпаков в {0}-файле: <u>{1}</u>\n\n<b>Жми</b> на ✅/🚫, чтобы <b>Добавить/Удалить</b> разрешенные стикерпаки",
    'en': "🦊 Current number of <b>allowed</b> sticker packs in {0} -file: <u>{1}</u>\n\n<b>Click</b> on ✅/🚫 to <b>Add/Remove</b> allowed sticker packs",
    'es': "🦊 Número actual de paquetes de calcomanías <b>permitidos</b> en {0} -archivo: <u>{1}</u>\n\n<b>Haga clic</b> en ✅/🚫 para <b>agregar o quitar</b> paquetes de calcomanías permitidos",
    'fr': "🦊 Nombre actuel de packs d'autocollants <b>autorisés</b> dans le fichier {0} : <u>{1}</u>\n\n<b>Cliquez</b> sur ✅/🚫 pour <b>ajouter/supprimer</b> des packs d'autocollants autorisés",
    'zh': "🦊 {0}文件中<b>允许的</b>贴纸包的当前数量： <u>{1}</u>\n\n<b>单击</b>✅/🚫<b>添加/删除</b>允许的贴纸包",
    'ar': "🦊 العدد الحالي لحزم الملصقات <b>المسموح بها</b> في {0} - الملف: <u>{1}</u>\n\n<b>انقر</b> على ✅ / 🚫 لإضافة <b>/ إزالة</b> حزم الملصقات المسموح بها",
}
l_GROUPP_CSTICKER1_NUM0 = {
    'ru': "🦊 Текущее количество <b>разрешенных</b> стикерпаков: <u>{0}</u>\n\n<b>Жми</b> на ✅/🚫, чтобы <b>Добавить/Удалить</b> разрешенные стикерпаки",
    'en': "🦊 Current number of <b>allowed</b> sticker packs: <u>{0}</u>\n\n<b>Click</b> on ✅/🚫 to <b>Add/Remove</b> allowed sticker packs",
    'es': "🦊 Número actual de paquetes de pegatinas <b>permitidos</b> : <u>{0}</u>\n\n<b>Haz clic</b> en ✅/🚫 para <b>agregar o quitar</b> paquetes de pegatinas permitidos",
    'fr': "🦊 Nombre actuel de packs d'autocollants <b>autorisés</b> : <u>{0}</u>\n\n<b>Cliquez</b> sur ✅/🚫 pour <b>ajouter/supprimer</b> des packs d'autocollants autorisés",
    'zh': "🦊 当前<b>允许的</b>贴纸包数量： <u>{0}</u>\n\n<b>点击</b>✅/🚫<b>添加/删除</b>允许的贴纸包",
    'ar': "🦊 العدد الحالي لحزم الملصقات <b>المسموح بها</b> : <u>{0}</u>\n\n<b>انقر</b> فوق ✅ / 🚫 <b>لإضافة / إزالة</b> حزم الملصقات المسموح بها",
}
l_GROUPP_CSTICKER0_NUM1 = {
    'ru': "🦊 Текущее количество <b>запрещенных</b> стикерпаков в {0}-файле: <u>{1}</u>\n\n<b>Жми</b> на ✅/🚫, чтобы <b>Добавить/Удалить</b> запрещенные стикерпаки",
    'en': "🦊 Current number of <b>banned</b> sticker packs in {0} -file: <u>{1}</u>\n\n<b>Click</b> on ✅/🚫 to <b>Add/Remove</b> banned sticker packs",
    'es': "🦊 Número actual de paquetes de pegatinas <b>prohibidos</b> en {0} -archivo: <u>{1}</u>\n\n<b>Haga clic</b> en ✅/🚫 para <b>agregar o quitar</b> paquetes de pegatinas prohibidos",
    'fr': "🦊 Nombre actuel de packs d'autocollants <b>interdits</b> dans le fichier {0} : <u>{1}</u>\n\n<b>Cliquez</b> sur ✅/🚫 pour <b>ajouter/supprimer</b> des packs d'autocollants interdits",
    'zh': "🦊 {0}文件中的当前<b>禁止</b>贴纸包数量： <u>{1}</u>\n\n<b>点击</b>✅/🚫<b>添加/删除</b>禁止贴纸包",
    'ar': "🦊 العدد الحالي لحزم الملصقات <b>المحظورة</b> في {0} - الملف: <u>{1}</u>\n\n<b>انقر</b> على ✅ / 🚫 لإضافة <b>/ إزالة</b> حزم الملصقات المحظورة",
}
l_GROUPP_CSTICKER0_NUM0 = {
    'ru': "🦊 Текущее количество <b>запрещенных</b> стикерпаков: <u>{0}</u>\n\n<b>Жми</b> на ✅/🚫, чтобы <b>Добавить/Удалить</b> запрещенные стикерпаки",
    'en': "🦊 Current number of <b>banned</b> sticker packs: <u>{0}</u>\n\n<b>Click</b> on ✅/🚫 to <b>Add/Remove</b> banned sticker packs",
    'es': "🦊 Número actual de paquetes de pegatinas <b>prohibidos</b> : <u>{0}</u>\n\n<b>Haz clic</b> en ✅/🚫 para <b>agregar o quitar</b> paquetes de pegatinas prohibidos",
    'fr': "🦊 Nombre actuel de packs d'autocollants <b>interdits</b> : <u>{0}</u>\n\n<b>Cliquez</b> sur ✅/🚫 pour <b>ajouter/supprimer</b> des packs d'autocollants interdits",
    'zh': "🦊 当前<b>禁止的</b>贴纸包数量： <u>{0}</u>\n\n<b>点击</b>✅/🚫<b>添加/删除</b>禁止的贴纸包",
    'ar': "🦊 العدد الحالي لحزم الملصقات <b>المحظورة</b> : <u>{0}</u>\n\n<b>انقر</b> فوق ✅ / 🚫 <b>لإضافة / إزالة</b> حزم الملصقات المحظورة",
}
l_cstickeroperation_add = {
    'ru': "\n\n👉🏼 Например, https://t.me/addstickers/HotCherry или HotCherry",
    'en': "\n\n👉🏼 For example, https://t.me/addstickers/HotCherry or HotCherry",
    'es': "\n\n👉🏼 Por ejemplo, https://t.me/addstickers/HotCherry o HotCherry",
    'fr': "\n\n👉🏼 Par exemple, https://t.me/addstickers/HotCherry ou HotCherry",
    'zh': "\n\n👉🏼 例如， https://t.me/addstickers/HotCherry或HotCherry",
    'ar': "\n\n👉🏼 على سبيل المثال ، https://t.me/addstickers/HotCherry أو HotCherry",
}
l_cstickeroperation_isadd = {
    'ru': "✅ Пришли ссылку или имя <b>стикерпака</b>, чтобы <b>добавить</b> его в список разрешенных{0}",
    'en': "✅ Sent a link or <b>sticker pack</b> name to <b>add</b> it to the allowed list{0}",
    'es': "✅ Envió un enlace o nombre <b>de paquete de calcomanías</b> para <b>agregarlo</b> a la lista permitida{0}",
    'fr': "✅ Envoyé un lien ou un nom <b>de pack d&#x27;autocollants</b> pour l&#x27; <b>ajouter</b> à la liste autorisée{0}",
    'zh': "✅ 发送链接或<b>贴纸包</b>名称以将其<b>添加</b>到允许列表{0}",
    'ar': "✅ أرسل رابطًا أو اسم <b>حزمة ملصقات</b> <b>لإضافتها</b> إلى القائمة المسموح بها {0}",
}
l_cstickeroperation_isnotadd = {
    'ru': "🚫 Пришли ссылку или имя <b>стикерпака</b>, чтобы <b>удалить</b> из списка разрешенных{0}",
    'en': "🚫 Sent a link or name <b>of a sticker pack</b> to be <b>removed</b> from the allowed list{0}",
    'es': "🚫 Envió un enlace o nombre <b>de un paquete de pegatinas</b> para <b>eliminarlo</b> de la lista permitida{0}",
    'fr': "🚫 Envoyé un lien ou le nom <b>d&#x27;un pack d&#x27;autocollants</b> à <b>supprimer</b> de la liste autorisée{0}",
    'zh': "🚫 发送了要从允许列表中<b>删除的贴纸包的</b>链接或名称{0}",
    'ar': "🚫 أرسل رابطًا أو اسمًا <b>لحزمة ملصقات</b> <b>لإزالتها</b> من القائمة المسموح بها {0}",
}
l_cstickeroperation_isadd2 = {
    'ru': "✅ Пришли ссылку или имя <b>стикерпака</b>, чтобы <b>добавить</b> его в список запрещенных{0}",
    'en': "✅ Sent a link or name <b>of a sticker pack</b> to <b>add</b> it to the banned list{0}",
    'es': "✅ Envió un enlace o el nombre <b>de un paquete de pegatinas</b> para <b>agregarlo</b> a la lista prohibida{0}",
    'fr': "✅ Envoyé un lien ou le nom <b>d&#x27;un pack d&#x27;autocollants</b> pour l&#x27; <b>ajouter</b> à la liste interdite{0}",
    'zh': "✅ 发送<b>贴纸包的</b>链接或名称以将其<b>添加</b>到禁止列表{0}",
    'ar': "✅ أرسل رابطًا أو اسم <b>حزمة ملصقات</b> <b>لإضافتها</b> إلى القائمة المحظورة {0}",
}
l_cstickeroperation_isnotadd2 = {
    'ru': "🚫 Пришли ссылку или имя <b>стикерпака</b>,  чтобы <b>удалить</b> его из списка запрещенных{0}",
    'en': "🚫 Sent the link or name <b>of the sticker pack</b> to <b>remove</b> it from the banned list{0}",
    'es': "🚫 Envió el enlace o el nombre <b>del paquete de pegatinas</b> para <b>eliminarlo</b> de la lista prohibida{0}",
    'fr': "🚫 Envoyé le lien ou le nom <b>du pack d&#x27;autocollants</b> pour le <b>supprimer</b> de la liste des interdits{0}",
    'zh': "🚫 发送<b>贴纸包的</b>链接或名称以将其从禁止列表中<b>删除</b>{0}",
    'ar': "🚫 أرسل رابط أو اسم <b>حزمة الملصقات</b> <b>لإزالتها</b> من القائمة المحظورة {0}",
}
l_fsm_sticker_add = {
    'ru': "🦊 <b>Готово!</b> <b>Исключения</b> для стикерпаков:\n\n+ Разрешенные: <u>{0}</u>\n- Запрещенные: <u>{1}</u>\n\n[✅ Разрешить] пропускает указанные стикерпаки <i>в качестве исключения</i>, когда выбрана опция [☑️☐Выкл sticker]\n[🚫 Запретить] запрещает указанные стикерпаки <i>в качестве исключения</i>, когда выбрана опция [✅☑Вкл sticker]",
    'en': "🦊 <b>Done!</b> Sticker pack <b>exceptions</b> :\n\n+ Allowed: <u>{0}</u>\n- Forbidden: <u>{1}</u>\n\n[✅ Allow] skips the specified sticker packs <i>as an exception</i> when the [☑️☐Off sticker] option is selected\n[🚫 Deny ] disables the specified sticker packs <i>as an exception</i> when the [✅☑Enable sticker] option is selected",
    'es': "🦊 <b>Listo!</b> <b>Excepciones</b> de paquetes de pegatinas:\n\n+ Permitido: <u>{0}</u>\n- Prohibido: <u>{1}</u>\n\n[✅ Permitir] omite los paquetes de pegatinas especificados <i>como una excepción</i> cuando se selecciona la opción [☑️☐Desactivar pegatina]\n[🚫 Denegar] desactiva los paquetes de adhesivos especificados <i>como una excepción</i> cuando se selecciona la opción [✅☑Activar adhesivo]",
    'fr': "🦊 <b>C&#x27;est fait !</b> <b>Exceptions</b> aux packs d&#x27;autocollants :\n\n+ Autorisé : <u>{0}</u>\n- Interdit : <u>{1}</u>\n\n[✅ Autoriser] ignore les packs d&#x27;autocollants spécifiés <i>comme exception</i> lorsque l&#x27;option [☑️☐Off sticker] est sélectionnée\n[🚫 Refuser] désactive les packs d&#x27;autocollants spécifiés <i>à titre exceptionnel</i> lorsque l'option [✅☑Activer l'autocollant] est sélectionnée",
    'zh': "🦊<b>完成！</b>贴纸包<b>例外</b>：\n\n+ 允许： <u>{0}</u>\n- 禁止： <u>{1}</u>\n\n[✅ 允许] 当选择 [☑️☐ 关闭贴纸] 选项时，跳过指定的贴纸包<i>作为例外</i>\n[🚫 Deny ] 在选择 [✅☑Enable sticker] 选项时将指定的贴纸包<i>作为例外</i>禁用",
    'ar': "🦊 <b>انتهى!</b> <b>استثناءات</b> حزمة الملصقات:\n\n+ المسموح بها: <u>{0}</u>\n- ممنوع: <u>{1}</u>\n\n[✅ Allow] يتخطى حزم الملصقات المحددة <i>كاستثناء</i> عند تحديد الخيار [☑️☐ Off sticker]\nيؤدي [🚫 Deny] إلى تعطيل حزم الملصقات المحددة <i>كاستثناء</i> عند تحديد خيار [تمكين الملصق]",
}
# endregion


# region cstart_
l_cstart_text = {
    'ru': "🚀 <b>Жми</b> на ✅/☑️, чтобы <b>Вкл/Выкл</b> авто-ответ на триггер-сообщения, содержащие конкретные старт-слова\n\n👉🏼 <b>Текущее</b> количество старт-слов <u>{0}</u>",
    'en': "🚀 <b>Press</b> ✅/☑️ to <b>turn on/off</b> auto-reply to trigger messages containing specific start words\n\n👉🏼 <b>Current</b> number of start words <u>{0}</u>",
    'es': "🚀 <b>Presiona</b> ✅/☑️ para <b>activar/desactivar</b> la respuesta automática para activar mensajes que contengan palabras de inicio específicas\n\n👉🏼 Número <b>actual</b> de palabras de inicio <u>{0}</u>",
    'fr': "🚀 <b>Appuyez sur</b> ✅/☑️ pour <b>activer/désactiver</b> la réponse automatique afin de déclencher des messages contenant des mots de départ spécifiques\n\n👉🏼 Nombre <b>actuel</b> de mots de départ <u>{0}</u>",
    'zh': "🚀<b>按</b>✅/☑️<b>打开/关闭</b>自动回复以触发包含特定起始词的消息\n\n👉🏼<b>当前</b>起始词数<u>{0}</u>",
    'ar': "🚀 <b>اضغط على</b> ✅ / ☑️ <b>لتشغيل / إيقاف</b> الرد التلقائي لتشغيل الرسائل التي تحتوي على كلمات بداية محددة\n\n👉🏼 العدد <b>الحالي</b> لكلمات البداية <u>{0}</u>",
}
l_cstart_call = {
    'ru': "🔔 Нужно ⚙️Настроить хотя бы одно старт-слово",
    'en': "🔔 You need to ⚙️Set up at least one start-word",
    'es': "🔔 Necesitas ⚙️Configurar al menos una palabra de inicio",
    'fr': "🔔 Vous devez ⚙️Configurer au moins un mot de départ",
    'zh': "🔔 你需要⚙️设置至少一个起始词",
    'ar': "🔔 تحتاج إلى ⚙️ إعداد كلمة بداية واحدة على الأقل",
}
l_cstartconfig_call = {
    'ru': "🚀 Нужно ⚙️Настроить хотя бы один пост через опцию 🔔Авто-постинг",
    'en': "🚀 You need to ⚙️Set up at least one post via the 🔔Auto-posting option",
    'es': "🚀 Necesitas ⚙️Configurar al menos una publicación a través de la opción 🔔Publicación automática",
    'fr': "🚀 Vous devez ⚙️Configurer au moins une publication via l'option 🔔Publication automatique",
    'zh': "🚀 您需要⚙️通过🔔自动发布选项设置至少一个帖子",
    'ar': "🚀 تحتاج إلى إعداد منشور واحد على الأقل عبر خيار 'النشر التلقائي'",
}
l_cstartconfig_text = {
    'ru': "🚀 <b>Выбери пост</b>, который будет присылаться в ответ на <b>старт</b>-слова и жми [🚀 <b>Использовать</b>] под выбранным постом\n\n👉🏼 Общее количество старт-слов: <u>{0}</u>",
    'en': "🚀 <b>Select the post</b> that will be sent in response to <b>start</b> -words and click [🚀 <b>Use</b>] under the selected post\n\n👉🏼 Total number of start-words: <u>{0}</u>",
    'es': "🚀 <b>Selecciona la publicación</b> que se enviará en respuesta a las palabras <b>iniciales</b> y haz clic en [🚀 <b>Usar</b>] debajo de la publicación seleccionada\n\n👉🏼 Número total de palabras iniciales: <u>{0}</u>",
    'fr': "🚀 <b>Sélectionnez la publication</b> qui sera envoyée en réponse aux mots <b>de départ</b> et cliquez sur [🚀 <b>Utiliser</b>] sous la publication sélectionnée\n\n👉🏼 Nombre total de mots de départ : <u>{0}</u>",
    'zh': "🚀<b>选择要发送的帖子</b>以响应<b>起始</b>词，然后单击所选帖子下的 [🚀<b>使用</b>]\n\n👉🏼 起始词总数： <u>{0}</u>",
    'ar': "🚀 <b>حدد المنشور</b> الذي سيتم إرساله استجابةً لكلمات <b>البدء</b> وانقر فوق [🚀 <b>Use</b>] ضمن المنشور المحدد\n\n👉🏼 إجمالي عدد كلمات البداية: <u>{0}</u>",
}
l_cstartconfig_use = {
    'ru': "🚀 Использовать",
    'en': "🚀 Use",
    'es': "🚀 Uso",
    'fr': "🚀 Utiliser",
    'zh': "🚀 使用",
    'ar': "🚀 استخدم",
}
l_cstartoperation_caption = {
    'ru': "🚀 <b>Текущее</b> количество <i>старт-слов</i> для поста #{0} в {1}-файле: <u>{2}</u>\n\n<b>Жми</b> на ✅/🚫, чтобы <b>Добавить/Удалить</b> старт-слова",
    'en': "🚀 <b>Current</b> number of <i>start words</i> for post #{0} in {1} file: <u>{2}</u>\n\n<b>Click</b> on ✅/🚫 to <b>Add/Remove</b> start words",
    'es': "🚀 Número <b>actual</b> de <i>palabras de inicio</i> para la publicación n.º {0} en el archivo {1} : <u>{2}</u>\n\n<b>Haga clic</b> en ✅/🚫 para <b>agregar o quitar</b> palabras de inicio",
    'fr': "🚀 Nombre <b>actuel</b> de <i>mots de départ</i> pour le message #{0} dans le fichier {1} : <u>{2}</u>\n\n<b>Cliquez</b> sur ✅/🚫 pour <b>ajouter/supprimer</b> des mots de départ",
    'zh': "🚀 {1}文件中帖子 #{0} 的<b>当前</b><i>起始词</i>数： <u>{2}</u>\n\n<b>单击</b>✅/🚫<b>添加/删除</b>起始词",
    'ar': "🚀 العدد <b>الحالي</b> <i>لكلمات البداية</i> للنشر # {0} في ملف {1} : <u>{2}</u>\n\n<b>انقر</b> على ✅ / 🚫 <b>لإضافة / إزالة</b> كلمات البداية",
}
l_cstartoperation_text = {
    'ru': "🚀 <b>Текущее</b> количество <i>старт-слов</i> для поста #{0}: <u>{1}</u>\n\n<b>Жми</b> на ✅/🚫, чтобы <b>Добавить/Удалить</b> старт-слова",
    'en': "🚀 <b>Current</b> number <i>of start words</i> for post #{0}: <u>{1}</u>\n\n<b>Click</b> on ✅/🚫 to <b>Add/Remove</b> start words",
    'es': "🚀 Número <b>actual</b> <i>de palabras de inicio</i> para la publicación n.º {0}: <u>{1}</u>\n\n<b>Haga clic</b> en ✅/🚫 para <b>agregar o quitar</b> palabras de inicio",
    'fr': "🚀 Nombre <b>actuel</b> <i>de mots de départ</i> pour le message #{0} : <u>{1}</u>\n\n<b>Cliquez</b> sur ✅/🚫 pour <b>ajouter/supprimer</b> des mots de départ",
    'zh': "🚀 帖子 #{0} 的<b>当前</b><i>起始词</i>数： <u>{1}</u>\n\n<b>单击</b>✅/🚫<b>添加/删除</b>起始词",
    'ar': "🚀 العدد <b>الحالي</b> <i>لكلمات البداية</i> للنشر # {0}: <u>{1}</u>\n\n<b>انقر</b> على ✅ / 🚫 <b>لإضافة / إزالة</b> كلمات البداية",
}
l_cstartoperation_handler = {
    'ru': "\n\n▪️регистр не важен\n▪️поставь звездочку в конце слова, чтобы учитывать вхождение\n▪️например, если ввести <b>психо*</b>, то авто-постинг сработает на <u>все</u> сообщения, которые <b>содержат</b> данное сочетание: <i>анти<u>психо</u>лог, <u>Психо</u>терапевт..</i>",
    'en': "\n\n▪️case insensitive\n▪️put an asterisk after the word to take into account the occurrence\n▪️for example, if you enter <b>psycho*</b> , then auto-posting will work on <u>all</u> messages that <b>contain</b> this combination: <i>anti- <u>psychologist</u> , <u>Psycho-</u> therapist. .</i>",
    'es': "\n\n▪️sin distinción entre mayúsculas y minúsculas\n▪️ponga un asterisco después de la palabra para tener en cuenta la ocurrencia\n▪️por ejemplo, si ingresa <b>psico*</b> , la publicación automática funcionará en <u>todos</u> los mensajes que <b>contengan</b> esta combinación: <i>anti- <u>psicóloga</u> , <u>psicoterapeuta</u> .</i>",
    'fr': "\n\n▪️insensible à la casse\n▪️mettre un astérisque après le mot pour prendre en compte l'occurrence\n▪️par exemple, si vous entrez <b>psycho*</b> , alors la publication automatique fonctionnera sur <u>tous</u> les messages qui <b>contiennent</b> cette combinaison : <i>anti- <u>psychologue</u> , <u>Psychothérapeute</u> . .</i>",
    'zh': "\n\n▪️不区分大小写\n▪️在单词后加上星号以考虑出现情况\n▪️例如，如果您输入<b>psycho*</b> ，那么自动发布将对<b>包含</b>此组合的<u>所有</u>消息起作用： <i>anti-<u>心理学家</u>，<u>心理</u>治疗师。。</i>",
    'ar': "\n\n▪️ <i>حالة</i> غير حساسة\n▪️ أدخل علامة النجمة بعد الكلمة لمراعاة الحدوث\n▪️ على سبيل المثال ، إذا أدخلت <b>نفسية *</b> ، فسيعمل النشر التلقائي على <u>جميع</u> الرسائل التي <b>تحتوي على</b> هذه المجموعة: <i><u>عالم نفس</u> ومعالج <u>نفسي</u> .</i>",
}
l_cstartoperation_answer = {
    'ru': "🚀 <b>Введи</b> <u>старт-слова</u> <b>через</b> пробелы или разделители, чтобы <i>добавить</i> их в базу{0}",
    'en': "🚀 <b>Enter</b> <u>start words</u> <b>separated by</b> spaces or separators to <i>add</i> them to the base{0}",
    'es': "🚀 <b>Introduce</b> <u>palabras iniciales</u> <b>separadas por</b> espacios o separadores para <i>añadirlas</i> a la base{0}",
    'fr': "🚀 <b>Saisissez</b> <u>des mots de début</u> <b>séparés par</b> des espaces ou des séparateurs pour les <i>ajouter</i> à la base{0}",
    'zh': "🚀<b>输入以空格或分隔符分隔的</b><u>起始词</u>，以将它们<i>添加</i>到基础{0}",
    'ar': "🚀 <b>أدخل</b> <u>كلمات البداية</u> <b>مفصولة</b> بمسافات أو فواصل <i>لإضافتها</i> إلى الأساس {0}",
}
l_cstartoperation_noanswer = {
    'ru': "🚫 <b>Введи</b> <u>старт-слова</u> <b>через</b> пробелы или разделители, чтобы их <i>удалить</i> из базы{0}",
    'en': "🚫 <b>Enter</b> <u>start words</u> <b>separated by</b> spaces or separators to <i>remove</i> them from the database{0}",
    'es': "🚫 <b>Introduce</b> <u>palabras iniciales</u> <b>separadas por</b> espacios o separadores para <i>eliminarlas</i> de la base de datos{0}",
    'fr': "🚫 <b>Saisissez</b> <u>des mots de début</u> <b>séparés par</b> des espaces ou des séparateurs pour les <i>supprimer</i> de la base de données{0}",
    'zh': "🚫<b>输入以空格或分隔符分隔的</b><u>起始词</u>，以将其从数据库中<i>删除</i>{0}",
    'ar': "🚫 <b>أدخل</b> <u>كلمات البداية</u> <b>مفصولة</b> بمسافات أو فواصل <i>لإزالتها</i> من قاعدة البيانات {0}",
}
l_fsm_start_add_caption = {
    'ru': "🚀 <b>Готово!</b> <b>Текущее</b> количество старт-слов для поста #{0} в {1}-файле: <u>{2}</u>",
    'en': "🚀 <b>Done!</b> <b>Current</b> number of start words for post #{0} in {1} -file: <u>{2}</u>",
    'es': "🚀 <b>Listo!</b> Número <b>actual</b> de palabras iniciales para la publicación n.º {0} en {1} -archivo: <u>{2}</u>",
    'fr': "🚀 <b>C&#x27;est fait !</b> Nombre <b>actuel</b> de mots de départ pour le message #{0} dans le fichier {1} : <u>{2}</u>",
    'zh': "🚀<b>完成！</b> {1}文件中帖子#{0} 的<b>当前</b>起始词数： <u>{2}</u>",
    'ar': "🚀 <b>انتهى!</b> العدد <b>الحالي</b> لكلمات البدء للمشاركة # {0} في الملف {1} : <u>{2}</u>",
}
l_fsm_start_add_text = {
    'ru': "🚀 <b>Готово!</b> <b>Текущее</b> количество старт-слов для поста #{0}: <u>{1}</u>",
    'en': "🚀 <b>Done!</b> <b>Current</b> number of start words for post #{0}: <u>{1}</u>",
    'es': "🚀 <b>Listo!</b> Número <b>actual</b> de palabras iniciales para la publicación n.º {0}: <u>{1}</u>",
    'fr': "🚀 <b>C&#x27;est fait !</b> Nombre <b>actuel</b> de mots de départ pour le message #{0} : <u>{1}</u>",
    'zh': "🚀<b>完成！</b>帖子 #{0} 的<b>当前</b>起始词数： <u>{1}</u>",
    'ar': "🚀 <b>انتهى!</b> العدد <b>الحالي</b> لكلمات البدء للمشاركة # {0}: <u>{1}</u>",
}
l_need_start_word = {
    'ru': "f'🚀 Сначала добавь хотя бы одно старт-слово",
    'en': "f'🚀 First add at least one start-word",
    'es': "f'🚀 Primero agrega al menos una palabra de inicio",
    'fr': "f'🚀 Ajoutez d'abord au moins un mot de départ",
    'zh': "f'🚀 首先添加至少一个起始词",
    'ar': "f '🚀 قم أولاً بإضافة كلمة بداية واحدة على الأقل",
}

# endregion


# region cstop_
l_cstop_text = {
    'ru': "🧾 <b>Жми</b> на ✅/☑️, чтобы <b>Вкл/Выкл</b> авто-удаление сообщений, содержащие запрещенные стоп-слова\n\n👉🏼 <b>Текущее</b> количество стоп-слов <u>{0}</u>",
    'en': "🧾 <b>Click</b> on ✅/☑️ to <b>turn on/off</b> auto-delete messages containing banned stop words\n\n👉🏼 <b>Current</b> number of stop words <u>{0}</u>",
    'es': "🧾 <b>Haz clic</b> en ✅/☑️ para <b>activar/desactivar</b> la eliminación automática de mensajes que contienen palabras vacías prohibidas\n\n👉🏼 Número <b>actual</b> de palabras vacías <u>{0}</u>",
    'fr': "🧾 <b>Cliquez</b> sur ✅/☑️ pour <b>activer/désactiver</b> la suppression automatique des messages contenant des mots vides interdits\n\n👉🏼 Nombre <b>actuel</b> de mots vides <u>{0}</u>",
    'zh': "🧾<b>点击</b>✅/☑️<b>打开/关闭</b>自动删除包含禁止停用词的消息\n\n👉🏼<b>当前</b>停用词数量<u>{0}</u>",
    'ar': "🧾 <b>انقر</b> فوق ✅ / ☑️ <b>لتشغيل / إيقاف</b> تشغيل الحذف التلقائي للرسائل التي تحتوي على كلمات إيقاف محظورة\n\n👉🏼 العدد <b>الحالي</b> لكلمات الإيقاف <u>{0}</u>",
}
l_cstop_call = {
    'ru': "🔔 Нужно ⚙️Настроить хотя бы одно стоп-слово",
    'en': "🔔 You must ⚙️Set up at least one stop word",
    'es': "🔔 Debes ⚙️Configurar al menos una palabra vacía",
    'fr': "🔔 Vous devez ⚙️Configurer au moins un mot vide",
    'zh': "🔔 你必须⚙️设置至少一个停用词",
    'ar': "🔔 يجب أن تقوم بإعداد كلمة توقف واحدة على الأقل",
}
l_cstopchange_caption = {
    'ru': "🧾 Текущее количество стоп-слов в {0}-файле: <u>{1}</u>\n\n<b>Жми</b> на ✅/🚫, чтобы <b>Добавить/Удалить</b> стоп-слова",
    'en': "🧾 Current number of stop words in {0} -file: <u>{1}</u>\n\n<b>Click</b> on ✅/🚫 to <b>Add/Remove</b> stop words",
    'es': "🧾 Número actual de palabras vacías en el archivo {0} : <u>{1}</u>\n\n<b>Haga clic</b> en ✅/🚫 para <b>agregar o quitar</b> palabras vacías",
    'fr': "🧾 Nombre actuel de mots vides dans le fichier {0} : <u>{1}</u>\n\n<b>Cliquez</b> sur ✅/🚫 pour <b>ajouter/supprimer</b> des mots vides",
    'zh': "🧾 {0}文件中的当前停用词数： <u>{1}</u>\n\n<b>单击</b>✅/🚫<b>添加/删除</b>停用词",
    'ar': "🧾 العدد الحالي لكلمات الإيقاف في {0} -ملف: <u>{1}</u>\n\n<b>انقر</b> على ✅ / 🚫 <b>لإضافة / إزالة</b> كلمات التوقف",
}
l_cstopchange_text = {
    'ru': "🧾 Текущее количество стоп-слов <u>{0}</u>\n\n<b>Жми</b> на ✅/🚫, чтобы <b>Добавить/Удалить</b> стоп-слова",
    'en': "🧾 Current number of stop words <u>{0}</u>\n\n<b>Click</b> on ✅/🚫 to <b>Add/Remove</b> stop words",
    'es': "🧾 Número actual de palabras vacías <u>{0}</u>\n\n<b>Haga clic</b> en ✅/🚫 para <b>agregar o</b> quitar palabras vacías",
    'fr': "🧾 Nombre actuel de mots vides <u>{0}</u>\n\n<b>Cliquez</b> sur ✅/🚫 pour <b>ajouter/supprimer</b> des mots vides",
    'zh': "🧾 当前停用词数<u>{0}</u>\n\n<b>点击</b>✅/🚫<b>添加/删除</b>停用词",
    'ar': "🧾 العدد الحالي لكلمات التوقف <u>{0}</u>\n\n<b>انقر</b> على ✅ / 🚫 <b>لإضافة / إزالة</b> كلمات التوقف",
}
l_cstopchange_add = {
    'ru': "\n\n▪️регистр не важен\n▪️поставь звездочку в конце слова, чтобы учитывать вхождение\n▪️например, если ввести <b>психо*</b>, то будут удаляться <u>все</u> сообщения, которые <b>содержат</b> данное сочетание: <i>анти<u>психо</u>лог, <u>Психо</u>терапевт..</i>",
    'en': "\n\n▪️case insensitive\n▪️put an asterisk after the word to take into account the occurrence\n▪️for example, if you enter <b>psycho*</b> , then <u>all</u> messages that <b>contain</b> this combination will be deleted: <i>anti <u>-psychologist</u> , <u>Psycho-</u> therapist..</i>",
    'es': "\n\n▪️sin distinción entre mayúsculas y minúsculas\n▪️ponga un asterisco después de la palabra para tener en cuenta la ocurrencia\n▪️por ejemplo, si ingresa <b>psico*</b> , se eliminarán <u>todos</u> los mensajes que <b>contengan</b> esta combinación: <i>anti <u>-psicólogo</u> , <u>psico -</u> terapeuta..</i>",
    'fr': "\n\n▪️insensible à la casse\n▪️mettez un astérisque après le mot pour prendre en compte l'occurrence\n▪️par exemple, si vous saisissez <b>psycho*</b> , alors <u>tous</u> les messages qui <b>contiennent</b> cette combinaison seront supprimés : <i>anti <u>-psychologue</u> , <u>Psycho -</u> thérapeute..</i>",
    'zh': "\n\n▪️不区分大小写\n▪️在单词后加一个星号以考虑出现情况\n▪️例如，如果您输入<b>psycho*</b> ，那么<u>所有</u><b>包含</b>此组合的消息都将被删除： <i>anti <u>-psychologist</u> , <u>Psycho -</u>治疗师..</i>",
    'ar': "\n\n▪️ حالة غير حساسة\n▪️ أدخل علامة النجمة بعد الكلمة لمراعاة الحدوث\n▪️ على سبيل المثال ، إذا أدخلت <b>نفسية *</b> ، فسيتم حذف <u>جميع</u> الرسائل التي <b>تحتوي على</b> هذه المجموعة: <i>معاداة النفس ، <u>وطبيب</u> <u>نفسي</u> <u>-</u> معالج ..</i>",
}
l_cstopchange_answer = {
    'ru': "✅ <b>Введи</b> <u>стоп-слова</u> <b>через</b> пробелы или разделители, чтобы <i>добавить</i> их в базу{0}",
    'en': "✅ <b>Enter</b> <u>stop words</u> <b>separated by</b> spaces or separators to <i>add</i> them to the base{0}",
    'es': "✅ <b>Introduzca</b> <u>palabras vacías</u> <b>separadas por</b> espacios o separadores para <i>añadirlas</i> a la base{0}",
    'fr': "✅ <b>Saisissez</b> <u>des mots vides</u> <b>séparés par</b> des espaces ou des séparateurs pour les <i>ajouter</i> à la base{0}",
    'zh': "✅<b>输入以空格或分隔符分隔的</b><u>停用词</u>，以将它们<i>添加</i>到基础{0}",
    'ar': "✅ <b>أدخل</b> <u>كلمات التوقف</u> <b>مفصولة</b> بمسافات أو فواصل <i>لإضافتها</i> إلى الأساس {0}",
}
l_cstopchange_noanswer = {
    'ru': "🚫 <b>Введи</b> <u>стоп-слова</u> <b>через</b> пробелы или разделители, чтобы их <i>удалить</i> из базы{0}",
    'en': "🚫 <b>Enter</b> <u>stop words</u> <b>separated by</b> spaces or separators to <i>remove</i> them from the database{0}",
    'es': "🚫 <b>Introduce</b> <u>palabras vacías</u> <b>separadas por</b> espacios o separadores para <i>eliminarlas</i> de la base de datos{0}",
    'fr': "🚫 <b>Saisissez</b> <u>des mots vides</u> <b>séparés par</b> des espaces ou des séparateurs pour les <i>supprimer</i> de la base de données{0}",
    'zh': "🚫<b>输入以空格或分隔符分隔的</b><u>停用词</u>以将其从数据库中<i>删除</i>{0}",
    'ar': "🚫 <b>أدخل</b> <u>كلمات التوقف</u> <b>مفصولة</b> بمسافات أو فواصل <i>لإزالتها</i> من قاعدة البيانات {0}",
}
l_fsm_stop_add_caption = {
    'ru': "🧾 <b>Готово!</b> <b>Текущее</b> количество стоп-слов в {0}-файле: <u>{1}</u>",
    'en': "🧾 <b>Done!</b> <b>Current</b> number of stop words in {0} -file: <u>{1}</u>",
    'es': "🧾 <b>Listo!</b> Número <b>actual</b> de palabras vacías en {0} -archivo: <u>{1}</u>",
    'fr': "🧾 <b>C&#x27;est fait !</b> Nombre <b>actuel</b> de mots vides dans le fichier {0} : <u>{1}</u>",
    'zh': "🧾<b>完成！</b> {0}文件中的<b>当前</b>停用词数： <u>{1}</u>",
    'ar': "🧾 <b>انتهى!</b> العدد <b>الحالي</b> لكلمات التوقف في ملف {0} : <u>{1}</u>",
}
l_fsm_stop_add_text = {
    'ru': "🧾 <b>Готово!</b> <b>Текущее</b> количество стоп-слов <u>{0}</u>",
    'en': "🧾 <b>Done!</b> <b>Current</b> number of stop words <u>{0}</u>",
    'es': "🧾 <b>Listo!</b> Número <b>actual</b> de palabras vacías <u>{0}</u>",
    'fr': "🧾 <b>C&#x27;est fait !</b> Nombre <b>actuel</b> de mots vides <u>{0}</u>",
    'zh': "🧾<b>完成！当前</b>停用词数<u>{0}</u>",
    'ar': "🧾 <b>انتهى!</b> العدد <b>الحالي</b> لكلمات التوقف <u>{0}</u>",
}
# endregion


# region cflood_
l_cflood_text = {
    'ru': "💬 <b>Жми</b> на ✅/☑️, чтобы <b>Вкл/Выкл</b> <i>проверку</i> на частоту подряд написанных сообщ за один промежуток времени\n\n👉🏼 Например, задай количество сообщ подряд, которое будет считаться флудом командой: /flood 5\n\n👉🏼 Или используй <b>медленный режим</b> в настройках группы для <u>1</u> сообщения",
    'en': "💬 <b>Click</b> on ✅/☑️ to <b>turn on/off</b> <i>the check</i> for the frequency of consecutive messages written in one period of time\n\n👉🏼 For example, set the number of messages in a row that will be considered a flood with the command: /flood 5\n\n👉🏼 Or use <b>slow mode</b> in group settings for <u>1</u> message",
    'es': "💬 <b>Haz clic</b> en ✅/☑️ para <b>activar/desactivar</b> <i>la verificación</i> de la frecuencia de mensajes consecutivos escritos en un período de tiempo\n\n👉🏼 Por ejemplo, establece la cantidad de mensajes seguidos que se considerarán una inundación con el comando: /flood 5\n\n👉🏼 O usa <b>el modo lento</b> en la configuración del grupo para <u>1</u> mensaje",
    'fr': "💬 <b>Cliquez</b> sur ✅/☑️ pour <b>activer/désactiver</b> <i>la vérification</i> de la fréquence des messages consécutifs écrits dans une période de temps\n\n👉🏼 Par exemple, définissez le nombre de messages consécutifs qui seront considérés comme une inondation avec le commande : /flood 5\n\n👉🏼 Ou utilisez <b>le mode lent</b> dans les paramètres de groupe pour <u>1</u> message",
    'zh': "💬<b>点击</b>✅/☑️<b>开启/关闭</b><i>检查</i>一段时间内连续写入消息的频率\n\n👉🏼 例如，设置连续消息的数量将被视为洪水命令： /flood 5\n\n👉🏼 或者在组设置中使用<b>慢速模式</b>发送<u>1 条</u>消息",
    'ar': "💬 <b>انقر</b> فوق ✅ / ☑️ لتشغيل <b>/ إيقاف تشغيل</b> <i>التحقق</i> من تكرار الرسائل المتتالية المكتوبة في فترة زمنية واحدة\n\n👉🏼 على سبيل المثال ، قم بتعيين عدد الرسائل في الصف الذي سيتم اعتباره فيضانًا مع الأمر: /flood 5\n\n👉🏼 أو استخدم <b>الوضع البطيء</b> في إعدادات المجموعة لرسالة <u>واحدة</u>",
}
l_cflood_count_on = {
    'ru': "✅☑Вкл {0} сообщ",
    'en': "✅☑On {0} messages",
    'es': "✅☑En {0} mensajes",
    'fr': "✅☑Sur {0} messages",
    'zh': "✅☑关于 {0} 条消息",
    'ar': "✅☑على {0} رسائل",
}
l_cflood_count_off = {
    'ru': "☑️☐Выкл {0} сообщ",
    'en': "☑️☐Off {0} messages",
    'es': "☑️☐Desactivado {0} mensajes",
    'fr': "☑️☐Désactiver {0} messages",
    'zh': "☑️☐关闭 {0} 条消息",
    'ar': "☑️☐ إيقاف {0} الرسائل",
}
# endregion


# region cuser_
l_cuser_text = {
    'ru': "👥 <b>Жми</b> на ✅/☑️, чтобы <b>Вкл/Выкл</b> первичную <i>задержку/свободный вход без входного контроля для premium-аккаунтов/разрешение на инвайт</i> пользователей/ботов в группу или разрешение на <i>редактирование</i> сообщений\n\n👉🏼 Например, <b>задержка</b> (<i>в мин</i>) для <u>новых</u> пользователей (перед написанием их <u>1</u>го сообщ) осуществляется командой: /delay  {0}",
    'en': "👥 <b>Click</b> on ✅/☑️ to <b>enable/disable</b> initial <i>delay/free entry without input control for premium accounts/permission to invite</i> users/bots to the group or permission to <i>edit</i> messages\n\n👉🏼 For example, <b>delay</b> ( <i>in min</i> ) for <u>new</u> users (before writing their <u>1st</u> message) is done with the command: /delay {0}",
    'es': "👥 <b>Haz clic</b> en ✅/☑️ para <b>activar/desactivar</b> <i>el retraso inicial/entrada gratuita sin control de entrada para cuentas premium/permiso para invitar</i> usuarios/bots al grupo o permiso para <i>editar</i> mensajes\n\n👉🏼 Por ejemplo, <b>retraso</b> ( <i>en minutos</i> ) para <u>nuevos</u> usuarios (antes de escribir su <u>primer</u> mensaje) se hace con el comando: /delay {0}",
    'fr': "👥 <b>Cliquez</b> sur ✅/☑️ pour <b>activer/désactiver</b> <i>le délai initial/entrée libre sans contrôle de saisie pour les comptes premium/autorisation d&#x27;inviter</i> des utilisateurs/bots dans le groupe ou autorisation de <i>modifier</i> des messages\n\n👉🏼 Par exemple, <b>délai</b> ( <i>en min</i> ) pour <u>les nouveaux</u> utilisateurs (avant d&#x27;écrire leur <u>1er</u> message) se fait avec la commande : /delay {0}",
    'zh': "👥<b>点击</b>✅/☑️<b>启用/禁用</b>初始<i>延迟/免费进入高级帐户没有输入控制/允许邀请</i>用户/机器人加入组或允许<i>编辑</i>消息\n\n👉🏼 例如，<b>延迟</b>（<i>以分钟为单位</i>）对于<u>新</u>用户（在写他们的<u>第一条</u>消息之前）是用命令完成的： /delay {0}",
    'ar': "👥 <b>انقر</b> فوق ✅ / ☑️ <b>لتمكين / تعطيل</b> <i>التأخير الأولي / الإدخال المجاني بدون التحكم في الإدخال للحسابات المتميزة / إذن لدعوة</i> المستخدمين / الروبوتات إلى المجموعة أو الإذن <i>لتحرير</i> الرسائل\n\n👉🏼 على سبيل المثال ، <b>تأخير</b> ( <i>بالدقائق</i> ) للمستخدمين <u>الجدد</u> (قبل كتابة رسالتهم <u>الأولى</u> ) يتم باستخدام الأمر: /delay {0}",
}
l_cuser_call = {
    'ru': "👮🏽 В настройках [Разрешения] включи опцию:\n\n[✅ Добавление участ]\n\n🕚Подожди 1min",
    'en': "👮🏽 In the [Permissions] settings, enable the option:\n\n[✅ Adding a part]\n\n🕚Wait 1min",
    'es': "👮🏽 En la configuración de [Permisos], habilita la opción:\n\n[✅ Agregar una parte]\n\n🕚Espera 1 minuto",
    'fr': "👮🏽 Dans les paramètres [Autorisations], activez l'option :\n\n[✅ Ajout d'une pièce]\n\n🕚Attendez 1min",
    'zh': "👮🏽 在[权限]设置中，启用选项：\n\n[✅添加零件]\n\n🕚等待1分钟",
    'ar': "👮🏽 في إعدادات [الأذونات] ، قم بتمكين الخيار:\n\n[✅ إضافة جزء]\n\n🕚 انتظر دقيقة واحدة",
}
l_cuser_delay_on = {
    'ru': "✅☑Вкл задержку {0}min",
    'en': "✅☑Enable delay {0}min",
    'es': "✅☑Habilitar retraso {0}min",
    'fr': "✅☑Activer le délai {0}min",
    'zh': "✅☑启用延迟{0}分钟",
    'ar': "✅☑ تمكين التأخير {0} دقيقة",
}
l_cuser_delay_off = {
    'ru': "☑️☐Выкл задержку {0}min",
    'en': "☑️☐Turn off delay {0}min",
    'es': "☑️☐Retardo de apagado {0}min",
    'fr': "☑️☐Désactiver le délai {0}min",
    'zh': "☑️☐关闭延迟{0}分钟",
    'ar': "☑️☐إيقاف التأخير {0} دقيقة",
}
l_cuser_invite_user_on = {
    'ru': "✅☑Вкл инвайт польз.",
    'en': "✅☑Enable user invite",
    'es': "✅☑Habilitar invitación de usuario",
    'fr': "✅☑Activer l'invitation de l'utilisateur",
    'zh': "✅☑启用用户邀请",
    'ar': "✅☑ تمكين دعوة المستخدم",
}
l_cuser_invite_user_off = {
    'ru': "☑️☐Выкл инвайт польз.",
    'en': "☑️☐Disable user invite.",
    'es': "☑️☐Desactivar invitación de usuario.",
    'fr': "☑️☐Désactiver l'invitation de l'utilisateur.",
    'zh': "☑️☐禁用用户邀请。",
    'ar': "☑️☐ تعطيل دعوة المستخدم.",
}

l_cuser_invite_bot_on = {
    'ru': "✅☑Вкл инвайт ботов",
    'en': "✅☑On invite bots",
    'es': "✅☑En bots de invitación",
    'fr': "✅☑Sur inviter des bots",
    'zh': "✅☑关于邀请机器人",
    'ar': "✅☑ على دعوة الروبوتات",
}
l_cuser_invite_bot_off = {
    'ru': "☑️☐Выкл инвайт ботов",
    'en': "☑️☐Disable invite bots",
    'es': "☑️☐Desactivar bots de invitación",
    'fr': "☑️☐Désactiver les robots d'invitation",
    'zh': "☑️☐禁用邀请机器人",
    'ar': "☑️☐ تعطيل روبوتات الدعوة",
}
l_cuser_premium_on = {
    'ru': "✅☑Вкл premium-вход",
    'en': "✅☑Includes premium entry",
    'es': "✅☑Incluye entrada premium",
    'fr': "✅☑Comprend une entrée premium",
    'zh': "✅☑包括高级入场券",
    'ar': "✅☑ يشمل الدخول المميز",
}
l_cuser_premium_off = {
    'ru': "☑️☐Выкл premium-вход",
    'en': "☑️☐Off premium-login",
    'es': "☑️☐Desactivado inicio de sesión premium",
    'fr': "☑️☐ Hors connexion premium",
    'zh': "☑️☐关闭高级登录",
    'ar': "☑️☐Off تسجيل الدخول المميز",
}
l_cuser_edit_on = {
    'ru': "✅☑Вкл редактирование сообщ",
    'en': "✅☑On message editing",
    'es': "✅☑Sobre la edición de mensajes",
    'fr': "✅☑Sur l'édition des messages",
    'zh': "✅☑关于消息编辑",
    'ar': "✅☑ في تحرير الرسالة",
}
l_cuser_edit_off = {
    'ru': "☑️☐Выкл редактирование сообщ",
    'en': "☑️☐Off message editing",
    'es': "☑️☐Edición de mensajes desactivados",
    'fr': "☑️☐Éteindre l'édition des messages",
    'zh': "☑️☐关闭消息编辑",
    'ar': "☑️☐ إيقاف تحرير الرسالة",
}
# endregion


# region cadmin_
l_cadmin_text = {
    'ru': "👩🏽‍💻 <b>Жми</b> на ✅/☑️, чтобы <b>Вкл/Выкл</b> <u>admin-доступ</u> (только к /cmd-командам для <i>других</i> администраторов) и <u>god-режим</u> (без ограничений для администраторов)\n\n👉🏼 <b>Текущие администраторы</b>:\n{0}",
    'en': "👩🏽‍💻 <b>Click</b> on ✅/☑️ to <b>enable/disable</b> <u>admin access</u> (only /cmd commands for <i>other</i> admins) and <u>god mode</u> (no restrictions for admins)\n\n👉🏼 <b>Current admins</b> :\n{ 0}",
    'es': "👩🏽‍💻 <b>Haz clic</b> en ✅/☑️ para <b>activar/desactivar</b> <u>el acceso de administrador</u> (solo comandos /cmd para <i>otros</i> administradores) y <u>el modo dios</u> (sin restricciones para administradores)\n\n👉🏼 <b>Administradores actuales</b> :\n{ 0}",
    'fr': "👩🏽‍💻 <b>Cliquez</b> sur ✅/☑️ pour <b>activer/désactiver</b> <u>l&#x27;accès administrateur</u> (uniquement les commandes /cmd pour <i>les autres</i> administrateurs) et <u>le mode Dieu</u> (aucune restriction pour les administrateurs)\n\n👉🏼 <b>Administrateurs actuels</b> :\n{ 0}",
    'zh': "👩🏽‍💻<b>单击</b>✅/☑️ 以<b>启用/禁用</b><u>管理员访问权限</u>（仅对<i>其他</i>管理员执行 /cmd 命令）和<u>上帝模式</u>（对管理员无限制）\n\n👉🏼<b>当前管理员</b>：\n{ 0}",
    'ar': "👩🏽‍💻 <b>انقر</b> فوق ✅ / ☑️ <b>لتمكين / تعطيل</b> <u>وصول المسؤول</u> (أوامر فقط / cmd للمسؤولين <i>الآخرين</i> ) ووضع <u>god</u> (لا توجد قيود للمسؤولين)\n\n👉🏼 <b>المشرفون الحاليون</b> :\n{0}",
}
l_cadmin_admin_on = {
    'ru': "✅☑Вкл admin-доступ",
    'en': "✅☑Enable admin access",
    'es': "✅☑Habilitar acceso de administrador",
    'fr': "✅☑Activer l'accès administrateur",
    'zh': "✅☑启用管理员访问权限",
    'ar': "✅☑ تمكين وصول المسؤول",
}
l_cadmin_admin_off = {
    'ru': "☑️☐Выкл admin-доступ",
    'en': "☑️☐Off admin access",
    'es': "☑️☐Acceso de administrador desactivado",
    'fr': "☑️☐Désactiver l'accès administrateur",
    'zh': "☑️☐关闭管理员权限",
    'ar': "☑️☐ من وصول المسؤول",
}
l_cadmin_god_on = {
    'ru': "✅☑Вкл god-режим",
    'en': "✅☑Inc year-mode",
    'es': "✅☑Inc modo año",
    'fr': "✅☑Inc mode année",
    'zh': "✅☑公司年模式",
    'ar': "✅☑Inc وضع العام",
}
l_cadmin_god_off = {
    'ru': "☑️☐Выкл god-режим",
    'en': "☑️☐Vykl god-mode",
    'es': "☑️☐Vykl modo dios",
    'fr': "☑️☐Vykl mode divin",
    'zh': "☑️☐Vykl 神模式",
    'ar': "☑️☐Vykl وضع الله",
}
# endregion


# region handlers
l_content_types_invite_user_bot = {
    'ru': "🚶🏽 Инвайт @username/@name_bot не разрешены",
    'en': "🚶🏽 @username / @name_bot invites are not allowed",
    'es': "🚶🏽 Las invitaciones @username / @name_bot no están permitidas",
    'fr': "🚶🏽 Les invitations @username / @name_bot ne sont pas autorisées",
    'zh': "🚶🏽 @username / @name_bot邀请是不允许的",
    'ar': "🚶🏽 @username / @name_bot الدعوات غير مسموح بها",
}
l_content_types_invite_user = {
    'ru': "🚶🏽 Инвайт @username не разрешен",
    'en': "🚶🏽 Invite @username not allowed",
    'es': "🚶🏽 Invitar @username no permitido",
    'fr': "🚶🏽 Inviter @username non autorisé",
    'zh': "🚶🏽 不允许邀请@username",
    'ar': "🚶🏽 دعوة @username غير مسموح به",
}
l_content_types_invite_bot = {
    'ru': "🚶🏽 Инвайт @name_bot не разрешен",
    'en': "🚶🏽 Invite @name_bot not allowed",
    'es': "🚶🏽 No se permite invitar a @name_bot",
    'fr': "🚶🏽 Inviter @name_bot non autorisé",
    'zh': "🚶🏽 不允许邀请@name_bot",
    'ar': "🚶🏽 دعوة @name_bot غير مسموح به",
}
l_content_types_button = {
    'ru': "👮🏽 {0}, на<b>Жми</b> на кнопку, чтобы вс︎тупить в группу",
    'en': "👮🏽 {0}, on <b>Press</b> the button to join the group",
    'es': "👮🏽 {0}, en <b>Presiona</b> el botón para unirte al grupo",
    'fr': "👮🏽 {0}, sur <b>Appuyez sur</b> le bouton pour rejoindre le groupe",
    'zh': "👮🏽 {0}, on<b>按下</b>按钮加入群组",
    'ar': "👮🏽 {0} ، <b>اضغط</b> على الزر للانضمام إلى المجموعة",
}
l_content_types_captcha = {
    'ru': "👮🏽 {0}, выбери <i>правильный вариант</i> ответа, чтобы вс︎тупить в группу:\n\n{1}",
    'en': "👮🏽 {0}, choose <i>the correct</i> answer to join the group:\n\n{1}",
    'es': "👮🏽 {0}, elige <i>la respuesta correcta</i> para unirte al grupo:\n\n{1}",
    'fr': "👮🏽 {0}, choisis <i>la bonne</i> réponse pour rejoindre le groupe :\n\n{1}",
    'zh': "👮🏽 {0}，选择<i>正确</i>答案加入群组：\n\n{1}",
    'ar': "👮🏽 {0} ، اختر الإجابة <i>الصحيحة</i> للانضمام إلى المجموعة:\n\n{1}",
}
l_hand_msg_FLOOD_USERNAME = {
    'ru': "💬 Пользователь @{0} изменил <b>name/@username</b>! Возможно, шпион!",
    'en': "💬 User @{0} changed <b>name/</b> <b>@username</b> ! Possibly a spy!",
    'es': "💬 ¡Usuario @{0} cambió <b>de nombre/</b> <b>@username</b> ! ¡Posiblemente un espía!",
    'fr': "💬 L'utilisateur @{0} a changé <b>de nom/</b> <b>@username</b> ! Peut-être un espion !",
    'zh': "💬 用户@{0} 更改了<b>名称/</b> <b>@username</b> ！可能是间谍！",
    'ar': "💬 تم تغيير <b>اسم المستخدم @ {0} /</b> <b>@username</b> ! ربما جاسوس!",
}
l_hand_msg_flood = {
    'ru': "💬 <i>Flood</i>-сообщения",
    'en': "💬 <i>Flood</i> messages",
    'es': "💬 Mensajes <i>de inundación</i>",
    'fr': "💬 Messages <i>d&#x27;inondation</i>",
    'zh': "💬<i>洪水</i>信息",
    'ar': "💬 رسائل <i>الفيضانات</i>",
}
l_hand_msg_via_bot = {
    'ru': "🗣 Сообщения <i>от имени бота</i> не разрешены",
    'en': "🗣 Posting <i>as a bot</i> is not allowed",
    'es': "🗣 No está permitido publicar <i>como bot</i>",
    'fr': "🗣 La publication <i>en tant que bot</i> n'est pas autorisée",
    'zh': "🗣 不允许<i>作为机器人</i>发帖",
    'ar': "🗣 لا يُسمح بالنشر <i>كبوت</i>",
}
l_hand_msg_channel = {
    'ru': "🫥 Сообщения <i>от имени канала</i> не разрешены",
    'en': "🫥 Messages <i>on behalf of the channel</i> are not allowed",
    'es': "🫥 No se permiten mensajes <i>en nombre del canal</i>",
    'fr': "🫥 Les messages <i>au nom de la chaîne</i> ne sont pas autorisés",
    'zh': "🫥 不允许<i>代表频道</i>发消息",
    'ar': "🫥 غير مسموح بالرسائل <i>نيابة عن القناة</i>",
}
l_hand_msg_emoji = {
    'ru': "🗣 Сообщения <i>c emoji</i> не разрешены",
    'en': "🗣 <i>Emoji</i> messages not allowed",
    'es': "🗣 Mensajes <i>emoji</i> no permitidos",
    'fr': "🗣 Messages <i>Emoji</i> non autorisés",
    'zh': "🗣 不允许<i>表情符号</i>消息",
    'ar': "🗣 رسائل <i>الرموز التعبيرية</i> غير مسموح بها",
}
l_hand_msg_http = {
    'ru': "🔗 Сообщения <i>c внешними ссылками</i> не разрешены",
    'en': "🔗 Posts <i>with external links</i> are not allowed",
    'es': "🔗 No se permiten publicaciones <i>con enlaces externos</i>",
    'fr': "🔗 Les publications <i>avec des liens externes</i> ne sont pas autorisées",
    'zh': "🔗 不允许发布<i>带有外部链接的</i>帖子",
    'ar': "🔗 المشاركات <i>ذات الروابط الخارجية</i> غير مسموح بها",
}
l_hand_msg_telegram = {
    'ru': "🔗 Сообщения <i>c telegram-ссылками</i> не разрешены",
    'en': "🔗 Messages <i>with telegram links</i> are not allowed",
    'es': "🔗 No se permiten mensajes <i>con enlaces de Telegram</i>",
    'fr': "🔗 Les messages <i>avec des liens de télégramme</i> ne sont pas autorisés",
    'zh': "🔗 不允许<i>带有电报链接的</i>消息",
    'ar': "🔗 غير مسموح بالرسائل <i>التي تحتوي على روابط برقية</i>",
}
l_hand_msg_forward = {
    'ru': "🔗 Сообщения <i>c forward-ссылками</i> не разрешены",
    'en': "🔗 Posts <i>with forward links</i> are not allowed",
    'es': "🔗 No se permiten publicaciones <i>con enlaces hacia adelante</i>",
    'fr': "🔗 Les publications <i>avec des liens vers l&#x27;avant</i> ne sont pas autorisées",
    'zh': "🔗 不允许发布<i>带有前向链接的</i>帖子",
    'ar': "🔗 المشاركات <i>ذات الروابط الأمامية</i> غير مسموح بها",
}
l_hand_msg_zalgo = {
    'ru': "文 Сообщения <i>c <a href='https://www.zalgo.org'>zalgo-символами</a></i> не разрешены",
    'en': "文 Messages <i>with</i> <i>zalgo characters</i> are not allowed",
    'es': "文 No se permiten mensajes <i>con</i> <i>caracteres en zalgo</i>",
    'fr': "文 Les messages <i>avec</i> <i>des caractères zalgo</i> ne sont pas autorisés",
    'zh': "文 不允许<i>带有zalgo 字符的</i>消息",
    'ar': "文 غير مسموح بالرسائل <i>التي تحتوي على</i> <i>أحرف zalgo</i>",
}
l_hand_msg_symbols = {
    'ru': "文 Сообщения <i>c 文ب-алфавитами</i> не разрешены",
    'en': "文 Messages <i>with 文ب alphabets</i> are not allowed",
    'es': "文 Mensajes <i>con 文ب alfabetos</i> no están permitidos",
    'fr': "文 Les messages <i>avec l&#x27;alphabet 文ب</i> ne sont pas autorisés",
    'zh': "不允许<i>带有 文ب 字母的</i>文 消息",
    'ar': "文 غير مسموح بالرسائل <i>ذات الحروف الهجائية 文 ب</i>",
}
l_hand_msg_stop = {
    'ru': "🧾 Сообщение содержит <i>стоп-слова</i>",
    'en': "🧾 Message contains <i>stop words</i>",
    'es': "🧾 El mensaje contiene <i>palabras vacías</i>",
    'fr': "🧾 Le message contient <i>des mots vides</i>",
    'zh': "🧾 消息包含<i>停用词</i>",
    'ar': "🧾 تحتوي الرسالة على <i>كلمات توقف</i>",
}
l_hand_msg_edit = {
    'ru': "👥 <i>Редактирование</i> сообщений не разрешено",
    'en': "👥 Post <i>editing</i> not allowed",
    'es': "👥 <i>Edición</i> de publicaciones no permitida",
    'fr': "👥 Post- <i>édition</i> non autorisée",
    'zh': "👥 不允许后期<i>编辑</i>",
    'ar': "👥 <i>تحرير</i> المنشور غير مسموح به",
}
l_scheduler_autoinvite_is_over = {
    'ru': "🚶🏽 Закончились пользователи для инвайта в группе {0}",
    'en': "🚶🏽 Run out of users to invite in the group {0}",
    'es': "🚶🏽 Me quedé sin usuarios para invitar en el grupo {0}",
    'fr': "🚶🏽 Plus d'utilisateurs à inviter dans le groupe {0}",
    'zh': "🚶🏽 邀请的用户已用完 {0}",
    'ar': "🚶🏽 نفاد عدد المستخدمين لدعوتهم إلى المجموعة {0}",
}
l_scheduler_autoinvite_success = {
    'ru': "🚶🏽 Успешный инвайт пользователя {0} в группу {1}",
    'en': "🚶🏽 Successful invite of user {0} to group {1}",
    'es': "🚶🏽 Invitación exitosa del usuario {0} al grupo {1}",
    'fr': "🚶🏽 Invitation réussie de l'utilisateur {0} au groupe {1}",
    'zh': "🚶🏽 成功邀请用户 {0} 加入组 {1}",
    'ar': "🚶🏽 دعوة ناجحة من المستخدم {0} للمجموعة {1}",
}
l_hand_msg_photo = {
    'ru': "🗣 Сообщения <i>с фото</i> не разрешены",
    'en': "🗣 <i>Photo</i> posts not allowed",
    'es': "🗣 Publicaciones <i>de fotos</i> no permitidas",
    'fr': "🗣 Publications <i>photo</i> non autorisées",
    'zh': "🗣 不允许发<i>照片</i>",
    'ar': "🗣 منشورات <i>الصور</i> غير مسموح بها",
}
l_hand_msg_video = {
    'ru': "🗣 Сообщения <i>с видео</i> не разрешены",
    'en': "🗣 <i>Video</i> posts are not allowed",
    'es': "🗣 No se permiten publicaciones <i>de video</i>",
    'fr': "🗣 Les publications <i>vidéo</i> ne sont pas autorisées",
    'zh': "🗣 不允许发布<i>视频</i>",
    'ar': "🗣 غير مسموح بمشاركات <i>الفيديو</i>",
}
l_hand_msg_giff = {
    'ru': "🗣 Сообщения <i>с гиф</i> не разрешены",
    'en': "🗣 <i>GIF</i> messages not allowed",
    'es': "🗣 Mensajes <i>GIF</i> no permitidos",
    'fr': "🗣 Messages <i>GIF</i> non autorisés",
    'zh': "🗣 不允许使用<i>GIF</i>消息",
    'ar': "🗣 رسائل <i>GIF</i> غير مسموح بها",
}
l_hand_msg_audio = {
    'ru': "🗣 Сообщения <i>с аудио</i> не разрешены",
    'en': "🗣 Posts <i>with audio</i> not allowed",
    'es': "🗣 Publicaciones <i>con audio</i> no permitidas",
    'fr': "🗣 Messages <i>avec audio</i> non autorisés",
    'zh': "🗣 不允许<i>有音频的</i>帖子",
    'ar': "🗣 المنشورات <i>ذات الصوت</i> غير مسموح بها",
}
l_hand_msg_sticker = {
    'ru': "🗣 Сообщения <i>со стикерами</i> не разрешены",
    'en': "🗣 Messages <i>with stickers</i> are not allowed",
    'es': "🗣 No se permiten mensajes <i>con stickers</i>",
    'fr': "🗣 Les messages <i>avec des autocollants</i> ne sont pas autorisés",
    'zh': "🗣 不允许<i>有贴纸的</i>消息",
    'ar': "🗣 غير مسموح بالرسائل <i>التي تحتوي على ملصقات</i>",
}
l_hand_msg_sticker_ex = {
    'ru': "🗣 Сообщения <i>со стикерами</i> разрешены, но есть исключения",
    'en': "🗣 Messages <i>with stickers</i> are allowed, but there are exceptions",
    'es': "🗣 Se permiten mensajes <i>con stickers</i> , pero hay excepciones",
    'fr': "🗣 Les messages <i>avec des autocollants</i> sont autorisés, mais il y a des exceptions",
    'zh': "🗣允许<i>带贴纸的</i>消息，但也有例外",
    'ar': "🗣 يُسمح بالرسائل <i>التي تحتوي على ملصقات</i> ، ولكن هناك استثناءات",
}
l_hand_msg_docum = {
    'ru': "🗣 Сообщения <i>с документами</i> не разрешены",
    'en': "🗣 Posts <i>with documents</i> not allowed",
    'es': "🗣 Publicaciones <i>con documentos</i> no permitidos",
    'fr': "🗣 Messages <i>avec des documents</i> non autorisés",
    'zh': "🗣 不允许发布<i>带有文件的</i>帖子",
    'ar': "🗣 المنشورات <i>مع الوثائق</i> غير مسموح بها",
}
l_hand_msg_poll = {
    'ru': "🗣 Сообщения <i>с опросами</i> не разрешены",
    'en': "🗣 <i>Poll</i> posts are not allowed",
    'es': "🗣 No se permiten publicaciones <i>de encuestas</i>",
    'fr': "🗣 Les messages <i>de sondage</i> ne sont pas autorisés",
    'zh': "🗣 不允许<i>发表</i>投票",
    'ar': "🗣 مشاركات <i>الاستطلاع</i> غير مسموح بها",
}
l_hand_msg_voice = {
    'ru': "🗣 <i>Голосовые-сообщения не разрешены</i>",
    'en': "🗣 <i>Voice messages not allowed</i>",
    'es': "🗣 <i>Mensajes de voz no permitidos</i>",
    'fr': "🗣 <i>Messages vocaux non autorisés</i>",
    'zh': "🗣<i>不允许语音留言</i>",
    'ar': "🗣 <i>الرسائل الصوتية غير مسموح بها</i>",
}
l_hand_msg_video_note = {
    'ru': "🗣 Сообщения <i>с видео-заметками</i> не разрешены",
    'en': "🗣 Messages <i>with video notes</i> are not allowed",
    'es': "🗣 No se permiten mensajes <i>con notas de video</i>",
    'fr': "🗣 Les messages <i>avec des notes vidéo</i> ne sont pas autorisés",
    'zh': "🗣 不允许<i>带有视频注释的</i>消息",
    'ar': "🗣 غير مسموح بالرسائل <i>مع ملاحظات الفيديو</i>",
}
# endregion

# endregion


# region FereyAIBot
l_ai_btn1 = {
    'ru': "⛰️ Нейросети",
    'en': "⛰️ Neural networks",
    'es': "⛰️ Redes neuronales",
    'fr': "⛰️ Réseaux de neurones",
    'zh': "⛰️ 神经网络",
    'ar': "⛰️ الشبكات العصبية",
}
l_ai_btn2 = {
    'ru': "🌬 Подписка",
    'en': "🌬 Subscription",
    'es': "🌬 Suscripción",
    'fr': "🌬 Abonnement",
    'zh': "🌬订阅",
    'ar': "🌬 الاشتراك",
}
l_ai_welcome = {
    'ru': "🌱 {0}, добро пожаловать в <i>лендинг-бот</i> для генерации контента:\n\n▪️<b>текст/изображение</b>\n▪️<b>анализ @telegram-канала</b>\n▪️<b>распознавание</b> речи\n▪️<b>очистка ⁰истории</b> /start\n\n❗️Регулярно-обновляемый /content",
    'en': "🌱 {0}, welcome to the content генерации <i>landing bot</i> :\n\n▪️ <b>text</b>\n▪️ <b>image</b>\n▪️ <b>analysis of the Telegram channel</b>\n\n❗️ you can also order the development of a chat bot in our studio Ferey",
    'es': "🌱 {0}, bienvenido al <i>bot de aterrizaje</i> генерации de contenido :\n\n▪️ <b>texto</b>\n▪️ <b>imagen</b>\n▪️ <b>análisis del canal de Telegram</b>\n\n❗️ también puedes encargar el desarrollo de un chat bot en nuestro estudio Ferey",
    'fr': "🌱 {0}, bienvenue dans le <i>landing bot</i> генерации de contenu :\n\n▪️ <b>texte</b>\n▪️ <b>image</b>\n▪️ <b>analyse de la chaîne Telegram</b>\n\n❗️ vous pouvez également commander le développement d'un chat bot dans notre studio Ferey",
    'zh': "🌱 {0}，欢迎使用内容генерации<i>登陆机器人</i>：\n\n▪️<b>文字</b>\n▪️<b>图片</b>\n▪️ <b>Telegram 频道分析</b>\n\n❗️ 您也可以在我们的工作室Ferey订购聊天机器人的开发",
    'ar': "🌱 {0} ، مرحبًا بك في <i>روبوت إنشاء</i> генерации :\n\n▪️ <b>نص</b>\n▪️ <b>صورة</b>\n▪️ <b>تحليل قناة Telegram</b>\n\n❗️ يمكنك أيضًا طلب تطوير روبوت محادثة في استوديو Ferey الخاص بنا",
}
l_subscribe_ai = {
    'ru': "👩🏽‍💻 <b>Оформи</b> ежемесячную <i>подписку</i>:\n\n¹ [<b>Все боты</b> и проекты (-<u>5</u>%)]\n² [@{0}-бот]:\n▪️отсутствие <b>режима ожидания</b>\n▪️аналитика постов канала\n(<i>+финансовый потенциал</i>)\n\n👩🏽‍💻 /balance",
    'en': "👩🏽‍💻 <b>Sign up for</b> a monthly\n\n¹ <i>subscription</i> to @{0}-bot [{1} ₽]\n▪️ no ads\n▪️ creative tasks\n² Subscribe to <u>all</u> bots [{2} ₽]",
    'es': "👩🏽‍💻 <b>Regístrese para obtener</b> una\n\n¹ <i>suscripción</i> mensual a @{0}-bot [{1} ₽]\n▪️ sin anuncios\n▪️ tareas creativas\n² Suscríbase a <u>todos</u> los bots [{2} ₽]",
    'fr': "👩🏽‍💻 <b>Inscrivez-vous pour</b> un <i>abonnement</i>\n\n¹ mensuel à @{0}-bot [{1} ₽]\n▪️ pas de publicité\n▪️ tâches créatives\n² Abonnez-vous à <u>tous</u> les bots [{2} ₽]",
    'zh': "👩🏽‍💻<b>注册</b>每月\n\n¹<i>订阅</i>@{0}-bot [{1} ₽]\n▪️ 无广告\n▪️ 创意任务\n² 订阅<u>所有</u>机器人 [{2} ₽]",
    'ar': "👩🏽‍💻 <b>اشترك للحصول على</b> <i>اشتراك</i> شهري\n\n¹ في @ {0} -bot [{1} ₽]\n▪️ بلا إعلانات\n▪️ مهام إبداعية\n² اشترك في <u>جميع</u> برامج التتبُّع [{2} ₽]",
}

l_gen_txt = {
    'ru': "📘 Текст{0}",
    'en': "📘 Text{0}",
    'es': "📘 Texto{0}",
    'fr': "📘 Texte{0}",
    'zh': "📘 文字{0}",
    'ar': "📘 نص {0}",
}
l_gen_img = {
    'ru': "🌌 Образ",
    'en': "🌌 Image",
    'es': "🌌 Imagen",
    'fr': "🌌 Image",
    'zh': "🌌 图片",
    'ar': "🌌 صورة",
}
l_gen_tlg = {
    'ru': "👩🏽‍💻 Анализ @telegram-канала",
    'en': "👩🏽‍💻 Telegram channel analysis",
    'es': "👩🏽‍💻 Análisis de canales de Telegram",
    'fr': "👩🏽‍💻 Analyse des chaînes de télégrammes",
    'zh': "👩🏽‍💻电报频道分析",
    'ar': "👩🏽‍💻 تحليل قناة Telegram",
}
l_generate_main = {
    'ru': "👩🏽‍💻 <b>Выбери режим</b>",
    'en': "👩🏽‍💻 <b>Choose a mode</b>",
    'es': "👩🏽‍💻 <b>Elige un modo</b>",
    'fr': "👩🏽‍💻 <b>Choisissez un mode</b>",
    'zh': "👩🏽‍💻<b>选择模式</b>",
    'ar': "👩🏽‍💻 <b>اختر الوضع</b>",
}
l_generate_prompt = {
    'ru': "👩🏽‍💻 <b>Введи</b> запрос для <b>{0}</b> 👇🏼..",
    'en': "👩🏽‍💻 <b>Enter</b> a query for <b>{0}</b> 👇🏼..",
    'es': "👩🏽‍💻 <b>Ingrese</b> una consulta para <b>{0}</b> 👇🏼..",
    'fr': "👩🏽‍💻 <b>Entrez</b> une requête pour <b>{0}</b> 👇🏼..",
    'zh': "👩🏽‍💻<b>输入</b>查询<b>{0}</b> 👇🏼..",
    'ar': "👩🏽‍💻 <b>أدخل</b> استعلامًا عن <b>{0}</b> 👇🏼 ..",
}
l_generate_chn = {
    'ru': "👩🏽‍💻 <b>Вставь</b> ссылку на @telegram-канал для анализа финансовых показателей",
    'en': "👩🏽‍💻 <b>Insert</b> a link to the Telegram channel to analyze financial performance",
    'es': "👩🏽‍💻 <b>Inserta</b> un enlace al canal de Telegram para analizar el desempeño financiero",
    'fr': "👩🏽‍💻 <b>Insérez</b> un lien vers la chaîne Telegram pour analyser les performances financières",
    'zh': "👩🏽‍💻<b>插入</b>到 Telegram 频道的链接以分析财务绩效",
    'ar': "👩🏽‍💻 <b>أدخل</b> رابطًا إلى قناة Telegram لتحليل الأداء المالي",
}
l_generate_wait = {
    'ru': "👩🏽‍💻 <b>Выбери режим</b> или <b>дождись</b> окончания генерации..",
    'en': "👩🏽‍💻 <b>Choose a mode</b> or <b>wait for</b> the generation to finish..",
    'es': "👩🏽‍💻 <b>Elija un modo</b> o <b>espere a</b> que termine la generación..",
    'fr': "👩🏽‍💻 <b>Choisissez un mode</b> ou <b>attendez la fin de</b> la génération..",
    'zh': "👩🏽‍💻<b>选择一种模式</b>或<b>等待</b>生成完成..",
    'ar': "👩🏽‍💻 <b>اختر وضعًا</b> أو <b>انتظر حتى</b> ينتهي الجيل ..",
}
l_generate_subcribe = {
    'ru': "👩🏽‍💻 Подожди {0}сек или оформи подписку",
    'en': "👩🏽‍💻 Wait {0}sec or subscribe",
    'es': "👩🏽‍💻 Espera {0}segundos o suscríbete",
    'fr': "👩🏽‍💻 Attendez {0}sec ou abonnez-vous",
    'zh': "👩🏽‍💻 等待 {0} 秒或订阅",
    'ar': "👩🏽‍💻 انتظر {0} ثانية أو اشترك",
}
l_generate_subcribe_channel = {
    'ru': "👩🏽‍💻 Оформи подписку, чтобы узнать финансовый потенциал твоего @telegram-канала",
    'en': "👩🏽‍💻 Wait {0}sec or subscribe",
    'es': "👩🏽‍💻 Espera {0}segundos o suscríbete",
    'fr': "👩🏽‍💻 Attendez {0}sec ou abonnez-vous",
    'zh': "👩🏽‍💻 等待 {0} 秒或订阅",
    'ar': "👩🏽‍💻 انتظر {0} ثانية أو اشترك",
}
l_generate_error = {
    'ru': "👩🏽‍💻 <b>Ошибка</b> генерации",
    'en': "👩🏽‍💻 Generation <b>Error</b>",
    'es': "👩🏽‍💻 <b>Error</b> de generación",
    'fr': "👩🏽‍💻 <b>Erreur</b> de génération",
    'zh': "👩🏽‍💻 生成<b>错误</b>",
    'ar': "👩🏽‍💻 <b>خطأ</b> في التوليد",
}
l_generate_errchn = {
    'ru': "👩🏽‍💻 <b>Ошибка</b> доступа к каналу (попробуй позже или сделай канал публичным)",
    'en': "👩🏽‍💻 Channel access <b>error</b> (try later or make the channel public)",
    'es': "👩🏽‍💻 <b>Error</b> de acceso al canal (inténtalo más tarde o haz público el canal)",
    'fr': "👩🏽‍💻 <b>Erreur</b> d'accès à la chaîne (essayez plus tard ou rendez la chaîne publique)",
    'zh': "👩🏽‍💻频道访问<b>错误</b>（稍后再试或公开频道）",
    'ar': "👩🏽‍💻 <b>خطأ</b> في الوصول إلى القناة (حاول لاحقًا أو اجعل القناة عامة)",
}
# endregion


# region FereyFindBot
l_find_btn1 = {
    'ru': "⛰️ Поиск",
    'en': "⛰️ Search",
    'es': "⛰️ Buscar",
    'fr': "⛰️ Rechercher",
    'zh': "⛰️ 搜索",
    'ar': "⛰️ بحث",
}
l_find_btn2 = {
    'ru': "📍 Geo поиск",
    'en': "📍 Geo search",
    'es': "📍 Búsqueda geográfica",
    'fr': "📍 Recherche géographique",
    'zh': "📍地理搜索",
    'ar': "📍 البحث الجغرافي",
}
l_find_btn3 = {
    'ru': "🔔 Уведомления",
    'en': "🔔 Notifications",
    'es': "🔔 Notificaciones",
    'fr': "🔔 Notifications",
    'zh': "🔔 通知",
    'ar': "🔔 الإخطارات",
}
l_find_btn4 = {
    'ru': "🌬 Подписка",
    'en': "🌬 Subscription",
    'es': "🌬 Suscripción",
    'fr': "🌬 Abonnement",
    'zh': "🌬订阅",
    'ar': "🌬 الاشتراك",
}
l_find_welcome = {
    'ru': "🌱 {0}, добро пожаловать в <i>лендинг-бот</i> поиска в <b>Telegram</b>:\n\n▪️<b>top</b> каналы/группы\n▪️<b>vip</b> пользователи/боты\n▪️<b>гео</b> парсинг\n▪️<b>пассивный</b> маркетинг\n\n❗️Регулярно-обновляемый /content",
    'en': "🌱 {0}, welcome to <b>Telegram</b> поиска <i>landing bot</i> :\n\n▪️ <b>top</b> channels/groups\n▪️ <b>vip</b> users/bots\n▪️ <b>geo</b> parsing\n▪️ <b>passive</b> marketing\n\n❗️ you can also order development Telegram promotions in our Ferey studio",
    'es': "🌱 {0}, bienvenido al <i>bot de aterrizaje</i> поиска <b>de Telegram</b> :\n\n▪️ canales/grupos <b>principales</b>\n▪️ usuarios <b>vip</b> /bots\n▪️ análisis <b>geográfico</b>\n▪️ marketing <b>pasivo</b>\n\n❗️ también puedes solicitar promociones de desarrollo de Telegram en nuestro estudio Ferey",
    'fr': "🌱 {0}, bienvenue sur <b>Telegram</b> поиска <i>landing bot</i> :\n\n▪️ <b>meilleurs</b> canaux/groupes\n▪️ utilisateurs/bots <b>vip</b>\n▪️ analyse <b>géographique</b>\n▪️ marketing <b>passif</b>\n\n❗️ vous pouvez également commander des promotions de développement Telegram dans notre atelier de Ferey",
    'zh': "🌱 {0}，欢迎使用<b>Telegram</b> поиска<i>登陆机器人</i>：\n\n▪️<b>热门</b>频道/群组\n▪️ <b>vip</b>用户/机器人\n▪️<b>地理</b>解析\n▪️<b>被动</b>营销\n\n❗️ 您也可以订购开发 Telegram 促销在我们的Ferey工作室",
    'ar': "🌱 {0} ، مرحبًا بك في <i>الروبوت الهبوطي</i> поиска <b>Telegram</b> :\n\n▪️ <b>أفضل</b> القنوات / المجموعات\n▪️ مستخدمين / برامج تتبع <b>لكبار</b> الشخصيات\n▪️ تحليل <b>جغرافي</b>\n▪️ تسويق <b>سلبي</b>\n\n❗️ يمكنك أيضًا طلب ترويجات Telegram للتطوير في استوديو Ferey الخاص بنا",
}
l_subscribe_find = {
    'ru': "👩🏽‍💻 <b>Оформи</b> ежемесячную <i>подписку</i>:\n\n¹ [<b>Все боты</b> и проекты (-<u>5</u>%)]\n² [@{0}-бот]:\n▪️<b>уведомления</b> о ключевых словах\n(<i>ссылка на сообщение</i>)\n▪️<b>увеличение</b> лимитов уведомлений\n(<i>до 10 ключевых слов/групп/каналов</i>)\n▪️<b>приоритетная</b> выдача при поиске\n(<i>выше чем premium/verified</i>)\n\n👩🏽‍💻 /balance",
    'en': "👩🏽‍💻 <b>Sign up for</b> a monthly\n\n¹ <i>subscription</i> to @{0}-bot [{1} ₽]\n▪️ no ads\n▪️ creative tasks\n² Subscribe to <u>all</u> bots [{2} ₽]",
    'es': "👩🏽‍💻 <b>Regístrese para obtener</b> una\n\n¹ <i>suscripción</i> mensual a @{0}-bot [{1} ₽]\n▪️ sin anuncios\n▪️ tareas creativas\n² Suscríbase a <u>todos</u> los bots [{2} ₽]",
    'fr': "👩🏽‍💻 <b>Inscrivez-vous pour</b> un <i>abonnement</i>\n\n¹ mensuel à @{0}-bot [{1} ₽]\n▪️ pas de publicité\n▪️ tâches créatives\n² Abonnez-vous à <u>tous</u> les bots [{2} ₽]",
    'zh': "👩🏽‍💻<b>注册</b>每月\n\n¹<i>订阅</i>@{0}-bot [{1} ₽]\n▪️ 无广告\n▪️ 创意任务\n² 订阅<u>所有</u>机器人 [{2} ₽]",
    'ar': "👩🏽‍💻 <b>اشترك للحصول على</b> <i>اشتراك</i> شهري\n\n¹ في @ {0} -bot [{1} ₽]\n▪️ بلا إعلانات\n▪️ مهام إبداعية\n² اشترك في <u>جميع</u> برامج التتبُّع [{2} ₽]",
}
l_find_bot_text_find = {
    'ru': "👩🏽‍💻 <b>Источник</b>: {0}, ссылка на публикацию: [{1}] (ключевое слово: <u>{2}</u>)",
    'en': "👩🏽‍💻 <b>Источник</b>: {name} нажал на: [{button}] (пост #<u>{post_id}</u>)",
    'es': "👩🏽‍💻 <b>Regístrese para obtener</b> una\n\n¹ <i>suscripción</i> mensual a @{0}-bot [{1} ₽]\n▪️ sin anuncios\n▪️ tareas creativas\n² Suscríbase a <u>todos</u> los bots [{2} ₽]",
    'fr': "👩🏽‍💻 <b>Inscrivez-vous pour</b> un <i>abonnement</i>\n\n¹ mensuel à @{0}-bot [{1} ₽]\n▪️ pas de publicité\n▪️ tâches créatives\n² Abonnez-vous à <u>tous</u> les bots [{2} ₽]",
    'zh': "👩🏽‍💻<b>注册</b>每月\n\n¹<i>订阅</i>@{0}-bot [{1} ₽]\n▪️ 无广告\n▪️ 创意任务\n² 订阅<u>所有</u>机器人 [{2} ₽]",
    'ar': "👩🏽‍💻 <b>اشترك للحصول على</b> <i>اشتراك</i> شهري\n\n¹ في @ {0} -bot [{1} ₽]\n▪️ بلا إعلانات\n▪️ مهام إبداعية\n² اشترك في <u>جميع</u> برامج التتبُّع [{2} ₽]",
}

l_geo_minus = {
    'ru': "-",
    'en': "-",
    'es': "-",
    'fr': "-",
    'zh': "-",
    'ar': "-",
}
l_geo_current = {
    'ru': "📍R: {0}m",
    'en': "📍R: {0}m",
    'es': "📍R: {0}m",
    'fr': "📍R : {0}mois",
    'zh': "📍R：{0}米",
    'ar': "📍R: {0} م",
}
l_geo_plus = {
    'ru': "+",
    'en': "+",
    'es': "+",
    'fr': "+",
    'zh': "+",
    'ar': "+",
}
l_geo_text1 = {
    'ru': "📍 <b>GEO-поиск</b> пользователей\n\n👩🏽‍💻 <b>Жми</b> на -/+, чтобы настроить 📍Radius",
    'en': "📍 <b>Geo-search</b> users by coordinates\n\n👩🏽‍💻 <b>Click</b> on -/+ to adjust 📍Radius",
    'es': "📍 Usuarios <b>de búsqueda geográfica</b> por coordenadas\n\n👩🏽‍💻 <b>Haz clic</b> en -/+ para ajustar el 📍Radio",
    'fr': "📍 <b>Géo-recherche</b> des utilisateurs par coordonnées\n\n👩🏽‍💻 <b>Cliquez</b> sur -/+ pour ajuster 📍Rayon",
    'zh': "📍 按坐标<b>地理搜索</b>用户\n\n👩🏽‍💻<b>点击</b>-/+ 调整📍半径",
    'ar': "📍 <b>البحث الجغرافي</b> للمستخدمين عن طريق الإحداثيات\n\n👩🏽‍💻 <b>انقر</b> فوق - / + لضبط 📍Radius",
}
l_geo_text2 = {
    'ru': "👩🏽‍💻 <b>Прикрепи</b> геопозицию через 📎-меню вложений или <b>Жми</b> на кнопку ниже\n[📍Отправить Geo] 👇🏽",
    'en': "👩🏽‍💻 <b>Attach</b> a location via the 📎 attachment menu or <b>click</b> on the button below\n[📍Send Geo] 👇🏽",
    'es': "👩🏽‍💻 <b>Adjunte</b> una ubicación a través del 📎 menú de archivos adjuntos o <b>haga clic</b> en el botón a continuación\n[📍Send Geo] 👇🏽",
    'fr': "👩🏽‍💻 <b>Joignez</b> un lieu via le 📎 menu de pièces jointes ou <b>cliquez</b> sur le bouton ci-dessous\n[📍Envoyer Géo] 👇🏽",
    'zh': "👩🏽‍💻通过📎附件菜单<b>附加</b>位置或<b>单击</b>下面的按钮\n[📍发送地理信息]👇🏽",
    'ar': "👩🏽‍💻 <b>قم بإرفاق</b> موقع عبر قائمة 📎 المرفقات أو <b>انقر</b> فوق الزر أدناه\n[Send Geo] 👇🏽",
}
l_geo_send = {
    'ru': "📍Отправить Geo",
    'en': "📍Send Geo",
    'es': "📍Enviar Geo",
    'fr': "📍Envoyer Géo",
    'zh': "📍发送地理位置",
    'ar': "📍إرسال جيو",
}
l_geo_start = {
    'ru': "🔎 <b>Начинаем</b> поиск..",
    'en': "🔎 Let's start the search..",
    'es': "🔎 Comencemos la búsqueda..",
    'fr': "🔎 Commençons la recherche..",
    'zh': "🔎 让我们开始搜索..",
    'ar': "🔎 لنبدأ البحث ..",
}
l_geo_no = {
    'ru': "📍 Пользователей (@username) в данной геопозиции не найдено",
    'en': "📍 No users ( @username ) found in this location",
    'es': "📍 No se encontraron usuarios ( @username ) en esta ubicación",
    'fr': "📍 Aucun utilisateur ( @username ) trouvé à cet emplacement",
    'zh': "📍 在此位置找不到用户 ( @username )",
    'ar': "📍 لم يتم العثور على مستخدمين ( @username ) في هذا الموقع",
}
l_geo_finish = {
    'ru': "🔥 <b>Готово!</b> Найдено пользователей: <u>{0}</u>",
    'en': "🔥 <b>Done!</b> Found users: <u>{0}</u>",
    'es': "🔥 <b>Listo!</b> Usuarios encontrados: <u>{0}</u>",
    'fr': "🔥 <b>C&#x27;est fait !</b> Utilisateurs trouvés : <u>{0}</u>",
    'zh': "🔥<b>完成！</b>找到的用户： <u>{0}</u>",
    'ar': "🔥 <b>انتهى!</b> المستخدمون الموجودون: <u>{0}</u>",
}

l_find_add_cmd = {
    'ru': "👩🏽‍💻 <b>Пришли</b> ссылку на канал/группу/пользователя/бота",
    'en': "👩🏽‍💻 <b>Send</b> a link to a channel/group/user/bot",
    'es': "👩🏽‍💻 <b>Enviar</b> un enlace a un canal/grupo/usuario/bot",
    'fr': "👩🏽‍💻 <b>Envoyer</b> un lien vers un canal/groupe/utilisateur/bot",
    'zh': "👩🏽‍💻<b>发送</b>指向频道/组/用户/机器人的链接",
    'ar': "👩🏽‍💻 <b>أرسل</b> رابطًا إلى قناة / مجموعة / مستخدم / روبوت",
}
l_find_err_cmd = {
    'ru': "👩🏽‍💻 <b>Ошибка</b> (вставь корректную ссылку или повтори позже)",
    'en': "👩🏽‍💻 <b>Error</b> (insert correct link or try again later)",
    'es': "👩🏽‍💻 <b>Error</b> (inserta el enlace correcto o vuelve a intentarlo más tarde)",
    'fr': "👩🏽‍💻 <b>Erreur</b> (insérez le lien correct ou réessayez plus tard)",
    'zh': "👩🏽‍💻<b>错误</b>（插入正确的链接或稍后重试）",
    'ar': "👩🏽‍💻 <b>خطأ</b> (أدخل الرابط الصحيح أو حاول مرة أخرى لاحقًا)",
}
l_find_ok_cmd = {
    'ru': "👩🏽‍💻 <b>Ссылка</b> успешно добавлена!",
    'en': "👩🏽‍💻 <b>Link</b> added successfully!",
    'es': "👩🏽‍💻 ¡ <b>Enlace</b> agregado exitosamente!",
    'fr': "👩🏽‍💻 <b>Lien</b> ajouté avec succès !",
    'zh': "👩🏽‍💻<b>链接</b>添加成功！",
    'ar': "👩🏽‍💻 تمت إضافة <b>الرابط</b> بنجاح!",
}
l_find_check = {
    'ru': "🔗 Проверка",
    'en': "🔗 Check",
    'es': "🔗 Comprobar",
    'fr': "🔗 Vérifier",
    'zh': "🔗 检查",
    'ar': "🔗 تحقق",
}

l_find_menu = {
    'ru': "↩ Menu",
    'en': "↩ Menu",
    'es': "↩ Menú",
    'fr': "↩Menu",
    'zh': "↩ 菜单",
    'ar': "↩ القائمة",
}
l_find_text = {
    'ru': "<b>🔎 Сбор целевой аудитории (ЦА)</b>\n\n▪️выгрузка тематических каналов\n▪️выгрузка групп с ЦА\n▪️выгрузка конкурентов по нише\n▪️каталог ботов\n\n<b>Итог:</b> <i>получение <u>горячей</u> ЦА, анализ ЦА конкурентов</i>",
    'en': "<b>🔎 Gathering the target audience (CA)</b>\n\n▪️uploading thematic channels\n▪️uploading leads/chats from the target audience\n▪️uploading competitors by niche\n▪️bot directory\n\n<b>Result:</b> <i>getting <u>a hot target</u> audience, analyzing the target audience of competitors</i>",
    'es': "<b>🔎 Reunir el público objetivo (CA)</b>\n\n▪️cargar canales temáticos\n▪️cargar clientes potenciales/chats del público objetivo\n▪️cargar competidores por nicho\n▪️directorio de bots\n\n<b>Resultado:</b> <i>obtener <u>un público objetivo atractivo</u> , analizando el público objetivo de los competidores</i>",
    'fr': "<b>🔎 Rassembler le public cible (CA)</b>\n\n▪️télécharger des chaînes thématiques\n▪️télécharger des prospects/chats du public cible\n▪️télécharger des concurrents par niche\n▪️répertoire de robots\n\n<b>Résultat :</b> <i>obtenir <u>un public cible chaud</u> , analysant le public cible des concurrents</i>",
    'zh': "<b>🔎 收集目标受众 (CA)</b>\n\n▪️上传主题频道\n▪️从目标受众上传线索/聊天\n▪️按利基上传竞争对手\n▪️bot 目录\n\n<b>结果：</b><i>获得<u>热门目标</u>受众, 分析竞争对手的目标受众</i>",
    'ar': "<b>🔎 تجميع الجمهور المستهدف (CA)</b>\n\n▪️ تحميل القنوات الموضوعية\n▪️ تحميل العملاء المتوقعين / الدردشات من الجمهور المستهدف\n▪️ تحميل المنافسين حسب المجال المناسب\n▪️ الدليل الآلي\n\n<b>النتيجة:</b> <i>الحصول على جمهور <u>مستهدف نشط</u> ، وتحليل الجمهور المستهدف من المنافسين</i>",
}
l_find_category_typing = {
    'ru': "✅ #ввести свои параметры",
    'en': "✅ #ввести your parameters",
    'es': "✅ #ввести sus parámetros",
    'fr': "✅ #ввести vos paramètres",
    'zh': "✅ # #ввести你的参数",
    'ar': "✅ # #ввести المعلمات الخاصة بك",
}
l_find_desc = {
    'ru': "<b>Описание:</b> {0}",
    'en': "<b>Description:</b> {0}",
    'es': "<b>Descripción:</b> {0}",
    'fr': "<b>Descriptif :</b> {0}",
    'zh': "<b>说明：</b> {0}",
    'ar': "<b>الوصف:</b> {0}",
}
l_find_reacts = {
    'ru': "<b>Реакции:</b> {0}",
    'en': "<b>Reactions:</b> {0}",
    'es': "<b>Reacciones:</b> {0}",
    'fr': "<b>Réactions :</b> {0}",
    'zh': "<b>反应：</b> {0}",
    'ar': "<b>التفاعلات:</b> {0}",
}
l_find_send = {
    'ru': "<b>Сообщ/медиа/инлайн/инвайт:</b> {0}/{1}/{2}/{3}",
    'en': "<b>Message/Media/Inline/Invite:</b> {0}/{1}/{2}/{3}",
    'es': "<b>Mensaje/Medios/En línea/Invitación:</b> {0}/{1}/{2}/{3}",
    'fr': "<b>Message/Média/Inline/Invitation :</b> {0}/{1}/{2}/{3}",
    'zh': "<b>消息/媒体/内联/邀请：</b> {0}/{1}/{2}/{3}",
    'ar': "<b>رسالة / وسائط / مضمنة / دعوة:</b> {0} / {1} / {2} / {3}",
}
l_find_bio = {
    'ru': "<b>Био:</b> {0}",
    'en': "<b>Bio:</b> {0}",
    'es': "<b>Biografía:</b> {0}",
    'fr': "<b>Biographie :</b> {0}",
    'zh': "<b>简历：</b> {0}",
    'ar': "<b>السيرة الذاتية:</b> {0}",
}
l_find_about = {
    'ru': "<b>Описание:</b> {0}",
    'en': "<b>Description:</b> {0}",
    'es': "<b>Descripción:</b> {0}",
    'fr': "<b>Descriptif :</b> {0}",
    'zh': "<b>说明：</b> {0}",
    'ar': "<b>الوصف:</b> {0}",
}
l_find_description = {
    'ru': "<b>Подробнее:</b> {0}",
    'en': "<b>Read more:</b> {0}",
    'es': "<b>Leer más:</b> {0}",
    'fr': "<b>En savoir plus :</b> {0}",
    'zh': "<b>阅读更多：</b> {0}",
    'ar': "<b>اقرأ المزيد:</b> {0}",
}
l_find_commands = {
    'ru': "<b>Команды:</b> {0}",
    'en': "<b>Commands:</b> {0}",
    'es': "<b>Comandos:</b> {0}",
    'fr': "<b>Commandes :</b> {0}",
    'zh': "<b>命令：</b> {0}",
    'ar': "<b>الأوامر:</b> {0}",
}

l_find_chn = {
    'ru': "📰 Каналы",
    'en': "📰 Channels",
    'es': "📰 Canales",
    'fr': "📰 Chaînes",
    'zh': "📰频道",
    'ar': "📰 القنوات",
}
l_find_grp = {
    'ru': "📁 Группы",
    'en': "📁 Groups",
    'es': "📁 Grupos",
    'fr': "📁 Groupes",
    'zh': "📁 团体",
    'ar': "📁 المجموعات",
}
l_find_usr = {
    'ru': "🕵️ Конкуренты",
    'en': "🕵️ Competitors",
    'es': "🕵️ Competidores",
    'fr': "🕵️ Concurrents",
    'zh': "🕵️ 参赛者",
    'ar': "🕵️ المنافسون",
}
l_find_bot = {
    'ru': "🫥 Боты",
    'en': "🫥 Tg bots",
    'es': "🫥Tg bots",
    'fr': "🫥 Robots Tg",
    'zh': "🫥 Tg 机器人",
    'ar': "🫥 Tg bots",
}

l_find_chn_choose = {
    'ru': "📰 <b>Выбери категорию</b> для выгрузки каналов",
    'en': "📰 <b>Choose a category</b> for uploading channels",
    'es': "📰 <b>Elige una categoría</b> para subir canales",
    'fr': "📰 <b>Choisissez une catégorie</b> pour télécharger des chaînes",
    'zh': "📰<b>选择上传频道的类别</b>",
    'ar': "📰 <b>اختر فئة</b> لتحميل القنوات",
}
l_find_grp_choose = {
    'ru': "📁 <b>Выбери категорию</b> для выгрузки групп",
    'en': "📁 <b>Choose a category</b> for uploading groups",
    'es': "📁 <b>Elige una categoría</b> para subir grupos",
    'fr': "📁 <b>Choisissez une catégorie</b> pour télécharger des groupes",
    'zh': "📁<b>选择上传群组的类别</b>",
    'ar': "📁 <b>اختر فئة</b> لتحميل المجموعات",
}
l_find_usr_choose = {
    'ru': "🕵️ <b>Выбери категорию</b> для выгрузки пользователей",
    'en': "🕵️ <b>Choose a category</b> to upload users",
    'es': "🕵️ <b>Elige una categoría</b> para subir usuarios",
    'fr': "🕵️ <b>Choisissez une catégorie</b> pour télécharger des utilisateurs",
    'zh': "🕵️<b>选择一个类别</b>上传用户",
    'ar': "🕵️ <b>اختر فئة</b> لتحميل المستخدمين",
}
l_find_bot_choose = {
    'ru': "🥾 <b>Выбери категорию</b> для выгрузки ботов",
    'en': "🥾 <b>Choose a category</b> for uploading bots",
    'es': "🥾 <b>Elija una categoría</b> para cargar bots",
    'fr': "🥾 <b>Choisissez une catégorie</b> pour télécharger des bots",
    'zh': "🥾<b>选择上传机器人的类别</b>",
    'ar': "🥾 <b>اختر فئة</b> لتحميل الروبوتات",
}

l_find_chn_find = {
    'ru': "🔎 Поиск по каналам",
    'en': "🔎 Channel search",
    'es': "🔎 Búsqueda de canales",
    'fr': "🔎 Recherche de chaînes",
    'zh': "🔎 频道搜索",
    'ar': "🔎 قناة البحث",
}
l_find_grp_find = {
    'ru': "🔎 Поиск по группам",
    'en': "🔎 Group search",
    'es': "🔎 Búsqueda de grupos",
    'fr': "🔎 Recherche de groupe",
    'zh': "🔎 群组搜索",
    'ar': "🔎 بحث المجموعة",
}
l_find_usr_find = {
    'ru': "🔎 Поиск по конкурентам",
    'en': "🔎 Search by competitors",
    'es': "🔎 Búsqueda por competidores",
    'fr': "🔎 Recherche par concurrents",
    'zh': "🔎 按竞争对手搜索",
    'ar': "🔎 البحث عن طريق المنافسين",
}
l_find_bot_find = {
    'ru': "🔎 Поиск по ботам",
    'en': "🔎 Search by bots",
    'es': "🔎 Búsqueda por bots",
    'fr': "🔎 Recherche par bots",
    'zh': "🔎 机器人搜索",
    'ar': "🔎 البحث عن طريق الروبوتات",
}

l_find_chn_link = {
    'ru': "🔗 Перейти к каналу",
    'en': "🔗 Go to channel",
    'es': "🔗 Ir al canal",
    'fr': "🔗 Aller à la chaîne",
    'zh': "🔗 前往频道",
    'ar': "🔗 اذهب إلى القناة",
}
l_find_grp_link = {
    'ru': "🔗 Перейти к группе",
    'en': "🔗 Go to group",
    'es': "🔗 Ir al grupo",
    'fr': "🔗 Aller au groupe",
    'zh': "🔗 进群",
    'ar': "🔗 اذهب إلى المجموعة",
}
l_find_usr_link = {
    'ru': "🔗 Перейти к пользователю",
    'en': "🔗 Go to user",
    'es': "🔗 Ir a usuario",
    'fr': "🔗 Aller à l'utilisateur",
    'zh': "🔗 转到用户",
    'ar': "🔗 اذهب إلى المستخدم",
}
l_find_bot_link = {
    'ru': "🔗 Перейти к боту",
    'en': "🔗 Go to bot",
    'es': "🔗 Ir al bot",
    'fr': "🔗 Aller au robot",
    'zh': "🔗 转到机器人",
    'ar': "🔗 اذهب إلى bot",
}

l_find_category_blog = {
    'ru': "#блогер",
    'en': "#blogger",
    'es': "#bloguero",
    'fr': "#blogueur",
    'zh': "#博主",
    'ar': "#مدَّوِن",
}
l_find_category_digit = {
    'ru': "#оцифровка",
    'en': "#digitizer",
    'es': "#digitalizador",
    'fr': "#numériseur",
    'zh': "#数字转换器",
    'ar': "#جهاز التحويل الرقمي",
}
l_find_category_smm = {
    'ru': "#смм",
    'en': "#smm",
    'es': "#mmm",
    'fr': "#nm",
    'zh': "#嗯",
    'ar': "#سم",
}
l_find_category_recruit = {
    'ru': "#рекрут",
    'en': "#recruit",
    'es': "#recluta",
    'fr': "#recruter",
    'zh': "#招募",
    'ar': "#تجنيد",
}
l_find_category_design = {
    'ru': "#дизайн",
    'en': "#design",
    'es': "#diseño",
    'fr': "#conception",
    'zh': "#设计",
    'ar': "#تصميم",
}
l_find_category_coach = {
    'ru': "#коуч",
    'en': "#coach",
    'es': "#entrenador",
    'fr': "#entraîneur",
    'zh': "#教练",
    'ar': "#مدرب",
}
l_find_category_it = {
    'ru': "#ИТ",
    'en': "#DOG",
    'es': "#PERRO",
    'fr': "#CHIEN",
    'zh': "#狗",
    'ar': "#كلب",
}
l_find_category_course = {
    'ru': "#курсы",
    'en': "#courses",
    'es': "#cursos",
    'fr': "#cours",
    'zh': "#培训班",
    'ar': "#الدورات",
}
l_find_category_business = {
    'ru': "#бизнес",
    'en': "#business",
    'es': "#negocio",
    'fr': "#entreprise",
    'zh': "#商业",
    'ar': "#عمل",
}
l_find_category_goods = {
    'ru': "#товарка",
    'en': "#cargo",
    'es': "#carga",
    'fr': "#cargaison",
    'zh': "#货物",
    'ar': "#البضائع",
}
l_find_category_offline = {
    'ru': "#оффлайн",
    'en': "#offline",
    'es': "#desconectado",
    'fr': "#hors ligne",
    'zh': "#离线",
    'ar': "#غير متصل على الانترنت",
}
l_find_category_lawyer = {
    'ru': "#юрист",
    'en': "#lawyer",
    'es': "#abogado",
    'fr': "#avocat",
    'zh': "#律师",
    'ar': "#محامي",
}
l_find_category_verified = {
    'ru': "#верифиц",
    'en': "#verification",
    'es': "#verificación",
    'fr': "#vérification",
    'zh': "#确认",
    'ar': "#تَحَقّق",
}
l_find_category_premium = {
    'ru': "#премиум",
    'en': "#premium",
    'es': "#de primera calidad",
    'fr': "#prime",
    'zh': "#优质的",
    'ar': "#غالي",
}
l_find_category_health = {
    'ru': "#здоровье",
    'en': "#health",
    'es': "#salud",
    'fr': "#santé",
    'zh': "#健康",
    'ar': "#صحة",
}

l_find_category_getting = {
    'ru': "🔎 Выгружаем <b>категорию</b> {0}..\n\n#длительность 0мин",
    'en': "🔎 Upload <b>category</b> {0}..\n\n#duration 0min",
    'es': "🔎 Subir <b>categoría</b> {0}..\n\n#duración 0min",
    'fr': "🔎 <b>Catégorie</b> de téléchargement {0}..\n\n#durée 0min",
    'zh': "🔎 上传<b>类别</b>{0}..\n\n#duration 0min",
    'ar': "🔎 <b>فئة</b> التحميل {0} ..\n\n# المدة 0 دقيقة",
}
l_find_keyword_getting = {
    'ru': "🔎 Выгружаем базу по ключевым словам <i>{0}</i>..\n\n#длительность 1мин",
    'en': "🔎 Unload the database by keywords <i>{0}</i> ..\n\n#duration 1 min",
    'es': "🔎 Descarga la base de datos por palabras clave <i>{0}</i> ..\n\n#duración 1 min",
    'fr': "🔎 Décharger la base de données par mots clés <i>{0}</i> ..\n\n#durée 1 min",
    'zh': "🔎 通过关键字<i>{0}</i>卸载数据库 ..\n\n#duration 1 分钟",
    'ar': "🔎 تفريغ قاعدة البيانات بالكلمات الأساسية <i>{0}</i> ..\n\n# المدة 1 دقيقة",
}
l_find_category_keywords = {
    'ru': "📰 <b>Введи</b> ключевые слова для поиска через пробелы или разделители",
    'en': "📰 <b>Enter</b> keywords to search through spaces or delimiters",
    'es': "📰 <b>Ingrese</b> palabras clave para buscar a través de espacios o delimitadores",
    'fr': "📰 <b>Entrez</b> des mots-clés pour rechercher dans des espaces ou des délimiteurs",
    'zh': "📰<b>输入</b>关键字以通过空格或分隔符进行搜索",
    'ar': "📰 <b>أدخل</b> كلمات أساسية للبحث من خلال المسافات أو المحددات",
}
l_find_reached = {
    'ru': "<b>Охват</b>: <u>{0}</u> польз.",
    'en': "<b>Reach</b> : <u>{0}</u> users",
    'es': "<b>Alcance</b> : <u>{0}</u> usuarios",
    'fr': "<b>Atteignez</b> : <u>{0}</u> utilisateurs",
    'zh': "<b>覆盖</b>： <u>{0}</u>个用户",
    'ar': "<b>الوصول</b> : <u>{0}</u> مستخدمين",
}
l_find_watch = {
    'ru': "🔎 Просмотр",
    'en': "🔎 View",
    'es': "🔎 Ver",
    'fr': "🔎 Voir",
    'zh': "🔎 查看",
    'ar': "🔎 عرض",
}
l_add_join_err = {
    'ru': "👩🏽‍💻 <b>Ошибка</b> (вставь корректную ссылку или повтори позже)",
    'en': "🚫 Failed to add {0} to the database, you need to open free access to join",
    'es': "🚫 No se pudo agregar {0} a la base de datos, debe abrir el acceso gratuito para unirse",
    'fr': "🚫 Échec de l'ajout de {0} à la base de données, vous devez ouvrir un accès gratuit pour rejoindre",
    'zh': "🚫 添加{0}到数据库失败，需要开通免费权限才能加入",
    'ar': "🚫 فشل إضافة {0} إلى قاعدة البيانات ، تحتاج إلى فتح وصول مجاني للانضمام",
}

l_add_chn_fail = {
    'ru': "🚫 <b>Канал</b> {0} не добавлен в базу\n\n{1} аватар\n{2} описание\n{3} более {4} подписчиков\n{5} последний пост менее {6} дней назад",
    'en': "🚫 Channel {0} - not added to the database\n\n{1} avatar\n{2} >100 subscribers\n{3} last post <100 days ago",
    'es': "🚫 Canal {0} - no agregado a la base de datos\n\n{1} avatar\n{2} >100 suscriptores\n{3} última publicación <100 días atrás",
    'fr': "🚫 Chaîne {0} - non ajoutée à la base de données\n\n{1} avatar\n{2} >100 abonnés\n{3} dernier message il y a <100 jours",
    'zh': "🚫 频道 {0} - 未添加到数据库\n\n{1} 头像\n{2} >100 个订阅者\n{3} 上次发布 <100 天前",
    'ar': "🚫 القناة {0} - لم تتم إضافتها إلى قاعدة البيانات\n\n{1} الصورة الرمزية\n{2}> 100 مشترك\n{3} آخر مشاركة قبل أقل من 100 يوم",
}
l_add_grp_fail = {
    'ru': "🚫 <b>Группа</b> {0} не добавлена в базу\n\n{1} аватар\n{2} описание\n{3} более {4} участников\n{5} последний пост менее {6} дней назад",
    'en': "🚫 Group {0} - not added to the database\n\n{1} avatar\n{2} >100 members\n{3} last post <100 days ago",
    'es': "🚫 Grupo {0} - no agregado a la base de datos\n\n{1} avatar\n{2} >100 miembros\n{3} última publicación <100 días atrás",
    'fr': "🚫 Groupe {0} - non ajouté à la base de données\n\n{1} avatar\n{2} >100 membres\n{3} dernier message il y a <100 jours",
    'zh': "🚫 组 {0} - 未添加到数据库\n\n{1} 头像\n{2} >100 名成员\n{3} 上次发帖 <100 天前",
    'ar': "🚫 المجموعة {0} - لم تتم إضافتها إلى قاعدة البيانات\n\n{1} الصورة الرمزية\n{2}> 100 عضو\n{3} آخر مشاركة منذ أقل من 100 يوم",
}
l_add_usr_fail = {
    'ru': "🚫 <b>Пользователь</b> {0} не добавлен в базу\n\n{1} аватар\n{2} @username\n{3} био",
    'en': "🚫 User {0} - not added to database\n\n{1} avatar\n{2} @username\n{3} bio",
    'es': "🚫 Usuario {0}: no agregado a la base de datos\n\n{1} avatar\n{2} @username\n{3} biografía",
    'fr': "🚫 Utilisateur {0} - non ajouté à la base de données\n\n{1} avatar\n{2} @username\n{3} bio",
    'zh': "🚫 用户 {0} - 未添加到数据库\n\n{1} 头像\n{2} @username\n{3} 简介",
    'ar': "🚫 المستخدم {0} - لم تتم إضافته إلى قاعدة البيانات\n\n{1} الصورة الرمزية\n{2} @username\n{3} السيرة الذاتية",
}
l_add_bot_fail = {
    'ru': "🚫 <b>Бот</b> {0} не добавлен в базу\n\n{1} аватар\n{2} описание",
    'en': "🚫 Bot {0} - not added to the database\n\n{1} avatar\n{2} description",
    'es': "🚫 Bot {0} - no agregado a la base de datos\n\n{1} avatar\n{2} descripción",
    'fr': "🚫 Bot {0} - non ajouté à la base de données\n\n{1} description de l'avatar\n{2}",
    'zh': "🚫 机器人 {0} - 未添加到数据库\n\n{1} 头像\n{2} 描述",
    'ar': "🚫 بوت {0} - لم تتم إضافته إلى قاعدة البيانات\n\n{1} الصورة الرمزية\n{2} الوصف",
}

l_add_chn_done = {
    'ru': "✅ <b>Канал</b> {0} - добавлен в базу и обновлен",
    'en': "✅ Channel {0} - added to the database and updated",
    'es': "✅ Canal {0}: agregado a la base de datos y actualizado",
    'fr': "✅ Chaîne {0} - ajoutée à la base de données et mise à jour",
    'zh': "✅ 频道 {0} - 添加到数据库并更新",
    'ar': "✅ القناة {0} - تمت إضافتها إلى قاعدة البيانات وتحديثها",
}
l_add_grp_done = {
    'ru': "✅ <b>Группа</b> {0} - добавлена в базу и обновлена",
    'en': "✅ Group {0} - added to the database and updated",
    'es': "✅ Grupo {0}: agregado a la base de datos y actualizado",
    'fr': "✅ Groupe {0} - ajouté à la base de données et mis à jour",
    'zh': "✅ 组 {0} - 添加到数据库并更新",
    'ar': "✅ المجموعة {0} - تمت إضافتها إلى قاعدة البيانات وتحديثها",
}
l_add_usr_done = {
    'ru': "✅ <b>Пользователь</b> {0} - добавлен в базу и обновлен",
    'en': "✅ User {0} - added to the database and updated",
    'es': "✅ Usuario {0}: agregado a la base de datos y actualizado",
    'fr': "✅ Utilisateur {0} - ajouté à la base de données et mis à jour",
    'zh': "✅ 用户 {0} - 添加到数据库并更新",
    'ar': "✅ المستخدم {0} - تمت إضافته إلى قاعدة البيانات وتحديثها",
}
l_add_bot_done = {
    'ru': "✅ <b>Бот</b> {0} - добавлен в базу и обновлен",
    'en': "✅ Bot {0} - added to the database and updated",
    'es': "✅ Bot {0}: agregado a la base de datos y actualizado",
    'fr': "✅ Bot {0} - ajouté à la base de données et mis à jour",
    'zh': "✅ Bot {0} - 添加到数据库并更新",
    'ar': "✅ بوت {0} - تمت إضافته إلى قاعدة البيانات وتحديثها",
}

l_find_chn_done = {
    'ru': "🔥 <b>Готово!</b> По {0} собрано <u>{1}</u> каналов, сегментированных по <i>ключевым</i> словам\n\n<b>Охват</b>: <u>{2}</u> польз\n\nМожно связаться с администраторами каналов, чтобы заказать рекламу",
    'en': "🔥 <b>Done!</b> {0} collected <u>{1}</u> channels segmented by <i>keywords</i>\n\n<b>Reach</b> : <u>{2}</u> users\n\nYou can contact channel administrators to order advertising",
    'es': "🔥 <b>Listo!</b> {0} recopilaron <u>{1}</u> canales segmentados por <i>palabras clave</i>\n\n<b>Alcance</b> : <u>{2}</u> usuarios\n\nPuede ponerse en contacto con los administradores del canal para solicitar publicidad",
    'fr': "🔥 <b>C&#x27;est fait !</b> {0} a collecté <u>{1}</u> chaînes segmentées par <i>mots-clés</i>\n\n<b>Atteinte</b> : <u>{2}</u> utilisateurs\n\nVous pouvez contacter les administrateurs de chaîne pour commander de la publicité",
    'zh': "🔥<b>完成！</b> {0} 收集了<u>{1} 个</u>按<i>关键字</i>细分的频道\n\n<b>覆盖</b>： <u>{2} 个</u>用户\n\n您可以联系频道管理员订购广告",
    'ar': "🔥 <b>انتهى!</b> القنوات {0} المجمعة <u>{1}</u> المقسمة حسب <i>الكلمات الرئيسية</i>\n\n<b>الوصول إلى</b> : <u>{2}</u> المستخدمين\n\nيمكنك الاتصال بمسؤولي القناة لطلب الإعلانات",
}
l_find_grp_done = {
    'ru': "🔥 <b>Готово!</b> По {0} собрано <u>{1}</u> чатов, сегментированных по <i>ключевым</i> словам\n\n<b>Охват</b>: <u>{2}</u> польз\n\nМожно сделать <b>рассылку</b> по группам",
    'en': "🔥 <b>Done!</b> {0} collected <u>{1}</u> chats, segmented by <i>keywords</i>\n\n<b>Reach</b> : <u>{2}</u> users\n\nCan be <b>sent</b> to groups",
    'es': "🔥 <b>Listo!</b> {0} <u>{1}</u> chats recopilados, segmentados por <i>palabras clave</i>\n\n<b>Alcance</b> : <u>{2}</u> usuarios\n\nSe puede <b>enviar</b> a grupos",
    'fr': "🔥 <b>C&#x27;est fait !</b> {0} a collecté <u>{1}</u> chats, segmentés par <i>mots-clés</i>\n\n<b>Atteinte</b> : <u>{2}</u> utilisateurs\n\nPeut être <b>envoyé</b> à des groupes",
    'zh': "🔥<b>完成！</b> {0} 收集了<u>{1} 个</u>聊天，按<i>关键字细分</i>\n\n<b>覆盖</b>： <u>{2} 个</u>用户\n\n可以<b>发送</b>到组",
    'ar': "🔥 <b>انتهى!</b> {0} دردشات <u>{1}</u> مجمعة ، مقسمة حسب <i>الكلمات الرئيسية</i>\n\n<b>مدى الوصول</b> : <u>{2}</u> مستخدمين\n\nيمكن <b>إرسالها</b> إلى مجموعات",
}
l_find_usr_done = {
    'ru': "🔥 <b>Готово!</b> По {0} собрано <u>{1}</u> пользователей, сегментированных по <i>ключевым</i> словам\n\nМожно сразу сделать <b>рассылку</b> или подписку-<b>инвайт</b> в чат по <i>полученным</i> лидам",
    'en': "🔥 <b>Done!</b> {0} collected <u>{1}</u> users, segmented by <i>keywords</i>\n\nYou can immediately make <b>a mailing list</b> or subscribe <b>- invite</b> to the chat according to <i>the received</i> leads",
    'es': "🔥 <b>Listo!</b> {0} recolectó <u>{1}</u> usuarios, segmentados por <i>palabras clave</i>\n\nPuede crear <b>una lista de correo</b> o suscribirse inmediatamente <b>: invite</b> al chat de acuerdo con <i>los clientes potenciales recibidos</i>",
    'fr': "🔥 <b>C&#x27;est fait !</b> {0} utilisateurs collectés <u>{1}</u> , segmentés par <i>mots-clés</i>\n\nVous pouvez immédiatement créer <b>une liste de diffusion</b> ou vous abonner <b>- inviter</b> au chat en fonction <i>des prospects reçus</i>",
    'zh': "🔥<b>完成！</b> {0} 收集了<u>{1} 个</u>用户，按<i>关键字</i>细分\n\n您可以立即制作<b>邮件列表</b>或订阅<b>-</b>根据<i>收到的</i>线索邀请聊天",
    'ar': "🔥 <b>انتهى!</b> {0} تم تجميع <u>{1}</u> مستخدمين ، مقسمين حسب <i>الكلمات الرئيسية</i>\n\nيمكنك على الفور إنشاء <b>قائمة بريدية</b> أو الاشتراك <b>- قم بدعوة</b> إلى الدردشة وفقًا للعملاء <i>المحتملين المستلمين</i>",
}
l_find_bot_done = {
    'ru': "🔥 <b>Готово!</b> По {0} собрано <u>{1}</u> ботов, сегментированных по <i>ключевым</i> словам",
    'en': "🔥 <b>Done!</b> {0} collected <u>{1}</u> bots segmented by <i>keywords</i>",
    'es': "🔥 <b>Listo!</b> {0} recopilaron <u>{1}</u> bots segmentados por <i>palabras clave</i>",
    'fr': "🔥 <b>C&#x27;est fait !</b> {0} collecté <u>{1}</u> bots segmentés par <i>mots-clés</i>",
    'zh': "🔥<b>完成！</b> {0} 收集了<u>{1} 个</u><i>按关键字</i>细分的机器人",
    'ar': "🔥 <b>انتهى!</b> {0} جمعت <u>{1}</u> برامج التتبع مقسمة حسب <i>الكلمات الرئيسية</i>",
}
l_hashtag_categories = {
    "BLOG": ["blog", "блог", "влог", "блогер", "контентмейкер", 'contentmaker', 'youtube', 'путешестви',
             "курс", 'getcourse', 'геткурс', "английск", 'школ', "school", "запуск", 'заняти', 'урок', 'воркшоп',
             "language", "онлайн-школ", "онлайн школ", 'лингвист', 'linguist', 'марафон', 'практикум', 'семинар',
             'вебинар', 'лаборатор', 'хакатон', 'интенсив', 'обучени', 'запуск', 'колледж', 'институт',
             'университет', 'лекци', 'мастермайнд', 'симпозиум', 'тренинг', 'тимбилдинг', 'мастерск', 'образовани',
             'المدونة', 'blogue', '博客',
             ],
    "DIGIT": ['оцифров', "фин.", 'финан', 'бух', 'инвест', 'франш', 'трейд', 'бирж', 'кредит', "учет",
              "банк", "торг", "кассы", "денежн", "консалт", 'consult', 'finan', 'business', "доход",
              '数字化', 'digitalización', 'numérisation', 'الرقمنة',
              'استشارة', '谘询', 'consulter', 'consultar',
              ],
    "SMM": ['smm', 'смм', 'инста', 'inst', "facebook", 'tiktok', "тикток", 'tik-tok', "тик-ток", 'youtube', 'маркето',
            'маркети', 'market', 'таргет', "target", 'распаковка', 'продвижение', 'seo', 'сео', 'бренд', "агентство",
            "лиды", "vkontakte", "вконтакте", "лидов", "реклам", 'taplink', "прогрев", "блог", "визуал", "запуск",
            "трафик", "mvp", "редакция", 'директ',
            'سم', '市场推广', 'التسويق', 'comercialización', 'commercialisation', '',
            ],
    "RECRUIT": ["рекрут", "роп", "работа", "фриланc", "freela", "найм", "hr", "pr", "персонал", "менеджер",
                "продаж", "ассист", "риелтор", 'млм', 'mlm', "управлен", "наем", "сотрудн", "делегир", "карьер",
                'recruit', 'تجنيد', '招聘人员', 'recruter', 'recluta',
                'لحسابهم الخاص', '自由撰稿人', 'indépendant',
                ],
    "DESIGN": ["дизайн", "design", "интерьер", "декор", "мебел", "3d", "архитект", "двери", "ремонт", "строител",
                "фасад", 'тексти', "рису", "креатив", "визуал", "ландшафт", "художн", "картин",
                 "имидж", "камин", "монтаж", 'граф', 'искусств', 'рукодел',
                 '设计', 'التصميم', 'conception', 'diseño',
                 'interior', 'interior', 'intérieur', 'الداخلية', 'الداخلية',
               'architecture', 'architecture', 'arquitectura', '建筑设计', 'العمارة',
               'creative', '创意', 'creativo', 'créativité', 'الإبداع',
               ],
    "COACH": ["коуч", "coach", 'консульт', 'продюсер', "бизнес", "наставн", "оратор", "энерг", "эксперт", "психо",
              "трекер", 'гайд',
              "практик", "бренд", "тайм", "мотива", "логопед", "мышлен", "нумеролог", "таролог", "йог",
              "ментор", "тренер", "гештальт", "предприним", "метафори", "денеж", "диагност", "icf",
              '教练', 'مدرب',
              'producer', 'productor', 'producteur', '生产商', 'المنتج',
              'mentor', '导师', 'مينتور', '',
              ],
    "IT": ["лендинг", "crm", 'kotlin', 'swift', 'flutter', 'c++', 'c#', 'unity', 'angular',
           'amocrm', "powerbi", 'программирова', 'tilda', 'frontend', 'backend', 'python', 'ux/ui',
           "битрикс", 'автоматизаци', 'автоворон', 'разработч', 'java',
           "developer", 'блокчейн', 'blockchain', 'startup', 'coding',
           'développeur', 'desarrollador', '开发人员', 'المطور',
           ],
    "BUSINESS": ["business", "бизнес", "инвест", "франш", "кредит", "торг", "консалт", "consult",
                 "доход", "представит", "предпринимат", "коммерц", "фирм", "предприят", "компани", "промышл",
                 "производст", "invest", "капитал", "capital", "корпорац", "агентств", "пассив",
                 "дистриб", "акцио", "холдин", "прибыл", "рубл", "стартап", 'startup',
                 'الأعمال', '业务', 'negocios', 'affaires',
                 ],
    "GOODS": ["wildbe", "вайлд", 'ozon', "озон", 'avito', "авито", "авторск", "одежд", "китай",
              "китая", "складчина", "подарк", 'модн', 'маркетплейс', 'вещи',
              'clothes', 'vêtements', 'ropa', '衣服', 'الملابس',
              'السوق', '市场', 'mercado', 'marketplace',
              ],
    "OFFLINE": ["салон", "студи", "логист", "грузопер", 'свечи', "букеты", "клиник",
                "магазин", "производств", 'эпиляц', 'парикмах', "кондитер",
                "пищев", 'кулинар', 'оффлайн', 'offline', 'адрес', 'храм', 'церковь', 'транспорт',
                'temple', 'church',
                'барбер', 'barber', 'barbero', 'coiffeur', '理发师', 'الحلاق',
                'salon', 'salón', 'صالون', '沙龙',
                'недвижимость', 'real estate', 'inmueble', 'immobilier', '房地产', 'العقارات',
                'shop', 'tienda', 'boutique', '商店', 'تسوق',
                'كوك', '库克', 'cuisinier', 'gastrónomo',
                'ресторан', 'restaurant', 'restaurant', 'restaurante', '食肆', 'مطعم',
                ],
    "HEALTH": ["beautifull", "beauty", "бьюти", "красота", "здоров", 'нутрициолог', 'косметик', 'косметол', 'йога',
               'питани', 'доктор', 'диет', 'похуден', 'волос', 'маникюр', 'макияж', 'клиник', 'ресниц', 'эпиляц',
               'парикмах', 'nutrition', 'krasota', 'zdorov', 'dietol', 'медицин', 'medic', 'стоматол',
               'врач', 'vrach', 'yoga', 'фитнес', 'fitnes', 'медиц', 'медик', 'лекарств', 'спортив', 'sport',
               'семья', 'дети', 'ребенок',
               'health', 'الصحة', '健康', 'salud', 'santé',
               'beauté', 'belleza', '美貌', 'الجمال',
               'medicine', '医学', 'الطب', 'medicina', 'médecine',
               ],
}
l_hashtag_translate = {
    "BLOG": {
        'ru': "#блогер",
        'en': "#blogger",
        'es': "#blogger",
        'fr': "#blogueur",
        'zh': "#博客作者",
        'ar': "#مدون",
    },
    "DIGIT": {
        'ru': "#оцифровка",
        'en': "#digit",
        'es': "#digitalización",
        'fr': "#numérisation",
        'zh': "#数字化",
        'ar': "#الرقمنة",
    },
    "SMM": {
        'ru': "#смм",
        'en': "#smm",
        'es': "#blogger",
        'fr': "#blogger",
        'zh': "#blogger",
        'ar': "#سم",
    },
    "RECRUIT": {
        'ru': "#рекрут",
        'en': "#recruit",
        'es': "#recluta",
        'fr': "#recruter",
        'zh': "#招聘人员",
        'ar': "#تجنيد",
    },
    "DESIGN": {
        'ru': "#дизайн",
        'en': "#design",
        'es': "#diseño",
        'fr': "#conception",
        'zh': "#设计",
        'ar': "#التصميم",
    },
    "COACH": {
        'ru': "#коуч",
        'en': "#coach",
        'es': "#entrenador",
        'fr': "#entraîneur",
        'zh': "#教练",
        'ar': "#مدرب",
    },
    "IT": {
        'ru': "#ИТ",
        'en': "#IT",
        'es': "#IT",
        'fr': "#IT",
        'zh': "#信息技术",
        'ar': "#تقانةالمعلومات",
    },
    "BUSINESS": {
        'ru': "#бизнес",
        'en': "#business",
        'es': "#negocios",
        'fr': "#affaires",
        'zh': "#业务",
        'ar': "#الأعمال",
    },
    "GOODS": {
        'ru': "#товарка",
        'en': "#products",
        'es': "#mercancía",
        'fr': "#articles",
        'zh': "#产品中心",
        'ar': "#المنتجات",
    },
    "OFFLINE": {
        'ru': "#оффлайн",
        'en': "#offline",
        'es': "#fueradelínea",
        'fr': "#horsligne",
        'zh': "#离线状态",
        'ar': "#غيرمتصل",
    },
    "HEALTH": {
        'ru': "#здоровье",
        'en': "#health",
        'es': "#blogger",
        'fr': "#blogger",
        'zh': "#blogger",
        'ar': "#blogger",
    },
    "ISVERIFIED": {
        'ru': "#верифиц",
        'en': "#verified",
        'es': "#verificado",
        'fr': "#vérifié",
        'zh': "#已核实",
        'ar': "#التحقق",
    },
    "ISPREMIUM": {
        'ru': "#премиум",
        'en': "#premium",
        'es': "#prima",
        'fr': "#prime",
        'zh': "#保费",
        'ar': "#قسط",
    },
}

l_find_alert = {
    'ru': "👩🏽‍💻 <b>Жми</b> на ✅/☑️, чтобы вкл/выкл <i>уведомления</i> о появлении отслеживаемых слов в публичных группах/каналах\n\n🔔 <b>Отслеживаемые</b>  слова: <code>{0}</code>\n🔔 <b>Отслеживаемые</b> группы/каналы: <code>{1}</code>",
    'en': "👩🏽‍💻 <b>Click</b> on ✅/☑️ to turn on/off <i>notifications</i> about Telegram customers in freelance groups/channels\n\n🔔 For example, <i>#ищу</i> <i>an assistant to maintain a Telegram channel or</i> <i>#search</i> <i>a telegram bot developer</i>",
    'es': "👩🏽‍💻 <b>Haz clic</b> en ✅/☑️ para activar/desactivar <i>las notificaciones</i> sobre los clientes de Telegram en grupos/canales independientes\n\n🔔 Por ejemplo, <i>#ищу</i> <i>un asistente para mantener un canal de Telegram o</i> <i>#search</i> <i>un desarrollador de bots de Telegram</i>",
    'fr': "👩🏽‍💻 <b>Cliquez</b> sur ✅/☑️ pour activer/désactiver <i>les notifications</i> concernant les clients Telegram dans les groupes/canaux indépendants\n\n🔔 Par exemple, <i>#ищу</i> <i>un assistant pour gérer un canal Telegram ou</i> <i>#search</i> <i>un développeur de bot Telegram</i>",
    'zh': "👩🏽‍💻<b>点击</b>✅/☑️ 开启/关闭自由群组/频道中有关 Telegram 客户的<i>通知</i>\n\n🔔 例如， <i>#ищу维护</i><i> Telegram 频道的助手或#search一个 telegram 机器人开发者</i>",
    'ar': "👩🏽‍💻 <b>انقر</b> فوق ✅ / ☑️ لتشغيل / إيقاف تشغيل <i>الإشعارات</i> حول عملاء Telegram في مجموعات / قنوات مستقلة\n\n🔔 على سبيل المثال ، <i>#ищу</i> <i>مساعد للحفاظ على قناة Telegram أو</i> <i>#search</i> <i>مطور برامج Telegram bot</i>",
}
l_find_alert_alert = {
    'ru': "🔔 Нет отслеживаемых слов/групп/каналов\nЖми ⚙️Настроить",
    'en': "🪄 The footer is empty, you need to set it up ⚙️",
    'es': "🪄 El pie de página está vacío, debes configurarlo ⚙️",
    'fr': "🪄 Le pied de page est vide, vous devez le paramétrer ⚙️",
    'zh': "🪄 footer 是空的，需要设置一下⚙️",
    'ar': "🪄 التذييل فارغ ، تحتاج إلى إعداده ⚙️",
}
l_find_alert_words = {
    'ru': "👩🏽‍💻 <b>Вставь</b> отслеживаемые слова (более <u>3</u> символов) через <i>пробельные или разделительные</i> символы (без подписки: <u>1</u> слово)\n▪️регистр не важен\n▪️* в конце слова учитывает вхождение\n\n👩🏽‍💻 <b>Например</b>, для <b>психо*</b> отслеживание сработает на фразы: <i>анти<u>психо</u>лог, <u>Психо</u>терапевт..</i>\n🔔 <b>Отслеживаемые</b>  слова: <code>{0}</code>\n🔔 <b>Отслеживаемые</b> группы/каналы: <code>{1}</code>",
    'en': "👩🏽‍💻 <b>Enter</b> recipient Ids separated by spaces or separator characters",
    'es': "👩🏽‍💻 <b>Ingrese</b> las identificaciones de los destinatarios separadas por espacios o caracteres separadores",
    'fr': "👩🏽‍💻 <b>Entrez</b> les identifiants des destinataires séparés par des espaces ou des caractères de séparation",
    'zh': "👩🏽‍💻<b>输入</b>以空格或分隔符分隔的收件人 ID",
    'ar': "👩🏽‍💻 <b>أدخل</b> معرفات المستلمين مفصولة بمسافات أو أحرف فاصلة",
}
l_find_alert_sources = {
    'ru': "👩🏽‍💻 <b>Вставь</b> публичные ссылки на группы/каналы (для отслеживаемых слов) через <i>пробельные или разделительные</i> символы (без подписки: <u>5</u> групп/каналов)\n\n🔔 <b>Отслеживаемые</b>  слова: <code>{0}</code>\n🔔 <b>Отслеживаемые</b> группы/каналы: <code>{1}</code>",
    'en': "👩🏽‍💻 <b>Enter</b> recipient Ids separated by spaces or separator characters",
    'es': "👩🏽‍💻 <b>Ingrese</b> las identificaciones de los destinatarios separadas por espacios o caracteres separadores",
    'fr': "👩🏽‍💻 <b>Entrez</b> les identifiants des destinataires séparés par des espaces ou des caractères de séparation",
    'zh': "👩🏽‍💻<b>输入</b>以空格或分隔符分隔的收件人 ID",
    'ar': "👩🏽‍💻 <b>أدخل</b> معرفات المستلمين مفصولة بمسافات أو أحرف فاصلة",
}
l_find_need_subscribe = {
    'ru': "👩🏽‍💻 <b>Для</b> получения ссылки на сообщение и заказчика оформи подписку на @FereyFindBot-бота:\n\nhttps://t.me",
    'en': "👩🏽‍💻 <b>To</b> get a link to the message and the customer, subscribe to @FereyFindBot -bot:\n\nhttps://t.me",
    'es': "👩🏽‍💻 <b>Para</b> obtener un enlace al mensaje y al cliente, suscríbete a @FereyFindBot -bot:\n\nhttps://t.me",
    'fr': "👩🏽‍💻 <b>Pour</b> obtenir un lien vers le message et le client, abonnez-vous à @FereyFindBot -bot :\n\nhttps://t.me",
    'zh': "👩🏽‍💻<b>要</b>获取消息和客户的链接，请订阅@FereyFindBot -bot：\n\nhttps://t.me",
    'ar': "👩🏽‍💻 <b>للحصول</b> على ارتباط للرسالة والعميل ، اشترك في @FereyFindBot -bot:\n\nhttps: //t.me",
}
# endregion


# region FereyMediaBot
l_media_btn1 = {
    'ru': "⛰️ Медиа",
    'en': "⛰️ Media",
    'es': "⛰️ Medios",
    'fr': "⛰️ Médias",
    'zh': "⛰️ 媒体",
    'ar': "⛰️ ميديا",
}
l_media_btn2 = {
    'ru': "🌬 Подписка",
    'en': "🌬 Subscription",
    'es': "🌬 Suscripción",
    'fr': "🌬 Abonnement",
    'zh': "🌬订阅",
    'ar': "🌬 الاشتراك",
}
l_media_welcome = {
    'ru': "🌱 {0}, добро пожаловать в <i>лендинг-бот</i> медиа-заметок:\n\n▪️<b>стикеры</b> из текста и фото\n▪️<b>аудио-тренды</b>\n▪️<b>видео-заметки</b>\n▪️инлайн-<b>телескопы</b>\n▪️<b>кнопочные</b> премиум-заметки\n\n❗️Регулярно-обновляемый /content",
    'en': "🌱 {0}, welcome to <i>the landing bot of</i> медиа notes:\n\n▪️ <b>stickers</b> from text and photos\n▪️ <b>audio sounds</b>\n▪️ <b>video notes</b>\n\n❗️ you can also order the development of a chat bot in our Ferey studio",
    'es': "🌱 {0}, bienvenido <i>al bot de aterrizaje de</i> notas медиа :\n\n▪️ <b>pegatinas</b> de texto y fotos\n▪️ <b>sonidos de audio</b>\n▪️ <b>notas de video</b>\n\n❗️ también puedes solicitar el desarrollo de un bot de chat en nuestro estudio Ferey",
    'fr': "🌱 {0}, bienvenue dans <i>le bot de débarquement des</i> notes медиа :\n\n▪️ <b>autocollants</b> à partir de textes et de photos\n▪️ <b>sons audio</b>\n▪️ <b>notes vidéo</b>\n\n❗️ vous pouvez également commander le développement d'un chat bot dans notre studio Ferey",
    'zh': "🌱 {0}，欢迎来到медиа笔记<i>的登陆机器人</i>：\n\n▪️文字和照片的<b>贴纸</b>\n▪️<b>音频声音</b>\n▪️<b>视频笔记</b>\n\n❗️您也可以在我们的Ferey工作室",
    'ar': "🌱 {0} ، مرحبًا بك في <i>الروبوت الأساسي</i> لملاحظات медиа :\n\n▪️ <b>ملصقات</b> من النصوص والصور\n▪️ <b>الأصوات الصوتية</b>\n▪️ <b>ملاحظات الفيديو</b>\n\n❗️ يمكنك أيضًا طلب تطوير روبوت الدردشة في استوديو Ferey الخاص بنا",
}
l_subscribe_media = {
    'ru': "👩🏽‍💻 <b>Оформи</b> ежемесячную <i>подписку</i>:\n\n¹ [<b>Все боты</b> и проекты (-<u>5</u>%)]\n² [@{0}-бот]:\n▪️<b>кнопочные</b> премиум-заметки\n(<i>динамические медиа</i>)\n\n👩🏽‍💻 /balance",
    'en': "👩🏽‍💻 <b>Sign up for</b> a monthly\n\n¹ <i>subscription</i> to @{0}-bot [{1} ₽]\n▪️ no ads\n▪️ creative tasks\n² Subscribe to <u>all</u> bots [{2} ₽]",
    'es': "👩🏽‍💻 <b>Regístrese para obtener</b> una\n\n¹ <i>suscripción</i> mensual a @{0}-bot [{1} ₽]\n▪️ sin anuncios\n▪️ tareas creativas\n² Suscríbase a <u>todos</u> los bots [{2} ₽]",
    'fr': "👩🏽‍💻 <b>Inscrivez-vous pour</b> un <i>abonnement</i>\n\n¹ mensuel à @{0}-bot [{1} ₽]\n▪️ pas de publicité\n▪️ tâches créatives\n² Abonnez-vous à <u>tous</u> les bots [{2} ₽]",
    'zh': "👩🏽‍💻<b>注册</b>每月\n\n¹<i>订阅</i>@{0}-bot [{1} ₽]\n▪️ 无广告\n▪️ 创意任务\n² 订阅<u>所有</u>机器人 [{2} ₽]",
    'ar': "👩🏽‍💻 <b>اشترك للحصول على</b> <i>اشتراك</i> شهري\n\n¹ في @ {0} -bot [{1} ₽]\n▪️ بلا إعلانات\n▪️ مهام إبداعية\n² اشترك في <u>جميع</u> برامج التتبُّع [{2} ₽]",
}

l_media_text = {
    'ru': "👩🏽‍💻 <b>Здесь</b> можно выбрать тип выпадающих media-заметок (/add | /del)",
    'en': "👩🏽‍💻 <b>Here</b> you can select the type of drop-down media notes (/add | /del)",
    'es': "👩🏽‍💻 <b>Aquí</b> puede seleccionar el tipo de notas multimedia desplegables (/add | /del)",
    'fr': "👩🏽‍💻 <b>Ici,</b> vous pouvez sélectionner le type de notes multimédia déroulantes (/add | /del)",
    'zh': "👩🏽‍💻<b>在这里</b>可以选择下拉媒体备注的类型（/add | /del）",
    'ar': "👩🏽‍💻 <b>هنا</b> يمكنك تحديد نوع ملاحظات الوسائط المنسدلة (/ إضافة | / ديل)",
}
l_media_del = {
    'ru': "👩🏽‍💻 <b>Выбери</b> media-заметку для удаления",
    'en': "👩🏽‍💻 <b>Select</b> media note to delete",
    'es': "👩🏽‍💻 <b>Seleccione</b> la nota multimedia para eliminar",
    'fr': "👩🏽‍💻 <b>Sélectionnez</b> la note multimédia à supprimer",
    'zh': "👩🏽‍💻<b>选择</b>要删除的媒体备注",
    'ar': "<b>حدد</b> ملاحظة وسائط لحذفها",
}
l_media_show = {
    'ru': "👩🏽‍💻 <b>Введи</b> текст для поиска по media-заметкам",
    'en': "👩🏽‍💻 <b>Enter</b> text to search media notes",
    'es': "👩🏽‍💻 <b>Ingrese</b> texto para buscar notas multimedia",
    'fr': "👩🏽‍💻 <b>Entrez</b> du texte pour rechercher des notes multimédias",
    'zh': "👩🏽‍💻<b>输入</b>文字搜索媒体笔记",
    'ar': "👩🏽‍💻 <b>أدخل</b> نصًا للبحث في ملاحظات الوسائط",
}
l_media_random = {
    'ru': "🎲 <b>Случайный</b> выбор",
    'en': "🎲 <b>Random</b> selection",
    'es': "🎲 Selección <b>aleatoria</b>",
    'fr': "🎲 Sélection <b>aléatoire</b>",
    'zh': "🎲<b>随机</b>选择",
    'ar': "🎲 اختيار <b>عشوائي</b>",
}
l_media_none = {
    'ru': "👩🏽‍💻 <b>Media</b>-заметок не найдено",
    'en': "👩🏽‍💻 <b>Media</b> - no notes found",
    'es': "👩🏽‍💻 <b>Medios</b> : no se encontraron notas",
    'fr': "👩🏽‍💻 <b>Médias</b> - aucune note trouvée",
    'zh': "👩🏽‍💻<b>媒体</b>- 未找到笔记",
    'ar': "👩🏽‍💻 <b>وسائط</b> - لم يتم العثور على ملاحظات",
}
l_media_file = {
    'ru': "👩🏽‍💻 1/2. <b>Прикрепи</b> audio/video, text/photo контент для создания media-заметки",
    'en': "👩🏽‍💻 1/2. <b>Attach</b> audio/video, text/photo content to create a media note",
    'es': "👩🏽‍💻 1/2. <b>Adjunte</b> contenido de audio/video, texto/foto para crear una nota multimedia",
    'fr': "👩🏽‍💻 1/2. <b>Joignez</b> du contenu audio/vidéo, texte/photo pour créer une note multimédia",
    'zh': "👩🏽‍💻 1/2。<b>附加</b>音频/视频、文本/照片内容以创建媒体说明",
    'ar': "👩🏽‍💻 1/2. <b>قم بإرفاق</b> محتوى صوت / فيديو ونص / صورة لإنشاء ملاحظة وسائط",
}
l_media_title1 = {
    'ru': "👩🏽‍💻 2/2. <b>Введи</b> ключевые_слова для твоей media-заметки\n[изменить ключевые_слова нельзя]",
    'en': "👩🏽‍💻 2/2. <b>Enter</b> ключевые_слова for your media note\n[ключевые_слова cannot be changed]",
    'es': "👩🏽‍💻 2/2. <b>Ingrese</b> ключевые_слова para su nota de prensa\n[ключевые_слова no se pueden cambiar]",
    'fr': "👩🏽‍💻 2/2. <b>Saisissez</b> ключевые_слова pour votre note média\n[ключевые_слова ne peuvent pas être modifiés]",
    'zh': "👩🏽‍💻 2/2。为您的媒体说明<b>输入</b>ключевые_слова\n[无法更改ключевые_слова]",
    'ar': "👩🏽‍💻 2/2. <b>أدخل</b> ключевые_слова لملاحظتك الإعلامية\n[لا يمكن تغيير ключевые_слова]",
}
l_media_title2 = {
    'ru': "👩🏽‍💻 2/2. <b>Текущие</b> ключевые_слова для твоей media-заметки\n\n{0}\n\n[пришли новые или нажми {1}]",
    'en': "👩🏽‍💻 2/2. <b>Current</b> ключевые_слова for your media note\n\n{0}\n\n[new ones come in or press {1}]",
    'es': "👩🏽‍💻 2/2. ключевые_слова <b>actuales</b> para su nota de prensa\n\n{0}\n\n[nuevas ingrese o presione {1}]",
    'fr': "👩🏽‍💻 2/2. ключевые_слова <b>actuels</b> pour votre note multimédia\n\n{0}\n\n[les nouveaux arrivent ou appuyez sur {1}]",
    'zh': "👩🏽‍💻 2/2。您的媒体说明的<b>当前</b>ключевые_слова\n\n{0}\n\n[请输入新关键字或按 {1}]",
    'ar': "👩🏽‍💻 2/2. ключевые_слова <b>الحالية</b> لملاحظة الوسائط الخاصة بك\n\n{0}\n\n[يتم إدخال كلمات رئيسية جديدة أو الضغط على {1}]",
}
l_media_confirm = {
    'ru': "🏁 Завершить",
    'en': "🏁 Complete",
    'es': "🏁 Completa",
    'fr': "🏁 Complet",
    'zh': "🏁 完成",
    'ar': "🏁 مكتمل",
}
l_media_error = {
    'ru': "👩🏽‍💻 <b>Ошибка</b> (попробуй позже или загрузи другое media)",
    'en': "👩🏽‍💻 <b>Error</b> (try later or upload another media)",
    'es': "👩🏽‍💻 <b>Error</b> (intenta más tarde o sube otro medio)",
    'fr': "👩🏽‍💻 <b>Erreur</b> (essayez plus tard ou téléchargez un autre média)",
    'zh': "👩🏽‍💻<b>错误</b>（稍后再试或上传其他媒体）",
    'ar': "👩🏽‍💻 <b>خطأ</b> (حاول لاحقًا أو قم بتحميل وسائط أخرى)",
}
l_media_finish = {
    'ru': "👩🏽‍💻 <b>Media</b>-заметка успешно создана",
    'en': "👩🏽‍💻 <b>Media</b> - note created successfully",
    'es': "👩🏽‍💻 <b>Medios</b> : nota creada con éxito",
    'fr': "👩🏽‍💻 <b>Média</b> - note créée avec succès",
    'zh': "👩🏽‍💻<b>媒体</b>- 笔记创建成功",
    'ar': "👩🏽‍💻 <b>الوسائط</b> - تم إنشاء الملاحظة بنجاح",
}
l_media_publish = {
    'ru': "🔗 Список",
    'en': "🔗 List",
    'es': "🔗 Lista",
    'fr': "🔗 Liste",
    'zh': "🔗 清单",
    'ar': "🔗 قائمة",
}
l_media_check = {
    'ru': "🔗 Проверка",
    'en': "🔗 Check",
    'es': "🔗 Comprobar",
    'fr': "🔗 Vérifier",
    'zh': "🔗 检查",
    'ar': "🔗 تحقق",
}
l_media_hasdeleted = {
    'ru': "👩🏽‍💻 <b>Media</b>-заметка удалена",
    'en': "👩🏽‍💻 <b>Media</b> - note deleted",
    'es': "👩🏽‍💻 <b>Medios</b> - nota eliminada",
    'fr': "👩🏽‍💻 <b>Médias</b> - note supprimée",
    'zh': "👩🏽‍💻<b>媒体</b>- 注释已删除",
    'ar': "👩🏽‍💻 <b>الوسائط</b> - تم حذف الملاحظة",
}
l_media_delprepare = {
    'ru': "🔗 Выбрать",
    'en': "🔗 Choose",
    'es': "🔗 Elige",
    'fr': "🔗 Choisissez",
    'zh': "🔗选择",
    'ar': "🔗 اختر",
}
# endregion


# region FereyPostBot
l_post_btn1 = {
    'ru': "⛰️ Посты",
    'en': "⛰️ Posts",
    'es': "⛰️ Publicaciones",
    'fr': "⛰️ Messages",
    'zh': "⛰️ 帖子",
    'ar': "⛰️ المشاركات",
}
l_post_btn2 = {
    'ru': "🌬 Подписка",
    'en': "🌬 Subscription",
    'es': "🌬 Suscripción",
    'fr': "🌬 Abonnement",
    'zh': "🌬订阅",
    'ar': "🌬 الاشتراك",
}
l_post_welcome = {
    'ru': "🌱 {0}, добро пожаловать в <i>лендинг-бот</i> для создания креативных постов <b>Ferey</b>\n▪️инлайн-<b>телескопы</b>\n▪️<b>уведомления</b> о нажатиях\n\n❗️Регулярно-обновляемый /content",
    'en': "🌱 {0}, welcome to <i>the landing bot</i> for creating creative постов <b>Ferey</b>\n\n❗️ you can also order the development of a chat bot in our Ferey studio",
    'es': "🌱 {0}, bienvenido al <i>bot de aterrizaje</i> para crear постов creativas <b>Ferey</b>\n\n❗️también puedes solicitar el desarrollo de un bot de chat en nuestro estudio Ferey",
    'fr': "🌱 {0}, bienvenue sur <i>le landing bot</i> pour créer постов créatifs <b>Ferey</b>\n\n❗️ vous pouvez également commander le développement d'un chat bot dans notre studio Ferey",
    'zh': "🌱 {0}，欢迎使用<b>Ferey</b>创建创意постов的<i>登陆机器人</i>\n\n❗️ 您也可以在我们的Ferey工作室订购聊天机器人的开发",
    'ar': "🌱 {0} ، مرحبًا بك في <i>روبوت الهبوط</i> لإنشاء постов إبداعية <b>Ferey</b>\n\n❗️ يمكنك أيضًا طلب تطوير روبوت محادثة في استوديو Ferey الخاص بنا",
}
l_subscribe_post = {
    'ru': "👩🏽‍💻 <b>Оформи</b> ежемесячную <i>подписку</i>:\n\n¹ [<b>Все боты</b> и проекты (-<u>5</u>%)]\n² [@{0}-бот]:\n▪️<b>нотис</b>-уведомления о нажатиях\n(<i>ссылка на пользователя</i>)\n\n👩🏽‍💻 /balance",
    'en': "👩🏽‍💻 <b>Sign up for</b> a monthly\n\n¹ <i>subscription</i> to @{0}-bot [{1} ₽]\n▪️ no ads\n▪️ creative tasks\n² Subscribe to <u>all</u> bots [{2} ₽]",
    'es': "👩🏽‍💻 <b>Regístrese para obtener</b> una\n\n¹ <i>suscripción</i> mensual a @{0}-bot [{1} ₽]\n▪️ sin anuncios\n▪️ tareas creativas\n² Suscríbase a <u>todos</u> los bots [{2} ₽]",
    'fr': "👩🏽‍💻 <b>Inscrivez-vous pour</b> un <i>abonnement</i>\n\n¹ mensuel à @{0}-bot [{1} ₽]\n▪️ pas de publicité\n▪️ tâches créatives\n² Abonnez-vous à <u>tous</u> les bots [{2} ₽]",
    'zh': "👩🏽‍💻<b>注册</b>每月\n\n¹<i>订阅</i>@{0}-bot [{1} ₽]\n▪️ 无广告\n▪️ 创意任务\n² 订阅<u>所有</u>机器人 [{2} ₽]",
    'ar': "👩🏽‍💻 <b>اشترك للحصول على</b> <i>اشتراك</i> شهري\n\n¹ في @ {0} -bot [{1} ₽]\n▪️ بلا إعلانات\n▪️ مهام إبداعية\n² اشترك في <u>جميع</u> برامج التتبُّع [{2} ₽]",
}

l_post_bot_button_push = {
    'ru': "👩🏽‍💻 <b>Пользователь</b>: {0} нажал на: [{1}] (пост #<u>{2}</u>)",
    'en': "👩🏽‍💻 <b>Пользователь</b>: {name} нажал на: [{button}] (пост #<u>{post_id}</u>)",
    'es': "👩🏽‍💻 <b>Regístrese para obtener</b> una\n\n¹ <i>suscripción</i> mensual a @{0}-bot [{1} ₽]\n▪️ sin anuncios\n▪️ tareas creativas\n² Suscríbase a <u>todos</u> los bots [{2} ₽]",
    'fr': "👩🏽‍💻 <b>Inscrivez-vous pour</b> un <i>abonnement</i>\n\n¹ mensuel à @{0}-bot [{1} ₽]\n▪️ pas de publicité\n▪️ tâches créatives\n² Abonnez-vous à <u>tous</u> les bots [{2} ₽]",
    'zh': "👩🏽‍💻<b>注册</b>每月\n\n¹<i>订阅</i>@{0}-bot [{1} ₽]\n▪️ 无广告\n▪️ 创意任务\n² 订阅<u>所有</u>机器人 [{2} ₽]",
    'ar': "👩🏽‍💻 <b>اشترك للحصول على</b> <i>اشتراك</i> شهري\n\n¹ في @ {0} -bot [{1} ₽]\n▪️ بلا إعلانات\n▪️ مهام إبداعية\n² اشترك في <u>جميع</u> برامج التتبُّع [{2} ₽]",
}
# endregion


# region FereyToolsBot
l_tools_btn1 = {
    'ru': "⛰️ Инструменты",
    'en': "⛰️ Tools",
    'es': "⛰️ Herramientas",
    'fr': "⛰️ Outils",
    'zh': "⛰️ 工具",
    'ar': "⛰️ أدوات",
}
l_tools_btn2 = {
    'ru': "🌬 Подписка",
    'en': "🌬 Subscription",
    'es': "🌬 Suscripción",
    'fr': "🌬 Abonnement",
    'zh': "🌬订阅",
    'ar': "🌬 الاشتراك",
}
l_tools_welcome = {
    'ru': "🌱 {0}, добро пожаловать в <i>лендинг-бот</i> Telegram-инструментов:\n\n▪️<b>преобразование</b> контента\n▪️<b>получение</b> информации о сообщ\n▪️<b>удаление</b> фона\n▪️<b>конвертация</b> в телескопы\n▪️<b>сообщение</b> 0-длины\n\n❗️Регулярно-обновляемый /content",
    'en': "🌱 {0}, welcome to <i>the landing bot</i> of Telegram инструментов :\n\n▪️ content <b>conversion</b>\n▪️ <b>getting</b> information about the message\n\n❗️you can also order the development of a chat bot in our studio Ferey",
    'es': "🌱 {0}, bienvenido al <i>bot de aterrizaje</i> de инструментов de Telegram:\n\n▪️ <b>conversión</b> de contenido\n▪️ <b>obtener</b> información sobre el mensaje\n\n❗️también puedes solicitar el desarrollo de un bot de chat en nuestro estudio Ferey",
    'fr': "🌱 {0}, bienvenue dans <i>le landing bot</i> des инструментов Telegram :\n\n▪️ <b>conversion</b> de contenu\n▪️ <b>obtenir</b> des informations sur le message\n\n❗️vous pouvez également commander le développement d'un chat bot dans notre studio Ferey",
    'zh': "🌱 {0}，欢迎使用 Telegram инструментов的<i>登陆机器人</i>：\n\n▪️ 内容<b>转换</b>\n▪️<b>获取</b>有关消息的信息\n\n❗️您也可以在我们的工作室Ferey订购聊天机器人的开发",
    'ar': "🌱 {0} ، مرحبًا بك في <i>روبوت الهبوط</i> الخاص инструментов Telegram:\n\n▪️ <b>تحويل</b> المحتوى\n▪️ <b>الحصول على</b> معلومات حول الرسالة\n\n❗️ يمكنك أيضًا طلب تطوير روبوت محادثة في استوديو Ferey الخاص بنا",
}
l_subscribe_tools = {
    'ru': "👩🏽‍💻 <b>Оформи</b> ежемесячную <i>подписку</i>:\n\n¹ [<b>Все боты</b> и проекты (-<u>5</u>%)]\n\n👩🏽‍💻 /balance",
    'en': "👩🏽‍💻 <b>Sign up for</b> a monthly\n\n¹ <i>subscription</i> to @{0}-bot [{1} ₽]\n▪️ no ads\n▪️ creative tasks\n² Subscribe to <u>all</u> bots [{2} ₽]",
    'es': "👩🏽‍💻 <b>Regístrese para obtener</b> una\n\n¹ <i>suscripción</i> mensual a @{0}-bot [{1} ₽]\n▪️ sin anuncios\n▪️ tareas creativas\n² Suscríbase a <u>todos</u> los bots [{2} ₽]",
    'fr': "👩🏽‍💻 <b>Inscrivez-vous pour</b> un <i>abonnement</i>\n\n¹ mensuel à @{0}-bot [{1} ₽]\n▪️ pas de publicité\n▪️ tâches créatives\n² Abonnez-vous à <u>tous</u> les bots [{2} ₽]",
    'zh': "👩🏽‍💻<b>注册</b>每月\n\n¹<i>订阅</i>@{0}-bot [{1} ₽]\n▪️ 无广告\n▪️ 创意任务\n² 订阅<u>所有</u>机器人 [{2} ₽]",
    'ar': "👩🏽‍💻 <b>اشترك للحصول على</b> <i>اشتراك</i> شهري\n\n¹ في @ {0} -bot [{1} ₽]\n▪️ بلا إعلانات\n▪️ مهام إبداعية\n² اشترك في <u>جميع</u> برامج التتبُّع [{2} ₽]",
}

l_image_text = {
    'ru': "👩🏽‍💻 <b>Выбери</b> инструменты для преобразования <i>изображения</i> в",
    'en': "👩🏽‍💻 <b>Choose</b> tools to convert <i>your image</i> to",
    'es': "👩🏽‍💻 <b>Elija</b> herramientas para convertir <i>su imagen</i> a",
    'fr': "👩🏽‍💻 <b>Choisissez</b> des outils pour convertir <i>votre image</i> en",
    'zh': "👩🏽‍💻<b>选择</b>将<i>图像</i>转换为的工具",
    'ar': "👩🏽‍💻 <b>اختر</b> أدوات لتحويل <i>صورتك</i> إلى",
}
l_image_sticker = {
    'ru': "🌌 стикер",
    'en': "🌌 sticker",
    'es': "🌌 pegatina",
    'fr': "🌌 autocollant",
    'zh': "🌌 贴纸",
    'ar': "🌌 ملصق",
}
l_image_jpg = {
    'ru': "🏞️ jpg",
    'en': "🏞️ jpg",
    'es': "🏞️ jpg",
    'fr': "🏞️jpg",
    'zh': "🏞️ jpg",
    'ar': "🏞️ jpg",
}
l_image_png = {
    'ru': "🌁 png",
    'en': "🌁 png",
    'es': "🌁 png",
    'fr': "🌁 png",
    'zh': "🌁 PNG",
    'ar': "🌁 ينغ",
}
l_image_rbg = {
    'ru': "🙌🏽 удалить фон",
    'en': "🙌🏽 remove background",
    'es': "🙌🏽 eliminar fondo",
    'fr': "🙌🏽 supprimer l'arrière-plan",
    'zh': "🙌🏽 删除背景",
    'ar': "🙌🏽 إزالة الخلفية",
}
l_image_mp4 = {
    'ru': "🎥 mp4",
    'en': "🎥 mp4",
    'es': "🎥 mp4",
    'fr': "🎥 mp4",
    'zh': "🎥 mp4",
    'ar': "🎥 mp4",
}
l_image_album = {
    'ru': "9️⃣ album⁹",
    'en': "9️⃣ album⁹",
    'es': "9️⃣ álbum⁹",
    'fr': "9️⃣album⁹",
    'zh': "9️⃣专辑⁹",
    'ar': "9️⃣ البوم⁹",
}
l_image_thumb = {
    'ru': "🖼️ thumb",
    'en': "🖼️ thumb",
    'es': "🖼️ pulgar",
    'fr': "🖼️ pouce",
    'zh': "🖼️拇指",
    'ar': "🖼️ إبهام",
}
l_image_descpic = {
    'ru': "⿴ Bot Desc Pic",
    'en': "⿴ Bot Desc Pic",
    'es': "⿴ Foto de descripción del bot",
    'fr': "⿴ Image de description du robot",
    'zh': "⿴ 机器人描述图片",
    'ar': "⿴ بوت ديسك بيك",
}
l_image_sticker_attach = {
    'ru': "👩🏽‍💻 <b>Прикрепи</b> фото для преобразования в стикер",
    'en': "👩🏽‍💻 <b>Attach</b> a photo to convert into a sticker",
    'es': "👩🏽‍💻 <b>Adjunta</b> una foto para convertirla en una pegatina",
    'fr': "👩🏽‍💻 <b>Joignez</b> une photo à convertir en autocollant",
    'zh': "👩🏽‍💻<b>附上</b>照片以转换为贴纸",
    'ar': "👩🏽‍💻 <b>أرفق</b> صورة لتحويلها إلى ملصق",
}
l_image_jpg_attach = {
    'ru': "👩🏽‍💻 <b>Прикрепи</b> фото для преобразования в jpg",
    'en': "👩🏽‍💻 <b>Attach</b> a photo to convert to jpg",
    'es': "👩🏽‍💻 <b>Adjunta</b> una foto para convertir a jpg",
    'fr': "👩🏽‍💻 <b>Joindre</b> une photo à convertir en jpg",
    'zh': "👩🏽‍💻<b>附上</b>照片以转换为jpg",
    'ar': "👩🏽‍💻 <b>أرفق</b> صورة لتحويلها إلى jpg",
}
l_image_png_attach = {
    'ru': "👩🏽‍💻 <b>Прикрепи</b> фото для преобразования в png",
    'en': "👩🏽‍💻 <b>Attach</b> a photo to convert to png",
    'es': "👩🏽‍💻 <b>Adjunta</b> una foto para convertir a png",
    'fr': "👩🏽‍💻 <b>Joindre</b> une photo à convertir en png",
    'zh': "👩🏽‍💻<b>附上</b>要转换为png的照片",
    'ar': "👩🏽‍💻 <b>أرفق</b> صورة لتحويلها إلى png",
}
l_image_rbg_attach = {
    'ru': "👩🏽‍💻 <b>Прикрепи</b> фото для удаления фона",
    'en': "👩🏽‍💻 <b>Attach</b> photo to remove background",
    'es': "👩🏽‍💻 <b>Adjuntar</b> foto para eliminar fondo",
    'fr': "👩🏽‍💻 <b>Joindre</b> une photo pour supprimer l'arrière-plan",
    'zh': "👩🏽‍💻<b>附加</b>照片以删除背景",
    'ar': "👩🏽‍💻 <b>إرفاق</b> صورة لإزالة الخلفية",
}
l_image_mp4_attach = {
    'ru': "👩🏽‍💻 <b>Прикрепи</b> фото для преобразования в mp4 (Telegram-аватарку)",
    'en': "👩🏽‍💻 <b>Attach</b> a photo to convert to mp4 (Telegram avatar)",
    'es': "👩🏽‍💻 <b>Adjunta</b> una foto para convertir a mp4 (Avatar de Telegram)",
    'fr': "👩🏽‍💻 <b>Joindre</b> une photo à convertir en mp4 (avatar Telegram)",
    'zh': "👩🏽‍💻<b>附上</b>照片以转换为mp4（电报头像）",
    'ar': "👩🏽‍💻 <b>إرفاق</b> صورة لتحويلها إلى mp4 (Telegram avatar)",
}
l_image_album_attach = {
    'ru': "👩🏽‍💻 <b>Прикрепи</b> фото для преобразования в альбом из 9 частей",
    'en': "👩🏽‍💻 <b>Attach</b> a photo to transform into a 9-part album",
    'es': "👩🏽‍💻 <b>Adjunta</b> una foto para transformarla en un álbum de 9 partes",
    'fr': "👩🏽‍💻 <b>Joignez</b> une photo pour la transformer en un album en 9 parties",
    'zh': "👩🏽‍💻<b>附上</b>照片，变身为9张相册",
    'ar': "👩🏽‍💻 <b>أرفق</b> صورة لتحويلها إلى ألبوم مكون من 9 أجزاء",
}
l_image_thumb_attach = {
    'ru': "👩🏽‍💻 <b>Прикрепи</b> фото для преобразования в thumb-nail-иконку (160x160)",
    'en': "👩🏽‍💻 <b>Attach</b> a photo to convert to a thumb-nail icon (160x160)",
    'es': "👩🏽‍💻 <b>Adjunte</b> una foto para convertirla en un icono de miniatura (160x160)",
    'fr': "👩🏽‍💻 <b>Joignez</b> une photo à convertir en icône de vignette (160x160)",
    'zh': "👩🏽‍💻<b>附加</b>照片以转换为缩略图图标 (160x160)",
    'ar': "👩🏽‍💻 <b>أرفق</b> صورة لتحويلها إلى رمز مسمار الإبهام (160 × 160)",
}
l_image_descpic_attach = {
    'ru': "👩🏽‍💻 <b>Прикрепи</b> фото для преобразования в формат, необходимый для установки Description Picture для бота в @BotFather (640x360)",
    'en': "👩🏽‍💻 <b>Attach</b> a photo to convert to the format required to set the Description Picture for the bot in @BotFather (640x360)",
    'es': "👩🏽‍💻 <b>Adjunte</b> una foto para convertir al formato requerido para configurar la imagen de descripción para el bot en @BotFather (640x360)",
    'fr': "👩🏽‍💻 <b>Joignez</b> une photo à convertir au format requis pour définir l'image de description du bot dans @BotFather (640x360)",
    'zh': "👩🏽‍💻<b>附上</b>照片以转换为在@BotFather中为机器人设置描述图片所需的格式（640x360）",
    'ar': "👩🏽‍💻 <b>أرفق</b> صورة لتحويلها إلى التنسيق المطلوب لتعيين وصف الصورة للروبوت في @BotFather (640x360)",
}

l_gif_text = {
    'ru': "👩🏽‍💻 <b>Выбери</b> инструменты для преобразования <i>гиф</i> в",
    'en': "👩🏽‍💻 <b>Choose</b> tools to convert <i>GIF</i> to",
    'es': "👩🏽‍💻 <b>Elija</b> herramientas para convertir <i>GIF</i> a",
    'fr': "👩🏽‍💻 <b>Choisissez</b> des outils pour convertir <i>GIF</i> en",
    'zh': "👩🏽‍💻<b>选择将</b><i>GIF</i>转换为的工具",
    'ar': "👩🏽‍💻 <b>اختر</b> أدوات لتحويل <i>GIF</i> إلى",
}
l_gif_mp4 = {
    'ru': "🎥 mp4",
    'en': "🎥 mp4",
    'es': "🎥 mp4",
    'fr': "🎥 mp4",
    'zh': "🎥 mp4",
    'ar': "🎥 mp4",
}
l_gif_thumb = {
    'ru': "🖼️ thumb-nail",
    'en': "🖼️ thumb-nail",
    'es': "🖼️ miniatura",
    'fr': "🖼️ ongle du pouce",
    'zh': "🖼️ 缩略图",
    'ar': "🖼️ الإبهام",
}
l_gif_descgif = {
    'ru': "⿴ Bot Desc Gif",
    'en': "⿴ Bottom Desc Gif",
    'es': "⿴ Gif de descripción inferior",
    'fr': "⿴ Bas Desc Gif",
    'zh': "⿴ 底部描述 Gif",
    'ar': "⿴ أسفل Desc Gif",
}
l_gif_mp4_attach = {
    'ru': "👩🏽‍💻 <b>Прикрепи</b> гиф для преобразования в mp4",
    'en': "👩🏽‍💻 <b>Attach</b> GIF to convert to mp4",
    'es': "👩🏽‍💻 <b>Adjuntar</b> GIF para convertir a mp4",
    'fr': "👩🏽‍💻 <b>Joindre</b> GIF pour convertir en mp4",
    'zh': "👩🏽‍💻<b>附加</b>GIF 以转换为 mp4",
    'ar': "👩🏽‍💻 <b>إرفاق</b> GIF للتحويل إلى mp4",
}
l_gif_thumb_attach = {
    'ru': "👩🏽‍💻 <b>Прикрепи</b> гиф для преобразования в thumb-nail-иконку (160x160)",
    'en': "👩🏽‍💻 <b>Attach</b> GIF to convert to thumb-nail icon (160x160)",
    'es': "👩🏽‍💻 <b>Adjuntar</b> GIF para convertir en icono de miniatura (160x160)",
    'fr': "👩🏽‍💻 <b>Attachez</b> GIF pour convertir en icône de vignette (160x160)",
    'zh': "👩🏽‍💻<b>附加</b>GIF 以转换为缩略图图标 (160x160)",
    'ar': "👩🏽‍💻 <b>أرفق</b> ملف GIF للتحويل إلى أيقونة مسمار الإبهام (160 × 160)",
}
l_gif_descgif_attach = {
    'ru': "👩🏽‍💻 <b>Прикрепи</b> гиф для преобразования в формат, необходимый для установки Description Gif для бота в @BotFather (640x360). После формирования GIF нажимаем на нее через <u>мобильное</u> приложение (ожидая загрузки), далее Поделиться - приложение Telegram - @BotFather",
    'en': "👩🏽‍💻 <b>Attach</b> a gif to convert to the format needed to set the Description Gif for the bot to @BotFather (640x360). After generating a GIF, click on it through <u>the mobile</u> application (waiting for download), then Share - Telegram application - @BotFather",
    'es': "👩🏽‍💻 <b>Adjunte</b> un gif para convertir al formato necesario para configurar el GIF de descripción para el bot en @BotFather (640x360). Después de generar un GIF, haga clic en él a través de <u>la aplicación móvil</u> (en espera de descarga), luego Compartir - Aplicación Telegram - @BotFather",
    'fr': "👩🏽‍💻 <b>Joignez</b> un gif à convertir au format nécessaire pour définir le gif de description du bot sur @BotFather (640x360). Après avoir généré un GIF, cliquez dessus via <u>l&#x27;application mobile</u> (en attente de téléchargement), puis Partager - Application Telegram - @BotFather",
    'zh': "👩🏽‍💻<b>附加</b>一个 gif 以转换为将机器人的描述 Gif 设置为@BotFather (640x360) 所需的格式。生成GIF后，通过<u>手机</u>应用点击（等待下载），然后Share - Telegram application - @BotFather",
    'ar': "👩🏽‍💻 <b>أرفق</b> صورة gif للتحويل إلى التنسيق المطلوب لتعيين Description Gif للبوت إلى @BotFather (640x360). بعد إنشاء ملف GIF ، اضغط عليه من خلال تطبيق <u>الهاتف المحمول</u> (في انتظار التنزيل) ، ثم شارك - تطبيق Telegram @BotFather",
}

l_video_text = {
    'ru': "👩🏽‍💻 <b>Выбери</b> инструменты для преобразования <i>видео</i> в",
    'en': "👩🏽‍💻 <b>Choose</b> tools to convert <i>video</i> to",
    'es': "👩🏽‍💻 <b>Elija</b> herramientas para convertir <i>videos</i> a",
    'fr': "👩🏽‍💻 <b>Choisissez</b> des outils pour convertir <i>la vidéo</i> en",
    'zh': "👩🏽‍💻<b>选择将</b><i>视频</i>转换为的工具",
    'ar': "👩🏽‍💻 <b>اختر</b> أدوات لتحويل <i>الفيديو</i> إلى",
}
l_video_videonote = {
    'ru': "⚫️ телескоп",
    'en': "⚫️ telescope",
    'es': "⚫️ telescopio",
    'fr': "⚫️ télescope",
    'zh': "⚫️望远镜",
    'ar': "⚫️ تلسكوب",
}
l_video_mp3 = {
    'ru': "▶️ mp3",
    'en': "▶️ mp3",
    'es': "▶️ mp3",
    'fr': "▶️ mp3",
    'zh': "▶️ mp3",
    'ar': "▶️ mp3",
}
l_video_mp4 = {
    'ru': "🎥 mp4",
    'en': "🎥 mp4",
    'es': "🎥 mp4",
    'fr': "🎥 mp4",
    'zh': "🎥 mp4",
    'ar': "🎥 mp4",
}
l_video_album = {
    'ru': "9️⃣ album⁹",
    'en': "9️⃣ album⁹",
    'es': "9️⃣ álbum⁹",
    'fr': "9️⃣album⁹",
    'zh': "9️⃣专辑⁹",
    'ar': "9️⃣ البوم⁹",
}
l_video_thumb = {
    'ru': "🖼️ thumb-nail",
    'en': "🖼️ thumb-nail",
    'es': "🖼️ miniatura",
    'fr': "🖼️ ongle du pouce",
    'zh': "🖼️ 缩略图",
    'ar': "🖼️ الإبهام",
}
l_video_gif = {
    'ru': "📽️ gif",
    'en': "📽️ gif",
    'es': "📽️ gif",
    'fr': "📽️ gif",
    'zh': "📽️动图",
    'ar': "📽️ gif",
}
l_video_transcribe = {
    'ru': "🗣️ транскрибация",
    'en': "🗣️ transcription",
    'es': "🗣️ transcripción",
    'fr': "🗣️ retranscription",
    'zh': "🗣️ 转录",
    'ar': "🗣️ النسخ",
}
l_video_videonote_attach = {
    'ru': "👩🏽‍💻 <b>Прикрепи</b> видео для преобразования в телескоп (круглую видео-заметку)",
    'en': "👩🏽‍💻 <b>Attach</b> a video to transform into a telescope (round video note)",
    'es': "👩🏽‍💻 <b>Adjunta</b> un video para transformarte en telescopio (nota de video redonda)",
    'fr': "👩🏽‍💻 <b>Joindre</b> une vidéo pour se transformer en télescope (note vidéo ronde)",
    'zh': "👩🏽‍💻<b>附上</b>变身望远镜的视频（圆形视频笔记）",
    'ar': "<b>أرفق</b> مقطع فيديو لتحويله إلى تلسكوب (ملاحظة فيديو مستديرة)",
}
l_video_mp3_attach = {
    'ru': "👩🏽‍💻 <b>Прикрепи</b> видео для преобразования в mp3-аудио",
    'en': "👩🏽‍💻 <b>Attach</b> video to convert to mp3 audio",
    'es': "👩🏽‍💻 <b>Adjuntar</b> video para convertir a audio mp3",
    'fr': "👩🏽‍💻 <b>Joindre</b> une vidéo pour la convertir en audio mp3",
    'zh': "👩🏽‍💻<b>附加</b>视频以转换为 mp3 音频",
    'ar': "👩🏽‍💻 <b>إرفاق</b> الفيديو لتحويله إلى صوت mp3",
}
l_video_mp4_attach = {
    'ru': "👩🏽‍💻 <b>Прикрепи</b> видео для преобразования в mp4",
    'en': "👩🏽‍💻 <b>Attach</b> video to convert to mp4",
    'es': "👩🏽‍💻 <b>Adjuntar</b> video para convertir a mp4",
    'fr': "👩🏽‍💻 <b>Joindre</b> une vidéo à convertir en mp4",
    'zh': "👩🏽‍💻<b>附上</b>视频以转换为mp4",
    'ar': "👩🏽‍💻 <b>إرفاق</b> الفيديو لتحويله إلى mp4",
}
l_video_album_attach = {
    'ru': "👩🏽‍💻 <b>Прикрепи</b> видео для преобразования в альбом из 9 частей",
    'en': "👩🏽‍💻 <b>Attach</b> video to convert into 9 part album",
    'es': "👩🏽‍💻 <b>Adjuntar</b> video para convertir en álbum de 9 partes",
    'fr': "👩🏽‍💻 <b>Joindre</b> une vidéo à convertir en album en 9 parties",
    'zh': "👩🏽‍💻<b>附上</b>视频以转换成 9 部分专辑",
    'ar': "👩🏽‍💻 <b>أرفق مقطع</b> فيديو لتحويله إلى ألبوم مكون من 9 أجزاء",
}
l_video_thumb_attach = {
    'ru': "👩🏽‍💻 <b>Прикрепи</b> видео для преобразования в thumb-nail-иконку (160x160)",
    'en': "👩🏽‍💻 <b>Attach</b> video to convert to thumbnail (160x160)",
    'es': "👩🏽‍💻 <b>Adjuntar</b> video para convertirlo en miniatura (160x160)",
    'fr': "👩🏽‍💻 <b>Joindre</b> une vidéo à convertir en vignette (160x160)",
    'zh': "👩🏽‍💻<b>附加</b>视频以转换为缩略图 (160x160)",
    'ar': "👩🏽‍💻 <b>إرفاق</b> فيديو للتحويل إلى صورة مصغرة (160 × 160)",
}
l_video_gif_attach = {
    'ru': "👩🏽‍💻 <b>Прикрепи</b> видео для преобразования в гиф",
    'en': "👩🏽‍💻 <b>Attach</b> video to convert to GIF",
    'es': "👩🏽‍💻 <b>Adjuntar</b> video para convertir a GIF",
    'fr': "👩🏽‍💻 <b>Joindre</b> une vidéo à convertir en GIF",
    'zh': "👩🏽‍💻<b>附加</b>视频以转换为 GIF",
    'ar': "👩🏽‍💻 <b>إرفاق</b> الفيديو لتحويله إلى GIF",
}
l_video_transcribe_attach = {
    'ru': "👩🏽‍💻 <b>Прикрепи</b> круглую видео для преобразования в текст",
    'en': "👩🏽‍💻 <b>Attach</b> round video to convert to text",
    'es': "👩🏽‍💻 <b>Adjuntar</b> video redondo para convertir a texto",
    'fr': "👩🏽‍💻 <b>Attachez</b> une vidéo ronde pour la convertir en texte",
    'zh': "👩🏽‍💻<b>附上</b>圆形视频以转换为文本",
    'ar': "👩🏽‍💻 <b>أرفق</b> مقطع فيديو مستديرًا للتحويل إلى نص",
}

l_audio_text = {
    'ru': "👩🏽‍💻 <b>Выбери</b> инструменты для преобразования <i>audio</i> в",
    'en': "👩🏽‍💻 <b>Choose</b> tools to convert <i>audio</i> to",
    'es': "👩🏽‍💻 <b>Elija</b> herramientas para convertir <i>audio</i> a",
    'fr': "👩🏽‍💻 <b>Choisissez</b> des outils pour convertir <i>l&#x27;audio</i> en",
    'zh': "👩🏽‍💻<b>选择</b>将<i>音频</i>转换为的工具",
    'ar': "👩🏽‍💻 <b>اختر</b> أدوات لتحويل <i>الصوت</i> إلى",
}
l_audio_mp3 = {
    'ru': "▶️ mp3-аудио",
    'en': "▶️ mp3-audio",
    'es': "▶️ audio mp3",
    'fr': "▶️ audio mp3",
    'zh': "▶️ mp3音频",
    'ar': "▶ ️ mp3 الصوت",
}
l_audio_ogg = {
    'ru': "🎤 ogg-голосовое",
    'en': "🎤 ogg-voice",
    'es': "🎤 voz ogg",
    'fr': "🎤 ogg-voix",
    'zh': "🎤 ogg 声音",
    'ar': "🎤 ogg-voice",
}
l_audio_transcribe = {
    'ru': "🗣️ транскрибация",
    'en': "🗣️ transcription",
    'es': "🗣️ transcripción",
    'fr': "🗣️ retranscription",
    'zh': "🗣️ 转录",
    'ar': "🗣️ النسخ",
}
l_audio_mp3_attach = {
    'ru': "👩🏽‍💻 <b>Прикрепи</b> голосовое для преобразования в mp3",
    'en': "👩🏽‍💻 <b>Attach</b> voice to convert to mp3",
    'es': "👩🏽‍💻 <b>Adjuntar</b> voz para convertir a mp3",
    'fr': "👩🏽‍💻 <b>Joindre</b> la voix pour convertir en mp3",
    'zh': "👩🏽‍💻<b>附上</b>语音转换成mp3",
    'ar': "👩🏽‍💻 <b>إرفاق</b> الصوت للتحويل إلى mp3",
}
l_audio_ogg_attach = {
    'ru': "👩🏽‍💻 <b>Прикрепи</b> audio для преобразования в голосовое",
    'en': "👩🏽‍💻 <b>Attach</b> audio to convert to voice",
    'es': "👩🏽‍💻 <b>Adjuntar</b> audio para convertir a voz",
    'fr': "👩🏽‍💻 <b>Attachez</b> l'audio pour convertir en voix",
    'zh': "👩🏽‍💻<b>附加</b>音频以转换为语音",
    'ar': "👩🏽‍💻 <b>إرفاق</b> الصوت لتحويله إلى صوت",
}
l_audio_transcribe_attach = {
    'ru': "👩🏽‍💻 <b>Прикрепи</b> голосовое для преобразования в текст",
    'en': "👩🏽‍💻 <b>Attach</b> voice to convert to text",
    'es': "👩🏽‍💻 <b>Adjuntar</b> voz para convertir a texto",
    'fr': "👩🏽‍💻 <b>Attachez</b> la voix pour convertir en texte",
    'zh': "👩🏽‍💻<b>附加</b>语音以转换为文本",
    'ar': "👩🏽‍💻 <b>إرفاق</b> صوت لتحويله إلى نص",
}
l_audio_recognize = {
    'ru': "👩🏽‍💻 <b>Ошибка</b> распознавания речи",
    'en': "👩🏽‍💻 Speech Recognition <b>Error</b>",
    'es': "👩🏽‍💻 <b>Error</b> de reconocimiento de voz",
    'fr': "👩🏽‍💻 <b>Erreur</b> de reconnaissance vocale",
    'zh': "👩🏽‍💻语音识别<b>错误</b>",
    'ar': "👩🏽‍💻 <b>خطأ</b> في التعرف على الكلام",
}

l_text_text = {
    'ru': "👩🏽‍💻 <b>Выбери</b> инструменты для преобразования <i>текста</i> в",
    'en': "👩🏽‍💻 <b>Choose</b> tools to convert <i>text</i> to",
    'es': "👩🏽‍💻 <b>Elija</b> herramientas para convertir <i>texto</i> a",
    'fr': "👩🏽‍💻 <b>Choisissez</b> des outils pour convertir du <i>texte</i> en",
    'zh': "👩🏽‍💻<b>选择</b>将<i>文本</i>转换为的工具",
    'ar': "👩🏽‍💻 <b>اختر</b> أدوات لتحويل <i>النص</i> إلى",
}
l_text_bin = {
    'ru': "🔢 bin",
    'en': "🔢 bin",
    'es': "🔢 papelera",
    'fr': "🔢 bin",
    'zh': "🔢 垃圾桶",
    'ar': "🔢 بن",
}
l_text_hex = {
    'ru': "🔠 hex",
    'en': "🔠 hex",
    'es': "🔠 maleficio",
    'fr': "🔠 hexagone",
    'zh': "🔠十六进制",
    'ar': "🔠 عرافة",
}
l_text_null = {
    'ru': "0️⃣ null",
    'en': "0️⃣ null",
    'es': "0️⃣ nulo",
    'fr': "0️⃣ nul",
    'zh': "0️⃣ 无",
    'ar': "0️⃣ لاغية",
}
l_text_mp3 = {
    'ru': "▶️ mp3-аудио",
    'en': "▶️ mp3-audio",
    'es': "▶️ audio mp3",
    'fr': "▶️ audio mp3",
    'zh': "▶️ mp3音频",
    'ar': "▶ ️ mp3 الصوت",
}
l_text_url = {
    'ru': "️🧾 url-encode",
    'en': "️🧾 url-encode",
    'es': "️🧾 codificación de URL",
    'fr': "️🧾 url-encoder",
    'zh': "️🧾 网址编码",
    'ar': "️🧾 عنوان url ترميز",
}
l_text_bin_attach = {
    'ru': "👩🏽‍💻 <b>Прикрепи</b> текст для преобразования в бинарный вид",
    'en': "👩🏽‍💻 <b>Attach</b> text to convert to binary",
    'es': "👩🏽‍💻 <b>Adjuntar</b> texto para convertir a binario",
    'fr': "👩🏽‍💻 <b>Joindre</b> du texte à convertir en binaire",
    'zh': "👩🏽‍💻<b>附加</b>文本以转换为二进制",
    'ar': "👩🏽‍💻 <b>إرفاق</b> نص لتحويله إلى ثنائي",
}
l_text_hex_attach = {
    'ru': "👩🏽‍💻 <b>Прикрепи</b> текст для преобразования в hex-символы",
    'en': "👩🏽‍💻 <b>Attach</b> text to convert to hex characters",
    'es': "👩🏽‍💻 <b>Adjuntar</b> texto para convertir a caracteres hexadecimales",
    'fr': "👩🏽‍💻 <b>Joindre</b> du texte à convertir en caractères hexadécimaux",
    'zh': "👩🏽‍💻<b>附加</b>文本以转换为十六进制字符",
    'ar': "👩🏽‍💻 <b>إرفاق</b> نص لتحويله إلى أحرف سداسية عشرية",
}
l_text_mp3_attach = {
    'ru': "👩🏽‍💻 <b>Прикрепи</b> текст для преобразования в голосовое",
    'en': "👩🏽‍💻 <b>Attach</b> text to convert to voice",
    'es': "👩🏽‍💻 <b>Adjuntar</b> texto para convertir a voz",
    'fr': "👩🏽‍💻 <b>Joindre</b> du texte à convertir en voix",
    'zh': "👩🏽‍💻<b>附加</b>文本以转换为语音",
    'ar': "👩🏽‍💻 <b>إرفاق</b> نص لتحويله إلى صوت",
}
l_text_url_attach = {
    'ru': "👩🏽‍💻 <b>Прикрепи</b> текст для url-encode-преобразования",
    'en': "👩🏽‍💻 <b>Attach</b> text for url-encode conversion",
    'es': "👩🏽‍💻 <b>Adjunte</b> texto para la conversión de codificación URL",
    'fr': "👩🏽‍💻 <b>Joindre</b> du texte pour la conversion en url-encode",
    'zh': "👩🏽‍💻<b>附加</b>文本进行 url-encode 转换",
    'ar': "👩🏽‍💻 <b>إرفاق</b> نص لتحويل ترميز url",
}
l_text_text1024 = {
    'ru': "💭 Текст 1024 символа",
    'en': "💭 Text 1024 characters",
    'es': "💭 Texto 1024 caracteres",
    'fr': "💭 Texte 1024 caractères",
    'zh': "💭 文本 1024 个字符",
    'ar': "💭 نص 1024 حرفًا",
}
l_text_text4096 = {
    'ru': "🗯️ Текст 4096 символа",
    'en': "🗯️ Text 4096 characters",
    'es': "🗯️ Texto 4096 caracteres",
    'fr': "🗯️ Texte 4096 caractères",
    'zh': "🗯️ 文本 4096 个字符",
    'ar': "🗯️ نص 4096 حرفًا",
}

l_convert_error = {
    'ru': "👩🏽‍💻 <b>Ошибка</b> преобразования контента (попробуй позже и загрузи другой файл)",
    'en': "👩🏽‍💻 Content conversion <b>error</b> (try later and upload another file)",
    'es': "👩🏽‍💻 <b>Error</b> de conversión de contenido (intente más tarde y cargue otro archivo)",
    'fr': "👩🏽‍💻 <b>Erreur</b> de conversion de contenu (essayez plus tard et téléchargez un autre fichier)",
    'zh': "👩🏽‍💻内容转换<b>错误</b>（稍后再试并上传另一个文件）",
    'ar': "👩🏽‍💻 <b>خطأ</b> في تحويل المحتوى (حاول لاحقًا وقم بتحميل ملف آخر)",
}
l_telegraph_text = {
    'ru': "👩🏽‍💻 <b>Прикрепи</b> .jpg/.png/.gif/.mp4 - контент, чтобы создать ссылку",
    'en': "👩🏽‍💻 <b>Attach</b> .jpg/.png/.gif/.mp4 content to create a link",
    'es': "👩🏽‍💻 <b>Adjunte</b> contenido .jpg/.png/.gif/.mp4 para crear un enlace",
    'fr': "👩🏽‍💻 <b>Joignez</b> du contenu .jpg/.png/.gif/.mp4 pour créer un lien",
    'zh': "👩🏽‍💻<b>附加</b>.jpg/.png/.gif/.mp4 内容以创建链接",
    'ar': "👩🏽‍💻 <b>أرفق</b> محتوى .jpg / .png / .gif / .mp4 لإنشاء ارتباط",
}
l_telegraph_error = {
    'ru': "👩🏽‍💻 <b>Ошибка</b> получения ссылки (попробуй позже или загрузи другой файл)",
    'en': "👩🏽‍💻 <b>Failed</b> to get link (try later and upload another file)",
    'es': "👩🏽‍💻 <b>No se pudo</b> obtener el enlace (intente más tarde y cargue otro archivo)",
    'fr': "👩🏽‍💻 <b>Échec</b> de l'obtention du lien (essayez plus tard et téléchargez un autre fichier)",
    'zh': "👩🏽‍💻 获取链接<b>失败</b>（稍后再试并上传另一个文件）",
    'ar': "👩🏽‍💻 <b>فشل</b> الحصول على الرابط (حاول لاحقًا وقم بتحميل ملف آخر)",
}
l_json_text = {
    'ru': "👩🏽‍💻 <b>Прикрепи</b> любое сообщение или сделай пересылку",
    'en': "👩🏽‍💻 <b>Attach</b> any message or forward",
    'es': "👩🏽‍💻 <b>Adjunte</b> cualquier mensaje o reenvíe",
    'fr': "👩🏽‍💻 <b>Joindre</b> n'importe quel message ou transférer",
    'zh': "👩🏽‍💻<b>附上</b>任何讯息或转发",
    'ar': "👩🏽‍💻 <b>إرفاق</b> أي رسالة أو إعادة توجيهها",
}
# endregion


# region FereyTargetBot
l_subscribe_target = {
    'ru': "👩🏽‍💻 <b>Оформи</b> ежемесячную <i>подписку</i>:\n\n¹ [<b>Все боты</b> и проекты (-<u>5</u>%)]\n² [<b>Донат</b> на баланс]:\n▪️рассылка/приглашения\n▪️редактирование чаевых\n(<i>чтобы указать точную сумму</i>)\n\n👩🏽‍💻 /balance",
    'en': "👩🏽‍💻 <b>Оформи</b> ежемесячную <i>подписку</i>:\n\n¹ [<b>Все боты</b> и проекты (-<u>5</u>%)]\n² [<b>Донат</b> на баланс]:\n▪️возможность сделать рассылку по всем ботам\n▪️измените значение чаевых (<i>чтобы указать точную сумму</i>)\n\n👩🏽‍💻 /balance",
    'es': "👩🏽‍💻 <b>Regístrese para obtener</b> una\n\n¹ <i>suscripción</i> mensual a @{0}-bot [{1} ₽]\n▪️ sin anuncios\n▪️ tareas creativas\n² Suscríbase a <u>todos</u> los bots [{2} ₽]",
    'fr': "👩🏽‍💻 <b>Inscrivez-vous pour</b> un <i>abonnement</i>\n\n¹ mensuel à @{0}-bot [{1} ₽]\n▪️ pas de publicité\n▪️ tâches créatives\n² Abonnez-vous à <u>tous</u> les bots [{2} ₽]",
    'zh': "👩🏽‍💻<b>注册</b>每月\n\n¹<i>订阅</i>@{0}-bot [{1} ₽]\n▪️ 无广告\n▪️ 创意任务\n² 订阅<u>所有</u>机器人 [{2} ₽]",
    'ar': "👩🏽‍💻 <b>اشترك للحصول على</b> <i>اشتراك</i> شهري\n\n¹ في @ {0} -bot [{1} ₽]\n▪️ بلا إعلانات\n▪️ مهام إبداعية\n² اشترك في <u>جميع</u> برامج التتبُّع [{2} ₽]",
}
# endregion


# region FereyAdsBot
l_ads_btn1 = {
    'ru': "⛰️ Посты",
    'en': "⛰️ Posts",
    'es': "⛰️ Publicaciones",
    'fr': "⛰️ Messages",
    'zh': "⛰️ 帖子",
    'ar': "⛰️ المشاركات",
}
l_ads_btn2 = {
    'ru': "🌬 Подписка",
    'en': "🌬 Subscription",
    'es': "🌬 Suscripción",
    'fr': "🌬 Abonnement",
    'zh': "🌬订阅",
    'ar': "🌬 الاشتراك",
}
l_ads_welcome = {
    'ru': "🌱 {0}, добро пожаловать в <i>лендинг-бот</i> для создания креативных постов <b>Ferey</b>\n\n▪️️реклама во всех Ferey-ботах\n▪️️заказ рекламы на канале\n\n❗️Регулярно-обновляемый /content",
    'en': "🌱 {0}, welcome to <i>the landing bot</i> for creating creative постов <b>Ferey</b>\n\n▪️️advertising in all Ferey bots\n▪️️ ordering advertising on the channel\n\n❗️you can also order the development of a chat bot in our Ferey studio",
    'es': "🌱 {0}, bienvenido <i>al bot de aterrizaje</i> para crear постов creativas <b>Ferey</b>\n\n▪️️publicidad en todos los bots de Ferey\n▪️️solicitando publicidad en el canal\n\n❗️también puedes ordenar el desarrollo de un chatbot en nuestro estudio Ferey",
    'fr': "🌱 {0}, bienvenue dans <i>le bot de débarquement</i> pour la création постов créatives <b>Ferey</b>\n\n▪️️publicité dans tous les bots Ferey\n▪️️commande de publicité sur la chaîne\n\n❗️vous pouvez également commander le développement d'un chat bot dans notre studio Ferey",
    'zh': "🌱 {0}，欢迎来到<b>Ferey</b>创建创意постов的<i>登陆机器人</i>\n\n▪️️在所有 Ferey 机器人中投放广告\n▪️️ 在频道订购广告\n\n❗️您也可以在以下订购聊天机器人的开发我们的Ferey工作室",
    'ar': "🌱 {0} ، مرحبًا بك في <i>روبوت الهبوط</i> لإنشاء постов إبداعية <b>Ferey</b>\n\nالإعلان في جميع برامج Ferey\n▪️️ طلب الإعلانات على القناة\n\n❗️ يمكنك أيضًا طلب تطوير روبوت محادثة في استوديو Ferey الخاص بنا",
}
l_subscribe_ads = {
    'ru': "👩🏽‍💻 <b>Оформи</b> ежемесячную <i>подписку</i>:\n\n¹ [<b>Все боты</b> и проекты (-<u>5</u>%)]\n² [<b>Донат</b> на баланс]:\n▪️рассылка по всем ботам\n▪️редактирование чаевых\n(<i>чтобы указать точную сумму</i>)\n\n👩🏽‍💻 /balance",
    'en': "👩🏽‍💻 <b>Оформи</b> ежемесячную <i>подписку</i>:\n\n¹ [<b>Все боты</b> и проекты (-<u>5</u>%)]\n² [<b>Донат</b> на баланс]:\n▪️возможность сделать рассылку по всем ботам\n▪️измените значение чаевых (<i>чтобы указать точную сумму</i>)\n\n👩🏽‍💻 /balance",
    'es': "👩🏽‍💻 <b>Regístrese para obtener</b> una\n\n¹ <i>suscripción</i> mensual a @{0}-bot [{1} ₽]\n▪️ sin anuncios\n▪️ tareas creativas\n² Suscríbase a <u>todos</u> los bots [{2} ₽]",
    'fr': "👩🏽‍💻 <b>Inscrivez-vous pour</b> un <i>abonnement</i>\n\n¹ mensuel à @{0}-bot [{1} ₽]\n▪️ pas de publicité\n▪️ tâches créatives\n² Abonnez-vous à <u>tous</u> les bots [{2} ₽]",
    'zh': "👩🏽‍💻<b>注册</b>每月\n\n¹<i>订阅</i>@{0}-bot [{1} ₽]\n▪️ 无广告\n▪️ 创意任务\n² 订阅<u>所有</u>机器人 [{2} ₽]",
    'ar': "👩🏽‍💻 <b>اشترك للحصول على</b> <i>اشتراك</i> شهري\n\n¹ في @ {0} -bot [{1} ₽]\n▪️ بلا إعلانات\n▪️ مهام إبداعية\n² اشترك في <u>جميع</u> برامج التتبُّع [{2} ₽]",
}

l_post_media_ads = {
    'ru': "✏️ 2. Прикрепи <b>медиа</b> контент: фото/гиф/видео до 5Mb\n\n(<i>или нажми «➡️️/Next», чтобы пропустить этот шаг</i>)",
    'en': "✏️ 2. Attach <b>media</b> content: photo/gif/video up to 5Mb\n\n( <i>or press &quot;➡️️/Next&quot; to skip this step</i> )",
    'es': "✏️ 2. Adjunte contenido <b>multimedia</b> : foto/gif/video de hasta 5 Mb\n\n( <i>o presione &quot;➡️️/Siguiente&quot; para omitir este paso</i> )",
    'fr': "✏️ 2. Joignez du contenu <b>multimédia</b> : photo/gif/vidéo jusqu&#x27;à 5 Mb\n\n( <i>ou appuyez sur &quot;➡️️/Suivant&quot; pour ignorer cette étape</i> )",
    'zh': "✏️ 2.附加<b>媒体</b>内容：照片/gif/视频最大5Mb\n\n（<i>或按“➡️️/Next”跳过此步骤</i>）",
    'ar': "✏️ 2. إرفاق محتوى <b>وسائط</b> : صورة / صورة / فيديو بحجم يصل إلى 5 ميغا بايت\n\n( <i>أو اضغط على &quot;➡️️ / التالي&quot; لتخطي هذه الخطوة</i> )",
}
# endregion


# region FereyDemoBot
l_demo_btn1 = {
    'ru': "⛰️ Проекты",
    'en': "⛰️ Projects",
    'es': "⛰️ Proyectos",
    'fr': "⛰️ Projets",
    'zh': "⛰️ 项目",
    'ar': "⛰️ المشاريع",
}
l_demo_btn2 = {
    'ru': "🌬 Подписка",
    'en': "🌬 Subscription",
    'es': "🌬 Suscripción",
    'fr': "🌬 Abonnement",
    'zh': "🌬订阅",
    'ar': "🌬 الاشتراك",
}
l_demo_welcome = {
    'ru': "🌱 {0}, добро пожаловать в <i>лендинг-бот</i> проекта <b>Ferey</b>:\n\n▪️<b>информация</b> обо всех проектах\n\n❗️Регулярно-обновляемый /content",
    'en': "🌱 {0}, welcome to <i>the landing bot</i> of the <b>Ferey</b> проекта :\n\n▪️ <b>information</b> about all projects\n\n❗️ you can also order the development of a chat bot in our Ferey studio",
    'es': "🌱 {0}, bienvenido al <i>bot de aterrizaje</i> del проекта <b>Ferey</b> :\n\n▪️ <b>información</b> sobre todos los proyectos\n\n❗️ también puedes solicitar el desarrollo de un bot de chat en nuestro estudio Ferey",
    'fr': "🌱 {0}, bienvenue sur <i>le landing bot</i> du проекта <b>Ferey</b> :\n\n▪️ <b>informations</b> sur tous les projets\n\n❗️ vous pouvez également commander le développement d'un chat bot dans notre studio Ferey",
    'zh': "🌱 {0}，欢迎来到<b>Ferey</b> проекта的<i>落地机器人</i>：\n\n▪️ 所有项目的<b>信息</b>\n\n❗️ 您也可以在我们的Ferey工作室订购聊天机器人的开发",
    'ar': "🌱 {0} ، مرحبًا بك في <i>روبوت الهبوط</i> الخاص проекта <b>Ferey</b> :\n\n▪️ <b>معلومات</b> حول جميع المشاريع\n\n❗️ يمكنك أيضًا طلب تطوير روبوت محادثة في استوديو Ferey الخاص بنا",
}
l_subscribe_demo = {
    'ru': "👩🏽‍💻 <b>Оформи</b> ежемесячную <i>подписку</i>:\n\n¹ [<b>Все боты</b> и проекты (-<u>5</u>%)]\n\n👩🏽‍💻 /balance",
    'en': "👩🏽‍💻 <b>Sign up for</b> a monthly\n\n¹ <i>subscription</i> to @{0}-bot [{1} ₽]\n▪️ no ads\n▪️ creative tasks\n² Subscribe to <u>all</u> bots [{2} ₽]",
    'es': "👩🏽‍💻 <b>Regístrese para obtener</b> una\n\n¹ <i>suscripción</i> mensual a @{0}-bot [{1} ₽]\n▪️ sin anuncios\n▪️ tareas creativas\n² Suscríbase a <u>todos</u> los bots [{2} ₽]",
    'fr': "👩🏽‍💻 <b>Inscrivez-vous pour</b> un <i>abonnement</i>\n\n¹ mensuel à @{0}-bot [{1} ₽]\n▪️ pas de publicité\n▪️ tâches créatives\n² Abonnez-vous à <u>tous</u> les bots [{2} ₽]",
    'zh': "👩🏽‍💻<b>注册</b>每月\n\n¹<i>订阅</i>@{0}-bot [{1} ₽]\n▪️ 无广告\n▪️ 创意任务\n² 订阅<u>所有</u>机器人 [{2} ₽]",
    'ar': "👩🏽‍💻 <b>اشترك للحصول على</b> <i>اشتراك</i> شهري\n\n¹ في @ {0} -bot [{1} ₽]\n▪️ بلا إعلانات\n▪️ مهام إبداعية\n² اشترك في <u>جميع</u> برامج التتبُّع [{2} ₽]",
}

l_kind_1 = {
    'ru': "<b>👩🏽‍💻@FereyDemoBot</b>\n\n<b>Демо</b> бот всех проектов",
    'en': "<b>👩🏽‍💻</b> <b>@FereyDemoBot</b>\n\nDemo bot of all projects",
    'es': "<b>👩🏽‍💻</b> <b>@FereyDemoBot</b>\n\nBot de demostración de todos los proyectos",
    'fr': "<b>👩🏽‍💻</b> <b>@FereyDemoBot</b>\n\nDemo bot de tous les projets",
    'zh': "<b>👩🏽‍💻</b> <b>@FereyDemoBot</b>\n\n所有项目的演示机器人",
    'ar': "<b>👩🏽‍💻FereyDemoBot</b>\n\nروبوت تجريبي <b>@FereyDemoBot</b> المشاريع",
}
l_kind_2 = {
    'ru': "<b>👩🏽‍💻@FereyBotBot</b>\n\n<b>Конструктор</b> ботов:\n▪️авто-генерация бота\n▪️авто-генерация контента (open-ai)\n▪️авто-бан/перевод/рассылка",
    'en': "<b>👩🏽‍💻</b> <b>@FereyBotBot</b>\n\nBot Builder:\n▪️auto-generate bot\n▪️auto-generate content (open-ai)\n▪️auto-ban/auto-translate",
    'es': "<b>👩🏽‍💻</b> <b>@FereyBotBot</b>\n\nGenerador de bots:\n▪️generación automática de bot\n▪️generación automática de contenido (open-ai)\n▪️prohibición automática/traducción automática",
    'fr': "<b>👩🏽‍💻</b> <b>@FereyBotBot</b>\n\nBot Builder :\n▪️auto-génère le bot\n▪️auto-génère le contenu (open-ai)\n▪️auto-ban/auto-translate",
    'zh': "<b>👩🏽‍💻</b> <b>@FereyBotBot</b>\n\nBot Builder：\n▪️自动生成机器人\n▪️自动生成内容（open-ai）\n▪️自动禁止/自动翻译",
    'ar': "<b>👩🏽‍💻FereyBotBot</b>\n\nBot Builder:\n▪️ إنشاء روبوت تلقائيًا <b>@FereyBotBot</b> n▪️ إنشاء محتوى تلقائيًا (فتح ai)\n▪️ حظر تلقائي / ترجمة آلية",
}
l_kind_3 = {
    'ru': "<b>👩🏽‍💻@FereyChannelBot</b>\n\n<b>Администрирование</b> каналов:\n▪️авто-постинг\n▪️авто-декор",
    'en': "<b>👩🏽‍💻</b> <b>@FereyChannelBot</b>\n\nChannel admin:\n▪️auto-posting\n▪️auto-decor",
    'es': "<b>👩🏽‍💻</b> <b>@FereyChannelBot</b>\n\nAdministrador del canal:\n▪️publicación automática\n▪️decoración automática",
    'fr': "<b>👩🏽‍💻</b> <b>@FereyChannelBot</b>\n\nAdministrateur de la chaîne :\n▪️publication automatique\n▪️décoration automatique",
    'zh': "<b>👩🏽‍💻</b> <b>@FereyChannelBot</b>\n\n频道管理员：\n▪️自动发布\n▪️自动装饰",
    'ar': "<b>👩🏽‍💻FereyChannelBot</b>\n\nمسؤول القناة:\nنشر تلقائي <b>@FereyChannelBot</b> n ديكور تلقائي",
}
l_kind_4 = {
    'ru': "<b>👩🏽‍💻@FereyGroupBot</b>\n\n<b>Модерация</b> групп:\n▪️авто-постинг\n▪️модерация",
    'en': "<b>👩🏽‍💻</b> <b>@FereyGroupBot</b>\n\nGroup admin:\n▪️auto-posting\n▪️moderation",
    'es': "<b>👩🏽‍💻</b> <b>@FereyGroupBot</b>\n\nAdministrador del grupo:\n▪️publicación automática\n▪️moderación",
    'fr': "<b>👩🏽‍💻</b> <b>@FereyGroupBot</b>\n\nAdministrateur du groupe :\n▪️publication automatique\n▪️modération",
    'zh': "<b>👩🏽‍💻</b> <b>@FereyGroupBot</b>\n\n群组管理员：\n▪️自动发布\n▪️审核",
    'ar': "<b>👩🏽‍💻FereyGroupBot</b>\n\n<b>@FereyGroupBot</b> المجموعة:\nنشر تلقائي\n▪️ تعديل",
}
l_kind_5 = {
    'ru': "<b>👩🏽‍💻@FereyUserBot</b>\n\n<b>Автоматизация</b> пользователей:\n▪️авто-постинг\n▪️авто-декор",
    'en': "<b>👩🏽‍💻</b> <b>@FereyUserBot</b>\n\nUser Admin:\n▪️auto-posting\n▪️auto-decor",
    'es': "<b>👩🏽‍💻</b> <b>@FereyUserBot</b>\n\nAdministrador de usuarios:\n▪️publicación automática\n▪️decoración automática",
    'fr': "<b>👩🏽‍💻</b> <b>@FereyUserBot</b>\n\nAdministrateur utilisateur :\n▪️publication automatique\n▪️décoration automatique",
    'zh': "<b>👩🏽‍💻</b> <b>@FereyUserBot</b>\n\n用户管理员：\n▪️自动发布\n▪️自动装饰",
    'ar': "<b>👩🏽‍💻FereyUserBot</b>\n\nمسؤول المستخدم:\nنشر <b>@FereyUserBot</b>\nديكور تلقائي",
}
l_kind_6 = {
    'ru': "<b>👩🏽‍💻@FereyPostBot</b>\n\n<b>Приватные посты</b>:\n▪️превью\n▪️галерея",
    'en': "<b>👩🏽‍💻</b> <b>@FereyPostBot</b>\n\nQuick post creation and publishing:\n▪️preview\n▪️gallery",
    'es': "<b>👩🏽‍💻</b> <b>@FereyPostBot</b>\n\nCreación y publicación rápidas de publicaciones:\n▪️vista previa\n▪️galería",
    'fr': "<b>👩🏽‍💻</b> <b>@FereyPostBot</b>\n\nCréation et publication rapides d'articles :\n▪️aperçu\n▪️galerie",
    'zh': "<b>👩🏽‍💻</b> <b>@FereyPostBot</b>\n\n快速创建和发布帖子：\n▪️预览\n▪️图库",
    'ar': "<b>👩🏽‍💻FereyPostBot</b>\n\nإنشاء منشور سريع <b>@FereyPostBot</b> :\nمعاينة\n▪️ معرض",
}
l_kind_7 = {
    'ru': "<b>👩🏽‍💻@FereyFindBot</b>\n\n<b>Поиск</b> по каналам/группам/пользователям/ботам:\n▪️отслеживание постов\n▪️гео-поиск",
    'en': "<b>👩🏽‍💻</b> <b>@FereyFindBot</b>\n\nSearch by channels/groups/users/bots:\n▪️post tracking\n▪️geo-search",
    'es': "<b>👩🏽‍💻</b> <b>@FereyFindBot</b>\n\nBuscar por canales/grupos/usuarios/bots:\n▪️seguimiento de publicaciones\n▪️búsqueda geográfica",
    'fr': "<b>👩🏽‍💻</b> <b>@FereyFindBot</b>\n\nRecherche par canaux/groupes/utilisateurs/bots :\n▪️suivi des publications\n▪️géo-recherche",
    'zh': "<b>👩🏽‍💻</b> <b>@FereyFindBot</b>\n\n按频道/群组/用户/机器人搜索：\n▪️post tracking\n▪️geo-search",
    'ar': "<b>👩🏽‍💻FereyFindBot</b>\n\nالبحث عن طريق القنوات / المجموعات <b>@FereyFindBot</b> المستخدمين / الروبوتات:\n▪️ تتبع المنشور\n▪️ البحث الجيو",
}
l_kind_8 = {
    'ru': "<b>👩🏽‍💻@FereyMediaBot</b>\n\n<b>Медиа-заметки</b>:\n▪️аудио/️видео-заметки\n▪️текст/фото-стикеры",
    'en': "<b>👩🏽‍💻</b> <b>@FereyMediaBot</b>\n\nBot with popular creatives:\n▪️audio notes\n▪️video notes",
    'es': "<b>👩🏽‍💻</b> <b>@FereyMediaBot</b>\n\nBot con creatividades populares:\n▪️notas de audio\n▪️notas de video",
    'fr': "<b>👩🏽‍💻</b> <b>@FereyMediaBot</b>\n\nBot avec des créations populaires :\n▪️notes audio\n▪️notes vidéo",
    'zh': "<b>👩🏽‍💻</b> <b>@FereyMediaBot</b>\n\n具有流行创意的机器人：\n▪️音频笔记\n▪️视频笔记",
    'ar': "<b>👩🏽‍💻FereyMediaBot</b>\n\nاستخدام التصميمات المشهورة:\n▪️ ملاحظات <b>@FereyMediaBot</b>\n▪️ ملاحظات الفيديو",
}
l_kind_9 = {
    'ru': "<b>👩🏽‍💻@FereyVPNBot</b>\n\n<b>Настройка</b>VPN",
    'en': "<b>👩🏽‍💻</b> <b>@FereyVpnBot</b>\n\nAll about VPN",
    'es': "<b>👩🏽‍💻</b> <b>@FereyVpnBot</b>\n\nTodo sobre VPN",
    'fr': "<b>👩🏽‍💻</b> <b>@FereyVpnBot</b>\n\nTout sur le VPN",
    'zh': "<b>👩🏽‍💻</b> <b>@FereyVpnBot</b>\n\n关于 VPN",
    'ar': "<b>👩🏽‍💻FereyVpnBot</b> <b>@FereyVpnBot</b> n\nكل شيء عن VPN",
}
l_kind_10 = {
    'ru': "<b>👩🏽‍💻@FereyTargetBot</b>\n\n<b>Таргет</b> сообщений/пользователей",
    'en': "<b>👩🏽‍💻</b> <b>@FereyTargetBot</b>\n\nTargeted email",
    'es': "<b>👩🏽‍💻</b> <b>@FereyTargetBot</b>\n\nCorreo electrónico dirigido",
    'fr': "<b>👩🏽‍💻</b> <b>@FereyTargetBot</b>\n\nE-mail ciblé",
    'zh': "<b>👩🏽‍💻</b> <b>@FereyTargetBot</b>\n\n目标电子邮件",
    'ar': "<b>👩🏽‍💻FereyTargetBot</b> \ <b>@FereyTargetBot</b>\nالبريد الإلكتروني المستهدف",
}
l_kind_11 = {
    'ru': "<b>👩🏽‍💻@FereyToolsBot</b>\n\n<b>Телеграм инструменты</b>:\n▪️конвертация файлов\n▪️шаблоны",
    'en': "<b>👩🏽‍💻</b> <b>@FereyToolsBot</b>\n\nTool bot:\n▪️convert\n▪️download",
    'es': "<b>👩🏽‍💻</b> <b>@FereyToolsBot</b>\n\nHerramienta bot:\n▪️convertir\n▪️descargar",
    'fr': "<b>👩🏽‍💻</b> <b>@FereyToolsBot</b>\n\nBot outil :\n▪️convertir\n▪️télécharger",
    'zh': "<b>👩🏽‍💻</b> <b>@FereyToolsBot</b>\n\n工具机器人：\n▪️转换\n▪️下载",
    'ar': "<b>👩🏽‍💻FereyToolsBot</b>\n\ <b>@FereyToolsBot</b> بوت الأداة:\n▪️ تحويل\n▪️ تحميل",
}
l_kind_12 = {
    'ru': "<b>👩🏽‍💻@FereyAIBot</b>\n\n<b>Нейросеть</b> генерации контента (open-ai):\n▪️chat-gpt\n▪️dalli·e",
    'en': "<b>👩🏽‍💻</b> <b>@FereyAIBot</b>\n\nContent generation bot (open-ai):\n▪️chat-gpt\n▪️dalli e",
    'es': "<b>👩🏽‍💻</b> <b>@FereyAIBot</b>\n\nBot de generación de contenido (open-ai):\n▪️chat-gpt\n▪️dalli e",
    'fr': "<b>👩🏽‍💻</b> <b>@FereyAIBot</b>\n\nBot de génération de contenu (open-ai) :\n▪️chat-gpt\n▪️dalli e",
    'zh': "<b>👩🏽‍💻</b> <b>@FereyAIBot</b>\n\n内容生成机器人（open-ai）：\n▪️chat-gpt\n▪️dalli e",
    'ar': "<b>👩🏽‍💻FereyAIBot</b>\n\nروبوت إنشاء المحتوى (open <b>@FereyAIBot</b> ai):\n▪️chat-gpt\n▪️dalli e",
}
l_kind_13 = {
    'ru': "<b>👩🏽‍💻@FereyAdsBot</b>\n\n<b>Реклама</b> в:\n▪️ботах",
    'en': "<b>👩🏽‍💻</b> <b>@FereyAdsBot</b>\n\nBot ads in:\n▪️bots\n▪️channels",
    'es': "<b>👩🏽‍💻</b> <b>@FereyAdsBot</b>\n\nAnuncios de bot en:\n▪️bots\n▪️canales",
    'fr': "<b>👩🏽‍💻</b> <b>@FereyAdsBot</b>\n\nAnnonces de robots dans :\n▪️bots\n▪️chaînes",
    'zh': "<b>👩🏽‍💻</b> <b>@FereyAdsBot</b>\n\n机器人广告在：\n▪️bots\n▪️channels",
    'ar': "<b>👩🏽‍💻FereyAdsBot</b>\n\n<b>@FereyAdsBot</b> الإعلانات في:\n▪️ الروبوتات\n▪️ القنوات",
}
l_kind_14 = {
    'ru': "<b>👩🏽‍💻@FereyWorkBot</b>\n\n<b>Рабочий</b> бот информации о:\n▪️вакансиях\n▪️соревнованиях",
    'en': "<b>👩🏽‍💻</b> <b>@FereyWorkBot</b>\n\nBot of information about:\n▪️vacancies\n▪️competitions",
    'es': "<b>👩🏽‍💻</b> <b>@FereyWorkBot</b>\n\nBot de información sobre:\n▪️vacantes\n▪️concursos",
    'fr': "<b>👩🏽‍💻</b> <b>@FereyWorkBot</b>\n\nBot d'informations sur :\n▪️offres d'emploi\n▪️concours",
    'zh': "<b>👩🏽‍💻</b> <b>@FereyWorkBot</b>\n\n有关以下信息的机器人：\n▪️职位空缺\n▪️比赛",
    'ar': "<b>👩🏽‍💻FereyWorkBot</b>\n\nبعض <b>@FereyWorkBot</b> حول:\n▪️ وظائف شاغرة\n▪️ مسابقات",
}
# endregion


# region FereyVPNBot
l_vpn_btn1 = {
    'ru': "⛰️ VPN",
    'en': "⛰️ VPN",
    'es': "⛰️VPN",
    'fr': "⛰️VPN",
    'zh': "⛰️ VPN",
    'ar': "⛰️ VPN",
}
l_vpn_btn2 = {
    'ru': "🌬 Подписка",
    'en': "🌬 Subscription",
    'es': "🌬 Suscripción",
    'fr': "🌬 Abonnement",
    'zh': "🌬订阅",
    'ar': "🌬 الاشتراك",
}
l_vpn_welcome = {
    'ru': "🌱 {0}, добро пожаловать в <i>лендинг-бот</i> проекта Ferey:\n\n▪️<b>openvpn</b>\n▪️<b>wireguard</b>\n\n❗️Регулярно-обновляемый /content",
    'en': "🌱 {0}, welcome to <i>the landing bot</i> of the Ferey project:\n\n▪️ <b>openvpn</b>\n▪️ <b>wireguard</b>\n\n❗️ you can also order the development of a chat bot in our Ferey studio",
    'es': "🌱 {0}, bienvenido al <i>bot de aterrizaje</i> del proyecto Ferey:\n\n▪️ <b>openvpn</b>\n▪️ <b>wireguard</b>\n\n❗️ también puedes encargar el desarrollo de un chat bot en nuestro estudio Ferey",
    'fr': "🌱 {0}, bienvenue sur <i>le landing bot</i> du projet Ferey :\n\n▪️ <b>openvpn</b>\n▪️ <b>wireguard</b>\n\n❗️ vous pouvez également commander le développement d'un chat bot dans notre studio Ferey",
    'zh': "🌱 {0}，欢迎来到 Ferey 项目的<i>落地机器人</i>：\n\n▪️ <b>openvpn</b>\n▪️ <b>wireguard</b>\n\n❗️您也可以在我们的Ferey工作室订购聊天机器人的开发",
    'ar': "🌱 {0} ، مرحبًا بك في <i>روبوت الهبوط</i> الخاص بمشروع Ferey:\n\n▪️ <b>openvpn</b>\n▪️ <b>wireguard</b>\n\n❗️ يمكنك أيضًا طلب تطوير روبوت محادثة في استوديو Ferey",
}
l_subscribe_vpn = {
    'ru': "👩🏽‍💻 <b>Оформи</b> ежемесячную <i>подписку</i>:\n\n¹ [<b>Все боты</b> и проекты (-<u>5</u>%)]\n\n👩🏽‍💻 /balance",
    'en': "👩🏽‍💻 <b>Sign up for</b> a monthly\n\n¹ <i>subscription</i> to @{0}-bot [{1} ₽]\n▪️ no ads\n▪️ creative tasks\n² Subscribe to <u>all</u> bots [{2} ₽]",
    'es': "👩🏽‍💻 <b>Regístrese para obtener</b> una\n\n¹ <i>suscripción</i> mensual a @{0}-bot [{1} ₽]\n▪️ sin anuncios\n▪️ tareas creativas\n² Suscríbase a <u>todos</u> los bots [{2} ₽]",
    'fr': "👩🏽‍💻 <b>Inscrivez-vous pour</b> un <i>abonnement</i>\n\n¹ mensuel à @{0}-bot [{1} ₽]\n▪️ pas de publicité\n▪️ tâches créatives\n² Abonnez-vous à <u>tous</u> les bots [{2} ₽]",
    'zh': "👩🏽‍💻<b>注册</b>每月\n\n¹<i>订阅</i>@{0}-bot [{1} ₽]\n▪️ 无广告\n▪️ 创意任务\n² 订阅<u>所有</u>机器人 [{2} ₽]",
    'ar': "👩🏽‍💻 <b>اشترك للحصول على</b> <i>اشتراك</i> شهري\n\n¹ في @ {0} -bot [{1} ₽]\n▪️ بلا إعلانات\n▪️ مهام إبداعية\n² اشترك في <u>جميع</u> برامج التتبُّع [{2} ₽]",
}

l_vpn_1 = {
    'ru': "👩🏽‍💻 <b>Open VPN</b>\n\n{0}",
    'en': "👩🏽‍💻 <b>Open VPN</b>\n\n{0}",
    'es': "👩🏽‍💻 <b>Abrir VPN</b>\n\n{0}",
    'fr': "👩🏽‍💻 <b>Ouvrez le VPN</b>\n\n{0}",
    'zh': "👩🏽‍💻<b>打开 VPN</b>\n\n{0}",
    'ar': "👩🏽‍💻 <b>افتح VPN</b>\n\n{0}",
}
l_vpn_2 = {
    'ru': "👩🏽‍💻 <b>Wire Guard</b>\n\n{0}",
    'en': "👩🏽‍💻 <b>Wire Guard</b>\n\n{0}",
    'es': "👩🏽‍💻 <b>Protector de alambre</b>\n\n{0}",
    'fr': "👩🏽‍💻 <b>Fil de protection</b>\n\n{0}",
    'zh': "👩🏽‍💻<b>线卫士</b>\n\n{0}",
    'ar': "👩🏽‍💻 <b>واقي الأسلاك</b>\n\n{0}",
}
# endregion


# region FereyWorkBot
l_work_btn1 = {
    'ru': "⛰️ Вакансии",
    'en': "⛰️ Jobs",
    'es': "⛰️ Empleos",
    'fr': "⛰️ Emplois",
    'zh': "⛰️ 工作",
    'ar': "⛰️ وظائف",
}
l_work_btn2 = {
    'ru': "🌬 Подписка",
    'en': "🌬 Subscription",
    'es': "🌬 Suscripción",
    'fr': "🌬 Abonnement",
    'zh': "🌬订阅",
    'ar': "🌬 الاشتراك",
}
l_work_welcome = {
    'ru': "🌱 {0}, добро пожаловать в <i>лендинг-бот</i> проекта <b>Ferey</b>:\n\n▪️<b>вакансии</b> нашего стартапа\n▪️конкурсы и <b>мероприятия</b>\n\n❗️Регулярно-обновляемый /content",
    'en': "🌱 {0}, welcome to <i>the landing bot</i> of the <b>Ferey</b> проекта :\n\n▪️ <b>vacancies</b> of our startup\n▪️ contests and <b>events</b>\n\n❗️ you can also order the development of a chat bot in our Ferey studio",
    'es': "🌱 {0}, bienvenido al <i>bot de aterrizaje</i> del проекта <b>Ferey</b> :\n\n▪️ <b>vacantes</b> de nuestra startup\n▪️ concursos y <b>eventos</b>\n\n❗️ también puedes encargar el desarrollo de un chat bot en nuestro estudio Ferey",
    'fr': "🌱 {0}, bienvenue sur <i>le landing bot</i> du проекта <b>Ferey</b> :\n\n▪️ <b>offres d&#x27;emploi</b> de notre startup\n▪️ concours et <b>événements</b>\n\n❗️ vous pouvez également commander le développement d'un chat bot dans notre studio Ferey",
    'zh': "🌱 {0}，欢迎来到<b>Ferey</b> проекта的<i>登陆机器人</i>：\n\n▪️ 我们初创公司的<b>职位空缺</b>\n▪️ 竞赛和<b>活动</b>\n\n❗️ 您也可以在我们的Ferey工作室订购聊天机器人的开发",
    'ar': "🌱 {0} ، مرحبًا بك في <i>روبوت الهبوط</i> проекта <b>Ferey</b> :\n\n▪️ <b>الشواغر</b> في بدء التشغيل\n▪️ المسابقات <b>والأحداث</b>\n\n❗️ يمكنك أيضًا طلب تطوير روبوت محادثة في استوديو Ferey",
}
l_subscribe_work = {
    'ru': "👩🏽‍💻 <b>Оформи</b> ежемесячную <i>подписку</i>:\n\n¹ [<b>Все боты</b> и проекты (-<u>5</u>%)]\n\n👩🏽‍💻 /balance",
    'en': "👩🏽‍💻 <b>Sign up for</b> a monthly\n\n¹ <i>subscription</i> to @{0}-bot [{1} ₽]\n▪️ no ads\n▪️ creative tasks\n² Subscribe to <u>all</u> bots [{2} ₽]",
    'es': "👩🏽‍💻 <b>Regístrese para obtener</b> una\n\n¹ <i>suscripción</i> mensual a @{0}-bot [{1} ₽]\n▪️ sin anuncios\n▪️ tareas creativas\n² Suscríbase a <u>todos</u> los bots [{2} ₽]",
    'fr': "👩🏽‍💻 <b>Inscrivez-vous pour</b> un <i>abonnement</i>\n\n¹ mensuel à @{0}-bot [{1} ₽]\n▪️ pas de publicité\n▪️ tâches créatives\n² Abonnez-vous à <u>tous</u> les bots [{2} ₽]",
    'zh': "👩🏽‍💻<b>注册</b>每月\n\n¹<i>订阅</i>@{0}-bot [{1} ₽]\n▪️ 无广告\n▪️ 创意任务\n² 订阅<u>所有</u>机器人 [{2} ₽]",
    'ar': "👩🏽‍💻 <b>اشترك للحصول على</b> <i>اشتراك</i> شهري\n\n¹ في @ {0} -bot [{1} ₽]\n▪️ بلا إعلانات\n▪️ مهام إبداعية\n² اشترك في <u>جميع</u> برامج التتبُّع [{2} ₽]",
}

l_vacancy_1 = {
    'ru': "👩🏽‍💻 <b>Text to video ai-designer</b>\n\nTasks: create ferey-masks (realistic video) for any human\nGender: girl\nAge: less than 30\nPay: share of the company",
    'en': "👩🏽‍💻 <b>Text to video ai-designer</b>\n\nTasks: create ferey-masks (realistic video) for any human\nGender: girl\nAge: less than 30\nPay: share of the company",
    'es': "👩🏽‍💻 <b>Text to video ai-designer</b>\n\nTareas: crear máscaras ferey (video realista) para cualquier humano\nGénero: niña\nEdad: menos de 30\nPago: parte de la empresa",
    'fr': "👩🏽‍💻 <b>Text to video ai-designer</b>\n\nTâches : créer des masques de ferey (vidéo réaliste) pour tout humain\nSexe : fille\nÂge : moins de 30 ans\nPaiement : part de l'entreprise",
    'zh': "👩🏽‍💻<b>文本到视频 ai-designer</b>\n\n任务：为任何人创建 ferey-mask（逼真的视频）\n性别：女孩\n年龄：30 岁以下\n薪酬：公司股份",
    'ar': "👩🏽‍💻 <b>نص إلى فيديو مصمم ai</b>\n\nالمهام: إنشاء أقنعة ضيقة (فيديو واقعي) لأي إنسان\nالجنس: فتاة\nالعمر: أقل من 30\nالدفع: حصة الشركة",
}
l_vacancy_2 = {
    'ru': "👩🏽‍💻 <b>Content/video maker</b>\n\nTasks: generate creatives for all socials\nGender: girl\nAge: less than 30\nPay: 1 TON per 1 post for all socials",
    'en': "👩🏽‍💻 <b>Content/video maker</b>\n\nTasks: generate creatives for all socials\nGender: girl\nAge: less than 30\nPay: 1 TON per 1 post for all socials",
    'es': "👩🏽‍💻 <b>Creador de contenido/video</b>\n\nTareas: generar creatividades para todas las redes sociales\nGénero: niña\nEdad: menos de 30\nPago: 1 TON por 1 publicación para todas las redes sociales",
    'fr': "👩🏽‍💻 <b>Créateur de contenu/vidéo</b>\n\nTâches : générer des créations pour tous les réseaux sociaux\nSexe : fille\nÂge : moins de 30 ans\nPaiement : 1 TON pour 1 post pour tous les réseaux sociaux",
    'zh': "👩🏽‍💻<b>内容/视频制作者</b>\n\n任务：为所有社交生成创意\n性别：女孩\n年龄：小于 30\n报酬：所有社交每 1 个帖子 1 吨",
    'ar': "👩🏽‍💻 <b>صانع المحتوى / الفيديو</b>\n\nالمهام: إنشاء تصميمات لجميع وسائل التواصل الاجتماعي\nالجنس: فتاة\nالعمر: أقل من 30\nالدفع: 1 طن لكل مشاركة واحدة لجميع الشبكات الاجتماعية",
}
l_vacancy_3 = {
    'ru': "👩🏽‍💻 <b>Aio/pyro-gram developer</b>\n\nTasks: dev and support all projects\nGender: girl\nAge: less than 30\nPay: share of the company",
    'en': "👩🏽‍💻 <b>Aio/pyro-gram developer</b>\n\nTasks: dev and support all projects\nGender: girl\nAge: less than 30\nPay: share of the company",
    'es': "👩🏽‍💻 <b>Desarrollador Aio/pyro-gram</b>\n\nTareas: desarrollar y apoyar todos los proyectos\nGénero: niña\nEdad: menos de 30\nPago: parte de la empresa",
    'fr': "👩🏽‍💻 <b>Développeur Aio/pyro-gram</b>\n\nTâches : développement et support de tous les projets\nSexe : fille\nÂge : moins de 30 ans\nRémunération : part de l'entreprise",
    'zh': "👩🏽‍💻 <b>Aio/pyro-gram 开发者</b>\n\n任务：开发和支持所有项目\n性别：女孩\n年龄：30岁以下\n薪酬：公司股份",
    'ar': "👩🏽‍💻 <b>مطور Aio / pyro-gram</b>\n\nالمهام: تطوير ودعم جميع المشاريع\nالجنس: فتاة\nالعمر: أقل من 30\nالدفع: حصة الشركة",
}
# endregion