# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetDnsZoneResult',
    'AwaitableGetDnsZoneResult',
    'get_dns_zone',
    'get_dns_zone_output',
]

@pulumi.output_type
class GetDnsZoneResult:
    """
    A collection of values returned by getDnsZone.
    """
    def __init__(__self__, all_projects=None, attributes=None, created_at=None, description=None, email=None, id=None, masters=None, name=None, pool_id=None, project_id=None, region=None, serial=None, status=None, transferred_at=None, ttl=None, type=None, updated_at=None, version=None):
        if all_projects and not isinstance(all_projects, str):
            raise TypeError("Expected argument 'all_projects' to be a str")
        pulumi.set(__self__, "all_projects", all_projects)
        if attributes and not isinstance(attributes, dict):
            raise TypeError("Expected argument 'attributes' to be a dict")
        pulumi.set(__self__, "attributes", attributes)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if email and not isinstance(email, str):
            raise TypeError("Expected argument 'email' to be a str")
        pulumi.set(__self__, "email", email)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if masters and not isinstance(masters, list):
            raise TypeError("Expected argument 'masters' to be a list")
        pulumi.set(__self__, "masters", masters)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if pool_id and not isinstance(pool_id, str):
            raise TypeError("Expected argument 'pool_id' to be a str")
        pulumi.set(__self__, "pool_id", pool_id)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if serial and not isinstance(serial, int):
            raise TypeError("Expected argument 'serial' to be a int")
        pulumi.set(__self__, "serial", serial)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if transferred_at and not isinstance(transferred_at, str):
            raise TypeError("Expected argument 'transferred_at' to be a str")
        pulumi.set(__self__, "transferred_at", transferred_at)
        if ttl and not isinstance(ttl, int):
            raise TypeError("Expected argument 'ttl' to be a int")
        pulumi.set(__self__, "ttl", ttl)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if updated_at and not isinstance(updated_at, str):
            raise TypeError("Expected argument 'updated_at' to be a str")
        pulumi.set(__self__, "updated_at", updated_at)
        if version and not isinstance(version, int):
            raise TypeError("Expected argument 'version' to be a int")
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="allProjects")
    def all_projects(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "all_projects")

    @_builtins.property
    @pulumi.getter
    def attributes(self) -> Mapping[str, _builtins.str]:
        """
        Attributes of the DNS Service scheduler.
        """
        return pulumi.get(self, "attributes")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        The time the zone was created.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def email(self) -> Optional[_builtins.str]:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "email")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def masters(self) -> Sequence[_builtins.str]:
        """
        An array of master DNS servers. When `type` is  `SECONDARY`.
        """
        return pulumi.get(self, "masters")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="poolId")
    def pool_id(self) -> _builtins.str:
        """
        The ID of the pool hosting the zone.
        """
        return pulumi.get(self, "pool_id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.str:
        """
        The project ID that owns the zone.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def serial(self) -> _builtins.int:
        """
        The serial number of the zone.
        """
        return pulumi.get(self, "serial")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="transferredAt")
    def transferred_at(self) -> _builtins.str:
        """
        The time the zone was transferred.
        """
        return pulumi.get(self, "transferred_at")

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> Optional[_builtins.int]:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "ttl")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> _builtins.str:
        """
        The time the zone was last updated.
        """
        return pulumi.get(self, "updated_at")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.int:
        """
        The version of the zone.
        """
        return pulumi.get(self, "version")


class AwaitableGetDnsZoneResult(GetDnsZoneResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDnsZoneResult(
            all_projects=self.all_projects,
            attributes=self.attributes,
            created_at=self.created_at,
            description=self.description,
            email=self.email,
            id=self.id,
            masters=self.masters,
            name=self.name,
            pool_id=self.pool_id,
            project_id=self.project_id,
            region=self.region,
            serial=self.serial,
            status=self.status,
            transferred_at=self.transferred_at,
            ttl=self.ttl,
            type=self.type,
            updated_at=self.updated_at,
            version=self.version)


def get_dns_zone(all_projects: Optional[_builtins.str] = None,
                 attributes: Optional[Mapping[str, _builtins.str]] = None,
                 created_at: Optional[_builtins.str] = None,
                 description: Optional[_builtins.str] = None,
                 email: Optional[_builtins.str] = None,
                 masters: Optional[Sequence[_builtins.str]] = None,
                 name: Optional[_builtins.str] = None,
                 pool_id: Optional[_builtins.str] = None,
                 project_id: Optional[_builtins.str] = None,
                 region: Optional[_builtins.str] = None,
                 serial: Optional[_builtins.int] = None,
                 status: Optional[_builtins.str] = None,
                 transferred_at: Optional[_builtins.str] = None,
                 ttl: Optional[_builtins.int] = None,
                 type: Optional[_builtins.str] = None,
                 updated_at: Optional[_builtins.str] = None,
                 version: Optional[_builtins.int] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDnsZoneResult:
    """
    Use this data source to get the ID of an available OpenStack DNS zone.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_openstack as openstack

    zone1 = openstack.dns.get_dns_zone(name="example.com")
    ```


    :param _builtins.str all_projects: Try to obtain zone ID by listing all projects
           (requires admin role by default, depends on your policy configuration)
    :param Mapping[str, _builtins.str] attributes: Attributes of the DNS Service scheduler.
    :param _builtins.str created_at: The time the zone was created.
    :param _builtins.str description: A description of the zone.
    :param _builtins.str email: The email contact for the zone record.
    :param Sequence[_builtins.str] masters: An array of master DNS servers. When `type` is  `SECONDARY`.
    :param _builtins.str name: The name of the zone.
    :param _builtins.str pool_id: The ID of the pool hosting the zone.
    :param _builtins.str project_id: The ID of the project the DNS zone is obtained from,
           sets `X-Auth-Sudo-Tenant-ID` header (requires an assigned user role in target project)
    :param _builtins.str region: The region in which to obtain the V2 DNS client.
           A DNS client is needed to retrieve zone ids. If omitted, the
           `region` argument of the provider is used.
    :param _builtins.int serial: The serial number of the zone.
    :param _builtins.str status: The zone's status.
    :param _builtins.str transferred_at: The time the zone was transferred.
    :param _builtins.int ttl: The time to live (TTL) of the zone.
    :param _builtins.str type: The type of the zone. Can either be `PRIMARY` or `SECONDARY`.
    :param _builtins.str updated_at: The time the zone was last updated.
    :param _builtins.int version: The version of the zone.
    """
    __args__ = dict()
    __args__['allProjects'] = all_projects
    __args__['attributes'] = attributes
    __args__['createdAt'] = created_at
    __args__['description'] = description
    __args__['email'] = email
    __args__['masters'] = masters
    __args__['name'] = name
    __args__['poolId'] = pool_id
    __args__['projectId'] = project_id
    __args__['region'] = region
    __args__['serial'] = serial
    __args__['status'] = status
    __args__['transferredAt'] = transferred_at
    __args__['ttl'] = ttl
    __args__['type'] = type
    __args__['updatedAt'] = updated_at
    __args__['version'] = version
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('openstack:dns/getDnsZone:getDnsZone', __args__, opts=opts, typ=GetDnsZoneResult).value

    return AwaitableGetDnsZoneResult(
        all_projects=pulumi.get(__ret__, 'all_projects'),
        attributes=pulumi.get(__ret__, 'attributes'),
        created_at=pulumi.get(__ret__, 'created_at'),
        description=pulumi.get(__ret__, 'description'),
        email=pulumi.get(__ret__, 'email'),
        id=pulumi.get(__ret__, 'id'),
        masters=pulumi.get(__ret__, 'masters'),
        name=pulumi.get(__ret__, 'name'),
        pool_id=pulumi.get(__ret__, 'pool_id'),
        project_id=pulumi.get(__ret__, 'project_id'),
        region=pulumi.get(__ret__, 'region'),
        serial=pulumi.get(__ret__, 'serial'),
        status=pulumi.get(__ret__, 'status'),
        transferred_at=pulumi.get(__ret__, 'transferred_at'),
        ttl=pulumi.get(__ret__, 'ttl'),
        type=pulumi.get(__ret__, 'type'),
        updated_at=pulumi.get(__ret__, 'updated_at'),
        version=pulumi.get(__ret__, 'version'))
def get_dns_zone_output(all_projects: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        attributes: Optional[pulumi.Input[Optional[Mapping[str, _builtins.str]]]] = None,
                        created_at: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        description: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        email: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        masters: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                        name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        pool_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        project_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        serial: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                        status: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        transferred_at: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        ttl: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                        type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        updated_at: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        version: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDnsZoneResult]:
    """
    Use this data source to get the ID of an available OpenStack DNS zone.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_openstack as openstack

    zone1 = openstack.dns.get_dns_zone(name="example.com")
    ```


    :param _builtins.str all_projects: Try to obtain zone ID by listing all projects
           (requires admin role by default, depends on your policy configuration)
    :param Mapping[str, _builtins.str] attributes: Attributes of the DNS Service scheduler.
    :param _builtins.str created_at: The time the zone was created.
    :param _builtins.str description: A description of the zone.
    :param _builtins.str email: The email contact for the zone record.
    :param Sequence[_builtins.str] masters: An array of master DNS servers. When `type` is  `SECONDARY`.
    :param _builtins.str name: The name of the zone.
    :param _builtins.str pool_id: The ID of the pool hosting the zone.
    :param _builtins.str project_id: The ID of the project the DNS zone is obtained from,
           sets `X-Auth-Sudo-Tenant-ID` header (requires an assigned user role in target project)
    :param _builtins.str region: The region in which to obtain the V2 DNS client.
           A DNS client is needed to retrieve zone ids. If omitted, the
           `region` argument of the provider is used.
    :param _builtins.int serial: The serial number of the zone.
    :param _builtins.str status: The zone's status.
    :param _builtins.str transferred_at: The time the zone was transferred.
    :param _builtins.int ttl: The time to live (TTL) of the zone.
    :param _builtins.str type: The type of the zone. Can either be `PRIMARY` or `SECONDARY`.
    :param _builtins.str updated_at: The time the zone was last updated.
    :param _builtins.int version: The version of the zone.
    """
    __args__ = dict()
    __args__['allProjects'] = all_projects
    __args__['attributes'] = attributes
    __args__['createdAt'] = created_at
    __args__['description'] = description
    __args__['email'] = email
    __args__['masters'] = masters
    __args__['name'] = name
    __args__['poolId'] = pool_id
    __args__['projectId'] = project_id
    __args__['region'] = region
    __args__['serial'] = serial
    __args__['status'] = status
    __args__['transferredAt'] = transferred_at
    __args__['ttl'] = ttl
    __args__['type'] = type
    __args__['updatedAt'] = updated_at
    __args__['version'] = version
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('openstack:dns/getDnsZone:getDnsZone', __args__, opts=opts, typ=GetDnsZoneResult)
    return __ret__.apply(lambda __response__: GetDnsZoneResult(
        all_projects=pulumi.get(__response__, 'all_projects'),
        attributes=pulumi.get(__response__, 'attributes'),
        created_at=pulumi.get(__response__, 'created_at'),
        description=pulumi.get(__response__, 'description'),
        email=pulumi.get(__response__, 'email'),
        id=pulumi.get(__response__, 'id'),
        masters=pulumi.get(__response__, 'masters'),
        name=pulumi.get(__response__, 'name'),
        pool_id=pulumi.get(__response__, 'pool_id'),
        project_id=pulumi.get(__response__, 'project_id'),
        region=pulumi.get(__response__, 'region'),
        serial=pulumi.get(__response__, 'serial'),
        status=pulumi.get(__response__, 'status'),
        transferred_at=pulumi.get(__response__, 'transferred_at'),
        ttl=pulumi.get(__response__, 'ttl'),
        type=pulumi.get(__response__, 'type'),
        updated_at=pulumi.get(__response__, 'updated_at'),
        version=pulumi.get(__response__, 'version')))
