# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ApplicationCredentialAccessRule',
    'UserMultiFactorAuthRule',
    'GetAuthScopeRoleResult',
    'GetAuthScopeServiceCatalogResult',
    'GetAuthScopeServiceCatalogEndpointResult',
]

@pulumi.output_type
class ApplicationCredentialAccessRule(dict):
    def __init__(__self__, *,
                 method: _builtins.str,
                 path: _builtins.str,
                 service: _builtins.str,
                 id: Optional[_builtins.str] = None):
        """
        :param _builtins.str method: The request method that the application credential is
               permitted to use for a given API endpoint. Allowed values: `POST`, `GET`,
               `HEAD`, `PATCH`, `PUT` and `DELETE`.
        :param _builtins.str path: The API path that the application credential is permitted
               to access. May use named wildcards such as **{tag}** or the unnamed wildcard
               **\\*** to match against any string in the path up to a **/**, or the recursive
               wildcard **\\*\\*** to include **/** in the matched path.
        :param _builtins.str service: The service type identifier for the service that the
               application credential is granted to access. Must be a service type that is
               listed in the service catalog and not a code name for a service. E.g.
               **identity**, **compute**, **volumev3**, **image**, **network**,
               **object-store**, **sharev2**, **dns**, **key-manager**, **monitoring**, etc.
        :param _builtins.str id: The ID of the existing access rule. The access rule ID of
               another application credential can be provided.
        """
        pulumi.set(__self__, "method", method)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "service", service)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def method(self) -> _builtins.str:
        """
        The request method that the application credential is
        permitted to use for a given API endpoint. Allowed values: `POST`, `GET`,
        `HEAD`, `PATCH`, `PUT` and `DELETE`.
        """
        return pulumi.get(self, "method")

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        """
        The API path that the application credential is permitted
        to access. May use named wildcards such as **{tag}** or the unnamed wildcard
        **\\*** to match against any string in the path up to a **/**, or the recursive
        wildcard **\\*\\*** to include **/** in the matched path.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter
    def service(self) -> _builtins.str:
        """
        The service type identifier for the service that the
        application credential is granted to access. Must be a service type that is
        listed in the service catalog and not a code name for a service. E.g.
        **identity**, **compute**, **volumev3**, **image**, **network**,
        **object-store**, **sharev2**, **dns**, **key-manager**, **monitoring**, etc.
        """
        return pulumi.get(self, "service")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The ID of the existing access rule. The access rule ID of
        another application credential can be provided.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class UserMultiFactorAuthRule(dict):
    def __init__(__self__, *,
                 rules: Sequence[_builtins.str]):
        """
        :param Sequence[_builtins.str] rules: A list of authentication plugins that the user must
               authenticate with.
        """
        pulumi.set(__self__, "rules", rules)

    @_builtins.property
    @pulumi.getter
    def rules(self) -> Sequence[_builtins.str]:
        """
        A list of authentication plugins that the user must
        authenticate with.
        """
        return pulumi.get(self, "rules")


@pulumi.output_type
class GetAuthScopeRoleResult(dict):
    def __init__(__self__, *,
                 role_id: _builtins.str,
                 role_name: _builtins.str):
        """
        :param _builtins.str role_id: The ID of the role.
        :param _builtins.str role_name: The name of the role.
        """
        pulumi.set(__self__, "role_id", role_id)
        pulumi.set(__self__, "role_name", role_name)

    @_builtins.property
    @pulumi.getter(name="roleId")
    def role_id(self) -> _builtins.str:
        """
        The ID of the role.
        """
        return pulumi.get(self, "role_id")

    @_builtins.property
    @pulumi.getter(name="roleName")
    def role_name(self) -> _builtins.str:
        """
        The name of the role.
        """
        return pulumi.get(self, "role_name")


@pulumi.output_type
class GetAuthScopeServiceCatalogResult(dict):
    def __init__(__self__, *,
                 endpoints: Sequence['outputs.GetAuthScopeServiceCatalogEndpointResult'],
                 id: _builtins.str,
                 name: _builtins.str,
                 type: _builtins.str):
        """
        :param Sequence['GetAuthScopeServiceCatalogEndpointArgs'] endpoints: A list of endpoints for the service.
        :param _builtins.str id: The ID of the endpoint.
        :param _builtins.str name: The name of the scope. This is an arbitrary name which is
               only used as a unique identifier so an actual token isn't used as the ID.
        :param _builtins.str type: The type of the service.
        """
        pulumi.set(__self__, "endpoints", endpoints)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def endpoints(self) -> Sequence['outputs.GetAuthScopeServiceCatalogEndpointResult']:
        """
        A list of endpoints for the service.
        """
        return pulumi.get(self, "endpoints")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the endpoint.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the scope. This is an arbitrary name which is
        only used as a unique identifier so an actual token isn't used as the ID.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of the service.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetAuthScopeServiceCatalogEndpointResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 interface: _builtins.str,
                 region: _builtins.str,
                 region_id: _builtins.str,
                 url: _builtins.str):
        """
        :param _builtins.str id: The ID of the endpoint.
        :param _builtins.str interface: The interface of the endpoint.
        :param _builtins.str region: The region in which to obtain the V3 Identity client.
               A Identity client is needed to retrieve tokens IDs. If omitted, the
               `region` argument of the provider is used.
        :param _builtins.str region_id: The region ID of the endpoint.
        :param _builtins.str url: The URL of the endpoint.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "interface", interface)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "region_id", region_id)
        pulumi.set(__self__, "url", url)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the endpoint.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def interface(self) -> _builtins.str:
        """
        The interface of the endpoint.
        """
        return pulumi.get(self, "interface")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        """
        The region in which to obtain the V3 Identity client.
        A Identity client is needed to retrieve tokens IDs. If omitted, the
        `region` argument of the provider is used.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> _builtins.str:
        """
        The region ID of the endpoint.
        """
        return pulumi.get(self, "region_id")

    @_builtins.property
    @pulumi.getter
    def url(self) -> _builtins.str:
        """
        The URL of the endpoint.
        """
        return pulumi.get(self, "url")


