# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetSecretResult',
    'AwaitableGetSecretResult',
    'get_secret',
    'get_secret_output',
]

@pulumi.output_type
class GetSecretResult:
    """
    A collection of values returned by getSecret.
    """
    def __init__(__self__, acl_only=None, acls=None, algorithm=None, bit_length=None, content_types=None, created_at=None, created_at_filter=None, creator_id=None, expiration=None, expiration_filter=None, id=None, metadata=None, mode=None, name=None, payload=None, payload_content_encoding=None, payload_content_type=None, region=None, secret_ref=None, secret_type=None, status=None, updated_at=None, updated_at_filter=None):
        if acl_only and not isinstance(acl_only, bool):
            raise TypeError("Expected argument 'acl_only' to be a bool")
        pulumi.set(__self__, "acl_only", acl_only)
        if acls and not isinstance(acls, list):
            raise TypeError("Expected argument 'acls' to be a list")
        pulumi.set(__self__, "acls", acls)
        if algorithm and not isinstance(algorithm, str):
            raise TypeError("Expected argument 'algorithm' to be a str")
        pulumi.set(__self__, "algorithm", algorithm)
        if bit_length and not isinstance(bit_length, int):
            raise TypeError("Expected argument 'bit_length' to be a int")
        pulumi.set(__self__, "bit_length", bit_length)
        if content_types and not isinstance(content_types, dict):
            raise TypeError("Expected argument 'content_types' to be a dict")
        pulumi.set(__self__, "content_types", content_types)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if created_at_filter and not isinstance(created_at_filter, str):
            raise TypeError("Expected argument 'created_at_filter' to be a str")
        pulumi.set(__self__, "created_at_filter", created_at_filter)
        if creator_id and not isinstance(creator_id, str):
            raise TypeError("Expected argument 'creator_id' to be a str")
        pulumi.set(__self__, "creator_id", creator_id)
        if expiration and not isinstance(expiration, str):
            raise TypeError("Expected argument 'expiration' to be a str")
        pulumi.set(__self__, "expiration", expiration)
        if expiration_filter and not isinstance(expiration_filter, str):
            raise TypeError("Expected argument 'expiration_filter' to be a str")
        pulumi.set(__self__, "expiration_filter", expiration_filter)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if metadata and not isinstance(metadata, dict):
            raise TypeError("Expected argument 'metadata' to be a dict")
        pulumi.set(__self__, "metadata", metadata)
        if mode and not isinstance(mode, str):
            raise TypeError("Expected argument 'mode' to be a str")
        pulumi.set(__self__, "mode", mode)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if payload and not isinstance(payload, str):
            raise TypeError("Expected argument 'payload' to be a str")
        pulumi.set(__self__, "payload", payload)
        if payload_content_encoding and not isinstance(payload_content_encoding, str):
            raise TypeError("Expected argument 'payload_content_encoding' to be a str")
        pulumi.set(__self__, "payload_content_encoding", payload_content_encoding)
        if payload_content_type and not isinstance(payload_content_type, str):
            raise TypeError("Expected argument 'payload_content_type' to be a str")
        pulumi.set(__self__, "payload_content_type", payload_content_type)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if secret_ref and not isinstance(secret_ref, str):
            raise TypeError("Expected argument 'secret_ref' to be a str")
        pulumi.set(__self__, "secret_ref", secret_ref)
        if secret_type and not isinstance(secret_type, str):
            raise TypeError("Expected argument 'secret_type' to be a str")
        pulumi.set(__self__, "secret_type", secret_type)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if updated_at and not isinstance(updated_at, str):
            raise TypeError("Expected argument 'updated_at' to be a str")
        pulumi.set(__self__, "updated_at", updated_at)
        if updated_at_filter and not isinstance(updated_at_filter, str):
            raise TypeError("Expected argument 'updated_at_filter' to be a str")
        pulumi.set(__self__, "updated_at_filter", updated_at_filter)

    @_builtins.property
    @pulumi.getter(name="aclOnly")
    def acl_only(self) -> Optional[_builtins.bool]:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "acl_only")

    @_builtins.property
    @pulumi.getter
    def acls(self) -> Sequence['outputs.GetSecretAclResult']:
        """
        The list of ACLs assigned to a secret. The `read` structure is described below.
        """
        return pulumi.get(self, "acls")

    @_builtins.property
    @pulumi.getter
    def algorithm(self) -> Optional[_builtins.str]:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "algorithm")

    @_builtins.property
    @pulumi.getter(name="bitLength")
    def bit_length(self) -> Optional[_builtins.int]:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "bit_length")

    @_builtins.property
    @pulumi.getter(name="contentTypes")
    def content_types(self) -> Mapping[str, _builtins.str]:
        """
        The map of the content types, assigned on the secret.
        """
        return pulumi.get(self, "content_types")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        The date the secret ACL was created.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="createdAtFilter")
    def created_at_filter(self) -> Optional[_builtins.str]:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "created_at_filter")

    @_builtins.property
    @pulumi.getter(name="creatorId")
    def creator_id(self) -> _builtins.str:
        """
        The creator of the secret.
        """
        return pulumi.get(self, "creator_id")

    @_builtins.property
    @pulumi.getter
    def expiration(self) -> _builtins.str:
        """
        The date the secret will expire.
        """
        return pulumi.get(self, "expiration")

    @_builtins.property
    @pulumi.getter(name="expirationFilter")
    def expiration_filter(self) -> Optional[_builtins.str]:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "expiration_filter")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Mapping[str, _builtins.str]:
        """
        The map of metadata, assigned on the secret, which has been
        explicitly and implicitly added.
        """
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter
    def mode(self) -> Optional[_builtins.str]:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "mode")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def payload(self) -> _builtins.str:
        """
        The secret payload.
        """
        return pulumi.get(self, "payload")

    @_builtins.property
    @pulumi.getter(name="payloadContentEncoding")
    def payload_content_encoding(self) -> _builtins.str:
        """
        The Secret encoding.
        """
        return pulumi.get(self, "payload_content_encoding")

    @_builtins.property
    @pulumi.getter(name="payloadContentType")
    def payload_content_type(self) -> _builtins.str:
        """
        The Secret content type.
        """
        return pulumi.get(self, "payload_content_type")

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[_builtins.str]:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="secretRef")
    def secret_ref(self) -> _builtins.str:
        """
        The secret reference / where to find the secret.
        """
        return pulumi.get(self, "secret_ref")

    @_builtins.property
    @pulumi.getter(name="secretType")
    def secret_type(self) -> Optional[_builtins.str]:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "secret_type")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the secret.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> _builtins.str:
        """
        The date the secret ACL was last updated.
        """
        return pulumi.get(self, "updated_at")

    @_builtins.property
    @pulumi.getter(name="updatedAtFilter")
    def updated_at_filter(self) -> Optional[_builtins.str]:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "updated_at_filter")


class AwaitableGetSecretResult(GetSecretResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSecretResult(
            acl_only=self.acl_only,
            acls=self.acls,
            algorithm=self.algorithm,
            bit_length=self.bit_length,
            content_types=self.content_types,
            created_at=self.created_at,
            created_at_filter=self.created_at_filter,
            creator_id=self.creator_id,
            expiration=self.expiration,
            expiration_filter=self.expiration_filter,
            id=self.id,
            metadata=self.metadata,
            mode=self.mode,
            name=self.name,
            payload=self.payload,
            payload_content_encoding=self.payload_content_encoding,
            payload_content_type=self.payload_content_type,
            region=self.region,
            secret_ref=self.secret_ref,
            secret_type=self.secret_type,
            status=self.status,
            updated_at=self.updated_at,
            updated_at_filter=self.updated_at_filter)


def get_secret(acl_only: Optional[_builtins.bool] = None,
               algorithm: Optional[_builtins.str] = None,
               bit_length: Optional[_builtins.int] = None,
               created_at_filter: Optional[_builtins.str] = None,
               expiration_filter: Optional[_builtins.str] = None,
               mode: Optional[_builtins.str] = None,
               name: Optional[_builtins.str] = None,
               region: Optional[_builtins.str] = None,
               secret_type: Optional[_builtins.str] = None,
               updated_at_filter: Optional[_builtins.str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSecretResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_openstack as openstack

    example = openstack.keymanager.get_secret(mode="cbc",
        secret_type="passphrase")
    ```

    ## Date Filters

    The values for the `expiration_filter`, `created_at_filter`, and
    `updated_at_filter` parameters are comma-separated lists of time stamps in
    RFC3339 format. The time stamps can be prefixed with any of these comparison
    operators: *gt:* (greater-than), *gte:* (greater-than-or-equal), *lt:*
    (less-than), *lte:* (less-than-or-equal).

    For example, to get a passphrase a Secret with CBC moda, that will expire in
    January of 2020:

    ```python
    import pulumi
    import pulumi_openstack as openstack

    date_filter_example = openstack.keymanager.get_secret(mode="cbc",
        secret_type="passphrase",
        expiration_filter="gt:2020-01-01T00:00:00Z")
    ```


    :param _builtins.bool acl_only: Select the Secret with an ACL that contains the user.
           Project scope is ignored. Defaults to `false`.
    :param _builtins.str algorithm: The Secret algorithm.
    :param _builtins.int bit_length: The Secret bit length.
    :param _builtins.str created_at_filter: Date filter to select the Secret with
           created matching the specified criteria. See Date Filters below for more
           detail.
    :param _builtins.str expiration_filter: Date filter to select the Secret with
           expiration matching the specified criteria. See Date Filters below for more
           detail.
    :param _builtins.str mode: The Secret mode.
    :param _builtins.str name: The Secret name.
    :param _builtins.str region: The region in which to obtain the V1 KeyManager client.
           A KeyManager client is needed to fetch a secret. If omitted, the `region`
           argument of the provider is used.
    :param _builtins.str secret_type: The Secret type. For more information see
           [Secret types](https://docs.openstack.org/barbican/latest/api/reference/secret_types.html).
    :param _builtins.str updated_at_filter: Date filter to select the Secret with
           updated matching the specified criteria. See Date Filters below for more
           detail.
    """
    __args__ = dict()
    __args__['aclOnly'] = acl_only
    __args__['algorithm'] = algorithm
    __args__['bitLength'] = bit_length
    __args__['createdAtFilter'] = created_at_filter
    __args__['expirationFilter'] = expiration_filter
    __args__['mode'] = mode
    __args__['name'] = name
    __args__['region'] = region
    __args__['secretType'] = secret_type
    __args__['updatedAtFilter'] = updated_at_filter
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('openstack:keymanager/getSecret:getSecret', __args__, opts=opts, typ=GetSecretResult).value

    return AwaitableGetSecretResult(
        acl_only=pulumi.get(__ret__, 'acl_only'),
        acls=pulumi.get(__ret__, 'acls'),
        algorithm=pulumi.get(__ret__, 'algorithm'),
        bit_length=pulumi.get(__ret__, 'bit_length'),
        content_types=pulumi.get(__ret__, 'content_types'),
        created_at=pulumi.get(__ret__, 'created_at'),
        created_at_filter=pulumi.get(__ret__, 'created_at_filter'),
        creator_id=pulumi.get(__ret__, 'creator_id'),
        expiration=pulumi.get(__ret__, 'expiration'),
        expiration_filter=pulumi.get(__ret__, 'expiration_filter'),
        id=pulumi.get(__ret__, 'id'),
        metadata=pulumi.get(__ret__, 'metadata'),
        mode=pulumi.get(__ret__, 'mode'),
        name=pulumi.get(__ret__, 'name'),
        payload=pulumi.get(__ret__, 'payload'),
        payload_content_encoding=pulumi.get(__ret__, 'payload_content_encoding'),
        payload_content_type=pulumi.get(__ret__, 'payload_content_type'),
        region=pulumi.get(__ret__, 'region'),
        secret_ref=pulumi.get(__ret__, 'secret_ref'),
        secret_type=pulumi.get(__ret__, 'secret_type'),
        status=pulumi.get(__ret__, 'status'),
        updated_at=pulumi.get(__ret__, 'updated_at'),
        updated_at_filter=pulumi.get(__ret__, 'updated_at_filter'))
def get_secret_output(acl_only: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                      algorithm: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                      bit_length: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                      created_at_filter: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                      expiration_filter: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                      mode: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                      name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                      region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                      secret_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                      updated_at_filter: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSecretResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_openstack as openstack

    example = openstack.keymanager.get_secret(mode="cbc",
        secret_type="passphrase")
    ```

    ## Date Filters

    The values for the `expiration_filter`, `created_at_filter`, and
    `updated_at_filter` parameters are comma-separated lists of time stamps in
    RFC3339 format. The time stamps can be prefixed with any of these comparison
    operators: *gt:* (greater-than), *gte:* (greater-than-or-equal), *lt:*
    (less-than), *lte:* (less-than-or-equal).

    For example, to get a passphrase a Secret with CBC moda, that will expire in
    January of 2020:

    ```python
    import pulumi
    import pulumi_openstack as openstack

    date_filter_example = openstack.keymanager.get_secret(mode="cbc",
        secret_type="passphrase",
        expiration_filter="gt:2020-01-01T00:00:00Z")
    ```


    :param _builtins.bool acl_only: Select the Secret with an ACL that contains the user.
           Project scope is ignored. Defaults to `false`.
    :param _builtins.str algorithm: The Secret algorithm.
    :param _builtins.int bit_length: The Secret bit length.
    :param _builtins.str created_at_filter: Date filter to select the Secret with
           created matching the specified criteria. See Date Filters below for more
           detail.
    :param _builtins.str expiration_filter: Date filter to select the Secret with
           expiration matching the specified criteria. See Date Filters below for more
           detail.
    :param _builtins.str mode: The Secret mode.
    :param _builtins.str name: The Secret name.
    :param _builtins.str region: The region in which to obtain the V1 KeyManager client.
           A KeyManager client is needed to fetch a secret. If omitted, the `region`
           argument of the provider is used.
    :param _builtins.str secret_type: The Secret type. For more information see
           [Secret types](https://docs.openstack.org/barbican/latest/api/reference/secret_types.html).
    :param _builtins.str updated_at_filter: Date filter to select the Secret with
           updated matching the specified criteria. See Date Filters below for more
           detail.
    """
    __args__ = dict()
    __args__['aclOnly'] = acl_only
    __args__['algorithm'] = algorithm
    __args__['bitLength'] = bit_length
    __args__['createdAtFilter'] = created_at_filter
    __args__['expirationFilter'] = expiration_filter
    __args__['mode'] = mode
    __args__['name'] = name
    __args__['region'] = region
    __args__['secretType'] = secret_type
    __args__['updatedAtFilter'] = updated_at_filter
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('openstack:keymanager/getSecret:getSecret', __args__, opts=opts, typ=GetSecretResult)
    return __ret__.apply(lambda __response__: GetSecretResult(
        acl_only=pulumi.get(__response__, 'acl_only'),
        acls=pulumi.get(__response__, 'acls'),
        algorithm=pulumi.get(__response__, 'algorithm'),
        bit_length=pulumi.get(__response__, 'bit_length'),
        content_types=pulumi.get(__response__, 'content_types'),
        created_at=pulumi.get(__response__, 'created_at'),
        created_at_filter=pulumi.get(__response__, 'created_at_filter'),
        creator_id=pulumi.get(__response__, 'creator_id'),
        expiration=pulumi.get(__response__, 'expiration'),
        expiration_filter=pulumi.get(__response__, 'expiration_filter'),
        id=pulumi.get(__response__, 'id'),
        metadata=pulumi.get(__response__, 'metadata'),
        mode=pulumi.get(__response__, 'mode'),
        name=pulumi.get(__response__, 'name'),
        payload=pulumi.get(__response__, 'payload'),
        payload_content_encoding=pulumi.get(__response__, 'payload_content_encoding'),
        payload_content_type=pulumi.get(__response__, 'payload_content_type'),
        region=pulumi.get(__response__, 'region'),
        secret_ref=pulumi.get(__response__, 'secret_ref'),
        secret_type=pulumi.get(__response__, 'secret_type'),
        status=pulumi.get(__response__, 'status'),
        updated_at=pulumi.get(__response__, 'updated_at'),
        updated_at_filter=pulumi.get(__response__, 'updated_at_filter')))
