# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SecretV1Args', 'SecretV1']

@pulumi.input_type
class SecretV1Args:
    def __init__(__self__, *,
                 acl: Optional[pulumi.Input['SecretV1AclArgs']] = None,
                 algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 bit_length: Optional[pulumi.Input[_builtins.int]] = None,
                 expiration: Optional[pulumi.Input[_builtins.str]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 mode: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 payload: Optional[pulumi.Input[_builtins.str]] = None,
                 payload_content_encoding: Optional[pulumi.Input[_builtins.str]] = None,
                 payload_content_type: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a SecretV1 resource.
        :param pulumi.Input['SecretV1AclArgs'] acl: Allows to control an access to a secret. Currently only the
               `read` operation is supported. If not specified, the secret is accessible
               project wide.
        :param pulumi.Input[_builtins.str] algorithm: Metadata provided by a user or system for informational purposes.
        :param pulumi.Input[_builtins.int] bit_length: Metadata provided by a user or system for informational purposes.
        :param pulumi.Input[_builtins.str] expiration: The expiration time of the secret in the RFC3339 timestamp format (e.g. `2019-03-09T12:58:49Z`). If omitted, a secret will never expire. Changing this creates a new secret.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] metadata: Additional Metadata for the secret.
        :param pulumi.Input[_builtins.str] mode: Metadata provided by a user or system for informational purposes.
        :param pulumi.Input[_builtins.str] name: Human-readable name for the Secret. Does not have
               to be unique.
        :param pulumi.Input[_builtins.str] payload: The secret's data to be stored. **payload\\_content\\_type** must also be supplied if **payload** is included.
        :param pulumi.Input[_builtins.str] payload_content_encoding: (required if **payload** is encoded) The encoding used for the payload to be able to include it in the JSON request. Must be either `base64` or `binary`.
        :param pulumi.Input[_builtins.str] payload_content_type: (required if **payload** is included) The media type for the content of the payload. Must be one of `text/plain`, `text/plain;charset=utf-8`, `text/plain; charset=utf-8`, `application/octet-stream`, `application/pkcs8`.
        :param pulumi.Input[_builtins.str] region: The region in which to obtain the V1 KeyManager client.
               A KeyManager client is needed to create a secret. If omitted, the
               `region` argument of the provider is used. Changing this creates a new
               V1 secret.
        :param pulumi.Input[_builtins.str] secret_type: Used to indicate the type of secret being stored. For more information see [Secret types](https://docs.openstack.org/barbican/latest/api/reference/secret_types.html).
        """
        if acl is not None:
            pulumi.set(__self__, "acl", acl)
        if algorithm is not None:
            pulumi.set(__self__, "algorithm", algorithm)
        if bit_length is not None:
            pulumi.set(__self__, "bit_length", bit_length)
        if expiration is not None:
            pulumi.set(__self__, "expiration", expiration)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if payload is not None:
            pulumi.set(__self__, "payload", payload)
        if payload_content_encoding is not None:
            pulumi.set(__self__, "payload_content_encoding", payload_content_encoding)
        if payload_content_type is not None:
            pulumi.set(__self__, "payload_content_type", payload_content_type)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if secret_type is not None:
            pulumi.set(__self__, "secret_type", secret_type)

    @_builtins.property
    @pulumi.getter
    def acl(self) -> Optional[pulumi.Input['SecretV1AclArgs']]:
        """
        Allows to control an access to a secret. Currently only the
        `read` operation is supported. If not specified, the secret is accessible
        project wide.
        """
        return pulumi.get(self, "acl")

    @acl.setter
    def acl(self, value: Optional[pulumi.Input['SecretV1AclArgs']]):
        pulumi.set(self, "acl", value)

    @_builtins.property
    @pulumi.getter
    def algorithm(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Metadata provided by a user or system for informational purposes.
        """
        return pulumi.get(self, "algorithm")

    @algorithm.setter
    def algorithm(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "algorithm", value)

    @_builtins.property
    @pulumi.getter(name="bitLength")
    def bit_length(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Metadata provided by a user or system for informational purposes.
        """
        return pulumi.get(self, "bit_length")

    @bit_length.setter
    def bit_length(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "bit_length", value)

    @_builtins.property
    @pulumi.getter
    def expiration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The expiration time of the secret in the RFC3339 timestamp format (e.g. `2019-03-09T12:58:49Z`). If omitted, a secret will never expire. Changing this creates a new secret.
        """
        return pulumi.get(self, "expiration")

    @expiration.setter
    def expiration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "expiration", value)

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Additional Metadata for the secret.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "metadata", value)

    @_builtins.property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Metadata provided by a user or system for informational purposes.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mode", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Human-readable name for the Secret. Does not have
        to be unique.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def payload(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The secret's data to be stored. **payload\\_content\\_type** must also be supplied if **payload** is included.
        """
        return pulumi.get(self, "payload")

    @payload.setter
    def payload(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "payload", value)

    @_builtins.property
    @pulumi.getter(name="payloadContentEncoding")
    def payload_content_encoding(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (required if **payload** is encoded) The encoding used for the payload to be able to include it in the JSON request. Must be either `base64` or `binary`.
        """
        return pulumi.get(self, "payload_content_encoding")

    @payload_content_encoding.setter
    def payload_content_encoding(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "payload_content_encoding", value)

    @_builtins.property
    @pulumi.getter(name="payloadContentType")
    def payload_content_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (required if **payload** is included) The media type for the content of the payload. Must be one of `text/plain`, `text/plain;charset=utf-8`, `text/plain; charset=utf-8`, `application/octet-stream`, `application/pkcs8`.
        """
        return pulumi.get(self, "payload_content_type")

    @payload_content_type.setter
    def payload_content_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "payload_content_type", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to obtain the V1 KeyManager client.
        A KeyManager client is needed to create a secret. If omitted, the
        `region` argument of the provider is used. Changing this creates a new
        V1 secret.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="secretType")
    def secret_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Used to indicate the type of secret being stored. For more information see [Secret types](https://docs.openstack.org/barbican/latest/api/reference/secret_types.html).
        """
        return pulumi.get(self, "secret_type")

    @secret_type.setter
    def secret_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secret_type", value)


@pulumi.input_type
class _SecretV1State:
    def __init__(__self__, *,
                 acl: Optional[pulumi.Input['SecretV1AclArgs']] = None,
                 algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 all_metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 bit_length: Optional[pulumi.Input[_builtins.int]] = None,
                 content_types: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 creator_id: Optional[pulumi.Input[_builtins.str]] = None,
                 expiration: Optional[pulumi.Input[_builtins.str]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 mode: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 payload: Optional[pulumi.Input[_builtins.str]] = None,
                 payload_content_encoding: Optional[pulumi.Input[_builtins.str]] = None,
                 payload_content_type: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_ref: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_type: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering SecretV1 resources.
        :param pulumi.Input['SecretV1AclArgs'] acl: Allows to control an access to a secret. Currently only the
               `read` operation is supported. If not specified, the secret is accessible
               project wide.
        :param pulumi.Input[_builtins.str] algorithm: Metadata provided by a user or system for informational purposes.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] all_metadata: The map of metadata, assigned on the secret, which has been
               explicitly and implicitly added.
        :param pulumi.Input[_builtins.int] bit_length: Metadata provided by a user or system for informational purposes.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] content_types: The map of the content types, assigned on the secret.
        :param pulumi.Input[_builtins.str] created_at: The date the secret was created.
        :param pulumi.Input[_builtins.str] creator_id: The creator of the secret.
        :param pulumi.Input[_builtins.str] expiration: The expiration time of the secret in the RFC3339 timestamp format (e.g. `2019-03-09T12:58:49Z`). If omitted, a secret will never expire. Changing this creates a new secret.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] metadata: Additional Metadata for the secret.
        :param pulumi.Input[_builtins.str] mode: Metadata provided by a user or system for informational purposes.
        :param pulumi.Input[_builtins.str] name: Human-readable name for the Secret. Does not have
               to be unique.
        :param pulumi.Input[_builtins.str] payload: The secret's data to be stored. **payload\\_content\\_type** must also be supplied if **payload** is included.
        :param pulumi.Input[_builtins.str] payload_content_encoding: (required if **payload** is encoded) The encoding used for the payload to be able to include it in the JSON request. Must be either `base64` or `binary`.
        :param pulumi.Input[_builtins.str] payload_content_type: (required if **payload** is included) The media type for the content of the payload. Must be one of `text/plain`, `text/plain;charset=utf-8`, `text/plain; charset=utf-8`, `application/octet-stream`, `application/pkcs8`.
        :param pulumi.Input[_builtins.str] region: The region in which to obtain the V1 KeyManager client.
               A KeyManager client is needed to create a secret. If omitted, the
               `region` argument of the provider is used. Changing this creates a new
               V1 secret.
        :param pulumi.Input[_builtins.str] secret_ref: The secret reference / where to find the secret.
        :param pulumi.Input[_builtins.str] secret_type: Used to indicate the type of secret being stored. For more information see [Secret types](https://docs.openstack.org/barbican/latest/api/reference/secret_types.html).
        :param pulumi.Input[_builtins.str] status: The status of the secret.
        :param pulumi.Input[_builtins.str] updated_at: The date the secret was last updated.
        """
        if acl is not None:
            pulumi.set(__self__, "acl", acl)
        if algorithm is not None:
            pulumi.set(__self__, "algorithm", algorithm)
        if all_metadata is not None:
            pulumi.set(__self__, "all_metadata", all_metadata)
        if bit_length is not None:
            pulumi.set(__self__, "bit_length", bit_length)
        if content_types is not None:
            pulumi.set(__self__, "content_types", content_types)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if creator_id is not None:
            pulumi.set(__self__, "creator_id", creator_id)
        if expiration is not None:
            pulumi.set(__self__, "expiration", expiration)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if payload is not None:
            pulumi.set(__self__, "payload", payload)
        if payload_content_encoding is not None:
            pulumi.set(__self__, "payload_content_encoding", payload_content_encoding)
        if payload_content_type is not None:
            pulumi.set(__self__, "payload_content_type", payload_content_type)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if secret_ref is not None:
            pulumi.set(__self__, "secret_ref", secret_ref)
        if secret_type is not None:
            pulumi.set(__self__, "secret_type", secret_type)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @_builtins.property
    @pulumi.getter
    def acl(self) -> Optional[pulumi.Input['SecretV1AclArgs']]:
        """
        Allows to control an access to a secret. Currently only the
        `read` operation is supported. If not specified, the secret is accessible
        project wide.
        """
        return pulumi.get(self, "acl")

    @acl.setter
    def acl(self, value: Optional[pulumi.Input['SecretV1AclArgs']]):
        pulumi.set(self, "acl", value)

    @_builtins.property
    @pulumi.getter
    def algorithm(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Metadata provided by a user or system for informational purposes.
        """
        return pulumi.get(self, "algorithm")

    @algorithm.setter
    def algorithm(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "algorithm", value)

    @_builtins.property
    @pulumi.getter(name="allMetadata")
    def all_metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The map of metadata, assigned on the secret, which has been
        explicitly and implicitly added.
        """
        return pulumi.get(self, "all_metadata")

    @all_metadata.setter
    def all_metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "all_metadata", value)

    @_builtins.property
    @pulumi.getter(name="bitLength")
    def bit_length(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Metadata provided by a user or system for informational purposes.
        """
        return pulumi.get(self, "bit_length")

    @bit_length.setter
    def bit_length(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "bit_length", value)

    @_builtins.property
    @pulumi.getter(name="contentTypes")
    def content_types(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The map of the content types, assigned on the secret.
        """
        return pulumi.get(self, "content_types")

    @content_types.setter
    def content_types(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "content_types", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date the secret was created.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="creatorId")
    def creator_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creator of the secret.
        """
        return pulumi.get(self, "creator_id")

    @creator_id.setter
    def creator_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "creator_id", value)

    @_builtins.property
    @pulumi.getter
    def expiration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The expiration time of the secret in the RFC3339 timestamp format (e.g. `2019-03-09T12:58:49Z`). If omitted, a secret will never expire. Changing this creates a new secret.
        """
        return pulumi.get(self, "expiration")

    @expiration.setter
    def expiration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "expiration", value)

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Additional Metadata for the secret.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "metadata", value)

    @_builtins.property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Metadata provided by a user or system for informational purposes.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mode", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Human-readable name for the Secret. Does not have
        to be unique.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def payload(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The secret's data to be stored. **payload\\_content\\_type** must also be supplied if **payload** is included.
        """
        return pulumi.get(self, "payload")

    @payload.setter
    def payload(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "payload", value)

    @_builtins.property
    @pulumi.getter(name="payloadContentEncoding")
    def payload_content_encoding(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (required if **payload** is encoded) The encoding used for the payload to be able to include it in the JSON request. Must be either `base64` or `binary`.
        """
        return pulumi.get(self, "payload_content_encoding")

    @payload_content_encoding.setter
    def payload_content_encoding(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "payload_content_encoding", value)

    @_builtins.property
    @pulumi.getter(name="payloadContentType")
    def payload_content_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (required if **payload** is included) The media type for the content of the payload. Must be one of `text/plain`, `text/plain;charset=utf-8`, `text/plain; charset=utf-8`, `application/octet-stream`, `application/pkcs8`.
        """
        return pulumi.get(self, "payload_content_type")

    @payload_content_type.setter
    def payload_content_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "payload_content_type", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to obtain the V1 KeyManager client.
        A KeyManager client is needed to create a secret. If omitted, the
        `region` argument of the provider is used. Changing this creates a new
        V1 secret.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="secretRef")
    def secret_ref(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The secret reference / where to find the secret.
        """
        return pulumi.get(self, "secret_ref")

    @secret_ref.setter
    def secret_ref(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secret_ref", value)

    @_builtins.property
    @pulumi.getter(name="secretType")
    def secret_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Used to indicate the type of secret being stored. For more information see [Secret types](https://docs.openstack.org/barbican/latest/api/reference/secret_types.html).
        """
        return pulumi.get(self, "secret_type")

    @secret_type.setter
    def secret_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secret_type", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the secret.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date the secret was last updated.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_at", value)


@pulumi.type_token("openstack:keymanager/secretV1:SecretV1")
class SecretV1(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acl: Optional[pulumi.Input[Union['SecretV1AclArgs', 'SecretV1AclArgsDict']]] = None,
                 algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 bit_length: Optional[pulumi.Input[_builtins.int]] = None,
                 expiration: Optional[pulumi.Input[_builtins.str]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 mode: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 payload: Optional[pulumi.Input[_builtins.str]] = None,
                 payload_content_encoding: Optional[pulumi.Input[_builtins.str]] = None,
                 payload_content_type: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ### Simple secret

        ```python
        import pulumi
        import pulumi_openstack as openstack

        secret1 = openstack.keymanager.SecretV1("secret_1",
            algorithm="aes",
            bit_length=256,
            mode="cbc",
            name="mysecret",
            payload="foobar",
            payload_content_type="text/plain",
            secret_type="passphrase",
            metadata={
                "key": "foo",
            })
        ```

        ### Secret with whitespaces

        > **Note** If you want to store payload with leading or trailing whitespaces,
        it's recommended to store it in a base64 encoding. Plain text payload can also
        work, but further addind or removing of the leading or trailing whitespaces
        won't be detected as a state change, e.g. changing plain text payload from
        ` password  ` to `password` won't recreate the secret.

        ```python
        import pulumi
        import pulumi_openstack as openstack
        import pulumi_std as std

        secret1 = openstack.keymanager.SecretV1("secret_1",
            name="password",
            payload=std.base64encode(input="password with the whitespace at the end ").result,
            secret_type="passphrase",
            payload_content_type="application/octet-stream",
            payload_content_encoding="base64")
        ```

        ### Secret with the ACL

        > **Note** Only read ACLs are supported

        ```python
        import pulumi
        import pulumi_openstack as openstack
        import pulumi_std as std

        secret1 = openstack.keymanager.SecretV1("secret_1",
            name="certificate",
            payload=std.file(input="certificate.pem").result,
            secret_type="certificate",
            payload_content_type="text/plain",
            acl={
                "read": {
                    "project_access": False,
                    "users": [
                        "userid1",
                        "userid2",
                    ],
                },
            })
        ```

        ## Import

        Secrets can be imported using the secret id (the last part of the secret reference), e.g.:

        ```sh
        $ pulumi import openstack:keymanager/secretV1:SecretV1 secret_1 8a7a79c2-cf17-4e65-b2ae-ddc8bfcf6c74
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['SecretV1AclArgs', 'SecretV1AclArgsDict']] acl: Allows to control an access to a secret. Currently only the
               `read` operation is supported. If not specified, the secret is accessible
               project wide.
        :param pulumi.Input[_builtins.str] algorithm: Metadata provided by a user or system for informational purposes.
        :param pulumi.Input[_builtins.int] bit_length: Metadata provided by a user or system for informational purposes.
        :param pulumi.Input[_builtins.str] expiration: The expiration time of the secret in the RFC3339 timestamp format (e.g. `2019-03-09T12:58:49Z`). If omitted, a secret will never expire. Changing this creates a new secret.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] metadata: Additional Metadata for the secret.
        :param pulumi.Input[_builtins.str] mode: Metadata provided by a user or system for informational purposes.
        :param pulumi.Input[_builtins.str] name: Human-readable name for the Secret. Does not have
               to be unique.
        :param pulumi.Input[_builtins.str] payload: The secret's data to be stored. **payload\\_content\\_type** must also be supplied if **payload** is included.
        :param pulumi.Input[_builtins.str] payload_content_encoding: (required if **payload** is encoded) The encoding used for the payload to be able to include it in the JSON request. Must be either `base64` or `binary`.
        :param pulumi.Input[_builtins.str] payload_content_type: (required if **payload** is included) The media type for the content of the payload. Must be one of `text/plain`, `text/plain;charset=utf-8`, `text/plain; charset=utf-8`, `application/octet-stream`, `application/pkcs8`.
        :param pulumi.Input[_builtins.str] region: The region in which to obtain the V1 KeyManager client.
               A KeyManager client is needed to create a secret. If omitted, the
               `region` argument of the provider is used. Changing this creates a new
               V1 secret.
        :param pulumi.Input[_builtins.str] secret_type: Used to indicate the type of secret being stored. For more information see [Secret types](https://docs.openstack.org/barbican/latest/api/reference/secret_types.html).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[SecretV1Args] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ### Simple secret

        ```python
        import pulumi
        import pulumi_openstack as openstack

        secret1 = openstack.keymanager.SecretV1("secret_1",
            algorithm="aes",
            bit_length=256,
            mode="cbc",
            name="mysecret",
            payload="foobar",
            payload_content_type="text/plain",
            secret_type="passphrase",
            metadata={
                "key": "foo",
            })
        ```

        ### Secret with whitespaces

        > **Note** If you want to store payload with leading or trailing whitespaces,
        it's recommended to store it in a base64 encoding. Plain text payload can also
        work, but further addind or removing of the leading or trailing whitespaces
        won't be detected as a state change, e.g. changing plain text payload from
        ` password  ` to `password` won't recreate the secret.

        ```python
        import pulumi
        import pulumi_openstack as openstack
        import pulumi_std as std

        secret1 = openstack.keymanager.SecretV1("secret_1",
            name="password",
            payload=std.base64encode(input="password with the whitespace at the end ").result,
            secret_type="passphrase",
            payload_content_type="application/octet-stream",
            payload_content_encoding="base64")
        ```

        ### Secret with the ACL

        > **Note** Only read ACLs are supported

        ```python
        import pulumi
        import pulumi_openstack as openstack
        import pulumi_std as std

        secret1 = openstack.keymanager.SecretV1("secret_1",
            name="certificate",
            payload=std.file(input="certificate.pem").result,
            secret_type="certificate",
            payload_content_type="text/plain",
            acl={
                "read": {
                    "project_access": False,
                    "users": [
                        "userid1",
                        "userid2",
                    ],
                },
            })
        ```

        ## Import

        Secrets can be imported using the secret id (the last part of the secret reference), e.g.:

        ```sh
        $ pulumi import openstack:keymanager/secretV1:SecretV1 secret_1 8a7a79c2-cf17-4e65-b2ae-ddc8bfcf6c74
        ```

        :param str resource_name: The name of the resource.
        :param SecretV1Args args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SecretV1Args, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acl: Optional[pulumi.Input[Union['SecretV1AclArgs', 'SecretV1AclArgsDict']]] = None,
                 algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 bit_length: Optional[pulumi.Input[_builtins.int]] = None,
                 expiration: Optional[pulumi.Input[_builtins.str]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 mode: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 payload: Optional[pulumi.Input[_builtins.str]] = None,
                 payload_content_encoding: Optional[pulumi.Input[_builtins.str]] = None,
                 payload_content_type: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SecretV1Args.__new__(SecretV1Args)

            __props__.__dict__["acl"] = acl
            __props__.__dict__["algorithm"] = algorithm
            __props__.__dict__["bit_length"] = bit_length
            __props__.__dict__["expiration"] = expiration
            __props__.__dict__["metadata"] = metadata
            __props__.__dict__["mode"] = mode
            __props__.__dict__["name"] = name
            __props__.__dict__["payload"] = None if payload is None else pulumi.Output.secret(payload)
            __props__.__dict__["payload_content_encoding"] = payload_content_encoding
            __props__.__dict__["payload_content_type"] = payload_content_type
            __props__.__dict__["region"] = region
            __props__.__dict__["secret_type"] = secret_type
            __props__.__dict__["all_metadata"] = None
            __props__.__dict__["content_types"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["creator_id"] = None
            __props__.__dict__["secret_ref"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["updated_at"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["payload"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(SecretV1, __self__).__init__(
            'openstack:keymanager/secretV1:SecretV1',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            acl: Optional[pulumi.Input[Union['SecretV1AclArgs', 'SecretV1AclArgsDict']]] = None,
            algorithm: Optional[pulumi.Input[_builtins.str]] = None,
            all_metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            bit_length: Optional[pulumi.Input[_builtins.int]] = None,
            content_types: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            creator_id: Optional[pulumi.Input[_builtins.str]] = None,
            expiration: Optional[pulumi.Input[_builtins.str]] = None,
            metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            mode: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            payload: Optional[pulumi.Input[_builtins.str]] = None,
            payload_content_encoding: Optional[pulumi.Input[_builtins.str]] = None,
            payload_content_type: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            secret_ref: Optional[pulumi.Input[_builtins.str]] = None,
            secret_type: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            updated_at: Optional[pulumi.Input[_builtins.str]] = None) -> 'SecretV1':
        """
        Get an existing SecretV1 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['SecretV1AclArgs', 'SecretV1AclArgsDict']] acl: Allows to control an access to a secret. Currently only the
               `read` operation is supported. If not specified, the secret is accessible
               project wide.
        :param pulumi.Input[_builtins.str] algorithm: Metadata provided by a user or system for informational purposes.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] all_metadata: The map of metadata, assigned on the secret, which has been
               explicitly and implicitly added.
        :param pulumi.Input[_builtins.int] bit_length: Metadata provided by a user or system for informational purposes.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] content_types: The map of the content types, assigned on the secret.
        :param pulumi.Input[_builtins.str] created_at: The date the secret was created.
        :param pulumi.Input[_builtins.str] creator_id: The creator of the secret.
        :param pulumi.Input[_builtins.str] expiration: The expiration time of the secret in the RFC3339 timestamp format (e.g. `2019-03-09T12:58:49Z`). If omitted, a secret will never expire. Changing this creates a new secret.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] metadata: Additional Metadata for the secret.
        :param pulumi.Input[_builtins.str] mode: Metadata provided by a user or system for informational purposes.
        :param pulumi.Input[_builtins.str] name: Human-readable name for the Secret. Does not have
               to be unique.
        :param pulumi.Input[_builtins.str] payload: The secret's data to be stored. **payload\\_content\\_type** must also be supplied if **payload** is included.
        :param pulumi.Input[_builtins.str] payload_content_encoding: (required if **payload** is encoded) The encoding used for the payload to be able to include it in the JSON request. Must be either `base64` or `binary`.
        :param pulumi.Input[_builtins.str] payload_content_type: (required if **payload** is included) The media type for the content of the payload. Must be one of `text/plain`, `text/plain;charset=utf-8`, `text/plain; charset=utf-8`, `application/octet-stream`, `application/pkcs8`.
        :param pulumi.Input[_builtins.str] region: The region in which to obtain the V1 KeyManager client.
               A KeyManager client is needed to create a secret. If omitted, the
               `region` argument of the provider is used. Changing this creates a new
               V1 secret.
        :param pulumi.Input[_builtins.str] secret_ref: The secret reference / where to find the secret.
        :param pulumi.Input[_builtins.str] secret_type: Used to indicate the type of secret being stored. For more information see [Secret types](https://docs.openstack.org/barbican/latest/api/reference/secret_types.html).
        :param pulumi.Input[_builtins.str] status: The status of the secret.
        :param pulumi.Input[_builtins.str] updated_at: The date the secret was last updated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SecretV1State.__new__(_SecretV1State)

        __props__.__dict__["acl"] = acl
        __props__.__dict__["algorithm"] = algorithm
        __props__.__dict__["all_metadata"] = all_metadata
        __props__.__dict__["bit_length"] = bit_length
        __props__.__dict__["content_types"] = content_types
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["creator_id"] = creator_id
        __props__.__dict__["expiration"] = expiration
        __props__.__dict__["metadata"] = metadata
        __props__.__dict__["mode"] = mode
        __props__.__dict__["name"] = name
        __props__.__dict__["payload"] = payload
        __props__.__dict__["payload_content_encoding"] = payload_content_encoding
        __props__.__dict__["payload_content_type"] = payload_content_type
        __props__.__dict__["region"] = region
        __props__.__dict__["secret_ref"] = secret_ref
        __props__.__dict__["secret_type"] = secret_type
        __props__.__dict__["status"] = status
        __props__.__dict__["updated_at"] = updated_at
        return SecretV1(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def acl(self) -> pulumi.Output['outputs.SecretV1Acl']:
        """
        Allows to control an access to a secret. Currently only the
        `read` operation is supported. If not specified, the secret is accessible
        project wide.
        """
        return pulumi.get(self, "acl")

    @_builtins.property
    @pulumi.getter
    def algorithm(self) -> pulumi.Output[_builtins.str]:
        """
        Metadata provided by a user or system for informational purposes.
        """
        return pulumi.get(self, "algorithm")

    @_builtins.property
    @pulumi.getter(name="allMetadata")
    def all_metadata(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        The map of metadata, assigned on the secret, which has been
        explicitly and implicitly added.
        """
        return pulumi.get(self, "all_metadata")

    @_builtins.property
    @pulumi.getter(name="bitLength")
    def bit_length(self) -> pulumi.Output[_builtins.int]:
        """
        Metadata provided by a user or system for informational purposes.
        """
        return pulumi.get(self, "bit_length")

    @_builtins.property
    @pulumi.getter(name="contentTypes")
    def content_types(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        The map of the content types, assigned on the secret.
        """
        return pulumi.get(self, "content_types")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        The date the secret was created.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="creatorId")
    def creator_id(self) -> pulumi.Output[_builtins.str]:
        """
        The creator of the secret.
        """
        return pulumi.get(self, "creator_id")

    @_builtins.property
    @pulumi.getter
    def expiration(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The expiration time of the secret in the RFC3339 timestamp format (e.g. `2019-03-09T12:58:49Z`). If omitted, a secret will never expire. Changing this creates a new secret.
        """
        return pulumi.get(self, "expiration")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Additional Metadata for the secret.
        """
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter
    def mode(self) -> pulumi.Output[_builtins.str]:
        """
        Metadata provided by a user or system for informational purposes.
        """
        return pulumi.get(self, "mode")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Human-readable name for the Secret. Does not have
        to be unique.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def payload(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The secret's data to be stored. **payload\\_content\\_type** must also be supplied if **payload** is included.
        """
        return pulumi.get(self, "payload")

    @_builtins.property
    @pulumi.getter(name="payloadContentEncoding")
    def payload_content_encoding(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        (required if **payload** is encoded) The encoding used for the payload to be able to include it in the JSON request. Must be either `base64` or `binary`.
        """
        return pulumi.get(self, "payload_content_encoding")

    @_builtins.property
    @pulumi.getter(name="payloadContentType")
    def payload_content_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        (required if **payload** is included) The media type for the content of the payload. Must be one of `text/plain`, `text/plain;charset=utf-8`, `text/plain; charset=utf-8`, `application/octet-stream`, `application/pkcs8`.
        """
        return pulumi.get(self, "payload_content_type")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region in which to obtain the V1 KeyManager client.
        A KeyManager client is needed to create a secret. If omitted, the
        `region` argument of the provider is used. Changing this creates a new
        V1 secret.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="secretRef")
    def secret_ref(self) -> pulumi.Output[_builtins.str]:
        """
        The secret reference / where to find the secret.
        """
        return pulumi.get(self, "secret_ref")

    @_builtins.property
    @pulumi.getter(name="secretType")
    def secret_type(self) -> pulumi.Output[_builtins.str]:
        """
        Used to indicate the type of secret being stored. For more information see [Secret types](https://docs.openstack.org/barbican/latest/api/reference/secret_types.html).
        """
        return pulumi.get(self, "secret_type")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the secret.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[_builtins.str]:
        """
        The date the secret was last updated.
        """
        return pulumi.get(self, "updated_at")

