# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['BgpSpeakerV2Args', 'BgpSpeakerV2']

@pulumi.input_type
class BgpSpeakerV2Args:
    def __init__(__self__, *,
                 local_as: pulumi.Input[_builtins.int],
                 advertise_floating_ip_host_routes: Optional[pulumi.Input[_builtins.bool]] = None,
                 advertise_tenant_networks: Optional[pulumi.Input[_builtins.bool]] = None,
                 ip_version: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 networks: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 peers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a BgpSpeakerV2 resource.
        :param pulumi.Input[_builtins.int] local_as: The local autonomous system number (ASN) for the BGP
               speaker. This is a mandatory field and must be specified. Changing this
               creates a new BGP speaker.
        :param pulumi.Input[_builtins.bool] advertise_floating_ip_host_routes: A boolean value indicating
               whether to advertise floating IP host routes. Defaults to `true`.
        :param pulumi.Input[_builtins.bool] advertise_tenant_networks: A boolean value indicating whether to
               advertise tenant networks. Defaults to `true`.
        :param pulumi.Input[_builtins.int] ip_version: The IP version of the BGP speaker. Valid values are
               `4` or `6`. Defaults to `4`. Changing this creates a new BGP speaker.
        :param pulumi.Input[_builtins.str] name: A name for the BGP speaker.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] networks: A list of network IDs to associate with the BGP speaker.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] peers: A list of BGP peer IDs to associate with the BGP speaker.
        :param pulumi.Input[_builtins.str] region: The region in which to obtain the V2 Networking client.
               A Networking client is needed to create a Neutron network. If omitted, the
               `region` argument of the provider is used. Changing this creates a new BGP
               speaker.
        :param pulumi.Input[_builtins.str] tenant_id: The tenant/project ID. Required if admin privileges
               are used. Changing this creates a new BGP speaker.
        """
        pulumi.set(__self__, "local_as", local_as)
        if advertise_floating_ip_host_routes is not None:
            pulumi.set(__self__, "advertise_floating_ip_host_routes", advertise_floating_ip_host_routes)
        if advertise_tenant_networks is not None:
            pulumi.set(__self__, "advertise_tenant_networks", advertise_tenant_networks)
        if ip_version is not None:
            pulumi.set(__self__, "ip_version", ip_version)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if networks is not None:
            pulumi.set(__self__, "networks", networks)
        if peers is not None:
            pulumi.set(__self__, "peers", peers)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter(name="localAs")
    def local_as(self) -> pulumi.Input[_builtins.int]:
        """
        The local autonomous system number (ASN) for the BGP
        speaker. This is a mandatory field and must be specified. Changing this
        creates a new BGP speaker.
        """
        return pulumi.get(self, "local_as")

    @local_as.setter
    def local_as(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "local_as", value)

    @_builtins.property
    @pulumi.getter(name="advertiseFloatingIpHostRoutes")
    def advertise_floating_ip_host_routes(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        A boolean value indicating
        whether to advertise floating IP host routes. Defaults to `true`.
        """
        return pulumi.get(self, "advertise_floating_ip_host_routes")

    @advertise_floating_ip_host_routes.setter
    def advertise_floating_ip_host_routes(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "advertise_floating_ip_host_routes", value)

    @_builtins.property
    @pulumi.getter(name="advertiseTenantNetworks")
    def advertise_tenant_networks(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        A boolean value indicating whether to
        advertise tenant networks. Defaults to `true`.
        """
        return pulumi.get(self, "advertise_tenant_networks")

    @advertise_tenant_networks.setter
    def advertise_tenant_networks(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "advertise_tenant_networks", value)

    @_builtins.property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The IP version of the BGP speaker. Valid values are
        `4` or `6`. Defaults to `4`. Changing this creates a new BGP speaker.
        """
        return pulumi.get(self, "ip_version")

    @ip_version.setter
    def ip_version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ip_version", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A name for the BGP speaker.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def networks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of network IDs to associate with the BGP speaker.
        """
        return pulumi.get(self, "networks")

    @networks.setter
    def networks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "networks", value)

    @_builtins.property
    @pulumi.getter
    def peers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of BGP peer IDs to associate with the BGP speaker.
        """
        return pulumi.get(self, "peers")

    @peers.setter
    def peers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "peers", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to obtain the V2 Networking client.
        A Networking client is needed to create a Neutron network. If omitted, the
        `region` argument of the provider is used. Changing this creates a new BGP
        speaker.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The tenant/project ID. Required if admin privileges
        are used. Changing this creates a new BGP speaker.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant_id", value)


@pulumi.input_type
class _BgpSpeakerV2State:
    def __init__(__self__, *,
                 advertise_floating_ip_host_routes: Optional[pulumi.Input[_builtins.bool]] = None,
                 advertise_tenant_networks: Optional[pulumi.Input[_builtins.bool]] = None,
                 advertised_routes: Optional[pulumi.Input[Sequence[pulumi.Input['BgpSpeakerV2AdvertisedRouteArgs']]]] = None,
                 ip_version: Optional[pulumi.Input[_builtins.int]] = None,
                 local_as: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 networks: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 peers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering BgpSpeakerV2 resources.
        :param pulumi.Input[_builtins.bool] advertise_floating_ip_host_routes: A boolean value indicating
               whether to advertise floating IP host routes. Defaults to `true`.
        :param pulumi.Input[_builtins.bool] advertise_tenant_networks: A boolean value indicating whether to
               advertise tenant networks. Defaults to `true`.
        :param pulumi.Input[Sequence[pulumi.Input['BgpSpeakerV2AdvertisedRouteArgs']]] advertised_routes: A list of dictionaries containing the `destination` and
               `next_hop` for each route advertised by the BGP speaker. This attribute is
               only populated after the BGP speaker has been created and has established BGP
               sessions with its peers.
        :param pulumi.Input[_builtins.int] ip_version: The IP version of the BGP speaker. Valid values are
               `4` or `6`. Defaults to `4`. Changing this creates a new BGP speaker.
        :param pulumi.Input[_builtins.int] local_as: The local autonomous system number (ASN) for the BGP
               speaker. This is a mandatory field and must be specified. Changing this
               creates a new BGP speaker.
        :param pulumi.Input[_builtins.str] name: A name for the BGP speaker.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] networks: A list of network IDs to associate with the BGP speaker.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] peers: A list of BGP peer IDs to associate with the BGP speaker.
        :param pulumi.Input[_builtins.str] region: The region in which to obtain the V2 Networking client.
               A Networking client is needed to create a Neutron network. If omitted, the
               `region` argument of the provider is used. Changing this creates a new BGP
               speaker.
        :param pulumi.Input[_builtins.str] tenant_id: The tenant/project ID. Required if admin privileges
               are used. Changing this creates a new BGP speaker.
        """
        if advertise_floating_ip_host_routes is not None:
            pulumi.set(__self__, "advertise_floating_ip_host_routes", advertise_floating_ip_host_routes)
        if advertise_tenant_networks is not None:
            pulumi.set(__self__, "advertise_tenant_networks", advertise_tenant_networks)
        if advertised_routes is not None:
            pulumi.set(__self__, "advertised_routes", advertised_routes)
        if ip_version is not None:
            pulumi.set(__self__, "ip_version", ip_version)
        if local_as is not None:
            pulumi.set(__self__, "local_as", local_as)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if networks is not None:
            pulumi.set(__self__, "networks", networks)
        if peers is not None:
            pulumi.set(__self__, "peers", peers)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter(name="advertiseFloatingIpHostRoutes")
    def advertise_floating_ip_host_routes(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        A boolean value indicating
        whether to advertise floating IP host routes. Defaults to `true`.
        """
        return pulumi.get(self, "advertise_floating_ip_host_routes")

    @advertise_floating_ip_host_routes.setter
    def advertise_floating_ip_host_routes(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "advertise_floating_ip_host_routes", value)

    @_builtins.property
    @pulumi.getter(name="advertiseTenantNetworks")
    def advertise_tenant_networks(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        A boolean value indicating whether to
        advertise tenant networks. Defaults to `true`.
        """
        return pulumi.get(self, "advertise_tenant_networks")

    @advertise_tenant_networks.setter
    def advertise_tenant_networks(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "advertise_tenant_networks", value)

    @_builtins.property
    @pulumi.getter(name="advertisedRoutes")
    def advertised_routes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BgpSpeakerV2AdvertisedRouteArgs']]]]:
        """
        A list of dictionaries containing the `destination` and
        `next_hop` for each route advertised by the BGP speaker. This attribute is
        only populated after the BGP speaker has been created and has established BGP
        sessions with its peers.
        """
        return pulumi.get(self, "advertised_routes")

    @advertised_routes.setter
    def advertised_routes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BgpSpeakerV2AdvertisedRouteArgs']]]]):
        pulumi.set(self, "advertised_routes", value)

    @_builtins.property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The IP version of the BGP speaker. Valid values are
        `4` or `6`. Defaults to `4`. Changing this creates a new BGP speaker.
        """
        return pulumi.get(self, "ip_version")

    @ip_version.setter
    def ip_version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ip_version", value)

    @_builtins.property
    @pulumi.getter(name="localAs")
    def local_as(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The local autonomous system number (ASN) for the BGP
        speaker. This is a mandatory field and must be specified. Changing this
        creates a new BGP speaker.
        """
        return pulumi.get(self, "local_as")

    @local_as.setter
    def local_as(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "local_as", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A name for the BGP speaker.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def networks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of network IDs to associate with the BGP speaker.
        """
        return pulumi.get(self, "networks")

    @networks.setter
    def networks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "networks", value)

    @_builtins.property
    @pulumi.getter
    def peers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of BGP peer IDs to associate with the BGP speaker.
        """
        return pulumi.get(self, "peers")

    @peers.setter
    def peers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "peers", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to obtain the V2 Networking client.
        A Networking client is needed to create a Neutron network. If omitted, the
        `region` argument of the provider is used. Changing this creates a new BGP
        speaker.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The tenant/project ID. Required if admin privileges
        are used. Changing this creates a new BGP speaker.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant_id", value)


@pulumi.type_token("openstack:networking/bgpSpeakerV2:BgpSpeakerV2")
class BgpSpeakerV2(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 advertise_floating_ip_host_routes: Optional[pulumi.Input[_builtins.bool]] = None,
                 advertise_tenant_networks: Optional[pulumi.Input[_builtins.bool]] = None,
                 ip_version: Optional[pulumi.Input[_builtins.int]] = None,
                 local_as: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 networks: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 peers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a V2 Neutron BGP Speaker resource within OpenStack.

        This resource allows you to configure a BGP speaker that can be associated with
        a BGP peer to exchange routing information.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_openstack as openstack

        network1 = openstack.networking.Network("network1", name="network1")
        peer1 = openstack.networking.BgpPeerV2("peer_1",
            name="bgp_peer_1",
            peer_ip="192.0.2.10",
            remote_as=65001,
            auth_type="md5",
            password="supersecret")
        speaker1 = openstack.networking.BgpSpeakerV2("speaker_1",
            name="bgp_speaker_1",
            ip_version=4,
            local_as=65000,
            networks=[network1.id],
            peers=[peer1_opestack_networking_bgp_peer_v2["id"]])
        ```

        ## Import

        BGP speakers can be imported using their ID:

        ```sh
        $ pulumi import openstack:networking/bgpSpeakerV2:BgpSpeakerV2 speaker_1 8a2ad402-b805-46bf-a60b-008573ca2844
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] advertise_floating_ip_host_routes: A boolean value indicating
               whether to advertise floating IP host routes. Defaults to `true`.
        :param pulumi.Input[_builtins.bool] advertise_tenant_networks: A boolean value indicating whether to
               advertise tenant networks. Defaults to `true`.
        :param pulumi.Input[_builtins.int] ip_version: The IP version of the BGP speaker. Valid values are
               `4` or `6`. Defaults to `4`. Changing this creates a new BGP speaker.
        :param pulumi.Input[_builtins.int] local_as: The local autonomous system number (ASN) for the BGP
               speaker. This is a mandatory field and must be specified. Changing this
               creates a new BGP speaker.
        :param pulumi.Input[_builtins.str] name: A name for the BGP speaker.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] networks: A list of network IDs to associate with the BGP speaker.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] peers: A list of BGP peer IDs to associate with the BGP speaker.
        :param pulumi.Input[_builtins.str] region: The region in which to obtain the V2 Networking client.
               A Networking client is needed to create a Neutron network. If omitted, the
               `region` argument of the provider is used. Changing this creates a new BGP
               speaker.
        :param pulumi.Input[_builtins.str] tenant_id: The tenant/project ID. Required if admin privileges
               are used. Changing this creates a new BGP speaker.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BgpSpeakerV2Args,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a V2 Neutron BGP Speaker resource within OpenStack.

        This resource allows you to configure a BGP speaker that can be associated with
        a BGP peer to exchange routing information.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_openstack as openstack

        network1 = openstack.networking.Network("network1", name="network1")
        peer1 = openstack.networking.BgpPeerV2("peer_1",
            name="bgp_peer_1",
            peer_ip="192.0.2.10",
            remote_as=65001,
            auth_type="md5",
            password="supersecret")
        speaker1 = openstack.networking.BgpSpeakerV2("speaker_1",
            name="bgp_speaker_1",
            ip_version=4,
            local_as=65000,
            networks=[network1.id],
            peers=[peer1_opestack_networking_bgp_peer_v2["id"]])
        ```

        ## Import

        BGP speakers can be imported using their ID:

        ```sh
        $ pulumi import openstack:networking/bgpSpeakerV2:BgpSpeakerV2 speaker_1 8a2ad402-b805-46bf-a60b-008573ca2844
        ```

        :param str resource_name: The name of the resource.
        :param BgpSpeakerV2Args args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BgpSpeakerV2Args, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 advertise_floating_ip_host_routes: Optional[pulumi.Input[_builtins.bool]] = None,
                 advertise_tenant_networks: Optional[pulumi.Input[_builtins.bool]] = None,
                 ip_version: Optional[pulumi.Input[_builtins.int]] = None,
                 local_as: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 networks: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 peers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BgpSpeakerV2Args.__new__(BgpSpeakerV2Args)

            __props__.__dict__["advertise_floating_ip_host_routes"] = advertise_floating_ip_host_routes
            __props__.__dict__["advertise_tenant_networks"] = advertise_tenant_networks
            __props__.__dict__["ip_version"] = ip_version
            if local_as is None and not opts.urn:
                raise TypeError("Missing required property 'local_as'")
            __props__.__dict__["local_as"] = local_as
            __props__.__dict__["name"] = name
            __props__.__dict__["networks"] = networks
            __props__.__dict__["peers"] = peers
            __props__.__dict__["region"] = region
            __props__.__dict__["tenant_id"] = tenant_id
            __props__.__dict__["advertised_routes"] = None
        super(BgpSpeakerV2, __self__).__init__(
            'openstack:networking/bgpSpeakerV2:BgpSpeakerV2',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            advertise_floating_ip_host_routes: Optional[pulumi.Input[_builtins.bool]] = None,
            advertise_tenant_networks: Optional[pulumi.Input[_builtins.bool]] = None,
            advertised_routes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BgpSpeakerV2AdvertisedRouteArgs', 'BgpSpeakerV2AdvertisedRouteArgsDict']]]]] = None,
            ip_version: Optional[pulumi.Input[_builtins.int]] = None,
            local_as: Optional[pulumi.Input[_builtins.int]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            networks: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            peers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            tenant_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'BgpSpeakerV2':
        """
        Get an existing BgpSpeakerV2 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] advertise_floating_ip_host_routes: A boolean value indicating
               whether to advertise floating IP host routes. Defaults to `true`.
        :param pulumi.Input[_builtins.bool] advertise_tenant_networks: A boolean value indicating whether to
               advertise tenant networks. Defaults to `true`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['BgpSpeakerV2AdvertisedRouteArgs', 'BgpSpeakerV2AdvertisedRouteArgsDict']]]] advertised_routes: A list of dictionaries containing the `destination` and
               `next_hop` for each route advertised by the BGP speaker. This attribute is
               only populated after the BGP speaker has been created and has established BGP
               sessions with its peers.
        :param pulumi.Input[_builtins.int] ip_version: The IP version of the BGP speaker. Valid values are
               `4` or `6`. Defaults to `4`. Changing this creates a new BGP speaker.
        :param pulumi.Input[_builtins.int] local_as: The local autonomous system number (ASN) for the BGP
               speaker. This is a mandatory field and must be specified. Changing this
               creates a new BGP speaker.
        :param pulumi.Input[_builtins.str] name: A name for the BGP speaker.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] networks: A list of network IDs to associate with the BGP speaker.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] peers: A list of BGP peer IDs to associate with the BGP speaker.
        :param pulumi.Input[_builtins.str] region: The region in which to obtain the V2 Networking client.
               A Networking client is needed to create a Neutron network. If omitted, the
               `region` argument of the provider is used. Changing this creates a new BGP
               speaker.
        :param pulumi.Input[_builtins.str] tenant_id: The tenant/project ID. Required if admin privileges
               are used. Changing this creates a new BGP speaker.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BgpSpeakerV2State.__new__(_BgpSpeakerV2State)

        __props__.__dict__["advertise_floating_ip_host_routes"] = advertise_floating_ip_host_routes
        __props__.__dict__["advertise_tenant_networks"] = advertise_tenant_networks
        __props__.__dict__["advertised_routes"] = advertised_routes
        __props__.__dict__["ip_version"] = ip_version
        __props__.__dict__["local_as"] = local_as
        __props__.__dict__["name"] = name
        __props__.__dict__["networks"] = networks
        __props__.__dict__["peers"] = peers
        __props__.__dict__["region"] = region
        __props__.__dict__["tenant_id"] = tenant_id
        return BgpSpeakerV2(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="advertiseFloatingIpHostRoutes")
    def advertise_floating_ip_host_routes(self) -> pulumi.Output[_builtins.bool]:
        """
        A boolean value indicating
        whether to advertise floating IP host routes. Defaults to `true`.
        """
        return pulumi.get(self, "advertise_floating_ip_host_routes")

    @_builtins.property
    @pulumi.getter(name="advertiseTenantNetworks")
    def advertise_tenant_networks(self) -> pulumi.Output[_builtins.bool]:
        """
        A boolean value indicating whether to
        advertise tenant networks. Defaults to `true`.
        """
        return pulumi.get(self, "advertise_tenant_networks")

    @_builtins.property
    @pulumi.getter(name="advertisedRoutes")
    def advertised_routes(self) -> pulumi.Output[Sequence['outputs.BgpSpeakerV2AdvertisedRoute']]:
        """
        A list of dictionaries containing the `destination` and
        `next_hop` for each route advertised by the BGP speaker. This attribute is
        only populated after the BGP speaker has been created and has established BGP
        sessions with its peers.
        """
        return pulumi.get(self, "advertised_routes")

    @_builtins.property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The IP version of the BGP speaker. Valid values are
        `4` or `6`. Defaults to `4`. Changing this creates a new BGP speaker.
        """
        return pulumi.get(self, "ip_version")

    @_builtins.property
    @pulumi.getter(name="localAs")
    def local_as(self) -> pulumi.Output[_builtins.int]:
        """
        The local autonomous system number (ASN) for the BGP
        speaker. This is a mandatory field and must be specified. Changing this
        creates a new BGP speaker.
        """
        return pulumi.get(self, "local_as")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        A name for the BGP speaker.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def networks(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A list of network IDs to associate with the BGP speaker.
        """
        return pulumi.get(self, "networks")

    @_builtins.property
    @pulumi.getter
    def peers(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A list of BGP peer IDs to associate with the BGP speaker.
        """
        return pulumi.get(self, "peers")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region in which to obtain the V2 Networking client.
        A Networking client is needed to create a Neutron network. If omitted, the
        `region` argument of the provider is used. Changing this creates a new BGP
        speaker.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[_builtins.str]:
        """
        The tenant/project ID. Required if admin privileges
        are used. Changing this creates a new BGP speaker.
        """
        return pulumi.get(self, "tenant_id")

