# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetNetworkResult',
    'AwaitableGetNetworkResult',
    'get_network',
    'get_network_output',
]

@pulumi.output_type
class GetNetworkResult:
    """
    A collection of values returned by getNetwork.
    """
    def __init__(__self__, admin_state_up=None, all_tags=None, availability_zone_hints=None, description=None, dns_domain=None, external=None, id=None, matching_subnet_cidr=None, mtu=None, name=None, network_id=None, region=None, segments=None, shared=None, status=None, subnets=None, tags=None, tenant_id=None, transparent_vlan=None):
        if admin_state_up and not isinstance(admin_state_up, str):
            raise TypeError("Expected argument 'admin_state_up' to be a str")
        pulumi.set(__self__, "admin_state_up", admin_state_up)
        if all_tags and not isinstance(all_tags, list):
            raise TypeError("Expected argument 'all_tags' to be a list")
        pulumi.set(__self__, "all_tags", all_tags)
        if availability_zone_hints and not isinstance(availability_zone_hints, list):
            raise TypeError("Expected argument 'availability_zone_hints' to be a list")
        pulumi.set(__self__, "availability_zone_hints", availability_zone_hints)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if dns_domain and not isinstance(dns_domain, str):
            raise TypeError("Expected argument 'dns_domain' to be a str")
        pulumi.set(__self__, "dns_domain", dns_domain)
        if external and not isinstance(external, bool):
            raise TypeError("Expected argument 'external' to be a bool")
        pulumi.set(__self__, "external", external)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if matching_subnet_cidr and not isinstance(matching_subnet_cidr, str):
            raise TypeError("Expected argument 'matching_subnet_cidr' to be a str")
        pulumi.set(__self__, "matching_subnet_cidr", matching_subnet_cidr)
        if mtu and not isinstance(mtu, int):
            raise TypeError("Expected argument 'mtu' to be a int")
        pulumi.set(__self__, "mtu", mtu)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if network_id and not isinstance(network_id, str):
            raise TypeError("Expected argument 'network_id' to be a str")
        pulumi.set(__self__, "network_id", network_id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if segments and not isinstance(segments, list):
            raise TypeError("Expected argument 'segments' to be a list")
        pulumi.set(__self__, "segments", segments)
        if shared and not isinstance(shared, str):
            raise TypeError("Expected argument 'shared' to be a str")
        pulumi.set(__self__, "shared", shared)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if subnets and not isinstance(subnets, list):
            raise TypeError("Expected argument 'subnets' to be a list")
        pulumi.set(__self__, "subnets", subnets)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if tenant_id and not isinstance(tenant_id, str):
            raise TypeError("Expected argument 'tenant_id' to be a str")
        pulumi.set(__self__, "tenant_id", tenant_id)
        if transparent_vlan and not isinstance(transparent_vlan, bool):
            raise TypeError("Expected argument 'transparent_vlan' to be a bool")
        pulumi.set(__self__, "transparent_vlan", transparent_vlan)

    @_builtins.property
    @pulumi.getter(name="adminStateUp")
    def admin_state_up(self) -> _builtins.str:
        """
        The administrative state of the network.
        """
        return pulumi.get(self, "admin_state_up")

    @_builtins.property
    @pulumi.getter(name="allTags")
    def all_tags(self) -> Sequence[_builtins.str]:
        """
        The set of string tags applied on the network.
        """
        return pulumi.get(self, "all_tags")

    @_builtins.property
    @pulumi.getter(name="availabilityZoneHints")
    def availability_zone_hints(self) -> Sequence[_builtins.str]:
        """
        The availability zone candidates for the network.
        """
        return pulumi.get(self, "availability_zone_hints")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="dnsDomain")
    def dns_domain(self) -> _builtins.str:
        """
        The network DNS domain. Available, when Neutron DNS extension
        is enabled
        """
        return pulumi.get(self, "dns_domain")

    @_builtins.property
    @pulumi.getter
    def external(self) -> Optional[_builtins.bool]:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "external")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="matchingSubnetCidr")
    def matching_subnet_cidr(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "matching_subnet_cidr")

    @_builtins.property
    @pulumi.getter
    def mtu(self) -> Optional[_builtins.int]:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "mtu")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "network_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def segments(self) -> Sequence['outputs.GetNetworkSegmentResult']:
        """
        An array of one or more provider segment objects.
        """
        return pulumi.get(self, "segments")

    @_builtins.property
    @pulumi.getter
    def shared(self) -> _builtins.str:
        """
        Specifies whether the network resource can be accessed by any
        tenant or not.
        """
        return pulumi.get(self, "shared")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def subnets(self) -> Sequence[_builtins.str]:
        """
        A list of subnet IDs belonging to the network.
        """
        return pulumi.get(self, "subnets")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[Sequence[_builtins.str]]:
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "tenant_id")

    @_builtins.property
    @pulumi.getter(name="transparentVlan")
    def transparent_vlan(self) -> Optional[_builtins.bool]:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "transparent_vlan")


class AwaitableGetNetworkResult(GetNetworkResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNetworkResult(
            admin_state_up=self.admin_state_up,
            all_tags=self.all_tags,
            availability_zone_hints=self.availability_zone_hints,
            description=self.description,
            dns_domain=self.dns_domain,
            external=self.external,
            id=self.id,
            matching_subnet_cidr=self.matching_subnet_cidr,
            mtu=self.mtu,
            name=self.name,
            network_id=self.network_id,
            region=self.region,
            segments=self.segments,
            shared=self.shared,
            status=self.status,
            subnets=self.subnets,
            tags=self.tags,
            tenant_id=self.tenant_id,
            transparent_vlan=self.transparent_vlan)


def get_network(description: Optional[_builtins.str] = None,
                external: Optional[_builtins.bool] = None,
                matching_subnet_cidr: Optional[_builtins.str] = None,
                mtu: Optional[_builtins.int] = None,
                name: Optional[_builtins.str] = None,
                network_id: Optional[_builtins.str] = None,
                region: Optional[_builtins.str] = None,
                status: Optional[_builtins.str] = None,
                tags: Optional[Sequence[_builtins.str]] = None,
                tenant_id: Optional[_builtins.str] = None,
                transparent_vlan: Optional[_builtins.bool] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNetworkResult:
    """
    Use this data source to get the ID of an available OpenStack network.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_openstack as openstack

    network = openstack.networking.get_network(name="tf_test_network")
    ```


    :param _builtins.str description: Human-readable description of the network.
    :param _builtins.bool external: The external routing facility of the network.
    :param _builtins.str matching_subnet_cidr: The CIDR of a subnet within the network.
    :param _builtins.int mtu: The network MTU to filter. Available, when Neutron `net-mtu`
           extension is enabled.
    :param _builtins.str name: The name of the network.
    :param _builtins.str network_id: The ID of the network.
    :param _builtins.str region: The region in which to obtain the V2 Neutron client.
           A Neutron client is needed to retrieve networks ids. If omitted, the
           `region` argument of the provider is used.
    :param _builtins.str status: The status of the network.
    :param Sequence[_builtins.str] tags: The list of network tags to filter.
    :param _builtins.str tenant_id: The owner of the network.
    :param _builtins.bool transparent_vlan: The VLAN transparent attribute for the
           network.
    """
    __args__ = dict()
    __args__['description'] = description
    __args__['external'] = external
    __args__['matchingSubnetCidr'] = matching_subnet_cidr
    __args__['mtu'] = mtu
    __args__['name'] = name
    __args__['networkId'] = network_id
    __args__['region'] = region
    __args__['status'] = status
    __args__['tags'] = tags
    __args__['tenantId'] = tenant_id
    __args__['transparentVlan'] = transparent_vlan
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('openstack:networking/getNetwork:getNetwork', __args__, opts=opts, typ=GetNetworkResult).value

    return AwaitableGetNetworkResult(
        admin_state_up=pulumi.get(__ret__, 'admin_state_up'),
        all_tags=pulumi.get(__ret__, 'all_tags'),
        availability_zone_hints=pulumi.get(__ret__, 'availability_zone_hints'),
        description=pulumi.get(__ret__, 'description'),
        dns_domain=pulumi.get(__ret__, 'dns_domain'),
        external=pulumi.get(__ret__, 'external'),
        id=pulumi.get(__ret__, 'id'),
        matching_subnet_cidr=pulumi.get(__ret__, 'matching_subnet_cidr'),
        mtu=pulumi.get(__ret__, 'mtu'),
        name=pulumi.get(__ret__, 'name'),
        network_id=pulumi.get(__ret__, 'network_id'),
        region=pulumi.get(__ret__, 'region'),
        segments=pulumi.get(__ret__, 'segments'),
        shared=pulumi.get(__ret__, 'shared'),
        status=pulumi.get(__ret__, 'status'),
        subnets=pulumi.get(__ret__, 'subnets'),
        tags=pulumi.get(__ret__, 'tags'),
        tenant_id=pulumi.get(__ret__, 'tenant_id'),
        transparent_vlan=pulumi.get(__ret__, 'transparent_vlan'))
def get_network_output(description: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       external: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                       matching_subnet_cidr: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       mtu: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                       name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       network_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       status: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       tags: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                       tenant_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       transparent_vlan: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetNetworkResult]:
    """
    Use this data source to get the ID of an available OpenStack network.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_openstack as openstack

    network = openstack.networking.get_network(name="tf_test_network")
    ```


    :param _builtins.str description: Human-readable description of the network.
    :param _builtins.bool external: The external routing facility of the network.
    :param _builtins.str matching_subnet_cidr: The CIDR of a subnet within the network.
    :param _builtins.int mtu: The network MTU to filter. Available, when Neutron `net-mtu`
           extension is enabled.
    :param _builtins.str name: The name of the network.
    :param _builtins.str network_id: The ID of the network.
    :param _builtins.str region: The region in which to obtain the V2 Neutron client.
           A Neutron client is needed to retrieve networks ids. If omitted, the
           `region` argument of the provider is used.
    :param _builtins.str status: The status of the network.
    :param Sequence[_builtins.str] tags: The list of network tags to filter.
    :param _builtins.str tenant_id: The owner of the network.
    :param _builtins.bool transparent_vlan: The VLAN transparent attribute for the
           network.
    """
    __args__ = dict()
    __args__['description'] = description
    __args__['external'] = external
    __args__['matchingSubnetCidr'] = matching_subnet_cidr
    __args__['mtu'] = mtu
    __args__['name'] = name
    __args__['networkId'] = network_id
    __args__['region'] = region
    __args__['status'] = status
    __args__['tags'] = tags
    __args__['tenantId'] = tenant_id
    __args__['transparentVlan'] = transparent_vlan
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('openstack:networking/getNetwork:getNetwork', __args__, opts=opts, typ=GetNetworkResult)
    return __ret__.apply(lambda __response__: GetNetworkResult(
        admin_state_up=pulumi.get(__response__, 'admin_state_up'),
        all_tags=pulumi.get(__response__, 'all_tags'),
        availability_zone_hints=pulumi.get(__response__, 'availability_zone_hints'),
        description=pulumi.get(__response__, 'description'),
        dns_domain=pulumi.get(__response__, 'dns_domain'),
        external=pulumi.get(__response__, 'external'),
        id=pulumi.get(__response__, 'id'),
        matching_subnet_cidr=pulumi.get(__response__, 'matching_subnet_cidr'),
        mtu=pulumi.get(__response__, 'mtu'),
        name=pulumi.get(__response__, 'name'),
        network_id=pulumi.get(__response__, 'network_id'),
        region=pulumi.get(__response__, 'region'),
        segments=pulumi.get(__response__, 'segments'),
        shared=pulumi.get(__response__, 'shared'),
        status=pulumi.get(__response__, 'status'),
        subnets=pulumi.get(__response__, 'subnets'),
        tags=pulumi.get(__response__, 'tags'),
        tenant_id=pulumi.get(__response__, 'tenant_id'),
        transparent_vlan=pulumi.get(__response__, 'transparent_vlan')))
