# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['TempUrlArgs', 'TempUrl']

@pulumi.input_type
class TempUrlArgs:
    def __init__(__self__, *,
                 container: pulumi.Input[_builtins.str],
                 object: pulumi.Input[_builtins.str],
                 ttl: pulumi.Input[_builtins.int],
                 digest: Optional[pulumi.Input[_builtins.str]] = None,
                 key: Optional[pulumi.Input[_builtins.str]] = None,
                 method: Optional[pulumi.Input[_builtins.str]] = None,
                 regenerate: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 split: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a TempUrl resource.
        :param pulumi.Input[_builtins.str] container: The container name the object belongs to.
        :param pulumi.Input[_builtins.str] object: The object name the tempurl is for.
        :param pulumi.Input[_builtins.int] ttl: The TTL, in seconds, for the URL. For how long it should
               be valid.
        :param pulumi.Input[_builtins.str] digest: The digest to use when generating the tempurl.
               Supported values are `sha1`, `sha256` and `sha512`. Default is `sha1`.
        :param pulumi.Input[_builtins.str] key: The key to use when generating the tempurl. If not
               provided, the key will be read from the container or account metadata.
        :param pulumi.Input[_builtins.str] method: The method allowed when accessing this URL.
               Valid values are `GET`, and `POST`. Default is `GET`.
        :param pulumi.Input[_builtins.bool] regenerate: Whether to automatically regenerate the URL when
               it has expired. If set to true, this will create a new resource with a new
               ID and new URL. Defaults to false.
        :param pulumi.Input[_builtins.str] region: The region the tempurl is located in.
        :param pulumi.Input[_builtins.str] split: Split is the string on which to split the object URL.
               Default is `/v1/`.
        """
        pulumi.set(__self__, "container", container)
        pulumi.set(__self__, "object", object)
        pulumi.set(__self__, "ttl", ttl)
        if digest is not None:
            pulumi.set(__self__, "digest", digest)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if method is not None:
            pulumi.set(__self__, "method", method)
        if regenerate is not None:
            pulumi.set(__self__, "regenerate", regenerate)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if split is not None:
            pulumi.set(__self__, "split", split)

    @_builtins.property
    @pulumi.getter
    def container(self) -> pulumi.Input[_builtins.str]:
        """
        The container name the object belongs to.
        """
        return pulumi.get(self, "container")

    @container.setter
    def container(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "container", value)

    @_builtins.property
    @pulumi.getter
    def object(self) -> pulumi.Input[_builtins.str]:
        """
        The object name the tempurl is for.
        """
        return pulumi.get(self, "object")

    @object.setter
    def object(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "object", value)

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> pulumi.Input[_builtins.int]:
        """
        The TTL, in seconds, for the URL. For how long it should
        be valid.
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "ttl", value)

    @_builtins.property
    @pulumi.getter
    def digest(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The digest to use when generating the tempurl.
        Supported values are `sha1`, `sha256` and `sha512`. Default is `sha1`.
        """
        return pulumi.get(self, "digest")

    @digest.setter
    def digest(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "digest", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The key to use when generating the tempurl. If not
        provided, the key will be read from the container or account metadata.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key", value)

    @_builtins.property
    @pulumi.getter
    def method(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The method allowed when accessing this URL.
        Valid values are `GET`, and `POST`. Default is `GET`.
        """
        return pulumi.get(self, "method")

    @method.setter
    def method(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "method", value)

    @_builtins.property
    @pulumi.getter
    def regenerate(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to automatically regenerate the URL when
        it has expired. If set to true, this will create a new resource with a new
        ID and new URL. Defaults to false.
        """
        return pulumi.get(self, "regenerate")

    @regenerate.setter
    def regenerate(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "regenerate", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region the tempurl is located in.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def split(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Split is the string on which to split the object URL.
        Default is `/v1/`.
        """
        return pulumi.get(self, "split")

    @split.setter
    def split(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "split", value)


@pulumi.input_type
class _TempUrlState:
    def __init__(__self__, *,
                 container: Optional[pulumi.Input[_builtins.str]] = None,
                 digest: Optional[pulumi.Input[_builtins.str]] = None,
                 key: Optional[pulumi.Input[_builtins.str]] = None,
                 method: Optional[pulumi.Input[_builtins.str]] = None,
                 object: Optional[pulumi.Input[_builtins.str]] = None,
                 regenerate: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 split: Optional[pulumi.Input[_builtins.str]] = None,
                 ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering TempUrl resources.
        :param pulumi.Input[_builtins.str] container: The container name the object belongs to.
        :param pulumi.Input[_builtins.str] digest: The digest to use when generating the tempurl.
               Supported values are `sha1`, `sha256` and `sha512`. Default is `sha1`.
        :param pulumi.Input[_builtins.str] key: The key to use when generating the tempurl. If not
               provided, the key will be read from the container or account metadata.
        :param pulumi.Input[_builtins.str] method: The method allowed when accessing this URL.
               Valid values are `GET`, and `POST`. Default is `GET`.
        :param pulumi.Input[_builtins.str] object: The object name the tempurl is for.
        :param pulumi.Input[_builtins.bool] regenerate: Whether to automatically regenerate the URL when
               it has expired. If set to true, this will create a new resource with a new
               ID and new URL. Defaults to false.
        :param pulumi.Input[_builtins.str] region: The region the tempurl is located in.
        :param pulumi.Input[_builtins.str] split: Split is the string on which to split the object URL.
               Default is `/v1/`.
        :param pulumi.Input[_builtins.int] ttl: The TTL, in seconds, for the URL. For how long it should
               be valid.
        :param pulumi.Input[_builtins.str] url: The URL
        """
        if container is not None:
            pulumi.set(__self__, "container", container)
        if digest is not None:
            pulumi.set(__self__, "digest", digest)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if method is not None:
            pulumi.set(__self__, "method", method)
        if object is not None:
            pulumi.set(__self__, "object", object)
        if regenerate is not None:
            pulumi.set(__self__, "regenerate", regenerate)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if split is not None:
            pulumi.set(__self__, "split", split)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @_builtins.property
    @pulumi.getter
    def container(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The container name the object belongs to.
        """
        return pulumi.get(self, "container")

    @container.setter
    def container(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "container", value)

    @_builtins.property
    @pulumi.getter
    def digest(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The digest to use when generating the tempurl.
        Supported values are `sha1`, `sha256` and `sha512`. Default is `sha1`.
        """
        return pulumi.get(self, "digest")

    @digest.setter
    def digest(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "digest", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The key to use when generating the tempurl. If not
        provided, the key will be read from the container or account metadata.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key", value)

    @_builtins.property
    @pulumi.getter
    def method(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The method allowed when accessing this URL.
        Valid values are `GET`, and `POST`. Default is `GET`.
        """
        return pulumi.get(self, "method")

    @method.setter
    def method(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "method", value)

    @_builtins.property
    @pulumi.getter
    def object(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The object name the tempurl is for.
        """
        return pulumi.get(self, "object")

    @object.setter
    def object(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "object", value)

    @_builtins.property
    @pulumi.getter
    def regenerate(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to automatically regenerate the URL when
        it has expired. If set to true, this will create a new resource with a new
        ID and new URL. Defaults to false.
        """
        return pulumi.get(self, "regenerate")

    @regenerate.setter
    def regenerate(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "regenerate", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region the tempurl is located in.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def split(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Split is the string on which to split the object URL.
        Default is `/v1/`.
        """
        return pulumi.get(self, "split")

    @split.setter
    def split(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "split", value)

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The TTL, in seconds, for the URL. For how long it should
        be valid.
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ttl", value)

    @_builtins.property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URL
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "url", value)


@pulumi.type_token("openstack:objectstorage/tempUrl:TempUrl")
class TempUrl(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 container: Optional[pulumi.Input[_builtins.str]] = None,
                 digest: Optional[pulumi.Input[_builtins.str]] = None,
                 key: Optional[pulumi.Input[_builtins.str]] = None,
                 method: Optional[pulumi.Input[_builtins.str]] = None,
                 object: Optional[pulumi.Input[_builtins.str]] = None,
                 regenerate: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 split: Optional[pulumi.Input[_builtins.str]] = None,
                 ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Use this resource to generate an OpenStack Object Storage temporary URL.

        The temporary URL will be valid for as long as TTL is set to (in seconds).
        Once the URL has expired, it will no longer be valid, but the resource
        will remain in place. If you wish to automatically regenerate a URL, set
        the `regenerate` argument to `true`. This will create a new resource with
        a new ID and URL.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_openstack as openstack

        container1 = openstack.objectstorage.Container("container_1",
            name="test",
            metadata={
                "Temp-URL-Key": "testkey",
            })
        object1 = openstack.objectstorage.ContainerObject("object_1",
            container_name=container1.name,
            name="test",
            content="Hello, world!")
        obj_tempurl = openstack.objectstorage.TempUrl("obj_tempurl",
            container=container1.name,
            object=object1.name,
            method="post",
            ttl=20)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] container: The container name the object belongs to.
        :param pulumi.Input[_builtins.str] digest: The digest to use when generating the tempurl.
               Supported values are `sha1`, `sha256` and `sha512`. Default is `sha1`.
        :param pulumi.Input[_builtins.str] key: The key to use when generating the tempurl. If not
               provided, the key will be read from the container or account metadata.
        :param pulumi.Input[_builtins.str] method: The method allowed when accessing this URL.
               Valid values are `GET`, and `POST`. Default is `GET`.
        :param pulumi.Input[_builtins.str] object: The object name the tempurl is for.
        :param pulumi.Input[_builtins.bool] regenerate: Whether to automatically regenerate the URL when
               it has expired. If set to true, this will create a new resource with a new
               ID and new URL. Defaults to false.
        :param pulumi.Input[_builtins.str] region: The region the tempurl is located in.
        :param pulumi.Input[_builtins.str] split: Split is the string on which to split the object URL.
               Default is `/v1/`.
        :param pulumi.Input[_builtins.int] ttl: The TTL, in seconds, for the URL. For how long it should
               be valid.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TempUrlArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Use this resource to generate an OpenStack Object Storage temporary URL.

        The temporary URL will be valid for as long as TTL is set to (in seconds).
        Once the URL has expired, it will no longer be valid, but the resource
        will remain in place. If you wish to automatically regenerate a URL, set
        the `regenerate` argument to `true`. This will create a new resource with
        a new ID and URL.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_openstack as openstack

        container1 = openstack.objectstorage.Container("container_1",
            name="test",
            metadata={
                "Temp-URL-Key": "testkey",
            })
        object1 = openstack.objectstorage.ContainerObject("object_1",
            container_name=container1.name,
            name="test",
            content="Hello, world!")
        obj_tempurl = openstack.objectstorage.TempUrl("obj_tempurl",
            container=container1.name,
            object=object1.name,
            method="post",
            ttl=20)
        ```

        :param str resource_name: The name of the resource.
        :param TempUrlArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TempUrlArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 container: Optional[pulumi.Input[_builtins.str]] = None,
                 digest: Optional[pulumi.Input[_builtins.str]] = None,
                 key: Optional[pulumi.Input[_builtins.str]] = None,
                 method: Optional[pulumi.Input[_builtins.str]] = None,
                 object: Optional[pulumi.Input[_builtins.str]] = None,
                 regenerate: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 split: Optional[pulumi.Input[_builtins.str]] = None,
                 ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TempUrlArgs.__new__(TempUrlArgs)

            if container is None and not opts.urn:
                raise TypeError("Missing required property 'container'")
            __props__.__dict__["container"] = container
            __props__.__dict__["digest"] = digest
            __props__.__dict__["key"] = None if key is None else pulumi.Output.secret(key)
            __props__.__dict__["method"] = method
            if object is None and not opts.urn:
                raise TypeError("Missing required property 'object'")
            __props__.__dict__["object"] = object
            __props__.__dict__["regenerate"] = regenerate
            __props__.__dict__["region"] = region
            __props__.__dict__["split"] = split
            if ttl is None and not opts.urn:
                raise TypeError("Missing required property 'ttl'")
            __props__.__dict__["ttl"] = ttl
            __props__.__dict__["url"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["key", "url"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(TempUrl, __self__).__init__(
            'openstack:objectstorage/tempUrl:TempUrl',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            container: Optional[pulumi.Input[_builtins.str]] = None,
            digest: Optional[pulumi.Input[_builtins.str]] = None,
            key: Optional[pulumi.Input[_builtins.str]] = None,
            method: Optional[pulumi.Input[_builtins.str]] = None,
            object: Optional[pulumi.Input[_builtins.str]] = None,
            regenerate: Optional[pulumi.Input[_builtins.bool]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            split: Optional[pulumi.Input[_builtins.str]] = None,
            ttl: Optional[pulumi.Input[_builtins.int]] = None,
            url: Optional[pulumi.Input[_builtins.str]] = None) -> 'TempUrl':
        """
        Get an existing TempUrl resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] container: The container name the object belongs to.
        :param pulumi.Input[_builtins.str] digest: The digest to use when generating the tempurl.
               Supported values are `sha1`, `sha256` and `sha512`. Default is `sha1`.
        :param pulumi.Input[_builtins.str] key: The key to use when generating the tempurl. If not
               provided, the key will be read from the container or account metadata.
        :param pulumi.Input[_builtins.str] method: The method allowed when accessing this URL.
               Valid values are `GET`, and `POST`. Default is `GET`.
        :param pulumi.Input[_builtins.str] object: The object name the tempurl is for.
        :param pulumi.Input[_builtins.bool] regenerate: Whether to automatically regenerate the URL when
               it has expired. If set to true, this will create a new resource with a new
               ID and new URL. Defaults to false.
        :param pulumi.Input[_builtins.str] region: The region the tempurl is located in.
        :param pulumi.Input[_builtins.str] split: Split is the string on which to split the object URL.
               Default is `/v1/`.
        :param pulumi.Input[_builtins.int] ttl: The TTL, in seconds, for the URL. For how long it should
               be valid.
        :param pulumi.Input[_builtins.str] url: The URL
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TempUrlState.__new__(_TempUrlState)

        __props__.__dict__["container"] = container
        __props__.__dict__["digest"] = digest
        __props__.__dict__["key"] = key
        __props__.__dict__["method"] = method
        __props__.__dict__["object"] = object
        __props__.__dict__["regenerate"] = regenerate
        __props__.__dict__["region"] = region
        __props__.__dict__["split"] = split
        __props__.__dict__["ttl"] = ttl
        __props__.__dict__["url"] = url
        return TempUrl(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def container(self) -> pulumi.Output[_builtins.str]:
        """
        The container name the object belongs to.
        """
        return pulumi.get(self, "container")

    @_builtins.property
    @pulumi.getter
    def digest(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The digest to use when generating the tempurl.
        Supported values are `sha1`, `sha256` and `sha512`. Default is `sha1`.
        """
        return pulumi.get(self, "digest")

    @_builtins.property
    @pulumi.getter
    def key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The key to use when generating the tempurl. If not
        provided, the key will be read from the container or account metadata.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def method(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The method allowed when accessing this URL.
        Valid values are `GET`, and `POST`. Default is `GET`.
        """
        return pulumi.get(self, "method")

    @_builtins.property
    @pulumi.getter
    def object(self) -> pulumi.Output[_builtins.str]:
        """
        The object name the tempurl is for.
        """
        return pulumi.get(self, "object")

    @_builtins.property
    @pulumi.getter
    def regenerate(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to automatically regenerate the URL when
        it has expired. If set to true, this will create a new resource with a new
        ID and new URL. Defaults to false.
        """
        return pulumi.get(self, "regenerate")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region the tempurl is located in.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def split(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Split is the string on which to split the object URL.
        Default is `/v1/`.
        """
        return pulumi.get(self, "split")

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> pulumi.Output[_builtins.int]:
        """
        The TTL, in seconds, for the URL. For how long it should
        be valid.
        """
        return pulumi.get(self, "ttl")

    @_builtins.property
    @pulumi.getter
    def url(self) -> pulumi.Output[_builtins.str]:
        """
        The URL
        """
        return pulumi.get(self, "url")

