# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetShareNetworkResult',
    'AwaitableGetShareNetworkResult',
    'get_share_network',
    'get_share_network_output',
]

@pulumi.output_type
class GetShareNetworkResult:
    """
    A collection of values returned by getShareNetwork.
    """
    def __init__(__self__, cidr=None, description=None, id=None, ip_version=None, name=None, network_type=None, neutron_net_id=None, neutron_subnet_id=None, project_id=None, region=None, security_service_id=None, security_service_ids=None, segmentation_id=None):
        if cidr and not isinstance(cidr, str):
            raise TypeError("Expected argument 'cidr' to be a str")
        pulumi.set(__self__, "cidr", cidr)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ip_version and not isinstance(ip_version, int):
            raise TypeError("Expected argument 'ip_version' to be a int")
        pulumi.set(__self__, "ip_version", ip_version)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if network_type and not isinstance(network_type, str):
            raise TypeError("Expected argument 'network_type' to be a str")
        pulumi.set(__self__, "network_type", network_type)
        if neutron_net_id and not isinstance(neutron_net_id, str):
            raise TypeError("Expected argument 'neutron_net_id' to be a str")
        pulumi.set(__self__, "neutron_net_id", neutron_net_id)
        if neutron_subnet_id and not isinstance(neutron_subnet_id, str):
            raise TypeError("Expected argument 'neutron_subnet_id' to be a str")
        pulumi.set(__self__, "neutron_subnet_id", neutron_subnet_id)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if security_service_id and not isinstance(security_service_id, str):
            raise TypeError("Expected argument 'security_service_id' to be a str")
        pulumi.set(__self__, "security_service_id", security_service_id)
        if security_service_ids and not isinstance(security_service_ids, list):
            raise TypeError("Expected argument 'security_service_ids' to be a list")
        pulumi.set(__self__, "security_service_ids", security_service_ids)
        if segmentation_id and not isinstance(segmentation_id, int):
            raise TypeError("Expected argument 'segmentation_id' to be a int")
        pulumi.set(__self__, "segmentation_id", segmentation_id)

    @_builtins.property
    @pulumi.getter
    def cidr(self) -> _builtins.str:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "cidr")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> _builtins.int:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "ip_version")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkType")
    def network_type(self) -> _builtins.str:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "network_type")

    @_builtins.property
    @pulumi.getter(name="neutronNetId")
    def neutron_net_id(self) -> _builtins.str:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "neutron_net_id")

    @_builtins.property
    @pulumi.getter(name="neutronSubnetId")
    def neutron_subnet_id(self) -> _builtins.str:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "neutron_subnet_id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.str:
        """
        The owner of the Share Network.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="securityServiceId")
    def security_service_id(self) -> Optional[_builtins.str]:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "security_service_id")

    @_builtins.property
    @pulumi.getter(name="securityServiceIds")
    def security_service_ids(self) -> Sequence[_builtins.str]:
        """
        The list of security service IDs associated with
        the share network.
        """
        return pulumi.get(self, "security_service_ids")

    @_builtins.property
    @pulumi.getter(name="segmentationId")
    def segmentation_id(self) -> _builtins.int:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "segmentation_id")


class AwaitableGetShareNetworkResult(GetShareNetworkResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetShareNetworkResult(
            cidr=self.cidr,
            description=self.description,
            id=self.id,
            ip_version=self.ip_version,
            name=self.name,
            network_type=self.network_type,
            neutron_net_id=self.neutron_net_id,
            neutron_subnet_id=self.neutron_subnet_id,
            project_id=self.project_id,
            region=self.region,
            security_service_id=self.security_service_id,
            security_service_ids=self.security_service_ids,
            segmentation_id=self.segmentation_id)


def get_share_network(description: Optional[_builtins.str] = None,
                      ip_version: Optional[_builtins.int] = None,
                      name: Optional[_builtins.str] = None,
                      network_type: Optional[_builtins.str] = None,
                      neutron_net_id: Optional[_builtins.str] = None,
                      neutron_subnet_id: Optional[_builtins.str] = None,
                      region: Optional[_builtins.str] = None,
                      security_service_id: Optional[_builtins.str] = None,
                      segmentation_id: Optional[_builtins.int] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetShareNetworkResult:
    """
    Use this data source to get the ID of an available Shared File System share network.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_openstack as openstack

    sharenetwork1 = openstack.sharedfilesystem.get_share_network(name="sharenetwork_1")
    ```


    :param _builtins.str description: The human-readable description of the share network.
    :param _builtins.int ip_version: The IP version of the share network. Can either be 4 or 6.
    :param _builtins.str name: The name of the share network.
    :param _builtins.str network_type: The share network type. Can either be VLAN, VXLAN,
           GRE, or flat.
    :param _builtins.str neutron_net_id: The neutron network UUID of the share network.
    :param _builtins.str neutron_subnet_id: The neutron subnet UUID of the share network.
    :param _builtins.str region: The region in which to obtain the V2 Shared File System client.
           A Shared File System client is needed to read a share network. If omitted, the
           `region` argument of the provider is used.
    :param _builtins.str security_service_id: The security service IDs associated with
           the share network.
    :param _builtins.int segmentation_id: The share network segmentation ID.
    """
    __args__ = dict()
    __args__['description'] = description
    __args__['ipVersion'] = ip_version
    __args__['name'] = name
    __args__['networkType'] = network_type
    __args__['neutronNetId'] = neutron_net_id
    __args__['neutronSubnetId'] = neutron_subnet_id
    __args__['region'] = region
    __args__['securityServiceId'] = security_service_id
    __args__['segmentationId'] = segmentation_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('openstack:sharedfilesystem/getShareNetwork:getShareNetwork', __args__, opts=opts, typ=GetShareNetworkResult).value

    return AwaitableGetShareNetworkResult(
        cidr=pulumi.get(__ret__, 'cidr'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        ip_version=pulumi.get(__ret__, 'ip_version'),
        name=pulumi.get(__ret__, 'name'),
        network_type=pulumi.get(__ret__, 'network_type'),
        neutron_net_id=pulumi.get(__ret__, 'neutron_net_id'),
        neutron_subnet_id=pulumi.get(__ret__, 'neutron_subnet_id'),
        project_id=pulumi.get(__ret__, 'project_id'),
        region=pulumi.get(__ret__, 'region'),
        security_service_id=pulumi.get(__ret__, 'security_service_id'),
        security_service_ids=pulumi.get(__ret__, 'security_service_ids'),
        segmentation_id=pulumi.get(__ret__, 'segmentation_id'))
def get_share_network_output(description: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             ip_version: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                             name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             network_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             neutron_net_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             neutron_subnet_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             security_service_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             segmentation_id: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetShareNetworkResult]:
    """
    Use this data source to get the ID of an available Shared File System share network.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_openstack as openstack

    sharenetwork1 = openstack.sharedfilesystem.get_share_network(name="sharenetwork_1")
    ```


    :param _builtins.str description: The human-readable description of the share network.
    :param _builtins.int ip_version: The IP version of the share network. Can either be 4 or 6.
    :param _builtins.str name: The name of the share network.
    :param _builtins.str network_type: The share network type. Can either be VLAN, VXLAN,
           GRE, or flat.
    :param _builtins.str neutron_net_id: The neutron network UUID of the share network.
    :param _builtins.str neutron_subnet_id: The neutron subnet UUID of the share network.
    :param _builtins.str region: The region in which to obtain the V2 Shared File System client.
           A Shared File System client is needed to read a share network. If omitted, the
           `region` argument of the provider is used.
    :param _builtins.str security_service_id: The security service IDs associated with
           the share network.
    :param _builtins.int segmentation_id: The share network segmentation ID.
    """
    __args__ = dict()
    __args__['description'] = description
    __args__['ipVersion'] = ip_version
    __args__['name'] = name
    __args__['networkType'] = network_type
    __args__['neutronNetId'] = neutron_net_id
    __args__['neutronSubnetId'] = neutron_subnet_id
    __args__['region'] = region
    __args__['securityServiceId'] = security_service_id
    __args__['segmentationId'] = segmentation_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('openstack:sharedfilesystem/getShareNetwork:getShareNetwork', __args__, opts=opts, typ=GetShareNetworkResult)
    return __ret__.apply(lambda __response__: GetShareNetworkResult(
        cidr=pulumi.get(__response__, 'cidr'),
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        ip_version=pulumi.get(__response__, 'ip_version'),
        name=pulumi.get(__response__, 'name'),
        network_type=pulumi.get(__response__, 'network_type'),
        neutron_net_id=pulumi.get(__response__, 'neutron_net_id'),
        neutron_subnet_id=pulumi.get(__response__, 'neutron_subnet_id'),
        project_id=pulumi.get(__response__, 'project_id'),
        region=pulumi.get(__response__, 'region'),
        security_service_id=pulumi.get(__response__, 'security_service_id'),
        security_service_ids=pulumi.get(__response__, 'security_service_ids'),
        segmentation_id=pulumi.get(__response__, 'segmentation_id')))
