# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetConfigurationResult',
    'AwaitableGetConfigurationResult',
    'get_configuration',
    'get_configuration_output',
]

@pulumi.output_type
class GetConfigurationResult:
    """
    A collection of values returned by getConfiguration.
    """
    def __init__(__self__, client_configuration=None, cluster_name=None, endpoints=None, id=None, nodes=None, talos_config=None):
        if client_configuration and not isinstance(client_configuration, dict):
            raise TypeError("Expected argument 'client_configuration' to be a dict")
        pulumi.set(__self__, "client_configuration", client_configuration)
        if cluster_name and not isinstance(cluster_name, str):
            raise TypeError("Expected argument 'cluster_name' to be a str")
        pulumi.set(__self__, "cluster_name", cluster_name)
        if endpoints and not isinstance(endpoints, list):
            raise TypeError("Expected argument 'endpoints' to be a list")
        pulumi.set(__self__, "endpoints", endpoints)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if nodes and not isinstance(nodes, list):
            raise TypeError("Expected argument 'nodes' to be a list")
        pulumi.set(__self__, "nodes", nodes)
        if talos_config and not isinstance(talos_config, str):
            raise TypeError("Expected argument 'talos_config' to be a str")
        pulumi.set(__self__, "talos_config", talos_config)

    @property
    @pulumi.getter(name="clientConfiguration")
    def client_configuration(self) -> 'outputs.GetConfigurationClientConfigurationResult':
        """
        The client configuration data
        """
        return pulumi.get(self, "client_configuration")

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> builtins.str:
        """
        The name of the cluster in the generated config
        """
        return pulumi.get(self, "cluster_name")

    @property
    @pulumi.getter
    def endpoints(self) -> Optional[Sequence[builtins.str]]:
        """
        endpoints to set in the generated config
        """
        return pulumi.get(self, "endpoints")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The ID of this resource
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def nodes(self) -> Optional[Sequence[builtins.str]]:
        """
        nodes to set in the generated config
        """
        return pulumi.get(self, "nodes")

    @property
    @pulumi.getter(name="talosConfig")
    def talos_config(self) -> builtins.str:
        """
        The generated client configuration
        """
        return pulumi.get(self, "talos_config")


class AwaitableGetConfigurationResult(GetConfigurationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetConfigurationResult(
            client_configuration=self.client_configuration,
            cluster_name=self.cluster_name,
            endpoints=self.endpoints,
            id=self.id,
            nodes=self.nodes,
            talos_config=self.talos_config)


def get_configuration(client_configuration: Optional[Union['GetConfigurationClientConfigurationArgs', 'GetConfigurationClientConfigurationArgsDict']] = None,
                      cluster_name: Optional[builtins.str] = None,
                      endpoints: Optional[Sequence[builtins.str]] = None,
                      nodes: Optional[Sequence[builtins.str]] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetConfigurationResult:
    """
    Generate client configuration for a Talos cluster

    ## Example Usage

    ```python
    import pulumi
    import pulumi_talos as talos
    import pulumiverse_talos as talos

    this_secrets = talos.machine.Secrets("this")
    this = talos.client.get_configuration_output(cluster_name="example-cluster",
        client_configuration=this_secrets.client_configuration,
        nodes=["10.5.0.2"])
    ```


    :param Union['GetConfigurationClientConfigurationArgs', 'GetConfigurationClientConfigurationArgsDict'] client_configuration: The client configuration data
    :param builtins.str cluster_name: The name of the cluster in the generated config
    :param Sequence[builtins.str] endpoints: endpoints to set in the generated config
    :param Sequence[builtins.str] nodes: nodes to set in the generated config
    """
    __args__ = dict()
    __args__['clientConfiguration'] = client_configuration
    __args__['clusterName'] = cluster_name
    __args__['endpoints'] = endpoints
    __args__['nodes'] = nodes
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('talos:client/getConfiguration:getConfiguration', __args__, opts=opts, typ=GetConfigurationResult).value

    return AwaitableGetConfigurationResult(
        client_configuration=pulumi.get(__ret__, 'client_configuration'),
        cluster_name=pulumi.get(__ret__, 'cluster_name'),
        endpoints=pulumi.get(__ret__, 'endpoints'),
        id=pulumi.get(__ret__, 'id'),
        nodes=pulumi.get(__ret__, 'nodes'),
        talos_config=pulumi.get(__ret__, 'talos_config'))
def get_configuration_output(client_configuration: Optional[pulumi.Input[Union['GetConfigurationClientConfigurationArgs', 'GetConfigurationClientConfigurationArgsDict']]] = None,
                             cluster_name: Optional[pulumi.Input[builtins.str]] = None,
                             endpoints: Optional[pulumi.Input[Optional[Sequence[builtins.str]]]] = None,
                             nodes: Optional[pulumi.Input[Optional[Sequence[builtins.str]]]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetConfigurationResult]:
    """
    Generate client configuration for a Talos cluster

    ## Example Usage

    ```python
    import pulumi
    import pulumi_talos as talos
    import pulumiverse_talos as talos

    this_secrets = talos.machine.Secrets("this")
    this = talos.client.get_configuration_output(cluster_name="example-cluster",
        client_configuration=this_secrets.client_configuration,
        nodes=["10.5.0.2"])
    ```


    :param Union['GetConfigurationClientConfigurationArgs', 'GetConfigurationClientConfigurationArgsDict'] client_configuration: The client configuration data
    :param builtins.str cluster_name: The name of the cluster in the generated config
    :param Sequence[builtins.str] endpoints: endpoints to set in the generated config
    :param Sequence[builtins.str] nodes: nodes to set in the generated config
    """
    __args__ = dict()
    __args__['clientConfiguration'] = client_configuration
    __args__['clusterName'] = cluster_name
    __args__['endpoints'] = endpoints
    __args__['nodes'] = nodes
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('talos:client/getConfiguration:getConfiguration', __args__, opts=opts, typ=GetConfigurationResult)
    return __ret__.apply(lambda __response__: GetConfigurationResult(
        client_configuration=pulumi.get(__response__, 'client_configuration'),
        cluster_name=pulumi.get(__response__, 'cluster_name'),
        endpoints=pulumi.get(__response__, 'endpoints'),
        id=pulumi.get(__response__, 'id'),
        nodes=pulumi.get(__response__, 'nodes'),
        talos_config=pulumi.get(__response__, 'talos_config')))
