# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetKubeconfigResult',
    'AwaitableGetKubeconfigResult',
    'get_kubeconfig',
    'get_kubeconfig_output',
]

@pulumi.output_type
class GetKubeconfigResult:
    """
    A collection of values returned by getKubeconfig.
    """
    def __init__(__self__, client_configuration=None, endpoint=None, id=None, kubeconfig_raw=None, kubernetes_client_configuration=None, node=None, timeouts=None, wait=None):
        if client_configuration and not isinstance(client_configuration, dict):
            raise TypeError("Expected argument 'client_configuration' to be a dict")
        pulumi.set(__self__, "client_configuration", client_configuration)
        if endpoint and not isinstance(endpoint, str):
            raise TypeError("Expected argument 'endpoint' to be a str")
        pulumi.set(__self__, "endpoint", endpoint)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if kubeconfig_raw and not isinstance(kubeconfig_raw, str):
            raise TypeError("Expected argument 'kubeconfig_raw' to be a str")
        pulumi.set(__self__, "kubeconfig_raw", kubeconfig_raw)
        if kubernetes_client_configuration and not isinstance(kubernetes_client_configuration, dict):
            raise TypeError("Expected argument 'kubernetes_client_configuration' to be a dict")
        pulumi.set(__self__, "kubernetes_client_configuration", kubernetes_client_configuration)
        if node and not isinstance(node, str):
            raise TypeError("Expected argument 'node' to be a str")
        pulumi.set(__self__, "node", node)
        if timeouts and not isinstance(timeouts, dict):
            raise TypeError("Expected argument 'timeouts' to be a dict")
        pulumi.set(__self__, "timeouts", timeouts)
        if wait and not isinstance(wait, bool):
            raise TypeError("Expected argument 'wait' to be a bool")
        pulumi.set(__self__, "wait", wait)

    @property
    @pulumi.getter(name="clientConfiguration")
    def client_configuration(self) -> 'outputs.GetKubeconfigClientConfigurationResult':
        """
        The client configuration data
        """
        return pulumi.get(self, "client_configuration")

    @property
    @pulumi.getter
    def endpoint(self) -> builtins.str:
        """
        endpoint to use for the talosclient. If not set, the node value will be used
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The ID of this resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="kubeconfigRaw")
    def kubeconfig_raw(self) -> builtins.str:
        """
        The raw kubeconfig
        """
        return pulumi.get(self, "kubeconfig_raw")

    @property
    @pulumi.getter(name="kubernetesClientConfiguration")
    def kubernetes_client_configuration(self) -> 'outputs.GetKubeconfigKubernetesClientConfigurationResult':
        """
        The kubernetes client configuration
        """
        return pulumi.get(self, "kubernetes_client_configuration")

    @property
    @pulumi.getter
    def node(self) -> builtins.str:
        """
        controlplane node to retrieve the kubeconfig from
        """
        return pulumi.get(self, "node")

    @property
    @pulumi.getter
    def timeouts(self) -> Optional['outputs.GetKubeconfigTimeoutsResult']:
        return pulumi.get(self, "timeouts")

    @property
    @pulumi.getter
    @_utilities.deprecated("""This attribute is deprecated and no-op. Will be removed in a future version. Use cluster_get_health instead.""")
    def wait(self) -> Optional[builtins.bool]:
        """
        Wait for the kubernetes api to be available
        """
        return pulumi.get(self, "wait")


class AwaitableGetKubeconfigResult(GetKubeconfigResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetKubeconfigResult(
            client_configuration=self.client_configuration,
            endpoint=self.endpoint,
            id=self.id,
            kubeconfig_raw=self.kubeconfig_raw,
            kubernetes_client_configuration=self.kubernetes_client_configuration,
            node=self.node,
            timeouts=self.timeouts,
            wait=self.wait)


def get_kubeconfig(client_configuration: Optional[Union['GetKubeconfigClientConfigurationArgs', 'GetKubeconfigClientConfigurationArgsDict']] = None,
                   endpoint: Optional[builtins.str] = None,
                   node: Optional[builtins.str] = None,
                   timeouts: Optional[Union['GetKubeconfigTimeoutsArgs', 'GetKubeconfigTimeoutsArgsDict']] = None,
                   wait: Optional[builtins.bool] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetKubeconfigResult:
    """
    Retrieves the kubeconfig for a Talos cluster


    :param Union['GetKubeconfigClientConfigurationArgs', 'GetKubeconfigClientConfigurationArgsDict'] client_configuration: The client configuration data
    :param builtins.str endpoint: endpoint to use for the talosclient. If not set, the node value will be used
    :param builtins.str node: controlplane node to retrieve the kubeconfig from
    :param builtins.bool wait: Wait for the kubernetes api to be available
    """
    __args__ = dict()
    __args__['clientConfiguration'] = client_configuration
    __args__['endpoint'] = endpoint
    __args__['node'] = node
    __args__['timeouts'] = timeouts
    __args__['wait'] = wait
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('talos:cluster/getKubeconfig:getKubeconfig', __args__, opts=opts, typ=GetKubeconfigResult).value

    return AwaitableGetKubeconfigResult(
        client_configuration=pulumi.get(__ret__, 'client_configuration'),
        endpoint=pulumi.get(__ret__, 'endpoint'),
        id=pulumi.get(__ret__, 'id'),
        kubeconfig_raw=pulumi.get(__ret__, 'kubeconfig_raw'),
        kubernetes_client_configuration=pulumi.get(__ret__, 'kubernetes_client_configuration'),
        node=pulumi.get(__ret__, 'node'),
        timeouts=pulumi.get(__ret__, 'timeouts'),
        wait=pulumi.get(__ret__, 'wait'))
def get_kubeconfig_output(client_configuration: Optional[pulumi.Input[Union['GetKubeconfigClientConfigurationArgs', 'GetKubeconfigClientConfigurationArgsDict']]] = None,
                          endpoint: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                          node: Optional[pulumi.Input[builtins.str]] = None,
                          timeouts: Optional[pulumi.Input[Optional[Union['GetKubeconfigTimeoutsArgs', 'GetKubeconfigTimeoutsArgsDict']]]] = None,
                          wait: Optional[pulumi.Input[Optional[builtins.bool]]] = None,
                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetKubeconfigResult]:
    """
    Retrieves the kubeconfig for a Talos cluster


    :param Union['GetKubeconfigClientConfigurationArgs', 'GetKubeconfigClientConfigurationArgsDict'] client_configuration: The client configuration data
    :param builtins.str endpoint: endpoint to use for the talosclient. If not set, the node value will be used
    :param builtins.str node: controlplane node to retrieve the kubeconfig from
    :param builtins.bool wait: Wait for the kubernetes api to be available
    """
    __args__ = dict()
    __args__['clientConfiguration'] = client_configuration
    __args__['endpoint'] = endpoint
    __args__['node'] = node
    __args__['timeouts'] = timeouts
    __args__['wait'] = wait
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('talos:cluster/getKubeconfig:getKubeconfig', __args__, opts=opts, typ=GetKubeconfigResult)
    return __ret__.apply(lambda __response__: GetKubeconfigResult(
        client_configuration=pulumi.get(__response__, 'client_configuration'),
        endpoint=pulumi.get(__response__, 'endpoint'),
        id=pulumi.get(__response__, 'id'),
        kubeconfig_raw=pulumi.get(__response__, 'kubeconfig_raw'),
        kubernetes_client_configuration=pulumi.get(__response__, 'kubernetes_client_configuration'),
        node=pulumi.get(__response__, 'node'),
        timeouts=pulumi.get(__response__, 'timeouts'),
        wait=pulumi.get(__response__, 'wait')))
