# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetDisksResult',
    'AwaitableGetDisksResult',
    'get_disks',
    'get_disks_output',
]

@pulumi.output_type
class GetDisksResult:
    """
    A collection of values returned by getDisks.
    """
    def __init__(__self__, client_configuration=None, disks=None, endpoint=None, id=None, node=None, selector=None, timeouts=None):
        if client_configuration and not isinstance(client_configuration, dict):
            raise TypeError("Expected argument 'client_configuration' to be a dict")
        pulumi.set(__self__, "client_configuration", client_configuration)
        if disks and not isinstance(disks, list):
            raise TypeError("Expected argument 'disks' to be a list")
        pulumi.set(__self__, "disks", disks)
        if endpoint and not isinstance(endpoint, str):
            raise TypeError("Expected argument 'endpoint' to be a str")
        pulumi.set(__self__, "endpoint", endpoint)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if node and not isinstance(node, str):
            raise TypeError("Expected argument 'node' to be a str")
        pulumi.set(__self__, "node", node)
        if selector and not isinstance(selector, str):
            raise TypeError("Expected argument 'selector' to be a str")
        pulumi.set(__self__, "selector", selector)
        if timeouts and not isinstance(timeouts, dict):
            raise TypeError("Expected argument 'timeouts' to be a dict")
        pulumi.set(__self__, "timeouts", timeouts)

    @property
    @pulumi.getter(name="clientConfiguration")
    def client_configuration(self) -> 'outputs.GetDisksClientConfigurationResult':
        """
        The client configuration data
        """
        return pulumi.get(self, "client_configuration")

    @property
    @pulumi.getter
    def disks(self) -> Sequence['outputs.GetDisksDiskResult']:
        """
        The disks that match the filters
        """
        return pulumi.get(self, "disks")

    @property
    @pulumi.getter
    def endpoint(self) -> builtins.str:
        """
        endpoint to use for the talosclient. If not set, the node value will be used
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The generated ID of this resource
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def node(self) -> builtins.str:
        """
        controlplane node to retrieve the kubeconfig from
        """
        return pulumi.get(self, "node")

    @property
    @pulumi.getter
    def selector(self) -> Optional[builtins.str]:
        """
        The CEL expression to filter the disks.
        If not set, all disks will be returned.
        See [CEL documentation](https://www.talos.dev/latest/talos-guides/configuration/disk-management/#disk-selector).
        """
        return pulumi.get(self, "selector")

    @property
    @pulumi.getter
    def timeouts(self) -> Optional['outputs.GetDisksTimeoutsResult']:
        return pulumi.get(self, "timeouts")


class AwaitableGetDisksResult(GetDisksResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDisksResult(
            client_configuration=self.client_configuration,
            disks=self.disks,
            endpoint=self.endpoint,
            id=self.id,
            node=self.node,
            selector=self.selector,
            timeouts=self.timeouts)


def get_disks(client_configuration: Optional[Union['GetDisksClientConfigurationArgs', 'GetDisksClientConfigurationArgsDict']] = None,
              endpoint: Optional[builtins.str] = None,
              node: Optional[builtins.str] = None,
              selector: Optional[builtins.str] = None,
              timeouts: Optional[Union['GetDisksTimeoutsArgs', 'GetDisksTimeoutsArgsDict']] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDisksResult:
    """
    Generate a machine configuration for a node type

    > **Note:** Since Talos natively supports `.machine.install.diskSelector`, the `machine_get_disks` data source maybe just used to query disk information that could be used elsewhere. It's recommended to use `machine.install.diskSelector` in Talos machine configuration.


    :param Union['GetDisksClientConfigurationArgs', 'GetDisksClientConfigurationArgsDict'] client_configuration: The client configuration data
    :param builtins.str endpoint: endpoint to use for the talosclient. If not set, the node value will be used
    :param builtins.str node: controlplane node to retrieve the kubeconfig from
    :param builtins.str selector: The CEL expression to filter the disks.
           If not set, all disks will be returned.
           See [CEL documentation](https://www.talos.dev/latest/talos-guides/configuration/disk-management/#disk-selector).
    """
    __args__ = dict()
    __args__['clientConfiguration'] = client_configuration
    __args__['endpoint'] = endpoint
    __args__['node'] = node
    __args__['selector'] = selector
    __args__['timeouts'] = timeouts
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('talos:machine/getDisks:getDisks', __args__, opts=opts, typ=GetDisksResult).value

    return AwaitableGetDisksResult(
        client_configuration=pulumi.get(__ret__, 'client_configuration'),
        disks=pulumi.get(__ret__, 'disks'),
        endpoint=pulumi.get(__ret__, 'endpoint'),
        id=pulumi.get(__ret__, 'id'),
        node=pulumi.get(__ret__, 'node'),
        selector=pulumi.get(__ret__, 'selector'),
        timeouts=pulumi.get(__ret__, 'timeouts'))
def get_disks_output(client_configuration: Optional[pulumi.Input[Union['GetDisksClientConfigurationArgs', 'GetDisksClientConfigurationArgsDict']]] = None,
                     endpoint: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                     node: Optional[pulumi.Input[builtins.str]] = None,
                     selector: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                     timeouts: Optional[pulumi.Input[Optional[Union['GetDisksTimeoutsArgs', 'GetDisksTimeoutsArgsDict']]]] = None,
                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDisksResult]:
    """
    Generate a machine configuration for a node type

    > **Note:** Since Talos natively supports `.machine.install.diskSelector`, the `machine_get_disks` data source maybe just used to query disk information that could be used elsewhere. It's recommended to use `machine.install.diskSelector` in Talos machine configuration.


    :param Union['GetDisksClientConfigurationArgs', 'GetDisksClientConfigurationArgsDict'] client_configuration: The client configuration data
    :param builtins.str endpoint: endpoint to use for the talosclient. If not set, the node value will be used
    :param builtins.str node: controlplane node to retrieve the kubeconfig from
    :param builtins.str selector: The CEL expression to filter the disks.
           If not set, all disks will be returned.
           See [CEL documentation](https://www.talos.dev/latest/talos-guides/configuration/disk-management/#disk-selector).
    """
    __args__ = dict()
    __args__['clientConfiguration'] = client_configuration
    __args__['endpoint'] = endpoint
    __args__['node'] = node
    __args__['selector'] = selector
    __args__['timeouts'] = timeouts
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('talos:machine/getDisks:getDisks', __args__, opts=opts, typ=GetDisksResult)
    return __ret__.apply(lambda __response__: GetDisksResult(
        client_configuration=pulumi.get(__response__, 'client_configuration'),
        disks=pulumi.get(__response__, 'disks'),
        endpoint=pulumi.get(__response__, 'endpoint'),
        id=pulumi.get(__response__, 'id'),
        node=pulumi.get(__response__, 'node'),
        selector=pulumi.get(__response__, 'selector'),
        timeouts=pulumi.get(__response__, 'timeouts')))
