import { Platform } from "aws-cdk-lib/aws-ecr-assets";
import { ApplicationLoadBalancedFargateService, ApplicationLoadBalancedFargateServiceProps } from "aws-cdk-lib/aws-ecs-patterns";
import { IGrantable, IPrincipal } from "aws-cdk-lib/aws-iam";
import { Construct } from "constructs";
import { BaseNessieCatalog, BaseNessieRepoProps } from "./base-nessie-catalog";
import type { DNSConfiguration } from "../dns-configuration";
import { ILogGroup } from "aws-cdk-lib/aws-logs";
export interface NessieECSCatalogProps extends BaseNessieRepoProps, ApplicationLoadBalancedFargateServiceProps {
    readonly platform?: Platform;
    readonly dns?: DNSConfiguration;
}
export declare class NessieECSCatalog extends BaseNessieCatalog implements IGrantable {
    readonly service: ApplicationLoadBalancedFargateService;
    readonly endpoint: string;
    readonly grantPrincipal: IPrincipal;
    readonly logGroup: ILogGroup;
    constructor(scope: Construct, id: string, props: NessieECSCatalogProps);
}
