"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.combineConfigurations = void 0;
const spark_config_1 = require("./spark-config");
// TODO: if keys like `"spark.jars.packages"` collide, join by , and dedupe
function combineConfigurations(...configs) {
    const mergedConfigurations = configs
        ?.flat()
        .reduce((finalConfig, next) => {
        if (next === undefined) {
            return finalConfig;
        }
        const { classification, configurationProperties, configurations } = next;
        if (!finalConfig[classification]) {
            finalConfig[classification] = {
                classification,
                configurationProperties: {},
                configurations: undefined,
            };
        }
        // @ts-expect-error - slight hack to overwrite the readonly array. JSII requires readonly properties.
        finalConfig[classification].configurations = combineConfigurations(finalConfig[classification].configurations, configurations);
        const csvProperties = new Set([
            "spark.jars.packages",
            "spark.sql.extensions",
        ]);
        for (const [key, value] of Object.entries(configurationProperties)) {
            if (csvProperties.has(key)) {
                const existing = finalConfig[classification]
                    .configurationProperties[key]
                    ? finalConfig[classification].configurationProperties[key].split(",")
                    : [];
                const newValues = value.split(",");
                const merged = [...new Set([...existing, ...newValues])].join(",");
                finalConfig[classification].configurationProperties[key] = merged;
            }
            else if (key == "spark.driver.extraJavaOptions") {
                finalConfig[classification].configurationProperties[key] =
                    (0, spark_config_1.mergeSparkExtraJars)(finalConfig[classification].configurationProperties[key], value);
            }
            else {
                finalConfig[classification].configurationProperties[key] = value;
            }
        }
        return finalConfig;
    }, {}) ?? [];
    const configurations = Object.values(mergedConfigurations);
    if (configurations.length == 0) {
        return undefined;
    }
    return configurations;
}
exports.combineConfigurations = combineConfigurations;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY29uZmlndXJhdGlvbi5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy9lbXIvY29uZmlndXJhdGlvbi50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQSxpREFBcUQ7QUFPckQsMkVBQTJFO0FBQzNFLFNBQWdCLHFCQUFxQixDQUNuQyxHQUFHLE9BQXNFO0lBRXpFLE1BQU0sb0JBQW9CLEdBQ3hCLE9BQU87UUFDTCxFQUFFLElBQUksRUFBRTtTQUNQLE1BQU0sQ0FDTCxDQUNFLFdBQXdELEVBQ3hELElBQStCLEVBQy9CLEVBQUU7UUFDRixJQUFJLElBQUksS0FBSyxTQUFTLEVBQUUsQ0FBQztZQUN2QixPQUFPLFdBQVcsQ0FBQztRQUNyQixDQUFDO1FBQ0QsTUFBTSxFQUFFLGNBQWMsRUFBRSx1QkFBdUIsRUFBRSxjQUFjLEVBQUUsR0FDL0QsSUFBSSxDQUFDO1FBQ1AsSUFBSSxDQUFDLFdBQVcsQ0FBQyxjQUFjLENBQUMsRUFBRSxDQUFDO1lBQ2pDLFdBQVcsQ0FBQyxjQUFjLENBQUMsR0FBRztnQkFDNUIsY0FBYztnQkFDZCx1QkFBdUIsRUFBRSxFQUFFO2dCQUMzQixjQUFjLEVBQUUsU0FBUzthQUMxQixDQUFDO1FBQ0osQ0FBQztRQUVELHFHQUFxRztRQUNyRyxXQUFXLENBQUMsY0FBYyxDQUFDLENBQUMsY0FBYyxHQUFHLHFCQUFxQixDQUNoRSxXQUFXLENBQUMsY0FBYyxDQUFDLENBQUMsY0FBYyxFQUMxQyxjQUFjLENBQ2YsQ0FBQztRQUNGLE1BQU0sYUFBYSxHQUFHLElBQUksR0FBRyxDQUFDO1lBQzVCLHFCQUFxQjtZQUNyQixzQkFBc0I7U0FDdkIsQ0FBQyxDQUFDO1FBQ0gsS0FBSyxNQUFNLENBQUMsR0FBRyxFQUFFLEtBQUssQ0FBQyxJQUFJLE1BQU0sQ0FBQyxPQUFPLENBQUMsdUJBQXVCLENBQUMsRUFBRSxDQUFDO1lBQ25FLElBQUksYUFBYSxDQUFDLEdBQUcsQ0FBQyxHQUFHLENBQUMsRUFBRSxDQUFDO2dCQUMzQixNQUFNLFFBQVEsR0FBRyxXQUFXLENBQUMsY0FBYyxDQUFDO3FCQUN6Qyx1QkFBdUIsQ0FBQyxHQUFHLENBQUM7b0JBQzdCLENBQUMsQ0FBQyxXQUFXLENBQUMsY0FBYyxDQUFDLENBQUMsdUJBQXVCLENBQ2pELEdBQUcsQ0FDSixDQUFDLEtBQUssQ0FBQyxHQUFHLENBQUM7b0JBQ2QsQ0FBQyxDQUFDLEVBQUUsQ0FBQztnQkFDUCxNQUFNLFNBQVMsR0FBRyxLQUFLLENBQUMsS0FBSyxDQUFDLEdBQUcsQ0FBQyxDQUFDO2dCQUNuQyxNQUFNLE1BQU0sR0FBRyxDQUFDLEdBQUcsSUFBSSxHQUFHLENBQUMsQ0FBQyxHQUFHLFFBQVEsRUFBRSxHQUFHLFNBQVMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxJQUFJLENBQzNELEdBQUcsQ0FDSixDQUFDO2dCQUNGLFdBQVcsQ0FBQyxjQUFjLENBQUMsQ0FBQyx1QkFBdUIsQ0FBQyxHQUFHLENBQUMsR0FBRyxNQUFNLENBQUM7WUFDcEUsQ0FBQztpQkFBTSxJQUFJLEdBQUcsSUFBSSwrQkFBK0IsRUFBRSxDQUFDO2dCQUNsRCxXQUFXLENBQUMsY0FBYyxDQUFDLENBQUMsdUJBQXVCLENBQUMsR0FBRyxDQUFDO29CQUN0RCxJQUFBLGtDQUFtQixFQUNqQixXQUFXLENBQUMsY0FBYyxDQUFDLENBQUMsdUJBQXVCLENBQUMsR0FBRyxDQUFDLEVBQ3hELEtBQUssQ0FDTixDQUFDO1lBQ04sQ0FBQztpQkFBTSxDQUFDO2dCQUNOLFdBQVcsQ0FBQyxjQUFjLENBQUMsQ0FBQyx1QkFBdUIsQ0FBQyxHQUFHLENBQUMsR0FBRyxLQUFLLENBQUM7WUFDbkUsQ0FBQztRQUNILENBQUM7UUFFRCxPQUFPLFdBQVcsQ0FBQztJQUNyQixDQUFDLEVBQ0QsRUFBRSxDQUNILElBQUksRUFBRSxDQUFDO0lBQ1osTUFBTSxjQUFjLEdBQUcsTUFBTSxDQUFDLE1BQU0sQ0FBQyxvQkFBb0IsQ0FBQyxDQUFDO0lBQzNELElBQUksY0FBYyxDQUFDLE1BQU0sSUFBSSxDQUFDLEVBQUUsQ0FBQztRQUMvQixPQUFPLFNBQVMsQ0FBQztJQUNuQixDQUFDO0lBQ0QsT0FBTyxjQUFjLENBQUM7QUFDeEIsQ0FBQztBQWxFRCxzREFrRUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBtZXJnZVNwYXJrRXh0cmFKYXJzIH0gZnJvbSBcIi4vc3BhcmstY29uZmlnXCI7XG5cbmV4cG9ydCBpbnRlcmZhY2UgQ29uZmlndXJhdGlvbiB7XG4gIHJlYWRvbmx5IGNsYXNzaWZpY2F0aW9uOiBzdHJpbmc7XG4gIHJlYWRvbmx5IGNvbmZpZ3VyYXRpb25Qcm9wZXJ0aWVzOiBSZWNvcmQ8c3RyaW5nLCBzdHJpbmc+O1xuICByZWFkb25seSBjb25maWd1cmF0aW9ucz86IENvbmZpZ3VyYXRpb25bXTtcbn1cbi8vIFRPRE86IGlmIGtleXMgbGlrZSBgXCJzcGFyay5qYXJzLnBhY2thZ2VzXCJgIGNvbGxpZGUsIGpvaW4gYnkgLCBhbmQgZGVkdXBlXG5leHBvcnQgZnVuY3Rpb24gY29tYmluZUNvbmZpZ3VyYXRpb25zKFxuICAuLi5jb25maWdzOiAoKENvbmZpZ3VyYXRpb24gfCB1bmRlZmluZWQpW10gfCBDb25maWd1cmF0aW9uIHwgdW5kZWZpbmVkKVtdXG4pOiBDb25maWd1cmF0aW9uW10gfCB1bmRlZmluZWQge1xuICBjb25zdCBtZXJnZWRDb25maWd1cmF0aW9ucyA9XG4gICAgY29uZmlnc1xuICAgICAgPy5mbGF0KClcbiAgICAgIC5yZWR1Y2UoXG4gICAgICAgIChcbiAgICAgICAgICBmaW5hbENvbmZpZzogeyBbY2xhc3NpZmljYXRpb246IHN0cmluZ106IENvbmZpZ3VyYXRpb24gfSxcbiAgICAgICAgICBuZXh0OiBDb25maWd1cmF0aW9uIHwgdW5kZWZpbmVkLFxuICAgICAgICApID0+IHtcbiAgICAgICAgICBpZiAobmV4dCA9PT0gdW5kZWZpbmVkKSB7XG4gICAgICAgICAgICByZXR1cm4gZmluYWxDb25maWc7XG4gICAgICAgICAgfVxuICAgICAgICAgIGNvbnN0IHsgY2xhc3NpZmljYXRpb24sIGNvbmZpZ3VyYXRpb25Qcm9wZXJ0aWVzLCBjb25maWd1cmF0aW9ucyB9ID1cbiAgICAgICAgICAgIG5leHQ7XG4gICAgICAgICAgaWYgKCFmaW5hbENvbmZpZ1tjbGFzc2lmaWNhdGlvbl0pIHtcbiAgICAgICAgICAgIGZpbmFsQ29uZmlnW2NsYXNzaWZpY2F0aW9uXSA9IHtcbiAgICAgICAgICAgICAgY2xhc3NpZmljYXRpb24sXG4gICAgICAgICAgICAgIGNvbmZpZ3VyYXRpb25Qcm9wZXJ0aWVzOiB7fSxcbiAgICAgICAgICAgICAgY29uZmlndXJhdGlvbnM6IHVuZGVmaW5lZCxcbiAgICAgICAgICAgIH07XG4gICAgICAgICAgfVxuXG4gICAgICAgICAgLy8gQHRzLWV4cGVjdC1lcnJvciAtIHNsaWdodCBoYWNrIHRvIG92ZXJ3cml0ZSB0aGUgcmVhZG9ubHkgYXJyYXkuIEpTSUkgcmVxdWlyZXMgcmVhZG9ubHkgcHJvcGVydGllcy5cbiAgICAgICAgICBmaW5hbENvbmZpZ1tjbGFzc2lmaWNhdGlvbl0uY29uZmlndXJhdGlvbnMgPSBjb21iaW5lQ29uZmlndXJhdGlvbnMoXG4gICAgICAgICAgICBmaW5hbENvbmZpZ1tjbGFzc2lmaWNhdGlvbl0uY29uZmlndXJhdGlvbnMsXG4gICAgICAgICAgICBjb25maWd1cmF0aW9ucyxcbiAgICAgICAgICApO1xuICAgICAgICAgIGNvbnN0IGNzdlByb3BlcnRpZXMgPSBuZXcgU2V0KFtcbiAgICAgICAgICAgIFwic3BhcmsuamFycy5wYWNrYWdlc1wiLFxuICAgICAgICAgICAgXCJzcGFyay5zcWwuZXh0ZW5zaW9uc1wiLFxuICAgICAgICAgIF0pO1xuICAgICAgICAgIGZvciAoY29uc3QgW2tleSwgdmFsdWVdIG9mIE9iamVjdC5lbnRyaWVzKGNvbmZpZ3VyYXRpb25Qcm9wZXJ0aWVzKSkge1xuICAgICAgICAgICAgaWYgKGNzdlByb3BlcnRpZXMuaGFzKGtleSkpIHtcbiAgICAgICAgICAgICAgY29uc3QgZXhpc3RpbmcgPSBmaW5hbENvbmZpZ1tjbGFzc2lmaWNhdGlvbl1cbiAgICAgICAgICAgICAgICAuY29uZmlndXJhdGlvblByb3BlcnRpZXNba2V5XVxuICAgICAgICAgICAgICAgID8gZmluYWxDb25maWdbY2xhc3NpZmljYXRpb25dLmNvbmZpZ3VyYXRpb25Qcm9wZXJ0aWVzW1xuICAgICAgICAgICAgICAgICAgICBrZXlcbiAgICAgICAgICAgICAgICAgIF0uc3BsaXQoXCIsXCIpXG4gICAgICAgICAgICAgICAgOiBbXTtcbiAgICAgICAgICAgICAgY29uc3QgbmV3VmFsdWVzID0gdmFsdWUuc3BsaXQoXCIsXCIpO1xuICAgICAgICAgICAgICBjb25zdCBtZXJnZWQgPSBbLi4ubmV3IFNldChbLi4uZXhpc3RpbmcsIC4uLm5ld1ZhbHVlc10pXS5qb2luKFxuICAgICAgICAgICAgICAgIFwiLFwiLFxuICAgICAgICAgICAgICApO1xuICAgICAgICAgICAgICBmaW5hbENvbmZpZ1tjbGFzc2lmaWNhdGlvbl0uY29uZmlndXJhdGlvblByb3BlcnRpZXNba2V5XSA9IG1lcmdlZDtcbiAgICAgICAgICAgIH0gZWxzZSBpZiAoa2V5ID09IFwic3BhcmsuZHJpdmVyLmV4dHJhSmF2YU9wdGlvbnNcIikge1xuICAgICAgICAgICAgICBmaW5hbENvbmZpZ1tjbGFzc2lmaWNhdGlvbl0uY29uZmlndXJhdGlvblByb3BlcnRpZXNba2V5XSA9XG4gICAgICAgICAgICAgICAgbWVyZ2VTcGFya0V4dHJhSmFycyhcbiAgICAgICAgICAgICAgICAgIGZpbmFsQ29uZmlnW2NsYXNzaWZpY2F0aW9uXS5jb25maWd1cmF0aW9uUHJvcGVydGllc1trZXldLFxuICAgICAgICAgICAgICAgICAgdmFsdWUsXG4gICAgICAgICAgICAgICAgKTtcbiAgICAgICAgICAgIH0gZWxzZSB7XG4gICAgICAgICAgICAgIGZpbmFsQ29uZmlnW2NsYXNzaWZpY2F0aW9uXS5jb25maWd1cmF0aW9uUHJvcGVydGllc1trZXldID0gdmFsdWU7XG4gICAgICAgICAgICB9XG4gICAgICAgICAgfVxuXG4gICAgICAgICAgcmV0dXJuIGZpbmFsQ29uZmlnO1xuICAgICAgICB9LFxuICAgICAgICB7fSxcbiAgICAgICkgPz8gW107XG4gIGNvbnN0IGNvbmZpZ3VyYXRpb25zID0gT2JqZWN0LnZhbHVlcyhtZXJnZWRDb25maWd1cmF0aW9ucyk7XG4gIGlmIChjb25maWd1cmF0aW9ucy5sZW5ndGggPT0gMCkge1xuICAgIHJldHVybiB1bmRlZmluZWQ7XG4gIH1cbiAgcmV0dXJuIGNvbmZpZ3VyYXRpb25zO1xufVxuIl19