"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FleetCluster = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cluster_1 = require("./cluster");
const managed_scaling_1 = require("./managed-scaling");
/**
 * An EMR Cluster that is comprised of {@link InstanceFleet}s.
 *
 * @see https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-instance-fleet.html
 * @see https://docs.aws.amazon.com/emr/latest/ManagementGuide/on-demand-capacity-reservations.html
 */
class FleetCluster extends cluster_1.Cluster {
    constructor(scope, id, props) {
        if (props.managedScalingPolicy) {
            if (props.managedScalingPolicy.computeLimits.unitType !==
                managed_scaling_1.ComputeUnit.INSTANCE_FLEET_UNITS) {
                throw new Error(`If you are using a FleetCluster, you must use INSTANCE_FLEET_UNITS as the ComputeLimitsUnitType`);
            }
        }
        super(scope, id, props);
    }
}
exports.FleetCluster = FleetCluster;
_a = JSII_RTTI_SYMBOL_1;
FleetCluster[_a] = { fqn: "@packyak/aws-cdk.FleetCluster", version: "0.4.20" };
//# sourceMappingURL=data:application/json;base64,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