"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.IcebergGlueCatalog = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const aws_s3_1 = require("aws-cdk-lib/aws-s3");
const constructs_1 = require("constructs");
const spark_sql_extension_1 = require("./spark-sql-extension");
class IcebergGlueCatalog extends constructs_1.Construct {
    static fromBucketName(scope, id, props) {
        return new IcebergGlueCatalog(scope, id, {
            warehouseBucket: aws_s3_1.Bucket.fromBucketName(scope, `${id}WarehouseBucket`, props.warehouseBucketName),
            warehousePrefix: props.warehousePrefix,
        });
    }
    constructor(scope, id, props) {
        super(scope, id);
        this.warehouseBucket =
            props.warehouseBucket ?? new aws_s3_1.Bucket(this, "WarehouseBucket");
        this.warehousePrefix = props.warehousePrefix;
    }
    bind(cluster, catalogName) {
        // TODO: should we limit this to the warehouse prefix
        this.warehouseBucket.grantReadWrite(cluster, "*");
        const { partition, region, account } = aws_cdk_lib_1.Stack.of(cluster);
        cluster.grantPrincipal.addToPrincipalPolicy(new aws_iam_1.PolicyStatement({
            actions: ["glue:GetDatabase"],
            resources: [`arn:${partition}:glue:${region}:${account}:catalog`],
        }));
        const sparkVersion = cluster.release.sparkVersion;
        const scalaVersion = cluster.release.scalaVersion;
        const icebergExt = spark_sql_extension_1.SparkSqlExtension.Iceberg.maven(sparkVersion, scalaVersion);
        const catalogNamespace = `spark.sql.catalog.${catalogName}`;
        cluster.addConfig({
            classification: "spark-hive-site",
            configurationProperties: {
                "hive.metastore.client.factory.class": "com.amazonaws.glue.catalog.metastore.AWSGlueDataCatalogHiveClientFactory",
            },
        }, {
            classification: "spark-defaults",
            configurationProperties: {
                "spark.jars.packages": icebergExt,
                "spark.sql.extensions": spark_sql_extension_1.SparkSqlExtension.Iceberg.className,
                // "spark.sql.catalogImplementation": "hive",
                [catalogNamespace]: "org.apache.iceberg.spark.SparkCatalog",
                [`${catalogNamespace}.warehouse`]: `s3://${this.warehouseBucket.bucketName}${this.warehousePrefix
                    ? `/${this.warehousePrefix.replace(/^[\/]*/g, "")}`
                    : ""}`,
                [`${catalogNamespace}.catalog-impl`]: "org.apache.iceberg.aws.glue.GlueCatalog",
                [`${catalogNamespace}.io-impl`]: "org.apache.iceberg.aws.s3.S3FileIO",
            },
        });
    }
}
exports.IcebergGlueCatalog = IcebergGlueCatalog;
_a = JSII_RTTI_SYMBOL_1;
IcebergGlueCatalog[_a] = { fqn: "@packyak/aws-cdk.IcebergGlueCatalog", version: "0.4.20" };
//# sourceMappingURL=data:application/json;base64,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