"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TimeoutAction = exports.AllocationStrategy = void 0;
/**
 *
 * @see https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-instance-fleet.html#emr-instance-fleet-allocation-strategy
 * @see https://docs.aws.amazon.com/emr/latest/ManagementGuide/managed-scaling-allocation-strategy.html
 */
var AllocationStrategy;
(function (AllocationStrategy) {
    AllocationStrategy["CAPACITY_OPTIMIZED"] = "capacity-optimized";
    AllocationStrategy["PRICE_CAPACITY_OPTIMIZED"] = "price-capacity-optimized";
    AllocationStrategy["DIVERSIFIED"] = "diversified";
    AllocationStrategy["LOWEST_PRICE"] = "lowest-price";
})(AllocationStrategy || (exports.AllocationStrategy = AllocationStrategy = {}));
/**
 * Action to take when provisioning a Cluster and Spot Instances are not available.
 *
 * @see https://docs.aws.amazon.com/emr/latest/APIReference/API_SpotProvisioningSpecification.html
 */
var TimeoutAction;
(function (TimeoutAction) {
    /**
     * Specifies that if no Spot Instances are available, On-Demand Instances
     * should be provisioned to fulfill any remaining Spot capacity.
     */
    TimeoutAction["SWITCH_TO_ON_DEMAND"] = "SWITCH_TO_ON_DEMAND";
    /**
     * Terminates the Cluster if Spot Instances are not available.
     */
    TimeoutAction["TERMINATE_CLUSTER"] = "TERMINATE_CLUSTER";
})(TimeoutAction || (exports.TimeoutAction = TimeoutAction = {}));
//# sourceMappingURL=data:application/json;base64,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