import { IConnectable } from "aws-cdk-lib/aws-ec2";
import type { Cluster } from "./cluster";
/**
 * https://mr3docs.datamonad.com/docs/k8s/advanced/transport/
 */
export declare enum TransportMode {
    BINARY = "binary",
    HTTP = "http",
    ALL = "all"
}
export interface JdbcProps {
    /**
     * @see https://spark.apache.org/docs/latest/sql-distributed-sql-engine.html
     */
    readonly port: number;
    /**
     * Include tje .ivy2/jars directory so that the server will pick up extra extensions
     *
     * @default true
     */
    readonly includeExtensions?: boolean;
    /**
     * @default
     */
    readonly hiveConf?: Record<string, string>;
    readonly sparkConf?: Record<string, string>;
    readonly extraJavaOptions?: Record<string, string>;
}
/**
 * Configures an EMR Cluster to start a Thrift Server daemon.
 */
export declare class Jdbc {
    private readonly cluster;
    private readonly options;
    constructor(cluster: Cluster, options: JdbcProps);
    allowFrom(...connectables: IConnectable[]): void;
}
