"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Jdbc = exports.TransportMode = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_ec2_1 = require("aws-cdk-lib/aws-ec2");
const spark_config_1 = require("./spark-config");
/**
 * https://mr3docs.datamonad.com/docs/k8s/advanced/transport/
 */
var TransportMode;
(function (TransportMode) {
    TransportMode["BINARY"] = "binary";
    TransportMode["HTTP"] = "http";
    TransportMode["ALL"] = "all";
})(TransportMode || (exports.TransportMode = TransportMode = {}));
/**
 * Configures an EMR Cluster to start a Thrift Server daemon.
 */
class Jdbc {
    constructor(cluster, options) {
        this.cluster = cluster;
        this.options = options;
        const hiveConf = options.hiveConf ?? {};
        if (
        // If the user has not explicitly disabled the inclusion of the .ivy2/jars directory
        options.includeExtensions !== false &&
            hiveConf["hive.aux.jars.path"] === undefined) {
            // TODO: ideally not the /root/ user...
            hiveConf["hive.aux.jars.path"] = "/root/.ivy2/jars/";
        }
        hiveConf["hive.server2.thrift.port"] = options.port.toString(10);
        const sparkConf = options.sparkConf ?? {};
        const extraJavaOptions = (0, spark_config_1.mergeSparkExtraJars)(cluster.extraJavaOptions, sparkConf["spark.driver.extraJavaOptions"], options.extraJavaOptions);
        if (extraJavaOptions) {
            sparkConf["spark.driver.extraJavaOptions"] = `'${extraJavaOptions}'`;
        }
        this.cluster.addStep({
            name: "StartThriftServer",
            hadoopJarStep: {
                jar: "command-runner.jar",
                args: [
                    "bash",
                    "-c",
                    [
                        // FIXME: this probably shouldn't be root but we need to set up a proper user
                        //        to make that the case since the default hadoop user doesn't have permission
                        //        to write to the log directory.
                        "sudo",
                        "/lib/spark/sbin/start-thriftserver.sh",
                        ...(Object.keys(hiveConf).length > 0
                            ? ["--hiveconf", (0, spark_config_1.toCLIArgs)(hiveConf)]
                            : []),
                        ...(Object.keys(sparkConf).length > 0
                            ? ["--conf", (0, spark_config_1.toCLIArgs)(sparkConf)]
                            : []),
                    ].join(" "),
                ],
            },
            actionOnFailure: "CANCEL_AND_WAIT",
        });
    }
    allowFrom(...connectables) {
        for (const connectable of connectables) {
            this.cluster.connections.allowFrom(connectable, aws_ec2_1.Port.tcp(this.options.port));
        }
    }
}
exports.Jdbc = Jdbc;
_a = JSII_RTTI_SYMBOL_1;
Jdbc[_a] = { fqn: "@packyak/aws-cdk.Jdbc", version: "0.4.20" };
//# sourceMappingURL=data:application/json;base64,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