"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AdjustmentType = exports.ScaleDownBehavior = exports.ComputeUnit = void 0;
var ComputeUnit;
(function (ComputeUnit) {
    ComputeUnit["INSTANCES"] = "Instances";
    ComputeUnit["INSTANCE_FLEET_UNITS"] = "InstanceFleetUnits";
    ComputeUnit["VCPU"] = "VCPU";
})(ComputeUnit || (exports.ComputeUnit = ComputeUnit = {}));
var ScaleDownBehavior;
(function (ScaleDownBehavior) {
    ScaleDownBehavior["TERMINATE_AT_INSTANCE_HOUR"] = "TERMINATE_AT_INSTANCE_HOUR";
    ScaleDownBehavior["TERMINATE_AT_TASK_COMPLETION"] = "TERMINATE_AT_TASK_COMPLETION";
})(ScaleDownBehavior || (exports.ScaleDownBehavior = ScaleDownBehavior = {}));
var AdjustmentType;
(function (AdjustmentType) {
    /**
     * The number of Amazon EC2 instances to add or remove each time the scaling activity is triggered.
     */
    AdjustmentType["CHANGE_IN_CAPACITY"] = "CHANGE_IN_CAPACITY";
    /**
     * The percentage of the current instance group size to add or remove each time the scaling activity is triggered.
     */
    AdjustmentType["PERCENT_CHANGE_IN_CAPACITY"] = "PERCENT_CHANGE_IN_CAPACITY";
    /**
     * The exact number of Amazon EC2 instances to add or remove each time the scaling activity is triggered.
     */
    AdjustmentType["EXACT_CAPACITY"] = "EXACT_CAPACITY";
})(AdjustmentType || (exports.AdjustmentType = AdjustmentType = {}));
//# sourceMappingURL=data:application/json;base64,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